<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @since     Arquivo disponvel desde a verso 1.0.0
 * @version   $Id$
 */

/*
 * Verifica se o PHP instalado  maior ou igual a 5.2.0
 */
if (! version_compare('5.2.0', PHP_VERSION, '<=')) {
  die('O i-Educar requer o PHP na verso 5.2. A verso instalada de seu PHP (' . PHP_VERSION . ') no  suportada.');
}

/**
 * Alias para DIRECTORY_SEPARATOR
 */
define('DS', DIRECTORY_SEPARATOR);

/**
 * Diretrio raiz do projeto.
 */
$root = realpath(dirname(__FILE__) . '/../');
define('PROJECT_ROOT', $root);

/**
 * Diretrio raiz da aplicao (intranet/).
 */
define('APP_ROOT', $root . DS . 'intranet');

/*
 * Altera o include_path, adicionando o caminho a CoreExt, tornando mais
 * simples o uso de require e include para as novas classes.
 */
$paths = array();
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'intranet'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'lib'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, 'modules'));
$paths[] = join(DIRECTORY_SEPARATOR, array($root, '.'));

// Configura o include_path.
set_include_path(join(PATH_SEPARATOR, $paths) . PATH_SEPARATOR . get_include_path());

/*
 * Define o ambiente de configurao desejado. Verifica se existe uma varivel
 * de ambiente configurada ou define 'production' como padro.
 */
if (getenv('CORE_EXT_CONFIGURATION_ENV')) {
  define('CORE_EXT_CONFIGURATION_ENV', getenv('CORE_EXT_CONFIGURATION_ENV'));
}
else {
  define('CORE_EXT_CONFIGURATION_ENV', 'production');
}

// por padro busca uma configurao para o ambiente atual definido em CORE_EXT_CONFIGURATION_ENV
$configFile = realpath(dirname(__FILE__) . '/../') . '/configuration/' . CORE_EXT_CONFIGURATION_ENV . '.ini';

// caso no exista o ini para o ambiente atual, usa o arquivo padro ieducar.ini
if (! file_exists($configFile))
  $configFile = realpath(dirname(__FILE__) . '/../') . '/configuration/ieducar.ini';

// Classe de configurao
require_once 'CoreExt/Config.class.php';
require_once 'CoreExt/Config/Ini.class.php';
require_once 'CoreExt/Locale.php';

// Array global de objetos de classes do pacote CoreExt
global $coreExt;
$coreExt = array();

// Localizao para pt_BR
$locale = CoreExt_Locale::getInstance();
$locale->setCulture('pt_BR')->setLocale();

// Instancia objeto CoreExt_Configuration
$coreExt['Config'] = new CoreExt_Config_Ini($configFile, CORE_EXT_CONFIGURATION_ENV);
$coreExt['Locale'] = $locale;

// Timezone
date_default_timezone_set($coreExt['Config']->app->locale->timezone);

$tenantEnv = $_SERVER['HTTP_HOST'];

// tenta carregar as configuraes da seo especifica do tenant,
// ex: ao acessar http://tenant.ieducar.com.br ser carregado a seo tenant.ieducar.com.br caso exista
if ($coreExt['Config']->hasEnviromentSection($tenantEnv))
  $coreExt['Config']->changeEnviroment($tenantEnv);

/**
 * Altera o diretrio da aplicao. chamadas a fopen() na aplicao no
 * verificam em que diretrio est, assumindo sempre uma requisio a
 * intranet/.
 */
chdir($root . DS . 'intranet');
unset($root, $paths);
