<?php

/*
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 */

/**
 * Faz stream de arquivo para o buffer do navegador.
 *
 * @author   Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @license  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt  CC GNU GPL
 * @package  Core
 * @since    Arquivo disponvel desde a verso 1.1.0
 * @version  $Id$
 */

require_once 'Utils/Mimetype.class.php';
require_once 'Utils/FileStream.class.php';

// Pega o nome do arquivo (caminho completo)
$filename = isset($_GET['filename']) ? $_GET['filename'] : NULL;

// Diretrios pblicos (permitidos) para stream de arquivo.
$defaultDirectories = array('tmp', 'pdf');

// Classe Mimetype
$mimetype = new Mimetype();

// Classe FileStream
$fileStream = new FileStream($mimetype, $defaultDirectories);

try {
  $fileStream->setFilepath($filename);
}
catch (Exception $e) {
  print $e->getMessage();
  exit();
}

try {
  $fileStream->streamFile();
}
catch (Exception $e) {
  print $e->getMessage();
  exit();
}

unlink($filename);