<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd
 * @since     Arquivo disponvel desde a verso 1.0.0
 * @version   $Id$
 */

require_once 'include/constants.inc.php';

/**
 * clsConfig class.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class clsConfig
{

  /**
   * Tempo em segundos para relatar uma query SQL.
   */
  const CLS_CONFIG_SQL_TEMPO    = 3;

  /**
   * Tempo em segundos para relatar um carregamento de pgina.
   */
  const CLS_CONFIG_PAGINA_TEMPO = 5;

  /**
   * Array com os parmetros de configurao
   */
  public $arrayConfig = array();

  /**
   * Switch para habilitar depurao.
   * @var  int
   */
  public $depurar = 0;


  /**
   * Construtor.
   *
   * Atribui os valores padres das diretivas de configurao.
   */
  public function __construct() {
    $this->setArrayConfig();
  }

  /**
   * Configura o array $arrayConfig com as diretivas passadas pelo ieducar.ini.
   */
  private function setArrayConfig()
  {
    global $coreExt;
    $config = $coreExt['Config'];

    $config = $coreExt['Config']->app;

    // Nome da instituio
    $this->_instituicao = $config->template->vars->instituicao . ' - ';

    // E-mails dos administradores para envio de relatrios de performance
    $emails = $config->admin->reports->emails->toArray();
    $this->arrayConfig['ArrStrEmailsAdministradores'] = $emails;

    // Diretrio dos templates de e-mail
    $this->arrayConfig['strDirTemplates'] = "templates/";

    // Quantidade de segundos para relatar uma query SQL
    $segundosSQL = $config->get($config->admin->reports->sql_tempo,
      self::CLS_CONFIG_SQL_TEMPO);
    $segundosSQL = $segundosSQL > 0 ?
      $segundosSQL : self::CLS_CONFIG_SQL_TEMPO;

    $this->arrayConfig['intSegundosQuerySQL'] = $segundosSQL;

    // Quantidade de segundos para relatar o tempo de carregamento de pgina
    $segundosPagina = $config->get($config->admin->reports->pagina_tempo,
      self::CLS_CONFIG_PAGINA_TEMPO);
    $segundosPagina = $segundosPagina > 0 ?
      $segundosPagina : self::CLS_CONFIG_PAGINA_TEMPO;

    $this->arrayConfig['intSegundosProcessaPagina'] = $segundosPagina;
  }


  /**
   * Reliza um var_dump da varivel passada.
   * @see  http://php.net/var_dump
   * @param  mixed  $msg
   */
  protected function Depurar($msg)
  {
    if ($this->depurar)
    {
      if ($this->depurar == 1)
        echo "\n\n<!--";

      echo "<pre>";

      if (is_array($msg))
        var_dump($msg);
      else
        echo $msg;

      echo "</pre>";

      if ($this->depurar == 1)
        echo "-->\n\n";
    }
  }
}