<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*																	     *
	*	@author Prefeitura Municipal de Itaja								 *
	*	@updated 29/03/2007													 *
	*   Pacote: i-PLB Software Pblico Livre e Brasileiro					 *
	*																		 *
	*	Copyright (C) 2006	PMI - Prefeitura Municipal de Itaja			 *
	*						ctima@itajai.sc.gov.br					    	 *
	*																		 *
	*	Este  programa    software livre, voc pode redistribu-lo e/ou	 *
	*	modific-lo sob os termos da Licena Pblica Geral GNU, conforme	 *
	*	publicada pela Free  Software  Foundation,  tanto  a verso 2 da	 *
	*	Licena   como  (a  seu  critrio)  qualquer  verso  mais  nova.	 *
	*																		 *
	*	Este programa   distribudo na expectativa de ser til, mas SEM	 *
	*	QUALQUER GARANTIA. Sem mesmo a garantia implcita de COMERCIALI-	 *
	*	ZAO  ou  de ADEQUAO A QUALQUER PROPSITO EM PARTICULAR. Con-	 *
	*	sulte  a  Licena  Pblica  Geral  GNU para obter mais detalhes.	 *
	*																		 *
	*	Voc  deve  ter  recebido uma cpia da Licena Pblica Geral GNU	 *
	*	junto  com  este  programa. Se no, escreva para a Free Software	 *
	*	Foundation,  Inc.,  59  Temple  Place,  Suite  330,  Boston,  MA	 *
	*	02111-1307, USA.													 *
	*																		 *
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
	// script executado na cronTab as 07:00 e as 13:00 hs
	chdir( "/home/pagina/public_html/intranet/" );
	require_once( "include/clsBanco.inc.php" );
	require_once( "include/clsEmail.inc.php" );
	require_once( "include/clsAgenda.inc.php" );
	require_once( "include/Geral.inc.php" );
	
	// Configuracoes
	$verbose = true;
	
	$data = date( "d/m/Y", time() );
	$data_db = date( "Y-m-d", time() );
	$enviados = 0;
	$db = new clsBanco();
	$db2 = new clsBanco();
	$db->Consulta( "SELECT cod_agenda, ref_ref_cod_pessoa_own FROM agenda" );
	while ( $db->ProximoRegistro() ) 
	{
		list( $cod_agenda, $cod_pessoa ) = $db->Tupla();
		$conteudo = "";
		$objAgenda = new clsAgenda( 0, false, $cod_agenda );
		
		if( $cod_pessoa )
		{
			$objPessoa = new clsPessoaFisica();
			list( $email ) = $objPessoa->queryRapida( $cod_pessoa, "email" );
			
			if( date( "H", time() ) < 8 )
			{
				// compromissos da manha
				$compromissos = $objAgenda->listaCompromissos( "$data_db 00:00", "$data_db 13:00" );
				$periodo = "Manh";
			}
			else 
			{
				// compromissos da tarde
				$compromissos = $objAgenda->listaCompromissos( "$data_db 13:00", "$data_db 23:59" );
				$periodo = "Tarde";
			}
			
			$conteudo = "Compromissos do dia $data, no periodo da $periodo.<br><br>\n\n";
			
			if( $email && is_array( $compromissos ) && count( $compromissos ) )
			{
				$qtd_tit_copia_desc = 5;
				$assunto = "[PMI AGENDA] - Compromissos da agenda " . $objAgenda->getNome();
			
				foreach ( $compromissos AS $compromisso )
				{
					// preenche o conteudo com os compromissos
					$data_inicio = $compromisso["data_inicio"];
					$cod_agenda_compromisso = $compromisso["cod_agenda_compromisso"];
					$data_fim = $compromisso["data_fim"];
					$titulo = $compromisso["titulo"];
					$descricao = $compromisso["descricao"];
					
					$hora_inicio = date( "H:i", strtotime( $data_inicio ) );
					$hora_fim = date( "H:i", strtotime( $data_fim ) );
					if( $titulo )
					{
						$disp_titulo = $titulo;
					}
					else 
					{
						// se nao tiver titulo pega as X primeiras palavras da descricao ( X = $qtd_tit_copia_desc )
						$disp_titulo = implode( " ", array_slice( explode( " ", $descricao ), 0, $qtd_tit_copia_desc ) );
					}
					$disp_titulo = "{$hora_inicio} - {$disp_titulo} - {$hora_fim}";
					
					$conteudo .= "<b>$disp_titulo</b><br>\n$descricao<br><br>\n\n";
				}
				$objEmail = new clsEmail( $email, $assunto, $conteudo );
				$objEmail->envia();
				
				$enviados++;
				if( $verbose )
				{
					echo "-";
					if( ! ( $enviados % 50 ) ) echo "| ( $enviados )\n";
				}
			}
		}
	}
	if( $enviados )
	{
		echo "\nCron.Agenda - $enviados e-mails enviados.\n";
	}
?>