<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*																	     *
	*	@author Prefeitura Municipal de Itaja								 *
	*	@updated 29/03/2007													 *
	*   Pacote: i-PLB Software Pblico Livre e Brasileiro					 *
	*																		 *
	*	Copyright (C) 2006	PMI - Prefeitura Municipal de Itaja			 *
	*						ctima@itajai.sc.gov.br					    	 *
	*																		 *
	*	Este  programa    software livre, voc pode redistribu-lo e/ou	 *
	*	modific-lo sob os termos da Licena Pblica Geral GNU, conforme	 *
	*	publicada pela Free  Software  Foundation,  tanto  a verso 2 da	 *
	*	Licena   como  (a  seu  critrio)  qualquer  verso  mais  nova.	 *
	*																		 *
	*	Este programa   distribudo na expectativa de ser til, mas SEM	 *
	*	QUALQUER GARANTIA. Sem mesmo a garantia implcita de COMERCIALI-	 *
	*	ZAO  ou  de ADEQUAO A QUALQUER PROPSITO EM PARTICULAR. Con-	 *
	*	sulte  a  Licena  Pblica  Geral  GNU para obter mais detalhes.	 *
	*																		 *
	*	Voc  deve  ter  recebido uma cpia da Licena Pblica Geral GNU	 *
	*	junto  com  este  programa. Se no, escreva para a Free Software	 *
	*	Foundation,  Inc.,  59  Temple  Place,  Suite  330,  Boston,  MA	 *
	*	02111-1307, USA.													 *
	*																		 *
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
require_once ("include/clsBase.inc.php");
require_once ("include/clsListagem.inc.php");
require_once ("include/clsBanco.inc.php");
require_once( "include/pmieducar/geral.inc.php" );

class clsIndexBase extends clsBase
{
	function Formular()
	{
		$this->SetTitulo( "{$this->_instituicao} i-Educar - Benef&iacute;cio Aluno" );
		$this->processoAp = "581";
		$this->addEstilo("localizacaoSistema");
	}
}

class indice extends clsListagem
{
	/**
	 * Referencia pega da session para o idpes do usuario atual
	 *
	 * @var int
	 */
	var $pessoa_logada;

	/**
	 * Titulo no topo da pagina
	 *
	 * @var int
	 */
	var $titulo;

	/**
	 * Quantidade de registros a ser apresentada em cada pagina
	 *
	 * @var int
	 */
	var $limite;

	/**
	 * Inicio dos registros a serem exibidos (limit)
	 *
	 * @var int
	 */
	var $offset;

	var $cod_aluno_beneficio;
	var $ref_usuario_exc;
	var $ref_usuario_cad;
	var $nm_beneficio;
	var $desc_beneficio;
	var $data_cadastro;
	var $data_exclusao;
	var $ativo;

	function Gerar()
	{
		@session_start();
		$this->pessoa_logada = $_SESSION['id_pessoa'];
		session_write_close();

		$this->titulo = "Benef&iacute;cio Aluno - Listagem";

		foreach( $_GET AS $var => $val ) // passa todos os valores obtidos no GET para atributos do objeto
			$this->$var = ( $val === "" ) ? null: $val;

		

		$this->addCabecalhos( array(
			"Beneficio"
		) );

		// Filtros de Foreign Keys

		 	//$obrigatorio = true;
			//include("include/pmieducar/educar_pesquisa_instituicao_escola.php");

		// outros Filtros
		$this->campoTexto( "nm_beneficio", "Benef&iacute;cio", $this->nm_beneficio, 30, 255, false );


		// Paginador
		$this->limite = 20;
		$this->offset = ( $_GET["pagina_{$this->nome}"] ) ? $_GET["pagina_{$this->nome}"]*$this->limite-$this->limite: 0;

		$obj_aluno_beneficio = new clsPmieducarAlunoBeneficio();
		$obj_aluno_beneficio->setOrderby( "nm_beneficio ASC" );
		$obj_aluno_beneficio->setLimite( $this->limite, $this->offset );

		$lista = $obj_aluno_beneficio->lista(
			null,
			null,
			null,
			$this->nm_beneficio,
			null,
			null,
			null,
			1
		);

		$total = $obj_aluno_beneficio->_total;

		// monta a lista
		if( is_array( $lista ) && count( $lista ) )
		{
			foreach ( $lista AS $registro )
			{

				$this->addLinhas( array(
					"<a href=\"educar_aluno_beneficio_det.php?cod_aluno_beneficio={$registro["cod_aluno_beneficio"]}\">{$registro["nm_beneficio"]}</a>"
				) );
			}
		}
		$this->addPaginador2( "educar_aluno_beneficio_lst.php", $total, $_GET, $this->nome, $this->limite );


		//** Verificacao de permissao para cadastro
		$obj_permissao = new clsPermissoes();

		if($obj_permissao->permissao_cadastra(581, $this->pessoa_logada,3))
		{
			$this->acao = "go(\"educar_aluno_beneficio_cad.php\")";
			$this->nome_acao = "Novo";
		}
		//**

		$this->largura = "100%";

		$localizacao = new LocalizacaoSistema();
	    $localizacao->entradaCaminhos( array(
	         $_SERVER['SERVER_NAME']."/intranet" => "In&iacute;cio",
	         "educar_index.php"                  => "i-Educar - Escola",
	         ""                                  => "Listagem de benef&iacute;cios de alunos"
	    ));
	    $this->enviaLocalizacao($localizacao->montar());
	}
}
// cria uma extensao da classe base
$pagina = new clsIndexBase();
// cria o conteudo
$miolo = new indice();
// adiciona o conteudo na clsBase
$pagina->addForm( $miolo );
// gera o html
$pagina->MakeAll();
?>