<?php
/**
 *
 * @version SVN: $Id$
 * @author  Prefeitura Municipal de Itaja
 * @updated 29/03/2007
 * Pacote: i-PLB Software Pblico Livre e Brasileiro
 *
 * Copyright (C) 2006	PMI - Prefeitura Municipal de Itaja
 *					ctima@itajai.sc.gov.br
 *
 * Este  programa    software livre, voc pode redistribu-lo e/ou
 * modific-lo sob os termos da Licena Pblica Geral GNU, conforme
 * publicada pela Free  Software  Foundation,  tanto  a verso 2 da
 * Licena   como  (a  seu  critrio)  qualquer  verso  mais  nova.
 *
 * Este programa   distribudo na expectativa de ser til, mas SEM
 * QUALQUER GARANTIA. Sem mesmo a garantia implcita de COMERCIALI-
 * ZAO  ou  de ADEQUAO A QUALQUER PROPSITO EM PARTICULAR. Con-
 * sulte  a  Licena  Pblica  Geral  GNU para obter mais detalhes.
 *
 * Voc  deve  ter  recebido uma cpia da Licena Pblica Geral GNU
 * junto  com  este  programa. Se no, escreva para a Free Software
 * Foundation,  Inc.,  59  Temple  Place,  Suite  330,  Boston,  MA
 * 02111-1307, USA.
 *
 */

header('Content-type: text/xml; charset=iso-8859-1');

require_once('include/clsBanco.inc.php');
require_once('include/funcoes.inc.php');

require_once 'Portabilis/Utils/DeprecatedXmlApi.php';
Portabilis_Utils_DeprecatedXmlApi::returnEmptyQueryUnlessUserIsLoggedIn();

print '<?xml version="1.0" encoding="iso-8859-1"?>' . PHP_EOL;
print '<query xmlns="sugestoes">' . PHP_EOL;

if (is_numeric($_GET['bib'])) {
  $db = new clsBanco();

  if (is_numeric($_GET['exemplar_tipo_id']))
    $filtroTipoExemplar = "ref_cod_exemplar_tipo = {$_GET['exemplar_tipo_id']} AND";
  else
    $filtroTipoExemplar = '';

  $sql = "
    SELECT
      DISTINCT(cod_cliente_tipo),
      nm_tipo,
      dias_emprestimo
    FROM
      pmieducar.cliente_tipo LEFT JOIN pmieducar.cliente_tipo_exemplar_tipo ON (cod_cliente_tipo = ref_cod_cliente_tipo)
    WHERE
      ref_cod_biblioteca = %s AND
      %s
      ativo = 1
    ORDER BY
      nm_tipo ASC";

  $sql = sprintf($sql, $_GET['bib'], $filtroTipoExemplar);
  $db->Consulta($sql);

  // Array com os cdigos do resultado do SELECT
  $codigos = array();

  while ($db->ProximoRegistro())
  {
    list($cod, $nome, $dias_emprestimo) = $db->Tupla();

    // Evita trazer dias emprestimo de outros cadastros, no cadastro novo tipo de exemplar
    if (! is_numeric($_GET['exemplar_tipo_id']))
      $dias_emprestimo = '';

    // Se o cdigo j foi utilizado, vai para o prximo resultado
    if (isset($codigos[$cod]))
      continue;

    $cliente_tag = '<cliente_tipo cod_cliente_tipo="%s" dias_emprestimo="%s">%s</cliente_tipo>';
    print sprintf($cliente_tag, $cod, $dias_emprestimo, $nome) . PHP_EOL;

    // Evita que se imprima o mesmo cdigo novamente
    $codigos[$cod] = TRUE;
  }
}

print '</query>';
