<?php
/**
 *
 *	@author Prefeitura Municipal de Itaja
 *	@updated 29/03/2007
 *   Pacote: i-PLB Software Pblico Livre e Brasileiro
 *
 *	Copyright (C) 2006	PMI - Prefeitura Municipal de Itaja
 *						ctima@itajai.sc.gov.br
 *
 *	Este  programa    software livre, voc pode redistribu-lo e/ou
 *	modific-lo sob os termos da Licena Pblica Geral GNU, conforme
 *	publicada pela Free  Software  Foundation,  tanto  a verso 2 da
 *	Licena   como  (a  seu  critrio)  qualquer  verso  mais  nova.
 *
 *	Este programa   distribudo na expectativa de ser til, mas SEM
 *	QUALQUER GARANTIA. Sem mesmo a garantia implcita de COMERCIALI-
 *	ZAO  ou  de ADEQUAO A QUALQUER PROPSITO EM PARTICULAR. Con-
 *	sulte  a  Licena  Pblica  Geral  GNU para obter mais detalhes.
 *
 *	Voc  deve  ter  recebido uma cpia da Licena Pblica Geral GNU
 *	junto  com  este  programa. Se no, escreva para a Free Software
 *	Foundation,  Inc.,  59  Temple  Place,  Suite  330,  Boston,  MA
 *	02111-1307, USA.
 *
 */
 
/**
 * @author Adriano Erik Weiguert Nagasava
 */
require_once ("include/clsBase.inc.php");
require_once ("include/clsCadastro.inc.php");
require_once ("include/clsBanco.inc.php");
require_once( "include/pmieducar/geral.inc.php" );

class clsIndexBase extends clsBase
{
	function Formular()
	{
		$this->SetTitulo( "{$this->_instituicao} i-Educar - Cliente" );
		$this->processoAp = "603";
	}
}

class indice extends clsCadastro
{
	/**
	 * Referencia pega da session para o idpes do usuario atual
	 *
	 * @var int
	 */
	var $pessoa_logada;

	var $cod_cliente;
	var $ref_cod_instituicao;
	var $ref_cod_escola;
	var $ref_cod_biblioteca;
	var $ref_cod_cliente_tipo;
	var $ref_usuario_exc;
	var $ref_usuario_cad;
	var $ref_idpes;
	var $login;
	var $senha;
	var $data_cadastro;
	var $data_exclusao;
	var $ativo;
	var $del_cod_cliente;
	var $del_cod_cliente_tipo;
	var $acao_status;
	var $cod_motivo_suspensao;
	var $descricao;
	var $dias;
	var $sequencial;
	
	function Inicializar()
	{
		$retorno = "Novo";
		@session_start();
		$this->pessoa_logada = $_SESSION['id_pessoa'];
		@session_write_close();

		$this->cod_cliente	      = $_GET["cod_cliente"];
		$this->acao_status	      = $_GET["status"];
		$this->ref_cod_biblioteca = $_GET["ref_cod_biblioteca"];

		$obj_permissoes = new clsPermissoes();
		$obj_permissoes->permissao_cadastra( 603, $this->pessoa_logada, 11,  "educar_cliente_det.php" );

		if( is_numeric( $this->cod_cliente ) )
		{
			$obj = new clsPmieducarCliente( $this->cod_cliente );
			$registro  = $obj->detalhe();
			if( $registro )
			{
				foreach( $registro AS $campo => $val )	// passa todos os valores obtidos no registro para atributos do objeto
					$this->$campo = $val;

				if ( $this->acao_status == "liberar" )
					$retorno = "Editar";
			}
		}
		$this->url_cancelar = ($retorno == "Editar") ? "educar_cliente_det.php?cod_cliente={$registro["cod_cliente"]}" : "educar_cliente_lst.php";
		$this->nome_url_cancelar = "Cancelar";
		return $retorno;
	}

	function Gerar()
	{
		if ( $this->acao_status == "suspender" ) {

			$this->campoOculto("cod_cliente", $this->cod_cliente);
			$this->campoOculto("ref_cod_biblioteca", $this->ref_cod_biblioteca);
			
			if ( $this->ref_idpes ) {

				$objTemp = new clsPessoaFisica( $this->ref_idpes );
				$detalhe = $objTemp->detalhe();

				$this->campoRotulo( "nm_cliente", "Cliente", $detalhe["nome"] );
			}
			$this->campoNumero( "dias", "Dias", $this->dias, 9, 9, true );
			if ( class_exists( "clsPmieducarMotivoSuspensao" ) ) {
				echo "<script> descricao = new Array();\n </script>";
				$opcoes[""] = "Selecione um motivo";
				$todos_motivos = "";
				$obj_motivo_suspensao = new clsPmieducarMotivoSuspensao();
				$lst_motivo_suspensao = $obj_motivo_suspensao->listaClienteBiblioteca( $this->cod_cliente );
				if ( $lst_motivo_suspensao ) 
				{
					foreach ( $lst_motivo_suspensao as $motivo_suspensao ) {
						$todos_motivos .= "descricao[descricao.length] = new Array( {$motivo_suspensao["cod_motivo_suspensao"]}, '{$motivo_suspensao["descricao"]}' );\n";
						$opcoes["{$motivo_suspensao["cod_motivo_suspensao"]}"] = "{$motivo_suspensao["nm_motivo"]}";
					}
					echo "<script>{$todos_motivos}</script>";
					$this->campoLista( "cod_motivo_suspensao", "Motivo da Suspenso", $opcoes, $this->cod_motivo_suspensao, "", false, "", "", false, true );
					$this->campoMemo( "descricao", "Descrio", $this->descricao, 50, 5, false, "", "", false, false, "onClick", true );
					echo "<script>
							var before_getDescricao = function(){}
							var after_getDescricao  = function(){}

							function getDescricao()
							{
								before_getDescricao();

								var campoMotivoSuspensao = document.getElementById( 'cod_motivo_suspensao' ).value;
								var campoDescricao 		 = document.getElementById( 'descricao' );
								for ( var j = 0; j < descricao.length; j++ )
								{
									if ( descricao[j][0] == campoMotivoSuspensao )
									{
										campoDescricao.value = descricao[j][1];
									}
									else if ( campoMotivoSuspensao == '' )
									{
										campoDescricao.value = 'Sem descrio...';
									}
								}
								if ( campoDescricao.length == 0 && campoMotivoSuspensao != '' ) {
									campoDescricao.value = 'Sem descrio...';
								}

								after_getDescricao();
							}
						 </script>";
				}
				else 
				{
					$this->campoLista( "cod_motivo_suspensao", "Motivo da Suspenso", array("" => "No h motivo cadastrado"), "", "", false, "", "", true, true );
				}
			}
		}
		elseif ( $this->acao_status == "liberar" ) {
			$db 	   		  = new clsBanco();
			$this->sequencial = $db->CampoUnico( "SELECT MAX( sequencial ) FROM pmieducar.cliente_suspensao WHERE ref_cod_cliente = {$this->cod_cliente} AND data_liberacao IS NULL" );
			$this->campoOculto("sequencial", $this->sequencial );

			$this->Editar();
		}
	}

	function Novo()
	{
		session_start();
		$this->pessoa_logada = $_SESSION['id_pessoa'];
		session_write_close();

		$obj_permissoes = new clsPermissoes();
		$obj_permissoes->permissao_cadastra( 603, $this->pessoa_logada, 11,  "educar_cliente_lst.php" );

		$obj = new clsPmieducarClienteSuspensao( null, $this->cod_cliente, $this->cod_motivo_suspensao, null, $this->pessoa_logada, $this->dias, null, null );
		
		// Caso suspenso tenha sido efetuada, envia para pgina de detalhes
		if ($obj->cadastra()) 
		{
			$this->mensagem .= "Suspens&atilde;o efetuada com sucesso.<br>";
			header("Location: educar_cliente_det.php?cod_cliente={$this->cod_cliente}&ref_cod_biblioteca={$this->ref_cod_biblioteca}");
			die();
			return true;
		}
		
		$this->mensagem = "Suspens&atilde;o n&atilde;o realizada.<br>";
		echo "<!--\nErro ao cadastrar clsPmieducarClienteSuspensao\nvalores obrigatorios\nis_numeric( $this->ref_cod_cliente_tipo ) && is_numeric( $this->ref_usuario_cad ) && is_numeric( $this->ref_idpes ) && is_numeric( $this->login )\n-->";
		return false;
	}

	function Editar()
	{
		@session_start();
		 $this->pessoa_logada = $_SESSION['id_pessoa'];
		@session_write_close();
		$obj_permissoes = new clsPermissoes();
		$obj_permissoes->permissao_cadastra( 603, $this->pessoa_logada, 11,  "educar_cliente_lst.php" );

		$obj_suspensao = new clsPmieducarClienteSuspensao( $this->sequencial, $this->cod_cliente, null, $this->pessoa_logada, null, null, null, null );
		if ( $obj_suspensao->edita() ) {
			$this->mensagem .= "Libera&ccedil;&atilde;o efetuada com sucesso.<br>";
			header( "Location: educar_cliente_lst.php" );
			die();
			return true;
		}
		$obj = new clsPmieducarCliente( $this->cod_cliente, $this->pessoa_logada, $this->pessoa_logada, $this->ref_idpes, $this->login, $senha, $this->data_cadastro, $this->data_exclusao, $this->ativo );
		$editou = $obj->edita();
		$this->mensagem = "Libera&ccedil;&atilde;o n&atilde;o realizada.<br>";
		echo "<!--\nErro ao editar clsPmieducarCliente\nvalores obrigatorios\nif( is_numeric( $this->cod_cliente ) && is_numeric( $this->ref_usuario_exc ) )\n-->";
		return false;
	}

	function Excluir()
	{
		@session_start();
		 $this->pessoa_logada = $_SESSION['id_pessoa'];
		@session_write_close();

		$obj_permissoes = new clsPermissoes();
		$obj_permissoes->permissao_excluir( 603, $this->pessoa_logada, 11,  "educar_cliente_lst.php" );


		$obj = new clsPmieducarCliente($this->cod_cliente, $this->ref_cod_cliente_tipo, $this->pessoa_logada, $this->pessoa_logada, $this->ref_idpes, $this->login, $this->senha, $this->data_cadastro, $this->data_exclusao, 0);
		$excluiu = $obj->excluir();
		if( $excluiu )
		{
			$this->mensagem .= "Exclus&atilde;o efetuada com sucesso.<br>";
			header( "Location: educar_cliente_lst.php?cod_cliente={$this->cod_cliente}" );
			die();
			return true;
		}

		$this->mensagem = "Exclus&atilde;o n&atilde;o realizada.<br>";
		echo "<!--\nErro ao excluir clsPmieducarCliente\nvalores obrigatorios\nif( is_numeric( $this->cod_cliente ) && is_numeric( $this->ref_usuario_exc ) )\n-->";
		return false;
	}
}

// cria uma extensao da classe base
$pagina = new clsIndexBase();
// cria o conteudo
$miolo = new indice();
// adiciona o conteudo na clsBase
$pagina->addForm( $miolo );
// gera o html
$pagina->MakeAll();
?>
<script>

var ref_cod_motivo_suspensao = document.getElementById( 'cod_motivo_suspensao' );
ref_cod_motivo_suspensao.onchange = function() { getDescricao(); };


</script>
