<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Pmieducar
 * @since     Arquivo disponvel desde a verso 1.0.0
 * @version   $Id$
 */

header('Content-type: text/xml; charset=ISO-8859-1');

require_once 'include/clsBanco.inc.php';
require_once 'include/funcoes.inc.php';

require_once 'Portabilis/Utils/DeprecatedXmlApi.php';
Portabilis_Utils_DeprecatedXmlApi::returnEmptyQueryUnlessUserIsLoggedIn();

echo "<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>\n<query xmlns=\"sugestoes\">\n";

$componentes = array();

// Seleciona os componentes de um curso ou srie
if (is_numeric($_GET['cur']) || is_numeric($_GET['ser'])) {
  require_once 'ComponenteCurricular/Model/AnoEscolarDataMapper.php';
  $mapper = new ComponenteCurricular_Model_AnoEscolarDataMapper();

  if (is_numeric($_GET['cur'])) {
    $componentes = $mapper->findComponentePorCurso($_GET['cur']);
  }
  elseif(is_numeric($_GET['ser'])) {
    $componentes = $mapper->findComponentePorSerie($_GET['ser']);
  }
}

// Seleciona os componentes de uma escola-srie
if (is_numeric($_GET['esc']) && is_numeric($_GET['ser'])) {
  require_once 'App/Model/IedFinder.php';

  try {
    $componentes = App_Model_IedFinder::getEscolaSerieDisciplina($_GET['ser'], $_GET['esc']);
  } catch (Exception $e) {
    echo '<disciplina>Erro: ' . $e->getMessage() . '</disciplina>';
    echo "</query>";
    die();
  }
}

foreach ($componentes as $componente) {
  print sprintf(' <disciplina cod_disciplina="%d" carga_horaria="%d">%s</disciplina>%s',
    $componente->id, $componente->cargaHoraria, $componente, PHP_EOL);
}

echo "</query>";