<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*																	     *
	*	@author Prefeitura Municipal de Itaja								 *
	*	@updated 29/03/2007													 *
	*   Pacote: i-PLB Software Pblico Livre e Brasileiro					 *
	*																		 *
	*	Copyright (C) 2006	PMI - Prefeitura Municipal de Itaja			 *
	*						ctima@itajai.sc.gov.br					    	 *
	*																		 *
	*	Este  programa    software livre, voc pode redistribu-lo e/ou	 *
	*	modific-lo sob os termos da Licena Pblica Geral GNU, conforme	 *
	*	publicada pela Free  Software  Foundation,  tanto  a verso 2 da	 *
	*	Licena   como  (a  seu  critrio)  qualquer  verso  mais  nova.	 *
	*																		 *
	*	Este programa   distribudo na expectativa de ser til, mas SEM	 *
	*	QUALQUER GARANTIA. Sem mesmo a garantia implcita de COMERCIALI-	 *
	*	ZAO  ou  de ADEQUAO A QUALQUER PROPSITO EM PARTICULAR. Con-	 *
	*	sulte  a  Licena  Pblica  Geral  GNU para obter mais detalhes.	 *
	*																		 *
	*	Voc  deve  ter  recebido uma cpia da Licena Pblica Geral GNU	 *
	*	junto  com  este  programa. Se no, escreva para a Free Software	 *
	*	Foundation,  Inc.,  59  Temple  Place,  Suite  330,  Boston,  MA	 *
	*	02111-1307, USA.													 *
	*																		 *
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
require_once ("include/clsBase.inc.php");
require_once ("include/clsCadastro.inc.php");
require_once ("include/clsBanco.inc.php");
require_once( "include/pmieducar/geral.inc.php" );
require_once 'lib/Portabilis/Date/Utils.php';

class clsIndexBase extends clsBase
{
	function Formular()
	{
		$this->SetTitulo( "{$this->_instituicao} i-Educar - Reclassificar Matr&iacute;cula" );
		$this->processoAp = "578";
		$this->addEstilo("localizacaoSistema");
	}
}

class indice extends clsCadastro
{
	/**
	 * Referencia pega da session para o idpes do usuario atual
	 *
	 * @var int
	 */
	var $pessoa_logada;

	var $cod_matricula;
	var $ref_cod_reserva_vaga;
	var $ref_ref_cod_escola;
	var $ref_ref_cod_serie;
	var $ref_usuario_exc;
	var $ref_usuario_cad;
	var $ref_cod_aluno;
	var $aprovado;
	var $data_cadastro;
	var $data_exclusao;
	var $ativo;
	var $ano;
	var $data_cancel;

	var $ref_cod_instituicao;
	var $ref_cod_curso;
	var $ref_cod_escola;

	var $ref_ref_cod_serie_antiga;

	var $descricao_reclassificacao;

	function Inicializar()
	{
		$retorno = "Novo";
		@session_start();
			$this->pessoa_logada = $_SESSION['id_pessoa'];
		@session_write_close();

		$this->cod_matricula=$_GET["ref_cod_matricula"];
		$this->ref_cod_aluno=$_GET["ref_cod_aluno"];

		$obj_permissoes = new clsPermissoes();
		$obj_permissoes->permissao_cadastra( 578, $this->pessoa_logada, 7,  "educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}" );

		$obj_matricula = new clsPmieducarMatricula($this->cod_matricula);
		$det_matricula = $obj_matricula->detalhe();

		if(!$det_matricula || $det_matricula['aprovado'] != 3)
			header("location: educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}");

		foreach ($det_matricula as $key => $value)
			$this->$key = $value;


		//$this->url_cancelar = "educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}";
		$this->url_cancelar = "educar_matricula_det.php?cod_matricula={$this->cod_matricula}";

		$nomeMenu = $retorno == "Editar" ? $retorno : "Cadastrar";
        $localizacao = new LocalizacaoSistema();
        $localizacao->entradaCaminhos( array(
             $_SERVER['SERVER_NAME']."/intranet" => "In&iacute;cio",
             "educar_index.php"                  => "i-Educar - Escola",
             ""        => "{$nomeMenu} reclassifica&ccedil;&atilde;o da matr&iacute;cula"
        ));
        $this->enviaLocalizacao($localizacao->montar());

		$this->nome_url_cancelar = "Cancelar";
		return $retorno;
	}

	function Gerar()
	{
		if ( $this->ref_cod_escola )
		{
			$this->ref_ref_cod_escola = $this->ref_cod_escola;
		}

		// primary keys
		$this->campoOculto( "cod_matricula", $this->cod_matricula );
		$this->campoOculto( "ref_cod_aluno", $this->ref_cod_aluno );
		$this->campoOculto( "ref_cod_escola", $this->ref_ref_cod_escola );

		$obj_aluno = new clsPmieducarAluno();
		$lst_aluno = $obj_aluno->lista( $this->ref_cod_aluno,null,null,null,null,null,null,null,null,null,1 );
		if ( is_array($lst_aluno) )
		{
			$det_aluno = array_shift($lst_aluno);
			$this->nm_aluno = $det_aluno["nome_aluno"];
			$this->campoRotulo( "nm_aluno", "Aluno", $this->nm_aluno);
		}


		$array_inicio_sequencias = clsPmieducarMatricula::getInicioSequencia();

		$db = new clsBanco();


		$cursos = array();
		$sql_curso_aluno = "SELECT ref_cod_curso FROM pmieducar.serie WHERE cod_serie = {$this->ref_ref_cod_serie}";
		$this->ref_cod_curso = $db->CampoUnico($sql_curso_aluno);

		foreach ($array_inicio_sequencias as $serie_inicio)
		{
			$serie_inicio = $serie_inicio[0];

			$seq_ini = $serie_inicio;
			$seq_correta = false;
			do
			{
				$sql = "SELECT o.ref_serie_origem
				               ,s.nm_serie
						       ,o.ref_serie_destino
						       ,s.ref_cod_curso as ref_cod_curso_origem
						       ,sd.ref_cod_curso as ref_cod_curso_destino
						  FROM pmieducar.sequencia_serie o
						       ,pmieducar.serie s
						       ,pmieducar.serie sd
						 WHERE s.cod_serie = o.ref_serie_origem
						   AND s.cod_serie = $seq_ini
				           AND sd.cod_serie = o.ref_serie_destino
						";
//						   AND s.ref_cod_curso = $curso
				$db->Consulta($sql);
				$db->ProximoRegistro();
				$tupla = $db->Tupla();
				$serie_origem = $tupla['ref_serie_origem'];
				//$nm_serie_origem = $tupla['nm_serie'];
				$curso_origem = $tupla['ref_cod_curso_origem'];
				$curso_destino = $tupla['ref_cod_curso_destino'];
				$seq_ini = $serie_destino = $tupla['ref_serie_destino'];

				$obj_curso = new clsPmieducarCurso($curso_origem);
				$det_curso = $obj_curso->detalhe();
				$cursos[$curso_origem] = $det_curso['nm_curso'];

				$obj_curso = new clsPmieducarCurso($curso_destino);
				$det_curso = $obj_curso->detalhe();
				$cursos[$curso_destino] = $det_curso['nm_curso'];

				if($this->ref_ref_cod_serie == $serie_origem)
					$seq_correta = true;


				//$todas_sequencias .= "sequencia_serie[sequencia_serie.length] = new Array({$curso_origem},$serie_origem,'$nm_serie_origem');\n";

				$sql = "SELECT 1
						  FROM pmieducar.sequencia_serie s
						 WHERE s.ref_serie_origem = $seq_ini
					    ";
				$true = $db->CampoUnico($sql);

			}while($true);

			$obj_serie = new clsPmieducarSerie($serie_destino);
			$det_serie = $obj_serie->detalhe();

			//$todas_sequencias .= "sequencia_serie[sequencia_serie.length] = new Array({$curso_destino},$serie_destino,'{$det_serie['nm_serie']}');\n";

			if($this->ref_ref_cod_serie == $serie_destino)
				$seq_correta = true;

			if($seq_correta == false)
			{
				///$todas_sequencias = "var sequencia_serie = new Array();\n";
				$cursos = array('' => 'No existem cursos/sries para reclassificao');
			}else
			{
				break;
			}
		}



		$this->campoOculto("serie_matricula",$this->ref_ref_cod_serie);

		//echo "<script>\n{$todas_sequencias}var serie_matricula = {$this->ref_ref_cod_serie};\n</script>";


		// foreign keys
		//$obrigatorio = true;
		//$get_escola = false;
	//	$get_instituicao = false;
	//	$get_escola_curso = true;
		//$get_escola_curso_serie = true;
		//$get_matricula = true;
		//include("include/pmieducar/educar_campo_lista.php");



		$this->campoLista("ref_cod_curso","Curso",$cursos,$this->ref_cod_curso,"getSerie();");
		$this->campoLista("ref_ref_cod_serie","S&eacute;rie",array('' => 'Selecione uma srie'),'');
		//$this->campoOculto("ref_ref_cod_serie_antiga",$this->ref_ref_cod_serie);
		$this->inputsHelper()->date('data_cancel', array('label' => 'Data da reclassifica&ccedil;&atilde;o', 'placeholder' => 'dd/mm/yyyy', 'value' => date('d/m/Y')));
		$this->campoMemo("descricao_reclassificacao","Descri&ccedil;&atilde;o",$this->descricao_reclassificacao,100,10,true);

		$this->acao_enviar = 'if(confirm("Deseja reclassificar est matrcula?"))acao();';


	}

	function Novo()
	{
		@session_start();
		 $this->pessoa_logada = $_SESSION['id_pessoa'];
		@session_write_close();
		$obj_permissoes = new clsPermissoes();
		$obj_permissoes->permissao_cadastra( 578, $this->pessoa_logada, 7, "educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}" );

		$this->data_cancel = Portabilis_Date_Utils::brToPgSQL($this->data_cancel);

		if($this->ref_ref_cod_serie == $this->ref_ref_cod_serie_antiga)
			header("location: educar_matricula_det.php?cod_matricula={$this->cod_matricula}");

		$obj_matricula = new clsPmieducarMatricula($this->cod_matricula);
		$det_matricula = $obj_matricula->detalhe();

		if(is_null($det_matricula['data_matricula'])){

			if(substr($det_matricula['data_cadastro'], 0, 10) > $this->data_cancel){

				$this->mensagem = "Data de abandono no pode ser inferior a data da matrcula.<br>";
				return false;	
				die();							
			} 
		}else{
			if(substr($det_matricula['data_matricula'], 0, 10) > $this->data_cancel){
				$this->mensagem = "Data de abandono no pode ser inferior a data da matrcula.<br>";
				return false;
				die();
			}
		}		

		if(!$det_matricula || $det_matricula['aprovado'] != 3)
			header("location: educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}");

		$obj_matricula = new clsPmieducarMatricula($this->cod_matricula,null,null,null,$this->pessoa_logada,null,null,5,null,null,1,null,0,null,null,$this->descricao_reclassificacao);
		$obj_matricula->data_cancel = $this->data_cancel;

		if(!$obj_matricula->edita())
		{
			echo "<script>alert('Erro ao reclassificar matrcula'); window.location='educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}';</script>";
			die("Erro ao reclassificar matrcula");
		}
		$obj_serie = new clsPmieducarSerie( $this->ref_ref_cod_serie );
		$det_serie = $obj_serie->detalhe();

		$obj_matricula = new clsPmieducarMatricula(null,null,$this->ref_cod_escola,$this->ref_ref_cod_serie,null,$this->pessoa_logada,$this->ref_cod_aluno,3,null,null,1,$det_matricula['ano'],1,null,null,null,1,$det_serie["ref_cod_curso"] );
		$cadastrou = $obj_matricula->cadastra();

		if(!$cadastrou){
			echo "<script>alert('Erro ao reclassificar matrcula'); window.location='educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}';</script>";
			die("Erro ao reclassificar matrcula");
		}else{
			/**
			 * desativa todas as enturmacoes da matricula anterior
			 */
			$obj_matricula_turma = new clsPmieducarMatriculaTurma($this->cod_matricula);
			if(!$obj_matricula_turma->reclassificacao())
			{
				echo "<script>alert('Erro ao desativar enturmaes da matrcula: {$this->cod_matricula}\nContate o administrador do sistema informando a matrcula!');</script>";
			}
			//window.location='educar_matricula_det.php?cod_matricula={$this->cod_matricula}&ref_cod_aluno={$this->ref_cod_aluno}';
			echo "<script>alert('Reclassificao realizada com sucesso!\\nO Cdigo da nova matrcula : $cadastrou.');
			window.location='educar_matricula_lst.php?ref_cod_aluno={$this->ref_cod_aluno}';
			</script>";
			die('Reclassificao realizada com sucesso!');

		}

	}

	function Excluir()
	{
		return false;
	}
}

// cria uma extensao da classe base
$pagina = new clsIndexBase();
// cria o conteudo
$miolo = new indice();
// adiciona o conteudo na clsBase
$pagina->addForm( $miolo );
// gera o html
$pagina->MakeAll();
?>
<script>
/*
document.getElementById('ref_cod_escola').onchange = function()
{
	getEscolaCurso();
}

document.getElementById('ref_cod_curso').onchange = function()
{
	getEscolaCursoSerie();
}*/
function getSerie()
{
	var campoCurso = document.getElementById('ref_cod_curso').value;
	var campoSerie = document.getElementById('serie_matricula').value;
	var xml1 = new ajax(getSerie_XML);
	strURL = "educar_sequencia_serie_curso_xml.php?cur="+campoCurso+"&ser_dif="+campoSerie;
	xml1.envia(strURL);

}

function getSerie_XML(xml)
{
	//var campoCurso = document.getElementById('ref_cod_curso').value;
	var campoSerie = document.getElementById('ref_ref_cod_serie');
	//var campoSerieMatricula = document.getElementById('serie_matricula').value;

	var seq_serie = xml.getElementsByTagName( "serie" );
	campoSerie.length = 1;

	for( var ct = 0;ct < seq_serie.length;ct++ )
	{
	//	if( curso == sequencia_serie[ct][0] && sequencia_serie[ct][1] != campoSerieMatricula)
		//{
		campoSerie[campoSerie.length] = new Option(seq_serie[ct].firstChild.nodeValue,seq_serie[ct].getAttribute("cod_serie"),false,false);
	//	}
	}
}
getSerie();
</script>