<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Adriano Nagasava <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Pmieducar
 * @since     Arquivo disponvel desde a verso 1.0.0
 * @version   $Id$
 */

require_once 'include/clsBase.inc.php';
require_once 'include/clsDetalhe.inc.php';
require_once 'include/clsBanco.inc.php';
require_once 'include/pmieducar/geral.inc.php';

require_once 'App/Model/IedFinder.php';

/**
 * clsIndexBase class.
 *
 * @author    Adriano Nagasava <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Pmieducar
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class clsIndexBase extends clsBase
{
  function Formular()
  {
    $this->SetTitulo($this->_instituicao . ' i-Educar - Turma');
    $this->processoAp = 586;
    $this->addEstilo("localizacaoSistema");
  }
}

/**
 * indice class.
 *
 * @author    Adriano Nagasava <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Pmieducar
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class indice extends clsDetalhe
{
  var $titulo;

  var $cod_turma;
  var $ref_usuario_exc;
  var $ref_usuario_cad;
  var $ref_ref_cod_serie;
  var $ref_ref_cod_escola;
  var $ref_cod_infra_predio_comodo;
  var $nm_turma;
  var $sgl_turma;
  var $max_aluno;
  var $multiseriada;
  var $data_cadastro;
  var $data_exclusao;
  var $ativo;
  var $ref_cod_turma_tipo;
  var $hora_inicial;
  var $hora_final;
  var $hora_inicio_intervalo;
  var $hora_fim_intervalo;

  var $ref_cod_instituicao;
  var $ref_cod_curso;

  var $ref_cod_instituicao_regente;
  var $ref_cod_regente;

  function Gerar()
  {
    @session_start();
    $this->pessoa_logada = $_SESSION['id_pessoa'];
    session_write_close();

    $this->titulo = 'Turma - Detalhe';
    $this->addBanner(
      'imagens/nvp_top_intranet.jpg', 'imagens/nvp_vert_intranet.jpg', 'Intranet'
    );

    $this->cod_turma = $_GET['cod_turma'];

    $tmp_obj = new clsPmieducarTurma();
    $lst_obj = $tmp_obj->lista($this->cod_turma, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
      NULL, NULL, NULL, array('true', 'false'));

    $registro = array_shift($lst_obj);

    foreach ($registro as $key => $value) {
      $this->$key = $value;
    }

    if (! $registro) {
      header('Location: educar_turma_lst.php');
      die();
    }

    if (class_exists('clsPmieducarTurmaTipo'))
    {
      $obj_ref_cod_turma_tipo = new clsPmieducarTurmaTipo(
        $registro['ref_cod_turma_tipo']
      );

      $det_ref_cod_turma_tipo = $obj_ref_cod_turma_tipo->detalhe();
      $registro['ref_cod_turma_tipo'] = $det_ref_cod_turma_tipo['nm_tipo'];
    }
    else {
      $registro['ref_cod_turma_tipo'] = 'Erro na gerao';
    }

    if (class_exists('clsPmieducarInfraPredioComodo')) {
      $obj_ref_cod_infra_predio_comodo = new clsPmieducarInfraPredioComodo(
        $registro['ref_cod_infra_predio_comodo']
      );

      $det_ref_cod_infra_predio_comodo = $obj_ref_cod_infra_predio_comodo->detalhe();
      $registro['ref_cod_infra_predio_comodo'] = $det_ref_cod_infra_predio_comodo['nm_comodo'];
    }
    else {
      $registro['ref_cod_infra_predio_comodo'] = 'Erro na gerao';
    }

    if (class_exists('clsPmieducarInstituicao')) {
      $obj_cod_instituicao = new clsPmieducarInstituicao(
        $registro['ref_cod_instituicao']
      );

      $obj_cod_instituicao_det = $obj_cod_instituicao->detalhe();
      $registro['ref_cod_instituicao'] = $obj_cod_instituicao_det['nm_instituicao'];
    }
    else {
      $registro['ref_cod_instituicao'] = 'Erro na gerao';
    }

    if (class_exists('clsPmieducarEscola')) {
      $this->ref_ref_cod_escola = $registro['ref_ref_cod_escola'];
      $obj_ref_cod_escola = new clsPmieducarEscola($registro['ref_ref_cod_escola']);
      $det_ref_cod_escola = $obj_ref_cod_escola->detalhe();
      $registro['ref_ref_cod_escola'] = $det_ref_cod_escola['nome'];
    }
    else {
      $registro['ref_cod_escola'] = 'Erro na gerao';
    }

    if (class_exists('clsPmieducarCurso')) {
      $obj_ref_cod_curso = new clsPmieducarCurso($registro['ref_cod_curso']);
      $det_ref_cod_curso = $obj_ref_cod_curso->detalhe();
      $registro['ref_cod_curso'] = $det_ref_cod_curso['nm_curso'];
      $padrao_ano_escolar = $det_ref_cod_curso['padrao_ano_escolar'];
    }
    else {
      $registro['ref_cod_curso'] = 'Erro na gerao';
    }

    if (class_exists('clsPmieducarSerie')) {
      $this->ref_ref_cod_serie = $registro['ref_ref_cod_serie'];
      $obj_ser = new clsPmieducarSerie($registro['ref_ref_cod_serie']);
      $det_ser = $obj_ser->detalhe();
      $registro['ref_ref_cod_serie'] = $det_ser['nm_serie'];
    }
    else {
      $registro['ref_ref_cod_serie'] = 'Erro na gerao';
    }

    $obj_permissoes = new clsPermissoes();
    $nivel_usuario = $obj_permissoes->nivel_acesso($this->pessoa_logada);

    if ($nivel_usuario == 1) {
      if ($registro['ref_cod_instituicao']) {
        $this->addDetalhe(array('Instituio', $registro['ref_cod_instituicao']));
      }
    }

    if ($nivel_usuario == 1 || $nivel_usuario == 2) {
      if ($registro['ref_ref_cod_escola']) {
        $this->addDetalhe(array('Escola', $registro['ref_ref_cod_escola']));
      }
    }

    if ($registro['ref_cod_curso']) {
      $this->addDetalhe(array('Curso', $registro['ref_cod_curso']));
    }

    if ($registro['ref_ref_cod_serie']) {
      $this->addDetalhe(array('Srie', $registro['ref_ref_cod_serie']));
    }

    if ($registro['ref_cod_regente']) {
      $obj_pessoa = new clsPessoa_($registro['ref_cod_regente']);
      $det = $obj_pessoa->detalhe();

      $this->addDetalhe(array('Professor/Regente', $det['nome']));
    }

    if ($registro['ref_cod_infra_predio_comodo']) {
      $this->addDetalhe(array('Sala', $registro['ref_cod_infra_predio_comodo']));
    }

    if ($registro['ref_cod_turma_tipo']) {
      $this->addDetalhe(array('Tipo de Turma', $registro['ref_cod_turma_tipo']));
    }

    if ($registro['nm_turma']) {
      $this->addDetalhe(array('Turma', $registro['nm_turma']));
    }

    if ($registro['sgl_turma']) {
      $this->addDetalhe(array('Sigla', $registro['sgl_turma']));
    }

    if ($registro['max_aluno']) {
      $this->addDetalhe(array('Mximo de Alunos', $registro['max_aluno']));
    }

    $this->addDetalhe(array('Situao', dbBool($registro['visivel']) ? 'Ativo' : 'Desativo'));

    if ($registro['multiseriada'] == 1) {
      if ($registro['multiseriada'] == 1) {
        $registro['multiseriada'] = 'sim';
      }
      else {
        $registro['multiseriada'] = 'no';
      }

      $this->addDetalhe(array('Multi-Seriada', $registro['multiseriada']));

      $obj_serie_mult = new clsPmieducarSerie($registro['ref_ref_cod_serie_mult']);
      $det_serie_mult = $obj_serie_mult->detalhe();

      $this->addDetalhe(array('Srie Multi-Seriada', $det_serie_mult['nm_serie']));
    }

    if ($padrao_ano_escolar == 1) {
      if ($registro['hora_inicial']) {
        $registro['hora_inicial'] = date('H:i', strtotime($registro['hora_inicial']));
        $this->addDetalhe(array('Hora Inicial', $registro['hora_inicial']));
      }

      if ($registro['hora_final']) {
        $registro['hora_final'] = date('H:i', strtotime($registro['hora_final']));
        $this->addDetalhe(array('Hora Final', $registro['hora_final']));
      }

      if ($registro['hora_inicio_intervalo']) {
        $registro['hora_inicio_intervalo'] = date('H:i', strtotime($registro['hora_inicio_intervalo']));
        $this->addDetalhe(array('Hora Incio Intervalo', $registro['hora_inicio_intervalo']));
      }

      if ($registro['hora_fim_intervalo']) {
        $registro['hora_fim_intervalo'] = date('H:i', strtotime($registro['hora_fim_intervalo']));
        $this->addDetalhe(array('Hora Fim Intervalo', $registro['hora_fim_intervalo']));
      }
    }
    elseif ($padrao_ano_escolar == 0) {
      $obj = new clsPmieducarTurmaModulo();
      $obj->setOrderby('data_inicio ASC');
      $lst = $obj->lista($this->cod_turma);

      if ($lst) {
        $tabela = '
          <table>
            <tr align="center">
              <td bgcolor="#A1B3BD"><b>Nome</b></td>
              <td bgcolor="#A1B3BD"><b>Data Incio</b></td>
              <td bgcolor="#A1B3BD"><b>Data Fim</b></td>
            </tr>';

        $cont = 0;

        foreach ($lst as $valor) {
          if (($cont % 2) == 0) {
            $color = ' bgcolor="#E4E9ED" ';
          }
          else {
            $color = ' bgcolor="#FFFFFF" ';
          }

          $obj_modulo = new clsPmieducarModulo($valor['ref_cod_modulo']);
          $det_modulo = $obj_modulo->detalhe();
          $nm_modulo = $det_modulo['nm_tipo'];

          $valor['data_inicio'] = dataFromPgToBr($valor['data_inicio']);
          $valor['data_fim']    = dataFromPgToBr($valor['data_fim']);

          $tabela .= sprintf('
            <tr>
              <td %s align=left>%s</td>
              <td %s align=left>%s</td>
              <td %s align=left>%s</td>
            </tr>',
            $color, $nm_modulo, $color, $valor['data_inicio'], $color, $valor['data_fim']
          );

          $cont++;
        }

        $tabela .= '</table>';
      }

      if ($tabela) {
        $this->addDetalhe(array('Mdulo', $tabela));
      }

      $dias_da_semana = array(
        '' => 'Selecione',
        1  => 'Domingo',
        2  => 'Segunda',
        3  => 'Tera',
        4  => 'Quarta',
        5  => 'Quinta',
        6  => 'Sexta',
        7  => 'Sbado'
      );

      $obj = new clsPmieducarTurmaDiaSemana();
      $lst = $obj->lista(NULL, $this->cod_turma);

      if ($lst) {
        $tabela1 = '
          <table>
            <tr align="center">
              <td bgcolor="#A1B3BD"><b>Nome</b></td>
              <td bgcolor="#A1B3BD"><b>Hora Inicial</b></td>
              <td bgcolor="#A1B3BD"><b>Hora Final</b></td>
            </tr>';

        $cont = 0;

        foreach ($lst as $valor) {
          if (($cont % 2) == 0) {
            $color = ' bgcolor="#E4E9ED" ';
          }
          else {
            $color = ' bgcolor="#FFFFFF" ';
          }

          $valor['hora_inicial'] = date('H:i', strtotime($valor['hora_inicial']));
          $valor['hora_final']   = date('H:i', strtotime($valor['hora_final']));

          $tabela1 .= sprintf("
            <tr>
              <td %s align=left>%s</td>
              <td %s align=left>%s</td>
              <td %s align=left>%s</td>
            </tr>",
            $color, $dias_da_semana[$valor['dia_semana']], $color,
            $valor['hora_inicial'], $color, $valor['hora_final']
          );

          $cont++;
        }

        $tabela1 .= '</table>';
      }

      if ($tabela1) {
        $this->addDetalhe(array('Dia da Semana', $tabela1));
      }
    }

    // Recupera os componentes curriculares da turma
    $componentes = array();

    try {
      $componentes = App_Model_IedFinder::getComponentesTurma(
        $this->ref_ref_cod_serie, $this->ref_ref_cod_escola, $this->cod_turma
      );
    }
    catch (Exception $e) {
    }

    $tabela3 = '
      <table>
        <tr align="center">
          <td bgcolor="#A1B3BD"><b>Nome</b></td>
          <td bgcolor="#A1B3BD"><b>Carga horria</b></td>
        </tr>';

    $cont = 0;
    foreach ($componentes as $componente) {
      $color = ($cont++ % 2 == 0) ? ' bgcolor="#E4E9ED" ' : ' bgcolor="#FFFFFF" ';

      $tabela3 .= sprintf('
        <tr>
          <td %s align="left">%s</td>
          <td %s align="center">%.0f h</td>
        </tr>',
        $color, $componente, $color, $componente->cargaHoraria
      );
    }

    $tabela3 .= '</table>';
    $this->addDetalhe(array('Componentes curriculares', $tabela3));

    if ($obj_permissoes->permissao_cadastra(586, $this->pessoa_logada, 7)) {
      $this->url_novo   = 'educar_turma_cad.php';
      $this->url_editar = 'educar_turma_cad.php?cod_turma=' . $registro['cod_turma'];
    }

    $this->url_cancelar = 'educar_turma_lst.php';
    $this->largura      = '100%';

    $localizacao = new LocalizacaoSistema();
    $localizacao->entradaCaminhos( array(
         $_SERVER['SERVER_NAME']."/intranet" => "In&iacute;cio",
         "educar_index.php"                  => "i-Educar - Escola",
         ""                                  => "Detalhe da turma"
    ));
    $this->enviaLocalizacao($localizacao->montar());

    $this->array_botao[]            = 'Reclassificar alunos alfabeticamente';
    $this->array_botao_url_script[] = "if(confirm(\"Deseja realmente reclassificar os alunos alfabeticamente?\\nAo utilizar esta opo para esta turma, a ordenao dos alunos no dirio e em relatrios que  controlada por ordem de chegada aps a data de fechamento da turma (campo Data de fechamento), passar a ter o controle novamente alfabtico, desconsiderando a data de fechamento.\"))reclassifica_matriculas({$registro['cod_turma']})";

    Portabilis_View_Helper_Application::loadJQueryLib($this);

    $scripts = array(
      '/modules/Portabilis/Assets/Javascripts/Utils.js',
      '/modules/Portabilis/Assets/Javascripts/ClientApi.js',
      '/modules/Cadastro/Assets/Javascripts/TurmaDet.js'
    );

    Portabilis_View_Helper_Application::loadJavascript($this, $scripts);
  }
}

// Instancia objeto de pgina
$pagina = new clsIndexBase();

// Instancia objeto de contedo
$miolo = new indice();

// Atribui o contedo   pgina
$pagina->addForm($miolo);

// Gera o cdigo HTML
$pagina->MakeAll();