<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Imagem
 * @since     Arquivo disponvel desde a verso 1.0.0
 * @version   $Id$
 */

require_once 'include/clsBase.inc.php';
require_once 'include/clsDetalhe.inc.php';
require_once 'include/clsBanco.inc.php';
require_once 'include/imagem/clsPortalImagemTipo.inc.php';
require_once 'include/imagem/clsPortalImagem.inc.php';

/**
 * clsIndex class.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Imagem
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class clsIndex extends clsBase
{
  function Formular()
  {
    $this->SetTitulo($this->_instituicao . 'Banco de Imagens');
    $this->processoAp = '473';
  }
}

/**
 * indice class.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Imagem
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class indice extends clsDetalhe
{
  function Gerar()
  {
    $this->titulo = 'Detalhe da Imagem';
    

    $cod_imagem = $_GET['cod_imagem'];

    $objimagem = new clsPortalImagem($cod_imagem);
    $detalheImagem = $objimagem->detalhe();
    $objimagemTipo = new clsPortalImagemTipo($detalheImagem['ref_cod_imagem_tipo']);
    $detalheImagemTipo = $objimagemTipo->detalhe();

    $this->addDetalhe(array('Tipo da Imagem', $detalheImagemTipo['nm_tipo']));
    $this->addDetalhe(array('Nome', $detalheImagem['nm_imagem']));
    $this->addDetalhe(array('Imagem', "<img src='banco_imagens/{$detalheImagem['caminho']}' alt='{$detalheImagem['nm_imagem']}' title='{$detalheImagem['nm_imagem']}'>"));
    $this->addDetalhe(array('Extenso', $detalheImagem['extensao']));
    $this->addDetalhe(array('Largura', $detalheImagem['largura']));
    $this->addDetalhe(array('Altura', $detalheImagem['altura']));
    $this->addDetalhe(array('Data de Cadastro', dataFromPgToBr($detalheImagem['data_cadastro']) ));

    $this->url_novo     = 'imagem_cad.php';
    $this->url_editar   = 'imagem_cad.php?cod_imagem=' . $cod_imagem;
    $this->url_cancelar = 'imagem_lst.php';

    $this->largura = "100%";
  }
}


// Instancia objeto de pgina
$pagina = new clsIndex();

// Instancia objeto de contedo
$miolo = new indice();

// Atribui o contedo  pgina
$pagina->addForm($miolo);

// Gera o cdigo HTML
$pagina->MakeAll();