<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd
 * @since     Arquivo disponvel desde a verso 1.0.0
 * @version   $Id$
 */

require_once '../includes/bootstrap.php';
require_once 'include/clsBancoPgSql.inc.php';

/**
 * clsBanco class.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class clsBanco extends clsBancoSQL_
{
  /**
   * Construtor (PHP 4).
   */
  public function clsBanco($strDataBase = FALSE)
  {
    parent::__construct($strDataBase);

    global $coreExt;
    $config = $coreExt['Config']->app->database;

    $this->setHost($config->hostname);
    $this->setDbname($config->dbname);
    $this->setPassword($config->password);
    $this->setUser($config->username);
    $this->setPort($config->port);
  }

  /**
   * Retorna a quantidade de registros de uma tabela baseado no objeto que a
   * abstrai. Este deve ter um atributo pblico Object->_tabela.
   *
   * @param   mixed   Objeto que abstrai a tabela
   * @param   string  Nome da coluna para clculo COUNT()
   * @return  int     Quantidade de registros da tabela
   */
  public function doCountFromObj($obj, $column = '*')
  {
    if ($obj->_tabela == NULL) {
      return FALSE;
    }

    $sql = sprintf('SELECT COUNT(%s) FROM %s', $column, $obj->_tabela);
    $this->Consulta($sql);

    return (int)$this->UnicoCampo($sql);
  }

  /**
   * Retorna os dados convertidos para a sintaxe SQL aceita por ext/pgsql.
   *
   * <code>
   * <?php
   * $data = array(
   *   'id' => 1,
   *   'hasChild' = FALSE
   * );
   *
   * $clsBanco->getDbValuesFromArray($data);
   * // array(
   * //   'id' => 1,
   * //   'hasChild' => 'f'
   * // );
   * </code>
   *
   * Apenas o tipo booleano  convertido.
   *
   * @param array $data Array associativo com os valores a serem convertidos.
   * @return array
   */
  public function formatValues(array $data)
  {
    $db = array();
    foreach ($data as $key => $val) {
      if (is_bool($val)) {
        $db[$key] = $this->_formatBool($val);
        continue;
      }
      $db[$key] = $val;
    }
    return $db;
  }

  /**
   * Retorna um valor formatado de acordo com o tipo output do tipo booleano
   * no PostgreSQL.
   *
   * @link   http://www.postgresql.org/docs/8.2/interactive/datatype-boolean.html
   * @link   http://www.php.net/manual/en/function.pg-query-params.php#78072
   * @param  mixed $val
   * @return string "t" para TRUE e "f" para false
   */
  protected function _formatBool($val)
  {
    return ($val == TRUE ? 't' : 'f');
  }
}