<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @license     http://creativecommons.org/licenses/GPL/2.0/legalcode.pt  CC GNU GPL
 * @package     Core
 * @subpackage  pessoa
 * @subpackage  Escolaridade
 * @since       Arquivo disponvel desde a verso 1.0.0
 * @version     $Id$
 */

/**
 * clsCadastroEscolaridade class.
 *
 * @author      Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @license     http://creativecommons.org/licenses/GPL/2.0/legalcode.pt  CC GNU GPL
 * @package     Core
 * @subpackage  pessoa
 * @subpackage  Escolaridade
 * @since       Classe disponvel desde a verso 1.0.0
 * @version     $Id$
 */
class clsCadastroEscolaridade
{
  var $idesco;
  var $descricao;

  /**
   * Armazena o total de resultados obtidos na ltima chamada ao mtodo lista.
   * @var int
   */
  var $_total;

  /**
   * Nome do schema.
   * @var string
   */
  var $_schema;

  /**
   * Nome da tabela.
   * @var string
   */
  var $_tabela;

  /**
   * Lista separada por virgula, com os campos que devem ser selecionados na prxima chamado ao mtodo lista.
   * @var string
   */
  var $_campos_lista;

  /**
   * Lista com todos os campos da tabela separados por vrgula, padro para seleo no mtodo lista.
   * @var string
   */
  var $_todos_campos;

  /**
   * Valor que define a quantidade de registros a ser retornada pelo mtodo lista.
   * @var int
   */
  var $_limite_quantidade;

  /**
   * Define o valor de offset no retorno dos registros no mtodo lista.
   * @var int
   */
  var $_limite_offset;

  /**
   * Define o campo padro para ser usado como padro de ordenao no mtodo lista.
   * @var string
   */
  var $_campo_order_by;

  /**
   * Construtor (PHP 4).
   */
  function clsCadastroEscolaridade($idesco = NULL, $descricao = NULL)
  {
    $db = new clsBanco();
    $this->_schema = "cadastro.";
    $this->_tabela = "{$this->_schema}escolaridade";

    $this->_campos_lista = $this->_todos_campos = "idesco, descricao";

    if (is_numeric($idesco)) {
      $this->idesco = $idesco;
    }
    if (is_string($descricao)) {
      $this->descricao = $descricao;
    }
  }

  /**
   * Cria um novo registro.
   * @return bool
   */
  function cadastra()
  {
    if (is_string($this->descricao))
    {
      $db = new clsBanco();

      $campos  = '';
      $valores = '';
      $gruda   = '';

      $this->idesco = $db->CampoUnico('SELECT MAX(idesco) + 1
                      FROM cadastro.escolaridade');

      // Se for nulo,  o primeiro registro da tabela
      if (is_null($this->idesco)) {
        $this->idesco = 1;
      }

      if (is_numeric($this->idesco)) {
        $campos  .= "{$gruda}idesco";
        $valores .= "{$gruda}'{$this->idesco}'";
        $gruda = ", ";
      }
      if (is_string($this->descricao)) {
        $campos  .= "{$gruda}descricao";
        $valores .= "{$gruda}'{$this->descricao}'";
        $gruda = ", ";
      }

      $db->Consulta("INSERT INTO {$this->_tabela} ($campos) VALUES ($valores)");
      return $this->idesco;
    }

    return FALSE;
  }

  /**
   * Edita os dados de um registro.
   * @return bool
   */
  function edita()
  {
    if (is_numeric($this->idesco)) {
      $db  = new clsBanco();
      $set = "";

      if (is_string($this->descricao)) {
        $set  .= "{$gruda}descricao = '{$this->descricao}'";
        $gruda = ", ";
      }

      if ($set) {
        $db->Consulta("UPDATE {$this->_tabela} SET $set WHERE idesco = '{$this->idesco}'");
        return TRUE;
      }
    }

    return FALSE;
  }

  /**
   * Retorna uma lista de registros filtrados de acordo com os parmetros.
   * @return array
   */
  function lista($int_idesco = NULL, $str_descricao = NULL) {
    $sql = "SELECT {$this->_campos_lista} FROM {$this->_tabela}";
    $filtros = "";

    $whereAnd = " WHERE ";

    if (is_numeric($int_idesco)) {
      $filtros .= "{$whereAnd} idesco = '{$int_idesco}'";
      $whereAnd = " AND ";
    }
    if (is_string($str_descricao)) {
      $filtros .= "{$whereAnd} descricao ILIKE '%{$str_descricao}%'";
      $whereAnd = " AND ";
    }

    $db = new clsBanco();
    $countCampos = count(explode(",", $this->_campos_lista));
    $resultado = array();

    $sql .= $filtros . $this->getOrderby() . $this->getLimite();

    $this->_total = $db->CampoUnico("SELECT COUNT(0) FROM {$this->_tabela} {$filtros}");

    $db->Consulta($sql);

    if ($countCampos > 1) {
      while ($db->ProximoRegistro()) {
        $tupla = $db->Tupla();

        $tupla["_total"] = $this->_total;
        $resultado[] = $tupla;
      }
    }
    else {
      while ($db->ProximoRegistro()) {
        $tupla = $db->Tupla();
        $resultado[] = $tupla[$this->_campos_lista];
      }
    }
    if (count($resultado)) {
      return $resultado;
    }

    return FALSE;
  }

  /**
   * Retorna um array com os dados de um registro.
   * @return array
   */
  function detalhe()
  {
    if (is_numeric($this->idesco)) {
      $db = new clsBanco();
      $db->Consulta("SELECT {$this->_todos_campos} FROM {$this->_tabela} WHERE idesco = '{$this->idesco}'");
      $db->ProximoRegistro();

      return $db->Tupla();
    }

    return FALSE;
  }

  /**
   * Exclui um registro.
   * @return bool
   */
  function excluir()
  {
    if (is_numeric($this->idesco)) {
      $db = new clsBanco();
      $db->Consulta("DELETE FROM {$this->_tabela} WHERE idesco = '{$this->idesco}'");

      return TRUE;
    }

    return FALSE;
  }

  /**
   * Define quais campos da tabela sero selecionados na invocao do mtodo lista.
   * @return null
   */
  function setCamposLista($str_campos) {
    $this->_campos_lista = $str_campos;
  }

  /**
   * Define que o mtodo Lista dever retornoar todos os campos da tabela.
   * @return null
   */
  function resetCamposLista() {
    $this->_campos_lista = $this->_todos_campos;
  }

  /**
   * Define limites de retorno para o mtodo lista.
   * @return null
   */
  function setLimite($intLimiteQtd, $intLimiteOffset = NULL)
  {
    $this->_limite_quantidade = $intLimiteQtd;
    $this->_limite_offset = $intLimiteOffset;
  }

  /**
   * Retorna a string com o trecho da query resposvel pelo limite de registros.
   * @return string
   */
  function getLimite()
  {
    if (is_numeric($this->_limite_quantidade)) {
      $retorno = " LIMIT {$this->_limite_quantidade}";

      if (is_numeric($this->_limite_offset)) {
        $retorno .= " OFFSET {$this->_limite_offset} ";
      }

      return $retorno;
    }

    return '';
  }

  /**
   * Define campo para ser utilizado como ordenao no mtodo lista.
   * @return null
   */
  function setOrderby($strNomeCampo)
  {
    if (is_string($strNomeCampo) && $strNomeCampo) {
      $this->_campo_order_by = $strNomeCampo;
    }
  }

  /**
   * Retorna a string com o trecho da query resposvel pela ordenao dos registros.
   * @return string
   */
  function getOrderby()
  {
    if (is_string($this->_campo_order_by)) {
      return " ORDER BY {$this->_campo_order_by} ";
    }

    return '';
  }
}