<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*																	     *
*	@author Prefeitura Municipal de Itaja								 *
*	@updated 29/03/2007													 *
*   Pacote: i-PLB Software Pblico Livre e Brasileiro					 *
*																		 *
*	Copyright (C) 2006	PMI - Prefeitura Municipal de Itaja			 *
*						ctima@itajai.sc.gov.br					    	 *
*																		 *
*	Este  programa    software livre, voc pode redistribu-lo e/ou	 *
*	modific-lo sob os termos da Licena Pblica Geral GNU, conforme	 *
*	publicada pela Free  Software  Foundation,  tanto  a verso 2 da	 *
*	Licena   como  (a  seu  critrio)  qualquer  verso  mais  nova.	 *
*																		 *
*	Este programa   distribudo na expectativa de ser til, mas SEM	 *
*	QUALQUER GARANTIA. Sem mesmo a garantia implcita de COMERCIALI-	 *
*	ZAO  ou  de ADEQUAO A QUALQUER PROPSITO EM PARTICULAR. Con-	 *
*	sulte  a  Licena  Pblica  Geral  GNU para obter mais detalhes.	 *
*																		 *
*	Voc  deve  ter  recebido uma cpia da Licena Pblica Geral GNU	 *
*	junto  com  este  programa. Se no, escreva para a Free Software	 *
*	Foundation,  Inc.,  59  Temple  Place,  Suite  330,  Boston,  MA	 *
*	02111-1307, USA.													 *
*																		 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
require_once ("include/clsBanco.inc.php");
require_once ("include/Geral.inc.php");

class clsCepLogradouro
{
	var $cep;
	var $idlog;
	var $nroini;
	var $nrofin;

	var $tabela;
	var $schema;

	/**
	 * Construtor
	 *
	 * @return Object:clsCepLogradouro
	 */
	function clsCepLogradouro( $cep=false, $idlog=false, $nroini=false, $nrofin=false)
	{
		$objLogradouro = new clsLogradouro($idlog);
		if ($objLogradouro->detalhe())
		{
			$this->idlog  = $idlog;
		}

		$this->cep    = $cep;
		$this->nroini = $nroini;
		$this->nrofin = $nrofin;
		
		$this->tabela = "cep_logradouro";
		$this->schema = "urbano";
	}
	
	/**
	 * Funcao que cadastra um novo registro com os valores atuais
	 *
	 * @return bool
	 */
	function cadastra()
	{
		$db = new clsBanco();
		// verificacoes de campos obrigatorios para insercao
		if( is_numeric($this->cep) &&	 is_numeric($this->idlog) )
		{
			$campos = "";
			$values = "";
			if(is_numeric($this->nroini))
			{
				$campos .= ", nroini";
				$values .= ", '{$this->nroini}'";
			}
			if(is_numeric($this->nrofin))
			{
				$campos .= ", nrofin";
				$valores .= ", '$this->nrofin' ";
			}

			$db->Consulta( "INSERT INTO {$this->schema}.{$this->tabela} (cep,  idlog, origem_gravacao, data_cad, operacao, idsis_Cad  $campos) VALUES ( '{$this->cep}', '{$this->idlog}','U', NOW(), 'I', '9' $values )" );

		}
		return false;
	}
	
	/**
	 * Edita o registro atual
	 *
	 * @return bool
	 */
	function edita()
	{
		// verifica campos obrigatorios para edicao
		if(is_numeric($this->cep) &&  is_numeric($this->idlog))
		{
			$gruda = "";
			if($this->nroini)
			{
			   $set .= " nroini = '{$this->nroini}'";
			   $gruda = ", ";
			}
			else 
			{
				$set .= " nroini = NULL";
				$gruda = ", ";
			}
			
			if($this->nrofin)
			{
			   $set .= "$gruda nrofin = '{$this->nrofin}'";
			}
			else 
			{
				$set .= " nrofin = NULL";
				$gruda = ", ";
			}
	
			if ($set)
			{
				$set = "SET {$set}";
				$db = new clsBanco();
				$db->Consulta( "UPDATE {$this->schema}.{$this->tabela} $set WHERE cep = '$this->cep' AND idlog = '$this->idlog" );
				return true;
			}
		}
		return false;
	}

 	/**
	* Retorna um array com os dados de um registro.
    * @return array
    */
    function existe()
    {
        if (is_numeric($this->cep) && is_numeric($this->idlog)) {
            $db = new clsBanco();
            $db->Consulta("SELECT 1 FROM {$this->schema}.{$this->tabela} WHERE cep = '{$this->cep}' AND idlog = '{$this->idlog}' ");
            $db->ProximoRegistro();
            return $db->Tupla();
        }

        return FALSE;
    }

	/**
	 * Remove o registro atual
	 *
	 * @return bool
	 */
	function exclui( )
	{
		if( is_numeric($this->cep) && is_numeric($this->idlog))
		{
			$db = new clsBanco();
			$db->Consulta("DELETE FROM {$this->schema}.{$this->tabela} WHERE cep = {$this->cep} AND idlog = {$this->idlog}");
			return true;
		}
		return false;
	}
	
	/**
	 * Exibe uma lista baseada nos parametros de filtragem passados
	 *
	 * @return Array
	 */
	function lista( $int_cep=false, $int_idlog=false, $int_nroini=false, $int_nrofin=false, $str_ordenacao="cep", $int_limite_ini=0, $int_limite_qtd=20 )
	{
		// verificacoes de filtros a serem usados
		$whereAnd = "WHERE ";
		if(is_numeric($int_cep))
		{
			$where .= "{$whereAnd}cep = '$int_cep'";
			$whereAnd = " AND ";
		}
		if(is_numeric($int_idlog))
		{
			$where .= "{$whereAnd}idlog = '$int_idlog'";
			$whereAnd = " AND ";
		}
		if(is_numeric( $int_nroini))
		{
			$where .= "{$whereAnd}nroini = '$int_nroini'";
			$whereAnd = " AND ";
		}
		if(is_numeric($int_nrofin))
		{
			$where .= "{$whereAnd}nrofin =  '$int_nrofin'";
		}
		
		$orderBy = "";
		if(is_string($str_ordenacao))
		{
			$orderBy = "ORDER BY $str_ordenacao";
		}
		$limit = "";
		if(is_numeric($int_limite_ini) && 				   	    is_numeric($int_limite_qtd))
		{
			$limit = " LIMIT $int_limite_qtd OFFSET $int_limite_ini";
		}
		
		$db = new clsBanco();
		$db->Consulta( "SELECT COUNT(0) AS total FROM {$this->schema}.{$this->tabela} $where" );
		$db->ProximoRegistro();
		$total = $db->Campo( "total" );
		$db->Consulta( "SELECT cep, idlog, nroini, nrofin FROM {$this->schema}.{$this->tabela} $where $orderBy $limit" );
		$resultado = array();
		while ( $db->ProximoRegistro() ) 
		{
			$tupla = $db->Tupla();
			$tupla["idlog"] = new clsLogradouro( $tupla["idlog"]);
			$tupla["total"] = $total;
			$resultado[] = $tupla;
		}
		if( count( $resultado ) )
		{
			return $resultado;
		}
		return false;
	} 
	
	/**
	 * Retorna um array com os detalhes do objeto
	 *
	 * @return Array
	 */
	function detalhe()
	{
		if($this->cep && $this->idlog)
		{
			$db = new clsBanco();
			$db->Consulta("SELECT cep, idlog, nroini, nrofin FROM {$this->schema}.{$this->tabela} WHERE cep = {$this->cep} AND idlog = {$this->idlog}");
			if( $db->ProximoRegistro() )
			{
				$tupla = $db->Tupla();
	
				$tupla["idlog"] = new clsLogradouro( $tupla["idlog"] );
	
				return $tupla;
			}
		}
		return false;
	}
}
?>