/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa <eriksen.paixao_bs@cobra.com.br>
 * @license   @@license@@
 * @since     Arquivo disponvel desde a verso 2.0.0
 * @version   $Id$
 */

/**
 * Closure com funes utilitrias para o manuseamento de formulrios.
 */
var ied_forms = new function() {
  var checker = 0;

  /**
   * Seleciona/deseleciona campos checkbox de um formulrio. Cada chamada ao
   * mtodo executa uma ao de forma alternada: a primeira vez, altera a
   * propriedade dos checkboxes para "checked", na segunda, remove a
   * propriedade "checked" dos mesmos. Esse padro segue nas chamadas
   * subsequentes.
   *
   * @param document docObj
   * @param string   formId
   * @param string   fieldsName
   * @see ied_forms.getElementsByName
   */
  this.checkAll = function(docObj, formId, fieldsName) {
    if (checker === 0) {
      checker = 1;
    } else {
      checker = 0;
    }

    var elements = ied_forms.getElementsByName(docObj, formId, fieldsName);
    for (e in elements) {
      elements[e].checked = checker == 1 ? true : false;
    }
  };

  /**
   * Faz um bind de eventos para um elemento HTML. Baseia-se nos mtodos de
   * eventos W3C e clssico. O mtodo do Internet Explorer (attachEvent) 
   * ignorado pois passa os argumentos das funes annimas com cpia e sim
   * por referncia, fazendo com que as variveis this referenciem o objeto
   * window global.
   *
   * Para registrar diversas funes como listener ao evento, crie uma funo
   * annima:
   *
   * <code>
   * window.load = function() {
   *   var events = function() {
   *     function1(params);
   *     function2(params);
   *     functionN(params);
   *   }
   *   new ied_forms.bind(document, 'formId', 'myRadios', 'click', events);
   * }
   * </code>
   *
   * @param document docObj
   * @param string   formId
   * @param string   fieldsName
   * @param string   eventType      O tipo de evento para registrar o evento
   *   (listener), sem a parte 'on' do nome. Exemplos: click, focus, mouseout.
   * @param string   eventFunction  Uma funo listener para o evento. Para
   *   registrar vrias funes, crie uma funo annima.
   * @see ied_forms.getElementsByName
   * @link http://www.quirksmode.org/js/events_advanced.html Advanced event registration models
   * @link http://www.quirksmode.org/js/events_tradmod.html Traditional event registration model
   * @link http://javascript.about.com/library/bldom21.htm Cross Browser Event Processing
   * @link http://www.w3schools.com/jsref/dom_obj_event.asp Event Handlers
   */
  this.bind = function(docObj, formId, fieldsName, eventType, eventFunction) {
    var elements = ied_forms.getElementsByName(docObj, formId, fieldsName);

    for (e in elements) {
      if (elements[e].addEventListener) {
        elements[e].addEventListener(eventType, eventFunction, false);
      }
      else {
        // Usa o modo tradicional de registro de eventos ao invs do mtodo
        // nativo do Internet Explorer (attachEvent).
        elements[e]['on' + eventType] = eventFunction;
      }
    }
  };

  /**
   * Retorna objetos de um formulrio ao qual o nome (atributo name) seja
   * equivalente ao argumento fieldsName. Esse argumento aceita expresses
   * regulares, o que o torna mais flexvel para atribuir eventos ou atributos
   * a mltiplos elementos da rvore DOM.
   *
   * @param document docObj      Um objeto document, geralmente o objeto global document.
   * @param string   formId      O atributo "id" do formulrio.
   * @param string   fieldsName  O nome do elemento de formulrio ou uma string Regex.
   * @return Array   Um array com os elementos encontrados.
   */
  this.getElementsByName = function(docObj, formId, fieldsName) {
    var regex = new RegExp(fieldsName);
    var form = docObj.getElementById(formId);
    var matches = [];
    var matchId = 0;

    for (var i = 0; i < form.elements.length; i++) {
      var elementName = form.elements[i].name;
      if (null !== elementName.match(regex)) {
        matches[matchId++] = form.elements[i];
      }
    }

    return matches;
  };
};
