<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Lucas Schmoeller da Silva <lucas@portabilis.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   Module
 * @since     07/2013
 * @version   $Id$
 */

require_once 'include/clsBase.inc.php';
require_once 'include/clsDetalhe.inc.php';
require_once 'include/clsBanco.inc.php';
require_once 'include/pmieducar/geral.inc.php';
require_once 'include/modules/clsModulesVeiculo.inc.php';

require_once 'Portabilis/Date/Utils.php';
require_once 'Portabilis/View/Helper/Application.php';


/**
 * clsIndexBase class.21239
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Pmieducar
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class clsIndexBase extends clsBase
{
  function Formular()
  {
    $this->SetTitulo($this->_instituicao . ' i-Educar - Veiculos');
    $this->processoAp = 21237;
    $this->addEstilo('localizacaoSistema');
  }
}

/**
 * indice class.
 *
 * @author    Prefeitura Municipal de Itaja <ctima@itajai.sc.gov.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   iEd_Pmieducar
 * @since     Classe disponvel desde a verso 1.0.0
 * @version   @@package_version@@
 */
class indice extends clsDetalhe
{
  var $titulo;

  function Gerar()
  {
    @session_start();
    $this->pessoa_logada = $_SESSION['id_pessoa'];
    session_write_close();

    // Verificao de permisso para cadastro.
    $this->obj_permissao = new clsPermissoes();

    $this->nivel_usuario = $this->obj_permissao->nivel_acesso($this->pessoa_logada);

    $this->titulo = 'Veiculo - Detalhe';
    

    $cod_veiculo = $_GET['cod_veiculo'];

    $tmp_obj = new clsModulesVeiculo($cod_veiculo);
    $registro = $tmp_obj->detalhe();

    if (! $registro) {
      header('Location: transporte_veiculo_lst.php');
      die();
    }
    
    $this->addDetalhe( array("Cdigo do veculo", $cod_veiculo));
    $this->addDetalhe( array("Descrio", $registro['descricao']) );
    $this->addDetalhe( array("Placa", $registro['placa']) );
    $this->addDetalhe( array("Renavam", $registro['renavam']) );
    $this->addDetalhe( array("Chassi", $registro['chassi']) );
    $this->addDetalhe( array("Marca", $registro['marca']) );
    $this->addDetalhe( array("Ano fabricao", $registro['ano_fabricacao']) );
    $this->addDetalhe( array("Ano modelo", $registro['ano_modelo']) );
    $this->addDetalhe( array("Limite de passageiros", $registro['passageiros']) );
    $malha ='';
    switch ($registro['malha']){
      case 'A':
        $malha = 'Aqutica/Embarcao';
        break;
      case 'F':
        $malha = 'Ferroviria';
        break;
      case 'R':
        $malha = 'Rodoviria';
        break;
    }
    $this->addDetalhe( array("Malha", $malha) );
    $this->addDetalhe( array("Categoria", $registro['descricao_tipo']) );
    $this->addDetalhe( array("Exclusivo para transporte escolar", ($registro['exclusivo_transporte_escolar'] == 'S' ? 'Sim' : 'No')) );
    $this->addDetalhe( array("Adaptado para pessoas com necessidades especiais", ($registro['adaptado_necessidades_especiais'] == 'S' ? 'Sim' : 'No')) );
    $this->addDetalhe( array("Ativo", ($registro['ativo'] == 'S' ? 'Sim' : 'No')) );
    if ($registro['ativo']=='N')
      $this->addDetalhe( array("Descrio inativo", $registro['descricao_inativo']) );
    $this->addDetalhe( array("Empresa", $registro['nome_empresa']) );
    $this->addDetalhe( array("Motorista responsvel", $registro['nome_motorista']) );
    $this->addDetalhe( array("Observa&ccedil;&atilde;o", $registro['observacao']));
    $this->url_novo = "../module/TransporteEscolar/Veiculo";
    $this->url_editar = "../module/TransporteEscolar/Veiculo?id={$cod_veiculo}";
    $this->url_cancelar = "transporte_veiculo_lst.php";

    $this->largura = "100%";

    $localizacao = new LocalizacaoSistema();
    $localizacao->entradaCaminhos( array(
         $_SERVER['SERVER_NAME']."/intranet" => "In&iacute;cio",
         "educar_index.php"                  => "i-Educar - Escola",
         ""                                  => "Detalhe do ve&iacute;culo"
    ));
    $this->enviaLocalizacao($localizacao->montar());    
  }
}

// Instancia o objeto da pgina
$pagina = new clsIndexBase();

// Instancia o objeto de contedo
$miolo = new indice();

// Passa o contedo para a pgina
$pagina->addForm($miolo);

// Gera o HTML
$pagina->MakeAll();
