<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   App_Model
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Entity.php';
require_once 'App/Model/MatriculaSituacao.php';

/**
 * App_Model_Matricula class.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   App_Model
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class App_Model_Matricula
{
  /**
   * Atualiza os dados da matrcula do aluno, promovendo-o ou retendo-o. Usa
   * uma instncia da classe legada clsPmieducarMatricula para tal.
   *
   * @param int $matricula
   * @param int $usuario
   * @param bool $aprovado
   * @return bool
   */
  public static function atualizaMatricula($matricula, $usuario, $aprovado = TRUE)
  {
    $instance = CoreExt_Entity::addClassToStorage('clsPmieducarMatricula', NULL,
      'include/pmieducar/clsPmieducarMatricula.inc.php');

    $instance->cod_matricula   = $matricula;
    $instance->ref_usuario_cad = $usuario;
    $instance->ref_usuario_exc = $usuario;

    if (is_int($aprovado))
      $instance->aprovado = $aprovado;
    else
    {
      $instance->aprovado        = ($aprovado == TRUE) ?
        App_Model_MatriculaSituacao::APROVADO :
        App_Model_MatriculaSituacao::REPROVADO;
    }

    return $instance->edita();
  }
}
