<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   App_Model
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Enum.php';

/**
 * App_Model_MatriculaSituacao class.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   App_Model
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class App_Model_MatriculaSituacao extends CoreExt_Enum
{
  const APROVADO            = 1;
  const REPROVADO           = 2;
  const EM_ANDAMENTO        = 3;
  const TRANSFERIDO         = 4;
  const RECLASSIFICADO      = 5;
  const ABANDONO            = 6;
  const EM_EXAME            = 7;
  const APROVADO_APOS_EXAME = 8;
  const RETIDO_FALTA        = 9;

  protected $_data = array(
    self::APROVADO            => 'Aprovado',
    self::REPROVADO           => 'Retido',
    self::EM_ANDAMENTO        => 'Em andamento',
    self::TRANSFERIDO         => 'Transferido',
    self::RECLASSIFICADO      => 'Reclassificado',
    self::ABANDONO            => 'Abandono',
    self::EM_EXAME            => 'Em exame',
    self::APROVADO_APOS_EXAME => 'Aprovado aps exame',
    self::RETIDO_FALTA        => 'Retido por falta'
  );

  public static function getInstance()
  {
    return self::_getInstance(__CLASS__);
  }
}