<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   App_Model
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Enum.php';

/**
 * App_Model_NivelAcesso class.
 *
 * Define os valores inteiros usados nas comparaes das verificaes de
 * acesso da classe clsPermissoes.
 *
 * Esses valores so verificados com o uso do operador binrio &, resultando
 * na seguinte tabela verdade:
 *
 * <code>
 * +------------------------+---+---+---+----+
 * | Nvel acessos          | 1 | 3 | 7 | 11 |
 * +------------------------+---+---+---+----+
 * | Poli-institucional (1) | T | T | T |  T |
 * +------------------------+---+---+---+----+
 * | Institucional      (2) | F | T | T |  T |
 * +------------------------+---+---+---+----+
 * | Escola             (4) | F | F | T |  F |
 * +------------------------+---+---+---+----+
 * | Biblioteca         (8) | F | F | F |  T |
 * +------------------------+---+---+---+----+
 *
 * Onde, T = TRUE; F = FALSE
 * </code>
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   App_Model
 * @see       clsPermissoes#permissao_cadastra
 * @see       clsPermissoes#permissao_excluir
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class App_Model_NivelAcesso extends CoreExt_Enum
{
  const POLI_INSTITUCIONAL = 1;
  const INSTITUCIONAL      = 3;
  const SOMENTE_ESCOLA     = 7;
  const SOMENTE_BIBLIOTECA = 11;

  protected $_data = array(
    self::POLI_INSTITUCIONAL => 'Poli-institucional',
    self::INSTITUCIONAL      => 'Institucional',
    self::SOMENTE_ESCOLA     => 'Somente escola',
    self::SOMENTE_BIBLIOTECA => 'Somente biblioteca'
  );

  public static function getInstance()
  {
    return self::_getInstance(__CLASS__);
  }
}