<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   Core_View
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'include/clsBase.inc.php';

/**
 * Core_View class.
 *
 * Prov mtodos getters/setters e alguns mtodos sobrescritos para facilitar
 * a gerao de pginas usando CoreExt_Controller_Page_Interface.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   Core_View
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class Core_View extends clsBase
{
  /**
   * Uma instncia de CoreExt_Controller_Page_Interface.
   * @var CoreExt_Controller_Page_Interface
   */
  protected $_pageController = NULL;

  /**
   * Construtor.
   * @param Core_Controller_Page_Interface $instance
   */
  public function __construct(Core_Controller_Page_Interface $instance)
  {
    parent::__construct();
    $this->_setPageController($instance);
  }

  /**
   * Setter.
   * @param Core_Controller_Page_Interface $instance
   * @return Core_View Prov interface fluda
   */
  protected function _setPageController(Core_Controller_Page_Interface $instance)
  {
    $this->_pageController = $instance;
    return $this;
  }

  /**
   * Getter.
   * @return CoreExt_Controller_Page_Interface
   */
  protected function _getPageController()
  {
    return $this->_pageController;
  }

  /**
   * Setter
   * @param string $titulo
   * @return Core_View Prov interface fluda
   */
  public function setTitulo($titulo)
  {
    parent::SetTitulo($titulo);
    return $this;
  }

  /**
   * Getter.
   * @return string
   */
  public function getTitulo()
  {
    return $this->titulo;
  }

  /**
   * Setter.
   * @param int $processo
   * @return Core_View Prov interface fluda
   */
  public function setProcessoAp($processo)
  {
    $this->processoAp = (int) $processo;
    return $this;
  }

  /**
   * Getter.
   * @return int
   */
  public function getProcessoAp()
  {
    return $this->processoAp;
  }

  /**
   * Configura algumas variveis de instncia usando o container global
   * $coreExt.
   *
   * @global $coreExt
   * @see clsBase#Formular()
   */
  public function Formular()
  {
    global $coreExt;
    $instituicao = $coreExt['Config']->app->template->vars->instituicao;

    $this->setTitulo($instituicao . ' | ' . $this->_getPageController()->getBaseTitulo())
         ->setProcessoAp($this->_getPageController()->getBaseProcessoAp());
  }

  /**
   * Executa o mtodo de gerao de HTML para a classe.
   * @param Core_View $instance
   */
  public static function generate($instance)
  {
    $viewBase = new self($instance);
    $viewBase->addForm($instance);
    $viewBase->MakeAll();
  }
}