<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Configurable
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

/**
 * CoreExt_Configurable interface.
 *
 * Essa interface tem como objetivo prover uma API uniforme para classes que
 * definem parmetros de configurao. Basicamente prov apenas o mtodo
 * pblico setOptions, que recebe um array de parmetros. Como o PHP no
 * permite herana mltipla, essa API apenas refora a idia de se criar uma
 * uniformidade entre as diferentes classes configurveis do i-Educar.
 *
 * Uma sugesto de implementao do mtodo setOptions  dada pelo exemplo a
 * seguir:
 * <code>
 * <?php
 * protected $_options = array(
 *   'option1' => NULL,
 *   'option2' => NULL
 * );
 *
 * public function setOptions(array $options = array())
 * {
 *   $defaultOptions = array_keys($this->getOptions());
 *   $passedOptions  = array_keys($options);
 *
 *   if (0 < count(array_diff($passedOptions, $defaultOptions))) {
 *     throw new InvalidArgumentException(
 *       sprintf('A classe %s no suporta as opes: %s.', get_class($this), implode(', ', $passedOptions))
 *     );
 *   }
 *
 *   $this->_options = array_merge($this->getOptions(), $options);
 *   return $this;
 * }
 *
 * public function getOptions()
 * {
 *   return $this->_options;
 * }
 * </code>
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Configurable
 * @since     Interface disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
interface CoreExt_Configurable
{
  /**
   * Setter.
   * @param  array $options
   * @return CoreExt_Configurable Prov interface fluda
   */
  public function setOptions(array $options = array());

  /**
   * Getter.
   * @return array
   */
  public function getOptions();
}