<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id: /ieducar/branches/teste/ieducar/lib/CoreExt/Controller/Front.php 645 2009-11-12T20:08:26.084511Z eriksen  $
 */

require_once 'CoreExt/Controller/Interface.php';

/**
 * CoreExt_Controller_Abstract abstract class.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
abstract class CoreExt_Controller_Abstract implements CoreExt_Controller_Interface
{
  /**
   * Uma instncia de CoreExt_Controller_Request_Interface
   * @var CoreExt_Controller_Request_Interface
   */
  protected $_request = NULL;

  /**
   * Uma instncia de CoreExt_Session_Abstract
   * @var CoreExt_Session_Abstract
   */
  protected $_session = NULL;

  /**
   * Uma instncia de CoreExt_Controller_Dispatcher_Interface
   * @var CoreExt_Controller_Dispatcher_Interface
   */
  protected $_dispatcher = NULL;

  /**
   * @see CoreExt_Configurable#setOptions($options)
   */
  public function setOptions(array $options = array())
  {
    $defaultOptions = array_keys($this->getOptions());
    $passedOptions  = array_keys($options);

    if (0 < count(array_diff($passedOptions, $defaultOptions))) {
      throw new InvalidArgumentException(
        sprintf('A classe %s no suporta as opes: %s.', get_class($this), implode(', ', $passedOptions))
      );
    }

    $this->_options = array_merge($this->getOptions(), $options);
    return $this;
  }

  /**
   * @see CoreExt_Configurable#getOptions()
   */
  public function getOptions()
  {
    return $this->_options;
  }

  /**
   * Verifica se uma opo est setada.
   *
   * @param string $key
   * @return bool
   */
  protected function _hasOption($key)
  {
    return array_key_exists($key, $this->_options);
  }

  /**
   * Retorna um valor de opo de configurao ou NULL caso a opo no esteja
   * setada.
   *
   * @param string $key
   * @return mixed|NULL
   */
  public function getOption($key)
  {
    return $this->_hasOption($key) ? $this->_options[$key] : NULL;
  }

  /**
   * Setter.
   * @param CoreExt_Controller_Request_Interface $request
   * @return CoreExt_Controller_Interface
   */
  public function setRequest(CoreExt_Controller_Request_Interface $request)
  {
    $this->_request = $request;
    return $this;
  }

  /**
   * Getter para uma instncia de CoreExt_Controller_Request_Interface.
   *
   * Instncia via lazy initialization uma instncia de
   * CoreExt_Controller_Request_Interface caso nenhuma seja explicitamente
   * atribuda a instncia atual.
   *
   * @return CoreExt_Controller_Request_Interface
   */
  public function getRequest()
  {
    if (is_null($this->_request)) {
      require_once 'CoreExt/Controller/Request.php';
      $this->setRequest(new CoreExt_Controller_Request());
    }
    return $this->_request;
  }

  /**
   * Setter.
   * @param CoreExt_Session_Abstract $session
   * @return CoreExt_Controller_Interface
   */
  public function setSession(CoreExt_Session_Abstract $session)
  {
    $this->_session = $session;
    return $this;
  }

  /**
   * Getter para uma instncia de CoreExt_Session.
   *
   * Instncia via lazy initialization uma instncia de CoreExt_Session caso
   * nenhuma seja explicitamente atribuda a instncia atual.
   *
   * @return CoreExt_Session
   */
  public function getSession()
  {
    if (is_null($this->_session)) {
      require_once 'CoreExt/Session.php';
      $this->setSession(new CoreExt_Session());
    }
    return $this->_session;
  }

  /**
   * Setter.
   * @param CoreExt_Controller_Dispatcher_Interface $dispatcher
   * @return CoreExt_Controller_Interface Prov interface fluda
   */
  public function setDispatcher(CoreExt_Controller_Dispatcher_Interface $dispatcher)
  {
    $this->_dispatcher = $dispatcher;
    return $this;
  }

  /**
   * Getter.
   * @return CoreExt_Controller_Dispatcher_Interface
   */
  public function getDispatcher()
  {
    if (is_null($this->_dispatcher)) {
      require_once 'CoreExt/Controller/Dispatcher/Standard.php';
      $this->setDispatcher(new CoreExt_Controller_Dispatcher_Standard());
    }
    return $this->_dispatcher;
  }

  /**
   * Redirect HTTP simples (espartanssimo).
   *
   * Se a URL for relativa, prefixa o caminho com o baseurl configurado para
   * o objeto CoreExt_Controller_Request.
   *
   * @param string $url
   * @todo Implementar opes de configurao de cdigo de status de
   *       redirecionamento. {@link http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html}
   */
  public function redirect($url)
  {
    $parsed = parse_url($url, PHP_URL_HOST);

    if ('' == $parsed['host']) {
      $url = $this->getRequest()->getBaseurl() . '/' . $url;
    }

    header(sprintf('Location: %s', $url));
  }
}