<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

/**
 * CoreExt_Controller_Dispatcher_Interface interface.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Interface disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
interface CoreExt_Controller_Dispatcher_Interface
{
  /**
   * Setter.
   * @param  CoreExt_Controller_Request_Interface $request
   * @return CoreExt_Controller_Dispatcher_Interface Prov interface fluda
   */
  public function setRequest(CoreExt_Controller_Request_Interface $request);

  /**
   * Getter.
   * @return CoreExt_Controller_Request_Interface
   */
  public function getRequest();

  /**
   * Retorna uma string correspondendo a parte de controller de uma URL.
   * @return string|NULL
   */
  public function getControllerName();

  /**
   * Retorna uma string correspondendo a parte de action de uma URL.
   * @return string|NULL
   */
  public function getActionName();
}