<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Controller/Dispatcher/Abstract.php';
require_once 'CoreExt/Controller/Dispatcher/Strategy/Interface.php';

/**
 * CoreExt_Controller_Dispatcher_Strategy_FrontStrategy class.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class CoreExt_Controller_Dispatcher_Strategy_FrontStrategy
  extends CoreExt_Controller_Dispatcher_Abstract
  implements CoreExt_Controller_Dispatcher_Strategy_Interface
{
  /**
   * Instncia de CoreExt_Controller_Interface.
   * @var CoreExt_Controller_Interface
   */
  protected $_controller = NULL;

  /**
   * Construtor.
   * @see CoreExt_Controller_Strategy_Interface#__construct($controller)
   */
  public function __construct(CoreExt_Controller_Interface $controller)
  {
    $this->setController($controller);
  }

  /**
   * @see CoreExt_Controller_Strategy_Interface#setController($controller)
   */
  public function setController(CoreExt_Controller_Interface $controller)
  {
    $this->_controller = $controller;
    return $this;
  }

  /**
   * @see CoreExt_Controller_Strategy_Interface#getController()
   */
  public function getController()
  {
    return $this->_controller;
  }

  /**
   * No implementado.
   * @see CoreExt_Controller_Strategy_Interface#dispatch()
   */
  public function dispatch()
  {
    require_once 'CoreExt/Controller/Dispatcher/Exception.php';
    throw new CoreExt_Controller_Dispatcher_Exception('Mtodo CoreExt_Controller_Strategy_FrontStrategy::dispatch() no implementado.');
  }
}