<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Controller/Request/Interface.php';

/**
 * CoreExt_Controller_Request class.
 *
 * Classe de gerenciamento de dados de uma requisio HTTP.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Controller
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class CoreExt_Controller_Request implements CoreExt_Controller_Request_Interface
{
  /**
   * Opes de configurao geral da classe.
   * @var array
   */
  protected $_options = array(
    'baseurl' => NULL
  );

  /**
   * Construtor.
   * @param array $options
   */
  public function __construct(array $options = array())
  {
    $this->setOptions($options);
  }

  /**
   * @see CoreExt_Configurable#setOptions($options)
   */
  public function setOptions(array $options = array())
  {
    $defaultOptions = array_keys($this->getOptions());
    $passedOptions  = array_keys($options);

    if (0 < count(array_diff($passedOptions, $defaultOptions))) {
      throw new InvalidArgumentException(
        sprintf('A classe %s no suporta as opes: %s.', get_class($this), implode(', ', $passedOptions))
      );
    }

    $this->_options = array_merge($this->getOptions(), $options);
    return $this;
  }

  /**
   * @see CoreExt_Configurable#getOptions()
   */
  public function getOptions()
  {
    return $this->_options;
  }

  /**
   * Verifica se uma opo est setada.
   *
   * @param string $key
   * @return bool
   */
  protected function _hasOption($key)
  {
    return array_key_exists($key, $this->_options);
  }

  /**
   * Retorna um valor de opo de configurao ou NULL caso a opo no esteja
   * setada.
   *
   * @param string $key
   * @return mixed|NULL
   */
  protected function _getOption($key)
  {
    return $this->_hasOption($key) ? $this->_options[$key] : NULL;
  }

  /**
   * Implementao do mtodo mgico __get().
   *
   * @param  string $key
   * @return mixed
   */
  public function __get($key)
  {
    switch (true) {
      case isset($_GET[$key]):
        return $_GET[$key];
      case isset($_POST[$key]):
        return $_POST[$key];
      case isset($_COOKIE[$key]):
        return $_COOKIE[$key];
      case isset($_SERVER[$key]):
        return $_SERVER[$key];
      default:
        break;
    }
    return NULL;
  }

  /**
   * Getter para as variveis de requisio.
   * @param string $key
   * @return mixed
   */
  public function get($key)
  {
    return $this->__get($key);
  }

  /**
   * Implementao do mtodo mgico __isset().
   *
   * @link   http://php.net/manual/en/language.oop5.overloading.php
   * @param  string $key
   * @return bool
   */
  public function __isset($key)
  {
    $val = $this->$key;
    return isset($val);
  }

  /**
   * Setter para a opo de configurao baseurl.
   * @param string $url
   * @return CoreExt_Controller_Request_Interface Prov interface fluda
   */
  public function setBaseurl($url)
  {
    $this->setOptions(array('baseurl' => $url));
    return $this;
  }

  /**
   * Getter para a opo de configurao baseurl.
   *
   * Caso a opo no esteja configurada, determina um valor baseado na
   * varivel $_SERVER['REQUEST_URI'] da requisio, usando apenas os
   * componentes scheme e path da URL. Veja {@link http://php.net/parse_url}
   * para mais informaes sobre os componentes de uma URL.
   *
   * @return string
   */
  public function getBaseurl()
  {
    if (is_null($this->_getOption('baseurl'))) {
      require_once 'CoreExt/View/Helper/UrlHelper.php';
      $url = CoreExt_View_Helper_UrlHelper::url(
        $this->get('REQUEST_URI'),
        array('absolute' => TRUE, 'components' => CoreExt_View_Helper_UrlHelper::URL_HOST)
      );
      $this->setBaseurl($url);
    }
    return $this->_getOption('baseurl');
  }
}