<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Entity
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Validate/Validatable.php';

/**
 * CoreExt_Entity_Validatable interface.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Entity
 * @since     Interface disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
interface CoreExt_Entity_Validatable extends CoreExt_Validate_Validatable
{
  /**
   * Configura uma coleo de CoreExt_Validate_Interface na instncia.
   * @return CoreExt_Entity Prov interface fluda
   */
  public function setValidatorCollection(array $validators);

  /**
   * Retorna um array de itens CoreExt_Validate_Interface da instncia.
   * @return array
   */
  public function getValidatorCollection();

  /**
   * Retorna um array de CoreExt_Validate_Interface padro para as propriedades
   * de CoreExt_Entity.
   *
   * Cada item do array precisa ser um item associativo com o mesmo nome do
   * atributo pblico definido pelo array $_data:
   *
   * <code>
   * <?php
   * // Uma classe concreta de CoreExt_Entity com as propriedades pblicas
   * // nome e telefone poderia ter os seguintes validadores.
   * array(
   *   'nome' => new CoreExt_Validate_Alpha(),
   *   'telefone' => new CoreExt_Validate_Alphanum()
   * );
   * </code>
   *
   * @return array
   */
  public function getDefaultValidatorCollection();
}