<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Enum
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Singleton.php';

/**
 * CoreExt_Enum abstract class.
 *
 * Prov uma interface simples de criao de instncias semelhantes a um
 * Enum do Java.
 *
 * As semelhanas so poucas mas a inteno  a de dar uma forma direta de
 * criar tipos enumerados. Para isso, basta subclassificar essa classe e prover
 * valores para o array $_data. Adicionalmente, prover constantes que ajudaram
 * ao usuario da classe a facilmente acessar os valores dos enumerados  uma
 * sugesto.
 *
 * O stub de teste CoreExt_Enum1Stub  um exemplo de como criar tipos
 * enumerados.
 *
 * Essa classe implementa tambm a interface ArrayAccess de SPL, provendo acesso
 * fcil aos valores do enumerado em uma forma de array:
 *
 * <code>
 * <?php
 * $enum = new Enum();
 * print $enum[Enum::ONE];
 * </code>
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @link      http://br2.php.net/manual/en/class.arrayaccess.php ArrayAccess interface
 * @package   CoreExt_Singleton
 * @since     Classe disponvel desde a verso 1.1.0
 * @todo      Verificar se  substituvel pela implementao de Enum disponvel
 *            em spl_types do Pecl {@link http://www.php.net/manual/en/splenum.construct.php SplEnum}.
 * @version   @@package_version@@
 */
abstract class CoreExt_Enum extends CoreExt_Singleton implements ArrayAccess
{
  /**
   * Array que emula um enum.
   * @var array
   */
  protected $_data = array();

  /**
   * Retorna o valor para um dado ndice de CoreExt_Enum.
   * @param  string|int $key
   * @return mixed
   */
  public function getValue($key)
  {
    return $this->_data[$key];
  }

  /**
   * Retorna todos os valores de CoreExt_Enum.
   * @return array
   */
  public function getValues()
  {
    return array_values($this->_data);
  }

  /**
   * Retorna o valor da ndice para um determinado valor.
   * @param  mixed $value
   * @return int|string
   */
  public function getKey($value)
  {
    return array_search($value, $this->_data);
  }

  /**
   * Retorna todos os ndices de CoreExt_Enum.
   * @return array
   */
  public function getKeys()
  {
    return array_keys($this->_data);
  }

  /**
   * Retorna o array de enums.
   * @return array
   */
  public function getEnums()
  {
    return $this->_data;
  }

  /**
   * Implementa offsetExists da interface ArrayAccess.
   * @link   http://br2.php.net/manual/en/arrayaccess.offsetexists.php
   * @param  string|int $offset
   * @return bool
   */
  public function offsetExists($offset)
  {
    return isset($this->_data[$offset]);
  }

  /**
   * Implementa offsetUnset da interface ArrayAccess.
   * @link  http://br2.php.net/manual/en/arrayaccess.offsetunset.php
   * @throws CoreExt_Exception
   */
  public function offsetUnset($offset)
  {
    require_once 'CoreExt/Exception.php';
    throw new CoreExt_Exception('Um "' . get_class($this) . '"  um objeto read-only.');
  }

  /**
   * Implementa offsetSet da interface ArrayAccess.
   *
   * Uma objeto CoreExt_Enum  apenas leitura.
   *
   * @link   http://br2.php.net/manual/en/arrayaccess.offsetset.php
   * @param  string|int $offset
   * @param  mixed $value
   * @throws CoreExt_Exception
   */
  public function offsetSet($offset, $value)
  {
    require_once 'CoreExt/Exception.php';
    throw new CoreExt_Exception('Um "' . get_class($this) . '"  um objeto read-only.');
  }

  /**
   * Implementa offsetGet da interface ArrayAccess.
   *
   * @link   http://br2.php.net/manual/en/arrayaccess.offsetget.php
   * @param  string|int $offset
   * @return mixed
   */
  public function offsetGet($offset)
  {
    return $this->_data[$offset];
  }
}