<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Session
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Session/Storage/Abstract.php';

/**
 * CoreExt_Session_Storage_Default class.
 *
 * Storage de session padro de CoreExt_Session, usa o mecanismo built-in do
 * PHP.
 *
 * Opes disponveis:
 * - session_use_cookies: se  para setar um cookie de session no browser do
 *   usurio. Usa o valor configurado no php.ini caso no informado
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Session
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class CoreExt_Session_Storage_Default extends CoreExt_Session_Storage_Abstract
{
  /**
   * @see CoreExt_Session_Storage_Abstract#_init()
   */
  protected function _init(array $options = array())
  {
    $options = array_merge(array(
      'session_use_cookies' => ini_get('session.use_cookies')
    ), $options);

    parent::_init($options);

    if (!is_null($this->getOption('session_name'))) {
      session_name($this->getOption('session_name'));
    }

    if (!is_null(self::$_sessionId)) {
      session_id(self::$_sessionId);
    }

    if (TRUE == $this->getOption('session_auto_start')) {
      $this->start();
    }
  }

  /**
   * @see CoreExt_Session_Storage_Interface#read($key)
   */
  public function read($key)
  {
    $returnValue = NULL;

    if (isset($_SESSION[$key])) {
      $returnValue = $_SESSION[$key];
    }

    return $returnValue;
  }

  /**
   * @see CoreExt_Session_Storage_Interface#write($key, $value)
   */
  public function write($key, $value)
  {
    $_SESSION[$key] = $value;
  }

  /**
   * @see CoreExt_Session_Storage_Interface#remove($key)
   */
  public function remove($key)
  {
    unset($_SESSION[$key]);
  }

  /**
   * @see CoreExt_Session_Storage_Interface#start()
   */
  public function start()
  {
    if (!$this->isStarted() && session_start()) {
      self::$_sessionStarted = TRUE;
      self::$_sessionId = session_id();
    }
  }

  /**
   * @see CoreExt_Session_Storage_Interface#destroy()
   */
  public function destroy()
  {
    if ($this->isStarted()) {
      return session_destroy();
    }
  }

  /**
   * @see CoreExt_Session_Storage_Interface#regenerate()
   */
  public function regenerate($destroy = FALSE)
  {
    if ($this->isStarted()) {
      session_regenerate_id($destroy);
      self::$_sessionId = session_id();
    }
  }

  /**
   * Persiste os dados da session no sistema de arquivos.
   * @see CoreExt_Session_Storage_Interface#shutdown()
   */
  public function shutdown()
  {
    if ($this->isStarted()) {
      session_write_close();
    }
  }

  /**
   * @link http://br.php.net/manual/en/countable.count.php
   */
  public function count()
  {
    return count($_SESSION);
  }

  /**
   * @see CoreExt_Session_Storage_Abstract#getSessionData()
   */
  public function getSessionData()
  {
    return $_SESSION;
  }
}