<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Session
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Configurable.php';

/**
 * CoreExt_Session_Storage_Interface interface.
 *
 * Interface mnima para que um storage de session possa ser criado. Define
 * os mtodos bsicos de escrita e inicializao/destruio de uma session.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Session
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
interface CoreExt_Session_Storage_Interface extends CoreExt_Configurable
{
  /**
   * Inicializa a session.
   */
  public function start();

  /**
   *
   * @param string $key
   * @return mixed
   */
  public function read($key);

  /**
   * Persiste um dado valor na session.
   * @param string $key
   * @param mixed $value
   */
  public function write($key, $value);

  /**
   * Remove/apaga um dado na session.
   * @param string $key
   */
  public function remove($key);

  /**
   * Destri os dados de uma session.
   */
  public function destroy();

  /**
   * Gera um novo id para a session.
   */
  public function regenerate($destroy = FALSE);

  /**
   * Persiste os dados da session no storage definido ao final da execuo
   * do script PHP.
   */
  public function shutdown();
}