<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Singleton
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

/**
 * CoreExt_Singleton abstract class.
 *
 * Funciona como uma interface de atalho para minimizar a duplicao de cdigo
 * para criar instncias singleton. Internamente, entretanto, funciona como um
 * {@link http://martinfowler.com/eaaCatalog/registry.html Registry} j que
 * todas as suas subclasses estaro armazenadas em um array esttico desta
 * classe.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @link      http://martinfowler.com/eaaCatalog/registry.html Registry pattern
 * @package   CoreExt_Singleton
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
abstract class CoreExt_Singleton
{
  /**
   * A instncia singleton de CoreExt_Singleton
   * @var array
   */
  private static $_instance = array();

  /**
   * Construtor.
   */
  private function __construct()
  {
  }

  /**
   * Sobrescreva esse mtodo para garantir que a subclasse possa criar um
   * singleton. Esta deve fazer uma chamada ao mtodo _getInstance, passando
   * uma string que tenha como valor o nome da classe. Uma forma conveniente
   * de fazer isso  chamando _getInstance passando como parmetro a constante
   * mgica __CLASS__.
   *
   * Exemplo:
   * <code>
   * <?php
   * ... // extends CoreExt_Singleton
   * public static function getInstance()
   * {
   *   return self::_getInstance(__CLASS__);
   * }
   * </code>
   *
   * @return CoreExt_Singleton
   */
  public static function getInstance()
  {
    require_once 'CoreExt/Exception.php';
    throw new CoreExt_Exception(' necessrio sobrescrever o mtodo "getInstance()" de CoreExt_Singleton.');
  }

  /**
   * Retorna uma instncia singleton, instanciando-a quando necessrio.
   *
   * @param  string $self  Nome da subclasse de CoreExt_Singleton que ser instanciada
   * @return CoreExt_Singleton
   */
  protected static function _getInstance($self)
  {
    if (!isset(self::$_instance[$self])) {
      self::$_instance[$self] = new $self();
    }
    return self::$_instance[$self];
  }
}