<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Validate
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Validate/Abstract.php';
require_once 'CoreExt/Locale.php';

/**
 * CoreExt_Validate_Numeric class.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Validate
 * @since     Classe disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
class CoreExt_Validate_Numeric extends CoreExt_Validate_Abstract
{
  /**
   * @see CoreExt_Validate_Abstract#_getDefaultOptions()
   */
  protected function _getDefaultOptions()
  {
    return array(
      'min'       => NULL,
      'max'       => NULL,
      'trim'      => FALSE,
      'invalid'   => 'O valor "@value" no  um tipo numrico',
      'min_error' => '"@value"  menor que o valor mnimo permitido (@min)',
      'max_error' => '"@value"  maior que o valor mximo permitido (@max)',
    );
  }

  /**
   * @see CoreExt_DataMapper#_getFindStatment($pkey) Sobre a converso com floatval()
   * @see CoreExt_Validate_Abstract#_validate($value)
   */
  protected function _validate($value)
  {
    if (FALSE === $this->getOption('required') && is_null($value)) {
      return TRUE;
    }

    if (!is_numeric($value)) {
      throw new Exception($this->_getErrorMessage('invalid', array('@value' => $value)));
    }

    // Converte usando floatval para evitar problemas com range do tipo int.
    $value = floatval($value);

    if ($this->_hasOption('min') &&
      $value < floatval($this->getOption('min'))) {
      throw new Exception($this->_getErrorMessage('min_error', array(
        '@value' => $value, '@min' => $this->getOption('min')
      )));
    }

    if ($this->_hasOption('max') &&
      $value > floatval($this->getOption('max'))) {
      throw new Exception($this->_getErrorMessage('max_error', array(
        '@value' => $value, '@max' => $this->getOption('max')
      )));
    }

    return TRUE;
  }

  /**
   * Realiza um sanitizao de acordo com o locale, para permitir que valores
   * flutuantes ou nmeros de preciso arbitrria utilizem a pontuao sem
   * localizao.
   *
   * @see CoreExt_Validate_Abstract#_sanitize($value)
   */
  protected function _sanitize($value)
  {
    $locale = CoreExt_Locale::getInstance();
    $decimalPoint = $locale->getCultureInfo('decimal_point');

    // Verifica se possui o ponto decimal do locale e substitui para o
    // padro do locale en_US (ponto ".")
    if (FALSE !== strstr($value, $decimalPoint)) {
      $value = strtr($value, $decimalPoint, '.');
      $value = floatval($value);
    }

    return parent::_sanitize($value);
  }
}