<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Validate
 * @since     Arquivo disponvel desde a verso 1.1.0
 * @version   $Id$
 */

require_once 'CoreExt/Validate/Choice.php';
require_once 'CoreExt/Validate/ChoiceMultiple.php';
require_once 'CoreExt/Validate/String.php';
require_once 'CoreExt/Validate/Numeric.php';

/**
 * CoreExt_Validatable interface.
 *
 * A classe que implementar essa interface ter definir mtodos que permitam
 * relacionar uma propriedade a um CoreExt_Validate_Interface, criando um
 * mecanismo simples e efetivo de validao.
 *
 * @author    Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category  i-Educar
 * @license   @@license@@
 * @package   CoreExt_Validate
 * @since     Interface disponvel desde a verso 1.1.0
 * @version   @@package_version@@
 */
interface CoreExt_Validate_Validatable
{
  /**
   * Retorna TRUE caso a propriedade seja vlida.
   *
   * @param  string $key
   * @return bool
   */
  public function isValid($key = '');

  /**
   * Configura um CoreExt_Validate_Interface para uma propriedade da classe.
   *
   * @param  string $key
   * @param  CoreExt_Validate_Interface $validator
   * @return CoreExt_Validate_Validatable Prov interface fluda
   */
  public function setValidator($key, CoreExt_Validate_Interface $validator);

  /**
   * Retorna a instncia CoreExt_Validate_Interface para uma propriedade da
   * classe ou NULL caso nenhum validador esteja atribudo.
   *
   * @param  string $key
   * @return CoreExt_Validate_Interface|NULL
   */
  public function getValidator($key);
}