<?php

/*
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 */

/*
 * Copyright (C) 2002 Jason Sheets <jsheets@shadonet.com>.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/**
 * mimetype class.
 *
 * Essa classe  uma modificao da classe mimetype de Jason Sheets. A classe
 * original  distribuda sobre uma licena BSD. Essa classe estava modificada
 * dentro do arquivo intranet/download.php mas para melhorar a testabilidade,
 * foi refatorada para a sua prpria classe novamente.
 *
 * Essa classe poder a vir ser depreciada em favor do uso da extenso PECL
 * {@link http://php.net/fileinfo fileinfo} do PHP 5.2 (no core na verso 5.3).
 * No entanto, essa dependncia s dever ser implantada quando um instalador
 * ou processo de verificao de dependncia estiver disponvel.
 *
 * @author   Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @author   Jason Sheets <jsheets@shadonet.com>
 * @license  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt  CC GNU GPL
 * @license  http://opensource.org/licenses/bsd-license.php  BSD License
 * @link     http://www.phpclasses.org/browse/file/2743.html  Cdigo fonte original
 * @package  Core
 * @since    Classe disponvel desde a verso 1.1.0
 * @todo     Verificar dual-licensing do arquivo
 * @todo     Substituir por fileinfo e adicionar dependncia na aplicao
 * @version  $Id$
 */
class Mimetype
{

  public function getType($filename)
  {
    $filename = basename($filename);
    $filename = explode('.', $filename);
    $filename = $filename[count($filename)-1];

    return $this->privFindType($filename);
  }

  protected function privFindType($ext)
  {
    $mimetypes = $this->privBuildMimeArray();

    if (isset($mimetypes[$ext])) {
      return $mimetypes[$ext];
    }
    else {
      return FALSE;
    }
  }

  protected function privBuildMimeArray() {
    return array(
      'doc' => 'application/msword',
      'odt' => 'application/vnd.oasis.opendocument.text',
      'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
      'pdf' => 'application/pdf',
      'xls' => 'application/vnd.ms-excel',
    );
  }
}