-- //

--
-- Corrige permisses do usurio administrador.
-- 
-- Adiciona as permisses dos mdulos rea de Conhecimento, Avaliao,
-- Componente Curricular, Frmula Mdia, Regra de Avaliao e Tabela de
-- Arredondamento.
--
-- Remove as permisses dos cadastros de Disciplina, Tipo de Avaliao e
-- Nota Turma, j que se tornaram obsoletos com a incluso dos mdulos acima
-- como padres da aplicao.
--
-- Inclui novas imagens do iconset FAMFAMFAM silk icons, utilizados para
-- estilizar os links de menu dos mdulos adicionados.
--
-- @author   Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
-- @license  @@license@@
-- @version  $Id$
--

-- Apaga permisso para disciplina
DELETE FROM pmicontrolesis.menu WHERE ref_cod_menu_submenu = 557;
DELETE FROM portal.menu_funcionario WHERE ref_cod_menu_submenu = 557;
DELETE FROM pmieducar.menu_tipo_usuario WHERE ref_cod_menu_submenu = 557;
DELETE FROM portal.menu_submenu WHERE cod_menu_submenu = 557;

-- Apaga permisso para tipo de avaliao
DELETE FROM pmicontrolesis.menu WHERE ref_cod_menu_submenu = 560;
DELETE FROM portal.menu_funcionario WHERE ref_cod_menu_submenu = 560;
DELETE FROM pmieducar.menu_tipo_usuario WHERE ref_cod_menu_submenu = 560;
DELETE FROM portal.menu_submenu WHERE cod_menu_submenu = 560;

-- Apaga permisso para nota turma
DELETE FROM pmicontrolesis.menu WHERE ref_cod_menu_submenu = 650;
DELETE FROM portal.menu_funcionario WHERE ref_cod_menu_submenu = 650;
DELETE FROM pmieducar.menu_tipo_usuario WHERE ref_cod_menu_submenu = 650;
DELETE FROM portal.menu_submenu WHERE cod_menu_submenu = 650;

-- Imagens do iconset FAMFAMFAM (http://famfamfam.com/lab/icons/silk/)
INSERT INTO portal.imagem VALUES (187, 1, 'book.png', 'FAMFAMFAM iconset: book.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (188, 1, 'book_add.png', 'FAMFAMFAM iconset: book_add.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (189, 1, 'book_go.png', 'FAMFAMFAM iconset: book_go.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (190, 1, 'layout.png', 'FAMFAMFAM iconset: layout.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (191, 1, 'layout_add.png', 'FAMFAMFAM iconset: layout_add.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (192, 1, 'layout_content.png', 'FAMFAMFAM iconset: layout_content.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (193, 1, 'book_previous.png', 'FAMFAMFAM iconset: book_previous.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (194, 1, 'book_error.png', 'FAMFAMFAM iconset: book_error.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (195, 1, 'cog.png', 'FAMFAMFAM iconset: cog.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (196, 1, 'cog_add.png', 'FAMFAMFAM iconset: cog_add.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (197, 1, 'cog_go.png', 'FAMFAMFAM iconset: cog_go.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (198, 1, 'calculator.png', 'FAMFAMFAM iconset: calculator.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);
INSERT INTO portal.imagem VALUES (199, 1, 'calendar_link.png', 'FAMFAMFAM iconset: calendar_link.png', 'png', 16, 16, 'NOW()', 1, NULL, NULL);

-- Itens de submenu (permisses) dos mdulos de avaliao
INSERT INTO portal.menu_submenu VALUES (945, 55, 2, 'reas de Conhecimento', 'module/AreaConhecimento/index', '', 3);
INSERT INTO portal.menu_submenu VALUES (946, 55, 2, 'Componentes Curriculares', 'module/ComponenteCurricular/index', '', 3);
INSERT INTO portal.menu_submenu VALUES (947, 55, 2, 'Regras de Avaliao', 'module/RegraAvaliacao/index', '', 3);
INSERT INTO portal.menu_submenu VALUES (948, 55, 2, 'Frmula de Clculo de Mdia', 'module/FormulaMedia/index', '', 3);
INSERT INTO portal.menu_submenu VALUES (949, 55, 2, 'Tabelas de Arredondamento de Nota', 'module/TabelaArredondamento/index', '', 3);

-- Apaga todos os dados do menu suspenso
TRUNCATE TABLE pmicontrolesis.menu;

-- Reinsere os dados do menu
INSERT INTO pmicontrolesis.menu VALUES (4624, 335, NULL, 'Super Usurio', 4, 'otopic_su_lst.php', '_self', 1, 7, 1);
INSERT INTO pmicontrolesis.menu VALUES (15870, 597, 15858, 'Tipo de Exemplar', 6, 'educar_exemplar_tipo_lst.php', '_self', 1, 16, 177);
INSERT INTO pmicontrolesis.menu VALUES (15871, 596, 15858, 'Tipo de Cliente', 7, 'educar_cliente_tipo_lst.php', '_self', 1, 16, 62);
INSERT INTO pmicontrolesis.menu VALUES (15875, 629, 15858, 'Dados Biblioteca', 12, 'educar_biblioteca_dados_lst.php', '_self', 1, 16, 143);
INSERT INTO pmicontrolesis.menu VALUES (15860, 591, 15858, 'Biblioteca', 1, 'educar_biblioteca_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15858, NULL, NULL, 'Cadastro', 1, NULL, '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15861, 603, 15859, 'Cliente', 1, 'educar_cliente_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15863, 622, 15859, 'Dvidas', 2, 'educar_pagamento_multa_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15864, 610, 15859, 'Emprstimo', 3, 'educar_exemplar_emprestimo_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15867, 628, 15859, 'Devoluo', 4, 'educar_exemplar_devolucao_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15869, 609, 15858, 'Reservas', 6, 'educar_reservas_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15877, 592, 15858, 'Assunto', 14, 'educar_acervo_assunto_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15878, 598, 15858, 'Obras', 15, 'educar_acervo_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15879, 606, 15858, 'Exemplares', 16, 'educar_exemplar_lst.php', '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (15859, NULL, NULL, 'Movimentao', 2, NULL, '_self', 1, 16, 1);
INSERT INTO pmicontrolesis.menu VALUES (21122, NULL, NULL, 'Cadastros', 1, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21123, NULL, NULL, 'Servidores', 2, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21124, NULL, NULL, 'Movimentao', 3, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21125, NULL, NULL, 'Administrativo', 4, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21126, NULL, NULL, 'Relatrios', 5, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21127, NULL, NULL, 'Documentos', 6, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21128, 559, 21122, 'Instituio', 1, 'educar_instituicao_lst.php', '_self', 1, 15, 26);
INSERT INTO pmicontrolesis.menu VALUES (21129, 772, 21126, 'Quadro Sinttico Alunos', 1, 'educar_relatorio_quadro_alunos_sintetico.php', '_self', 1, 15, 115);
INSERT INTO pmicontrolesis.menu VALUES (21130, 635, 21123, 'Cadastrar', 1, 'educar_servidor_lst.php', '_self', 1, 15, 168);
INSERT INTO pmicontrolesis.menu VALUES (21131, 554, 21125, 'Tipo de Usurio', 1, 'educar_tipo_usuario_lst.php', '_self', 1, 15, 111);
INSERT INTO pmicontrolesis.menu VALUES (21132, 652, 21126, 'Relao de Alunos ANEEs', 1, 'educar_relatorio_relacao_aluno_pnee_escola.php', '_self', 1, 15, 142);
INSERT INTO pmicontrolesis.menu VALUES (21133, 674, 21127, 'Boletim Escolar', 1, 'educar_relatorio_boletim.php', '_self', 1, 15, 110);
INSERT INTO pmicontrolesis.menu VALUES (21134, 639, 21124, 'Reserva de Vaga', 1, 'educar_reserva_vaga_lst.php', '_self', 1, 15, 36);
INSERT INTO pmicontrolesis.menu VALUES (21135, 900, 21126, 'Alunos ANEEs Instituio', 2, 'educar_relatorio_relacao_qtd_aluno_pnee_escola.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21136, 664, 21127, 'Dirio de Frequncia', 2, 'educar_relatorio_diario_classe.php', '_self', 1, 15, 122);
INSERT INTO pmicontrolesis.menu VALUES (21137, 641, 21124, 'Quadro de Horrio', 2, 'educar_quadro_horario_lst.php', '_self', 1, 15, 105);
INSERT INTO pmicontrolesis.menu VALUES (21138, 653, 21126, 'Demonstrativo Alunos Defasados', 2, 'educar_relatorio_demonstrativo_defasado.php', '_self', 1, 15, 82);
INSERT INTO pmicontrolesis.menu VALUES (21139, 555, 21125, 'Usurios', 2, 'educar_usuario_lst.php', '_self', 1, 15, 141);
INSERT INTO pmicontrolesis.menu VALUES (21140, NULL, 21122, 'Curso', 2, NULL, '_self', 1, 15, 20);
INSERT INTO pmicontrolesis.menu VALUES (21141, 786, 21126, 'Demonst. Aluno Defasado Geral', 3, 'educar_relatorio_demonstrativo_defasado_geral.php', '_self', 1, 15, 84);
INSERT INTO pmicontrolesis.menu VALUES (21142, 654, 21126, 'Controle Desempenho de Alunos', 3, 'educar_relatorio_controle_bim_desempenho.php', '_self', 1, 15, 111);
INSERT INTO pmicontrolesis.menu VALUES (21144, 659, 21124, 'Enturmao', 3, 'educar_matriculas_turma_lst.php', '_self', 1, 15, 145);
INSERT INTO pmicontrolesis.menu VALUES (21145, 670, 21127, 'Dirio de Avaliaes', 3, 'educar_relatorio_diario_classe_avaliacao.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21146, 632, 21123, 'Escolaridade', 3, 'educar_escolaridade_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21147, NULL, 21122, 'Componentes Curriculares', 3, NULL, '_self', 1, 15, 190);
INSERT INTO pmicontrolesis.menu VALUES (21148, 746, 21127, 'Histrico Escolar', 4, 'educar_relatorio_historico_escolar.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21149, 661, 21126, 'Relatrio Mov, Mensal Alunos', 4, 'educar_relatorio_mov_mensal_aluno.php', '_self', 1, 15, 104);
INSERT INTO pmicontrolesis.menu VALUES (21150, NULL, 21122, 'Srie', 4, NULL, '_self', 1, 15, 37);
INSERT INTO pmicontrolesis.menu VALUES (21151, 633, 21123, 'Motivo de Afastamento', 4, 'educar_motivo_afastamento_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21152, 642, 21124, 'Faltas/Notas', 4, 'educar_falta_nota_aluno_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21153, 634, 21123, 'Funo', 5, 'educar_funcao_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21155, 927, 21127, 'Dirio de Frequncia Temp.', 5, 'educar_relatorio_diario_classe_temp.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21156, 829, 21123, 'Categoria Nveis', 5, 'educar_categoria_nivel_lst.php', '_self', 1, 15, 20);
INSERT INTO pmicontrolesis.menu VALUES (21157, 587, 21122, 'Sequncia de Enturmao', 5, 'educar_sequencia_serie_lst.php', '_self', 1, 15, 145);
INSERT INTO pmicontrolesis.menu VALUES (21158, NULL, 21123, 'Relatrios Servidores', 6, NULL, '_self', 1, 15, 176);
INSERT INTO pmicontrolesis.menu VALUES (21159, 584, 21122, 'Mdulos', 6, 'educar_modulo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21160, 845, 21124, 'Rematrcula Automtica', 6, 'educar_avancar_mod_cad.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21161, NULL, 21122, 'Escola', 7, NULL, '_self', 1, 15, 91);
INSERT INTO pmicontrolesis.menu VALUES (21162, NULL, 21122, 'Infra Estrutura', 8, NULL, '_self', 1, 15, 108);
INSERT INTO pmicontrolesis.menu VALUES (21163, 684, 21126, 'Relao dos Alunos Enturmados', 8, 'educar_relatorio_alunos_enturmados.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21164, 685, 21126, 'Relao dos Alunos NEnturmados', 9, 'educar_relatorio_alunos_nao_enturmados.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21165, NULL, 21122, 'Turma', 9, NULL, '_self', 1, 15, 141);
INSERT INTO pmicontrolesis.menu VALUES (21166, 696, 21126, 'Quadro Curricular', 9, 'educar_relatorio_quadro_curricular.php', '_self', 1, 15, 105);
INSERT INTO pmicontrolesis.menu VALUES (21167, 807, 21126, 'Espelho de Notas', 10, 'educar_relatorio_alunos_nota_semestre.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21168, 811, 21126, 'Espelho de Notas Bimestral', 10, 'educar_relatorio_alunos_nota_semestre_disc.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21169, NULL, 21122, 'Calendrio Letivo', 10, NULL, '_self', 1, 15, 104);
INSERT INTO pmicontrolesis.menu VALUES (21170, 631, 21122, 'Deficincias', 11, 'educar_deficiencia_lst.php', '_self', 1, 15, 142);
INSERT INTO pmicontrolesis.menu VALUES (21171, NULL, 21122, 'Aluno', 12, NULL, '_self', 1, 15, 62);
INSERT INTO pmicontrolesis.menu VALUES (21172, NULL, 21122, 'Material Didtico', 13, NULL, '_self', 1, 15, 126);
INSERT INTO pmicontrolesis.menu VALUES (21173, 580, 21122, 'Tipos de Ocorrncias', 13, 'educar_tipo_ocorrencia_disciplinar_lst.php', '_self', 1, 15, 194);
INSERT INTO pmicontrolesis.menu VALUES (21174, 575, 21122, 'Tipo de Transferncia', 14, 'educar_transferencia_tipo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21175, 707, 21126, 'Alunos Matriculados Sinttico', 15, 'educar_relatorio_alunos_matriculados_sintetico.php', '_self', 1, 15, 62);
INSERT INTO pmicontrolesis.menu VALUES (21176, NULL, 21122, 'Tipos', 15, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21177, NULL, 21122, 'Pr-Requisito', 16, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21178, 711, 21126, 'Documentos Pendentes', 17, 'educar_relatorio_documentos_pendentes.php', '_self', 1, 15, 153);
INSERT INTO pmicontrolesis.menu VALUES (21179, NULL, 21126, 'Relao de Alunos ANNEs - qtd', 22, NULL, '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21180, 911, 21126, 'Ficha de Rematrcula', 22, 'educar_relatorio_ficha_rematricula.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21181, 835, 21124, 'Relatrio Quadros de Horrio', 25, 'educar_relatorio_quadro_horario.php', '_self', 1, 15, 105);
INSERT INTO pmicontrolesis.menu VALUES (21182, 916, 21126, 'Registro de Trans. Expedidas', 25, 'educar_relatorio_registro_transferencias.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21183, 774, 21126, 'Relatrio Alunos Idade x Sexo', 25, 'educar_relatorio_quadro_idade_sexo_serie.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21184, 917, 21126, 'Alunos 5 Avaliao', 26, 'educar_relatorio_alunos_quinta_avaliacao.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21185, 918, 21126, 'Ata Resultado Final', 28, 'educar_relatorio_ata_resultado_final.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21186, 836, 21126, 'Relatrio de alunos por idade', 30, 'educar_relatorio_alunos_idade.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21187, 823, 21126, 'Resultado Final', 30, 'educar_relatorio_resultado_final.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21188, 930, 21126, 'Levantamento Alfab. e no Alf.', 30, 'educar_relatorio_alfabetizados.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21189, 830, 21126, 'Alunos Benefcios', 30, 'educar_relatorio_alunos_beneficios.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21190, 824, 21126, 'Acompanhamento Mensal', 31, 'educar_relatorio_acompanhamento_mensal.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21191, 933, 21126, 'Levantamento Turma Perodo', 31, 'educar_relatorio_levantamento_turma_periodo_aluno.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21192, 944, 21126, 'Demons. Alu. Defasados Nominal', 31, 'educar_alunos_defasados_nominal.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21193, 825, 21126, 'Ficha de Leitura Escrita', 33, 'educar_relatorio_ficha_leitura.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21194, 826, 21126, 'Acompanhamento Leitura', 35, 'educar_relatorio_acompanhamento_leitura_livros.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21195, 946, 21147, 'Listar Componentes', 0, 'module/ComponenteCurricular/index', '_self', 1, 15, 192);
INSERT INTO pmicontrolesis.menu VALUES (21197, 586, 21165, 'Cadastrar', 1, 'educar_turma_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21198, 561, 21161, 'Cadastrar', 1, 'educar_escola_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21199, 620, 21169, 'Calendrios', 1, 'educar_calendario_ano_letivo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21200, 567, 21162, 'Prdios', 1, 'educar_infra_predio_lst.php', '_self', 1, 15, 147);
INSERT INTO pmicontrolesis.menu VALUES (21201, 583, 21150, 'Cadastrar', 1, 'educar_serie_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21202, 566, 21140, 'Cadastrar', 1, 'educar_curso_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21203, 690, 21158, 'Relatrios Professores', 1, 'educar_relatorio_quadro_professores.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21204, 569, 21172, 'Materiais', 1, 'educar_material_didatico_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21205, 578, 21171, 'Alunos', 1, 'educar_aluno_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21206, 945, 21147, 'reas de Conhecimento', 1, 'module/AreaConhecimento/index', '_self', 1, 15, 189);
INSERT INTO pmicontrolesis.menu VALUES (21207, 574, 21162, 'Comodo Prdio', 2, 'educar_infra_predio_comodo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21208, 573, 21140, 'Habilitao', 2, 'educar_habilitacao_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21209, 576, 21169, 'Motivos', 2, 'educar_calendario_dia_motivo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21210, 581, 21171, 'Benefcios', 2, 'educar_aluno_beneficio_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21211, 562, 21161, 'Localizao', 2, 'educar_escola_localizacao_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21212, 563, 21172, 'Tipo Material', 2, 'educar_material_tipo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21213, 577, 21147, 'Tipos de Dispensa', 2, 'educar_tipo_dispensa_lst.php', '_self', 1, 15, 193);
INSERT INTO pmicontrolesis.menu VALUES (21214, 827, 21158, 'Professores por Disciplina', 2, 'educar_relatorio_professor_disciplina.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21215, 570, 21165, 'Tipo', 2, 'educar_turma_tipo_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21216, 585, 21150, 'Escola-Srie', 3, 'educar_escola_serie_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21217, 831, 21158, 'Servidores por Nvel', 3, 'educar_relatorio_servidor_nivel.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21218, 647, 21161, 'Rede de Ensino', 3, 'educar_escola_rede_ensino_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21219, 579, 21171, 'Religio', 3, 'educar_religiao_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21220, 568, 21140, 'Tipo de Regime', 3, 'educar_tipo_regime_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21221, 572, 21162, 'Funo Cmodo', 3, 'educar_infra_comodo_funcao_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21222, 558, 21140, 'Tipo de Ensino', 4, 'educar_tipo_ensino_lst.php', '_self', 1, 15, 124);
INSERT INTO pmicontrolesis.menu VALUES (21223, 678, 21171, 'Raa', 4, 'educar_raca_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21224, 571, 21140, 'Nvel Ensino', 5, 'educar_nivel_ensino_lst.php', '_self', 1, 15, 1);
INSERT INTO pmicontrolesis.menu VALUES (21226, NULL, 21122, 'Regras de Avaliao', 2, NULL, '_self', 1, 15, 195);
INSERT INTO pmicontrolesis.menu VALUES (21227, 947, 21226, 'Listar Regras', 0, 'module/RegraAvaliacao/index', '_self', 1, 15, 197);
INSERT INTO pmicontrolesis.menu VALUES (21228, 948, 21226, 'Frmulas de Clculo de Mdia', 1, 'module/FormulaMedia/index', '_self', 1, 15, 198);
INSERT INTO pmicontrolesis.menu VALUES (21229, 949, 21226, 'Tabelas de Arredondamento', 2, 'module/TabelaArredondamento/index', '_self', 1, 15, 199);
INSERT INTO pmicontrolesis.menu VALUES (21230, 693, 21126, 'Registro de Matrculas', 30, 'educar_relatorio_registro_matriculas.php', '_self', 1, 15, 1);
 
-- Corrige permisses para o usurio do tipo Administrador
DELETE FROM menu_tipo_usuario WHERE ref_cod_tipo_usuario = 1;
 
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 826, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 824, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 578, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 917, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 707, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 624, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 918, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 581, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 674, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 620, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 576, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 829, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 946, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 654, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 566, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 574, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 631, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 653, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 786, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 944, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 664, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 670, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 927, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 711, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 659, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 561, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 562, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 585, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 632, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 807, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 811, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 642, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 825, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 911, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 572, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 634, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 948, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 573, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 746, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 559, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 930, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 933, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 569, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 633, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 584, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 571, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 827, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 567, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 696, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 641, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 772, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 678, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 647, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 693, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 916, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 947, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 836, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 830, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 774, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 684, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 685, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 661, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 835, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 690, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 652, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 900, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 579, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 845, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 639, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 823, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 587, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 635, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 831, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 583, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 949, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 577, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 558, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 563, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 580, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 568, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 575, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 586, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 570, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 945, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 625, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 592, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 594, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 591, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 603, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 593, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 629, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 628, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 622, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 595, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 610, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 606, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 608, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 590, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 600, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 607, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 598, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 609, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 602, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 596, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (1, 597, 1, 1, 1);

-- Corrige as permisses para o usurio do tipo Escola, adiciona permisses
-- ausentes
INSERT INTO pmieducar.menu_tipo_usuario VALUES (2, 946, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (2, 948, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (2, 947, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (2, 949, 1, 1, 1);
INSERT INTO pmieducar.menu_tipo_usuario VALUES (2, 945, 1, 1, 1);

-- Apaga todas as permisses do usurio administrador e as atribui novamente
DELETE FROM portal.menu_funcionario WHERE ref_ref_cod_pessoa_fj = 1;

INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 0);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 104);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 109);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 114);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 115);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 116);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 135);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 136);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 137);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 138);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 154);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 158);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 159);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 170);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 190);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 209);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 239);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 240);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 241);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 244);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 26);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 27);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 29);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 293);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 294);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 295);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 296);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 297);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 299);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 332);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 333);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 335);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 336);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 337);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 34);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 341);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 343);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 345);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 35);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 36);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 375);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 41);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 43);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 445);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 459);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 473);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 551);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 552);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 553);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 588);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 604);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 605);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 611);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 612);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 613);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 648);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 666);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 669);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 694);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 741);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 753);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 754);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 755);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 756);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 757);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 758);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 773);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 79);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 85);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 86);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 87);
INSERT INTO portal.menu_funcionario VALUES (1, 0, 0, 89);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 554);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 555);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 826);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 824);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 578);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 917);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 707);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 624);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 918);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 581);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 674);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 620);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 576);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 829);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 946);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 654);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 566);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 574);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 631);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 653);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 786);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 944);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 664);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 670);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 927);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 711);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 659);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 561);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 562);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 585);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 632);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 807);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 811);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 642);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 825);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 911);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 572);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 634);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 948);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 573);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 746);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 559);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 930);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 933);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 569);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 633);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 584);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 571);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 827);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 567);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 696);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 641);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 772);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 678);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 647);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 693);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 916);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 947);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 836);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 830);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 774);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 684);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 685);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 661);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 835);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 690);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 652);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 900);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 579);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 845);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 639);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 823);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 587);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 635);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 831);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 583);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 949);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 577);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 558);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 563);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 580);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 568);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 575);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 586);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 570);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 945);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 625);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 592);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 594);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 591);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 603);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 593);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 629);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 628);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 622);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 595);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 610);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 606);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 608);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 590);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 600);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 607);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 598);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 609);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 602);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 596);
INSERT INTO portal.menu_funcionario VALUES (1, 1, 1, 597);

-- //@UNDO

-- //