-- //

--
-- Cria as tabelas modules.educacenso_ies e modules.educacenso_curso_superior,
-- populando com dados padro do Educacenso 2010.
--
-- @author   Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
-- @license  @@license@@
-- @version  $Id$
--

CREATE TABLE modules.educacenso_ies
(
  id serial,
  ies_id integer NOT NULL,
  nome character varying(255) NOT NULL,
  dependencia_administrativa_id integer NOT NULL,
  tipo_instituicao_id integer NOT NULL,
  uf character(2),
  user_id integer NOT NULL,
  created_at timestamp without time zone NOT NULL,
  updated_at timestamp without time zone,
  CONSTRAINT educacenso_ies_pk PRIMARY KEY (id)
) WITH (OIDS=FALSE);


CREATE TABLE modules.educacenso_curso_superior
(
  id serial,
  curso_id character varying(100) NOT NULL,
  nome character varying(255) NOT NULL,
  classe_id integer NOT NULL,
  user_id integer NOT NULL,
  created_at timestamp without time zone NOT NULL,
  updated_at timestamp without time zone,
  CONSTRAINT educacenso_curso_superior_pk PRIMARY KEY (id)
) WITH (OIDS=FALSE);

-- Instituies de Ensino Superior (IES), de acordo com o Educacenso 2010.
SELECT pg_catalog.setval('educacenso_ies_id_seq', 5301, true);

INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1, 1, 'UNIVERSIDADE FEDERAL DE MATO GROSSO', 1, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2, 2, 'UNIVERSIDADE DE BRASLIA', 1, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3, 3, 'UNIVERSIDADE FEDERAL DE SERGIPE', 1, 1, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4, 4, 'UNIVERSIDADE FEDERAL DO AMAZONAS', 1, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (5, 5, 'UNIVERSIDADE FEDERAL DO PIAU', 1, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (6, 6, 'UNIVERSIDADE FEDERAL DE OURO PRETO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (7, 7, 'UNIVERSIDADE FEDERAL DE SO CARLOS', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (8, 8, 'FUNDAO UNIVERSIDADE FEDERAL DE VIOSA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (9, 9, 'UNIVERSIDADE ESTADUAL DE LONDRINA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (10, 10, 'PONTIFCIA UNIVERSIDADE CATLICA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (11, 11, 'UNIVERSIDADE CATLICA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (12, 12, 'FUNDAO UNIVERSIDADE FEDERAL DO RIO GRANDE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (13, 13, 'UNIVERSIDADE DE CAXIAS DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (14, 14, 'UNIVERSIDADE DO VALE DO RIO DOS SINOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (15, 15, 'UNIVERSIDADE CATLICA DE PETRPOLIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (16, 16, 'UNIVERSIDADE GAMA FILHO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (17, 17, 'UNIVERSIDADE FEDERAL DE UBERLNDIA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (18, 18, 'UNIVERSIDADE CATLICA DE PELOTAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (19, 19, 'PONTIFCIA UNIVERSIDADE CATLICA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (20, 20, 'UNIVERSIDADE DE PASSO FUNDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (21, 21, 'PONTIFCIA UNIVERSIDADE CATLICA DO RIO GRANDE DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (22, 22, 'UNIVERSIDADE PRESBITERIANA MACKENZIE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (23, 23, 'CENTRO UNIVERSITRIO FEEVALE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (24, 24, 'UNIVERSIDADE ESTADUAL DE SANTA CRUZ', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (25, 26, 'ESCOLA NACIONAL DE CINCIAS ESTATSTICAS', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (26, 27, 'UNIVERSIDADE VALE DO RIO VERDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (27, 29, 'UNIVERSIDADE ESTADUAL DO CEAR', 2, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (28, 30, 'UNIVERSIDADE JOS DO ROSRIO VELLANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (29, 31, 'CENTRO DE EDUCAO TCNICA DA UTRAMIG', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (30, 32, 'UNIVERSIDADE ESTADUAL DE CINCIAS DA SADE DE ALAGOAS - UNCISAL', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (31, 33, 'FACULDADE DE TECNOLOGIA DE SOROCABA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (32, 34, 'FACULDADE DE TECNOLOGIA DE SO PAULO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (33, 35, 'FACULDADE DE TECNOLOGIA DE AMERICANA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (34, 36, 'FACULDADE DE TECNOLOGIA DA BAIXADA SANTISTA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (35, 37, 'FACULDADE DE TECNOLOGIA DE JAHU', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (36, 38, 'UNIVERSIDADE DO ESTADO DO PAR', 2, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (37, 39, 'INSTITUTO DE TECNOLOGIA DA AMAZNIA', 2, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (38, 40, 'UNIVERSIDADE DO ESTADO DA BAHIA', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (39, 41, 'FACULDADE ESTADUAL DE EDUCAO FSICA DE JACAREZINHO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (40, 42, 'FACULDADE ESTADUAL DE DIREITO DO NORTE PIONEIRO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (41, 43, 'FUNDAO UNIVERSIDADE DO ESTADO DE SANTA CATARINA', 2, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (42, 44, 'FACULDADE DE ENGENHARIA CIVIL DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (43, 45, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (44, 46, 'FACULDADE ESTADUAL DE CINCIAS ECONMICAS DE APUCARANA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (45, 47, 'UNIVERSIDADE ESTADUAL DE GOIS', 2, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (46, 54, 'UNIVERSIDADE ESTADUAL DE CAMPINAS', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (47, 55, 'UNIVERSIDADE DE SO PAULO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (48, 56, 'UNIVERSIDADE ESTADUAL PAULISTA JLIO DE MESQUITA FILHO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (49, 57, 'UNIVERSIDADE ESTADUAL DE MARING', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (50, 58, 'FACULDADE DE DIREITO DE SO BERNARDO DO CAMPO', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (51, 59, 'FACULDADE DE DIREITO DE FRANCA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (52, 60, 'CENTRO UNIVERSITRIO DE FRANCA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (53, 61, 'ESCOLA SUPERIOR DE EDUCAO FSICA DE AVAR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (54, 62, 'FACULDADE DE CINCIAS E LETRAS DE AVAR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (55, 63, 'FACULDADE DE CINCIAS DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (56, 64, 'FACULDADE DE ENGENHARIA DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (57, 65, 'FACULDADE DE ODONTOLOGIA DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (58, 66, 'FACULDADE DE DIREITO E ADMINISTRAO DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (59, 67, 'ESCOLA DE ENGENHARIA DE PIRACICABA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (60, 68, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PENPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (61, 71, 'UNIVERSIDADE DO ESTADO DO RIO GRANDE DO NORTE', 2, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (62, 72, 'FACULDADE DE FORMAO DE PROFESSORES DA MATA SUL', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (63, 73, 'CENTRO DE ENSINO SUPERIOR DE ARCOVERDE', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (64, 74, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE SO JOS DO RIO PARDO', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (65, 75, 'FACULDADE ESTADUAL DE EDUCAO CINCIAS E LETRAS DE PARANAVA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (66, 76, 'UNIVERSIDADE REGIONAL DE BLUMENAU', 3, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (67, 77, 'FACULDADE DA REGIO DOS LAGOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (68, 78, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ALEGRE', 3, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (69, 79, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE CATANDUVA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (70, 80, 'CENTRO UNIVERSITRIO PARA O DESENVOLVIMENTO DO ALTO VALE DO ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (71, 81, 'UNIVERSIDADE DA REGIO DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (72, 82, 'UNIVERSIDADE DO OESTE DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (73, 83, 'UNIVERSIDADE DO VALE DO ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (74, 84, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE MACA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (75, 85, 'FACULDADE DE FILOSOFIA DE ITAPERUNA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (76, 86, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS PADRE HUMBERTO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (77, 87, 'CENTRO UNIVERSITRIO DE BRUSQUE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (78, 88, 'FACULDADE DE FORMAO DE PROFESSORES DE PENEDO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (79, 89, 'FUNDAO FACULDADES LUIZ MENEGHEL', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (80, 90, 'ESCOLA SUPERIOR DE EDUCAO CINCIAS E LETRAS DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (81, 91, 'ESCOLA SUPERIOR DE CINCIAS AGRRIAS DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (82, 92, 'ESCOLA SUPERIOR CINCIAS HUMANAS E EXATAS DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (83, 93, 'FACULDADE DE MEDICINA DE JUNDIA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (84, 94, 'ESCOLA SUPERIOR DE EDUCAO FSICA DE JUNDIA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (85, 95, 'UNIVERSIDADE ESTADUAL DO VALE DO ACARA', 2, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (86, 96, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS PROFESSOR JOS AUGUSTO VIEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (87, 97, 'ESCOLA SUPERIOR DE AGRICULTURA E CINCIAS DE MACHADO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (88, 98, 'FACULDADE DE ADMINISTRAO E FINANAS DE MACHADO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (89, 99, 'FACULDADE DE DIREITO DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (90, 100, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ARAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (91, 101, 'FACULDADE DE CINCIAS GERENCIAIS DO ALTO PARANABA', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (92, 102, 'FACULDADE DE DIREITO DO ALTO PARANABA', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (93, 103, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE ARAGUARI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (94, 104, 'FACULDADE DE CINCIAS ECONMICAS DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (95, 105, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (96, 106, 'FACULDADE DE EDUCAO DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (97, 107, 'UNIVERSIDADE FEDERAL DE SO JOO DEL REI', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (98, 108, 'ESCOLA SUPERIOR DE EDUCAO FSICA E TCNICAS DESPORTIVAS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (99, 109, 'FACULDADES INTEGRADAS RUI BARBOSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (100, 110, 'FACULDADE DE DIREITO DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (101, 111, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (102, 122, 'FACULDADE DE ENGENHARIA DE AGRIMENSURA DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (103, 123, 'FACULDADE DE ENGENHARIA CIVIL DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (104, 124, 'CENTRO UNIVERSITRIO DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (105, 125, 'CENTRO UNIVERSITRIO DE ARARAS - "DR. EDMUNDO ULSON" - UNAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (106, 126, 'INSTITUTO NACIONAL DE TELECOMUNICAES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (107, 127, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE ATIBAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (108, 128, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (109, 129, 'FACULDADE DE DIREITO DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (110, 130, 'FACULDADE DE ADMINISTRAO DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (111, 131, 'FACULDADE DE EDUCAO FSICA DE BARRA BONITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (112, 132, 'FACULDADE DE EDUCAO ANTNIO AUGUSTO REIS NEVES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (113, 133, 'FACULDADE DE CINCIAS CONTBEIS DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (114, 134, 'FACULDADE DE TECNOLOGIA E PROCESSAMENTO DE DADOS - BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (115, 135, 'CENTRO UNIVERSITRIO CLARETIANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (116, 136, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE BEBEDOURO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (117, 137, 'UNIVERSIDADE DO SAGRADO CORAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (118, 138, 'CENTRO UNIVERSITRIO BARO DE MAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (119, 139, 'FACULDADE DE CINCIAS ECONMICAS DO TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (120, 140, 'UNIVERSIDADE SEVERINO SOMBRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (121, 141, 'FACULDADE DE DIREITO DE VARGINHA - FADIVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (122, 142, 'CENTRO UNIVERSITRIO DO TRINGULO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (123, 143, 'UNIVERSIDADE DE UBERABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (124, 144, 'FACULDADE DE CINCIAS HUMANAS DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (125, 145, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (126, 146, 'CENTRO UNIVERSITRIO DE RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (127, 149, 'FACULDADE DE MEDICINA DE SO JOS DO RIO PRETO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (128, 150, 'UNIVERSIDADE DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (129, 151, 'ESCOLA DE ADMINISTRAO DE EMPRESAS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (130, 152, 'FACULDADE DE CINCIAS CONTBEIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (131, 158, 'CONSERVATRIO BRASILEIRO DE MSICA - CENTRO UNIVERSITRIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (132, 159, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (133, 160, 'FACULDADE FRASSINETTI DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (134, 161, 'CENTRO UNIVERSITRIO ASSUNO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (135, 162, 'CENTRO UNIVERSITRIO BELAS ARTES DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (136, 163, 'UNIVERSIDADE ESTCIO DE S', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (137, 165, 'UNIVERSIDADE VEIGA DE ALMEIDA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (138, 166, 'FACULDADE DE ADMINISTRAO E INFORMTICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (139, 167, 'UNIVERSIDADE METODISTA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (140, 170, 'FACULDADES DA FUNDAO DE ENSINO DE MOCOCA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (141, 171, 'FACULDADE DE DIREITO DO SUL DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (142, 172, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS EUGNIO PACELLI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (143, 173, 'FACULDADE DE CINCIAS MDICAS DR. JOS ANTONIO GARCIA COUTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (144, 174, 'INSTITUTO SUPERIOR DE ESTUDOS SOCIAIS CLVIS BEVILACQUA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (145, 176, 'UNIVERSIDADE CASTELO BRANCO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (146, 177, 'FACULDADE DE CINCIAS ECONMICAS E DE ADMINISTRAO DE EMPRESAS DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (147, 178, 'FACULDADE DE ENGENHARIA DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (148, 179, 'FACULDADE DE ARQUITETURA E URBANISMO DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (149, 180, 'FACULDADE DE DIREITO DE CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (150, 181, 'FACULDADE DE ODONTOLOGIA DE CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (151, 190, 'ESCOLA DE MEDICINA SOUZA MARQUES DA FUNDAO TCNICO-EDUCACIONAL SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (152, 191, 'FACULDADE DE CINCIAS CONTBEIS E DE ADMINISTRAO DE EMPRESAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (153, 192, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (154, 193, 'FACULDADE DE ENGENHARIA SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (155, 194, 'ESCOLA DE ENFERMAGEM DA FUNDAO TCNICO EDUCACIONAL SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (156, 195, 'FACULDADE MORAES JNIOR - MACKENZIE RIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (157, 197, 'INSTITUTO DE CINCIAS SOCIAIS DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (158, 198, 'CENTRO UNIVERSITRIO DA CIDADE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (159, 199, 'FACULDADE SO LUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (160, 200, 'FACULDADE CSPER LBERO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (161, 201, 'FACULDADE BRASILEIRA DE CINCIAS JURDICAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (162, 202, 'FACULDADE DE ECONOMIA E FINANAS DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (163, 203, 'UNIVERSIDADE SO JUDAS TADEU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (164, 206, 'CENTRO UNIVERSITRIO TALO-BRASILEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (165, 207, 'CENTRO UNIVERSITRIO MOURA LACERDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (166, 208, 'UNIVERSIDADE DE RIBEIRO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (167, 210, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (168, 211, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (169, 212, 'FACULDADE DE FILOSOFIA DE CAMPO GRANDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (170, 213, 'CENTRO UNIVERSITRIO LVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (171, 214, 'FACULDADE DE ENGENHARIA DE MINAS GERAIS - FEAMIG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (172, 215, 'UNIVERSIDADE DO GRANDE ABC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (173, 216, 'CENTRO UNIVERSITRIO METODISTA IZABELA HENDRIX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (174, 217, 'CENTRO UNIVERSITRIO DAS FACULDADES ASSOCIADAS DE ENSINO - FAE', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (175, 218, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (176, 219, 'FACULDADE DE EDUCAO CINCIAS E ARTES DOM BOSCO DE MONTE APRAZVEL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (177, 220, 'FACULDADE SO JUDAS TADEU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (178, 221, 'UNIVERSIDADE CRUZEIRO DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (179, 222, 'CENTRO UNIVERSITRIO DE VOTUPORANGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (180, 223, 'FACULDADE DE EDUCAO FSICA DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (181, 224, 'FACULDADE DE MEDICINA DO ABC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (182, 225, 'INSTITUTO DE ENSINO SUPERIOR SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (183, 226, 'CENTRO UNIVERSITRIO LUSADA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (184, 227, 'UNIVERSIDADE CATLICA DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (185, 228, 'FACULDADE DE ENGENHARIA INDUSTRIAL DE SO BERNARDO DO CAMPO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (186, 229, 'ESCOLA SUPERIOR DE ADMINISTRAO DE NEGCIOS DE SO BERNARDO DO CAMPO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (187, 230, 'ESCOLA SUPERIOR DE ADMINISTRAO DE NEGCIOS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (188, 231, 'FACULDADE DE SO BERNARDO DO CAMPO - FASB', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (189, 234, 'FACULDADES OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (190, 236, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE SO JOO DA BOA VISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (191, 237, 'FACULDADE DE DIREITO DE SO JOO DA BOA VISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (192, 238, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE SO JOO DA BOA VISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (193, 239, 'FACULDADE DE MEDICINA VETERINRIA OCTVIO BASTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (194, 240, 'UNIVERSIDADE SANTA RSULA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (195, 241, 'FACULDADE DE ENGENHARIA QUMICA DE LORENA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (196, 242, 'CENTRO UNIVERSITRIO DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (197, 243, 'FACULDADE DO CLUBE NUTICO MOGIANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (198, 244, 'CENTRO UNIVERSITRIO FIEO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (199, 245, 'FACULDADE DE ADMINISTRAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (200, 254, 'CENTRO UNIVERSITRIO CAPITAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (201, 255, 'FACULDADE DE ENGENHARIA E AGRIMENSURA DE PIRASSUNUNGA - FEAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (202, 256, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE PIRAJU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (203, 257, 'FACULDADE DE ADMINISTRAO E CINCIAS CONTBEIS LUZWELL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (204, 263, 'FACULDADES INTEGRADAS CAMPOS SALLES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (205, 264, 'UNIVERSIDADE SO MARCOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (206, 265, 'FACULDADES INTEGRADAS DE OURINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (207, 266, 'UNIVERSIDADE METODISTA DE PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (208, 267, 'FACULDADES INTEGRADAS ESPRITO SANTENSES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (209, 268, 'FACULDADE DE DIREITO DA ALTA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (210, 269, 'FACULDADE FACCAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (211, 270, 'FACULDADES ESEFAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (212, 271, 'UNIVERSIDADE DO OESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (213, 273, 'ESCOLA DE ENGENHARIA INDUSTRIAL DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (214, 274, 'FACULDADE DE CINCIAS APLICADAS DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (215, 275, 'UNIVERSIDADE DO VALE DO PARABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (216, 276, 'FACULDADE DE DIREITO DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (217, 277, 'CENTRO UNIVERSITRIO AUGUSTO MOTTA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (218, 278, 'FACULDADES INTEGRADAS SIMONSEN', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (219, 279, 'FACULDADES INTEGRADAS HLIO ALONSO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (220, 280, 'FACULDADE DE DIREITO DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (221, 281, 'CONSERVATRIO DRAMTICO MUSICAL SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (222, 282, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (223, 283, 'FACULDADE DE EDUCAO COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (224, 284, 'FACULDADE DE MEDICINA DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (225, 288, 'FACULDADE DE DIREITO DO VALE DO RIO DOCE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (226, 289, 'FACULDADE DE EDUCAO DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (227, 290, 'FACULDADE DE DIREITO DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (228, 291, 'FACULDADE DE PSICOLOGIA DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (229, 292, 'FACULDADE DE CINCIAS DA SADE DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (230, 293, 'FACULDADE DE CINCIAS E TECNOLOGIA DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (231, 294, 'FACULDADE TRS DE MAIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (232, 295, 'UNIVERSIDADE DE SANTA CRUZ DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (233, 296, 'UNIVERSIDADE DA REGIO DA CAMPANHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (234, 297, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS SO JUDAS TADEU', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (235, 298, 'UNIVERSIDADE NORTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (236, 299, 'FACULDADE DE JANDAIA DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (237, 300, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (238, 301, 'ESCOLA DE BIBLIOTECONOMIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (239, 302, 'FACULDADE DE CINCIAS ECONMICAS, ADMINISTRATIVAS E CONTBEIS DE DIVINPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (240, 303, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (241, 304, 'FACULDADE DE CINCIAS CONTBEIS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (242, 307, 'FACULDADE DE MEDICINA DE BARBACENA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (243, 308, 'UNIVERSIDADE PRESIDENTE ANTNIO CARLOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (244, 316, 'UNIVERSIDADE NOVE DE JULHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (245, 317, 'FACULDADES INTEGRADAS ALCNTARA MACHADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (246, 318, 'FACULDADE DE ARTES ALCNTARA MACHADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (247, 319, 'UNIVERSIDADE CAMILO CASTELO BRANCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (248, 320, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE TATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (249, 321, 'FACULDADE DE DESENHO DE TATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (250, 322, 'UNIVERSIDADE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (251, 328, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS VIANNA JNIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (252, 329, 'ESCOLA SUPERIOR DE AGRONOMIA DE PARAGUA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (253, 330, 'UNIVERSIDADE IGUAU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (254, 332, 'ESCOLA DE ENGENHARIA DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (255, 333, 'FACULDADE DE INFORMTICA DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (256, 334, 'FACULDADE DE SERVIO SOCIAL DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (257, 335, 'FACULDADE DE EDUCAO E CINCIAS PINHEIRENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (258, 336, 'FACULDADE MACHADO SOBRINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (259, 337, 'CENTRO DE ENSINO SUPERIOR DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (260, 338, 'PONTIFCIA UNIVERSIDADE CATLICA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (261, 339, 'FACULDADE SANTA EMLIA DE RODAT', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (262, 343, 'CENTRO UNIVERSITRIO NEWTON PAIVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (263, 344, 'CENTRO UNIVERSITRIO UNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (264, 345, 'ESCOLA DE ENGENHARIA KENNEDY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (265, 346, 'INSTITUTO SUPERIOR DE CINCIAS APLICADAS - ISCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (266, 349, 'CENTRO UNIVERSITRIO DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (267, 351, 'FACULDADE DE CINCIAS MDICAS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (268, 352, 'CENTRO UNIVERSITRIO DE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (269, 353, 'FACULDADE EVANGLICA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (270, 355, 'UNIVERSIDADE TUIUTI DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (271, 359, 'ESCOLA SUPERIOR DE EDUCAO FSICA DE MUZAMBINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (272, 360, 'CENTRO UNIVERSITRIO PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (273, 361, 'FACULDADE PAULISTA DE SERVIO SOCIAL DE SO CAETANO DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (274, 362, 'FACULDADE PAULISTA DE SERVIO SOCIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (275, 363, 'FACULDADE MOZARTEUM DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (276, 364, 'FACULDADE DE CINCIAS CONTBEIS DE PONTE NOVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (277, 367, 'UNIVERSIDADE ESTADUAL DE MONTES CLAROS', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (278, 368, 'FACULDADE DE EDUCAO FSICA DA ASSOCIAO CRIST DE MOOS DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (279, 369, 'FACULDADE AUXILIUM DE FILOSOFIA CINCIAS E LETRAS DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (280, 370, 'FACULDADE PAULISTA DE ARTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (281, 371, 'FACULDADE DE MSICA CARLOS GOMES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (282, 372, 'FACULDADE DE BIBLIOTECONOMIA E CINCIA DA INFORMAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (283, 373, 'ESCOLA DE SOCIOLOGIA E POLTICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (284, 374, 'CENTRO UNIVERSITRIO DAS FACULDADES METROPOLITANAS UNIDAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (285, 375, 'UNIVERSIDADE DE SANTO AMARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (286, 376, 'CENTRO UNIVERSITRIO IBERO-AMERICANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (287, 377, 'FACULDADE DE EDUCAO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (288, 378, 'FACULDADE DE DIREITO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (289, 379, 'FACULDADE DE CINCIAS E LETRAS PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (290, 380, 'FACULDADE DE CINCIAS ECONMICAS, CONTBEIS E DE ADM DE EMPRESAS PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (291, 381, 'FACULDADE DE PSICOLOGIA PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (292, 382, 'FACULDADE DE TECNOLOGIA PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (293, 383, 'UNIVERSIDADE DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (294, 384, 'CENTRO UNIVERSITRIO DE ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (295, 385, 'UNIVERSIDADE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (296, 386, 'CENTRO UNIVERSITRIO DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (297, 387, 'UNIVERSIDADE CATLICA DOM BOSCO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (298, 388, 'FACULDADE DE CINCIAS CONTBEIS E ATUARIAIS DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (299, 389, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (300, 390, 'FACULDADE DE EDUCAO FSICA DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (301, 391, 'FACULDADE DE TECNOLOGIA DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (302, 395, 'FACULDADE DE CINCIAS CONTBEIS DE LUCLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (303, 396, 'FACULDADE RUY BARBOSA DE ADMINISTRAO E DE DIREITO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (304, 397, 'FACULDADE RUY BARBOSA DE TECNOLOGIA EM PROCESSAMENTO DE DADOS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (305, 398, 'UNIVERSIDADE TIRADENTES', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (306, 399, 'ESCOLA DE ENGENHARIA DE AGRIMENSURA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (307, 400, 'FACULDADE DE DIREITO DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (308, 401, 'CENTRO DE ESTUDOS SUPERIORES BARROS MELO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (309, 402, 'CENTRO UNIVERSITRIO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (310, 403, 'UNIVERSIDADE CATLICA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (311, 404, 'FACULDADES INTEGRADAS DA UPIS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (312, 405, 'FOCCA - FACULDADE DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (313, 408, 'ESCOLA SUPERIOR DE RELAES PBLICAS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (314, 409, 'UNIVERSIDADE DE PERNAMBUCO', 2, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (315, 410, 'FACULDADE DE CINCIAS HUMANAS ESUDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (316, 413, 'FACULDADE PORTO-ALEGRENSE DE EDUCAO, CINCIAS E LETRAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (317, 414, 'FACULDADE PORTO-ALEGRENSE DE CINCIAS CONTBEIS E ADMINISTRATIVAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (318, 415, 'FACULDADE DE CINCIAS MDICAS DA SANTA CASA SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (319, 416, 'FACULDADES INTEGRADAS TERESA MARTIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (320, 417, 'UNIVERSIDADE CIDADE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (321, 420, 'UNIVERSIDADE DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (322, 421, 'FACULDADE ESTADUAL DE CINCIAS E LETRAS DE CAMPO MOURO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (323, 423, 'UNIVERSIDADE REGIONAL INTEGRADA DO ALTO URUGUAI E DAS MISSES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (324, 424, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE SANTA ROSA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (325, 425, 'FACULDADE DE EDUCAO ARTSTICA DE SANTA ROSA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (326, 426, 'CENTRO UNIVERSITRIO FRANCISCANO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (327, 428, 'FACULDADE DE CINCIAS CONTBEIS E DE ADMINISTRAO DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (328, 429, 'FACULDADE DE DIREITO DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (329, 430, 'CENTRO UNIVERSITRIO FILADLFIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (330, 431, 'FACULDADE DE MEDICINA DE MARLIA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (331, 432, 'FACULDADE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (332, 433, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PALMAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (333, 434, 'FACULDADE SANTA MARCELINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (334, 435, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS SANTA MARCELINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (335, 436, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (336, 437, 'UNIVERSIDADE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (337, 438, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITUVERAVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (338, 439, 'FACULDADE DOUTOR FRANCISCO MAEDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (339, 440, 'FACULDADE DE DIREITO DE IT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (340, 441, 'UNIVERSIDADE DO CONTESTADO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (341, 442, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITARAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (342, 443, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE ITARAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (343, 446, 'UNIVERSIDADE DE CRUZ ALTA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (344, 447, 'FACULDADE CATLICA DE CINCIAS ECONMICAS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (345, 448, 'CENTRO UNIVERSITRIO RITTER DOS REIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (346, 449, 'UNIVERSIDADE LUTERANA DO BRASIL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (347, 450, 'CENTRO UNIVERSITRIO LUTERANO DE JI-PARAN', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (348, 451, 'CENTRO UNIVERSITRIO LUTERANO DE SANTARM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (349, 452, 'CENTRO UNIVERSITRIO LUTERANO DE MANAUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (350, 453, 'CENTRO UNIVERSITRIO LUTERANO DE PALMAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (351, 454, 'FACULDADE CAMAQENSE DE CINCIAS CONTBEIS E ADMINISTRATIVAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (352, 455, 'FACULDADE DE FORMAO DE PROFESSORES E ESPECIALISTAS DE EDUCAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (353, 456, 'CENTRO UNIVERSITRIO SANTANNA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (354, 457, 'UNIVERSIDADE BANDEIRANTE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (355, 458, 'UNIVERSIDADE IBIRAPUERA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (356, 459, 'FACULDADE RENASCENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (357, 460, 'FACULDADE DE ARTES PLSTICAS DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (358, 461, 'FACULDADE DE ADMINISTRAO DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (359, 462, 'FACULDADE DE ENGENHARIA DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (360, 463, 'FACULDADE DE COMUNICAO E MARKETING DA - FUNDAO ARMANDO LVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (361, 464, 'FACULDADE DE ECONOMIA DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (362, 465, 'FACULDADE DE COMPUTAO E INFORMTICA DA FUNDAO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (363, 466, 'UNIVERSIDADE ANHEMBI MORUMBI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (364, 467, 'FACULDADE DE CINCIAS CONTBEIS DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (365, 468, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (366, 469, 'ABEU FACULDADES INTEGRADAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (367, 470, 'FACULDADE DE ODONTOLOGIA DE NOVA FRIBURGO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (368, 472, 'UNIVERSIDADE DO GRANDE RIO PROFESSOR JOS DE SOUZA HERDY', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (369, 473, 'FACULDADE DE CINCIAS ECONMICAS, ADMINISTRATIVAS E DA COMPUTAO DOM BOSCO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (370, 474, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DOM BOSCO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (371, 475, 'FACULDADE DE MEDICINA DE PETRPOLIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (372, 480, 'CENTRO UNIVERSITRIO SERRA DOS RGOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (373, 481, 'UNIVERSIDADE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (374, 482, 'UNIVERSIDADE DO EXTREMO SUL CATARINENSE', 3, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (375, 483, 'CENTRO UNIVERSITRIO METROPOLITANO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (376, 486, 'FACULDADE DE FORMAO DE PROFESSORES DE ARAPIRACA', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (377, 487, 'FACULDADE DE ADMINISTRAO, CINCIAS CONTBEIS, JURDICAS E SOCIAIS DO ESTADO DE ALAGOAS', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (378, 488, 'ESCOLA SUPERIOR DE CINCIAS HUMANAS FSICAS E BIOLGICAS DO SERTO', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (379, 489, 'CENTRO UNIVERSITRIO DE VOLTA REDONDA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (380, 490, 'CENTRO DE ENSINO SUPERIOR DE VALENA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (381, 491, 'FACULDADE DE EDUCAO CINCIAS E LETRAS DON DOMNICO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (382, 492, 'FACULDADE DE ADMINISTRAO CINCIAS ECON E CONTBEIS DE GUARATINGUET', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (383, 493, 'FACULDADE DE EDUCAO DE GUARATINGUET', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (384, 494, 'UNIVERSIDADE DO SUL DE SANTA CATARINA', 3, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (385, 495, 'FACULDADE DE CINCIAS E LETRAS DE BRAGANA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (386, 496, 'UNIVERSIDADE DE FRANCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (387, 498, 'ESCOLA SUPERIOR DE EDUCAO FSICA E DESPORTOS DE CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (388, 499, 'FACULDADE DE DIREITO E ADMINISTRAO CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (389, 500, 'FACULDADE DE MEDICINA DE CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (390, 501, 'ESCOLA SUPERIOR DE CINCIAS DA SANTA CASA DE MISERICRDIA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (391, 502, 'CENTRO UNIVERSITRIO MONTE SERRAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (392, 503, 'FACULDADE DE DIREITO DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (393, 504, 'FACULDADE DE ODONTOLOGIA DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (394, 505, 'FACULDADE DE FILOSOFIA DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (395, 506, 'FACULDADE DE MEDICINA DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (396, 507, 'FACULDADE TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (397, 508, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO SUL DE MINAS - FACESM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (398, 509, 'FACULDADES INTEGRADAS DE CRUZEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (399, 510, 'ESCOLA DE ENFERMAGEM WENCESLAU BRAZ', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (400, 511, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE GUAXUP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (401, 512, 'FACULDADE DE CINCIAS ADMINISTRATIVAS ECONMICAS E CONTBEIS DE GUAXUP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (402, 513, 'UNIVERSIDADE VALE DO RIO DOCE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (403, 514, 'CENTRO UNIVERSITRIO DE BARRA MANSA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (404, 515, 'CENTRO UNIVERSITRIO PLNIO LEITE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (405, 516, 'CENTRO UNIVERSITRIO MOACYR SREDER BASTOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (406, 517, 'FACULDADE DE EDUCAO SO LUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (407, 518, 'CENTRO UNIVERSITRIO DO DISTRITO FEDERAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (408, 519, 'UNIVERSIDADE CATLICA DO SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (409, 521, 'UNIVERSIDADE DE MOGI DAS CRUZES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (410, 522, 'CENTRO UNIVERSITRIO CELSO LISBOA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (411, 524, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (412, 526, 'UNIVERSIDADE BRAZ CUBAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (413, 527, 'UNIVERSIDADE CATLICA DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (414, 528, 'PONTIFCIA UNIVERSIDADE CATLICA DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (415, 530, 'FACULDADE DE MSICA DO ESPRITO SANTO', 2, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (416, 531, 'FACULDADE DE FORMAO DE PROFESSORES DE VITRIA DE SANTO ANTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (417, 532, 'UNIVERSIDADE REGIONAL DO NOROESTE DO ESTADO DO RIO GRANDE DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (418, 533, 'FACULDADES INTEGRADAS DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (419, 534, 'ESCOLA BAHIANA DE MEDICINA E SADE PBLICA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (420, 535, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE MANDAGUARI', 3, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (421, 543, 'FACULDADE DE CINCIAS DA FUNDAO INSTITUTO TECNOLGICO DE OSASCO', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (422, 544, 'FACULDADE DE CINCIAS HUMANAS DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (423, 545, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (424, 546, 'PONTIFCIA UNIVERSIDADE CATLICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (425, 547, 'UNIVERSIDADE DO ESTADO DO RIO DE JANEIRO', 2, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (426, 548, 'UNIVERSIDADE FEDERAL DO MARANHO', 1, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (427, 549, 'UNIVERSIDADE FEDERAL DO ACRE', 1, 1, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (428, 550, 'UNIVERSIDADE ESTADUAL DA PARABA', 2, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (429, 552, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (430, 553, 'FACULDADE DE CINCIAS ADMINISTRATIVAS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (431, 554, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE BOA ESPERANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (432, 555, 'UNIVERSIDADE DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (433, 556, 'CONSERVATRIO DE MSICA DE NITERI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (434, 557, 'ESCOLA DE MSICA E BELAS ARTES DO PARAN', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (435, 558, 'FACULDADE DE ARTES DO PARAN', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (436, 568, 'UNIVERSIDADE ESTADUAL DO MARANHO', 2, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (437, 569, 'UNIVERSIDADE FEDERAL DO PAR', 1, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (438, 570, 'UNIVERSIDADE FEDERAL DO RIO GRANDE DO NORTE', 1, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (439, 571, 'UNIVERSIDADE FEDERAL DO PARAN', 1, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (440, 572, 'UNIVERSIDADE FEDERAL FLUMINENSE', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (441, 573, 'UNIVERSIDADE FEDERAL DO ESPRITO SANTO', 1, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (442, 574, 'UNIVERSIDADE FEDERAL RURAL DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (443, 575, 'UNIVERSIDADE FEDERAL DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (444, 576, 'UNIVERSIDADE FEDERAL DE JUIZ DE FORA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (445, 577, 'UNIVERSIDADE FEDERAL DE ALAGOAS', 1, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (446, 578, 'UNIVERSIDADE FEDERAL DA BAHIA', 1, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (447, 579, 'UNIVERSIDADE FEDERAL DA PARABA', 1, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (448, 580, 'UNIVERSIDADE FEDERAL DE PERNAMBUCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (449, 581, 'UNIVERSIDADE FEDERAL DO RIO GRANDE DO SUL', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (450, 582, 'UNIVERSIDADE FEDERAL DE SANTA MARIA', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (451, 583, 'UNIVERSIDADE FEDERAL DO CEAR', 1, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (452, 584, 'UNIVERSIDADE FEDERAL DE GOIS', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (453, 585, 'UNIVERSIDADE FEDERAL DE SANTA CATARINA', 1, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (454, 586, 'UNIVERSIDADE FEDERAL DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (455, 587, 'UNIVERSIDADE FEDERAL RURAL DE PERNAMBUCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (456, 588, 'UNIVERSIDADE TECNOLGICA FEDERAL DO PARAN', 1, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (457, 589, 'UNIVERSIDADE FEDERAL RURAL DO SEMI-RIDO', 1, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (458, 590, 'UNIVERSIDADE FEDERAL RURAL DA AMAZNIA', 1, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (459, 591, 'UNIVERSIDADE FEDERAL DE SO PAULO', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (460, 592, 'UNIVERSIDADE FEDERAL DE LAVRAS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (461, 593, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA CELSO SUCKOW DA FONSECA', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (462, 594, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (463, 595, 'UNIVERSIDADE FEDERAL DE ALFENAS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (464, 596, 'UNIVERSIDADE FEDERAL DOS VALES DO JEQUITINHONHA E MUCURI', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (465, 597, 'UNIVERSIDADE FEDERAL DO TRINGULO MINEIRO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (466, 598, 'UNIVERSIDADE FEDERAL DE ITAJUB - UNIFEI', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (467, 599, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DA BAHIA', 1, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (468, 600, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO MARANHO', 1, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (469, 601, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO RIO GRANDE DO SUL', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (470, 602, 'INSTITUTO TECNOLGICO DE AERONUTICA', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (471, 605, 'UNIVERSIDADE MUNICIPAL DE SO CAETANO DO SUL', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (472, 606, 'FACULDADE DE DIREITO DE CACHOEIRO DO ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (473, 607, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE CACHOEIRO DO ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (474, 608, 'ESCOLA SUPERIOR DE CRUZEIRO "PREFEITO HAMILTON VIEIRA MENDES"', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (475, 609, 'UNIVERSIDADE ESTADUAL DO OESTE DO PARAN', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (476, 610, 'CENTRO UNIVERSITRIO METODISTA BENNETT', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (477, 614, 'FACULDADE DE FILOSOFIA SANTA DOROTIA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (478, 615, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS PROFESSORA NAIR FORTES ABU-MERHY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (479, 616, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (480, 617, 'FACULDADE DE ENFERMAGEM E OBSTETRCIA DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (481, 618, 'FACULDADE DE FISIOTERAPIA DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (482, 621, 'CENTRO DE ESTUDOS SUPERIORES DE MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (483, 622, 'FACULDADES INTEGRADAS SILVA E SOUZA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (484, 623, 'FACULDADES DE FILOSOFIA CINCIAS E LETRAS DE SANTA CRUZ DO RIO PARDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (485, 624, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS CARLOS QUEIROZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (486, 625, 'FACULDADE CENECISTA DE CAPIVARI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (487, 626, 'FACULDADE CENECISTA DE OSRIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (488, 627, 'FACULDADE CENECISTA DE VARGINHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (489, 629, 'FACULDADE CENECISTA DE VITRIA - FACEV', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (490, 630, 'FACULDADE CENECISTA DE CINCIAS ADMINISTRATIVAS DE OSRIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (491, 631, 'CENTRO DE ENSINO SUPERIOR CENECISTA DE FARROUPILHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (492, 632, 'FACULDADE DE CINCIAS ECONMICAS, ADMINISTRATIVAS E CONTBEIS DE SO SEBASTIO DO PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (493, 633, 'INSTITUTO MILITAR DE ENGENHARIA', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (494, 634, 'UNIVERSIDADE FEDERAL DE PELOTAS', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (495, 636, 'ESCOLA SUPERIOR DE PROPAGANDA E MARKETING', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (496, 637, 'FACULDADE DE ENGENHARIA SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (497, 638, 'FACULDADE DE DIREITO MILTON CAMPOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (498, 639, 'FACULDADE DE DESENHO INDUSTRIAL DE MAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (499, 640, 'FACULDADES INTEGRADAS MARIA THEREZA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (500, 641, 'CENTRO UNIVERSITRIO LA SALLE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (501, 645, 'CENTRO UNIVERSITRIO DE JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (502, 646, 'FACULDADES ASSOCIADAS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (503, 647, 'FACULDADE DE ENFERMAGEM LUIZA DE MARILLAC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (504, 648, 'FACULDADES ASSOCIADAS DE UBERABA - FAZU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (505, 649, 'CENTRO UNIVERSITRIO DE UNIO DA VITRIA', 3, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (506, 650, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE AVAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (507, 651, 'FACULDADE DE ADMINISTRAO DE GOVERNADOR VALADARES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (508, 652, 'FACULDADE SANTA CECLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (509, 657, 'FACULDADE DE FORMAO DE PROFESSORES DE SERRA TALHADA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (510, 659, 'FACULDADE DE CINCIAS HUMANAS DO SUL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (511, 660, 'FACULDADE METODISTA DO SUL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (512, 661, 'FACULDADE PIO DCIMO', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (513, 662, 'FACULDADES INTEGRADAS CORAO DE JESUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (514, 663, 'UNIVERSIDADE SALGADO DE OLIVEIRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (515, 664, 'CENTRO UNIVERSITRIO VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (516, 665, 'UNIVERSIDADE DE TAUBAT', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (517, 666, 'UNIVERSIDADE ESTADUAL DE FEIRA DE SANTANA', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (518, 667, 'FACULDADES INTEGRADAS DE JACAREPAGU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (519, 668, 'CENTRO UNIVERSITRIO DE ENSINO SUPERIOR DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (520, 669, 'CENTRO UNIVERSITRIO NILTON LINS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (521, 670, 'UNIVERSIDADE SO FRANCISCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (522, 671, 'UNIVERSIDADE ANHANGUERA - UNIDERP', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (523, 672, 'FACULDADE DE ENGENHARIA DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (524, 673, 'CENTRO UNIVERSITRIO DA GRANDE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (525, 674, 'CENTRO DE ENSINO SUPERIOR DO VALE SO FRANCISCO', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (526, 677, 'FACULDADE DE REABILITAO DA ASCE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (527, 678, 'FACULDADE DE ODONTOLOGIA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (528, 679, 'FACULDADE DE REABILITAO DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (529, 680, 'FACULDADES INTEGRADAS DE PEDRO LEOPOLDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (530, 681, 'FACULDADES INTEGRADAS ANGLO-AMERICANO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (531, 682, 'FACULDADE DO NOROESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (532, 683, 'FACULDADE DE CINCIAS ECONMICAS DE COLATINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (533, 684, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE COLATINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (534, 685, 'FACULDADE DE FORMAO DE PROFESSORES DE BELO JARDIM', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (535, 686, 'FACULDADE DE CINCIAS DA ADMINISTRAO DO LIMOEIRO', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (536, 687, 'FACULDADE ESTADUAL DE FILOSOFIA CINCIAS LETRAS UNIO DA VITRIA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (537, 688, 'UNIVERSIDADE ESTADUAL DO SUDOESTE DA BAHIA', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (538, 689, 'FACULDADE DE NUTRIO E FONOAUDIOLOGIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (539, 690, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (540, 691, 'FACULDADE DE EDUCAO DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (541, 692, 'FACULDADE DE CINCIAS APLICADAS E SOCIAIS DE PETROLINA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (542, 693, 'UNIVERSIDADE FEDERAL DO ESTADO DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (543, 694, 'UNIVERSIDADE FEDERAL DE MATO GROSSO DO SUL', 1, 1, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (544, 695, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (545, 696, 'FACULDADE DE CINCIAS AGRRIAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (546, 697, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (547, 699, 'FUNDAO UNIVERSIDADE FEDERAL DE RONDNIA', 1, 1, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (548, 700, 'FACULDADE DE EDUCAO DE ITABORA', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (549, 701, 'FACULDADE DE CINCIAS DA ADMINISTRAO DE GARANHUNS', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (550, 702, 'FACULDADE DE FORMAO DE PROFESSORES DE GOIANA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (551, 703, 'FACULDADE DE FORMAO DE PROFESSORES DE ARARIPINA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (552, 704, 'FACULDADE DE CINCIAS AGRRIAS DE ARARIPINA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (553, 705, 'FACULDADE SO JOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (554, 706, 'FACULDADE DE ARTES DULCINA DE MORAES', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (555, 707, 'CENTRO UNIVERSITRIO CENTRAL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (556, 708, 'INSTITUTO DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (557, 709, 'INSTITUTO DE CINCIAS EXATAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (558, 710, 'FACULDADE BTHENCOURT DA SILVA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (559, 711, 'FACULDADES REUNIDAS DE ADMINISTRAO CINCIAS CONTBEIS E ECONMICAS DE PALMAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (560, 712, 'CENTRO UNIVERSITRIO HERMNIO DA SILVEIRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (561, 713, 'ESCOLA SUPERIOR DE ESTATSTICA DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (562, 714, 'FACULDADE ESTADUAL DE FILOSOFIA CINCIAS E LETRAS DE CORNLIO PROCPIO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (563, 715, 'CENTRO UNIVERSITRIO FRANCISCANO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (564, 716, 'FACULDADES INTEGRADAS DE BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (565, 717, 'FUNDAO UNIVERSIDADE FEDERAL DE CINCIAS DA SADE DE PORTO ALEGRE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (566, 718, 'UNIVERSIDADE POTIGUAR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (567, 719, 'UNIVERSIDADE DO ESTADO DE MATO GROSSO', 2, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (568, 720, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS APLICADAS DO CABO DE SANTO AGOSTINHO', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (569, 721, 'FACULDADE DE EDUCAO DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (570, 722, 'ESCOLA DE EDUCAO FSICA DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (571, 723, 'FACULDADE DE ADMINISTRAO DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (572, 724, 'FACULDADE DE CINCIAS, CULTURA E EXTENSO DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (573, 725, 'FACULDADE ESTADUAL DE FILOSOFIA, CINCIAS E LETRAS DE PARANAGU', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (574, 726, 'FACULDADE ESTADUAL DE FILOSOFIA CINCIAS E LETRAS DE JACAREZINHO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (575, 727, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (576, 728, 'FACULDADE DE CINCIAS HUMANAS DE CURVELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (577, 729, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PRESIDENTE VENCESLAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (578, 730, 'UNIVERSIDADE ESTADUAL DE PONTA GROSSA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (579, 734, 'FACULDADES INTEGRADAS MARIA IMACULADA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (580, 736, 'FACULDADE DE CINCIAS APLICADAS SAGRADO CORAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (581, 737, 'CENTRO UNIVERSITRIO SO CAMILO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (582, 738, 'FACULDADES INTEGRADAS TERESA DVILA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (583, 739, 'CENTRO UNIVERSITRIO SO CAMILO - ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (584, 740, 'FACULDADE DE CINCIAS HUMANAS DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (585, 741, 'ESCOLA SUPERIOR DE SECRETARIADO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (586, 742, 'FACULDADE DE ARQUITETURA E URBANISMO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (587, 743, 'ESCOLA SUPERIOR DE ENSINO HELENA ANTIPOFF', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (588, 744, 'FACULDADE DE EDUCAO E CINCIAS HUMANAS DE ANICUNS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (589, 745, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE SO MANUEL', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (590, 746, 'UNIVERSIDADE REGIONAL DO CARIRI', 2, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (591, 747, 'FACULDADE DE CINCIAS HUMANAS DE IVAIPOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (592, 749, 'CENTRO DE ENSINO SUPERIOR DO VALE DO PARNABA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (593, 750, 'CENTRO UNIVERSITRIO UNIRG', 3, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (594, 751, 'FACULDADE DA ILHA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (595, 752, 'FACULDADE DE PAR DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (596, 753, 'FACULDADE DE CINCIAS HUMANAS DO SERTO CENTRAL', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (597, 754, 'CENTRO DE ENSINO SUPERIOR DE CATALO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (598, 755, 'CENTRO DE ENSINO SUPERIOR DE JATA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (599, 756, 'UNIVERSIDADE ESTADUAL DO PIAU', 2, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (600, 757, 'FACULDADES INTEGRADAS DO TAPAJS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (601, 758, 'FACULDADE BRASILEIRA DE RECURSOS HUMANOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (602, 759, 'FACULDADE DE CINCIAS MDICAS E PARAMDICAS FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (603, 760, 'FACULDADE DE CINCIAS HUMANAS DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (604, 761, 'FACULDADES SPEI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (605, 762, 'FACULDADES INTEGRADAS DE FTIMA DO SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (606, 763, 'INSTITUTO UNIFICADO DE ENSINO SUPERIOR OBJETIVO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (607, 764, 'FACULDADE PINHEIRO GUIMARES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (608, 767, 'INSTITUTO SUPERIOR DE INFORMTICA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (609, 768, 'FACULDADE DE ADMINISTRAO DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (610, 769, 'FACULDADES INTEGRADAS DE NAVIRA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (611, 770, 'FACULDADE DE EDUCAO DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (612, 771, 'FACULDADE MARIA AUGUSTA RIBEIRO DAHER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (613, 773, 'FACULDADE DE ADMINISTRAO E CINCIAS CONTBEIS DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (614, 774, 'FACULDADE ALVORADA DE INFORMTICA E PROCESSAMENTO DE DADOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (615, 775, 'FACULDADE ALVORADA DE EDUCAO FSICA E DESPORTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (616, 776, 'FACULDADE DE CINCIAS CONTBEIS DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (617, 777, 'FACULDADE DE EDUCAO THEREZA PORTO MARQUES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (618, 778, 'FACULDADE DE TECNOLOGIA THEREZA PORTO MARQUES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (619, 779, 'FACULDADE DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (620, 780, 'UNIVERSIDADE DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (621, 781, 'FACULDADE DO SUL DE MATO GROSSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (622, 782, 'FACULDADE CUIABANA DE EDUCAO E LETRAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (623, 783, 'FACULDADE MATOGROSSENSE DE CINCIAS CONTBEIS E ADMINISTRATIVA DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (624, 785, 'FACULDADE DE EDUCAO DE TANGAR DA SERRA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (625, 788, 'FACULDADE DE CINCIAS HUMANAS, EXATAS E LETRAS DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (626, 789, 'UNIVERSIDADE FEDERAL DE RORAIMA', 1, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (627, 790, 'FACULDADE DE ENFERMAGEM DO HOSPITAL ISRAELITA ALBERT EINSTEIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (628, 791, 'FACULDADE SENAC DE TURISMO E HOTELARIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (629, 792, 'CENTRO UNIVERSITRIO DO ESTADO DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (630, 793, 'CENTRO UNIVERSITRIO RADIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (631, 794, 'CENTRO UNIVERSITRIO DE VRZEA GRANDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (632, 795, 'FACULDADES INTEGRADAS DE DIAMANTINO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (633, 796, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO VALE DO SO LOURENO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (634, 797, 'FACULDADE DE EDUCAO E CINCIAS ADMINISTRATIVAS DE VILHENA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (635, 798, 'FACULDADE DE ARACRUZ', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (636, 799, 'FACULDADE LEONARDO DA VINCI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (637, 800, 'FACULDADE DE EDUCAO FSICA MONTENEGRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (638, 801, 'FACULDADE DE EDUCAO MONTENEGRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (639, 802, 'CENTRO UNIVERSITRIO CARIOCA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (640, 803, 'FACULDADE INTERAO AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (641, 809, 'FACULDADE DE DIREITO E CINCIAS SOCIAIS DO LESTE DE MINAS - FADILESTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (642, 810, 'CENTRO TCNICO-EDUCACIONAL SUPERIOR DO OESTE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (643, 811, 'FACULDADES INTEGRADAS DE CASSILNDIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (644, 817, 'FACULDADE BATISTA CARIOCA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (645, 818, 'FACULDADE DE ADMINISTRAO DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (646, 819, 'FACULDADE DE AGRONOMIA DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (647, 820, 'FACULDADE DE CINCIAS DA COMPUTAO DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (648, 821, 'FACULDADE DE PEDAGOGIA DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (649, 822, 'ESCOLA SUPERIOR DE ESTUDOS EMPRESARIAIS E INFORMTICA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (650, 823, 'CENTRO UNIVERSITRIO DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (651, 824, 'FACULDADE DE FILOSOFIA E CINCIAS HUMANAS DE GOIATUBA', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (652, 825, 'FACULDADE PRESBITERIANA GAMMON', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (653, 826, 'CENTRO UNIVERSITRIO DE DESENVOLVIMENTO DO CENTRO-OESTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (654, 827, 'FACULDADES UNIDAS DO VALE DO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (655, 828, 'FACULDADE DE SO LOURENO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (656, 829, 'UNIVERSIDADE DO TOCANTINS', 2, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (657, 830, 'UNIVERSIDADE FEDERAL DO AMAP', 1, 1, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (658, 831, 'FACULDADE DE CINCIAS HUMANAS DO VALE DO RIO GRANDE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (659, 832, 'FACULDADE DE CINCIAS ADMINISTRATIVAS DE CURVELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (660, 833, 'FACULDADES INTEGRADAS DE ARIQUEMES', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (661, 834, 'FACULDADE VARZEAGRANDENSE DE CINCIAS HUMANAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (662, 835, 'FACULDADE VARZEAGRANDENSE DE COMUNICAO SOCIAL', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (663, 837, 'FACULDADE DE CINCIAS HUMANAS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (664, 838, 'FACULDADE DE CINCIAS TECNOLGICAS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (665, 839, 'FACULDADE VITORIANA DE CINCIAS CONTBEIS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (666, 840, 'FACULDADE VITORIANA DE TECNOLOGIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (667, 841, 'FACULDADE DE TURISMO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (668, 843, 'FACULDADE DE CINCIAS E TECNOLOGIA DE BIRIGUI', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (669, 844, 'FACULDADE DE AGRONOMIA E ENGENHARIA FLORESTAL DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (670, 845, 'FACULDADE DA FUNDAO EDUCACIONAL ARAATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (671, 846, 'FACULDADE DE ADMINISTRAO DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (672, 847, 'FACULDADE PIAUIENSE DE PROCESSAMENTO DE DADOS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (673, 848, 'FACULDADE PARAIBANA DE PROCESSAMENTO DE DADOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (674, 849, 'FACULDADE JESUTA DE FILOSOFIA E TEOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (675, 850, 'FACULDADE PRIMUS DE INFORMTICA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (676, 851, 'FACULDADE DE TECNOLOGIA EM PROCESSAMENTO DE DADOS DO LITORAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (677, 852, 'FACULDADE DE INFORMTICA E ADMINISTRAO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (678, 859, 'FACULDADE REGIONAL SANTA CRUZ DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (679, 860, 'FACULDADE DE CINCIAS SOCIAIS DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (680, 861, 'CENTRO DE ENSINO SUPERIOR DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (681, 862, 'FACULDADE ESTCIO DE S DE CAMPO GRANDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (682, 864, 'FACULDADE DE DIREITO DE VRZEA GRANDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (683, 866, 'FACULDADE DE INFORMTICA DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (684, 867, 'FACULDADE DE EDUCAO CINCIAS E LETRAS DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (685, 873, 'FACULDADES UNIFICADAS DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (686, 874, 'FACULDADE DE ESTUDOS SOCIAIS APLICADOS DE VIANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (687, 875, 'FACULDADE DE ESTUDOS SOCIAIS DE BARRA DO GARAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (688, 876, 'FACULDADE DE TECNOLOGIA DO VALE DO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (689, 877, 'FACULDADE DE ECONOMIA E PROCESSAMENTO DE DADOS DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (690, 878, 'CENTRO UNIVERSITRIO DO LESTE DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (691, 880, 'FACULDADE DE CINCIAS E TECNOLOGIA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (692, 881, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (693, 882, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE BEBEDOURO VICTRIO CARDASSI', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (694, 886, 'FACULDADE PAULISTA DE ADMINISTRAO E CINCIAS CONTBEIS DE HORTOLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (695, 887, 'FACULDADE CHRISTUS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (696, 888, 'FACULDADE BANDEIRANTES DE CINCIAS EXATAS E HUMANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (697, 890, 'ESCOLA DE GOVERNO PROFESSOR PAULO NEVES DE CARVALHO', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (698, 891, 'FACULDADE BRASILEIRA DE CINCIAS EXATAS, HUMANAS E SOCIAIS - FABRAI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (699, 896, 'ESCOLA SUPERIOR DE TURISMO E HOTELARIA - FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (700, 897, 'UNIO DAS ESCOLAS SUPERIORES DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (701, 898, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS SANTA RITA DE CSSIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (702, 899, 'FACULDADES INTEGRADAS DE RIO VERDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (703, 900, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E DE TECNOLOGIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (704, 903, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (705, 904, 'FACULDADE DE PROCESSAMENTO DE DADOS DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (706, 905, 'FACULDADE ESCOLA PAULISTA DE DIREITO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (707, 906, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE SUMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (708, 907, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE INDAIATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (709, 908, 'FACULDADE ALAGOANA DE ADMINISTRAO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (710, 909, 'FACULDADE DE BELFORD ROXO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (711, 910, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS SANTA LCIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (712, 911, 'FACULDADES UNIDAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (713, 912, 'FACULDADE COMPACTO DE CINCIAS GERENCIAIS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (714, 913, 'FACULDADES INTEGRADAS DE PARANABA - FIPAR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (715, 914, 'FACULDADE PARANAENSE DE ADMINISTRAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (716, 915, 'FACULDADE DE ADMINISTRAO DE FTIMA DO SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (717, 916, 'FACULDADE DE CINCIAS HUMANAS E JURDICAS DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (718, 917, 'FACULDADE DE CINCIAS CONTBEIS DE NAVIRAI', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (719, 918, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (720, 922, 'FACULDADE DE CINCIAS GERENCIAIS DE DRACENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (721, 923, 'FACULDADE DE ADMINISTRAO E CINCIAS CONTBEIS DE SO ROQUE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (722, 924, 'FACULDADE INTERLAGOS DE EDUCAO E CULTURA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (723, 925, 'FACULDADE DE CINCIAS GERNCIAIS DE VILHENA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (724, 926, 'CENTRO UNIVERSITRIO DE CAMPO GRANDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (725, 927, 'CENTRO DE ESTUDOS SUPERIORES DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (726, 929, 'INSTITUTO MANAUARA DE ENSINO SUPERIOR', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (727, 930, 'FACULDADE DE EDUCAO DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (728, 934, 'FACULDADE SO CARLOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (729, 935, 'FACULDADE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (730, 939, 'FACULDADE CATLICA DE ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (731, 940, 'FACULDADE DE CINCIAS CONTBEIS DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (732, 941, 'FACULDADE DE EDUCAO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (733, 944, 'ESCOLA SUPERIOR DE PROPAGANDA E MARKETING DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (734, 945, 'INSTITUTO DE CINCIAS SOCIAIS E HUMANAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (735, 950, 'UNIO DE ENSINO SUPERIOR DE NOVA MUTUM', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (736, 951, 'FACULDADES INTEGRADAS DE COXIM', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (737, 952, 'UNIVERSIDADE SANTA CECLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (738, 953, 'UNIVERSIDADE METROPOLITANA DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (739, 954, 'FACULDADE DE CINCIAS AGRO- AMBIENTAIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (740, 955, 'FACULDADE DE FILOSOFIA NOSSA SENHORA IMACULADA CONCEIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (741, 959, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (742, 960, 'FACULDADE DE CINCIAS CONTBEIS DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (743, 961, 'FACULDADE GARCIA SILVEIRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (744, 966, 'FACULDADE DE TURISMO - SANTOS DUMONT', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (745, 967, 'FACULDADE DE TECNOLOGIA DE TAQUARITINGA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (746, 968, 'FACULDADE DE TECNOLOGIA EM PROCESSAMENTO DE DADOS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (747, 969, 'FACULDADE DE TURISMO - FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (748, 970, 'FACULDADE DE SERVIO SOCIAL DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (749, 971, 'FACULDADE DE TECNOLOGIA E CINCIAS DE CONSELHEIRO LAFAIETE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (750, 973, 'FACULDADE DE CINCIAS GERENCIAIS E ORAMENTOS E CONTBEIS LUCLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (751, 975, 'FACULDADE DE FISIOTERAPIA DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (752, 976, 'FACULDADES INTEGRADAS DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (753, 977, 'FACULDADE SO CAMILO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (754, 980, 'FACULDADE DE ADMINISTRAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (755, 983, 'FACULDADE PRUDENTE DE MORAES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (756, 984, 'FACULDADE DE EDUCAO DE IVAIPOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (757, 985, 'FACULDADE DE CINCIAS E EDUCAO DE RUBIATABA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (758, 986, 'FACULDADE DE EDUCAO E CULTURA MONTESSORI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (759, 988, 'FACULDADE DE COMUNICAO SOCIAL TAMOIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (760, 989, 'ESCOLA SUPERIOR DE BIOLOGIA E MEIO AMBIENTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (761, 990, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE CONGONHAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (762, 991, 'FACULDADE SENAI-CETIQT', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (763, 994, 'FACULDADE FLAMA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (764, 997, 'FACULDADE DE CINCIAS ECONMICAS DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (765, 998, 'FACULDADE DE SERVIO SOCIAL DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (766, 999, 'FACULDADE DE DIREITO DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (767, 1001, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (768, 1002, 'FACULDADE DE DIREITO DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (769, 1003, 'FACULDADE DE SERVIO SOCIAL PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (770, 1012, 'FACULDADE DE FORMAO DE PROFESSORES DE AFOGADOS DA INGAZEIRA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (771, 1013, 'FACULDADE SUDOESTE PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (772, 1014, 'INSTITUTO SUPERIOR E CENTRO EDUCACIONAL LUTERANO - BOM JESUS - IELUSC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (773, 1015, 'FACULDADE DE CINCIAS CONTBEIS MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (774, 1016, 'FACULDADE DE CINCIAS HUMANAS DO VALE DO PIRANGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (775, 1017, 'FACULDADE STEFANINI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (776, 1019, 'FACULDADE DE CINCIAS E TECNOLOGIA DE UNA - FACTU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (777, 1021, 'FACULDADE DE CINCIAS DE TIMBABA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (778, 1027, 'UNIVERSIDADE ESTADUAL DO NORTE FLUMINENSE DARCY RIBEIRO', 2, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (779, 1028, 'UNIVERSIDADE ESTADUAL DE MATO GROSSO DO SUL', 2, 1, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (780, 1030, 'FACULDADE DE ECONOMIA E FINANAS IBMEC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (781, 1031, 'FACULDADE ANDR DA SILVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (782, 1032, 'CENTRO UNIVERSITRIO SALESIANO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (783, 1034, 'UNIO DE ESCOLAS SUPERIORES DA FUNESO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (784, 1036, 'UNIVERSIDADE DO ESTADO DE MINAS GERAIS', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (785, 1038, 'FACULDADES INTEGRADAS DE TRS LAGOAS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (786, 1040, 'FACULDADES DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (787, 1041, 'CENTRO UNIVERSITRIO UNIVATES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (788, 1042, 'UNIVERSIDADE POSITIVO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (789, 1043, 'CENTRO UNIVERSITRIO HERMINIO OMETTO DE ARARAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (790, 1045, 'CENTRO UNIVERSITRIO ANHANGERA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (791, 1046, 'UNIO DAS FACULDADES DOS GRANDES LAGOS - UNILAGO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (792, 1047, 'FACULDADE TECNOLGICA PORTO-ALEGRENSE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (793, 1048, 'FACULDADE CAMPOS ELSEOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (794, 1049, 'INSTITUTO DE ENSINO SUPERIOR FUCAPI', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (795, 1051, 'FACULDADE DE CINCIAS CONTBEIS - MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (796, 1052, 'FACULDADE ADVENTISTA DE ADMINISTRAO DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (797, 1053, 'FACULDADE DE TECNOLOGIA E CINCIAS DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (798, 1054, 'ESCOLA BAHIANA DE ADMINISTRAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (799, 1055, 'FACULDADE MAURCIO DE NASSAU DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (800, 1058, 'CENTRO UNIVERSITRIO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (801, 1059, 'FACULDADE LOURENO FILHO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (802, 1060, 'INSTITUTO DE EDUCAO SUPERIOR DE BRASLIA - IESB', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (803, 1061, 'FACULDADE PLANALTO DE ADMINISTRAO E CINCIAS ECONMICAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (804, 1063, 'FACULDADE BATISTA DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (805, 1064, 'FACULDADE BATISTA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (806, 1065, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (807, 1066, 'INSTITUTO DE ENSINO E PESQUISA OBJETIVO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (808, 1067, 'FACULDADE DE JUSSARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (809, 1068, 'FACULDADE ALDETE MARIA ALVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (810, 1069, 'CENTRO REGIONAL DE ESTUDOS EM CINCIAS HUMANAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (811, 1070, 'INSTITUTO DE ENSINO SUPERIOR CENECISTA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (812, 1071, 'INSTITUTO DE ENSINO SUPERIOR DA FUNLEC', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (813, 1072, 'FACULDADE AFIRMATIVO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (814, 1075, 'INSTITUTO DE EDUCAO SUPERIOR DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (815, 1076, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE CAJAZEIRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (816, 1077, 'FACULDADE INTEGRADA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (817, 1078, 'FACULDADE INTEGRADO DE CAMPO MOURO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (818, 1079, 'FACULDADE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (819, 1080, 'FACULDADE ARTHUR S EARP NETO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (820, 1081, 'FACULDADE DE ENGENHARIA DE RESENDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (821, 1082, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO RIO GRANDE DO NORTE', 1, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (822, 1084, 'FACULDADE CENECISTA DE BENTO GONALVES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (823, 1085, 'FACULDADE METODISTA DE SANTA MARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (824, 1086, 'FACULDADE DE EDUCAO DE COLORADO DO OESTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (825, 1087, 'FACULDADES INTEGRADAS APARCIO CARVALHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (826, 1088, 'FACULDADE DE DESENHO INDUSTRIAL DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (827, 1089, 'CENTRO DE EDUCAO SUPERIOR - NICA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (828, 1090, 'FACULDADE SO LUS DE FRANA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (829, 1091, 'FACULDADE DE PEDAGOGIA DE VARGEM GRANDE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (830, 1092, 'FACULDADES INTEGRADAS DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (831, 1093, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (832, 1095, 'FACULDADE DE ADMINISTRAO E NEGCIOS DE MONTE ALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (833, 1096, 'FACULDADE DE PRESIDENTE EPITCIO - FAPE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (834, 1097, 'FACULDADES INTEGRADAS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (835, 1099, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (836, 1100, 'FACULDADE CARLOS DRUMMOND DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (837, 1101, 'FACULDADE ADVENTISTA DE CINCIAS DA SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (838, 1102, 'FACULDADE DE INFORMTICA - MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (839, 1103, 'FACULDADE DE ADMINISTRAO SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (840, 1104, 'FACULDADE DE COMUNICAO SOCIAL DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (841, 1107, 'FACULDADE INTEGRADA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (842, 1108, 'FACULDADE DE CINCIAS GERENCIAIS - COTIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (843, 1111, 'FACULDADE DE TURISMO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (844, 1112, 'FACULDADE DE RELAES INTERNACIONAIS DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (845, 1113, 'CENTRO UNIVERSITRIO EURO-AMERICANO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (846, 1114, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS APLICADAS RIO BRANCO - FIRB', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (847, 1115, 'FACULDADE SANTA TEREZINHA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (848, 1116, 'FACULDADE CAIARAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (849, 1117, 'FACULDADE SENAC DE COMUNICAO E ARTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (850, 1118, 'UNIO DAS ESCOLAS DO GRUPO FAIMI DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (851, 1119, 'FACULDADE PLANALTO DE FILOSOFIA, CINCIAS E LETRAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (852, 1120, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA FLUMINENSE', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (853, 1122, 'FACULDADE DE EDUCAO DE OSVALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (854, 1123, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (855, 1124, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (856, 1125, 'FACULDADES INTEGRADAS ESPRITA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (857, 1126, 'UNIVERSIDADE ESTADUAL DO CENTRO OESTE', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (858, 1128, 'UNIVERSIDADE DE ITANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (859, 1129, 'CENTRO UNIVERSITRIO DO NORTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (860, 1130, 'FACULDADE METODISTA DE CINCIAS HUMANAS E EXATAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (861, 1131, 'FACULDADE SANTO AGOSTINHO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (862, 1132, 'FACULDADE DE CINCIA DA COMPUTAO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (863, 1134, 'FACULDADE EVANGLICA LUTERANA MARTINUS*', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (864, 1135, 'FACULDADE PLANALTO DE CINCIA DA COMPUTAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (865, 1136, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DE IGARASSU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (866, 1137, 'CENTRO DE ENSINO SUPERIOR HERIS DE JENIPAPO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (867, 1138, 'CENTRO DE EDUCAO SUPERIOR DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (868, 1139, 'FACULDADE DE ESTUDOS ADMINISTRATIVOS DE MINAS GERAIS - FEAD-MG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (869, 1140, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (870, 1141, 'FACULDADE GAMA E SOUZA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (871, 1142, 'FACULDADES INTEGRADAS DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (872, 1143, 'FACULDADE DE EDUCAO SUPERIOR DE TIMBABA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (873, 1144, 'FACULDADE DE CINCIAS HUMANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (874, 1145, 'FACULDADE DE CINCIAS AGRRIAS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (875, 1147, 'FACULDADE RUY BARBOSA DE PSICOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (876, 1149, 'CENTRO UNIVERSITRIO NOSSA SENHORA DO PATROCNIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (877, 1150, 'FACULDADE SENAI DE TECNOLOGIA GRFICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (878, 1151, 'FACULDADE DE ADMINISTRAO E NEGCIOS DE SERGIPE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (879, 1152, 'INSTITUTO SUL BRASIL DE ENSINO SUPERIOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (880, 1153, 'UNIVERSIDADE CNDIDO MENDES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (881, 1155, 'FACULDADE SALESIANA DE SANTA TERESA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (882, 1156, 'FACULDADE CENECISTA DE ITABORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (883, 1157, 'ESCOLA SUPERIOR SO FRANCISCO DE ASSIS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (884, 1158, 'FACULDADE RUY BARBOSA DE CINCIA DA COMPUTAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (885, 1159, 'CENTRO DE ENSINO SUPERIOR DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (886, 1160, 'FACULDADE CAMBURY', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (887, 1161, 'FACULDADE IBMEC SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (888, 1162, 'FACULDADE DE ADMINISTRAO DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (889, 1163, 'FACULDADE DE CINCIA DA COMPUTAO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (890, 1164, 'FACULDADE VARZEAGRANDENSE DE ADMINISTRAO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (891, 1166, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DA PARABA', 1, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (892, 1168, 'FACULDADE DE ANLISE DE SISTEMAS DE INFORMAO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (893, 1169, 'FACULDADE SENAC DE MODA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (894, 1170, 'FACULDADE METROPOLITANA DE CAMAARI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (895, 1171, 'FACULDADE DE LETRAS - MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (896, 1172, 'FACULDADE AD 1', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (897, 1173, 'FACULDADE JUSCELINO KUBITSCHEK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (898, 1174, 'FACULDADE DE SABAR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (899, 1175, 'FACULDADES RIOGRANDENSES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (900, 1176, 'FACULDADE DE ANGRA DOS REIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (901, 1177, 'ESCOLA SUPERIOR DE CINCIAS AGRRIAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (902, 1179, 'ESCOLA SUPERIOR DE CINCIAS DA SADE DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (903, 1180, 'FACULDADE BARDDAL DE LETRAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (904, 1181, 'FACULDADE BRASLIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (905, 1182, 'INSTITUTO DE ENSINO SUPERIOR DE AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (906, 1183, 'INSTITUTO SO JOS DOS CAMPOS DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (907, 1184, 'CENTRO DE CINCIAS DA SADE DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (908, 1185, 'CENTRO UNIVERSITRIO JORGE AMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (909, 1186, 'FACULDADE DE TURISMO E HOTELARIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (910, 1187, 'CENTRO UNIVERSITRIO MDULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (911, 1189, 'UNIVERSIDADE DO PLANALTO CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (912, 1190, 'FACULDADE INTEGRAL CANTAREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (913, 1191, 'INSTITUTO DE ENSINO SUPERIOR DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (914, 1192, 'FACULDADE DE CINCIAS DA SADE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (915, 1194, 'FACULDADE DE TECNOLOGIA DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (916, 1195, 'FACULDADE SENAI DE TECNOLOGIA MECATRNICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (917, 1196, 'CENTRO UNIVERSITRIO DE MARING - CEUMAR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (918, 1197, 'FACULDADE DE TURISMO - AEMA/RJ', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (919, 1198, 'FACULDADE DE CINCIAS SOCIAIS E APLICADAS DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (920, 1200, 'INSTITUTO BRASILIENSE DE TECNOLOGIA E CINCIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (921, 1201, 'FACULDADE DE ADMINISTRAO MILTON CAMPOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (922, 1202, 'FACULDADE SANTA RITA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (923, 1203, 'FACULDADE DE ECONOMIA DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (924, 1204, 'FACULDADE DE AMAMBAI', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (925, 1205, 'FACULDADE EDUCACIONAL DA LAPA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (926, 1206, 'FACULDADE ADVENTISTA DE FISIOTERAPIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (927, 1207, 'FACULDADE DE ADMINISTRAO GERAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (928, 1208, 'FACULDADE DE NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (929, 1209, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (930, 1210, 'FACULDADE DE CINCIAS DA COMUNICAO DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (931, 1211, 'INSTITUTO DE ENSINO SUPERIOR DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (932, 1212, 'FACULDADE DE CINCIAS CONTBEIS DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (933, 1213, 'FACULDADE FLEMING', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (934, 1215, 'FACULDADE ANGLO LATINO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (935, 1217, 'CENTRO DE TECNOLOGIA EM AUTOMAO DE INFORMTICA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (936, 1219, 'INSTITUTO ITAPETININGANO DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (937, 1220, 'INSTITUTO MATO DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (938, 1221, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (939, 1222, 'FACULDADE SENAC DE CINCIAS EXATAS E TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (940, 1223, 'FACULDADE RADIAL JABAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (941, 1224, 'CENTRO UNIVERSITRIO DE JALES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (942, 1225, 'CENTRO UNIVERSITRIO AMPARENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (943, 1226, 'INSTITUTO DE ENSINO SUPERIOR DO ACRE', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (944, 1227, 'FACULDADE SO FRANCISCO DE BARREIRAS - FASB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (945, 1228, 'FACULDADE DE TECNOLOGIA EMPRESARIAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (946, 1229, 'INSTITUTO DE ENSINO SUPERIOR DO NORDESTE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (947, 1230, 'CENTRO REGIONAL UNIVERSITRIO DE ESPRITO SANTO DO PINHAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (948, 1231, 'INSTITUTO CENECISTA DE ENSINO SUPERIOR DE SANTO NGELO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (949, 1232, 'CENTRO UNIVERSITRIO CAMPOS DE ANDRADE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (950, 1233, 'CENTRO UNIVERSITRIO CNDIDO RONDON', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (951, 1234, 'FACULDADE METROPOLITANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (952, 1235, 'ESCOLA DE EDUCAO SUPERIOR IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (953, 1236, 'ESCOLA POLITCNICA IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (954, 1237, 'FACULDADE NOSSA SENHORA APARECIDA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (955, 1238, 'FACULDADE DE CINCIAS CONTBEIS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (956, 1239, 'FACULDADE PADRO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (957, 1240, 'FACULDADE DE ESTUDOS SOCIAIS DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (958, 1241, 'FACULDADE ESPRITO SANTENSE DE ENSINO TECNOLGICO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (959, 1243, 'FACULDADE DE ADMINISTRAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (960, 1244, 'FACULDADE BRASILEIRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (961, 1245, 'FACULDADE DE CASTELO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (962, 1246, 'FACULDADE CANDIDO MENDES DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (963, 1247, 'FACULDADE DE CINCIAS CONTBEIS DE NOVA ANDRADINA - FACINAN', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (964, 1248, 'FACULDADE DE PEDAGOGIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (965, 1249, 'FACULDADE DE EDUCAO DE COSTA RICA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (966, 1252, 'FACULDADE PROMOVE DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (967, 1253, 'FACULDADE METODISTA GRANBERY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (968, 1254, 'FACULDADE DE ADMINISTRAO DE ITABIRITO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (969, 1255, 'FACULDADE BOA VIAGEM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (970, 1256, 'FACULDADE DOM BOSCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (971, 1257, 'FACULDADE DE ADMINISTRAO, CINCIAS, EDUCAO E LETRAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (972, 1258, 'FACULDADE DE CINCIAS APLICADAS DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (973, 1259, 'FACULDADE NOBEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (974, 1260, 'FACULDADE OPET', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (975, 1261, 'FACULDADE ADVENTISTA DE CINCIAS CONTBEIS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (976, 1262, 'FACULDADE ADVENTISTA DE EDUCAO DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (977, 1263, 'FACULDADE BEZERRA DE ARAJO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (978, 1264, 'FACULDADE NATALENSE PARA O DESENVOLVIMENTO DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (979, 1265, 'FACULDADE DE PROCESSAMENTO DE DADOS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (980, 1266, 'FACULDADES INTEGRADAS URUBUPUNG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (981, 1267, 'INSTITUTO DE ENSINO SUPERIOR DA GRANDE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (982, 1270, 'INSTITUTO DE ENSINO SUPERIOR COC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (983, 1271, 'FACULDADE DE COMUNICAO SOCIAL DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (984, 1272, 'FACULDADE SANTANNA DE SALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (985, 1273, 'FACULDADE CAMPO LIMPO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (986, 1274, 'FACULDADE DE EDUCAO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (987, 1275, 'FACULDADE DO GUARUJ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (988, 1276, 'INSTITUTO TAUBAT DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (989, 1277, 'FACULDADE DE INFORMTICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (990, 1278, 'FACULDADE ADVENTISTA DE EDUCAO E CINCIAS HUMANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (991, 1279, 'FACULDADE DE ITPOLIS - FACITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (992, 1280, 'INSTITUTO DE ENSINO SUPERIOR DE COTIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (993, 1281, 'FACULDADE DE CINCIAS SOCIAIS E AGRRIAS DE ITAPEVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (994, 1283, 'INSTITUTO MANCHESTER PAULISTA DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (995, 1285, 'INSTITUTO DE ENSINO SUPERIOR DE MAIRIPOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (996, 1286, 'FACULDADE SENAI DE TECNOLOGIA AMBIENTAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (997, 1287, 'FACULDADE DE CINCIAS GERENCIAIS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (998, 1288, 'FACULDADE INDEPENDENTE BUTANT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (999, 1289, 'FACULDADE DE DIREITO DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1000, 1290, 'FACULDADE ALBERT EINSTEIN DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1001, 1291, 'FACULDADE DO NORTE PIONEIRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1002, 1292, 'FACULDADES ADAMANTINENSES INTEGRADAS', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1003, 1293, 'INSTITUTO DE ENSINO SUPERIOR DO OESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1004, 1294, 'FACULDADE DAS AMRICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1005, 1295, 'FACULDADE MORUMBI SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1006, 1296, 'ESCOLA SUPERIOR DE MARKETING', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1007, 1297, 'FACULDADE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1008, 1298, 'FACULDADE DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1009, 1299, 'FACULDADES INTEGRADAS DE FERNANDPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1010, 1300, 'INSTITUTO TAQUARITINGUENSE DE ENSINO SUPERIOR DR. ARISTIDES DE CARVALHO SCHLOBACH', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1011, 1301, 'INSTITUTO MATONENSE MUNICIPAL DE ENSINO SUPERIOR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1012, 1302, 'FACULDADE BATISTA BRASILEIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1013, 1303, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA GOIANO', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1014, 1304, 'FACULDADES INTEGRADAS DE RIBEIRO PIRES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1015, 1305, 'FACULDADE DE CINCIAS JURDICAS, GERENCIAIS E EDUCAO DE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1016, 1306, 'FACULDADE DE CINCIAS CONTBEIS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1017, 1307, 'FACULDADE DE CINCIAS HUMANAS DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1018, 1308, 'FACULDADE NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1019, 1309, 'FACULDADE JESUS MARIA JOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1020, 1310, 'FACULDADE DE AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1021, 1311, 'TREVISAN ESCOLA SUPERIOR DE NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1022, 1312, 'FACULDADES INTEGRADAS DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1023, 1313, 'FACULDADE BANDEIRANTES DE EDUCAO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1024, 1314, 'INSTITUTO DE ENSINO SUPERIOR JOO ALFREDO DE ANDRADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1025, 1315, 'FACULDADE DE EDUCAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1026, 1316, 'FACULDADE DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1027, 1317, 'FACULDADE SUDOESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1028, 1318, 'FACULDADE JUVNCIO TERRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1029, 1319, 'FACULDADE TECSOMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1030, 1320, 'FACULDADE DE EDUCAO FSICA DO LITORAL NORTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1031, 1321, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS DA ZONA NORTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1032, 1322, 'FACULDADE EDUVALE DE AVAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1033, 1323, 'FACULDADE TANCREDO NEVES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1034, 1324, 'FACULDADE DE INFORMTICA LEMOS DE CASTRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1035, 1325, 'FACULDADE DE APUCARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1036, 1326, 'ESCOLA SUPERIOR DE ENSINO ANSIO TEIXEIRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1037, 1327, 'ESCOLA SUPERIOR DE PROPAGANDA E MARKETING DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1038, 1328, 'FACULDADE DE COMUNICAO E TURISMO DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1039, 1329, 'FACULDADE DE ADMINISTRAO DE DIADEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1040, 1330, 'FACULDADE COTEMIG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1041, 1331, 'FACULDADE HOYLER DE COMUNICAO SOCIAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1042, 1332, 'FACULDADE DE COMUNICAO SOCIAL DE HORTOLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1043, 1333, 'FACULDADE CECAP DO LAGO NORTE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1044, 1334, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS - FACISA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1045, 1335, 'INSTITUTO DE ENSINO SUPERIOR THATHI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1046, 1336, 'FACULDADE ASSIS GURGACZ', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1047, 1337, 'FACULDADE MATER DEI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1048, 1338, 'FACULDADE DE EDUCAO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1049, 1339, 'FACULDADE DE CINCIAS ADMINISTRATIVAS DE PARANABA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1050, 1340, 'FACULDADE DE CINCIAS GERENCIAIS DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1051, 1341, 'FACULDADE DE ARQUITETURA E URBANISMO DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1052, 1342, 'FACULDADE DE PEDAGOGIA DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1053, 1343, 'FACULDADE DE EDUCAO DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1054, 1344, 'FACULDADE DO SABER', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1055, 1345, 'FACULDADE INTEGRAO - ZONA OESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1056, 1346, 'FACULDADE BATISTA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1057, 1347, 'FACULDADE ADVENTISTA DE ADMINISTRAO DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1058, 1348, 'FACULDADE BATISTA DE ADMINISTRAO E INFORMTICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1059, 1349, 'FACULDADE DE CINCIAS ECONMICAS DE AFONSO CLUDIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1060, 1350, 'FACULDADE DO VALE DO JAGUARIBE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1061, 1351, 'INSTITUTO SUPERIOR TUPY - IST', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1062, 1352, 'FACULDADE ADVENTISTA DE EDUCAO FSICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1063, 1353, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1064, 1354, 'FACULDADE DE CINCIA DE ADMINISTRAO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1065, 1355, 'FACULDADES INTEGRADAS DE JAHU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1066, 1356, 'FACULDADES INTEGRADAS DE SANTA F DO SUL', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1067, 1357, 'INSTITUTO SUPERIOR DE EDUCAO DO RIO DE JANEIRO', 2, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1068, 1358, 'FACULDADE DE PEDAGOGIA DE AFONSO CLUDIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1069, 1359, 'FACULDADE CAPIXABA DE NOVA VENCIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1070, 1360, 'FACULDADE SO GABRIEL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1071, 1361, 'FACULDADE DOM ORIONE', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1072, 1362, 'FACULDADE UBAENSE OZANAM COELHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1073, 1363, 'FACULDADE VISCONDE DE CAIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1074, 1364, 'FACULDADE DE TECNOLOGIA E CINCIAS DE VITRIA DA CONQUISTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1075, 1365, 'CENTRO UNIVERSITRIO ADVENTISTA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1076, 1366, 'FACULDADE BARDDAL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1077, 1367, 'FACULDADE DE CINCIA DA COMPUTAO DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1078, 1368, 'FACULDADE DE CINCIAS CONTBEIS DE BOM DESPACHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1079, 1369, 'FACULDADE SENAC DE TURISMO E HOTELARIA DE GUAS DE SO PEDRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1080, 1370, 'FACULDADE SENAC DE TURISMO E HOTELARIA DE CAMPOS DO JORDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1081, 1371, 'FACULDADE DE MIRANDPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1082, 1372, 'FACULDADE SENAC DE EDUCAO AMBIENTAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1083, 1373, 'FACULDADE CASA BRANCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1084, 1374, 'FACULDADE DE CINCIAS SOCIAIS DE GUARANT DO NORTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1085, 1375, 'FACULDADE CATLICA RAINHA DA PAZ DE ARAPUTANGA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1086, 1376, 'FACULDADE COMPACTO DE EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1087, 1377, 'FACULDADE DE CINCIA E TECNOLOGIA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1088, 1378, 'FACULDADE ASSEMBLEIANA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1089, 1379, 'FACULDADES INTEGRADAS SO PEDRO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1090, 1380, 'FACULDADE DE DOMINGOS MARTINS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1091, 1381, 'FACULDADE MARTHA FALCO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1092, 1382, 'ESCOLA SUPERIOR DE TEOLOGIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1093, 1383, 'FACULDADE JOS LACERDA FILHO DE CINCIAS APLICADAS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1094, 1384, 'FACULDADE SANTA HELENA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1095, 1385, 'FACULDADES INTEGRADAS IPEP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1096, 1386, 'ESCOLA SUPERIOR DE ADMINISTRAO E MARKETING E COMUNICAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1097, 1387, 'FACULDADE OCTGONO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1098, 1388, 'FACULDADE SUMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1099, 1389, 'FACULDADE TORRICELLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1100, 1390, 'FACULDADE ELITE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1101, 1394, 'FACULDADE CASTRO ALVES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1102, 1395, 'FACULDADE DE CALDAS NOVAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1103, 1396, 'FACULDADE DINMICA DAS CATARATAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1104, 1397, 'FACULDADE OESTE MINEIRA DE INFORMTICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1105, 1398, 'FACULDADE DE DIREITO DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1106, 1399, 'FACULDADE UNISSA DE SARANDI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1107, 1400, 'FACULDADE METROPOLITANA DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1108, 1401, 'FACULDADE ADELMAR ROSADO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1109, 1402, 'INSTITUTO DE CINCIAS SOCIAIS E HUMANAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1110, 1403, 'FACULDADE DE PIMENTA BUENO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1111, 1404, 'FACULDADE DE PIRACANJUBA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1112, 1405, 'FACULDADE DE CINCIAS CONTBEIS DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1113, 1406, 'FACULDADE DE ENGENHARIA E TECNOLOGIA DO INSTITUTO MAIRIPOR DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1114, 1407, 'FACULDADE DE ECONOMIA E ADMINISTRAO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1115, 1408, 'FACULDADE DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1116, 1409, 'FACULDADE DO CENTRO LESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1117, 1410, 'REA1 - FACULDADE DE CINCIA E TECNOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1118, 1411, 'FACULDADE DOIS DE JULHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1119, 1412, 'FACULDADE ANHAGUERA DE JUNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1120, 1413, 'FACULDADE DE PRIMAVERA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1121, 1414, 'FACULDADE SO LUCAS', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1122, 1415, 'FACULDADE MAGISTER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1123, 1416, 'FACULDADE GRANDE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1124, 1417, 'FACULDADE CENECISTA DE CAMPO LARGO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1125, 1418, 'CENTRO UNIVERSITRIO TOLEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1126, 1419, 'CENTRO UNIVERSITRIO CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1127, 1420, 'FACULDADES DE DRACENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1128, 1422, 'CENTRO UNIVERSITRIO DO NORTE', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1129, 1423, 'FACULDADE IDEAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1130, 1424, 'FACULDADE PIO XII', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1131, 1425, 'FACULDADE EVOLUTIVO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1132, 1426, 'INSTITUTO LUTERANO DE ENSINO SUPERIOR DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1133, 1427, 'FACULDADE DA SERRA GACHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1134, 1428, 'INSTITUTO DE ENSINO SUPERIOR PLANALTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1135, 1429, 'FACULDADE BATISTA DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1136, 1430, 'FACULDADE ING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1137, 1431, 'FACULDADE PIRATININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1138, 1432, 'FACULDADE BERTIOGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1139, 1433, 'FACULDADE ORGENES LESSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1140, 1434, 'INSTITUTO DE ENSINO SUPERIOR DE ITAPIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1141, 1435, 'FACULDADE DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1142, 1436, 'ESCOLA SUPERIOR BATISTA DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1143, 1437, 'ESCOLA SUPERIOR DE TECNOLOGIA E EDUCAO DE RIO CLARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1144, 1438, 'FACULDADE DE ADMINISTRAO DE EMPRESAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1145, 1439, 'FACULDADE DE CINCIAS ECONMICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1146, 1440, 'INSTITUTO APHONSIANO DE ENSINO SUPERIOR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1147, 1441, 'FACULDADE DE TECNOLOGIA DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1148, 1442, 'FACULDADE DE DIREITO DE TANGAR DA SERRA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1149, 1443, 'FACULDADE NACIONAL', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1150, 1444, 'FACULDADES INTEGRADAS EINSTEIN DE LIMEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1151, 1445, 'CENTRO UNIVERSITRIO DO INSTITUTO MAU DE TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1152, 1446, 'CENTRO UNIVERSITRIO PLANALTO DO DISTRITO FEDERAL - UNIPLAN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1153, 1447, 'FACULDADE DE DIREITO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1154, 1448, 'FACULDADE DO CENTRO EDUCACIONAL DE NITERI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1155, 1449, 'FACULDADE DE EDUCAO, ADMINISTRAO E TECNOLOGIA DE IBAITI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1156, 1450, 'CENTRO UNIVERSITRIO DO CERRADO-PATROCNIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1157, 1451, 'FACULDADES INTEGRADAS DE SO CARLOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1158, 1452, 'FACULDADE ATENAS MARANHENSE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1159, 1453, 'FACULDADE SARANDI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1160, 1454, 'FACULDADE SALESIANA DO NORDESTE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1161, 1455, 'FACULDADE SANTSSIMO SACRAMENTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1162, 1456, 'FACULDADE DE SERTOZINHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1163, 1457, 'FACULDADE EURO-PANAMERICANA DE HUMANIDADES E TECNOLOGIAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1164, 1458, 'FACULDADE DO NORTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1165, 1459, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1166, 1460, 'FACULDADE DE CINCIAS SOCIAIS E APLICADAS DO COMPLEXO DE ENSINO SUPERIOR DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1167, 1461, 'FACULDADE DE TECNOLOGIA E CINCIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1168, 1462, 'INSTITUTO PARAIBANO DE ENSINO RENOVADO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1169, 1463, 'FACULDADE ALFACASTELO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1170, 1464, 'FACULDADE MDULO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1171, 1465, 'FACULDADE BANDEIRANTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1172, 1466, 'INSTITUTO DE ENSINO SUPERIOR DE ALPHAVILLE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1173, 1467, 'FACULDADE CENECISTA DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1174, 1468, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1175, 1469, 'FACULDADE DE CINCIAS SOCIAIS DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1176, 1470, 'FACULDADE CAMES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1177, 1471, 'INSTITUTO DE ENSINO SUPERIOR DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1178, 1472, 'CENTRO UNIVERSITRIO LEONARDO DA VINCI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1179, 1473, 'FACULDADE DE ADMINISTRAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1180, 1474, 'FACULDADE DE EDUCAO DE ATIBAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1181, 1475, 'FACULDADE DE CINCIAS ECONMICAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1182, 1476, 'FACULDADES INTEGRADAS INTERAMERICANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1183, 1477, 'FACULDADE MICHELANGELO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1184, 1478, 'FACULDADE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1185, 1479, 'FACULDADES INTEGRADAS TIBIRI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1186, 1480, 'FACULDADE DE LETRAS DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1187, 1481, 'FACULDADE DE ADMINISTRAO DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1188, 1482, 'FACULDADE DE CINCIAS ECONMICAS VIANNA JNIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1189, 1483, 'FACULDADE DE CINCIAS ECONMICAS DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1190, 1484, 'FACULDADE IBMEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1191, 1485, 'FACULDADE DE ENFERMAGEM DE CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1192, 1486, 'FACULDADE ESTCIO DE S DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1193, 1487, 'FACULDADE DOM BOSCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1194, 1488, 'FACULDADE PARASO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1195, 1489, 'FACULDADE DE SELVRIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1196, 1490, 'FACULDADE DE JAGUARINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1197, 1491, 'FACULDADE INTERNACIONAL DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1198, 1492, 'FACULDADE DE CINCIAS APLICADAS DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1199, 1493, 'FACULDADE ALVES FARIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1200, 1494, 'FACULDADE SALESIANA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1201, 1495, 'FACULDADE UNIO DE QUEDAS DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1202, 1496, 'FACULDADE ESTCIO DE S DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1203, 1497, 'FACULDADE DE ADMINISTRAO DE SANTA CRUZ DO RIO PARDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1204, 1498, 'INSTITUTO DE ENSINO SUPERIOR E FORMAO AVANADA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1205, 1499, 'FACULDADE TABOO DA SERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1206, 1500, 'FACULDADE DE ENSINO SUPERIOR DE SO MIGUEL DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1207, 1501, 'FACULDADE LATINO AMERICANA DE EDUCAO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1208, 1502, 'FACULDADE JAPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1209, 1503, 'FACULDADE DOUTOR LEOCDIO JOS CORREIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1210, 1504, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE MACEI - ESAMC', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1211, 1505, 'FACULDADE DE MEDICINA VETERINRIA E ZOOTECNIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1212, 1506, 'INSTITUTO CENECISTA FAYAL DE ENSINO SUPERIOR', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1213, 1507, 'FACULDADE CENECISTA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1214, 1508, 'FACULDADE METROPOLITANA DE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1215, 1509, 'FACULDADE ESTCIO DE S DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1216, 1510, 'FACULDADE ESTCIO DE S DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1217, 1511, 'FACULDADE DE ENFERMAGEM DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1218, 1512, 'FACULDADE DE CINCIA DA EDUCAO DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1219, 1513, 'INSTITUTO DE CINCIAS JURDICAS E SOCIAIS PROFESSOR CAMILLO FILHO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1220, 1514, 'FACULDADE VALE DO CRICAR', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1221, 1515, 'FACULDADE DE EDUCAO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1222, 1516, 'FACULDADE DE VINHEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1223, 1517, 'FACULDADE NOVO ATENEU DE GUARAPUAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1224, 1518, 'FACULDADE SANTA TEREZINHA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1225, 1519, 'FACULDADE DE PATO BRANCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1226, 1520, 'FACULDADE MRIO DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1227, 1521, 'INSTITUTO DE ESTUDOS SUPERIORES DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1228, 1522, 'FACULDADE DE EDUCAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1229, 1523, 'FACULDADE DE DIREITO FRANCISCO BELTRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1230, 1524, 'FACULDADES INTEGRADAS OLGA METTIG', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1231, 1525, 'FACULDADE DE CINCIAS CONTBEIS DE AFONSO CLUDIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1232, 1526, 'FACULDADE SENAI DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1233, 1527, 'FACULDADE TAMOIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1234, 1528, 'FACULDADE DE CINCIAS HUMANAS SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1235, 1529, 'FACULDADE DE EDUCAO FSICA DE AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1236, 1530, 'FACULDADE CENECISTA DE JOINVILLE - FACE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1237, 1531, 'FACULDADE DE ENFERMAGEM DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1238, 1532, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS NOSSA SENHORA APARECIDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1239, 1533, 'FACULDADE DE COMUNICAO SOCIAL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1240, 1534, 'FACULDADE DE CINCIAS, LETRAS E EDUCAO DO NOROESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1241, 1535, 'FACULDADE SO JUDAS TADEU DE PINHAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1242, 1536, 'FACULDADE DE TELMACO BORBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1243, 1537, 'FACULDADE EXPONENCIAL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1244, 1538, 'FACULDADE PROJEO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1245, 1539, 'FACULDADE TALO BRASILEIRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1246, 1540, 'INSTITUTO DE ENSINO SUPERIOR DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1247, 1541, 'FACULDADE FLAMINGO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1248, 1542, 'CENTRO UNIVERSITRIO GERALDO DI BIASE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1249, 1543, 'FACULDADE DE DIREITO DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1250, 1544, 'FACULDADE DECISO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1251, 1545, 'INSTITUTO DE EDUCAO SUPERIOR DE BOITUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1252, 1546, 'FACULDADE DE EDUCAO SO FRANCISCO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1253, 1547, 'FACULDADE DE MEDICINA DE JUAZEIRO DO NORTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1254, 1548, 'FACULDADE CAMPO GRANDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1255, 1549, 'FACULDADE PALAS ATENA DE CHOPINZINHO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1256, 1550, 'FACULDADE DE EDUCAO FSICA DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1257, 1551, 'FACULDADE FRANCO-BRASILEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1258, 1552, 'FACULDADE PIAUIENSE', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1259, 1553, 'FACULDADE DE ODONTOLOGIA DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1260, 1554, 'FACULDADES INTEGRADAS DO VALE DO RIBEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1261, 1555, 'FACULDADE DE DIREITO DE GUARAPUAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1262, 1556, 'FACULDADE SETE DE SETEMBRO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1263, 1557, 'UNIVERSIDADE FUMEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1264, 1558, 'INSTITUTO DE ENSINO SUPERIOR DE JOO MONLEVADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1265, 1559, 'CENTRO UNIVERSITRIO DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1266, 1561, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1267, 1562, 'FACULDADE DE ILHA SOLTEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1268, 1563, 'FACULDADE DE SADE, CINCIAS HUMANAS E TECNOLGICAS DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1269, 1564, 'FACULDADE SUL FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1270, 1565, 'FACULDADE UNIME DE CINCIAS JURDICAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1271, 1566, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1272, 1567, 'FACULDADE VIZINHANA VALE DO IGUAU', 3, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1273, 1568, 'FACULDADES INTEGRADAS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1274, 1569, 'FACULDADES INTEGRADAS DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1275, 1570, 'FACULDADE DE CINCIAS CONTBEIS DE POMBAL', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1276, 1571, 'FACULDADE UNIME DE CINCIAS SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1277, 1572, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1278, 1573, 'FACULDADE ALFREDO NASSER', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1279, 1574, 'FACULDADE EDUCACIONAL DE MEDIANEIRA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1280, 1575, 'CENTRO UNIVERSITRIO DO PLANALTO DE ARAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1281, 1576, 'INSTITUTO DE ENSINO SUPERIOR BLAURO CARDOSO DE MATTOS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1282, 1577, 'FACULDADE INTERMUNICIPAL DO NOROESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1283, 1578, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA SUL-RIO-GRANDENSE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1284, 1579, 'FACULDADE DE CINCIAS SOCIAIS DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1285, 1580, 'FACULDADE DE CINCIAS E EDUCAO SENA AIRES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1286, 1581, 'FACULDADE DA CIDADE DE SANTA LUZIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1287, 1582, 'FACULDADE DECISO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1288, 1583, 'FACULDADE DE TECNOLOGIA DE INDAIATUBA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1289, 1584, 'FACULDADE DE TECNOLOGIA DE GUARATINGUET', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1290, 1585, 'FACULDADE ENERGIA DE ADMINISTRAO E NEGCIOS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1291, 1586, 'UNIVERSIDADE DO VALE DO SAPUCA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1292, 1587, 'FACULDADES INTEGRADAS DE TANGAR DA SERRA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1293, 1588, 'FACULDADE PITGORAS DE TURISMO E HOTELARIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1294, 1589, 'FACULDADE DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1295, 1590, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS APLICADAS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1296, 1591, 'FACULDADE SEAMA', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1297, 1592, 'FACULDADE DE ODONTOLOGIA DE MANAUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1298, 1593, 'FACULDADE DE PEDAGOGIA DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1299, 1594, 'FACULDADE DE LETRAS DA INSTITUIO DE ENSINO SUPERIOR DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1300, 1595, 'FACULDADE DE LETRAS UNIO DE ENSINO SUPERIOR CERTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1301, 1596, 'FACULDADE DE CINCIAS E EDUCAO DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1302, 1597, 'FACULDADE SANTA F', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1303, 1598, 'FACULDADE POLITCNICA DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1304, 1599, 'INSTITUTO DE ENSINO SUPERIOR PRESIDENTE TANCREDO DE ALMEIDA NEVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1305, 1600, 'INSTITUTO DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1306, 1601, 'FACULDADE CIDADE DE COROMANDEL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1307, 1602, 'FACULDADE DE CINCIAS GERENCIAIS DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1308, 1603, 'FACULDADE DE COMUNICAO SOCIAL DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1309, 1604, 'FACULDADE MAGNUN DE EDUCAO FSICA E ESPORTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1310, 1605, 'FACULDADE DE ADMINISTRAO DE NOVA ANDRADINA - FANOVA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1311, 1606, 'FACULDADE VALE DO APOR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1312, 1607, 'FACULDADE LUTERANA SO MARCOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1313, 1608, 'FACULDADE DE INFORMTICA DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1314, 1609, 'FACULDADE DOS CERRADOS PIAUIENSES', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1315, 1610, 'FACULDADE DAS ATIVIDADES EMPRESARIAIS DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1316, 1611, 'FACULDADE EDUCACIONAL DE ARAPOTI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1317, 1612, 'FACULDADE SUL BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1318, 1613, 'FACULDADE ADVENTISTA PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1319, 1614, 'FACULDADE PALAS ATENA DE ASTORGA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1320, 1615, 'INSTITUTO SUPERIOR DO LITORAL DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1321, 1616, 'FACULDADE ANGEL VIANNA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1322, 1617, 'FACULDADE DE CINCIAS ECONMICAS DA REGIO CARBONFERA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1323, 1618, 'INSTITUTO BLUMENAUENSE DE ENSINO SUPERIOR', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1324, 1619, 'FACULDADE ERNESTO RISCALI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1325, 1620, 'FACULDADE SANTA RITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1326, 1621, 'FACULDADE NETWORK', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1327, 1622, 'FACULDADE DO INTERIOR PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1328, 1623, 'FACULDADE DE CINCIAS AGRRIAS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1329, 1624, 'FACULDADE MARECHAL RONDON', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1330, 1625, 'FACULDADE REUNIDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1331, 1626, 'CENTRO DE TECNOLOGIA E CINCIA - CETEC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1332, 1627, 'FACULDADE DE EDUCAO DE MONTE ALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1333, 1628, 'FACULDADE DE CINCIAS HUMANAS DE AGUA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1334, 1629, 'INSTITUTO DE ENSINO SUPERIOR AQUIDAUANENSE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1335, 1630, 'FACULDADE ITABIRANA DE DESENVOLVIMENTO DAS CINCIAS E TECNOLOGIAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1336, 1631, 'FACULDADE PITGORAS DE FISIOTERAPIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1337, 1632, 'FACULDADE METROPOLITANA LONDRINENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1338, 1633, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE CUIAB', 1, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1339, 1634, 'FACULDADE BATISTA DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1340, 1635, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1341, 1636, 'CASTELLI ESCOLA SUPERIOR DE HOTELARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1342, 1637, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DE MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1343, 1638, 'FACULDADE DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1344, 1639, 'FACULDADE HLIO ROCHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1345, 1640, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1346, 1641, 'FACULDADE SOCIAL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1347, 1642, 'FACULDADE DE TECNOLOGIA E CINCIAS DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1348, 1643, 'FACULDADE ANSIO TEIXEIRA DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1349, 1644, 'FACULDADE UNIME DE EDUCAO E COMUNICAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1350, 1645, 'FACULDADE DE TECNOLOGIA E CINCIAS DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1351, 1646, 'FACULDADE DE EDUCAO CINCIAS E LETRAS DE PARASO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1352, 1647, 'INSTITUTO DE ENSINO SUPERIOR DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1353, 1648, 'FACULDADE COMPACTO DE COMUNICAO SOCIAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1354, 1649, 'FACULDADE DE COMUNICAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1355, 1650, 'FACULDADE J. SIMES ENSINO SUPERIOR', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1356, 1651, 'FACULDADE DE EDUCAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1357, 1652, 'FACULDADE DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1358, 1653, 'FACULDADE DE GUAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1359, 1654, 'INSTITUTO DE ENSINO SUPERIOR DE NOVA VENCIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1360, 1655, 'FACULDADE CENECISTA DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1361, 1656, 'INSTITUTO DE ENSINO SUPERIOR DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1362, 1657, 'FACULDADE EDUCACIONAL DE DOIS VIZINHOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1363, 1658, 'FACULDADE INTEGRADA DA GRANDE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1364, 1659, 'FACULDADE ESTCIO DE S DE OURINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1365, 1660, 'FACULDADE DE CINCIAS SOCIAIS E TECNOLGICAS FACITEC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1366, 1661, 'FACULDADE DE ADMINISTRAO ESCOLA SUPERIOR PROFESSOR PAULO MARTINS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1367, 1662, 'FACULDADE CAPIXABA DE ADMINISTRAO E EDUCAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1368, 1663, 'FACULDADE ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1369, 1664, 'FACULDADE DA SADE E ECOLOGIA HUMANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1370, 1665, 'FACULDADE KENNEDY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1371, 1666, 'FACULDADE NOVOS HORIZONTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1372, 1667, 'FACULDADE INTERNACIONAL DE CINCIAS EMPRESARIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1373, 1668, 'FACULDADE METROPOLITANA DE BELO HORIZONTE -METROPOLITANA -BH', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1374, 1669, 'INSTITUTO METROPOLITANO DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1375, 1670, 'FACULDADE ASA DE BRUMADINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1376, 1671, 'FACULDADE DE ENSINO UNIFICADO DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1377, 1672, 'INSTITUTO ESPERANA DE ENSINO SUPERIOR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1378, 1673, 'FACULDADE DE AGRONOMIA DE POMBAL', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1379, 1674, 'INSTITUTO SALESIANO DE FILOSOFIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1380, 1675, 'FACULDADE METROPOLITANA DA GRANDE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1381, 1676, 'FACULDADE SO MIGUEL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1382, 1677, 'FACULDADE DE ENSINO SUPERIOR DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1383, 1678, 'FACULDADE DE CINCIAS DE WENCESLAU BRAZ', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1384, 1679, 'FACULDADE DE CAMPINA GRANDE DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1385, 1680, 'FACULDADE DE CINCIAS E TECNOLOGIA MATER CHRISTI', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1386, 1681, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS IBMEC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1387, 1682, 'FACULDADE SALESIANA MARIA AUXILIADORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1388, 1683, 'FACULDADE PIAUIENSE', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1389, 1684, 'FACULDADE DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1390, 1685, 'FACULDADE BARDDAL DE CINCIAS CONTBEIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1391, 1686, 'FACULDADE BARDDAL DE ARTES APLICADAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1392, 1687, 'FACULDADE IDEPE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1393, 1688, 'FACULDADE SENAC DE EDUCAO EM SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1394, 1689, 'FACULDADE SANTA IZILDINHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1395, 1690, 'FACULDADE DE SO VICENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1396, 1691, 'FACULDADE PRXIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1397, 1692, 'ESCOLA SUPERIOR DE TECNOLOGIA E EDUCAO DE PORTO FERREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1398, 1693, 'FACULDADE ITANHAM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1399, 1694, 'ESCOLA SUPERIOR DE CRICIMA - ESUCRI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1400, 1695, 'FACULDADE DE EDUCAO DE BOM DESPACHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1401, 1696, 'FACULDADE CENTRAL DE CRISTALINA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1402, 1697, 'FACULDADE ESCRITOR OSMAN DA COSTA LINS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1403, 1698, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO CESCARELI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1404, 1699, 'FACULDADE DE EDUCAO DE JARU', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1405, 1700, 'FACULDADE SETE LAGOAS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1406, 1701, 'FACULDADE MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1407, 1702, 'FACULDADE ATUAL DA AMAZNIA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1408, 1703, 'INSTITUTO DE ENSINO SUPERIOR DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1409, 1704, 'FACULDADE DE ADMINISTRAO DO ALTO VALE DO RIO TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1410, 1705, 'FACULDADE DE EDUCAO DO ALTO VALE DO RIO TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1411, 1706, 'FACULDADE DE INFORMTICA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1412, 1707, 'FACULDADE DE CINCIAS CONTBEIS DE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1413, 1708, 'INSTITUTO PERNAMBUCANO DE ENSINO SUPERIOR', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1414, 1709, 'FACULDADE INTEGRADA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1415, 1710, 'FACULDADE DE NEGCIOS E TECNOLOGIAS DA INFORMAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1416, 1711, 'FACULDADE DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1417, 1712, 'FACULDADE DE CINCIAS E TECNOLOGIA DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1418, 1713, 'FACULDADE DE TECNOLOGIA DE SO VICENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1419, 1714, 'ESCOLA SUPERIOR DE GESTO COMERCIAL E MARKETING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1420, 1715, 'FACULDADE DO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1421, 1716, 'FACULDADE UNIO DAS AMRICAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1422, 1717, 'FACULDADE DE IMPERATRIZ', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1423, 1718, 'FACULDADE NOBRE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1424, 1719, 'FACULDADE DE ADMINISTRAO DE CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1425, 1720, 'FACULDADE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1426, 1721, 'FACULDADE DE VIOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1427, 1722, 'FACULDADE DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1428, 1723, 'ESCOLA SUPERIOR DE ADMINISTRAO E GESTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1429, 1724, 'FACULDADE DE GUARARAPES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1430, 1725, 'FACULDADE XV DE AGOSTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1431, 1726, 'FACULDADE SANTA AMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1432, 1727, 'FACULDADE DE CARIACICA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1433, 1728, 'FACULDADE INTERAMERICANA DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1434, 1729, 'FACULDADE DE ODONTOLOGIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1435, 1730, 'FACULDADE NORTE CAPIXABA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1436, 1731, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1437, 1732, 'FACULDADE GENNARI E PEARTREE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1438, 1733, 'FACULDADE DE ENSINO SUPERIOR DE MARECHAL CNDIDO RONDON', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1439, 1734, 'FACULDADE INTEGRAL DIFERENCIAL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1440, 1735, 'FACULDADE DE CINCIAS APLICADAS DOUTOR LEO SAMPAIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1441, 1736, 'INSTITUTO SUPERIOR DE EDUCAO LA SALLE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1442, 1737, 'FACULDADE DE INFORMTICA DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1443, 1738, 'INSTITUTO LUTERANO DE ENSINO SUPERIOR DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1444, 1739, 'INSTITUTO DE ENSINO SUPERIOR DO CENTRO OESTE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1445, 1740, 'FACULDADE DE TECNOLOGIA RADIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1446, 1741, 'FACULDADE DE TECNOLOGIA INTERAMRICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1447, 1742, 'FACULDADE DE TECNOLOGIA CARLOS DRUMMOND DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1448, 1743, 'FACULDADE DE TECNOLOGIA OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1449, 1744, 'FACULDADE DE TECNOLOGIA OPET', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1450, 1745, 'FACULDADE DE TECNOLOGIA ALBERT EINSTEIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1451, 1746, 'FACULDADE DE TECNOLOGIA DAS AMRICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1452, 1747, 'FACULDADE DE TECNOLOGIA FLAMINGO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1453, 1748, 'FACULDADE DE TECNOLOGIA MRIO DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1454, 1749, 'FACULDADE LUSO-BRASILEIRA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1455, 1750, 'UNIDADE DE ENSINO SUPERIOR EXPOENTE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1456, 1751, 'FACULDADE DE DESIGN GRFICO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1457, 1752, 'FACULDADE AUTNOMA DE DIREITO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1458, 1753, 'FACULDADE DE ENFERMAGEM NOVA ESPERANA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1459, 1754, 'INSTITUTO SUPERIOR DE EDUCAO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1460, 1755, 'FACULDADE EQUIPE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1461, 1756, 'FACULDADE ASSOCIADA BRASIL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1462, 1757, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1463, 1758, 'FACULDADE INDEPENDENTE DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1464, 1759, 'FACULDADE PADRE JOO BAGOZZI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1465, 1760, 'FACULDADE DE PEDAGOGIA DE VITRIA DE SANTO ANTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1466, 1761, 'FACULDADE BRASILEIRA DE GESTO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1467, 1762, 'FACULDADE DE TECNOLOGIA JOO XXIII', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1468, 1763, 'FACULDADE DE TECNOLOGIA SENAI CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1469, 1764, 'FACULDADE DE EDUCAO REGIONAL SERRANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1470, 1765, 'FACULDADE DE JOS BONIFCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1471, 1766, 'FACULDADE ESPRITO SANTENSE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1472, 1767, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1473, 1768, 'FACULDADE REGIONAL SERRANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1474, 1769, 'FACULDADE DE TURISMO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1475, 1770, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DA INSTITUIO DE ENSINO SUPERIOR DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1476, 1771, 'FACULDADE SANTA MARIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1477, 1772, 'FACULDADE NORDESTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1478, 1773, 'FACULDADE DE ITAPIRANGA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1479, 1774, 'FACULDADE EDUCACIONAL DE PONTA GROSSA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1480, 1775, 'FACULDADE DO VALE DO IPOJUCA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1481, 1776, 'FACULDADE DE TECNOLOGIA PROF. LUIZ ROSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1482, 1777, 'FACULDADE METROPOLITANA DE GUARAMIRIM', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1483, 1778, 'FACULDADE DE EDUCAO, CINCIAS E LETRAS SO JUDAS TADEU', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1484, 1779, 'FACULDADE AIEC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1485, 1780, 'FACULDADE HORIZONTINA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1486, 1781, 'FACULDADE INTESP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1487, 1782, 'FACULDADE DE ARTES, CINCIAS E TECNOLOGIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1488, 1783, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1489, 1784, 'FACULDADE EDITORA NACIONAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1490, 1785, 'FACULDADE DE COLIDER', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1491, 1786, 'INSTITUTO MACHADENSE DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1492, 1787, 'INSTITUTO DE ENSINO SUPERIOR DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1493, 1788, 'FACULDADE DE ADMINISTRAO E ARTES DE LIMEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1494, 1789, 'INSTITUTO CATUA DE ENSINO SUPERIOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1495, 1790, 'INSTITUTO SUPERIOR DE EDUCAO DO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1496, 1791, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DA UNIO DE ENSINO SUPERIOR CERTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1497, 1792, 'FACULDADE DE EDUCAO DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1498, 1793, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1499, 1794, 'FACULDADE DE CINCIAS HUMANAS DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1500, 1795, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1501, 1796, 'FACULDADE DE MATEMTICA DA INSTITUIO DE ENSINO SUPERIOR DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1502, 1797, 'FACULDADE NORTE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1503, 1798, 'FACULDADE EDUCACIONAL DE CORNLIO PROCPIO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1504, 1799, 'FACULDADE BRASLIA DE TECNOLOGIA, CINCIAS E EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1505, 1800, 'FACULDADE DE REALEZA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1506, 1801, 'FACULDADE DOM BOSCO DE UBIRAT', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1507, 1802, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1508, 1803, 'FACULDADE DE INFORMTICA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1509, 1804, 'FACULDADE DE MAU - FAMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1510, 1805, 'FACULDADE DOS GUARARAPES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1511, 1806, 'FACULDADE FERNO DIAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1512, 1807, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO CEAR', 1, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1513, 1808, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO ESPRITO SANTO', 1, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1514, 1809, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE PERNAMBUCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1515, 1810, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE SO PAULO', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1516, 1811, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE GOIS', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1517, 1812, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DO AMAZONAS', 1, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1518, 1813, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO PAR', 1, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1519, 1814, 'FACULDADE DE CINCIAS SOCIAIS E APLICADAS DE DIAMANTINO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1520, 1815, 'FACULDADE DO INSTITUTO BRASIL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1521, 1816, 'INSTITUTO DE ENSINO SUPERIOR DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1522, 1817, 'FACULDADE RADIAL CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1523, 1818, 'FACULDADE PITGORAS DE ADMINISTRAO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1524, 1819, 'FACULDADE FARIAS BRITO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1525, 1820, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO PIAU', 1, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1526, 1821, 'FACULDADE LIONS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1527, 1822, 'FACULDADE SUL-AMERICANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1528, 1823, 'INSTITUTO DE ENSINO SUPERIOR DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1529, 1824, 'FACULDADE DE CINCIAS CONTBEIS DE ITABIRITO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1530, 1825, 'FACULDADE DE ESTUDOS SUPERIORES DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1531, 1826, 'FACULDADE DE DIREITO DE LEOPOLDINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1532, 1827, 'FACULDADE LUTERANA DE TEOLOGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1533, 1828, 'ESCOLA DA CIDADE - FACULDADE DE ARQUITETURA E URBANISMO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1534, 1829, 'FACULDADE DE TECNOLOGIA UIRAPURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1535, 1830, 'FACULDADE ANHANGUERA DE PASSO FUNDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1536, 1831, 'FACULDADE CENTRO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1537, 1832, 'FACULDADE DE JABOTICABAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1538, 1833, 'FACULDADE DE ARUJ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1539, 1834, 'FACULDADE DE AGUDOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1540, 1835, 'FACULDADE INTEGRADA DE ENSINO SUPERIOR DE COLINAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1541, 1836, 'CENTRO UNIVERSITRIO FUNDAO DE ENSINO OCTVIO BASTOS - FEOB', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1542, 1837, 'ESCOLA DE ESTUDOS SUPERIORES DE VIOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1543, 1838, 'FACULDADES INTEGRADAS RIO BRANCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1544, 1839, 'FACULDADES INTEGRADAS DE VRZEA GRANDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1545, 1840, 'FACULDADE CASTELO BRANCO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1546, 1841, 'FACULDADES INTEGRADAS ANTNIO EUFRSIO DE TOLEDO DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1547, 1842, 'FACULDADES INTEGRADAS MACHADO DE ASSIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1548, 1843, 'FACULDADE DE ADMINISTRAO DE CAMPO BELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1549, 1844, 'FACULDADES INTEGRADAS STELLA MARIS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1550, 1845, 'FEFISA - FACULDADES INTEGRADAS DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1551, 1846, 'CENTRO UNIVERSITRIO DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1552, 1847, 'FACULDADE ATENAS MARANHENSE DE IMPERATRIZ', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1553, 1848, 'FACULDADE CENECISTA DE SANTA TEREZINHA DE ITAIPU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1554, 1849, 'FACULDADE DE DIREITO DE MOGI MIRIM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1555, 1850, 'FACULDADE ALVORADA DE TECNOLOGIA E EDUCAO DE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1556, 1851, 'ESCOLA BRASILEIRA DE ADMINISTRAO PBLICA E DE EMPRESAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1557, 1852, 'FACULDADE SABERES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1558, 1853, 'FACULDADE DE TECNOLOGIA IBTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1559, 1854, 'FACULDADES INTEGRADAS CLARETIANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1560, 1855, 'CENTRO UNIVERSITRIO CATLICO DO SUDOESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1561, 1856, 'FACULDADE DO NORTE NOVO DE APUCARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1562, 1857, 'FACULDADE DEHONIANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1563, 1858, 'FACULDADE DE ADMINISTRAO DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1564, 1859, 'INSTITUTO SUPERIOR DE EDUCAO UIRAPURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1565, 1860, 'FACULDADE DE CINCIAS GERENCIAIS PADRE ARNALDO JANSSEN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1566, 1861, 'FACULDADE DE DIREITO DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1567, 1862, 'FACULDADE DA REGIO SERRANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1568, 1863, 'FACULDADE DE MANTENA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1569, 1864, 'FACULDADE DE ADMINISTRAO DA ASSOCIAO BRASILIENSE DE EDUCAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1570, 1865, 'INSTITUTO SUPERIOR DE EDUCAO ALVORADA PLUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1571, 1866, 'FACULDADE DE CINCIAS EMPRESARIAIS E ESTUDOS COSTEIROS DE NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1572, 1867, 'FACULDADE DE CINCIAS GERENCIAIS DE SANTOS DUMONT', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1573, 1868, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTOS DUMONT', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1574, 1869, 'CENTRO UNIVERSITRIO DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1575, 1870, 'FACULDADES INTEGRADAS REGIONAIS DE AVAR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1576, 1871, 'FACULDADE DE MEDICINA DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1577, 1872, 'FACULDADES INTEGRADAS SANTA CRUZ DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1578, 1873, 'FACULDADE MERCRIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1579, 1874, 'FACULDADE DE TECNOLOGIA DE OURINHOS', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1580, 1875, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE IBITINGA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1581, 1876, 'FACULDADE MUNICIPAL PROFESSOR FRANCO MONTORO DE MOGI GUAU', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1582, 1877, 'FACULDADE ATUAL', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1583, 1878, 'CENTRO UNIVERSITRIO DA FUNDAO EDUCACIONAL INACIANA PE SABIA DE MEDEIROS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1584, 1879, 'FACULDADE EDUCACIONAL DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1585, 1880, 'FACULDADE CASA DO ESTUDANTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1586, 1881, 'FACULDADE DA ESCADA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1587, 1882, 'FACULDADE DE ASSUNTOS ACADMICOS E CIENTFICOS MONSENHOR EDISSON VIEIRA LCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1588, 1883, 'FACULDADE DE CINCIAS AGRRIAS E DA SADE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1589, 1884, 'FACULDADE RANCHARIENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1590, 1885, 'UNIDADE DE ENSINO SUPERIOR DOM BOSCO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1591, 1886, 'FACULDADE DE MONTE ALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1592, 1887, 'FACULDADE DE DIREITO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1593, 1888, 'FACULDADE DE SADE TECSOMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1594, 1889, 'FACULDADE HOYLER DE LETRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1595, 1890, 'FACULDADE VILA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1596, 1891, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1597, 1892, 'FACULDADE ENIAC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1598, 1893, 'ESCOLA DE NEGCIOS DO ESTADO DA BAHIA - ENEB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1599, 1894, 'FACULDADE EUROPIA DE ADMINISTRAO E MARKETING', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1600, 1895, 'FACULDADE CHRISTUS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1601, 1896, 'FACULDADE DE TURISMO DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1602, 1897, 'FACULDADE DE LETRAS DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1603, 1898, 'FACULDADE DO LITORAL SUL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1604, 1899, 'FACULDADE DO NOROESTE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1605, 1900, 'FACULDADE ANCHIETA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1606, 1901, 'FACULDADE CATLICA DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1607, 1902, 'FACULDADE SANTO AGOSTINHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1608, 1903, 'FACULDADE CRISTO REI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1609, 1904, 'FACULDADE SO CAMILO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1610, 1905, 'FACULDADE SANTA ADAME', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1611, 1906, 'INSTITUTO DE ENSINO SUPERIOR MATERDEI', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1612, 1907, 'FACULDADE EDUCACIONAL DE COLOMBO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1613, 1908, 'ESCOLA DE ENSINO SUPERIOR ALTERNATIVO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1614, 1909, 'FACULDADE PEREIRA DE FREITAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1615, 1910, 'FACULDADE BAIANA DE CINCIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1616, 1911, 'FACULDADE CENTRO-OESTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1617, 1912, 'INSTITUTO SUPERIOR DE EDUCAO JAPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1618, 1913, 'FACULDADE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1619, 1914, 'FACULDADE PITGORAS DE ENFERMAGEM DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1620, 1915, 'FACULDADE DE EDUCAO SILVA SERPA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1621, 1916, 'INSTITUTO SUPERIOR DE EDUCAO PITGORAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1622, 1917, 'FACULDADE DE CINCIAS BIOMDICAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1623, 1918, 'FACULDADE CAPIVARI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1624, 1919, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS SANTO AGOSTINHO - FACET', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1625, 1920, 'FACULDADE DE FARMCIA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1626, 1921, 'FACULDADE DE SO BENTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1627, 1922, 'ESCOLA SUPERIOR DE FISIOTERAPIA - ESUFI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1628, 1923, 'FACULDADE DE DIREITO PADRE ARNALDO JANSSEN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1629, 1924, 'FACULDADE DO NORTE PIONEIRO DE JACAREZINHO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1630, 1925, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1631, 1926, 'FACULDADE DE ADMINISTRAO DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1632, 1927, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1633, 1928, 'FACULDADE CENECISTA ILHA DO GOVERNADOR', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1634, 1929, 'FACULDADE DE CINCIAS CONTBEIS - FACICONT', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1635, 1930, 'INSTITUTO SUPERIOR DE EDUCAO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1636, 1931, 'INSTITUTO DE ENSINO SUPERIOR FRANCISCANO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1637, 1932, 'FACULDADE PALOTINA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1638, 1933, 'FACULDADE BIRIGUI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1639, 1934, 'FACULDADE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1640, 1935, 'FACULDADE SO PAULO DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1641, 1936, 'FACULDADE DE LUCAS DO RIO VERDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1642, 1937, 'FACULDADE EVANGLICA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1643, 1938, 'FACULDADE GLOBAL DE UMUARAMA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1644, 1939, 'INSTITUTO DE ENSINO SUPERIOR DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1645, 1940, 'FACULDADE DE NOVA SERRANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1646, 1941, 'FACULDADE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1647, 1942, 'FACULDADE DE COMUNICAO SOCIAL DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1648, 1943, 'FACULDADE SERRANA DE ENSINO SUPERIOR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1649, 1944, 'FACULDADE DE TECNOLOGIA IBRATEC', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1650, 1945, 'FACULDADE DE SORRISO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1651, 1946, 'FACULDADE MATER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1652, 1947, 'FACULDADE DE ENGENHARIA DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1653, 1948, 'FACULDADE DE ENSINO SUPERIOR DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1654, 1949, 'FACULDADE DE PAULNIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1655, 1950, 'FACULDADE DE ORLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1656, 1951, 'INSTITUTO DE EDUCAO E ENSINO SUPERIOR DE SAMAMBAIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1657, 1952, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS APLICADAS DO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1658, 1953, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1659, 1954, 'FACULDADE DE ECONOMIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1660, 1955, 'FACULDADE DE CINCIAS HUMANAS DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1661, 1956, 'INSTITUTO BATISTA DE ENSINO SUPERIOR DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1662, 1957, 'FACULDADE DE TECNOLOGIA SENAI JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1663, 1958, 'FACULDADE DE TECNOLOGIA SENAI BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1664, 1959, 'FACULDADE DE CINCIAS JURDICAS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1665, 1960, 'FACULDADE DE MEDICINA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1666, 1961, 'INSTITUTO TECNOLGICO E DAS CINCIAS SOCIAIS APLICADAS E DA SADE DO CENTRO EDUC. N. SR AUXILIADORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1667, 1962, 'INSTITUTO SUPERIOR DE EDUCAO DO CENTRO EDUCACIONAL NOSSA SENHORA AUXILIADORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1668, 1963, 'FACULDADE DE FISIOTERAPIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1669, 1964, 'FACULDADE DE TECNOLOGIA EM HOTELARIA, GASTRONOMIA E TURISMO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1670, 1965, 'FACULDADE DE TECNOLOGIA DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1671, 1966, 'FACULDADE ALBERT EINSTEIN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1672, 1967, 'FACULDADE DO VALE DO ITAPECUR', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1673, 1968, 'FACULDADE ATLNTICO', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1674, 1969, 'FACULDADE DOS IMIGRANTES - FAI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1675, 1970, 'FACULDADE DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1676, 1971, 'FACULDADE DE TECNOLOGIA MORUMBI SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1677, 1972, 'FACULDADE TIJUCUSSU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1678, 1973, 'INSTITUTO SUPERIOR DE EDUCAO ORGENES LESSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1679, 1974, 'INSTITUTO SUPERIOR DE EDUCAO DE CAXIAS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1680, 1975, 'FACULDADE DE CINCIAS AGRRIAS DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1681, 1976, 'INSTITUTO SUPERIOR DE EDUCAO DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1682, 1977, 'CENTRO DE ESTUDOS SUPERIORES APRENDIZ', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1683, 1978, 'FACULDADE METROPOLITANA DA GRANDE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1684, 1979, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1685, 1980, 'FACULDADE SINERGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1686, 1981, 'FACULDADE MILLENNIUM', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1687, 1982, 'FACULDADE DE COMUNICAO SOCIAL DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1688, 1983, 'FACULDADE DE CINCIAS E DA SADE DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1689, 1984, 'FACULDADE DE CINCIAS GERENCIAIS DE MANHUAU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1690, 1985, 'FACULDADE COMUNITRIA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1691, 1986, 'FACULDADE ESTCIO DE S DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1692, 1987, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DEPUTADO JOS LAVIOLA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1693, 1988, 'FACULDADE AVANTIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1694, 1989, 'INSTITUTO SUPERIOR DE EDUCAO AVANTIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1695, 1990, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1696, 1991, 'FACULDADE JOO PAULO PRIMEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1697, 1992, 'INSTITUTO DE ENSINO SUPERIOR DE PIEDADE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1698, 1993, 'FACULDADE DE CINCIAS HUMANAS E DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1699, 1994, 'INSTITUTO DE ENSINO SUPERIOR DE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1700, 1995, 'FACULDADE DE MEDICINA NOVA ESPERANA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1701, 1996, 'INSTITUTO CUIAB DE ENSINO E CULTURA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1702, 1997, 'INSTITUTO DE ENSINO SUPERIOR DE ARIPUAN', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1703, 1998, 'INSTITUTO SUPERIOR DE EDUCAO ELVIRA DAYRELL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1704, 1999, 'JOHN KNOX', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1705, 2000, 'FACULDADE TATUAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1706, 2001, 'SEMINRIO ADVENTISTA LATINO-AMERICANO DE TEOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1707, 2002, 'INSTITUTO SUPERIOR DE EDUCAO DIVINO SALVADOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1708, 2003, 'FACULADE TEOLGICA SINAL', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1709, 2004, 'FACULDADE DE DIREITO PRESIDENTE CASTELO BRANCO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1710, 2005, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1711, 2006, 'INSTITUTO SUPERIOR DE EDUCAO DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1712, 2007, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1713, 2008, 'INSTITUTO SUPERIOR DE EDUCAO DE SO GOTARDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1714, 2009, 'FACULDADE DE TAQUARITINGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1715, 2010, 'FACULDADE DE CINCIAS E LETRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1716, 2011, 'INSTITUTO NACIONAL DE EDUCAO DE PORTO SEGURO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1717, 2012, 'INSTITUTO SUPERIOR DE EDUCAO DE PESQUEIRA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1718, 2013, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1719, 2014, 'FACULDADE SETELAGOANA DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1720, 2015, 'INSTITUTO SANTO TOMS DE AQUINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1721, 2016, 'LOGOS FACULDADE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1722, 2017, 'FACULDADES DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1723, 2018, 'FACULDADE EVOLUO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1724, 2019, 'INSTITUTO SUPERIOR DE EDUCAO DE SALGUEIRO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1725, 2020, 'INSTITUTO DE EDUCAO SUPERIOR EUROBRAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1726, 2021, 'FACULDADES EUROBRAS - ESTUDOS UNIVERSITRIOS REGIONAIS BRASILEIROS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1727, 2022, 'FACULDADE DE ROLIM DE MOURA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1728, 2023, 'FACULDADE DE GUANAMBI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1729, 2024, 'INSTITUTO SUPERIOR DE EDUCAO DAS CLARETIANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1730, 2025, 'INSTITUTO SUPERIOR DE EDUCAO CARLI GIOVANNI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1731, 2026, 'INSTITUTO SUPERIOR DE EDUCAO BRASIL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1732, 2027, 'FACULDADE DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1733, 2028, 'FALCUDADE DE CINCIAS ECONMICAS, CONTBEIS E ADMINISTRATIVAS DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1734, 2029, 'INSTITUTO SUPERIOR DE EDUCAO DE MARECHAL CNDIDO RONDON', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1735, 2030, 'INSTITUTO SUPERIOR DE EDUCAO CAMPO LIMPO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1736, 2031, 'FACULDADE DE EDUCAO DE PRESIDENTE MDICI', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1737, 2032, 'FACULDADE DE PEDAGOGIA E FORMAO DE NORMALISTAS DE ARAGUANA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1738, 2033, 'INSTITUTO SUPERIOR DE EDUCAO DE FLORESTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1739, 2034, 'FACULDADE DE CINCIAS CONTBEIS DE ARAGUANA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1740, 2035, 'FACULDADE JAGUARIAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1741, 2036, 'FACULDADE DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1742, 2037, 'FACULDADE UNIME DE CINCIAS EXATAS E TECNOLGICAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1743, 2038, 'INSTITUTO DE EDUCAO SUPERIOR VALE DO MEARIM', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1744, 2039, 'FACULDADE CIDADE LUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1745, 2040, 'FACULDADE DO FUTURO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1746, 2041, 'FACULDADE SUDAMRICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1747, 2042, 'FACULDADE FIGUEIREDO COSTA - FIC', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1748, 2043, 'FACULDADE VALE DO SALGADO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1749, 2044, 'INSTITUTO SUPERIOR DE EDUCAO VALE DO SALGADO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1750, 2045, 'FACULDADE AMADEUS', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1751, 2046, 'INSTITUTO SUPERIOR DE EDUCAO AMADEUS', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1752, 2047, 'FACULDADE DE PSICOLOGIA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1753, 2048, 'FACULDADE DE CINCIAS E TECNOLOGIA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1754, 2049, 'INSTITUTO DE ESTUDOS SUPERIORES DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1755, 2050, 'ESCOLA SUPERIOR DE GESTO E CINCIAS DA SADE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1756, 2051, 'FACULDADE INTERFUTURA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1757, 2052, 'FACULDADE DE DIREITO DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1758, 2053, 'FACULDADE PARA O DESENVOLVIMENTO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1759, 2054, 'FACULDADE DE EDUCAO DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1760, 2055, 'FACULDADE ARAUCRIA DO SUDOESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1761, 2056, 'FACULDADE DA ALTA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1762, 2057, 'FACULDADE DE MOGI GUAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1763, 2058, 'FACULDADE METROPOLITANA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1764, 2059, 'FACULDADE DE EDUCAO E CINCIAS DE TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1765, 2060, 'FACULDADE PADRE SEVERIANO LTDA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1766, 2061, 'FACULDADE DE FORMAO DE PROFESSORES DE ARAPIRACA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1767, 2062, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE VARGINHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1768, 2063, 'INSTITUTO NOSSA SENHORA APARECIDA DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1769, 2064, 'FACULDADE METROPOLITANA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1770, 2065, 'FACULDADE DE FILOSOFIA E TEOLOGIA DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1771, 2066, 'FACULDADE LEONARDO DA VINCI', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1772, 2067, 'FACULDADE DE CINCIAS EMPRESARIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1773, 2068, 'FACULDADE DE CASTILHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1774, 2069, 'FACULDADE DE TEOLOGIA E CINCIAS HUMANAS', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1775, 2070, 'FACULDADE DE CINCIAS SOCIAIS AMORIL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1776, 2071, 'FACULDADE TEOLGICA BATISTA DO BRASIL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1777, 2072, 'FACULDADE DE DESENVOLVIMENTO SUSTENTVEL DE CRUZEIRO DO SUL', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1778, 2073, 'INSTITUTO SUPERIOR DE EDUCAO PADRO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1779, 2074, 'INSTITUTO EDUCACIONAL SO JOO DA ESCIA DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1780, 2075, 'INSTITUTO DE ENSINO SUPERIOR DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1781, 2076, 'FACULDADE REGIONAL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1782, 2077, 'FACULDADE ANGLO-AMERICANO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1783, 2078, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1784, 2079, 'FACULDADE DE ITAITUBA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1785, 2080, 'FACULDADE UNIVRSICA DE FILOSOFIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1786, 2081, 'FACULDADE DE CINCIAS GERENCIAS DE PEDREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1787, 2082, 'FACULDADE DE CINCIAS MDICAS DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1788, 2083, 'FACULDADE DE IBITINGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1789, 2084, 'FACULDADE CENECISTA DE NOVA PETRPOLIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1790, 2085, 'INSTITUTO BAIANO DE ENSINO SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1791, 2086, 'INSTITUTO DE ENSINO SUPERIOR DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1792, 2087, 'FACULDADE MARECHAL RONDON', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1793, 2088, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1794, 2089, 'FACULDADE CENECISTA DE MOSSOR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1795, 2090, 'FACULDADE DE TURISMO DE CONGONHAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1796, 2091, 'INSTITUTO SUPERIOR DE EDUCAO PR-SABER', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1797, 2092, 'FACULDADE DOM PEDRO II', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1798, 2093, 'FACULDADE GREGOR MENDEL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1799, 2094, 'FACULDADE DE ENSINO A', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1800, 2095, 'INSITUTO SUPERIOR DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1801, 2096, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS DE MANHUAU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1802, 2097, 'ESCOLA SUPERIOR DE GUARARAPES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1803, 2098, 'FACULDADE KURIOS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1804, 2099, 'INSTITUTO DE ENSINO, PESQUISA E EXTENSO DO BRASIL OESTE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1805, 2100, 'FACULDADE DE LETRAS DO SERRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1806, 2101, 'FACULDADE ASCENSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1807, 2102, 'FACULDADE DE AURIFLAMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1808, 2103, 'FACULDADE E CENTRO DE ENSINO DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1809, 2104, 'FACULDADE DE TEOLOGIA DE HOKEMH', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1810, 2105, 'FACULDADE ADVENTISTA DE INFORMTICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1811, 2106, 'FACULDADE DE VIOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1812, 2107, 'FACULDADE IBTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1813, 2108, 'FACULDADE DE DIREITO DA SEDES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1814, 2109, 'FACULDADE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1815, 2110, 'FACULDADE DOM CSAR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1816, 2111, 'INSTITUTO SUPERIOR DE TEOLOGIA APLICADA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1817, 2112, 'FACULDADE METODISTA DE BIRIGI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1818, 2113, 'FACULDADE DOM BOSCO DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1819, 2114, 'FACULDADE DE TEOLOGIA FILADLFIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1820, 2115, 'FACULDADE JOO PAULO II', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1821, 2116, 'FACULDADE IGUAPENSE SANTO AUGUSTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1822, 2117, 'FACULDADE DE CINCIA E TECNOLOGIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1823, 2118, 'INSTITUTO DE EDUCAO SUPERIOR GUAIANS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1824, 2119, 'FACULDADE GUARARAPES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1825, 2120, 'INSTITUTO DE FILOSOFIA E DE TEOLOGIA PAULO VI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1826, 2121, 'FACULDADE DE INFORMTICA DE PEDREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1827, 2122, 'FACULDADE DE SERGIPE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1828, 2123, 'FACULDADE MAX PLANCK', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1829, 2124, 'INSTITUTO SUPERIOR DE EDUCAO DE PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1830, 2125, 'FACULDADE DE EDUCAO DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1831, 2126, 'ESCOLA DE DIREITO DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1832, 2127, 'FACULDADE BATISTA DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1833, 2128, 'ESCOLA DE DIREITO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1834, 2129, 'ESCOLA DE ECONOMIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1835, 2130, 'FACULDADE EVANGLICA DE TEOLOGIA DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1836, 2131, 'FACULDADE FAPAN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1837, 2132, 'FACULDADE BARO DO RIO BRANCO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1838, 2133, 'FACULDADE DE CINCIAS, EDUCAO E TEOLOGIA DO NORTE DO BRASIL', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1839, 2134, 'FACULDADE DA IGREJA MINISTRIO FAMA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1840, 2135, 'INSTITUTO FILOSFICO TEOLGICO NOSSA SENHORA IMACULADA RAINHA DO SERTO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1841, 2136, 'INSTITUTO DE JUNA DE ENSINO SUPERIOR', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1842, 2137, 'FACULDADE SO MARCOS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1843, 2138, 'INSTITUTO SUPERIOR DE EDUCAO DIVINO SALVADOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1844, 2139, 'FACULDADE DE INFORMTICA DE PARANABA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1845, 2140, 'INSTITUTO SUPERIOR DE EDUCAO NOSSA SENHORA DE LOURDES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1846, 2141, 'FACULDADE TEOLGICA BATISTA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1847, 2142, 'FACULDADE MULTIEDUCATIVA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1848, 2143, 'INSTITUTO SUPERIOR DE EDUCAO DE DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1849, 2144, 'FACULDADE ECOPORANGA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1850, 2145, 'FACULDADE INFRIUM DE TECNOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1851, 2146, 'FACULDADE DO ACRE', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1852, 2147, 'FACULDADE METROPOLITANA DE MANAUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1853, 2148, 'INSTITUTO PALMAS DE ENSINO SUPERIOR', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1854, 2149, 'INSTITUTO MATO GROSSO DO SUL DE EDUCAO E CULTURA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1855, 2150, 'INSTITUTO TERESINA DE ENSINO E CULTURA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1856, 2151, 'INSTITUTO SUPERIOR DE EDUCAO BERLAAR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1857, 2152, 'FACULDADE DE ADMINISTRAO E TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1858, 2153, 'FACULDADE DE DIREITO DE MACA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1859, 2154, 'INSTITUTO SUPERIOR DE CINCIAS HUMANAS E SOCIAIS ANSIO TEIXEIRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1860, 2155, 'FACULDADE DE CINCIAS SOCIAIS E DA SADE DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1861, 2156, 'FACULDADE SO TOMS DE AQUINO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1862, 2157, 'INSTITUTO SUPERIOR DE EDUCAO SANTANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1863, 2158, 'FACULDADE SANTA MARIA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1864, 2160, 'FACULDADE SANT''ANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1865, 2161, 'FACULDADE TEOLGICA DE VALENA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1866, 2162, 'INSTITUTO METROPOLITANO DE ENSINO SUPERIOR DE VESPASIANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1867, 2163, 'INSTITUTO SUPERIOR DE EDUCAO EUGNIO GOMES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1868, 2164, 'FACULDADE PANAMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1869, 2165, 'INSTITUTO FOZ DO IGUAU DE ENSINO E CULTURA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1870, 2166, 'INSTITUTO DE EDUCAO E CULTURA INTEGRADA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1871, 2167, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE SALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1872, 2168, 'INSTITUTO CAMPO GRANDE DE ENSINO SUPERIOR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1873, 2169, 'FACULDADE CENECISTA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1874, 2170, 'FACULDADE DE MATEMTICA JESUS MARIA JOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1875, 2171, 'INSTITUTO BELO HORIZONTE DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1876, 2172, 'FACULDADE CENECISTA DE TRS RIOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1877, 2173, 'FACULDADE GUAIANS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1878, 2174, 'INSTITUTO SANTA CATARINA DE EDUCAO E CULTURA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1879, 2175, 'FACULDADE METROPOLITANA DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1880, 2176, 'FACULDADE DE CINCIAS BIOMDICAS DE COLATINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1881, 2177, 'INSTITUTO PAULISTA DE ENSINO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1882, 2178, 'FACULDADE CENECISTA DE MACA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1883, 2179, 'FACULDADE DE TURISMO DO ESTADO DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1884, 2180, 'RATIO - FACULDADE TEOLGICA E FILOSFICA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1885, 2181, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE CAPIVARI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1886, 2182, 'FACULDADE BATISTA IDA NELSON', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1887, 2183, 'CENTRO UNIVERSITRIO FUNDAO SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1888, 2184, 'FACULDADE CENECISTA NOSSA SENHORA DOS ANJOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1889, 2185, 'FACULDADE DE NUTRIO DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1890, 2186, 'FACULDADE SALESIANA DOM BOSCO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1891, 2187, 'FACULDADE DE CINCIAS GERENCIAIS DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1892, 2188, 'INSTITUTO SUPERIOR DE EDUCAO NOSSA SENHORA DE SION', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1893, 2189, 'FACULDADE DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1894, 2190, 'FACULDADE JLIO CAMPOS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1895, 2191, 'FACULDADE ATLNTICO SUL DE PELOTAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1896, 2192, 'INSTITUTO SUPERIOR DE EDUCAO IVOTI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1897, 2193, 'INSTITUTO SUPERIOR DE EDUCAO IDEAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1898, 2194, 'FACULDADE ATLNTICO SUL DO RIO GRANDE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1899, 2195, 'FACULDADE DE CINCIAS GERENCIAIS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1900, 2196, 'FACULDADE DE INFORMTICA E TECNOLOGIAS VARZEA-GRANDENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1901, 2197, 'INSTITUTO SUPERIOR DE EDUCAO SANTA MARINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1902, 2198, 'FACULDADE MONTEIRO LOBATO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1903, 2199, 'FACULDADE DE EDUCAO E TEOLOGIA DO BRASIL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1904, 2200, 'FACULDADE VALE DO GORUTUBA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1905, 2201, 'FACULDADE ALPHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1906, 2202, 'INSTITUTO SUPERIOR DE EDUCAO DE GUARATUBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1907, 2203, 'FACULDADE DE EDUCAO ANCHIETA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1908, 2204, 'FACULDADE CATARINENSE DOM BOSCO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1909, 2205, 'FACULDADE DE TUPI PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1910, 2206, 'FACULDADE PILARES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1911, 2207, 'FACULDADE SO JUDAS TADEU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1912, 2208, 'FACULDADE LUS DE CAMES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1913, 2209, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1914, 2210, 'FACULDADE GARAVELO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1915, 2211, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE FARROUPILHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1916, 2212, 'FACULDADE UNIDADE DAS AMRICAS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1917, 2213, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1918, 2214, 'FACULDADE DE ENGENHARIA DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1919, 2215, 'FACULDADE DE TEOLOGIA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1920, 2216, 'INSTITUTO SUPERIOR DE EDUCAO DE INA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1921, 2217, 'FACULDADE DE CINCIAS GERENCIAIS DE INA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1922, 2218, 'FACULDADE DE CINCIAS EXATAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1923, 2219, 'FACULDADE MUNDO MODERNO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1924, 2220, 'FACULDADE DE CINCIAS JURDICAS DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1925, 2221, 'FACULDADE MADEIRA MAMOR', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1926, 2222, 'FACULDADE SETE DE SETEMBRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1927, 2223, 'FACULDADE DE CINCIAS SOCIAIS E DA SADE DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1928, 2224, 'FACULDADES INTEGRADAS DE IMPERATRIZ', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1929, 2225, 'INSTITUTO SUPERIOR DE FORMAO DE PROFESSORES', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1930, 2226, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1931, 2227, 'FACULDADE DE CINCIAS BIOLGICAS JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1932, 2228, 'FACULDADE DA SADE HUMANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1933, 2229, 'FACULDADE VICTOR HUGO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1934, 2230, 'FACULDADE DE ADMINISTRAO JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1935, 2231, 'FACULDADE DE COMUNICAO SOCIAL JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1936, 2232, 'FACULDADE DE ADMINISTRAO E MARKETING DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1937, 2233, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1938, 2234, 'FACULDADE DE PEDAGOGIA DE BETIM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1939, 2235, 'FACULDADE TEOLGICA DAS ASSEMBLIAS DE DEUS EM SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1940, 2236, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SO BERNARDO DO CAMPO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1941, 2237, 'FACULDADE TEOLGICA BATISTA EQUATORIAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1942, 2238, 'FACULDADE DE PSICOLOGIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1943, 2239, 'FACULDADE DE DIREITO DE VILHA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1944, 2240, 'INSTITUTO CEAR DE ENSINO E CULTURA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1945, 2241, 'INSTITUTO SUDESTE MINEIRO DE EDUCAO E CULTURA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1946, 2242, 'INSTITUTO PERNAMBUCO DE ENSINO E CULTURA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1947, 2243, 'INSTITUTO PARABA DE EDUCAO E CULTURA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1948, 2244, 'INSTITUTO MACEI DE ENSINO E CULTURA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1949, 2245, 'INSTITUTO VITRIA DE ENSINO E CULTURA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1950, 2246, 'FACULDADE UNIO AMERICANA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1951, 2247, 'FACULDADE CHAFIC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1952, 2248, 'INSTITUTO SERGIPE DE ENSINO SUPERIOR', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1953, 2249, 'FACULDADE LOGOS EM ARACAJU', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1954, 2250, 'INSTITUTO SANTO TOMS DE AQUINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1955, 2251, 'FACULDADE DE POMPIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1956, 2252, 'FACULDADE DE CINCIA DA EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1957, 2253, 'FACULDADE DE DIREITO DE PRIMAVERA DO LESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1958, 2254, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1959, 2255, 'INSTITUTO DE ENSINO SUPERIOR DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1960, 2256, 'FACULDADE CATLICA STELLA MARIS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1961, 2257, 'FACULDADE DIADEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1962, 2258, 'FACULDADE DE PRIMEIRO MUNDO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1963, 2259, 'INSTITUTO SUPERIOR EDUCAO LEONARDO DA VINCI', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1964, 2260, 'FACULDADE DE TECNOLOGIA IESVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1965, 2261, 'FACULDADE DE CINCIAS HUMANAS E DA SADE DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1966, 2262, 'INSTITUTO DE EDUCAO NORMAL SUPERIOR DE PIMENTA BUENO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1967, 2263, 'FACULDADE SANTO ANTNIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1968, 2264, 'FACULDADE DE COMUNICAO SOCIAL DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1969, 2265, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DE IBIRAMA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1970, 2266, 'FACULDADE CAMBURY DE FORMOSA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1971, 2267, 'FACULDADE DE SADE DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1972, 2268, 'FACULDADE DE TEOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1973, 2269, 'INSTITUTO SUPERIOR DE EDUCAO LMINI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1974, 2270, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE EXTREMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1975, 2271, 'FACULDADE PITGORAS DE IPATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1976, 2272, 'FACULDADE DE PSICOLOGIA DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1977, 2273, 'INSTITUTO SUPERIOR DE EDUCAO DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1978, 2274, 'FACULDADE CIDADANIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1979, 2275, 'FACULDADE DE DIREITO SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1980, 2276, 'FACULDADE DE DIREITO DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1981, 2277, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE UNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1982, 2278, 'FACULDADE IGARATA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1983, 2279, 'FACULDADE INTEGRADA METROPOLITANA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1984, 2280, 'FACULDADE SUPERIOR DE RIBAS DO RIO PARDO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1985, 2281, 'FACULDADE DE FILOSOFIA SO BOAVENTURA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1986, 2282, 'FACULDADE DE CAFELNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1987, 2283, 'FACULDADE SO JOS DA COSTA VERDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1988, 2284, 'FACULDADE DE FILOSOFIA, CNCIAS E LETRAS DE FAXINAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1989, 2285, 'FACULDADE DE PEDAGOGIA DE DORES DO INDAI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1990, 2286, 'FACULDADE DE BOM JESUS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1991, 2287, 'ESCOLA SUPERIOR DE TEOLOGIA E ESPIRITUALIDADE FRANCISCANA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1992, 2288, 'FACULDADE ALMEIDA RODRIGUES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1993, 2289, 'FACULDADES INTEGRADAS DE ANGELES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1994, 2290, 'FACULDADE DE EDUCAO, CINCIAS E HUMANIDADES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1995, 2291, 'INSTITUTO SUPERIOR DE EDUCAO DE BEBEDOURO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1996, 2292, 'INSTITUTO DE EDUCAO NORMAL SUPERIOR', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1997, 2293, 'FACULDADE DE CINCIAS HUMANAS, BIOLGICAS E DA SADE', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1998, 2294, 'FACULDADE DE CINCIAS APLICADAS DA REGIO CENTRO SUL DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (1999, 2295, 'INSTITUTO MEDICENSE DE EDUCAO SUPERIOR', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2000, 2296, 'FACULDADE DE LETRAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2001, 2297, 'FACULDADE DE DIREITO DE SANTA MARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2002, 2298, 'ESCOLA SUPERIOR DE DIREITO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2003, 2299, 'FACULDADE ESPECIAL DE EDUCAO E CULTURA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2004, 2300, 'INSTITUTO DE EDUCAO SUPERIOR DE ROLIM DE MOURA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2005, 2301, 'FACULDADE FIDELIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2006, 2302, 'FACULDADE PORTO SEGURO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2007, 2303, 'FACULDADE CIMO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2008, 2304, 'INSTITUTO DE ENSINO SUPERIOR DA FUNLEC DE BONITO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2009, 2305, 'FACULDADE DE DIREITO DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2010, 2306, 'FACULDADE RIO BRANCO DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2011, 2307, 'INSTITUTO SUPERIOR DE EDUCAO DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2012, 2308, 'FACULDADE GEREMRIO DANTAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2013, 2309, 'FACULDADE NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2014, 2310, 'FACULDADE DA REGIO DOS VALES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2015, 2311, 'FACULDADE DE CINCIAS JURDICAS PROFESSOR ALBERTO DEODATO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2016, 2312, 'FACULDADE LUTERANA RUI BARBOSA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2017, 2313, 'FACULDADE DE TEOLOGIA DE BOA VISTA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2018, 2314, 'INSTITUTO DE ENSINO SUPERIOR TECNOLGICO DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2019, 2315, 'FACULDADE CEARENSE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2020, 2316, 'INSTITUTO NACIONAL DE DESENVOLVIMENTO DO ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2021, 2317, 'FACULDADE DO DESCOBRIMENTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2022, 2318, 'FACULDADE DOM BOSCO DE NOVA AURORA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2023, 2319, 'ESCOLA SUPERIOR DE EDUCAO CORPORATIVA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2024, 2320, 'INSTITUTO SUPERIOR DE EDUCAO ATENEU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2025, 2321, 'FACULDADE INESP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2026, 2322, 'FACULDADE ATENEU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2027, 2323, 'FACULDADE DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2028, 2324, 'FACULDADE ANITA GARIBALDI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2029, 2325, 'INSTITUTO SUPERIOR DE EDUCAO DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2030, 2326, 'FACULDADE NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2031, 2327, 'FACULDADE SERRANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2032, 2328, 'FACULDADE ITEANA DE BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2033, 2329, 'FACULDADE BATISTA DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2034, 2330, 'FACULDADE PARA O DESENVOLVIMENTO DO ESTADO E DO PANTANAL MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2035, 2331, 'ESCOLA SUPERIOR DE TEOLOGIA E FILOSOFIA DO BRASIL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2036, 2332, 'FACULDADE CORPORATIVA CESPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2037, 2333, 'FACULDADE DE TEOLOGIA MOKITI OKADA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2038, 2334, 'INSTITUTO SUPERIOR MENDES DE ALMEIDA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2039, 2335, 'FACULDADE JOAQUIM MACHADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2040, 2336, 'FACULDADE MONTES BELOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2041, 2337, 'INSTITUTO SUPERIOR DE EDUCAO DE MONTES BELOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2042, 2338, 'INSTITUTO BRASILEIRO DE ESTUDOS TRIBUTRIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2043, 2339, 'FACULDADE INTERNACIONAL DE HOTELARIA E TURISMO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2044, 2340, 'FACULDE ALPHAVILLE DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2045, 2341, 'FACULDADE DA ALDEIA DE CARAPICUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2046, 2342, 'INSTITUTO SUPERIOR DE EDUCAO CERES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2047, 2343, 'FACULDADE DA AMAZNIA OCIDENTAL - FAAO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2048, 2344, 'FACULDADE ITEANA DE IBITINGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2049, 2345, 'FACULDADE SETE DE SETEMBRO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2050, 2346, 'INSTITUTO SUPERIOR DE FILOSOFIA BERTHIER', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2051, 2347, 'FACULDADE GENNARI & PEARTREE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2052, 2348, 'INSTITUIO DE ENSINO SO FRANCISCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2053, 2349, 'DINMICO FACULDADE DE FLORIANO LTDA.', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2054, 2350, 'ESCOLA SUPERIOR MADRE CELESTE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2055, 2351, 'FACULDADE ESPRITO SANTENSE DE CINCIAS JURDICAS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2056, 2352, 'INSTITUTO DE EDUCAO SUPERIOR PIO XII', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2057, 2353, 'FACULDADE DE ADMINISTRAO DO CENTRO EDUCACIONAL DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2058, 2354, 'INSTITUTO SUPERIOR DE EDUCAO DO BRASIL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2059, 2355, 'FACULDADE ANHANGUERA DE MATO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2060, 2356, 'FACULDADE PAN AMERICANA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2061, 2357, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE DO CESCARELLI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2062, 2358, 'INSTITUTO SUPERIOR DE EDUCAO DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2063, 2359, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2064, 2360, 'INSTITUTO SUPERIOR DE EDUCAO MESTRE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2065, 2361, 'FACULDADE MESTRA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2066, 2362, 'FACULDADE DE CINCIAS MDICAS DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2067, 2363, 'FACULDADE NOVO MILNIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2068, 2364, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE PARASO DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2069, 2365, 'FACULDADE CATLICA DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2070, 2366, 'FACULDADE DE SISTEMAS DE INFORMAO DE PARASO DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2071, 2367, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2072, 2368, 'FACULDADE DE ODONTOLOGIA SO LEOPOLDO MANDIC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2073, 2369, 'INSTITUTO DE ENSINO SUPERIOR SANTO ANTNIO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2074, 2370, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2075, 2371, 'INSTITUTO DE EDUCAO SUPERIOR SO FRANCISCO DE ASSIS DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2076, 2372, 'INSTITUTO DE CINCIAS GERENCIAIS DE BRASLIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2077, 2373, 'FACULDADE TELES PIRES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2078, 2374, 'FACULDADES INTEGRADAS CONTEMPORNEAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2079, 2375, 'FACULDADE VIZCAYA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2080, 2376, 'INSTITUTO SUPERIOR DE EDUCAO DE BRASLIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2081, 2377, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA PRESIDENTE KENNEDY', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2082, 2378, 'FACULDADE DE ADMINISTRAO DE CAMPINA VERDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2083, 2379, 'INSTITUTO SUPERIOR DE EDUCAO DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2084, 2380, 'FACULDADE DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2085, 2381, 'INSTITUTO DE ENSINO E CULTURA DE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2086, 2382, 'INSTITUTO SUPERIOR DE EDUCAO DE TEOFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2087, 2383, 'FACULDADE MERIDIONAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2088, 2384, 'FACULDADE INTEGRADA DO BRASIL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2089, 2385, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2090, 2386, 'FACULDADE SUL RIOGRANDENSE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2091, 2387, 'FACULDADES INTEGRADAS POSIVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2092, 2388, 'FACULDADE NOVO MILNIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2093, 2389, 'FACULDADE DE FILOSOFIA E TEOLOGIA PAULO VI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2094, 2390, 'INSTITUTO BRUSQUENSE DE ENSINO SUPERIOR', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2095, 2391, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2096, 2392, 'INSTITUTO SUPERIOR DE EDUCAO DE SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2097, 2393, 'FACULDADE MARISTA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2098, 2394, 'FACULDADE DE INFORMTICA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2099, 2395, 'FACULDADE DE CAMPO VERDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2100, 2396, 'INSTITUTO DE EDUCAO SUPEIOR DO SERTO EM PO DE ACAR', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2101, 2397, 'FACULDADE FUCAPE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2102, 2398, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPO VERDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2103, 2399, 'FACULDADE DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2104, 2400, 'FACULDADE DOM BOSCO DE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2105, 2401, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPO BELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2106, 2402, 'FACULDADE CIDADE DO SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2107, 2403, 'FACULDADE SALESIANA DE PINDAMONHANGABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2108, 2404, 'FACULDADES INTEGRADAS DE FILOSOFIA E CINCIAS DO PLANALTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2109, 2405, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTA LUZIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2110, 2406, 'FACULDADE DE GESTO E EMPREENDEDORISMO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2111, 2407, 'FACULDADES INTEGRADAS FACVEST', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2112, 2408, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2113, 2409, 'FACULDADE DO AGRESTE DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2114, 2410, 'FACULDADE CEARENSE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2115, 2411, 'FACULDADE DA CIDADE DO NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2116, 2412, 'FACULDADE ECONOROESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2117, 2413, 'FACULDADE DE ENSINO SUPERIOR DE FLORIANO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2118, 2414, 'INSTITUTO SUPERIOR DE EDUCAO IESDE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2119, 2415, 'FACULDADE BOM JESUS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2120, 2416, 'INSTITUTO SUPERIOR DE EDUCAO DE BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2121, 2417, 'INSTITUTO SUPERIOR DE EDUCAO METROPOLITANO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2122, 2418, 'FACULDADES INTEGRADAS DO RECNCAVO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2123, 2419, 'FACITALGO - FACULDADE DE CIENCIAS E TECNOLOGIA DE AGUAS LINDAS DE GOIAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2124, 2420, 'INSTITUTO DE ENSINO E CULTURA DO PARAN - IECP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2125, 2421, 'INSTITUTO DE ENSINO SUPERIOR', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2126, 2422, 'FACULDADE DE FILOSOFIA LETRAS E ARTES DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2127, 2423, 'FACULDADE DE CINCIA E TECNOLOGIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2128, 2424, 'FACULDADE DE SISTEMA DE INFORMAO DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2129, 2425, 'FACULDADE DE JIPARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2130, 2426, 'FACULDADE INTEGRADA BRASIL AMAZONIA - FIBRA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2131, 2427, 'FACULDADE DE CINCIAS GERENCIAIS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2132, 2428, 'FACULDADE DE CINCIAS DA SADE DE CAMPOS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2133, 2429, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2134, 2430, 'FACULDADE CATLICA ORTODOXA SEDES SAPIENTIAM', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2135, 2431, 'FACULDADE MONTESSORI DE IBINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2136, 2432, 'FACULDADE ALPHAVILLE DE JUNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2137, 2433, 'INSTITUTO SUPERIOR DE EDUCAO PORTO SEGURO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2138, 2434, 'FACULDADE AMRICA LATINA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2139, 2435, 'FACULDADE DE CINCIAS CONTBEIS LUIZ MENDES', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2140, 2436, 'FACULDADE THIRIH', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2141, 2437, 'FACULDADE DE TEIXEIRA DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2142, 2438, 'INSTITUTO TEOLGICO PASTORAL DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2143, 2439, 'FACULDADE OCIDEMNTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2144, 2440, 'FACULDADE CIDADE DE JOO PINHEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2145, 2441, 'INSTITUTO SUPERIOR DE EDUCAO AUXILIUM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2146, 2442, 'FACULDADE DE CINCIAS BIOMDICAS DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2147, 2443, 'INSTITUTO SUPERIOR DE EDUCAO DE JANABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2148, 2444, 'FACULDADE JOO CALVINO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2149, 2445, 'FACULDADE PADRO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2150, 2446, 'INSTITUTO SUPERIOR DE EDUCAO PADRO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2151, 2447, 'INSTITUTO EDUCACIONAL DE CASTRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2152, 2448, 'INSTITUTO SUPERIOR DE EDUCAO DE JANURIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2153, 2449, 'INSTITUTO MATO GROSSO DE EDUCAO E CULTURA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2154, 2450, 'FACULDADE DE DIREITO PROMOVE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2155, 2451, 'FACULDADE IPIRANGA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2156, 2452, 'INSTITUTO BRASILEIRO DE ENSINO SUPERIOR PROFISSIONALIZANTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2157, 2453, 'FACULDADE BRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2158, 2454, 'FACULDADE MAFRENSE DE TURISMO E CINCIAS HUMANAS DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2159, 2455, 'FACULDADE CASTRO ALVES', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2160, 2456, 'FACULDADE DE ADMINISTRAO DE CHAPADO DO SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2161, 2457, 'FACULDADE ISAAC NEWTON', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2162, 2458, 'CENTRO UNIFICADO DE ENSINO SUPERIOR DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2163, 2459, 'FACULDADE DE ESTUDOS AVANADOS DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2164, 2460, 'FACULDADE CMARA CASCUDO', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2165, 2461, 'FACULDADE CBES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2166, 2462, 'FACULDADE SO LUS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2167, 2463, 'FACULDADE JOANA D''ARC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2168, 2464, 'INSTITUTO SUPERIOR DE EDUCAO ATENEU', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2169, 2465, 'FACULDADE DE DIREITO PROFESSOR DAMSIO DE JESUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2170, 2466, 'FACULDADE ATENEU', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2171, 2467, 'FACULDADE NACIONAL DO NORTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2172, 2468, 'INSTITUTO TEOLGICO FRANCISCANO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2173, 2469, 'INSTITUTO MACAPAENSE DE ENSINO SUPERIOR', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2174, 2470, 'INSTITUTO SALVADOR DE ENSINO E CULTURA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2175, 2471, 'INTITUTO SUPERIOR DE EDUCAO DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2176, 2472, 'FACULDADE DE EDUCAO, CINCIA E TECNOLOGIA 2001', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2177, 2473, 'INSTITUTO BRASILEIRO DE ADMINISTRAO - BIM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2178, 2474, 'FACULDADE MARIA MILZA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2179, 2475, 'FACULDADE ARQUIDIOCESANA DE MARIANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2180, 2476, 'FACULDADE FNIX DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2181, 2477, 'FACULDADE DE ADMINISTRAO DE MARIANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2182, 2478, 'FACULDADE DE INTEGRAO DO ENSINO SUPERIOR DO CONE SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2183, 2479, 'FACULDADE LATINO AMERICANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2184, 2480, 'INSTITUTO SUPERIOR DE EDUCAO DE ITPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2185, 2481, 'ESCOLA BRASILEIRA DE FORMAO EMPRESARIAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2186, 2482, 'FACULDADE DE CINCIAS HUMANAS E APLICADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2187, 2483, 'INSTITUTO SUPERIOR DE EDUCAO INTEGRAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2188, 2484, 'FACULDADE PROCESSUS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2189, 2485, 'INSTITUTO DE CINCIAS RELIGIOSAS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2190, 2486, 'FACULDADE LEONARDO DA VINCI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2191, 2487, 'FACULDADE EXMIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2192, 2488, 'FACULDADE ANGLICANA DE ERECHIM', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2193, 2489, 'INSTITUTO SUPERIOR DE EDUCAOBRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2194, 2490, 'INSTITUTO SUPERIOR DE ENSINO DO LITORAL CATARINENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2195, 2491, 'INSTITUTO SUPERIOR DE EDUCAO DO CECAP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2196, 2492, 'INSTITUTO SUPERIOR DE EDUCAO A DISTNCIA DE BRASLIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2197, 2493, 'INSTITUTO SUPERIOR DE EDUCAO  DISTNCIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2198, 2494, 'FACULDADE DE PINDAMONHANGABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2199, 2495, 'INSTITUTO DE PESQUISA GRANDE VITRIA - IPGV FACULDADE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2200, 2496, 'INSTITUTO MACHADO DE ASSIS DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2201, 2497, 'FACULDADE ATENEU', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2202, 2498, 'FACULDADE DE MLTIPLAS CINCIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2203, 2499, 'FACULDADE APOIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2204, 2500, 'FACULDADE EINSTEIN', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2205, 2501, 'FACULDADE ESTCIO DE S DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2206, 2502, 'FACULDADE ARINOS DE ADMINISTRAO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2207, 2503, 'FACULDADE DE INTEGRAO NACIONAL LEDA JESUNO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2208, 2504, 'FACULDADE DIVINPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2209, 2505, 'FACULDADE DE ARTE E DESIGN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2210, 2506, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2211, 2507, 'FACULDADE DE TECNOLOGIA E CINCIAS DE SANTO ANTNIO DE JESUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2212, 2508, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2213, 2509, 'FACULDADE DE MEDICINA TRADICIONAL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2214, 2510, 'FACULDADES MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2215, 2511, 'FACULDADE DE DIREITO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2216, 2512, 'INSTITUTO SUPERIOR DE EDUCAO CUIABANO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2217, 2513, 'FACULDADE ARTHUR THOMAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2218, 2514, 'INSTITUTO NATALENSE DE EDUCAO SUPERIOR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2219, 2515, 'FACULDADE ERUDITA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2220, 2516, 'INSTITUTO SUPERIOR DE EDUCAO SANTA RITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2221, 2517, 'FACULDADE DE ESTUDOS SOCIAIS E GESTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2222, 2518, 'FACULDADE INTENSIVA DE PEDAGOGIA E FILOSOFIA DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2223, 2519, 'FACULDADE DE INFORMTICA E TECNOLOGIA TERRANOVENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2224, 2520, 'INSTITUTO DE EDUCAO SUPERIOR TERRANOVENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2225, 2521, 'INSTITUTO SUPERIOR DE EDUCAO DO SUL DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2226, 2522, 'INSTITUTO MARISTA SUPERIOR DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2227, 2523, 'FACULDADE BONDESPACHENSE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2228, 2524, 'FACULDADE DE ENGENHARIA DA ITAJUB TECNPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2229, 2525, 'FACULDADE PAULISTA DE CINCIAS APLICADAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2230, 2526, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2231, 2527, 'INSTITUTO SUPERIOR DE EDUCAO DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2232, 2528, 'INSTITUTO SUPERIOR DE EDUCAO ME DE DEUS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2233, 2529, 'INSTITUTO SUPERIOR DE EDUCAO DE IGUAPE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2234, 2530, 'FACULDADE DE CINCIAS DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2235, 2531, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSORA LCIA DANTAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2236, 2532, 'FACULDADE DO SUDESTE GOIANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2237, 2533, 'FACULDADE REGIONAL BARUERI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2238, 2534, 'FACULDADE METROPOLITANA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2239, 2535, 'FACULDADE DOS INCONFIDENTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2240, 2536, 'FACULDADE RORAIMENSE DE ENSINO SUPERIOR', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2241, 2537, 'FACULDADE SO GERALDO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2242, 2538, 'FACULDADE VENDA NOVA DO IMIGRANTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2243, 2539, 'FACULDADE EVANGLICA DO MEIO NORTE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2244, 2540, 'INSTITUTO DE ENSINO SUPERIOR DE CAMAPU', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2245, 2541, 'ESCOLA SUPERIOR DE TECNOLOGIA E EDUCAO DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2246, 2542, 'FACULDADE CENECISTA DE QUEIMADOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2247, 2543, 'FACULDADE DA CHAPADA DOS GUIMARES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2248, 2544, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSORA VILMA MONTEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2249, 2545, 'FACULDADE CENECISTA DE PARACAMBI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2250, 2546, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DE VIANNA JNIOR DE MURIAR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2251, 2547, 'FACULDADE MAGNUM DE FORMAO DE PROFESSORES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2252, 2548, 'FACULDADE DE TEOLOGIA, FILOSOFIA E CINCIAS HUMANAS GAMALIEL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2253, 2549, 'FACULDADE PAULISTA DE EDUCAO E COMUNICAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2254, 2550, 'FACULDADE SEPAM', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2255, 2551, 'FACULDADE CENECISTA ITAGUA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2256, 2552, 'INSTITUTO SUPERIOR DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2257, 2553, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA LUIS EDUARDO MAGALHES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2258, 2554, 'FACULDADE DE EDUCAO SANTA TEREZINHA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2259, 2555, 'FACULDADE DE EDUCAO DE UBERABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2260, 2556, 'FIAM-FAAM - CENTRO UNIVERSITRIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2261, 2557, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE PENEDO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2262, 2558, 'FACULDADE DE DIREITO DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2263, 2559, 'INSTITUTO SUPERIOR DE EDUCAO DAS FACULDADES DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2264, 2560, 'FACULDADE DE ENSINO SUPERIOR DA CIDADE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2265, 2561, 'FACULDADE DE CINCIAS ADMINISTRATIVAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2266, 2562, 'FACULDADE JOS LACERDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2267, 2563, 'INSTITUTO SUPERIOR DE EDUCAO PADRE JOO BAGOZZI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2268, 2564, 'UNIVERSIDADE FEDERAL DE CAMPINA GRANDE', 1, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2269, 2565, 'ABEU - CENTRO UNIVERSITRIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2270, 2566, 'INSTITUTO DE ENSINO SUPERIOR DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2271, 2567, 'ESCOLA SUPERIOR DE CINCIAS HUMANAS E ECONMICAS', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2272, 2568, 'FACULDADE ZACARIAS DE GES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2273, 2569, 'FACULDADE DE TECNOLOGIA FAESA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2274, 2570, 'FACULDADE DE CINCIAS EDUCACIONAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2275, 2571, 'FACULDADE REDENTOR', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2276, 2572, 'FACULDADE REGIONAL DE FILOSOFIA, CINCIAS E LETRAS DE CANDEIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2277, 2573, 'FACULDADE TEOLGICA SUL AMERICANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2278, 2574, 'INSTITUTO SUPERIOR DE EDUCAO DAS FACULDADES INTEGRADAS MDULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2279, 2575, 'FACULDADES INTEGRADAS SOARES DE OLIVEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2280, 2576, 'FACULDADES INTEGRADAS PADRE ANCHIETA DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2281, 2577, 'INSTITUTO SUPERIOR DE MSICA DE SO LEOPOLDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2282, 2578, 'FACULDADE DE TEOLOGIA CARDEAL EUGNIO SALES', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2283, 2579, 'FACULDADE ATENAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2284, 2580, 'INSTITUTO SUPERIOR DE EDUCAO PAULO MARTINS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2285, 2581, 'FACULDADE SO SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2286, 2582, 'FACULDADE DE ENSINO SUPERIOR DO CENTRO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2287, 2583, 'FACULDADE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2288, 2584, 'FACULDADE DO SUDOESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2289, 2585, 'FACULDADE DE FISIOTERAPIA DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2290, 2586, 'INSTITUTO SUPERIOR DE EDUCAO TALO-BRASILEIRO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2291, 2587, 'FACULDADE CNDIDO MENDES DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2292, 2588, 'FALCULDADE MERCATOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2293, 2589, 'FACULDADE DE BROTAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2294, 2590, 'FACULDADE DE CINCIA DA COMPUTAO E INFORMTICA SILVA SERPA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2295, 2591, 'ESCOLA BRASILEIRA DE ECONOMIA E FINANAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2296, 2592, 'FACULDADE PRESBITERIANA 15 DE NOVEMBRO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2297, 2593, 'FACULDADE DE JUAZEIRO DO NORTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2298, 2594, 'FACULDADE TEOLGICA BATISTA ANA WOLLERMAN', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2299, 2595, 'FACULDADES COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2300, 2596, 'INSTITUTO SUPERIOR DE EDUCAO DON DOMNICO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2301, 2597, 'FACULDADE DE CINCIAS DA SADE DA VITRIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2302, 2598, 'FACULDADE PENSAR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2303, 2599, 'FACULDADE DE EDUCAO E CINCIAS HUMANAS NOVA FLRIDA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2304, 2600, 'FACULDADE DE CIENCIAS DA ADMINISTRACAO DA VITORIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2305, 2601, 'FACULDADE DE CINCIAS, FILOSOFIA E LETRAS HAKAY', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2306, 2602, 'INSTITUTO SUPERIOR DE EDUCAO BALO VERMELHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2307, 2603, 'FACULDADE DE ODONTOLOGIA DOS GUARARAPES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2308, 2604, 'FACULDADE TEOLGICA BATISTA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2309, 2605, 'FACULDADE DE CINCIAS ECONMICAS DE TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2310, 2606, 'FACULDADE AFIRMATIVO DE CAMPO MOURO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2311, 2607, 'FACULDADE PADRE ANTONIO VIEIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2312, 2608, 'INSTITUTO SUPERIOR DE EDUCAO DE LAVRAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2313, 2609, 'INSTITUTO SUPERIOR DE EDUCAO DE TUPI PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2314, 2610, 'FACULDADE DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2315, 2611, 'FACULDADE DE ENSINO SUPERIOR DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2316, 2612, 'INSTITUTO SUPERIOR DE EDUCAO MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2317, 2613, 'FACULDADE RIO BRANCO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2318, 2614, 'FACULDADE EMMANUEL KANT', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2319, 2615, 'FACULDADE INCONFIDNCIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2320, 2616, 'FACULDADE SANTO ANTNIO DE PDUA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2321, 2617, 'FACULDADE SO BENTO DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2322, 2618, 'FACULDADE DOMINGOS SVIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2323, 2619, 'FACULDADE DE DIREITO DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2324, 2620, 'FACULDADE AMPRE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2325, 2621, 'INSTITUTO SUPERIOR DE EDUCAO DOMINGOS SVIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2326, 2622, 'INSTITUTO SUPERIOR DE EDUCAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2327, 2623, 'FACULDADE DO TAPAJS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2328, 2624, 'FACULDADE DO LITORAL PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2329, 2625, 'FACULDADE DE TECNOLOGIA IBTA - SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2330, 2626, 'FACULDADE DE COMUNICAO SOCIAL SANTA EFIGNIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2331, 2627, 'FACULDADE JOO XXIII', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2332, 2628, 'INSTITUTO DE EDUCAO SUPERIOR ACADEMUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2333, 2629, 'FACULDADE DE CINCIAS CONTBEIS E DE ADMINISTRAO DO VALE DO JURUENA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2334, 2630, 'INSTITUTO SUPERIOR DE EDUCAO DO VALE DO JURUENA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2335, 2631, 'INSTITUTO DE EDUCAO SUPERIOR', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2336, 2632, 'FACULDADES INTEGRADAS DO EXTREMO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2337, 2633, 'INSTITUTO DE EDUCAO E TECNOLOGIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2338, 2634, 'INSTITUTO EDUCACIONAL DALTON CUNHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2339, 2635, 'INSTITUTO SUPERIOR DE EDUCAO JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2340, 2636, 'FACULDADE DINMICA DO VALE DO PIRANGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2341, 2637, 'FACULDADE BOM JESUS DE SIQUEIRA CAMPOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2342, 2638, 'INSTITUTO DE CINCIAS E EDUCAO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2343, 2639, 'FACULDADE DE TECNOLOGIA SENAI CONCRDIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2344, 2640, 'FACULDADE DE CINCIAS DA SADE DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2345, 2641, 'FACULDADE TEOLGICA BATISTA FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2346, 2642, 'FACULDADE SO VICENTE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2347, 2643, 'INSTITUTO SUPERIOR DE CINCIAS E TECNOLOGIA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2348, 2644, 'INSTITUTO DE EDUCAO SUPERIOR DO TAPAJS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2349, 2645, 'INSTITUTO DE ENSINO SUPERIOR DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2350, 2646, 'FACULDADE REGIONAL IPIRANGA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2351, 2647, 'FACULDADE SANTA CLARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2352, 2648, 'FACULDADE SUL MINEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2353, 2649, 'FACULDADE DE CINCIAS JURDICAS DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2354, 2650, 'INSTITUTO DE ENSINO SUPERIOR DE ARIQUEMES', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2355, 2651, 'FACULDADE TAMANDAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2356, 2652, 'FACULDADE UNIDA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2357, 2653, 'FACULDADE DE EDUCAO SUPERIOR DO PIEMONTE DA CHAPADA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2358, 2654, 'FACULDADE DE ENSINO TECNOLGICO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2359, 2655, 'FACULDADE DE CINCIAS ADMINISTRATIVAS, SOCIAIS E DA SADE DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2360, 2656, 'FACULDADE SANTA CATARINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2361, 2657, 'FACULDADE ADOLFO CAMINHA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2362, 2658, 'FACULDADE AMEC TRABUCO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2363, 2659, 'FACULDADE DO VALE DO PARNABA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2364, 2660, 'FACULDADE PHNIX DE CINCIAS HUMANAS E SOCIAIS DO BRASIL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2365, 2661, 'INSTITUTO DE ENSINO SUPERIOR DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2366, 2662, 'INSTITUTO SUPERIOR DE ENSINO PAULA CNDIDO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2367, 2663, 'FACULDADE DE ODONTOLOGIA ARGEMIRO FIGUEIREDO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2368, 2664, 'INSTITUTO DE ENSINO SUPERIOR DO VALE DO PARNABA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2369, 2665, 'FACULDADE DE TECNOLOGIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2370, 2666, 'FACULDADE INTEGRADA DE BRUSQUE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2371, 2667, 'INSTITUTO SUPERIOR PAULO FREIRE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2372, 2668, 'FACULDADE TEOLGICA DO SUDOESTE GOIANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2373, 2669, 'FACULDADE CNDIDO MENDES DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2374, 2670, 'INSTITUTO DE EDUCAO SUPERIOR ACREANO EUCLIDES DA CUNHA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2375, 2671, 'FACULDADE DE CINCIAS HUMANAS E PSICOLGICAS EUCLIDES DA CUNHA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2376, 2672, 'FACULDADE HUGO DE SO VITOR', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2377, 2673, 'INSTITUTO SUPERIOR DE EDUCAO VILA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2378, 2674, 'INSTITUTO DE ENSINO SUPERIOR UNILLUZ', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2379, 2675, 'INSTITUTO SUPERIOR DE EDUCAO LATINO AMERICANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2380, 2676, 'FACULDADE LA SALLE', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2381, 2677, 'INSTITUTO SUPERIOR DE EDUCAO SO JUDAS TADEU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2382, 2678, 'FACULDADE DE COMPUTAO E INFORMTICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2383, 2679, 'FACULDADE DE CINCIA DA COMPUTAO DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2384, 2680, 'FACULDADE DE COMPUTAO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2385, 2681, 'FACULDADE DE ENGENHARIA CIVIL DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2386, 2682, 'FACULDADE DE CINCIAS DA SADE DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2387, 2683, 'FACULDADE DE CINCIAS DA COMPUTAO DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2388, 2684, 'FACULDADE DE CINCIAS GERENCIAIS DE LEOPOLDINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2389, 2685, 'FACULDADE DELTA DE ENSINO SUPERIOR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2390, 2686, 'FACULDADE SANTA IZILDINHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2391, 2687, 'FACULDADE DOM ALBERTO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2392, 2688, 'FACULDADE INESP - INSTITUTO NACIONAL DE ENSINO E PESQUISA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2393, 2689, 'FACULDADE CARLOS LOBO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2394, 2690, 'FACULDADES INTEGRADAS LOGOS - FILOGOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2395, 2691, 'FACULDADE ASSOCIADA DA BAHIA - FAB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2396, 2692, 'FACULDADE VILA DE CINCIAS HUMANAS E EXATAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2397, 2693, 'FACULDADES INTEGRADAS DO TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2398, 2694, 'FACULDADE VALE DO ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2399, 2695, 'FACULDADE DO CENTRO-OESTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2400, 2696, 'INSUBA - INSTITUTO SUPERIOR DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2401, 2697, 'INSTITUTO SUPERIOR DE EDUCAO DE AMLIA RODRIGUES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2402, 2698, 'INSTITUTO SUPERIOR DE EDUCAO VALE DO ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2403, 2699, 'INSTITUTO DE ENSINO SUPERIOR AVANT GARDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2404, 2700, 'FACULDADE UNIPOLI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2405, 2701, 'FACULDADE DE ORLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2406, 2702, 'FACULDADE DE CINCIAS JURDICAS DE PARASO DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2407, 2703, 'FACULDADE SENAC MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2408, 2704, 'INSTITUTO SUPERIOR DE EDUCAO DO INSTITUTO METODISTA UNIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2409, 2705, 'FACULDADE DE EDUCAO E CINCIAS HUMANAS NOVA FLRIDA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2410, 2706, 'FACULDADE EUROPEU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2411, 2707, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSOR EDGARDO BEZERRA DA ROCHA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2412, 2708, 'INSTITUTO SUPERIOR DE CINCIAS HUMANAS E FILOSOFIA LA SALLE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2413, 2709, 'INSTITUTO DE ENSINO SUPERIOR NOVO HORIZONTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2414, 2710, 'INSTITUTO SUPERIOR DE EDUCAO RANCHARIENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2415, 2711, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2416, 2712, 'FACULDADE DE SISTEMAS DE INFORMAO DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2417, 2713, 'INSTITUTO NORMAL SUPERIOR DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2418, 2714, 'FACULDADE DE ENFERMAGEM E OBSTETRCIA DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2419, 2715, 'FACULDADE DE CINCIAS HUMANAS DE PONTE NOVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2420, 2716, 'FACULDADE COTEMGE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2421, 2717, 'FACULDADE DE CINCIAS JURDICAS VISCONDE DE CAIRU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2422, 2718, 'INSTITUTO SUPERIOR DE EDUCAO DO NORTE', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2423, 2719, 'FACULDADE DE DIREITO OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2424, 2720, 'FACULDADE AUGUSTO MAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2425, 2721, 'FACULDADE IMPACTA DE TECNOLOGIA DA INFORMAO - FITI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2426, 2722, 'FACULDADE CATLICA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2427, 2723, 'FACULDADE MARISTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2428, 2724, 'INSTITUTO DE ENSINO SUPERIOR DO SUL DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2429, 2725, 'INSTITUTO SUPERIOR DE EDUCAO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2430, 2726, 'ESCOLA SUPERIOR DE ADMINISTRAO DE EMPRESAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2431, 2727, 'FACULDADE DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2432, 2728, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS MAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2433, 2729, 'FACULDADE DE PSICOLOGIA MAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2434, 2730, 'UNIPB - FACULDADE UNIDA DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2435, 2731, 'ESCOLA SUPERIOR DE COMPUTAO E TECNOLOGIAS DA INFORMAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2436, 2732, 'FACULDADE UNIDAS DO ENTORNO GOIS/DF - UNIENTORNO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2437, 2733, 'FACULDADE TEOLOGICA ALPHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2438, 2734, 'FACULDADE DE CINCIAS DA SADE DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2439, 2735, 'FACULDADE DE CINCIAS DA COMPUTAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2440, 2736, 'INSTITUTO TECNOLGICO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2441, 2737, 'FACULDADE DE CINCIAS DA INFORMAO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2442, 2738, 'INSTITUTO SUPERIOR DE EDUCAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2443, 2739, 'FACULDADE CASTILHENSE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2444, 2740, 'FACULDADE DO VALE DO JAGUARIBE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2445, 2741, 'FACULDADE CATLICA DOM ORIONE', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2446, 2742, 'FACULDADE DE EDUCAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2447, 2743, 'FACULDADE DE CINCIA DA COMPUTAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2448, 2744, 'INSTITUTO SUPERIOR DE EDUCAO VERA CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2449, 2745, 'ESCOLA SUPERIOR DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2450, 2746, 'INSTITUTO DE ENSINO SUPERIOR ETAPA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2451, 2747, 'FACULDADE EUROPEU DO CEARA - FEC', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2452, 2748, 'FACULDADE LATO SENSU DO BRASIL', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2453, 2749, 'INSTITUTO DE CINCIAS JURDICAS PITGORAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2454, 2750, 'FACULDADE DE TECNOLOGIA SENAI LUZERNA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2455, 2751, 'INSTITUTO SUPERIOR DE EDUCAO DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2456, 2752, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS PROFESSORA VILMA MONTEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2457, 2753, 'FACULDADE DE CINCIAS AGRRIAS, BIOLGICAS, EXATAS E SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2458, 2754, 'FACULDADE SO PAULO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2459, 2755, 'FACULDADE DO VALE DO ITAJA MIRIM', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2460, 2756, 'FACULDADE JK VALPARASO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2461, 2757, 'FACULDADE JK ADMINISTRAO DE VALPARASO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2462, 2758, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSOR PAULO ALBINO PIMENTEL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2463, 2759, 'FACULDADE PROFESSOR PAULO ALBINO PIMENTEL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2464, 2760, 'ESCOLA SUPERIOR DE TECNOLOGIA DA INFORMAO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2465, 2761, 'FACULDADE DO SERTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2466, 2762, 'INSTITUTO ISAAC NEWTON', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2467, 2763, 'FACULDADE DE CINCIAS GERENCIAS DE SO GOTARDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2468, 2764, 'INSTITUTO DE ENSINO SUPERIOR DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2469, 2765, 'INSTITUTO DE CINCIAS RELIGIOSAS LUMEN CHRISTI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2470, 2766, 'FACULDADE EMPRESARIAL DE CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2471, 2767, 'INSTITUTO SUPERIOR DE EDUCAO DA AIMORS - M.G.', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2472, 2768, 'INSTITUTO SUPERIOR DE EDUCAO - FACREFI', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2473, 2769, 'FAVE - FACULDADE DE ADMINISTRAO DE VESPASIANO LTDA.', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2474, 2770, 'FACULDADE UNIDA DE CAMPINAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2475, 2771, 'CENTRO DE ENSINO SUPERIOR DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2476, 2772, 'INSTITUTO SUPERIOR DE EDUCAO MANHUMIRIM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2477, 2773, 'FACULDADE DE MACAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2478, 2774, 'FACULDADES INTEGRADAS FAFIBE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2479, 2775, 'FACULDADES INTEGRADAS DESEMBARGADOR SVIO BRANDO - FAUSB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2480, 2776, 'FACULDADES INTEGRADAS NORTE CAPIXABA - FANORTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2481, 2777, 'INSTITUTO DE ENSINO SUPERIOR SANTA MARIA DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2482, 2778, 'INSTITUTO SUPERIOR ESPECIAL DE EDUCAO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2483, 2779, 'FACULDADE DE INFORMTICA DE OURO PRETO DO OESTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2484, 2780, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2485, 2781, 'FACULDADE DE CINCIAS DA SADE DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2486, 2782, 'INSTITUTO SUPERIOR DE EDUCAO AFONSO LINARES PRADO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2487, 2783, 'FACULDADE DE TECNOLOGIA DO NORDESTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2488, 2784, 'FACULDADE FRANCISCANA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2489, 2785, 'ESCOLA SUPERIOR DE EDUCAO CONTINUADA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2490, 2786, 'INSTITUTO DE EDUCAO SUPERIOR E TECNOLOGICA PROF. FRANBRAN', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2491, 2787, 'FACULDADES PEQUENO PRNCIPE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2492, 2788, 'FACULDADE DE CINCIAS AMBIENTAIS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2493, 2789, 'FACULDADE JOINVILLE DE ENSINO E CULTURA - FAJEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2494, 2790, 'FACULDADE FRANCISCANA DE ENSINO SUPERIOR - FAFRES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2495, 2791, 'FACULDADE DE CINCIAS AGRRIAS E EXATAS DE PRIMAVERA DO LESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2496, 2792, 'FACULDADE DE CINCIAS SOCIAIS E EDUCAO - FACE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2497, 2793, 'FACULDADE UNIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2498, 2794, 'FACULDADE DE CINCIAS SOCIAIS E HUMANAS SOBRAL PINTO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2499, 2795, 'FACULDADE SO FRANCISCO DE ASSIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2500, 2796, 'FACULDADE DE IPOR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2501, 2797, 'FACULDADE DO LITORAL SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2502, 2798, 'FAESP - FACULDADE DE ENSINO SUPERIOR DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2503, 2799, 'FANEESP - FACULDADE NACIONAL DE EDUCAO E ENSINO SUPERIOR DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2504, 2800, 'FACULDADE DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2505, 2801, 'INSTITUTO GUARANT DE EDUCAO SUPERIOR', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2506, 2802, 'FACULDADE DE CINCIAS AGRRIAS DE GUARANT DO NORTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2507, 2803, 'FACULDADE CETESI', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2508, 2804, 'FACULDADE CCAA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2509, 2805, 'FACULDADE MODELO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2510, 2806, 'FACULDADE EVANGLICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2511, 2807, 'FACULDADE CENTRO CAPE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2512, 2808, 'FACULDADES ITECNE DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2513, 2809, 'INSTITUTO DE ENSINO SUPERIOR DE UBERLNDIA - IESU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2514, 2810, 'INSTITUTO SUPERIOR DE EDUCAO ANSIO TEIXEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2515, 2811, 'FACULDADE PAULUS DE TECNOLOGIA E COMUNICAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2516, 2812, 'FACULDADE DO SUDESTE BRASILEIRO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2517, 2813, 'INSTITUTO SUPERIOR DE EDUCAO CAPIMGROSSENSE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2518, 2814, 'FACULDADE SO SEBASTIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2519, 2815, 'FACULDADE VALE DO RIBEIRA - FVR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2520, 2816, 'FACULDADE SANTO AGOSTINHO - FSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2521, 2817, 'FACULDADE DE IUNA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2522, 2818, 'FACULDADE DE VETERINRIA DE VESPASIANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2523, 2819, 'FACULDADE ANGELO VASCONCELOS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2524, 2820, 'FACULDADE PITGORAS DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2525, 2821, 'FACULDADE IDC', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2526, 2822, 'FACULDADE DE ENGENHARIA FLORESTAL DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2527, 2823, 'FACULDADE DE ENGENHARIA AGRCOLA DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2528, 2824, 'FACULDADE DE ENGENHARIA AGRONMICA DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2529, 2825, 'FACULDADE DO SISTEMA FINDES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2530, 2826, 'FACULDADE NOSSA SENHORA DE FTIMA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2531, 2827, 'FACULDADE EVANGLICA DO PIAUI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2532, 2828, 'FACULDADE ITABIRANA DE SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2533, 2829, 'INSTITUTO SUPERIOR DE EDUCAO E FILOSOFIA DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2534, 2830, 'FACULDADE ADVENTISTA DE CINCIAS DA SADE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2535, 2831, 'FACULDADE DOM BOSCO DE GOIOER', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2536, 2832, 'INSTITUTO SUPERIOR DE EDUCAO PROGRAMUS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2537, 2833, 'FACULDADE ON LINE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2538, 2834, 'INSTITUTO SUPERIOR DE PSICOLOGIA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2539, 2835, 'FACULDADE MAURCIO DE NASSAU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2540, 2836, 'FACULDADE SUL DA AMRICA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2541, 2837, 'INSTITUTO SUPERIOR DE EDUCAO SUL DA AMRICA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2542, 2838, 'FASES - FACULDADE SOTEROPOLITANA DE ENSINO SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2543, 2839, 'INSTITUTO METODISTA SUPERIOR DE EDUCAO DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2544, 2840, 'FACULDADE METODISTA DE TEOLOGIA E CINCIAS HUMANAS DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2545, 2841, 'FACULDADE PARANAPANEMA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2546, 2842, 'FACULDADE DE MEDICINA MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2547, 2843, 'FACULDADE DE CINCIAS MDICAS E DA SADE DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2548, 2844, 'FACULDADE SALESIANA DOM BOSCO DE PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2549, 2845, 'FACULDADE REINALDO RAMOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2550, 2846, 'FACULDADE DE TEOLOGIA UMBANDISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2551, 2847, 'INSTITUTO SUPERIOR DE EDUCAO DO PARANAPANEMA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2552, 2848, 'FACULDADE DE NOVO PROGRESSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2553, 2849, 'ESCOLA SUPERIOR DOM HELDER CMARA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2554, 2850, 'FACULDADE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2555, 2851, 'FACULDADE SANTA PAULINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2556, 2852, 'FACULDADE DE GESTO E NEGCIOS DO ALTO URUGUAI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2557, 2853, 'FACULDADE DE TECNOLOGIA INED - UNIDADE DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2558, 2854, 'FACULDADE CONHECER', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2559, 2855, 'FACULDADE SO FRANCISCO DE ASSIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2560, 2856, 'FACULDADE DE TECNOLOGIA QUASAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2561, 2857, 'INSTITUTO CIENTFICO DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2562, 2858, 'INSTITUTO DE SADE ALEXANDER FLEMING', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2563, 2859, 'FACULDADE DE BELM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2564, 2860, 'FACULDADE CEAQ', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2565, 2861, 'FACULDADE DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2566, 2862, 'FACULDADE DE DIREITO PRESIDENTE TANCREDO NEVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2567, 2863, 'FACULDADE DE ADMINISTRAO DE PETROLINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2568, 2864, 'FACULDADE DE DIREITO DE PETROLINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2569, 2865, 'FACULDADE DE CINCIAS SOCIAIS DE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2570, 2866, 'FACULDADE DE CINCIAS JURDICAS DE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2571, 2867, 'FACULDADE DE DIREITO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2572, 2868, 'FACULDADE DE ADMINISTRAO DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2573, 2869, 'FACULDADE DE CINCIAS SOCIAIS ADO DE ALMEIDA E SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2574, 2870, 'FACULDADE SERRA DO CARMO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2575, 2871, 'INSTITUTO SUPERIOR DE EDUCAO SERRA DO CARMO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2576, 2872, 'FACULDADE DE CINCIAS AGRRIAS RENATO AZEREDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2577, 2873, 'FACULDADE DE SISTEMAS DE INFORMAO DE SO SEBASTIO DO PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2578, 2874, 'FACULDADE DE DIREITO DE SO SEBASTIO DO PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2579, 2875, 'FACULDADE INDGENA DA AMAZNIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2580, 2876, 'FACULDADE UNISSA DE SARANDI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2581, 2877, 'FACULDADE UNISSA DE EDUCAO TECNOLGICA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2582, 2878, 'INSTITUTO SUPERIOR DE EDUCAO DE CAIEIRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2583, 2879, 'FACULDADE METROPOLITANA DE CAIEIRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2584, 2880, 'INSTITUTO SUPERIOR DE EDUCAO DE TIJUCUSSU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2585, 2881, 'INSTITUTO SUPERIOR DE EDUCAO DO SENAC-SP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2586, 2882, 'FACULDADE SO JOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2587, 2883, 'FACULDADE EDUVALE DE PARANAPANEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2588, 2884, 'INSTITUTO SUPERIOR DE EDUCAO BOM JESUS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2589, 2885, 'FACULDADE SO CAMILO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2590, 2886, 'FACULDADE ZUMBI DOS PALMARES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2591, 2887, 'FACULDADE EDUVALE DE PIRAJU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2592, 2888, 'UNIVERSIDADE DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2593, 2889, 'UNIVERSIDADE PARA O DESENVOLVIMENTO DA AMAZNIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2594, 2890, 'UNIVERSIDADE DE INTEGRAO BRASILEIRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2595, 2891, 'FACULDADE BARO DE PIRATININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2596, 2892, 'FACULDADE DE PALMARES - FAPAL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2597, 2893, 'INSTITUTO SUPERIOR DE EDUCAO DOS PALMARES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2598, 2894, 'FACULDADE INTEGRAL DE SANTA HELENA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2599, 2895, 'FACULDADE DE EDUCAO E TECNOLOGIA DA REGIO MISSIONEIRA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2600, 2896, 'FACULDADE SATC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2601, 2897, 'FACULDADE JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2602, 2899, 'FACULDADES CAIARAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2603, 2900, 'INSTITUTO TECNOLGICO REGIONAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2604, 2901, 'INSTITUTO SUPERIOR DE EDUCAO DO MDIO NORTE MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2605, 2902, 'FACULDADE DO MDIO NORTE MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2606, 2903, 'FACULDADE CONCRDIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2607, 2904, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2608, 2905, 'FACULDADE BRASILEIRA DE PEDAGOGIA / UNIBRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2609, 2906, 'FACULDADE NACIONAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2610, 2907, 'FACULDADE BRASILEIRA DE NANUQUE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2611, 2908, 'INSTITUTO NATALENSE DE ENSINO E CULTURA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2612, 2909, 'INSTITUTO DE ENSINO SUPERIOR DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2613, 2910, 'INSTITUTO SUPERIOR DE EDUCAO VERDE NORTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2614, 2911, 'INSTITUTO DE ENSINO SUPERIOR DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2615, 2912, 'FACULDADE DE CINCIA E TECNOLOGIA ALBERT EINSTEIN', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2616, 2913, 'FACULDADE DO VALE DO PARAGUAU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2617, 2914, 'INSTITUTO ABUCHAIM', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2618, 2915, 'FACULDADE CIDADE DE PATOS DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2619, 2916, 'INSTITUTO DE EDUCAO SUPERIOR DE SERGIPE - ISES', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2620, 2917, 'INSTITUTO DE ENSINO E CULTURA DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2621, 2918, 'FACULDADE DE ENSINO SUPERIOR DA AMAZNIA REUNIDA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2622, 2919, 'FACULDADE SO JOS DE RIBAMAR', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2623, 2920, 'INSTITUTO DE ENSINO SUPERIOR CATTA PRETA E DIAMANTINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2624, 2921, 'INSTITUTO SUPERIOR DE EDUCAO DA AMAZNIA REUNIDA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2625, 2922, 'INSTITUTO SUPERIOR DE EDUCAO DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2626, 2923, 'FACULDADE TABIRENSE DE ENFERMAGEM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2627, 2924, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE BUTI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2628, 2925, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2629, 2926, 'FACULDADE BRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2630, 2927, 'FACULDADE DEL REY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2631, 2928, 'FACULDADE HOLSTICA DE CINCIAS HUMANAS - FHCH', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2632, 2929, 'FACULDADE DE MILAGRES CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2633, 2930, 'FACULDADE DE SARANDI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2634, 2931, 'FACULDADE RIO GRANDE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2635, 2932, 'FACULDADE PELOTENSE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2636, 2933, 'FACULDADE TIMONENSE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2637, 2934, 'FACULDADE DE ADMINISTRAO E ECONMIA DE JOINVILLE - FAEJ', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2638, 2935, 'FACULDADE DE TALENTOS HUMANOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2639, 2936, 'INSTITUTO DE EDUCAO SUPERIOR MARISTA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2640, 2937, 'FACULDADE METROPOLITANA DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2641, 2938, 'FACULDADE DE EDUCAO DE BARCARENA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2642, 2939, 'INSTITUTO SUPERIOR DE EDUCAO TORRICELLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2643, 2940, 'FACULDADE CENECISTA DE CACHOEIRAS DE MACACU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2644, 2941, 'INSTITUTO SUPERIOR DE TEOLOGIA E PASTORAL DE BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2645, 2942, 'INSTITUTO SUPERIOR DE EDUCAO FRANCISCANO NOSSA SENHORA DE FTIMA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2646, 2943, 'INSTITUTO SUPERIOR DE EDUCAO PIRMIDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2647, 2944, 'FACULDADE DO SUL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2648, 2945, 'FACULDADE DA ASSOCIAO BRASILIENSE DE EDUCAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2649, 2946, 'FACULDADE DE ARQUITETURA E URBANISMO DO DISTRITO FEDERAL (FAU-DF)', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2650, 2947, 'FACULDADE DAS AMRICAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2651, 2948, 'REAL FACULDADE DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2652, 2949, 'FACULDADE DO BAIXO PARNABA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2653, 2950, 'ESCOLA SUPERIOR DE ADMINISTRAO, DIREITO E ECONOMIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2654, 2951, 'INSTITUTO SUPERIOR DE EDUCAO DE MORRO AGUDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2655, 2952, 'FACULDADES DO SUL - FASUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2656, 2953, 'INSTITUTO SUPERIOR DE EDUCAO DA CIDADE DO NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2657, 2954, 'FACULDADE SUL CAPIXABA - UNISUL', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2658, 2955, 'FACULDADE DE CIENCIAS HUMANAS, BIOLGICAS E DA SAUDE DO LESTE MATOGROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2659, 2956, 'FACULDADE DE CINCIAS JURIDICAS, SOCIAIS E TECNOLGICA-FACITE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2660, 2957, 'FACULDADE DE CINCIAS EXATAS E AGRRIAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2661, 2958, 'FACULDADE DE CINCIAS BIOLGICAS, HUMANAS E SADE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2662, 2959, 'FACULDADE DE CIENCIAS AGRARIAS E EXATAS DO LESTE MATOGROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2663, 2960, 'FACULDADE SANTOS DUMONT', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2664, 2961, 'FACULDADE DO PANTANAL MATOGROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2665, 2962, 'FACULDADE DE CINCIAS SOCIAIS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2666, 2963, 'FACULDADE DE CINCIAS SOCIAIS DE PETROLINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2667, 2964, 'FACULDADE DE CINCIAS DE BRASLIA - FACIBRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2668, 2965, 'FACULDADE MOKITI OKADA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2669, 2966, 'INSTITUTO SUPERIOR DE EDUCAO HELIO MAGDALENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2670, 2967, 'INSTITUTO SUPERIOR DE EDUCAAO PEDRO II', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2671, 2968, 'FACULDADE NOVA ESPERANA DE NUTRIO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2672, 2969, 'INSTITUTO SUPERIOR DE EDUCAO OCIDENTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2673, 2970, 'FACULDADE INTEGRAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2674, 2971, 'FACULDADE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2675, 2972, 'FACULDADE CHAPADINHENSE DE EDUCAO, CINCIAS E TECNOLOGIA - FACHAP', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2676, 2973, 'FACULDADE DE CINCIAS HUMANAS E BIOLGICAS E DA SADE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2677, 2974, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS APLICADAS DE PRIMAVERA DO LESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2678, 2975, 'FACULDADE JK GUAR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2679, 2976, 'INSTITUTO SUPERIOR DE EDUCAO DA FATEB', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2680, 2977, 'FACULDADES INTEGRADAS DE CIENCIAS E BIOTECNOLOGIA - FICEB', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2681, 2978, 'FACUDADE DE ODONTOLOGIA MARIO DE OLIVEIRA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2682, 2979, 'FACULDADE SUL ESPRITO SANTENSE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2683, 2980, 'FACULDADE SENAC-CEAR DE ADMINISTRAO E COMRCIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2684, 2981, 'FACULDADE SO VICENTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2685, 2982, 'FACULDADE VICTOR HUGO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2686, 2983, 'FACULDADE SO VICENTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2687, 2984, 'FACULDADE ABRAHAN LINCON', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2688, 2985, 'FACULDADE MERIDIONAL DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2689, 2986, 'INSTITUTO DE FILOSOFIA E CIENCIAS HUMANAS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2690, 2987, 'FACULDADE DE ODONTOLOGIA ALFEU GOMES DE OLIVEIRA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2691, 2988, 'INSTITUTO SUPERIOR DE EDUCAO FNIX DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2692, 2989, 'IBESS - INSTITUTO BRASILEIRO DE EDUCAO SUED E SUSEJ LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2693, 2990, 'FACULDADES DE ADMINISTRAO DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2694, 2991, 'FACULDADE DE SAPEAU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2695, 2992, 'FACULDADE DO SUDESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2696, 2993, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2697, 2994, 'INSTITUTO SUPERIOR UNIFELI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2698, 2995, 'INSTITUTO SUPERIOR DE EDUCAO LUTERANO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2699, 2996, 'FACULDADE SOTEROPOLITANA DE DIREITO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2700, 2997, 'FACULDADE DE COMUNICAO E INFORMAO DO CENTRO OESTE - COMUNICO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2701, 2998, 'FACULDADES SESI AMAZONAS - FASESI', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2702, 2999, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2703, 3000, 'FACULDADE CENECISTA DE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2704, 3001, 'FACULDADE CENECISTA DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2705, 3002, 'FACULDADE DE CINCIAS DA SADE NOSSA SENHORA DAS MERCS DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2706, 3003, 'INSTITUTO SUPERIOR DE EDUCAO JUSCELINO KUBITSCHEK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2707, 3004, 'INSTITUTO DE ENSINO SUPERIOR SANTA CECLIA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2708, 3005, 'FACULDADE SEM FRONTEIRAS - FASEF', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2709, 3006, 'INSTITUTO SUPERIOR DE EDUCAO MILTON CAMPOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2710, 3007, 'FACULDADE DO INSTITUTO NACIONAL DE PS-GRADUAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2711, 3008, 'FACULDADE DO INSTITUTO NACIONAL DE PS-GRADUAO DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2712, 3009, 'INSTITUTO DE ENSINO SUPERIOR APIA - ISA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2713, 3010, 'FACULDADE DE CINCIAS HUMANAS DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2714, 3011, 'FACULDADE PROF. MIGUEL NGELO DA SILVA SANTOS', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2715, 3012, 'FAJOPA - FACULDADE JOO PAULO II', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2716, 3013, 'INSTITUTO SUPERIOR DE EDUCAO CIDADANIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2717, 3014, 'FACULDADE DE FARMCIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2718, 3015, 'INSTITUTO DE EDUCAO SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2719, 3016, 'FACULDADE DE ENFERMAGEM JOS RODRIGUES DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2720, 3017, 'INSTITUTO SUPERIOR DE EDUCAO UNIPLAM', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2721, 3018, 'FACULDADE METROPOLITANA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2722, 3019, 'INSTITUTO DE EDUCAO SUPERIOR ANAMLIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2723, 3020, 'FACULDADE SANTA RITA DE CSSIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2724, 3021, 'INSTITUTO SUPERIOR DE EDUCAO SANTA RITA DE CSSIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2725, 3022, 'FACULDADE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2726, 3023, 'FACULDADES INTEGRADAS ATLNTICA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2727, 3024, 'FACULDADES INTEGRADAS DE ENSINO SUPERIOR DO ESTADO DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2728, 3025, 'INSTITUTO PRESBITERIANO DE EDUCAO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2729, 3026, 'FACULDADE DO PLANALTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2730, 3027, 'FACULDADE DE CINCIAS EDUCACIONAIS E SISTEMAS INTEGRADOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2731, 3028, 'FACULDADE REUNIDAS DO LITORAL DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2732, 3029, 'FACULDADE DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2733, 3030, 'INSTITUTO SUPERIOR DE EDUCAO EDUVALE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2734, 3031, 'FACULDADE ALPHA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2735, 3032, 'FACULDADE SANTA MARIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2736, 3033, 'FACULDADE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2737, 3034, 'FACULDADE DELTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2738, 3035, 'FACULDADE BARBOSA CASTILHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2739, 3036, 'LIBERTAS - INSTITUTO SUPERIOR DE CINCIAS JURIDICAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2740, 3037, 'FACULDADE DE IBINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2741, 3038, 'INSTITUTO SUPERIOR DE EDUCAO LIONS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2742, 3039, 'FACULDADE VASCONCELLOS & SOUZA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2743, 3040, 'FACULDADE VALE DO JEQUITINHONHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2744, 3041, 'FACULDADE FILADELFIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2745, 3042, 'CHRISTUS FACULDADE DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2746, 3043, 'ABEU FACULDADE DE SO JOO DE MERITI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2747, 3044, 'ABEU FACULDADE VILAR DOS TELES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2748, 3045, 'ABEU FACULDADE DE QUEIMADOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2749, 3046, 'INSTITUTO SUPERIOR DE EDUCAO - ISE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2750, 3047, 'FACULDADE POLIVALENTE - FACIP', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2751, 3048, 'INSTITUTO SUPERIOR DE EDUCAO DO INSTITUTO PORTO ALEGRE DA IGREJA METODISTA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2752, 3049, 'INSTITUTO ODONTOLGICO DO PARAN - ODONS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2753, 3050, 'FACULDADE DE TEOLOGIA DA ASSEMBLIA DE DEUS - FATEAD', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2754, 3051, 'FACULDADE TEOLGICA DE CINCIAS HUMANAS E SOCIAIS LOGOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2755, 3052, 'FACULDADE EDUCARE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2756, 3053, 'FACULDADE DE ODONTOLOGIA PR-PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2757, 3054, 'FACULDADE DE CINCIAS E TECNOLOGIA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2758, 3055, 'INSTITUTO SUPERIOR DE EDUCAO DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2759, 3056, 'ESCOLA SUPERIOR OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2760, 3057, 'INSTITUTO DE ENSINO SUPERIOR SAGRADA FAMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2761, 3058, 'INSTITUTO SUPERIOR DE EDUCAO SAGRADA FAMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2762, 3059, 'INSTITUTO DE ENSINO SUPERIOR DO PARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2763, 3060, 'INSTITUTO DE ENSINO SUPERIOR DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2764, 3061, 'INSTITUTO SUPERIOR DE EDUCAO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2765, 3062, 'FACULDADE COMERCIAL DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2766, 3063, 'FAECO - FACULDADE EDUCACIONAL COSTA OESTE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2767, 3064, 'FACULDADE DE CINCIAS EXATAS E AGRARIAS DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2768, 3065, 'INSTITUTO SUPERIOR DE EDUCAO DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2769, 3066, 'FACULDADE INTERAMERICANA DE BELM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2770, 3067, 'FACULDADE ROTHSCHILD DE EDUCAO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2771, 3068, 'FACULDADE DE TEOLOGIA E CINCIAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2772, 3069, 'INSTITUTO DE EDUCAO SUPERIOR DE ALAGOAS NO LITORAL NORTE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2773, 3070, 'FACULDADE DE BELA VISTA DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2774, 3071, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2775, 3072, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE JACOBINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2776, 3073, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE CRUZ DAS ALMAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2777, 3074, 'FACULDADE DO EXTREMO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2778, 3075, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2779, 3076, 'FACULDADE DE SADE IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2780, 3077, 'FACULDADE METROPOLITANA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2781, 3078, 'INSTITUTO SUPERIOR DE EDUCAO FRUTALENSE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2782, 3079, 'INSTITUTO DE ENSINO SUPERIOR ALTERNATIVO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2783, 3080, 'FACULDADE DE ARTE E DESIGN BERLIM - BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2784, 3081, 'FACULDADE ITALIANA DE TECNOLOGIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2785, 3082, 'FACULDADE 2 DE JULHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2786, 3083, 'FACULDADE INTEGRADA UNIVERACRUZ DE GUANAMBI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2787, 3084, 'FACULDADE MARQUS DE POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2788, 3085, 'FACULDADE EVANGLICA LUZ E VIDA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2789, 3086, 'FACULDADE DA MODA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2790, 3087, 'CHRISTUS INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2791, 3088, 'FACULDADE UNIDAS SUL BAHIA - FUSBA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2792, 3089, 'FACULDADE CAIARAS DE TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2793, 3090, 'INSTITUTO SUPERIOR NORMAL AURELINA PALMEIRA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2794, 3091, 'CENTRO DE ENSINO LEIDE TORRES', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2795, 3092, 'FACULDADE DE BEM ESTAR SOCIAL E SADE DE ITAPECERICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2796, 3093, 'FACULDADE DE ENFERMAGEM JOO FRANCISCO DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2797, 3094, 'FACULDADE DE DIREITO DESEMBARGADOR AFFONSO TEIXEIRA LAGES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2798, 3095, 'FACULDADE DE CINCIAS AGRRIAS DOM ORIONE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2799, 3096, 'FACULDADE DE AGRONOMIA MANOEL ANTNIO DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2800, 3097, 'FACULDADE DE DIREITO AFONSO PENA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2801, 3098, 'INSTITUTO SUPERIOR DE EDUCAO SO JUDAS TADEU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2802, 3099, 'FACULDADE POTIGUAR DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2803, 3100, 'FACULDADE INTEGRADA UNIVERACRUZ DE BOM JESUS DA LAPA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2804, 3101, 'FACULDADE INTEGRADA UNIVERACRUZ DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2805, 3102, 'FACULDADE INTEGRADA UNIVERACRUZ DE CAMPO FORMOSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2806, 3103, 'FACULDADE INTEGRADA UNIVERACRUZ DE BRUMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2807, 3104, 'FACULDADE INTEGRADA UNIVERACRUZ DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2808, 3105, 'FACULDADE INTEGRADA UNIVERACRUZ DE JACOBINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2809, 3106, 'FACULDADE INTEGRADA UNIVERACRUZ DE ITAMARAJ', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2810, 3107, 'FACULDADE BENEMRITA EDUCADORA UNIVERACRUZ DE PAULO AFONSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2811, 3108, 'FACULDADE INTEGRADA UNIVERACRUZ DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2812, 3109, 'FACULDADE ITEGRADA UNIVERACRUZ DE VALENA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2813, 3110, 'FACULDADE ITEGRADA UNIVERACRUZ DE CAMAARI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2814, 3111, 'FACULDADE INTEGRADA UNIVERACRUZ DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2815, 3112, 'FACULDADE INTEGRADA UNIVERACRUZ DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2816, 3113, 'FACULDADE INTEGRADA UNIVERACRUZ DE PILO ARCADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2817, 3114, 'FACULDADE INTEGRADA UNIVERACRUZ DE VITRIA DA CONQUISTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2818, 3115, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO DE PIRAPORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2819, 3116, 'FACULDADE SANTO AGOSTINHO DE PIRAPORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2820, 3117, 'FACULDADE DE SADE E DESENVOLVIMENTO HUMANO SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2821, 3118, 'FALCUDADE INTEGRADA UNIVERACRUZ DE BARRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2822, 3119, 'FACULDADE INTEGRADA UNIVERACRUZ DE DIAS D''AVILA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2823, 3120, 'FACULDADE INTEGRADA UNIVERACRUZ DE CANDEIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2824, 3121, 'FACULDADE INTEGRADA UNIVERACRUZ DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2825, 3122, 'FACULDADE INTEGRADA UNIVERACRUZ SIMES FILHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2826, 3123, 'FACULDADE INTEGRADA UNIVERACRUZ DE SANTA MARIA DA VITRIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2827, 3124, 'FACULDADE DO DISTRITO FEDERAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2828, 3125, 'FACULDADE INTEGRADA UNIVERACRUZ DE PORTO SEGURO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2829, 3126, 'FACULDADE INTEGRADA UNIVERACRUZ DE SENHOR DO BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2830, 3127, 'FACULDADE INTEGRADA UNIVERACRUZ DE IRECE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2831, 3128, 'FACULDADE INTEGRADA UNIVERACRUZ DE LAURO DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2832, 3129, 'FACULDADE INTEGRADA UNIVERACRUZ DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2833, 3130, 'FACULDADE INTEGRADA UNIVERACRUZ DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2834, 3131, 'FACULDADE INTEGRADA UNIVERACRUZ DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2835, 3132, 'FACULDADE INEGRADA UNIVERACRUZ DE EUCLIDES DA CUNHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2836, 3133, 'FACULDADE INTEGRADA UNIVERACRUZ DE JUAZEIRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2837, 3134, 'FACULDADE INTEGRADA UNIVERACRUZ DE ITABERABA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2838, 3135, 'FACULDADE INTEGRADA UNIVERACRUZ DE TEIXEIRA DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2839, 3136, 'FACULDADES INTEGRADA UNIVERACRUZ DE IPIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2840, 3137, 'FACULDADE INTEGRADA UNIVERACRUZ DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2841, 3138, 'FACULDADE DINMICA DE ITAIPULNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2842, 3139, 'INSTITUTO DE SUPERIOR DE EDUCAO FRANCISCO AGUIAR', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2843, 3140, 'FACULDADE ZEUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2844, 3141, 'FACVALE - FACULDADE DO VALE DO JACUPE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2845, 3142, 'INSTITUTO SUPERIOR DE EDUCAO EDEM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2846, 3143, 'FACULDADE DO VAREJO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2847, 3144, 'FACULDADE GUAS LINDAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2848, 3145, 'FACULDADE DE DIREITO SO JUDAS TADEU DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2849, 3146, 'FACULDADE DE ODONTOLOGIA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2850, 3147, 'FACULDADE DE DIREITO DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2851, 3148, 'FACULDADE ANCHIETA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2852, 3149, 'FACULDADES INTEGRADAS DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2853, 3150, 'INSTITUTO SUPERIOR DE EDUCAO DA FACULDADE DE CINCIAS E LETRAS DE ARARAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2854, 3151, 'UNIVERSIDADE COMUNITRIA REGIONAL DE CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2855, 3152, 'INSTITUTO SUPERIOR DE EDUCAO SANTA RITA DO SAPUCA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2856, 3153, 'INSTITUTO SUPERIOR DE EDUCAO CANTAREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2857, 3154, 'FACULDADE DE TECNOLOGIA SENAI RIO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2858, 3155, 'FACULDADE DE TECNOLOGIA SENAI JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2859, 3156, 'FACULDADE DE TECNOLOGIA SENAI BRUSQUE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2860, 3157, 'INSTITUTO SUPERIOR DE EDUCAO ALMEIDA RODRIGUES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2861, 3158, 'INSTITUTO SUPERIOR DE EDUCAO ANGLO-AMERICANO DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2862, 3159, 'FACULDADE DE TECNOLOGIA SENAI FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2863, 3160, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE ALAGOAS', 1, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2864, 3161, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO SERTO PERNAMBUCANO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2865, 3162, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DE SANTA CATARINA', 1, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2866, 3163, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2867, 3164, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE MATO GROSSO', 1, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2868, 3165, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DO TRINGULO MINEIRO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2869, 3166, 'INSTITUTO SUPERIOR DE EDUCAO DE IBINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2870, 3167, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2871, 3168, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2872, 3169, 'FACULDADE DE TECNOLOGIA IBTA CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2873, 3170, 'FACULDADES INTEGRADAS ASSOCIAO DE ENSINO DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2874, 3171, 'FACULDADE EQUIPE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2875, 3172, 'UNIVERSIDADE DO ESTADO DO AMAZONAS', 2, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2876, 3173, 'FACULDADE DE TECNOLOGIA DO COMRCIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2877, 3174, 'INSTITUTO SUPERIOR DE EDUCAO DE VINHEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2878, 3175, 'INSTITUTO SUPERIOR DE EDUCAO DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2879, 3176, 'INSTITUTO SUPERIOR DE EDUCAO EQUIPE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2880, 3177, 'FACULDADE DE ADMINISTRAO DA FESPSP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2881, 3178, 'INSTITUTO DE EDUCAO SUPERIOR DE BARUERI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2882, 3179, 'FACULDADE DA CIDADE DE SO GONALO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2883, 3180, 'INSTITUTO SUPERIOR DE EDUCAO UNIO DAS AMRICAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2884, 3181, 'FACULDADE DE DIREITO DE BOA VISTA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2885, 3182, 'CENTRO DE ENSINO SUPERIOR ARCANJO MIKAEL DE ARAPIRACA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2886, 3183, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE SERGIPE', 1, 1, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2887, 3184, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE RORAIMA', 1, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2888, 3185, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE SO VICENTE DO SUL', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2889, 3186, 'FACULDADE EVOLUO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2890, 3187, 'INSTITUTO SUPERIOR DE EDUCAO CORAO DE JESUS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2891, 3188, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO NORTE DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2892, 3189, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2893, 3190, 'INSTITUTO SUPERIOR DE EDUCAO DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2894, 3191, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2895, 3192, 'INSTITUTO SUPERIOR DE EDUCAO DE CAJAZEIRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2896, 3193, 'FACULDADES INTEGRADAS DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2897, 3194, 'FACULDADE DE MINAS BH', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2898, 3195, 'FACULDADE VILA RICA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2899, 3196, 'FACULDADE PONTES E LACERDA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2900, 3197, 'FACULDADES DO PARECIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2901, 3198, 'FACULDADE DE CINCIAS HUMANAS DE IVAIPOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2902, 3199, 'FANESF - FACULDADE NACIONAL DE ENSINO SUPERIOR DA FAZENDA RIO GRANDE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2903, 3200, 'FANPINHAIS - FACULDADE NACIONAL DE PINHAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2904, 3201, 'FACULDADE DE EDUCAO E ENSINO SUPERIOR DO ABRANCHES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2905, 3202, 'FACULDADES AUGUSTUS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2906, 3203, 'INSTITUTO SUPERIOR DE EDUCAO ALBERT EINSTEIN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2907, 3204, 'FACULDADE DE QUATRO MARCOS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2908, 3205, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2909, 3206, 'INSTITUTO DO SABER', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2910, 3207, 'FACULDADES DE CAFELNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2911, 3208, 'FACULDADE AMERICA DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2912, 3209, 'FACULDADE DE ARAATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2913, 3210, 'INSTITUTO EDUCACIONAL EVANGELICO DE ARAPONGAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2914, 3211, 'FACDIPAR-FACULDADE DE DIREITO DO PARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2915, 3212, 'INSTITUTO SUPERIOR DE FILOSOFIA BERTHIER', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2916, 3213, 'AFIMA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2917, 3214, 'FACULDADE EUROPEU DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2918, 3215, 'FACULDADE RELIGARE TEOLGICA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2919, 3216, 'FACULDADE DE CINCIAS DA BAHIA - FACIBA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2920, 3217, 'FACULDADE DE ENSINO SUPERIOR DO BRASIL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2921, 3218, 'FACULDADE DE CINCIAS DA SADE DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2922, 3219, 'FACULDADE EVANGLICA DE INDAIATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2923, 3220, 'INSTITUTO NACIONAL DE EDUCAO SUPERIOR DE EDUCAO E CULTURA - INESC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2924, 3221, 'FACULDADE DE ODONTOLOGIA DE MACAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2925, 3222, 'FACULDADE DE ODONTOLOGIA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2926, 3223, 'ESCOLA SUPERIOR DE CINCIAS DA SADE', 2, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2927, 3224, 'FACULDADE DE FARMCIA E BIOQUMICA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2928, 3225, 'FACULDADE DE ENFERMAGEM', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2929, 3226, 'FACULDADE DE MEDICINA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2930, 3227, 'FACULDADE DE SISTEMA DE INFORMAO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2931, 3228, 'FACULDADE DE ADMINISTRAO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2932, 3229, 'FACULDADE DE TURISMO DE DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2933, 3230, 'FACULDADE LUIZ EDUARDO MAGALHES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2934, 3231, 'INSTITUTO SUPERIOR DE EDUCAO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2935, 3232, 'FACULDADE IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2936, 3233, 'FACULDADE AMRICA DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2937, 3234, 'URN. FACULDADE DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2938, 3235, 'INSTITUTO SUPERIOR DE EDUCAO JOO PAULO PRIMEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2939, 3236, 'INSITUTO DE TEOLOGIA DA DIOCESE DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2940, 3237, 'FACULDADE SENAC DE ADMINISTRAO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2941, 3238, 'FACULDADE DE ODONTOLOGIA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2942, 3239, 'INSTITUTO DE DESENVOLVIMENTO EDUCACIONAL SUL CATARINENSE S/C LTDA.', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2943, 3240, 'INSTITUTO SUPERIOR DE EDUCAO DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2944, 3241, 'FACULDADE NACIONAL DE EDUCAO E ENSINO SUPERIOR DO BRASIL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2945, 3242, 'FACULDADE ALFA BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2946, 3243, 'FACULDADE NACIONAL CAMPO LARGO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2947, 3244, 'FACULDADE DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2948, 3245, 'FACULDADE DE SENADOR CANEDO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2949, 3246, 'FACULDADE DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2950, 3247, 'FACULDADE VITRIA DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2951, 3248, 'FACULDADE DE DOMINGOS MARTINS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2952, 3249, 'FACULDADE PADRAO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2953, 3250, 'FACULDADE DE MORRINHOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2954, 3251, 'FACULDADE DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2955, 3252, 'FACULDADE QUIRINPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2956, 3253, 'FACULDADE COSTA ESMERALDA ITAPEMA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2957, 3254, 'FACULDADE DE EDUCAO E TEOLOGIA VIVA - FATEV', 1, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2958, 3255, 'FACULDADE INPG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2959, 3256, 'INSTITUTO SUPERIOR DE ECOLOGIA HUMANA E DESENVOLVIMENTO SUSTENTVEL- ISEDS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2960, 3257, 'FAESSF - FACULDADE DE ENSINO SUPERIOR SANTA FELICIDADE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2961, 3258, 'FACULDADE DE DIREITO DE RESENDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2962, 3259, 'FACULDADES DO ICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2963, 3260, 'FACULDADE PRINCESA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2964, 3261, 'FACULDADE DE EDUCAO E ENSINO SUPERIOR INTEGRAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2965, 3262, 'FACULDADE DOM BOSCO DE GUARANIAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2966, 3263, 'FACULDADE YVERDUN BRASILIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2967, 3265, 'FACULDADE BATISTA IDA NELSON', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2968, 3266, 'UNIDADE VOCACIONAL CIDADES - UVC', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2969, 3267, 'FACULDADE TADEU ARGOLO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2970, 3268, 'FACULDADE MADRE THAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2971, 3269, 'FACULDADE DE JUAZEIRO DO NORTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2972, 3270, 'FACULDADE SO BENTO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2973, 3271, 'FACULDADE QUASAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2974, 3272, 'FACULDADE DE DIREITO DE PETROLINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2975, 3273, 'FACULDADE DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2976, 3274, 'FACULDADE PSICOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2977, 3275, 'FACULDADE JURIDICA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2978, 3276, 'FACULDADE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2979, 3277, 'FACULDADE DE TECNOLOGIA PREVE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2980, 3278, 'FACULDADE DE TECNOLOGIA MARTINUS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2981, 3279, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO SUDESTE DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2982, 3280, 'FACULDADE SO JOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2983, 3281, 'FACULDADE DO DESENVOLVIMENTO DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2984, 3282, 'FACULDADE PONTAL DO PARANAPANEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2985, 3283, 'INSTITUTO BRASILEIRO DE ZOOTECNOLOGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2986, 3284, 'ESCOLA SUPERIOR DE ADMINISTRAO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2987, 3285, 'FACULDADE SANTO ANTONIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2988, 3286, 'FACULDADE DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2989, 3287, 'FACULDADE DA ASSEDIPA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2990, 3288, 'FACULDADE GENESIS - FAGEN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2991, 3289, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2992, 3290, 'INSTITUTO SUPERIOR DE EDUCAO DOS INCONFIDENTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2993, 3291, 'FACULDADE DUARTE COELHO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2994, 3292, 'INSTITUTO SUPERIOR DE EDUCAO DE CAET', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2995, 3293, 'FACULDADE DE TECNOLOGIA DIAMANTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2996, 3294, 'FACULDADE DE TECNOLOGIA ENIAC-FAPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2997, 3295, 'FACULDADE DE TECNOLOGIA SENAC FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2998, 3296, 'FACULDADE DE TECNOLOGIA SENAC RIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (2999, 3297, 'CENTRO DE EDUCAO TECNOLGICA CHRISTUS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3000, 3298, 'FACULDADE DE TECNOLOGIA CAMES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3001, 3299, 'FACULDADE DE TECNOLOGIA INFORMTICA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3002, 3300, 'FACULDADE DE TECNOLOGIA MICHEL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3003, 3301, 'FACULDADE DE TECNOLOGIA MAGISTER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3004, 3302, 'INSTITUTO SUPERIOR DE EDUCAO DE JUNQUEIRPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3005, 3303, 'FACULDADES INTEGRADAS MATO-GROSSENSES DE CINCIAS SOCIAIS E HUMANAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3006, 3304, 'FACULDADES INTEGRADAS DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3007, 3305, 'FACULDADE PITGORAS DE PSICOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3008, 3306, 'FACULDADE DE TECNOLOGIA IPUC', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3009, 3307, 'FACULDADE DE TECNOLOGIA DE RIO CLARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3010, 3308, 'FACULDADE DE TECNOLOGIA TERMOMECNICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3011, 3309, 'FACULDADE DE TECNOLOGIA INTERNACIONAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3012, 3310, 'FACULDADE DE TECNOLOGIA DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3013, 3311, 'FACULDADE DE TECNOLOGIA SO FRANCISCO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3014, 3312, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE RIO VERDE', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3015, 3313, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE BAMBU', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3016, 3314, 'FACULDADE DE CINCIAS GERENCIAIS DA FUNCEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3017, 3315, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3018, 3316, 'FACULDADE SUDOESTE PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3019, 3317, 'FACULDADE MASTER', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3020, 3318, 'FACULDADE MASTER', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3021, 3319, 'FACULDADE DE ENSINO SUPERIOR DE CATALO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3022, 3320, 'INSTITUTO DE TELEMARKETING E SERVIO AO CLIENTE LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3023, 3321, 'FACIVALE -FACULDADE INTERNACIONAL DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3024, 3322, 'FACULDADE POLITCNICA DE ATIBAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3025, 3323, 'INSTITUTO DE EDUCAO E ENSINO SUPERIOR DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3026, 3324, 'FACULDADE TALENTI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3027, 3325, 'FACULDADE COMUNITRIA DE CONTAGEM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3028, 3326, 'CENTRO SUPERIOR DE ESTUDOS JURDICOS CARLOS DRUMMOND DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3029, 3327, 'UNIPONTE - FACULDADE DA MEIA PONTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3030, 3328, 'CENTRO DE ESTUDOS SUPERIORES EM CINCIAS DA SADE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3031, 3329, 'FACULDADE DE DIREITO DE PAR DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3032, 3330, 'INSTITUTO DE LNGUA PORTUGUESA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3033, 3331, 'FAMOL - FACULDADE MONTEIRO LOBATO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3034, 3332, 'FACULDADE DE TECNOLOGIA SENAC RIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3035, 3333, 'FACULDADE DE TECNOLOGIA TECBRASIL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3036, 3334, 'FACULDADE DE TECNOLOGIA SO GONALO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3037, 3335, 'FACULDADE DE CINCIAS E LETRAS DO NOROESTE DO PARAN FACIP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3038, 3336, 'UNIVERSIDADE ESTADUAL DO RIO GRANDE DO SUL', 2, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3039, 3337, 'FACULDADE DE TECNOLOGIA DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3040, 3338, 'INSTITUTO SUPERIOR DE EDUCAO GETLIO VARGAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3041, 3339, 'FACULDADE DE GETLIO VARGAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3042, 3340, 'FACULDADE DE PAULISTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3043, 3341, 'FACULDADES DE ALTO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3044, 3342, 'FACULDADE EVANGLICA DE CINCIA FILOSOFICA E TEOLGICA DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3045, 3343, 'FACULDADES DO PARECIS - FACCIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3046, 3344, 'FACULDADE REGIONAL DE IREC', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3047, 3345, 'FACULDADE YVERDON DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3048, 3346, 'FACULDADE YVERDON', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3049, 3347, 'FACULDADE REGIONAL DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3050, 3348, 'FACULDADE REGIONAL DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3051, 3349, 'FACULDADE REGIONAL METROPOLITANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3052, 3350, 'FACULDADE REGIONAL DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3053, 3351, 'INSTITUTO SUPERIOR DO NOROESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3054, 3352, 'FACULDADE REGIONAL DE SANTO AMARO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3055, 3353, 'FACULDADE RECON.BAHIA EMPRESARIAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3056, 3354, 'FACULDADE REGIONAL DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3057, 3355, 'FACULDADE REGIONAL DE SO FLIX', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3058, 3356, 'INSTITUTO TEOLGICO DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3059, 3357, 'FACULDADE DO SERTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3060, 3358, 'FACULDADE CIENTFICA DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3061, 3359, 'FESC - FACULDADE DO EXTREMO SUL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3062, 3360, 'INSTITUTO DE EDUCAO SUPERIOR PRESIDENTE KENNEDY - CENTRO DE FORMAO DE PROFISSIONAIS DE EDUCAO', 2, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3063, 3361, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3064, 3362, 'INSTITUTO DE CINCIAS HUMANAS E SOCIAIS APLICADAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3065, 3363, 'FACULDADE GUARA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3066, 3364, 'FACULDADE DE ENFERMAGEM DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3067, 3365, 'FACULDADE SO FRANCISCO DE JUAZEIRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3068, 3366, 'FACULDADE DE CINCIAS GERENCIAIS DE OLIVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3069, 3367, 'INSTITUTO SUPERIOR DE EDUCAO DE OLIVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3070, 3368, 'CENTRO UNIVERSITRIO DO SUL DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3071, 3369, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS GEREMRIO DANTAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3072, 3370, 'ESCOLA DOMINICANA DE TEOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3073, 3371, 'CENTRO UNIVERSITRIO DE PATOS DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3074, 3372, 'CENTRO UNIVERSITRIO DE LAVRAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3075, 3373, 'INSTITUTO SUPERIOR DE EDUCAO DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3076, 3374, 'FACULDADE PAUL SABATIER DE EDUCAO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3077, 3375, 'INSTITUTO DE ENSINO SUPERIOR MLTIPLO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3078, 3376, 'FACULDADE DE TEOLOGIA INTEGRADA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3079, 3377, 'FACULDADE MONTESSORIANO DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3080, 3378, 'FACULDADE CENECISTA DE RECIFE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3081, 3379, 'INSTITUTO DE EDUCAO SUPERIOR SERRANO - IESSER', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3082, 3380, 'FACULDADE MISSIONEIRA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3083, 3381, 'UNITEC FACULDADE TECNOLGICA E CIENTFICA DE UNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3084, 3382, 'ESCOLA SUPERIOR DE ENFERMAGEM E PEDAGOGIA MARIA PASTOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3085, 3383, 'INSTITUTO SUPERIOR DE EDUCAO SAGRA - ISAGRA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3086, 3384, 'FACULDADE SAGRA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3087, 3385, 'FACULDADE DE DIREITO PROFESSOR PEDRO ALEIXO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3088, 3386, 'FACULDADE DE ADMINISTRAO DE EMPRESAS - UNITECH', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3089, 3387, 'FACULDADE NACIONAL DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3090, 3388, 'FACULDADE PARASO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3091, 3389, 'FACULDADE RAZES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3092, 3390, 'FACULDADE DE DIREITO DO ICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3093, 3391, 'INSTITUTO SUPERIOR DE EDUCAO NOVA VIDA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3094, 3392, 'FACULDADE DA ACADEMIA BRASILEIRA DE EDUCAO E CULTURA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3095, 3393, 'FACULDADE DE ENSINO SUPERIOR DOM BOSCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3096, 3394, 'FACULDADE VALE DO IPIRANGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3097, 3395, 'FACULDADE EDUCIONAL SUL PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3098, 3396, 'FACULDADE LS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3099, 3397, 'FACULDADE BOAS NOVAS DE CINCIAS TEOLGICAS, SOCIAIS E BIOTECNOLGICAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3100, 3398, 'FACULDADE DE CINCIAS DO ESTADO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3101, 3399, 'FACULDADE DE TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3102, 3400, 'FACULDADE DE SADE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3103, 3401, 'FACULDADE DE ITAPECERICA DA SERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3104, 3402, 'FACULDADE ANGLICANA DE NEGCIOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3105, 3403, 'INSTITUTO SUPERIOR DE EDUCAO RUI BARBOSA - ISURB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3106, 3404, 'FACULDADE DE FILOSOFIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3107, 3405, 'FACULDADE RUI BARBOSA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3108, 3406, 'FACULDADE CNDIDO RONDON', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3109, 3407, 'IESEMA - INSTITUTO SUPERIOR DE EDUCAO DA MATA ALAGOANA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3110, 3408, 'FACULDADE AMAZNIA DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3111, 3409, 'FACULDADE DE CINCIAS DA SADE CRISTO REI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3112, 3410, 'INSTITUTO DE EDUCAO SUPERIOR FATEV', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3113, 3411, 'FACULDADE EA DE QUEIROS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3114, 3412, 'FACULDADE DO INTERIOR PAULISTA DE TANABI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3115, 3413, 'ISEMP - INSTITUTO SUPERIOR DE EDUCAO DA MATA PERNAMBUCANA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3116, 3414, 'FACULDADE DO ENTORNO DE BRASLIA - FAEB', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3117, 3415, 'FACULDADE DE TECNOLOGIA DE CAXIAS DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3118, 3416, 'FACULDADE JK DO GAMA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3119, 3417, 'FACULDADE DO CENTRO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3120, 3418, 'FACULDADE VALE DO CARIRI', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3121, 3419, 'FACULDADE CHROMOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3122, 3420, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPOS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3123, 3421, 'FACULDADE DE MANDAGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3124, 3422, 'FACULDADE TEOLGICA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3125, 3423, 'FACULDADE DE ADMINISTRAO DE NOVO PROGRESSO', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3126, 3424, 'FACULDADE DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3127, 3425, 'FACETE - FACULDADE DE ARTES, CINCIAS E TECNOLOGIAS DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3128, 3426, 'ESCOLA SUPERIOR DE CINCIAS TRADICIONAIS E AMBIENTAIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3129, 3427, 'FACULDADE JOS AUGUSTO VIEIRA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3130, 3428, 'FACULDADE ALFA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3131, 3429, 'FACULDADE RIO DAS CONTAS - FAC-RIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3132, 3430, 'FACULDADE DE MARKETING E NEGCIOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3133, 3431, 'FACULDADE DO SERID', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3134, 3432, 'FACULDADES INTEGRADAS DE CINCIAS HUMANAS, SADE E EDUCAO DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3135, 3433, 'INSTITUTO SUPERIOR DE EDUCAO INTERLAGOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3136, 3434, 'FACULDADE DE SADE IBITURUNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3137, 3435, 'INSTITUTO SUPERIOR DE EDUCAO NORTE MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3138, 3436, 'FACULDADE SAVONITTI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3139, 3437, 'FACULDADE DO LITORAL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3140, 3438, 'FACULDADE MASTER DE PALMAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3141, 3439, 'FACULDADE MASTER DE PARAUAPEBAS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3142, 3440, 'FACULDADE MASTER DE SANTARM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3143, 3441, 'FACULDADE MASTER DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3144, 3442, 'INSTITUTO DE ENSINO ALVARES DE AZEVEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3145, 3443, 'FACULDADE INEDI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3146, 3444, 'FACULDADE DE CINCIAS BIOLGICAS E SOCIAIS APLICADAS JEFFERSON JORGE SALOMO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3147, 3445, 'FACULDADE JOO DO VALE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3148, 3446, 'INSTITUTO SUPERIOR DE EDUCAO JOO DO VALE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3149, 3447, 'FACULDADES SANTAMARIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3150, 3448, 'INSTITUTO SUPERIOR DE EDUCAO IBITURUNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3151, 3449, 'TRECSON FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3152, 3450, 'FACULDADES MASTER', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3153, 3451, 'INSTITUTO SUPERIOR DE EDUCAO DO LITORAL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3154, 3453, 'FACULDADE JUSCELINO KUBTSCHEK GUAR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3155, 3454, 'FACULDADES LEONEL AGUIAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3156, 3455, 'FACULDADE DE EDUCAO EXPOVEST', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3157, 3456, 'FACULDADE POLITCNICA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3158, 3457, 'FESC- FACULDADE DO EXTREMO SUL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3159, 3458, 'ACADEMIA TEOLGICA DA GRAA DE DEUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3160, 3459, 'INSTITUTO DE ENSINO SUPERIOR E PESQUISA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3161, 3460, 'INSTITUTO SUPERIOR DE ENSINO E PESQUISA DE ITUIUTABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3162, 3461, 'FACULDADE DE FILOSOFIA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3163, 3462, 'FACULDADE DE ENFERMAGEM DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3164, 3463, 'FACULDADE DE DIREITO DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3165, 3464, 'FACULDADE DE ENGENHARIA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3166, 3465, 'FACULDADE DE INFORMTICA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3167, 3466, 'FACULDADE DE SERVIO SOCIAL DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3168, 3467, 'FACULDADE DE NUTRIO DA FUNDAO DE ENSINO SUPERIOR DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3169, 3468, 'FACULDADE DE ENGENHARIA DO TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3170, 3469, 'FACULDADE DE ADMINISTRAO DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3171, 3470, 'FACULDADE EDUCAO FSICA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3172, 3471, 'FACULDADE DE MODA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3173, 3472, 'INSTITUTO SUPERIOR DE EDUCAO DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3174, 3473, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE CARANGOLA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3175, 3474, 'FACULDADE DE CINCIAS EXATAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3176, 3475, 'INSTITUTO SUPERIOR DE EDUCAO DE CARANGOLA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3177, 3476, 'FACULDADE DE FILOSOFIA E LETRAS DE DIAMANTINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3178, 3477, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS NOSSA SENHORA DE SION', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3179, 3478, 'FACULDADE DE CINCIAS EXATAS E HUMANAS DA CAMPANHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3180, 3479, 'INSTITUTO SUPERIOR DE EDUCAO NOSSA SENHORA DE SION', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3181, 3480, 'FACULDADE DE CINCIAS JURDICAS DE DIAMANTINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3182, 3481, 'INSTITUTO SUPERIOR DE EDUCAO DE DIAMANTINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3183, 3482, 'INSTITUTO SUPERIOR DE EDUCAO DE DIVINPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3184, 3483, 'INSTITUTO SUPERIOR DE EDUCAO DE CLUDIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3185, 3484, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3186, 3485, 'INSTITUTO SUPERIOR DE EDUCAO DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3187, 3486, 'INSTITUTO SUPERIOR DE EDUCAO DE ITUIUTABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3188, 3487, 'FACULDADE SENAC/RS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3189, 3488, 'FACULDADE DE CINCIAS ECONMICAS DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3190, 3489, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3191, 3490, 'FACULDADE DE ENGENHARIA ELTRICA DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3192, 3491, 'FACULDADE EVANGLICA DO BRASIL (FAEB)', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3193, 3492, 'FACULDADE DE DIREITO DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3194, 3493, 'FACULDADE PROJETO DIDTICO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3195, 3494, 'FACULDADE GUAJARAENSE DE EDUCAO E CULTURA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3196, 3495, 'FACULDADE PINHALZINHO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3197, 3496, 'INSTITUTO NACIONAL DE DESENVOLVIMENTO HUMANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3198, 3497, 'FACULDADE BRASILIENSE DE DIREITO - FADIR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3199, 3498, 'FACULDADE DE ARTES, TECNOLOGIA E NEGCIOS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3200, 3499, 'INSTITUTO BOLSA DE VALORES', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3201, 3500, 'FACULDADE DO SERTO BAIANO - FASB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3202, 3501, 'FACULDADE DE ADMINISTRAO DE SANTO ANTNIO DO MONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3203, 3502, 'FACULDADE DA FRONTEIRA - FAF', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3204, 3503, 'FACUDADE DA CINCIA DA SAUDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3205, 3504, 'ESCOLA DE ENSINO SUPERIOR DE BRASILNDIA DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3206, 3505, 'INSTITUTO SUPERIOR DE EDUCAO DE JACUTINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3207, 3506, 'FACULDADE DE CINCIAS EDUCACIONAIS DE SERGIPE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3208, 3507, 'FACULDADE DE ADMINISTRAO DE EMPRESAS IBRAFEM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3209, 3508, 'FACULDADE SANTO ANTONIO DE QUEIMADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3210, 3509, 'FACULDADE VICENTINA - FAVI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3211, 3510, 'UNASP.FACULDADE DO SERVIDOR PBLICO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3212, 3511, 'FACULDADES COMUNITRIA UNIDAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3213, 3512, 'ILES - INSTITUTO LOGOS DE EDUCAO E ENSINO SUPERIOR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3214, 3513, 'FACULDADE DE PRESIDENTE VENCESLAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3215, 3514, 'FACULDADE DE CINCIAS GERENCIAIS ALVES FORTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3216, 3515, 'FACULDADES INTEGRADAS DA VITRIA DE SANTO ANTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3217, 3516, 'FACULDADE DE CINCIAS DA SADE ARCHIMEDES THEODORO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3218, 3517, 'FACULDADE IEGS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3219, 3518, 'FACULDADE JANGADA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3220, 3519, 'FACULDADE DE CINCAS GERENCIAIS DO ALTO PARAOPEBA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3221, 3520, 'INSTITUTO DE EDUCAO SUPERIOR SANTA MARIA (IESSAM)', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3222, 3521, 'FACULDADE EXPOENTE DE EDUCAO E PESQUISA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3223, 3522, 'FACULDADE CATLICA DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3224, 3523, 'ESCOLA SUPERIOR DO MINISTRIO PBLICO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3225, 3524, 'UNIBUSINESS - FACULDADE INTERNACIONAL DE EDUCAO E GERNCIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3226, 3525, 'FACULDADE EVANGLICA DE TECNOLOGIA, CINCIAS E BIOTECNOLOGIA DA CGADB', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3227, 3526, 'INSTITUTO DE ENSINO SUPERIOR MIGUEL DE CERVANTES', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3228, 3527, 'FACULDADE CATLICA DOM AQUINO DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3229, 3528, 'FACULDADES CATLICAS DE FRANCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3230, 3529, 'CENTRO UNIVERSITRIO EURPEDES DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3231, 3530, 'FACULDADE DE NANUQUE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3232, 3531, 'FACULDADE CACHOEIRO DE ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3233, 3532, 'FACULDADE DO OESTE CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3234, 3533, 'FACULDADE CERES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3235, 3534, 'FACULDADE BRASILEIRA DE ENSINO SUPERIOR E TECNOLOGIA - FABEST', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3236, 3535, 'FACULDADE PAULISTA DE CINCIAS FARMACUTICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3237, 3536, 'FACULDADE DE TEOLOGIA EVANGLICA EM CURITIBA - FATEV', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3238, 3537, 'INSTITUTO BRASILEIRO DE MODA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3239, 3538, 'FACULDADES INTEGRADAS SVIGN', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3240, 3539, 'FACULDADE SANTA LCIA - MOGI GUAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3241, 3540, 'UNIO DE FACULDADES DE ADMINISTRAO PBLICA - UNIFAP', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3242, 3541, 'FACULDADE NOTRE DAME', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3243, 3542, 'INSTITUTO DE ENSINO SUPERIOR DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3244, 3543, 'FACULDADE NOVO HAMBURGO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3245, 3544, 'FACULDADE DE FISIOTERAPIA MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3246, 3546, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BARRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3247, 3547, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3248, 3548, 'FACULDADE SUA DE HOTELARIA DE JOINVILLE S.A.', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3249, 3549, 'FACULDADE NACIONAL SNIOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3250, 3550, 'FACULDADE SAO FRANCISCO DE CAJAZEIRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3251, 3551, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3252, 3552, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE TEIXEIRA DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3253, 3553, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE VALENA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3254, 3554, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE JACOBINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3255, 3555, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3256, 3556, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3257, 3557, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE IRECE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3258, 3558, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE IPIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3259, 3559, 'FACULDADE DE PORANGATU', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3260, 3560, 'FACULDADE DE CINCIAS DA SADE DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3261, 3561, 'FACULDADE SANTA RITA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3262, 3562, 'FACULDADE DE ODONTOLOGIA RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3263, 3563, 'FACULDADE DE ODONTOLOGIA RIO BRANCO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3264, 3564, 'FACULDADE MORENENSE DE EDUCAO-FAM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3265, 3565, 'FACULDADE MORENENSE DE EDUCAO-FAM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3266, 3566, 'FACULDADE PAULO FREIRE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3267, 3567, 'FMV - FACULDADE METROPOLITANA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3268, 3568, 'FACULDADE DE DESENVOLVIMENTO E INTEGRAO REGIONAL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3269, 3569, 'INSTITUTO SUPERIOR DE EDUCAO DE MANHUAU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3270, 3570, 'FACULDADE DE CINCIAS E EDUCAO DE SO SIMO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3271, 3571, 'FACULDADE DOS INCONFIDENTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3272, 3572, 'FACULDADE DE DIREITO DA ACADEMIA BRASILEIRA DE CINCIAS JURDICAS E SOCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3273, 3573, 'FACULDADE TEOLGICA BATISTA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3274, 3574, 'UNIO DE FACULDADES DE PARASO - UNIFAP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3275, 3575, 'FACULDADE ATIVA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3276, 3576, 'FACULDADE DE ENSINO SUPERIOR DO LITORAL SUL - FASUL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3277, 3577, 'FACULDADE DE ALTOS ESTUDOS DA BAHIA - FAE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3278, 3578, 'FACULDADE DE CIENCIAS FARMACEUTICAS DO PANTANAL', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3279, 3579, 'INSTITUTO LUTERANO DE EDUCAO SUPERIOR DO PARECIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3280, 3580, 'FACULDADE DE EDUCAO, CINCIAS SOCIAIS E DA SADE - SESI/TO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3281, 3581, 'FACULDADE DE ENSINO TECNOLGICO FILADLFIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3282, 3582, 'FACULDADE PORTO CALVO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3283, 3583, 'ESCOLAS SUPERIORES DE ADMINISTRAO, GEOGRAFIA E CURSO NORMAL SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3284, 3584, 'INSTITUTO SUPERIOR DE EDUCAO SANTA CRUZ', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3285, 3585, 'FACULDADE SANTA CRUZ', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3286, 3586, 'FACULDADE OXFORD DO BRASIL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3287, 3587, 'FACULDADE DIOCESANA SO JOS', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3288, 3588, 'FACULDADE DOM PEDRO II', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3289, 3589, 'FACULDADE TEOREMA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3290, 3590, 'FACULDADE DE ENFERMAGEM SO VICENTE DE PAULA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3291, 3591, 'INSTITUTO SUPERIOR DE EDUCAO DE MACAPARANA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3292, 3593, 'FACULDADE DE CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3293, 3594, 'FACULDADE DE CINCIA, TECNOLOGIA E EDUCAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3294, 3595, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTA MARIA DA VITRIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3295, 3596, 'FACULDADE MONTSERRAT', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3296, 3597, 'FACULDADE DE ENSINO SUPERIOR DE SANTA CRUZ DO CAPIBARIBE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3297, 3598, 'FACULDADE DE IRATI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3298, 3599, 'FACULDADE DE ITAPEMA - FAI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3299, 3600, 'FACULDADE DO LITORAL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3300, 3601, 'FACULDADE DE TAPEJARA - FATAP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3301, 3602, 'FACULDADES INTEGRADAS DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3302, 3603, 'FACULDADES INTEGRADAS TORRICELLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3303, 3604, 'INSTITUTO SUPERIOR DE EDUCAO DE CARIACICA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3304, 3605, 'FACULDADE DE CINCIAS, COMUNICAES E TECNOLOGIAS DE PESQUEIRA - FACCIP', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3305, 3606, 'INSTITUTO SUPERIOR DE EDUCAO PRESBITERIANO VALE DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3306, 3607, 'ESCOLA SUPERIOR ASSOCIADA DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3307, 3608, 'INSTITUTO SUPERIOR DE EDUCAO DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3308, 3609, 'FACULDADES INTEGRADAS IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3309, 3610, 'FACULDADES INTEGRADAS UNICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3310, 3611, 'FACULDADES INTEGRADAS DA UNIO DE ENSINO SUPERIOR CERTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3311, 3612, 'FACULDADE ANHANGUERA DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3312, 3613, 'FACULDADES INTEGRADAS IESGO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3313, 3614, 'ESCOLA SUPERIOR DE CINCIAS SOCIAIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3314, 3615, 'FACULDADE BOA VIAGEM - INSTITUTO MATERNO INFANTIL DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3315, 3616, 'FACULDADES PHD', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3316, 3617, 'FACULDADE DE CINCIAS HUMANAS E EXATAS DO SERTO DO SO FRANCISCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3317, 3618, 'FACULDADE MARIO SCHENBERG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3318, 3619, 'UNESC - UNIO DAS ESCOLAS SUPERIORES DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3319, 3620, 'ESCOLA INTERNACIONAL DE ADMINISTRAO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3320, 3621, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3321, 3622, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3322, 3623, 'FACULDADE DE CINCIAS DA BAHIA - FACIBA (NOME ALTERADO POR SOLICITAO DO MEC)', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3323, 3624, 'PUC MINAS ARCOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3324, 3625, 'FACULDADE CATLICA NOSSA SENHORA DAS VITRIAS', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3325, 3626, 'FACULDADE BRASILEIRA DE EDUCAO E NEGCIOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3326, 3627, 'FACULDADE DE TECNOLOGIA BARO DO RIO BRANCO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3327, 3628, 'FACULDADADE TEOLGICA REFORMADA - FTR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3328, 3629, 'FACULDADADE TEOLGICA REFORMADA - FTR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3329, 3630, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE PAULO AFONSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3330, 3631, 'FACULDADE DAMAS DA INSTRUO CRIST', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3331, 3632, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ITABERABA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3332, 3633, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE CAMPO FORMOSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3333, 3634, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BOM JESUS DA LAPA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3334, 3635, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SANTA MARIA DA VITRIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3335, 3636, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SENHOR DO BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3336, 3637, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3337, 3638, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3338, 3639, 'FACULDADE DE DIREITO DO INSTITUTO DE ENSINO SUPERIOR DO CIRCUITO DO OURO - FDINESO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3339, 3640, 'FACULDADE DE CINCIAS ECONMICAS DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3340, 3641, 'CENTRO UNIVERSITRIO DA FUNDAO EDUCACIONAL DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3341, 3642, 'FACULDADE INTEGRADA DE PERNAMBUCO - SURUBIM (FACIPE - SURUBIM)', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3342, 3643, 'FACULDADE CATLICA NOSSA SENHORA DAS NEVES', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3343, 3644, 'FACULDADE CATLICA SANTA TERESINHA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3344, 3645, 'FACULDADE CATLICA SANTA TERESINHA (CADASTRADA INDEVIDAMENTE)', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3345, 3646, 'FACULDADE DE TECNOLOGIA DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3346, 3647, 'FACULDADE DE TECNOLOGIA MARISTA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3347, 3648, 'FACULDADE CENTRO AMRICA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3348, 3649, 'FACULDADE CIDADE VERDE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3349, 3650, 'INSTITUTO SUPERIOR DE EDUCAAO GREGORIANO - ISEG', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3350, 3651, 'FACULDADE DAS GUAS QUENTES - FAQ', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3351, 3652, 'FACULDADE PRESBITERIANA SAMUEL GRAHAM', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3352, 3653, 'FACULDADE PRESBITERIANA SAMUEL GRAHAM', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3353, 3654, 'FACULDADE DE CINCIAS COMUNICAES E TECNOLOGIAS DE FLORESTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3354, 3655, 'FACULDADE DE JANABA - FAJAN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3355, 3656, 'FACULDADE NOVA TRINDADE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3356, 3657, 'FACULDADE DE COMPUTAO DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3357, 3658, 'FACULDADE UIRAPURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3358, 3659, 'FACULDADE DE CINCIAS COMUNICAO E TECNOLOGIA DE SALGUEIRO-FACTS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3359, 3660, 'INSTITUTO SUPERIOR DE EDUCAO DE SALGUEIRO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3360, 3662, 'FACULDADE EVANGLICA LOGOS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3361, 3663, 'FACULDADE EVANGLICA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3362, 3664, 'INSTITUTO SUPERIOR DE EDUCAO DE VARGEM GRANDE DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3363, 3665, 'FACULDADE DE JOAABA - FJ', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3364, 3666, 'FACULDADE DE ADMINISTRAO DA AERONUTCA', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3365, 3667, 'FACULDADE FILADLFIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3366, 3668, 'FACULDADE DE ENFERMAGEM E ADMINISTRAO DE JATA - FEAJ', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3367, 3669, 'FACULDADE REGIONAL DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3368, 3670, 'FACULDADE DE CRICIUMA - FACRI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3369, 3671, 'FACULDADE INTERDISCIPLINAR DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3370, 3672, 'FACULDADE DE CAMPOS NOVOS - FACAN', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3371, 3673, 'FACULDADE PREMIER', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3372, 3674, 'INSTITUTO NORMAL SUPERIOR - FBV', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3373, 3675, 'SINAL - FACULDADE DE TEOLOGIA E FILOSOFIA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3374, 3676, 'FACULDADE DE TECNOLOGIA DO VALE DO RIBEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3375, 3677, 'FACULDADE DE TECNOLOGIA DE ALTA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3376, 3678, 'FACULDADE DE TECNOLOGIA DO VALE DO ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3377, 3679, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3378, 3680, 'FACULDADE DE TECNOLOGIA DARCY RIBEIRO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3379, 3681, 'FACULDADES DE GARANHUNS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3380, 3682, 'INSTITUTO SUPERIOR DE EDUCAO DO MUNICPIO DE ITAPERUNA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3381, 3683, 'FACULDADE UNILAGOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3382, 3684, 'FUNDAO DE ENSINO SUPERIOR DE CLEVELNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3383, 3685, 'FACULDADE DA POLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3384, 3686, 'FADITU - FACULDADE DE DIREITO DE IT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3385, 3687, 'FACULDADES INTEGRADAS DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3386, 3688, 'FACULDADES INTEGRADAS DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3387, 3689, 'FACULDADE PEDRO JULIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3388, 3690, 'FACULDADE PEDRO II', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3389, 3691, 'FACULDADE DE TECNOLOGIA TUPY DE SO BENTO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3390, 3692, 'FACULDADE DE TECNOLOGIA IPEP DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3391, 3693, 'FACULDADE DE TECNOLOGIA IPEP DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3392, 3694, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3393, 3695, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE OURINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3394, 3696, 'FACULDADE DE TECNOLOGIA DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3395, 3697, 'FACULDADE DE TECNOLOGIA SAINT PASTOUS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3396, 3698, 'PORTAL FACULDADES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3397, 3699, 'FACULDADE PORTAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3398, 3700, 'FACULDADE DE CINCIAS JURDICAS DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3399, 3701, 'FACULDADE DE CINCIAS GERENCIAIS DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3400, 3702, 'FACULDADES ELO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3401, 3703, 'INSTITUTO SUPERIOR DE ADMINISTRAO E NEGOCIOS DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3402, 3704, 'FACULDADE DO ALTO PARNABA - FAP', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3403, 3705, 'FACULDADE KHALIL LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3404, 3706, 'FACULDADE REGIONAL DE POJUCA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3405, 3707, 'FACULDADE INTEGRADAS DO MORENO - FIAM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3406, 3708, 'FACULDADE INTEGRAL DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3407, 3709, 'INSTUTO DE ENSINO SUPERIOR SO LUCAS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3408, 3710, 'ESCOLA SUPERIOR NACIONAL DE SEGUROS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3409, 3711, 'FACULDADE CENTRAL DE CRISTALINA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3410, 3712, 'FACULDADE VITRIA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3411, 3713, 'INSTITUTO DE TEOLOGIA E PASTORAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3412, 3714, 'INSTITUTO TATUIANO DE ENSINO SUPERIOR - ITES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3413, 3715, 'FACULDADE METROPOLITANA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3414, 3716, 'FACULDADE CINCIAS DA VIDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3415, 3717, 'FACULDADE CULTURAL ANJAGUN', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3416, 3718, 'FACULDADE DE CINCIAS HUMANAS JLIO GOMES', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3417, 3719, 'FACULDADE DE CORAO DE JESUS-FADECOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3418, 3720, 'FACULDADE PORTO REAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3419, 3721, 'FACULDADE OLIVEIRA TELLES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3420, 3722, 'FACULDADE DE CINCIAS MDICAS INTEGRADAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3421, 3723, 'FACULDADE NACIONAL POLICURSOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3422, 3724, 'FACULDADE SO JOS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3423, 3725, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ITAMARAJU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3424, 3726, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3425, 3727, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE EUCLIDES DA CUNHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3426, 3728, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3427, 3729, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE GUANAMBI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3428, 3730, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE CAMAARI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3429, 3731, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BRUMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3430, 3732, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE VITRIA DA CONQUISTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3431, 3733, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE JUAZEIRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3432, 3734, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3433, 3735, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3434, 3736, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE PILO ARCADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3435, 3737, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE PORTO SEGURO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3436, 3738, 'FACULDADE DE EDUCAO, CINCIAS E LETRAS DO NOROESTE DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3437, 3739, 'FACULDADE ASSOCIAO HOSPITALAR DE ILHA SOLTEIRA - FACISA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3438, 3740, 'FACULDADE DE MEDICINA DE BOTUCATU', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3439, 3741, 'FACULDADE DE EDUCAO DE BACABAL - FEBAC', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3440, 3742, 'FACULDADES DE CINCIAS E TECNOLOGIA DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3441, 3743, 'FACULDADE DE TECNOLOGIA SO FRANCISCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3442, 3744, 'FACULDADE CETEP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3443, 3745, 'INSTITUTO SUPERIOR SEJA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3444, 3746, 'FACULDADE PAULISTA DE PESQUISA E ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3445, 3747, 'FACULDADE METROPOLITANA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3446, 3748, 'FACULDADE DE TECNOLOGIA THEREZA PORTO MARQUES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3447, 3749, 'FACULDADE DE TECNOLOGIA BRASLIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3448, 3750, 'FACULDADE DE TECNOLOGIA DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3449, 3751, 'FACULDADE DE TECNOLOGIA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3450, 3752, 'FACULDADE DE TECNOLOGIA CONTEC', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3451, 3753, 'FACULDADES INTEGRADAS DOM PEDRO II', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3452, 3754, 'FACULDADES INTEGRADAS ADVENTISTAS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3453, 3755, 'FACULDADE EM AUTOCONHECIMENTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3454, 3756, 'FACULDADE DE ALMENARA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3455, 3757, 'FACULDADE SERRA DA MESA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3456, 3758, 'INSTITUTO SUPERIOR TUPY DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3457, 3759, 'INSTITUTO SUPERIOR TUPY DE SO BENTO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3458, 3760, 'FACULDADE OMNI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3459, 3761, 'FACULDADE MONSENHOR JOS SINFRNIO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3460, 3762, 'FACULDADE DE TECNOLOGIA MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3461, 3763, 'FACULDADE DO INTERIOR PAULISTA DE TANABI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3462, 3764, 'CENTRO DE EDUCAO SUPERIOR DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3463, 3765, 'FACULDADE SANTO AGOSTINHO DE SANTA VITRIA - FASAV', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3464, 3766, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO DE SANTA VITRIA - ISAV', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3465, 3767, 'FACULDADE DE EDUCAAO CIENCIAS E TECNOLOGIA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3466, 3768, 'FACULDADE IBGEN - INSTITUTO BRASILEIRO DE GESTO DE NEGCIOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3467, 3769, 'FACULDADE MADRE TEREZA', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3468, 3770, 'FACULDADE TEOLGICA BATISTA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3469, 3771, 'FACULDADE DE TURISMO E ADMINISTRAO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3470, 3772, 'FACULDADE DE TECNOLOGIA PASTOR DOHMS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3471, 3773, 'FACULDADE PAULIPOLITANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3472, 3774, 'FACULDADE SO TOMAZ DE AQUINO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3473, 3775, 'INSTITUTO UVB.BR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3474, 3776, 'INSTITUTO DE ENSINO SUPERIOR DE MATO GROSSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3475, 3777, 'INSTITUTO DE ENSINO SUPERIOR DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3476, 3778, 'INSTITUTO ARACAJU DE ENSINO E CULTURA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3477, 3779, 'FACULDADE DE TECNOLOGIA RADIAL SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3478, 3780, 'FACULDADE DE TECNOLOGIA IMPACTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3479, 3781, 'FACULDADE DE TECNOLOGIA DE JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3480, 3782, 'FACULDADE DE TECNOLOGIA CACHOEIRO DE ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3481, 3783, 'INSTITUTO PARAENSE DE ENSINO E CULTURA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3482, 3784, 'INSTITUTO DE ENSINO SUPERIOR DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3483, 3785, 'INSTITUTO MARANHENSE DE ENSINO E CULTURA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3484, 3786, 'INSTITUTO MINAS GERAIS DE ENSINO E CULTURA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3485, 3787, 'INSTITUTO MACAP DE ENSINO SUPERIOR', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3486, 3788, 'INSTITUTO JUIZ DE FORA DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3487, 3789, 'FACULDADE BETEL DE GOIANSIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3488, 3790, 'FACULDADE DE TECNOLOGIA ENSITEC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3489, 3791, 'FACULDADE DE MEDICINA DO VALE DO AO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3490, 3792, 'FACULDADE DE TECNOLOGIA DO ITAJA-MIRIM', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3491, 3793, 'FACULDADE FRUTAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3492, 3794, 'FACULDADE DE TECNOLOGIA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3493, 3795, 'CENTRO DE EDUCAO SUPERIOR TECNOLGICA DA TERRA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3494, 3796, 'CENTRO DE ENSINO SUPERIOR DO ESTADO DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3495, 3797, 'FACULDADE GUAIRAC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3496, 3798, 'FACULDADE DE TEOLOGIA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3497, 3799, 'INSTITUTO SUPERIOR DE EDUCAO E CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3498, 3800, 'INSTITUTO DE EDUCAO E CULTURA VALE DO IPANEMA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3499, 3801, 'CENTRO UNIVERSIT[ARIO ZEN', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3500, 3802, 'CENTRO DE EDUCAO TECNOLGICA DO INTERIOR PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3501, 3803, 'FACULDADE JAUENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3502, 3804, 'FACULDADE DE TECNOLOGIA SENAC DO RIO GRANDE DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3503, 3805, 'FACULDADE DE TECNOLOGIA DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3504, 3806, 'FACULDADE DE TECNOLOGIA DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3505, 3807, 'FACULDADE DE TECNOLOGIA IAPEC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3506, 3808, 'FACULDADE DE ENSINO FACTUAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3507, 3809, 'INSTITUTO SUPERIOR DE EDUCAO TEOLOGICA DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3508, 3810, 'NCLEO DE CINCIAS FIORAVANTI DI PIERO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3509, 3811, 'CENTRO DE ESTUDOS EM NEGCIOS INTERNACIONAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3510, 3812, 'FACULDADES PARA O DESENVOLVIMENTO SUSTENTVEL DO SUL DA BAHIA - FADESB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3511, 3813, 'FATECE - FACULDADES DE TECNOLOGIA CINCIAS E EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3512, 3814, 'FACULDADE PLANALTO DO BRASIL - FPB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3513, 3815, 'FACULDADE DE DIREITO DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3514, 3816, 'FACULDADE SANTA MARIA GORETTI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3515, 3817, 'FACULDADE METROPOLITANA DA PARAIBA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3516, 3818, 'FACULDADES EQUIPE LTDA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3517, 3819, 'FACULDADE DE ADMINISTRAO DE EMPRESAS E GESTO PBLICA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3518, 3820, 'FACULDADE PETRNIO PORTELA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3519, 3821, 'FACULDADE SO BOAVENTURA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3520, 3822, 'INSTITUTO DE EDUCAO SUPERIOR DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3521, 3823, 'INSTITUTO DE EDUCAO SUPERIOR DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3522, 3824, 'FACULDADE JOS CNDIDO DE MELO CARVALHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3523, 3825, 'FACULDADE CATLICA RIO-PRETENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3524, 3826, 'FACULDADE VASCO DA GAMA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3525, 3827, 'ESCOLA SUPERIOR DE CIENCIAS COMERCIAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3526, 3828, 'INSTITUTO SUPERIOR DE EDUCAO DE TUP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3527, 3829, 'CENTRO DE EDUCAO SUPERIOR TECNOLGICA DA TERRA PAULISTA - CETERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3528, 3830, 'INSTITUTO CENTRO DE ENSINO TECNOLGICO - SOBRAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3529, 3831, 'FACULDADE DE CINCIAS CONTBEIS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3530, 3832, 'FACULDADE DE ZOOTECNIA', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3531, 3833, 'FACULDADE DE ENGENHARIA FLORESTAL', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3532, 3834, 'FACULDADE SANTA LCIA - PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3533, 3835, 'UNIVERSIDADE VIRTUAL DO ESTADO DO MARANHO', 2, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3534, 3836, 'UNIVERSIDADE PAULISTA-UNIP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3535, 3837, 'FACULDADE DE TECNOLOGIA MDULO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3536, 3838, 'FACULDADE DE TECNOLOGIA DO UNIUOL', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3537, 3839, 'FACULDADE DE TECNOLOGIA NOVO RUMO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3538, 3840, 'FACULDADE DE TECNOLOGIA E PROFISSIONAL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3539, 3841, 'FACULDADE PITGORAS DE ADMINISTRAO SUPERIOR DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3540, 3842, 'FACULDADE METROPOLITANA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3541, 3843, 'FACULDADE CANDIDO MENDES DE ARARUAMA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3542, 3844, 'ESCOLA SUPERIOR DE CASTANHAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3543, 3845, 'FACULDADE TAQUARITUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3544, 3846, 'FACULDADE DE CINCIAS E CULTURA DA LIBERDADE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3545, 3847, 'FACULDADE BAIANA DE DIREITO E GESTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3546, 3848, 'FACULDADE GABRIELA GONALVES', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3547, 3849, 'FUNDAO UNIVERSIDADE FEDERAL DO TOCANTINS', 1, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3548, 3850, 'FACULDADE CONTEMPORNEA - UNC-SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3549, 3851, 'FACULDADE DO RECNCAVO - UNR-CRUZ DAS ALMAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3550, 3852, 'FACULDADE DO RECNCAVO - UNR-CONCEIO DO ALMEIDA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3551, 3853, 'FACULDADE MAURCIO DE NASSAU DE NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3552, 3854, 'FACULDADE DAS GUAS EMENDADAS - FAE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3553, 3855, 'FACULDADES INTERNACIONAIS SAN MARTIN DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3554, 3856, 'FACULDADE DE SANTO ANASTCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3555, 3857, 'FACULDADE GAUDIUM', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3556, 3858, 'FACULDADE TOBIAS BARRETO DE MENEZES-FATOB', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3557, 3859, 'INSTITUTO SUPERIOR DE EDUCAO TECNOLGICA DO NORTE FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3558, 3860, 'FACULDADE TRIUNFO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3559, 3861, 'FACULDADE DE TECNOLOGIA E NEGCIOS CONTEMPORNEO - FATEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3560, 3862, 'FACULDADE LUCIANO FEIJO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3561, 3863, 'FACULDADE COOPERATIVA DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3562, 3864, 'FACULDADE REGIONAL DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3563, 3865, 'FACULDADES INTEGRADAS PADRE HUMBERTO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3564, 3866, 'FACULDADE BRASILEIRA DE EDUCAO E CULTURA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3565, 3867, 'FACULDADE MAU DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3566, 3868, 'INSTITUTO DE EDUCAO SUPERIOR DO ALTO PARANABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3567, 3869, 'INSTITUTO FLORENCE DE ENSINO SUPERIOR', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3568, 3870, 'INSTITUTO DE ESTUDOS DE NEGCIOS INTERNACIONAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3569, 3871, 'ESCOLA DE ADMINISTRAO FAZENDRIA', 1, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3570, 3872, 'FACULDADE DE TECNOLOGIA SO CARLOS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3571, 3873, 'FACULDADE DE TECNOLOGIA DE BRUMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3572, 3874, 'ESCOLA SUPERIOR PROFESSOR PAULO MARTINS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3573, 3875, 'CENTRO UNIVERSITRIO DA FUNDAO EDUCACIONAL GUAXUP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3574, 3876, 'INSTITUTO A VEZ DO MESTRE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3575, 3877, 'FACULDADE BRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3576, 3878, 'FACULDADE DECISION DE NEGCIOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3577, 3879, 'FACULDADE MAURCIO DE NASSAU DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3578, 3880, 'INSTITUTO SOCIAL DE EDUCAO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3579, 3881, 'FACULDADE DE INTEGRAO DO SERTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3580, 3882, 'INSTITUTO DE ENSINO SUPERIOR DE FORMAO PROFISSIONAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3581, 3883, 'FACULDADE EVANGLICA LOGOS - FAEL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3582, 3884, 'CESB - CENTRO DE EDUCAO SUPERIOR DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3583, 3885, 'FACULDADES INTEGRADAS DA TERRA PAULISTA - FATERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3584, 3886, 'FACULDADE GUA BOA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3585, 3887, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3586, 3888, 'ESCOLA SUPERIOR DE ADMINISTRAO E NEGCIOS DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3587, 3889, 'FACULDADE DE IGARAPAVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3588, 3890, 'FACULDADE MARQUES GUIMARES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3589, 3891, 'SOCIEDADE EDUCACIONAL ALBERTI TOLENTINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3590, 3892, 'FACULDADE DE CINCIAS SOCIAIS J.G. MELO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3591, 3894, 'UNIESP UNIO DAS INSTITUIES EDUCACIONAIS DO ESTADO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3592, 3895, 'INSTITUTO DE EDUCAO SUPERIOR ALBERTI TOLENTINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3593, 3896, 'FACULDADE MUNDIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3594, 3897, 'FACULDADE BUSCA VIDA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3595, 3898, 'SLCSA FACULDADE SANTA INS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3596, 3899, 'FACULDADE DE RIBEIRAO DAS NEVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3597, 3901, 'FACULDADES PROEDUC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3598, 3902, 'FUNDAO ESCOLA DO MINISTRIO PBLICO DO ESTADO DO PARAN - FEMPAR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3599, 3903, 'INFAMILIA - INSTITUTO BRASILEIRO DE SADE DA FAMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3600, 3904, 'FACULDADE DE CINCIAS GERENCIAIS DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3601, 3905, 'FACULDADE DE DIREITO DOCTUM DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3602, 3906, 'FACULDADE DE CINCIAS AGRRIAS E DA TERRA DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3603, 3907, 'FACULDADE DE SAPIRANGA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3604, 3908, 'FACOM - FACULDADE COMUNITRIA DO BRASIL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3605, 3909, 'ISTITUTO DE ENSINO SUPERIOR PARAENSE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3606, 3910, 'INSTITUTO SUPERIOR DE EDUCAO DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3607, 3911, 'FACULDADE DE TECNOLOGIA OXFORD DO BRASIL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3608, 3912, 'FACULDADE SUDOESTE PAULISTA - BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3609, 3913, 'FACULDADE SUDOESTE PAULISTA - TAQUARITUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3610, 3914, 'INSTITUTO SUPERIOR DE EDUCAO DO VALE DO CAPIBARIBE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3611, 3915, 'INSTITUTO SUPERIOR DE EDUCAO CARLOS JOEL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3612, 3916, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DO PIAUI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3613, 3917, 'FACULDADE DE MERCADO AMPLO - FAMA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3614, 3918, 'FACULDADE INTEGRADA EM CINCIAS HUMANAS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3615, 3919, 'FACULDADE NOSSA SENHORA DO BOM CONSELHO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3616, 3920, 'FACULDADE DE TECNOLOGIA SENAI ROBERTO MANGE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3617, 3921, 'FACULDADE ARNALDO HORCIO FERREIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3618, 3922, 'FACULDADE ARNALDO HORCIO FERREIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3619, 3923, 'FACULDADE SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3620, 3924, 'FACULDADE DE IBIRACU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3621, 3925, 'FACULDADE DE TEOLOGIA DO BRASIL - FATEB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3622, 3926, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3623, 3927, 'FACULDADE DE CCERES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3624, 3928, 'FAESB - FACULDADE DE ENSINO SUPERIOR DO BRASIL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3625, 3929, 'FACULDADES UNIDAS DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3626, 3930, 'INSTITUTO DE EDUCAO SUPERIOR RAIMUNDO S', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3627, 3931, 'FACULDADE PRESBITERIANA ARMSTRONG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3628, 3932, 'FACULDADE DE EDUCAO E TECNOLOGIA DE ITANHM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3629, 3933, 'FACULDADE MTODO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3630, 3934, 'FACULDADE DA SADE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3631, 3935, 'FACULDADE DE EDUCAO TEOLOGICA DO DISTRITO FEDERAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3632, 3936, 'FACULDADE ANHANGUERA DE LIMEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3633, 3937, 'FACULDADE ANHAGUERA DE INDAIATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3634, 3938, 'FACULDADE DO NORTE DO MATO GROSSO DO SUL FANOR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3635, 3939, 'FACULDADE ALIANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3636, 3940, 'FACULDADE DE ENSINO SUPERIOR SANTA BARBARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3637, 3941, 'FACULDADE COMUNITRIA DE SANTA BRBARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3638, 3942, 'FACULDADE COMUNITRIA DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3639, 3943, 'FASC-TB FACULDADES ASSOCIADAS DE SC, DE TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3640, 3944, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3641, 3945, 'INSTITUTO DE EDUCAO EXECUTIVA CATHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3642, 3946, 'FACULDADE DE TECNOLOGIA SENAC TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3643, 3947, 'FACULDADE DE TECNOLOGIA SENAC CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3644, 3948, 'FACULDADE DE TECNOLOGIA SENAC BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3645, 3949, 'CENTRO DE EDUCAO SUPERIOR TECNOLGICA DA TERRA PAULISTA - CETERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3646, 3950, 'CENTRO DE CINCIAS ETECNOLOGIA DETERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3647, 3951, 'FACULDADE DE TECNOLOGIA LUIZ ADELAR SCHEUER', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3648, 3952, 'FACULDADE VILAVELHENSE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3649, 3953, 'FACULDADE DE ODONTOLOGIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3650, 3954, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS DE OLIVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3651, 3955, 'FACULDADES INTEGRADAS DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3652, 3956, 'ASSOCIAO EDUCACIONAL CENTRAL DE CRISTALINA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3653, 3957, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3654, 3958, 'FACULDADE TECNOLOGICA DE MARILIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3655, 3959, 'FACULDADE TECNOLOGICA AMRICA DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3656, 3960, 'FACULDADE TECNOLOGICA DE BIRIGUI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3657, 3961, 'FACULDADE DE TECNOLOGIA SANTA RITA DE CSSIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3658, 3962, 'FACULDADE DE TECNOLOGIA SENAI CIMATEC', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3659, 3963, 'INSTITUTO SUPERIOR DE EDUCAO CARLOS CHAGAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3660, 3964, 'FACULDADE DE TECNOLOGIA PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3661, 3965, 'FACULDADE DE TECNOLOGIA ENG. MARCELO SILVA GUIMARES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3662, 3966, 'CENTRO UNIVERSITRIO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3663, 3967, 'INSTITUTO SUPERIOR DE EDUCAO DE RORAIMA', 2, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3664, 3968, 'INSTITUTO SUPERIOR DE EDUCAO DE RORAINPOLIS', 2, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3665, 3969, 'INSTITUTO SUPERIOR DE SEGURANA E CIDADANIA DE RORAIMA', 2, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3666, 3970, 'INSTITUTO SUPERIOR DE EDUCAO DE PARAISPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3667, 3971, 'UNIO EDUCACIONAL DE PORTO NACIONAL - UNIPORTO', 3, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3668, 3972, 'CENTRO SUPERIOR DE ENSINO E PESQUISA DE MACHADO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3669, 3973, 'FACULDADE DE TECNOLOGIA BANDEIRANTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3670, 3974, 'UNIVERSIDADE DE RIO VERDE', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3671, 3975, 'FACULDADE SO FRANCISCO DE PIUMHI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3672, 3976, 'INSTITUTO SUPERIOR DE CINCIAS HUMANAS E SOCIAIS APLICADAS DE ABAET', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3673, 3977, 'FACULDADE DE TECNOLOGIA DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3674, 3978, 'FACULDADE DE TECNOLOGIA PENTGONO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3675, 3979, 'FACULDADE DE TECNOLOGIA LICEU NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3676, 3980, 'FACULDADE DE TECNOLOGIA CENACAP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3677, 3981, 'FACULDADE DE TECNOLOGIA INTEGRAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3678, 3982, 'FACULDADE DE TECNOLOGIA FAMEG - FAMETEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3679, 3983, 'CENTRO UNIVERSITRIO DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3680, 3984, 'FUNDAO UNIVERSIDADE FEDERAL DO VALE DO SO FRANCISCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3681, 3985, 'CENTRO UNIVERSITRIO SENAC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3682, 3986, 'INSTITUTO SUPERIOR DE EDUCAO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3683, 3987, 'FACULDADE UNIO DE GOYAZES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3684, 3988, 'FACULDADE UNIO DE GOYAZES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3685, 3989, 'FACULDADE DE TECNOLOGIA DE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3686, 3990, 'FACULDADE DE TECNOLOGIA ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3687, 3991, 'FACULDADE DE TECNOLOGIA SO MATEUS', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3688, 3992, 'FACULDADE ILAPE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3689, 3993, 'FACULDADE DE TECNOLOGIA CETEP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3690, 3994, 'FACULDADE DE TECNOLOGIA LATINO AMERICANO DE ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3691, 3995, 'FACULDADE EVANGLICA CRISTO REI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3692, 3996, 'FACULDADE SENAC PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3693, 3997, 'FACULDADES DE JI-PARAN', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3694, 3998, 'FACULDADE DE TECNOLOGIA INFNET RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3695, 3999, 'CENTRO DE ENSINO SUPERIOR TECNOLGICO DO INTERIOR PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3696, 4000, 'FACULDADE DE ENSINO SUPERIOR DO INTERIOR PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3697, 4001, 'FACULDADE DE ENSINO SUPERIOR DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3698, 4002, 'INSTITUTO DE ENSINO SUPERIOR DA PARAIBA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3699, 4003, 'FACULDADE CENTRO OESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3700, 4004, 'FACULDADE CENECISTA DE ITUBER', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3701, 4005, 'FACULDADE CENECISTA DE SENHOR DO BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3702, 4006, 'FACULDADE DE TECNOLOGIA SENAC PELOTAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3703, 4007, 'FATECE - FACULDADE DE TECNOLOGIA, CINCIAS E EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3704, 4008, 'FACULDADE DE TECNOLOGIA SENAC PASSO FUNDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3705, 4009, 'FACULDADE DE TECNOLOGIA RADIAL CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3706, 4010, 'CENTRO UNIVERSITRIO METODISTA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3707, 4011, 'UNI- DORINHA FACULDADE DE CINCIAS E TECNOLOGIA DE DORINHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3708, 4012, 'UNI-METROPOLITANA; FACULDADES DE CINCIAS HUMANAS E DE BIOTECNOLOGIA DA SADE', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3709, 4013, 'FACULDADE ANHANGUERA DE RIO CLARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3710, 4014, 'FACULDADE ASSOCIADA PAULISTA - FAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3711, 4015, 'FACULDADE DE TECNOLOGIA IBTA - RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3712, 4016, 'INSTITUTO NACIONAL DE EDUCAO DE SURDOS', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3713, 4017, 'CENTRO UNIVERSITRIO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3714, 4018, 'FACULDADE GAT DE GESTAO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3715, 4019, 'CENTRO DE EDUCAO TECNOLOGIA RUI BARBOSA - CETERB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3716, 4020, 'FACULDADE DE TECNOLOGIA DE BOTUCATU', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3717, 4021, 'FACULDADE DE TECNOLOGIA DE GARA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3718, 4022, 'FACULDADE DE TECNOLOGIA DE JUNDIA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3719, 4023, 'FACULDADE DE TECNOLOGIA DE MAU', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3720, 4024, 'FACULDADE DE TECNOLOGIA DE MOCOCA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3721, 4025, 'FACULDADE DE TECNOLOGIA DE SO JOS DO RIO PRETO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3722, 4026, 'FACULDADE DE TECNOLOGIA ZONA LESTE', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3723, 4027, 'INSTITUTO SUPERIOR DE ENSINO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3724, 4028, 'FACULDADE DE ITAPECERICA DA SERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3725, 4029, 'FACULDADE POLITEC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3726, 4030, 'CENTRO UNIVERSITRIO FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3727, 4031, 'INSTITUTO DE ENSINO SUPERIOR PROFESSORA ALMEIDA (CESPMA)', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3728, 4032, 'FACULDADE DE CINCIAS E TECNOLOGIA DE PAULISTA- FACIT', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3729, 4033, 'FACULDADE DE TECNOLOGIA FABRAI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3730, 4034, 'ASSOCIAO EDUCACIONAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3731, 4035, 'FACULDADE MAU - FAMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3732, 4036, 'FACULDADE DE TECNOLOGIA DE CATALO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3733, 4037, 'FACULDADE DE TECNOLOGIA INTENSIVA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3734, 4038, 'FACULDADE DE TECNOLOGIA CONSULTIME', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3735, 4039, 'FACULDADE UNILIVRE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3736, 4040, 'ESCOLA AGROTCNICA FEDERAL DE UBERLNDIA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3737, 4041, 'FACULDADE DE IRAR - FAIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3738, 4042, 'FACULDADE DO MEIO AMBIENTE E DE TECNOLOGIA DE NEGOCIOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3739, 4043, 'FACULDADE TECNOLOGIA EDUVALE - AVAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3740, 4044, 'FACULDADE TECNOLOGIA EXPERT', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3741, 4045, 'FACULDADE TECNOLOGIA TUPY CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3742, 4046, 'ESCOLA FIEMG DE LDERES EMPRESARIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3743, 4047, 'FACULDADE TECNOLOGIA IBTA BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3744, 4048, 'FCC - FACULDADE CATLICA DO CARIRI', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3745, 4049, 'FACULDADE TEOLGICA DA ASSEMBLIA DE DEUS EM CURITIBA-FATADC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3746, 4050, 'FAESP -  FACULDADE DE ENSINO SUPERIOR E PROFISSIONALIZANTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3747, 4051, 'FACULDADE SILVIO ROMERO', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3748, 4052, 'INSTITUTO BONDESPACHENSE PRESIDENTE ANTONIO CARLOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3749, 4053, 'CENTRO DE EDUCAO SUPERIOR BARNABITA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3750, 4054, 'INSTITUTO UNIFICADO DE ENSINO SUPERIOR OBJETIVO - IUESO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3751, 4055, 'INSTITUTO BBLICO DAS ASSEMBLIAS DE DEUS DO ESTADO DO PARAN- IBADEP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3752, 4057, 'FACISA - FACULDADE DE CINCIA DA SADE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3753, 4058, 'FACULDADE IP', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3754, 4059, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3755, 4060, 'CENTRO DE EDUCAO TECNOLGICA CENECISTA DE RIO NEGRINHO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3756, 4061, 'FACULDADE DE TECNOLOGIA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3757, 4062, 'FACULDADE ATHENIENSSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3758, 4064, 'FACULDADE DE TECNOLOGIA FAMA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3759, 4065, 'FACULDADE DE TECNOLOGIA DO INSTITUTO BANDEIRANTE DE EDUCAO E CULTURA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3760, 4066, 'FACULDADE DE TECNOLOGIA NORTE FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3761, 4067, 'FACIT - FACULDADE INDEPENDENTE DE ITAPETINGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3762, 4068, 'INSTITUTO SUPERIOR DE EDUCAO DO ICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3763, 4069, 'FACULDADE HORIZONTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3764, 4070, 'ESCOLA AGROTCNICA FEDERAL DE SALINAS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3765, 4071, 'ESCOLA AGROTCNICA FEDERAL DE INCONFIDENTES', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3766, 4072, 'ESCOLA AGROTCNICA FEDERAL DE IGUATU', 1, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3767, 4073, 'FACULDADE DE TECNOLOGIA IPIRANGA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3768, 4074, 'FACULDADE DELTA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3769, 4076, 'FACULDADE DE TECNOLOGIA PREVE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3770, 4077, 'FACULDADE DE TECNOLOGIA DE GRAVATA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3771, 4078, 'FACULDADE METROPOLITANA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3772, 4079, 'FACULDADE TECNOLGICA INAP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3773, 4080, 'FACULDADE DE PRUDENTPOLIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3774, 4081, 'FATEG-FACULDADE DE TECNOLOGIA GALVO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3775, 4082, 'IBEC - INSTITUTO BRASILEIRO DE EDUCAO SUPERIOR CONTINUADA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3776, 4083, 'MATEC-CENTRO DE ENSINO TECNOLOGICO DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3777, 4084, 'INSTITUTO DE ENSINO SUPERIOR DOS MILITARES', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3778, 4085, 'FACULDADE ANCHIETA DE EDUCAO A DISTNCIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3779, 4086, 'FACULDADE DE TECNOLOGIA JARDIM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3780, 4087, 'FACULDADE DE EDUCAO TECNOLGICA - FET DA CDL DE SOBRAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3781, 4088, 'FACULDADE DE TECNOLOGIA DO INSTITUTO EDUCACIONAL PROFISSIONALIZANTE DE JALES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3782, 4089, 'FACULDADE DE SIDROLNDIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3783, 4090, 'FACULDADE DE ROSEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3784, 4091, 'FACULDADE DE TECNOLOGIA AD1', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3785, 4092, 'FACULDADE DE TECNOLOGIA PEDRO ROGRIO GARCIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3786, 4093, 'FACULDADE DE TECNOLOGIA DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3787, 4094, 'FACULDADE DE TECNOLOGIA IBRATEC DE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3788, 4095, 'FACULDADE DE TECNOLOGIA EQUIPE DARWIN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3789, 4096, 'FACULDADE DE TECNOLOGIA TECBRASIL - UNIDADE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3790, 4097, 'FACULDADE DE TECNOLOGIA TECBRASIL - UNIDADE BENTO GONALVES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3791, 4098, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE FARROUPILHA', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3792, 4099, 'ESCOLA AGROTCNICA FEDERAL DE BARBACENA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3793, 4100, 'FACULDADE DE TECNOLOGIA SENAI TALO BOLOGNA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3794, 4101, 'FACULDADE DE TECNOLOGIA SENAI DE DESENVOLVIMENTO GERENCIAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3795, 4102, 'FACULDADE DE TECNOLOGIA IBRATEC DE MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3796, 4103, 'FACULDADE METROPOLITANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3797, 4104, 'ESCOLA SUPERIOR DE ENGENHARIA E GESTO DE SO PAULO - ESEG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3798, 4105, 'FACULDADES COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3799, 4106, 'FAQ - FACULDADE QUINZE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3800, 4107, 'FACULDADE DE TECNOLOGIA SENAI PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3801, 4108, 'INSTITUTO CATLICO DE ESTUDOS SUPERIORES DO PIAU - ICESPI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3802, 4109, 'FACULDADE DE SADE E MEDICINA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3803, 4110, 'FACULDADE DE CINCIAS GERENCIAIS DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3804, 4111, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3805, 4112, 'FACULDADE TECNOLGICA FILADLFIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3806, 4113, 'FACULDADE DE CERES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3807, 4114, 'FACULDADE TEOLGICA CRIST DO BRASIL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3808, 4116, 'FACULDADE MAURICIO DE NASSAU JABOATO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3809, 4117, 'FACULDADE MAURCIO DE NASSAU MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3810, 4118, 'FACULDADE JOAQUIM NABUCO - PAULISTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3811, 4119, 'FACULDADE MAURCIO DE NASSAU GARANHUNS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3812, 4120, 'FACULDADE MAURCIO DE NASSAU CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3813, 4121, 'FACULDADE TOBIAS BARRETO', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3814, 4122, 'CENTRO DE EDUCAO TECNOCNOLGICA RUI BARBOSA - CETRB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3815, 4123, 'FACULDADE JATAIENSE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3816, 4124, 'FACULDADE DOM HEITOR SALES', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3817, 4125, 'FACULDADE BATISTA IDA NELSON', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3818, 4126, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS E DE TECNOLOGIAS DE AGUA BOA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3819, 4127, 'ISEF - INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE FARROUPILHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3820, 4128, 'INSTITUTO DE EDUCAO SUPERIOR DO PIAUI - IESPI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3821, 4129, 'FACULDADE JOS DE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3822, 4130, 'FACULDADE DE TECNOLOGIA DE CINCIAS HOLSTICAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3823, 4131, 'FACULDADE DO DELTA DO PARNABA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3824, 4132, 'FACULDADE DE COLORADO - FAC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3825, 4133, 'FACULDADE DE EDUCAO TECNOLGICA SANTA GEMA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3826, 4134, 'INEJ - INSTITUTO NACIONAL DE ESTUDOS JURDICOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3827, 4135, 'FACULDADE SANTA DOROTIA DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3828, 4136, 'FACULDADE CNDIDO RONDON DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3829, 4137, 'INSTITUTO EVANGLICO SUPERIOR DE EDUCAO CRISTO REI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3830, 4138, 'FACULDADE ANHANGUERA DE SANTA BRBARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3831, 4139, 'FACULDADE COMUNITRIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3832, 4140, 'FACULDADE COMUNITRIA DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3833, 4141, 'FACULDADE ANHANGUERA DE TAUBAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3834, 4142, 'FACULDADE UNIO DE EDUCADORES E ESTUDANTES DO ENSINO SUPERIOR DE BRASLIA - UNESB', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3835, 4143, 'FACULDADE EVANGLICA SHALOM', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3836, 4144, 'FACULDADE INTEGRADA GAMALIEL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3837, 4145, 'CENTRO NACIONAL DE EDUCAO A DISTNCIA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3838, 4146, 'FACULDADE DE CINCIAS JURDICAS DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3839, 4147, 'FACULDADE TEOLGICA DE UBERLANDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3840, 4148, 'FACULDADE DE TECNOLOGIA SENAI SO JOS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3841, 4149, 'FACULDADE DE TECNOLOGIA SENAI ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3842, 4150, 'FACULDADE DE TECNOLOGIA DE PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3843, 4151, 'FACULDADE BOAVENTURA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3844, 4152, 'FACULDADE MAURCIO DE NASSAU JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3845, 4153, 'FACULDADE JOAQUIM NABUCO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3846, 4154, 'FACULDADE MAURCIO DE NASSAU CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3847, 4155, 'FACULDADE JOAQUIM NABUCO CAMARAGIBE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3848, 4156, 'FACULDADE TECNOLGICA DE SOORETAMA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3849, 4157, 'FACULDADE METROPOLITANA DE RIO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3850, 4158, 'FACULDADE EVANGLICA DO MEARIM', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3851, 4159, 'FACULDADE PIRATININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3852, 4160, 'FACULDADE DE TECNOLOGIA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3853, 4161, 'INSTITUTO DE ENSINO SUPERIOR CAETANO VELOSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3854, 4162, 'FACULDADE DE TECNOLOGIA SENAC GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3855, 4163, 'CENTRO UNIVERSITRIO BARRIGA VERDE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3856, 4164, 'FACULDADE XODUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3857, 4165, 'FACULDADE POTNCIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3858, 4166, 'CENTRO DE ENSINO SUPERIOR DE UBERABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3859, 4167, 'INSTITUTO DE ENSINO SUPERIOR DA FUPESP', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3860, 4168, 'INSTITUTO DE ENSINO SUPERIOR DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3861, 4169, 'FACULDADE NOSSA CIDADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3862, 4170, 'FACULDADE INTEGRADA SO PEDRO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3863, 4171, 'ISAG - INSTITUTO SUPERIOR DE ADMINISTRAO E GESTO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3864, 4172, 'CENTRO DE ENSINO SUPERIOR DO SERVIDOR PUBLICO MARANHENSE CESPMA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3865, 4173, 'FACULDADE DE TECNOLOGIA PAULO FREIRE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3866, 4174, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE ENERGIA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3867, 4175, 'INSTITUTO UNIFICADO EUROPEU DO BRASIL IUNE-BRASIL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3868, 4176, 'FACULDADE DE MARILIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3869, 4177, 'FACULDADE DE TECNOLOGIA DE SANTA MARIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3870, 4178, 'FACULDADE EVILSIO FORMIGA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3871, 4179, 'FACULDADE NAZARENA DO BRASIL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3872, 4180, 'FACULDADE HERRERO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3873, 4182, 'FACULDADE PRESBITERIANA SIMONTON - IPES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3874, 4183, 'FACULDADE PRESBITERIANA SIMONTON DE SAPEZAL - IPES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3875, 4184, 'INSTITUTO SUPERIOR DE EDUCAO DE SERRANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3876, 4185, 'FACULDADE PERUIBE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3877, 4187, 'ISEFAJIPA - INSTITUTO SUPERIOR DE EDUCAO DE JI-PARAN', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3878, 4188, 'FACULDADE IAPEDEM/ANAMACO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3879, 4189, 'INSTITUTO DE EDUCAO SUPERIOR SO JUDAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3880, 4190, 'UNIFOS - UNIVERSO DE FORMAO TCNICA E SUPERIOR', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3881, 4191, 'INSTITUTO SUPERIOR METROPOLITANA - ISUME', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3882, 4192, 'FACULDADE METROPOLITANA DE TERESINA - FAMET', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3883, 4193, 'INSTITUTO SUPERIOR DE EDUCAO DO BRASIL - ISEB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3884, 4194, 'FACULDADE DO ALTO TIETE - FAAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3885, 4195, 'FACULDADE PROFETA ABRAO - FAPA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3886, 4196, 'INSTITUTO BRASILEIRO ACADMICO SOCIAL DE PESQUISAS E ENSINO/IBRASPE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3887, 4197, 'FACULDADE CERTO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3888, 4198, 'FACULDADE MINEIRENSE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3889, 4199, 'FACULDADE DE TECNOLOGIA ROGACIONISTA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3890, 4200, 'FACULDADE DE COMUNICAO SOCIAL DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3891, 4201, 'FACULDADE DE ENSINO SUPERIOR DO NORDESTE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3892, 4202, 'FACULDADE ALFA - FAAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3893, 4203, 'FACULDADE ABERTA DO BRASIL - UNIABRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3894, 4204, 'FACULDADE DE TECNOLOGIA INED - UNIDADE IPATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3895, 4205, 'ESCOLA SUPERIOR DO MINISTRIO PBLICO DA UNIO (ESMPU)', 1, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3896, 4206, 'INSTITUTO DE ENSINO SUPERIOR DE TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3897, 4207, 'NAP ODONTO SC LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3898, 4208, 'FACULDADE DE TECNOLOGIA MONTEIRO LOBATO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3899, 4209, 'FACULDADE DE TECNOLOGIA CSAR LATTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3900, 4210, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DO MORUMBI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3901, 4211, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE PERDIZES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3902, 4212, 'FACULDADE DE TECNOLOGIA DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3903, 4213, 'FACULDADE DE CAAPAVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3904, 4214, 'INSTITUTO SUPERIOR PAULO FREIRE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3905, 4215, 'FACULDADE DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3906, 4216, 'INSTITUTO MOINHOS DE VENTO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3907, 4217, 'FACULDADE DE TECNOLOGIA INSTITUTO POLITCNICO DO PARAN - UNIDADE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3908, 4218, 'FACULDADE DE DIREITO DE PEDRO LEOPOLDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3909, 4219, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSORA NAIR FORTES ABU-MERHY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3910, 4220, 'FACULDADE DE CINCIAS GERENCIAIS DE BICAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3911, 4221, 'INSTITUTO SUPERIOR DE EDUCAO DE BICAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3912, 4222, 'INSTITUTO SUPERIOR DE EDUCAO DE MATIAS BARBOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3913, 4223, 'FACULDADE SANTOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3914, 4224, 'FACULDADE DE ITAPECIRICA - FACITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3915, 4225, 'FACULDADE DE TECNOLOGIA LUIZ ADELAR SCHEUER', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3916, 4227, 'FACULDADE DE TECNOLOGIA SENAC PASSO FUNDO - PASSO FUNDO/RS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3917, 4228, 'INSTITUTO DE EDUCAO SUPERIOR MISSES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3918, 4229, 'FACULDADE PARANTINGA - FAP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3919, 4230, 'FACULDADE TECNOLGICA UNIVERSAL DE FORMAO TCNICA E SUPERIOR', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3920, 4233, 'INSTITUTO METROPOLITANO DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3921, 4234, 'SOCIEDADE EVOLUO DE TECNOLOGIA E EDUCAO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3922, 4235, 'FACULDADE TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3923, 4236, 'FACULDADES INTEGRADAS DE SERRANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3924, 4237, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DO AMAZONAS', 1, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3925, 4239, 'FACULDADE DE CINCIAS E TECNOLOGIA DO VALE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3926, 4241, 'FACULDADE DE CINCIAS HUMANAS, SOCIAIS E TECNOLGICAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3927, 4243, 'FACULDADE DE CINCIAS GERENCIAIS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3928, 4244, 'FACULDADE DE TECNOLOGIA ENSITEC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3929, 4245, 'FACULDADE DE TECNOLOGIA DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3930, 4246, 'PROGRAMA DE PS GRADUAO LATO SENSU DA FUNDAO UNIMED', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3931, 4247, 'FACULDADE DE CIENCIAS HUMANAS E SOCIAIS SO PAULO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3932, 4248, 'INSTITUTO DE ENSINO, PESQUISA E PS-GRADUAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3933, 4249, 'FACULDADE DE CINCIAS DE ALAGOAS - FACAL', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3934, 4250, 'FACULDADE DE CINCIAS GERENCIAIS ALVES FORTES (JUIZ DE FORA)', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3935, 4251, 'FACULDADE DE TECNOLOGIA INED - UNIDADE LAGOA DA PAMPULHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3936, 4252, 'FACULDADE DE TECNOLOGIA EXPOENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3937, 4253, 'ESCOLA AGROTCNICA FEDERAL DE CONCRDIA', 1, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3938, 4254, 'FACULDADES INTEGRADAS DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3939, 4255, 'FACULDADES INTEGRADAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3940, 4256, 'FACULDADES INTEGRADAS PITGORAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3941, 4257, 'INSTITUTO DE FILOSOFIA E TEOLOGIA DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3942, 4258, 'FACULDADE PURIFICAO LTDA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3943, 4259, 'FACULDADE DE INHUMAS - FAC-MAIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3944, 4260, 'FACULDADE DE TECNOLOGIA DE SO LEOPOLDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3945, 4261, 'FACULDADE DE TECNOLOGIA DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3946, 4262, 'FACULDADE DE TECNOLOGIA IDESC', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3947, 4263, 'FACULDADE ESPRITA RAMATIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3948, 4264, 'INSTITUTO FIGUEIREDO DE EDUCAO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3949, 4265, 'UNEPPSI - UNIDADE DE ENSINO E PESQUISA EM PSICOLOGIA E PSICANLISE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3950, 4266, 'INSTITUTO GUERRA BIAGI - INGB', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3951, 4267, 'INSTITUTO SUPERIOR DE EDUCAO DA AMRICA LATINA - ISAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3952, 4268, 'FACULDADE ISAG', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3953, 4269, 'SOCIEDADE BRASILEIRA DE EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3954, 4270, 'FACULDADE LIBERTAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3955, 4271, 'INSTITUTO SUPERIOR EM CINCIAS DA HUMANIDADE', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3956, 4272, 'INSTITUTO MODAL LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3957, 4273, 'INSTITUTO SUPERIOR DE EDUCAO SEESB', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3958, 4274, 'INSTITUTO TEOLGICO DA ASSEMBLIA DE DEUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3959, 4275, 'INSTITUTO DE ENSINO E PESQUISA EM ADMINISTRAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3960, 4276, 'IETEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3961, 4277, 'FACULDADE LITERATUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3962, 4278, 'FACULDADE INTEGRADA SANTA RITA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3963, 4279, 'FACULDADE DE TECNOLOGIA INSTITUTO POLITCNICO DO PARAN - UNIDADE GUARAPUAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3964, 4280, 'FACULDADE INTEGRADA CIDADE DE PATOS DE MINAS LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3965, 4281, 'FACULDADE AMBIENTAL DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3966, 4282, 'FACULDADE PARA O DESENVOLVIMENTO DO ESTADO DE SO PAULO - FADESP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3967, 4283, 'FACULDADE IASOCIAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3968, 4284, 'FACULDADE SO FRANCISCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3969, 4285, 'FUNDAO INSTITUTO DE ADMINISTRAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3970, 4286, 'FACULDADE PRATA - FAP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3971, 4287, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DO XINGU E AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3972, 4288, 'UNIED TECNOLOGIA EDUCACIONAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3973, 4289, 'FACULDADE DO VALE ELVIRA DAYRELL - FAVED', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3974, 4290, 'FACULDADE DE ARTES INTEGRADAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3975, 4291, 'IEMS INSTITUTO EDUCACIONAL MORADA DA SERRA DO MUNICPIO DE CUIAB/MT.', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3976, 4292, 'ITECSS - INSTITUTO TIRADENTES DE EDUCAO EM CINCIAS SOCIAIS E DA SADE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3977, 4293, 'FACULDADE INTEGRAO TIETE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3978, 4294, 'FACULDADE DE TECNOLOGIA SENAC JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3979, 4295, 'FACULDADE DE TECNOLOGIA SENAI CETIND', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3980, 4296, 'INSTITUTO BRASILEIRO DE CIENCIAS CRIMINAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3981, 4297, 'CENTRO DE ESTUDOS PROF JOS BELMIRO DE CASTRO MOREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3982, 4298, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3983, 4299, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA/RS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3984, 4300, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SECO PARAIBA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3985, 4301, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL ABO-DF', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3986, 4302, 'ASSOCIAO CATARINENSE DE ODONTOLOGIA ESPECIALIZADA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3987, 4303, 'SOCIEDADE DOS CIRURGIES DENTISTAS DE PERNAMBUCO - ABO/PE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3988, 4304, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA ABO-RO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3989, 4305, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA-ES/RVV', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3990, 4306, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA ASSOCIAO BRASILEIRA DE ODONTOLOGIA REGIONAL POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3991, 4307, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA - SEO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3992, 4308, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SECO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3993, 4309, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA - SEO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3994, 4310, 'UNIS-MG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3995, 4311, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL - ABO/AL', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3996, 4312, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO - REGIONAL CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3997, 4313, 'ASSOCIACAO BRASILEIRA DE ODONTOLOGIA SAOPAULO REGIONAL BIRIGUI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3998, 4314, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (3999, 4315, 'FACULDADE DE TEOLOGIA E CIENCIAS DA RELIGIAO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4000, 4316, 'FACULDADE DE TECNOLOGIA SANTOS DUMONT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4001, 4317, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4002, 4318, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4003, 4319, 'CAP/ABORJ - CENTRO DE APERFEIOAMENTO PROFISSIONAL DA ABO-RJ', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4004, 4320, 'ESCOLA DE PS GRADUAO /ASSOCIAO BRASILEIRA DE ODONTOLOGIA REGIONAL DE CASCAVEL - PR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4005, 4321, 'IETEC INSTITUTO DE CINCIA E TECNOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4006, 4322, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4007, 4323, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA REGIONAL CARIRI', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4008, 4324, 'FACULDADE GONZAGA DE PELOTAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4009, 4325, 'EAP ABO-MURIAE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4010, 4326, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL - ASSOCIAO BRASILEIRA DE ODONTOLOGIA REGIONAL JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4011, 4327, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4012, 4328, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4013, 4329, 'FACULDADE DO CENTRO EDUCACIONAL MINEIRO - FACEM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4014, 4330, 'FACULDADE DE TECNOLOGIA AMRICA DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4015, 4331, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO - REGIONAL ARAATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4016, 4332, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4017, 4333, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4018, 4334, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL SERTOZINHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4019, 4335, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO - REGIONAL SO JOSE DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4020, 4336, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL RIBEIRO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4021, 4337, 'ASSOCIACAO BRASILEIRA DE ODONTOLOGIA SAO PAULO REGIONAL PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4022, 4338, 'ASSOCIACAO BRASILEIRA DE ODONTOLOGIA SAO PAULO REGIONAL CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4023, 4339, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO REGIONAL VALE DO PARAIBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4024, 4340, 'FACULDADE DE ENSINO SUPERIOR DE VALENA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4025, 4341, 'ASSOCIAO MARINGAENSE DE ODONTOLOGIA ( AMO ) - ABO REGIONAL MARINGA - PR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4026, 4342, 'FACULDADE STAR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4027, 4343, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA ABO-MS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4028, 4344, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA ABO/PI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4029, 4345, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA ABO-BA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4030, 4346, 'FACULDADE DE ENSINO SUPERIOR DE MIGUEL ALVES', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4031, 4347, 'FACULDADE SERRA DOS PIRINEUS DE EDUCAO DE CINCIAS APLICADAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4032, 4348, 'FACULDADE DE COMUNICAO, TECNOLOGIA E CIENCIA - FACTEC', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4033, 4349, 'ABO - REGIONAL SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4034, 4350, 'E.A.B. ASSOCIAO BRASILEIRA DE ODOTOLOGIA RJ - D.DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4035, 4351, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA - SEO SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4036, 4352, 'ASSOCIACAO BRASILEIRA DE ODONTOLOGIA REGIONAL OSASCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4037, 4353, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA SO PAULO - REGIONAL ABC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4038, 4354, 'AFISVEC', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4039, 4355, 'FACULDADE DE TECNOLOGIA DE PALMAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4040, 4356, 'FACULDADE DE CINCIAS SOCIAIS DOS PALMARES', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4041, 4357, 'FACULDADE DE TECNOLOGIA LVARES DE AZEVEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4042, 4358, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO SUL DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4043, 4359, 'ESCOLA AGROTCNICA FEDERAL DE SATUBA', 1, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4044, 4360, 'ESCOLA AGROTCNICA FEDERAL DE MACHADO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4045, 4361, 'FACULDADE DE CINCIAS GERENCIAIS DE SANTA LUZIA MG - FAGESA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4046, 4362, 'FACULDADE PITGORAS DE BETIM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4047, 4363, 'INSTITUTO SANTA MNICA DE ESTUDOS E PESQUISAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4048, 4364, 'FACULDADE QUASAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4049, 4365, 'FABS - FACULDADE DE BOM SUCESSO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4050, 4366, 'EAP - ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4051, 4367, 'FACULDADE TERRA NORDESTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4052, 4368, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4053, 4369, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL - EAP - ABO/RN', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4054, 4370, 'SANTA CASA DE MISERICRDIA DE PONTA GROSSA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4055, 4371, 'FACULDADE PADRE ANCHIETA DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4056, 4372, 'U.E.P. UNIDADE DE ENSINO PROFISSIONAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4057, 4373, 'FACULDADE DE EDUCAO CINCIA E TECNOLOGIA DE REDENO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4058, 4374, 'CURSO DE TEOLOGIA E PASTORAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4059, 4375, 'UNC-SALVADOR UNIDADE AVANADA DE PS-GRADUAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4060, 4376, 'IBEG - PS-GRADUAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4061, 4377, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL /EAP', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4062, 4378, 'NCLEO DE ESTUDOS ORTODNTICOS MBT BRASIL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4063, 4379, 'ASSOCIAO DE CIRURGIES DENTISTAS DO ESTADO DE SO PAULO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4064, 4380, 'CENTRO DE QUALIFICAO ODONTOLGICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4065, 4381, 'ACADEMIA NORTE RIO-GRANDENSE DE ODONTOLOGIA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4066, 4382, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA - REGIONAL PETRPOLIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4067, 4383, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA - SECO DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4068, 4384, 'CESVIA FACULDADE DE VIAMO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4069, 4386, 'ESAB - ESCOLA SUPERIOR ABERTA DO BRASIL', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4070, 4387, 'NETT ODONTO - NCLEO DE ESPECIALIZAO, TREINAMENTO E TRATAMENTO ODONTOLGICO S/C LTDA.', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4071, 4388, 'IPEC - INSTITUTO PAULISTA DE EDUCAO CONTINUADA LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4072, 4389, 'FACULDADE INTEGRADA CARAJS DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4073, 4390, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA ASSOCIAO BRASILEIRA DE ODONTOLOGIA SECO SERGIPE', 2, 1, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4074, 4391, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4075, 4392, 'FATEC DE CONTAGEM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4076, 4393, 'INSTITUTO SUPERIOR DE CINCIAS DO COMPORTAMENTO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4077, 4394, 'FACULDADE DE EDUCAO FSICA DE ARAGUANA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4078, 4395, 'FACULDADE DE DIREITO DE ARAGUANA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4079, 4396, 'FACULDADES INTEGRADAS DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4080, 4397, 'ESCOLA SUPERIOR DE ENSINO DA SEICHO-NO-IE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4081, 4398, 'INSTITUTO SUPERIOR DE EDUCAO DE GOIANA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4082, 4399, 'FACULDADE DE BALSAS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4083, 4400, 'INSTITUTO DE ESTUDOS DA SADE - PS GRADUAO EM CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4084, 4401, 'FACULDADE DE APIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4085, 4403, 'FACULDADE DA ACADEMIA MEMORIAL DE ENSINO SUPERIOR DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4086, 4404, 'INSTITUTO SEDES SAPIENTIAE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4087, 4405, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA REGIONAL DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4088, 4406, 'ASSOCIACAO BRAS DE ODONTO SEC DE GOIAS SUB SEC DE JATAI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4089, 4407, 'FACULDADE DE ENSINO SUPERIOR DA TERRA PAULISTA - FATERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4090, 4408, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL ABO/RN REGIONAL MOSSOR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4091, 4409, 'ASSOCIAO INSTITUTO DE FOMENTO EDUCACIONAL FENIX', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4092, 4410, 'CRDA PS GRADUAES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4093, 4411, 'FACULDADE PANAMERICANA DE JI-PARAN', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4094, 4412, 'FACULDADE VALE DO ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4095, 4413, 'ASSOCIAO VITA CARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4096, 4414, 'INSTITUTO SUPERIOR DE EDUCAO VALE DO ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4097, 4415, 'FSD - FACULDADE SO DOMINGOS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4098, 4416, 'FACULDADE CIMAN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4099, 4417, 'FACULDADE DE ENFERMAGEM DE BELO JARDIM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4100, 4418, 'FACULDADE SO BERNARDO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4101, 4419, 'INSTITUTO DE PESQUISA E ENSINO EM SADE ANIMAL - IPESA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4102, 4420, 'FACULDADES INTEGRADAS BARROS MELO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4103, 4421, 'FACULDADE DE TECNOLOGIA SENAI BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4104, 4422, 'FACULDADE DE TECNOLOGIA DO ABC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4105, 4423, 'FACULDADE ADVENTISTA DE ENFERMAGEM DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4106, 4424, 'LIBERTAS CLNICA ESCOLA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4107, 4425, 'FACULDADE CORPO & MENTE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4108, 4426, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA-REGIONAL ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4109, 4427, 'FACULDADE DAS CINCIAS MULTIPLAS E DO MEIOAMBIENTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4110, 4428, 'FACULDADE PROFESSOR MIGUEL NGELO DA SILVA SANTOS', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4111, 4429, 'FACULDADE UNIGRAN CAPITAL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4112, 4430, 'ITAL - INSTITUTO DE TECNOLOGIA DE ALIMENTOS', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4113, 4431, 'FACULDADE DE ENFERMAGEM NOVA ESPERANA DE MOSSOR - FACENE/RN', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4114, 4432, 'FACULDADE GERAO POSITIVA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4115, 4433, 'FAWEST- FACULDADE WESTPHALIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4116, 4434, 'INSTITUTO DE DIREITO ROMEU FELIPE BACELLAR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4117, 4435, 'FACULDADE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4118, 4436, 'FACULDADE BIG MASTER', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4119, 4437, 'CENTRO ODONTOLGICO DE APERFEIOAMENTO PROFISSIONAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4120, 4438, 'ACADEMIA BRASILEIRA DE DIREITO CONSTITUCIONAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4121, 4439, 'COOENSINO - COOPERATIVA DE ENSINO UNIVERSAL DOIS MIL', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4122, 4440, 'FACULDADE DE MEDICINA NOVA ESPERANA DE NATAL - FAMENE/RN', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4123, 4441, 'SISTEMA EDUCACIONAL SUPERIOR UNIVERSITRIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4124, 4442, 'ESCOLA SUPERIOR PAULISTA DE ADMINISTRAO - ESPA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4125, 4443, 'FACULDADE RIO CLARO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4126, 4444, 'CBPEX PS-GRADUAO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4127, 4445, 'FACULDADE MEDIANEIRA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4128, 4446, 'FACULDADE CIDADE DE GUANHES - FACIG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4129, 4447, 'SOCIEDADE BRASILEIRA DE DIREITO PUBLICO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4130, 4448, 'SOCIEDADE BRASILEIRA DE DIREITO PUBLICO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4131, 4449, 'FACULDADE DE TECNOLOGIA DO NORTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4132, 4450, 'FACULDADE METROPOLITANA DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4133, 4451, 'FACULDADE TEOLOGICA E EDUCACIONAL AGAPE COMUNITARIA - FATEAC', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4134, 4452, 'FACULDADE METROPOLITANA DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4135, 4454, 'FACULDADE PITGORAS DE NOVA LIMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4136, 4455, 'GESTOS - GRUPO DE ESTUDOS ORTODNTICOS E SERVIOS S/C LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4137, 4456, 'ASSOCIAO BRASILEIRA DE ODONTOLOGIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4138, 4457, 'INSTITUTO SUPERIOR DE EDUCAO DE ITAPECIRICA DA SERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4139, 4458, 'INSTITUTO DE ENSINO SUPERIOR DE MACEI - IESMA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4140, 4459, 'INEES - INSTITUTO DE EDUCAO E ESPECIALIZAO SUPERIOR', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4141, 4460, 'FACULDADE DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4142, 4461, 'FACULDADE DE TECNOLOGIA SENAI CSAR RODRIGUES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4143, 4462, 'ESCOLA DE GESTO E CONTROLE FRANCISCO JURUENA', 2, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4144, 4463, 'GRUPO DE ESTUDO ODONTOLGICO E SERVIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4145, 4464, 'FACULDADE LAGEANA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4146, 4465, 'CENTRO ODONTOLOGICO DE ESTUDOS E PESQUISAS - COESP', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4147, 4466, 'CENTRO DE ESTUDOS PROF DIRCEU VIEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4148, 4467, 'IACE - INSTITUTO AVANADO DE CINCIAS E EDUCAO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4149, 4468, 'INSTITUTO PICE DE ENSINO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4150, 4469, 'FACULDADE HEXGONO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4151, 4470, 'TVALLE ASSESSORIA E TREINAMENTO EDUCACIONAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4152, 4471, 'FACULDADE DE TECNOLOGIA POLITEC', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4153, 4472, 'CESDE BRASIL INTELIGENCIA EDUCACIONAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4154, 4473, 'FACULDADE DE TECNOLOGIA ACCTIVA DE CINCIA E TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4155, 4474, 'ESCOLA PAULISTANA DE ODONTOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4156, 4475, 'ESCOLA CAPIXABA DE ODONTOLOGIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4157, 4476, 'ESCOLA PAULISTA DE ODONTOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4158, 4477, 'ENSINO  DISTNCIA - SLMANDIC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4159, 4478, 'ESCOLA BRASILIENSE DE ODONTOLOGIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4160, 4479, 'ESCOLA CHAPECOENSE DE ODONTOLOGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4161, 4480, 'ESCOLA CAMBORI DE ODONTOLOGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4162, 4481, 'ESCOLA FLUMINENSE DE ODONTOLOGIA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4163, 4482, 'ESCOLA DO NORDESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4164, 4483, 'ESCOLA CEARENSE DE ODONTOLOGIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4165, 4484, 'CENTRO DE PESQUISAS ODONTOLGICAS SO LEOPOLDO MANDIC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4166, 4485, 'ESCOLA FORENSE DE ODONTOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4167, 4486, 'ESCOLA MINEIRA DE ODONTOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4168, 4487, 'SOBRACURSOS - CURSOS DE PS-GRADUAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4169, 4488, 'ESCOLA METROPOLITANA DE ODONTOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4170, 4489, 'ESCOLA SANTISTA DE ODONTOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4171, 4490, 'FACULDADE SENADOR CANEDO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4172, 4491, 'FACULDADE TECNOLOGICA ITAI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4173, 4492, 'FACULDADE PASCHOAL DANTAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4174, 4493, 'FACULDADE DE TECNOLOGIA CERTUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4175, 4494, 'COORDENADORIA DE ENSINO  DISTNCIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4176, 4495, 'FACULDADE DE TECNOLOGIA JARAGUAENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4177, 4496, 'FACULDADE DE TECNOLOGIA DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4178, 4497, 'WP - CENTRO DE PSICOTERAPIA COGNITIVO-COMPORTAMENTAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4179, 4498, 'CENTRO DE ENSINO TEORICO TECNICO DE TRANSITO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4180, 4499, 'CENTRO DE ENSINO TEORICO TECNICO DE TRANSITO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4181, 4500, 'FACULDADE DE TECNOLOGIA EM SADE DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4182, 4501, 'FACULDADE DE TECNOLOGIA ALTO TIET', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4183, 4502, 'FACULDADES INTEGRADAS CAMPO-GRANDENSES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4184, 4503, 'UNIVERSIDADE FEDERAL DO RECNCAVO DA BAHIA', 1, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4185, 4504, 'FUNDAO UNIVERSIDADE FEDERAL DA GRANDE DOURADOS', 1, 1, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4186, 4505, 'FACULDADE FACISA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4187, 4506, 'CEFE - CENTRO DE ESTUDOS DE FISIOLOGIA DO EXERCCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4188, 4507, 'INSTITUTO SUPERIOR XAVIER CORDEIRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4189, 4508, 'FACULDADE DE ENSINO SUPERIOR DE FLORIANO - PI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4190, 4509, 'INSTITUTO SUL BRASILEIRO DE ENSINO SUPERIOR - INSBES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4191, 4510, 'FASOMA-FACULDADE SOLUO MARANHENSE LTDA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4192, 4511, 'IPPEO INSTITUTO PARANAENSE DE PESQUISA E ENSINO EM ODONTOLOGIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4193, 4512, 'FACULDADE GUIAS DO DIREITO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4194, 4513, 'FATEB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4195, 4514, 'ESCOLA SUPERIOR DA MAGISTRATURA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4196, 4515, 'ABO-REGIONAL DE TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4197, 4516, 'INSTITUTO CHIAVENATO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4198, 4517, 'FACULDADE DE EDUCAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4199, 4518, 'FACULDADE REGIONAL PALMITOS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4200, 4519, 'OPEG - FACULDADE DE TECNOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4201, 4520, 'FACULDADE CENACAP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4202, 4521, 'FACULDADE DE CINCIAS APLICADAS DE ITAPEVA - FACITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4203, 4522, 'CENTRO UNIVERSITRIO CATLICO SALESIANO AUXILIUM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4204, 4523, 'FACULDADE DO INSTITUTO EDUCACIONAL PROFISSIONALIZANTE DE JALES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4205, 4524, 'INSTITUTO TECNOLOGICO DE AVALIAO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4206, 4525, 'FACULDADE TECNOLOGICA DE EXCELENCIA EDUCACIONAL DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4207, 4526, 'FACULDADES INTEGRADAS LAVOISIER', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4208, 4527, 'FACULDADE DE URUAU', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4209, 4528, 'IBEXP - INSTITUTO BRASILEIRO DE EXECUTIVOS PROFISSIONAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4210, 4530, 'FACULDADE INTEGRADA TIRADENTES', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4211, 4531, 'FACULDADE ADVENTISTA DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4212, 4532, 'FACULDADE DE TECNOLOGIA SENAI CAMPO GRANDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4213, 4533, 'FACULDADE SO FRANCISCO DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4214, 4534, 'FACULDADE DE TECNOLOGIA HERRERO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4215, 4535, 'FACULDADE DA AMAZNIA - FAMA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4216, 4536, 'IPEO-MT', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4217, 4537, 'INSTITUTO SUPERIOR DE EDUCAO DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4218, 4538, 'FACULDADE PARQUE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4219, 4539, 'FACULDADE DE TEOLOGIA E CINCIAS HUMANAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4220, 4540, 'FACULDADES CONE SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4221, 4541, 'CENTRO BAIANO DE ESTUDOS ODONTOLGICOS - CEBEO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4222, 4542, 'INSTITUTO BIOSFERA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4223, 4543, 'FACULDADE DE EDUCAO E ESTUDOS SUPERIORES DE AREIA - FAESA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4224, 4544, 'FACULDADE LDER', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4225, 4545, 'FACULDADE PARANATINGA - FAP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4226, 4546, 'FACULDADE METODISTA UNIO URUGUAIANA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4227, 4547, 'CENTRO DE ESTUDOS E APERFEICOAMENTO PROFISSIONAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4228, 4548, 'CAP- CENTRO DE APERFEIOAMENTO PROFISSIONAL', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4229, 4550, 'INSTITUTO DE ENSINO PEDAGOGOS ASSOCIADOS - INESPA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4230, 4551, 'FACULDADES ASSOC. DE MNACO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4231, 4552, 'FACULDADE ECUMENICA LAYRA DE ALTO PARAISO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4232, 4553, 'FACULDADE MERIDIONAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4233, 4554, 'FUNDAO CARDIOVASCULAR SO FRANCISCO DE ASSIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4234, 4555, 'INSTITUTO DE EDUCAO A DISTNCIA NORTE FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4235, 4556, 'FACULDADE EVOLUO DE CINCIAS E TECNOLOGIA - FECET', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4236, 4557, 'CLINICA INTEGRADA DE ODONTOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4237, 4558, 'FACULDADE CENECISTA DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4238, 4559, 'INSTITUTO SUPERIOR LAGEANO DE EDUCAO A DISTNCIA - ISLED', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4239, 4560, 'FACULDADE DE SENHOR DO BOMFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4240, 4561, 'FACULDADE SANTO ANTNIO DE QUEIMADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4241, 4562, 'FACULDADE LUZ DE GUARABIRA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4242, 4563, 'FACULDADE DE TECNOLOGIA DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4243, 4564, 'FACULDADE SANTA RITA DE CASSIA FASARC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4244, 4565, 'INSTITUTO EDUCACIONAL SEMINRIO PAULOPOLITANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4245, 4566, 'FACULDADE DE EXCELNCIA EDUCACIONAL DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4246, 4567, 'FACULDADE CENTRO MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4247, 4568, 'FACULDADE EA DE QUEIROZ - SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4248, 4569, 'ESCOLA DE APERFEIOAMENTO PROFISSIONAL DA APCD REGIONAL TAUBAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4249, 4570, 'FACULDADE DE TEOLOGIA DE SELVRIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4250, 4571, 'INSTITUTO IPESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4251, 4572, 'FACULDADE DE TEOLOGIA E EDUCAO DE MINAS GERAIS-FATEMIG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4252, 4573, 'IBTEC - INSTITUTO BRASILEIRO DE TECNOLOGIA E CINCIAS', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4253, 4574, 'FACULDADE JACQUES COUSTEAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4254, 4575, 'INSTITUTO DE CINCIAS DO TRABALHO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4255, 4576, 'CENTRO DE ENSINO SUPERIOR LEOPOLDINENSE ALBERT EINSTEIN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4256, 4577, 'ISAE FGV PARAN - INSTITUTO SUPERIOR DE ADMINISTRAO E ECONOMIA DO PARAN - FUNDAO GETLIO VARGAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4257, 4578, 'FACULDADE CARLOS CHAGAS FILHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4258, 4579, 'FACULDADE DO SUDESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4259, 4580, 'FACULDADE REUNIDA DE ILHA SOLTEIRA - MESMO QUE 1625', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4260, 4581, 'CENTRO LUMN DE EXTENSO E PS-GRAFUAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4261, 4582, 'FACULDADE CENTRO SUL DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4262, 4583, 'FACULDADE PITGORAS DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4263, 4584, 'FACULDADE DE TECNOLOGIA MACHADO DE ASSIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4264, 4585, 'ESCOLA SUPERIOR DA MAGISTRATURA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4265, 4586, 'FACULDADE DO NORTE GOIANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4266, 4587, 'FACULDADE UNIVERSAL DE FORMAO TECNOLGICA E SUPERIOR - UNIFOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4267, 4588, 'FACULDADE APOGEU', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4268, 4589, 'FACULDADE DE DIREITO DO DISTRITO FEDERAL - FDDF', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4269, 4590, 'FACULDADE DE TECNOLOGIA FATEP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4270, 4592, 'FACULDADE DE OURO PRETO DO OESTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4271, 4593, 'CENTRO EURO-AMERICANO DE GESTO E HOSPITALIDADE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4272, 4594, 'FACULDADE CATLICA DE RONDONIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4273, 4595, 'DEPARTAMENTO DE APERFEIOAMENTO PROFISSIONAL - DAP', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4274, 4596, 'FACULDADE DE ADMINISTRAO E NEGCIOS EM RIBEIRO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4275, 4597, 'FACULDADE DE CINCIAS GERENCIAIS EM VOTUPORANGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4276, 4598, 'FACULDADE DE CINCIAS GERENCIAIS BARO DE JUNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4277, 4599, 'INSTITUTO EL SHADDAY DE TEOLOGIA E MISSES', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4278, 4600, 'FACULDADE DE TECNOLOGIA DE MACAP - FATEMA', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4279, 4601, 'FACULDADE TECNOLOGICA CRISTO REI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4280, 4602, 'FUNDAO ESCOLA SUPERIOR DO MPDFT', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4281, 4603, 'INSTITUTO DE TECNOLOGIA EM SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4282, 4604, 'FWM - FACULDADE TEOLGICA E APOLOGTICA DR WALTER MARTIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4283, 4605, 'FACULDADE DE ENSINO SUPERIOR KM 125', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4284, 4606, 'FACULDADE DE TECNOLOGIA CONTEC - UNIDADE DE CARAPINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4285, 4607, 'ESCOLA SUPERIOR KLYMUS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4286, 4608, 'FACULDADE 2001', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4287, 4609, 'FATESP - FACULDADE TEOLGICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4288, 4610, 'FACULDADE DE TECNOLOGIA ASSESSORITEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4289, 4611, 'FACULDADE PLANALTO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4290, 4612, 'ISEBES - INSTITUTO BETH SHALOM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4291, 4613, 'FACULDADE DE EDUCAO E MEIO AMBIENTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4292, 4614, 'FACULDADE APROVAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4293, 4615, 'ACADEMIA DE GESTO FISCAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4294, 4616, 'FACULDADE KANTUN', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4295, 4617, 'ATAME- PS-GRADUAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4296, 4618, 'E.A.P. ESCOLA DE APERFEIOAMENTO PROFISSIONAL ABO-RJ REGIONAL DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4297, 4619, 'SINDICATO DOS ODONTOLOGISTAS DO ESTADO DE SAO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4298, 4620, 'FACULDADE EVANGLICA - CEILNDIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4299, 4621, 'FACULDADE EVANGLICA - GUAS CLARAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4300, 4622, 'FACULDADE EVANGLICA - TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4301, 4623, 'FACULDADE LATINO-AMERICANA DE TEOLOGIA INTEGRAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4302, 4624, 'FACULDADE DE ODONTOLOGIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4303, 4625, 'A&C CONSULTING LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4304, 4626, 'FACIDER II', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4305, 4627, 'SO JUDAS - FACULDADES INTEGRADAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4306, 4628, 'ESCOLA SUPERIOR VERBO JURIDICO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4307, 4629, 'FACULDADE DE TECNOLOGIA FUNDETEC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4308, 4630, 'FACULDADE DE TECNOLOGIA TECMED', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4309, 4631, 'FACULDADE ANGLO-AMERICANO DE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4310, 4632, 'FACULDADE ANGLO-AMERICANO DE CAXIAS DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4311, 4633, 'FACULDADE ANGLO-AMERICANO DE PASSO FUNDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4312, 4634, 'ESCOLA AGROTCNICA FEDERAL DE ALEGRE', 1, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4313, 4635, 'FACULDADE INTEGRADO DA COMCAM', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4314, 4636, 'FACULDADES INTEGRADAS INTERAMERICANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4315, 4637, 'FACULDADE DE RELAES INTERNACIONAIS SRGIO VIEIRA DE MELLO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4316, 4638, 'FACULDADE TEOLGICA BATISTA EQUATORIAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4317, 4639, 'FACULDADE IJUI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4318, 4640, 'ESCOLA DE TERAPIA MANUAL E POSTURAL S/S LTDDA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4319, 4641, 'UNIDIDTICO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4320, 4642, 'FACULDADE UNIREAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4321, 4643, 'INSTITUTO SO PAULO DE ESTUDOS SUPERIORES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4322, 4644, 'UNIEXODOS - FACULDADE DE TECNOLOGIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4323, 4645, 'INSTITUTO BRASILEIRO DE CHI KUNG E TERAPIAS AFINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4324, 4646, 'IPG - INSTITUTO DE PS-GRADUAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4325, 4647, 'FACULDADE DE REABILITAO DO PLANALTO CENTRAL - FARPLAC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4326, 4648, 'DEPARTAMENTO DE ENSINO E CULTURA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4327, 4649, 'JRK ESCOLA DE PS GRADUAO EM ODONTOLOGIA LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4328, 4650, 'FACULDADE DA AMAZNIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4329, 4651, 'FACULDADES ANDEF', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4330, 4652, 'FACULDADE ANHANGERA DE SO JOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4331, 4653, 'FACULDADE COMUNITRIA DE GUARATINGUET', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4332, 4654, 'FACULDADE COMUNITRIA DE BAUR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4333, 4655, 'FACULDADE ANHANGERA DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4334, 4656, 'FACULDADE ANHANGERA DE PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4335, 4657, 'FACULDADE DE EDUCAO E ENSINO SUPERIOR TECNOLGICO  FAEST', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4336, 4658, '3158 - INSTITUTO SUPERIOR DE EDUCAO ANGLO-AMERICANO DE FOZ DO IGUAU - ISEAAFI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4337, 4659, 'FACULDADE DE TEOLOGIA, EDUCAO E CINCIAS - FATEC', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4338, 4660, 'UNIPESSOA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4339, 4661, 'FACULDADE DE AGRONEGCIO PARASO DO NORTE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4340, 4662, 'INSTITUTO LATINO AMERICANO DE PESQUISA E ENSINO ODONTOLGICO - ILAPEO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4341, 4663, 'NAP INSTITUTO DE ENSINO SUPERIOR LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4342, 4664, 'FAEPO - NCLEO DE PS-GRADUAO E PESQUISA EM ODONTOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4343, 4665, 'SOCIEDADE DE EDUCACAO E CULTURA CAICARAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4344, 4666, 'FACULDADE DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4345, 4667, 'FACULDADE RIO SONO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4346, 4668, 'FACULDADE COMUNITRIA DE SUMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4347, 4669, 'FACULDADE DELTA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4348, 4670, 'FACULDADE DE ENSINO SUPERIOR E TECNOLOGIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4349, 4671, 'IOCP - CEPS - CENTRO DE ESTUDOS E PS-GRADUAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4350, 4672, 'FACULDADE EMPREENDEDORA AURORA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4351, 4673, 'ESCOLA SUPERIOR DE TEOLOGIA E FILOSOFIA DO BRASIL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4352, 4674, 'FACULDADE PORTO DAS GUAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4353, 4675, 'JUSPODIVM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4354, 4676, 'SENAI DENDEZEIROS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4355, 4677, 'UNIVERSIDADE JOS DO ROSRIO VELLANO - UNIFENAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4356, 4678, 'INSTITUTO DE DERMATOLOGIA, MEDICINA E CIRURGIA ESTETICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4357, 4679, 'FESPPAR - FACULDADE EDUCACIONAL DE PINHAIS DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4358, 4680, 'FEPPAR - FACULDADE EDUCACIONAL DE PIRAQUARA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4359, 4681, 'FACULDADE CENTRO PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4360, 4682, 'FACULDADE INTEGRADA BRASILEIRA RENASCENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4361, 4683, 'PROJECTO CENTRO CULTURAL E DE FORMAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4362, 4684, 'BUSINESS SCHOOL CEDEPE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4363, 4685, 'FACULDADES INTEGRADAS PLURAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4364, 4686, 'FACULDADE SO BASILIO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4365, 4687, 'FACULDADE DE TEOLOGIA BRASILEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4366, 4688, 'FACULDADE DE DIREITO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4367, 4689, 'INSTITUTO DE ENSINO SUPERIOR PASSIONISTA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4368, 4690, 'FACULDADE DE EDUCAO SUPERIOR E TEOLGICA MARANHENSE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4369, 4691, 'INSTITUTO PARANAENSE DE PESQUISA, DESENVOLVIMENTO E PS-GRADUAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4370, 4692, 'FACULDADE VITORIO BONACIN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4371, 4693, 'FACULDADE DE TECNOLOGIA DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4372, 4694, 'FACULDADE DE TEOLOGIA E CIENCIAS DA EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4373, 4695, 'UB FACULDADE TECNOLGICA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4374, 4696, 'FASE - FACULDADE DE TECNOLOGIA DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4375, 4697, 'MOUSE COM CURSOS PROFISSIONALIZANTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4376, 4698, 'TECNOLOGIA RADIOLGICA E RADIOTERPICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4377, 4699, 'FACULDADE DE EDUCAAO, CIENCIA E TECNOLOGIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4378, 4700, 'FACULDADE NOVA ROMA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4379, 4701, 'FACULDADE CATLICA DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4380, 4702, 'FACULDADE DE TECNOLOGIA GESTO & MARKETING', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4381, 4703, 'INSTITUTO D ENSINO SUPERIOR CASTRO ALVES', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4382, 4704, 'FACULDADE PONTE SERRADA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4383, 4705, 'FACULDADE UNIECO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4384, 4706, 'FACULDADE WELLINGTON', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4385, 4707, 'NCLEO DE EDUCAO CONTINUADA - NEC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4386, 4708, 'FACULDADE SINOPENSE DE ENSINO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4387, 4709, 'IRMANDADE DA SANTA CASA DE MISERICRDIA DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4388, 4710, 'INSTITUTO CABRERA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4389, 4711, 'UNIDADE DE ENSINO SUPERIOR DE APUCARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4390, 4712, 'FACULDADES CASA DO SABER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4391, 4713, 'ASSOCIAO DE ENSINO SUPERIOR EDUCARE - EDUCARE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4392, 4714, 'FACULDADE ALTERNATIVA DE ENSINO SUPERIOR DO AGRESTE - FAESA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4393, 4715, 'BRIGADA AMBIENTAL DO MUNICPIO DE SO PEDRO DA ALDEIA', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4394, 4716, 'FACULDADE DE MEDICINA DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4395, 4717, 'INSTITUTO SUPERIOR DE EDUCAO SANTA MARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4396, 4718, 'FACULDADE DE TECNOLOGIA SANTA MARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4397, 4719, 'FACULDADE DE TECNOLOGIA IJUI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4398, 4720, 'IBREAS - INSTITUTO BRASILEIRO DE ESTUDOS AVANADOS EM SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4399, 4721, 'ESCOLA DOMINICANA DE TEOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4400, 4722, 'FACULDADES INTEGRADAS VIANNA JNIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4401, 4723, 'ACADEMIA NACIONAL DE POLCIA', 1, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4402, 4724, 'FACULDADE DE CINCIAS HUMANAS DE CRUZEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4403, 4725, 'FACULDADE DE TECNOLOGIA EGDIO JOS DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4404, 4726, 'FACULDADE EQUIPE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4405, 4727, 'FACULDADE DE EDUCAO, CINCIA E TECNOLOGIA EM CAMOCIM', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, updated_at) VALUES (4406, 4728, 'FACULDADE CENECISTA DE QUISSAM', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies (id, ies_id, nome, dependencia_administrativa_id, tipo_instituicao_id, uf, user_id, created_at, upda