-- //

-- Fora commit para cada operao atmica
SET AUTOCOMMIT TO on;

-- Configura o search_path
SET search_path TO "$user", public, portal, cadastro, acesso, alimentos, consistenciacao, historico, pmiacoes, pmicontrolesis, pmidrh, pmieducar, pmiotopic, urbano;


-- Cadastra os tipos de logradouro
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CORRE', 'Corredor');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('DESCI', 'Descida');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('AEROP', 'Aeroporto');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('DESVI', 'Desvio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ELEVA', 'Elevada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ENTRP', 'Entrada Particular');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESCA', 'Escada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESCAD', 'Escadaria');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTAC', 'Estacionamento');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESPLA', 'Esplanada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('GALER', 'Galeria');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ILHA', 'Ilha');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('JDNET', 'Jardinete');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('LAGO', 'Lago');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('LAGOA', 'Lagoa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('MONTE', 'Monte');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('MARIN', 'Marina');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VERED', 'Vereda');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CORRG', 'Crrego');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PASSE', 'Passeio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BULEV', 'Bulevar');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PAES', 'Praa Esportes');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CALA', 'Calada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('COLON', 'Colnia');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PATIO', 'Ptio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TUNEL', 'Tnel');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ROTUL', 'Rtula');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTAD', 'Estdio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('MODUL', 'Mdulo');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('SERVI', 'Servido');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ALM', 'Alameda');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ALTO', 'Alto');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('AV', 'Avenida');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BEC', 'Beco');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CHC', 'Chcara');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('COND', 'Condomnio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CONJ', 'Conjunto');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('DIV', 'Divisa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('EST', 'Estrada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('FEIRA', 'Feira');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('JD', 'Jardim');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('LAD', 'Ladeira');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('LTM', 'Loteamento');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('LRG', 'Largo');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('MRG', 'Margem');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PA', 'Praa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PORTO', 'Porto');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PQE', 'Parque');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PRAIA', 'Praia');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('QDA', 'Quadra');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('REC', 'Recanto');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RES', 'Residencial');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RET', 'Retorno');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ROD', 'Rodovia');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ROT', 'Rotatria');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RUA', 'Rua');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('STIO', 'Stio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TER', 'Terminal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TRV', 'Travessa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('UND', 'Unidade');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIA', 'Via');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VLA', 'Vila');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ACAMP', 'Acampamento');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ACESS', 'Acesso');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIACE', 'Via de Acesso');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ADRO', 'Adro');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ANTES', 'Antiga Estrada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('AREA', 'rea');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ARESP', 'rea Especial');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ATALH', 'Atalho');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('AVCON', 'Avenida Contorno');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('AVMAR', 'Avenida Marginal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('AVVEL', 'Avenida Velha');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PARAL', 'Paralela');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ENTRQ', 'Entre Quadra');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PRQMU', 'Parque Municipal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PRQRE', 'Parque Residencial');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BAIXA', 'Baixa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PASSG', 'Passagem');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PASPE', 'Passagem de Pedestres');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PASSB', 'Passagem Subterrnea');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BELVE', 'Belvedere');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PASSA', 'Passarela');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BLOCO', 'Bloco');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BOSQU', 'Bosque');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PONTA', 'Ponta');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BOULE', 'Boulevard');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ZIGUE', 'Zigue-Zague');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIELA', 'Viela');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIDUT', 'Viaduto');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIALO', 'Via Local');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIAPE', 'Via de Pedestre');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIALI', 'Via Litornea');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIAEL', 'Via Elevado');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIAEX', 'Via Expressa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VIACO', 'Via Coletora');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CAMIN', 'Caminho');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VALE', 'Vale');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('VALA', 'Vala');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TRAVP', 'Travessa Particular');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TRAVV', 'Travessa Velha');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TRECH', 'Trecho');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('TREVO', 'Trevo');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RUAPE', 'Rua de Pedestre');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RUAPA', 'Rua Particular');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RUAVE', 'Rua Velha');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('SUBID', 'Subida');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PONTE', 'Ponte');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RAMPA', 'Rampa');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BURAC', 'Buraco');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('QUINT', 'Quinta');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RETIR', 'Retiro');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CAIS', 'Cais');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('FONTE', 'Fonte');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PROLO', 'Prolongamento');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('PARAD', 'Parada');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('SETOR', 'Setor');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RETA', 'Reta');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('MORRO', 'Morro');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RODAN', 'Rodo Anel');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RAMAL', 'Ramal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('FERRO', 'Ferrovia');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CANAL', 'Canal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('FORT', 'Forte');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('DISTR', 'Distrito');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTRE', 'Estrada Estadual');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTRM', 'Estrada Municipal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTRP', 'Estrada Particular');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTRV', 'Estrada Velha');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTRC', 'Estrada Vicinal');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CICLO', 'Ciclovia');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('GRANJ', 'Granja');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('FAZEN', 'Fazenda');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CAMPO', 'Campo');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('FAVEL', 'Favela');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CIRCU', 'Circular');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CONTO', 'Contorno');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('RUALI', 'Rua de Ligao');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ROTAT', 'Rotatria');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('NUCLE', 'Ncleo');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTRL', 'Estrada de Ligao');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ARTER', 'Artria');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('COMVI', 'Complexo Virio');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('CJOMU', 'Conjunto Mutiro');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('ESTA', 'Estao');
INSERT INTO urbano.tipo_logradouro (idtlog, descricao) VALUES ('BALAO', 'Balo');

-- Consistenciao
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (1, 'CPF ou CNPJ', 'N', 14);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (2, 'Nome pessoa fsica ou jurdica', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (3, 'E-mail', 'N', 50);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (4, 'URL', 'N', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (5, 'Data nascimento', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (6, 'Nmero RG', 'N', 10);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (7, 'rgo expedidor RG', 'S', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (8, 'Data expedio RG', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (9, 'UF expedio RG', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (10, 'Tipo certido civil', 'S', 2);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (11, 'Nmero termo certido civil', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (12, 'Nmero livro certido civil', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (13, 'Nmero folha certido civil', 'N', 4);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (14, 'Data emisso certido civil', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (15, 'Cartrio emissor certido civil', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (16, 'UF emisso certido civil', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (17, 'Nmero carteira trabalho', 'N', 7);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (18, 'Nmero srie carteira trabalho', 'N', 5);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (19, 'Data emisso carteira trabalho', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (20, 'UF emisso carteira trabalho', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (21, 'Nmero ttulo de eleitor', 'N', 13);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (22, 'Nmero zona ttulo eleitor', 'N', 4);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (23, 'Nmero seo ttulo eleitor', 'N', 4);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (24, 'Nome fantasia pessoa jurdica', 'N', 50);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (25, 'Nmero inscrio estadual', 'N', 10);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (26, 'Sexo pessoa fsica', 'S', 10);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (27, 'Nome me', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (28, 'Nome pai', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (29, 'Nome cnjuge', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (30, 'Nome responsvel', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (31, 'Nome ltima empresa', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (32, 'Ocupao profissional', 'S', 250);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (33, 'Escolaridade', 'S', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (34, 'Estado civil', 'S', 15);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (35, 'Pas de origem(se estrangeiro)', 'S', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (36, 'Data chegada ao Brasil', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (37, 'Data bito', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (38, 'Data unio com cnjuge', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (39, 'DDD telefone residencial', 'N', 3);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (40, 'Telefone residencial', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (41, 'DDD telefone comercial', 'N', 3);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (42, 'Telefone comercial', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (43, 'DDD telefone celular', 'N', 3);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (44, 'Telefone celular', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (45, 'DDD fax', 'N', 3);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (46, 'Fax', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (47, 'Logradouro (end. correspondncia)', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (48, 'Tipo logradouro (end. correspondncia)', 'S', 15);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (49, 'Nmero (end. correspondncia)', 'N', 6);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (50, 'Letra (end. correspondncia)', 'N', 1);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (51, 'Complemento (end. correspondncia)', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (52, 'Bairro (end. correspondncia)', 'N', 40);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (53, 'CEP (end. correspondncia)', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (54, 'Cidade (end. correspondncia)', 'N', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (55, 'UF (end. correspondncia)', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (56, 'Logradouro (end. residencial)', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (57, 'Tipo logradouro (end. residencial)', 'S', 15);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (58, 'Nmero (end. residencial)', 'N', 6);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (59, 'Letra (end. residencial)', 'N', 1);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (60, 'Complemento (end. residencial)', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (61, 'Bairro (end. residencial)', 'N', 40);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (62, 'CEP (end. residencial)', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (63, 'Cidade (end. residencial)', 'N', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (64, 'UF (end. residencial)', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (65, 'Logradouro (end. comercial)', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (66, 'Tipo logradouro (end. comercial)', 'S', 15);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (67, 'Nmero (end. comercial)', 'N', 6);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (68, 'Letra (end. comercial)', 'N', 1);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (69, 'Complemento (end. comercial)', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (70, 'Bairro (end. comercial)', 'N', 40);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (71, 'CEP (end. comercial)', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (72, 'Cidade (end. comercial)', 'N', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (73, 'UF (end. comercial)', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (74, 'Logradouro (correspondncia ou residencial)', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (75, 'Tipo logradouro (correspondncia ou residencial)', 'S', 15);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (76, 'Nmero (correspondncia ou residencial)', 'N', 6);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (77, 'Letra (correspondncia ou residencial)', 'N', 1);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (78, 'Complemento (correspondncia ou residencial)', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (79, 'Bairro (correspondncia ou residencial)', 'N', 40);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (80, 'CEP (correspondncia ou residencial)', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (81, 'Cidade (correspondncia ou residencial)', 'N', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (82, 'UF (correspondncia ou residencial)', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (83, 'Logradouro (correspondncia ou comercial)', 'N', 150);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (84, 'Tipo logradouro (correspondncia ou comercial)', 'S', 15);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (85, 'Nmero (correspondncia ou comercial)', 'N', 6);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (86, 'Letra (correspondncia ou comercial)', 'N', 1);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (87, 'Complemento (correspondncia ou comercial)', 'N', 20);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (88, 'Bairro (correspondncia ou comercial)', 'N', 40);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (89, 'CEP (correspondncia ou comercial)', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (90, 'Cidade (correspondncia ou comercial)', 'N', 60);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (91, 'UF (correspondncia ou comercial)', 'S', 30);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (92, 'DDD telefone comercial ou residencial', 'N', 3);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (93, 'Telefone comercial ou residencial', 'N', 8);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (94, 'CPF', 'N', 14);
INSERT INTO consistenciacao.campo_consistenciacao (idcam, campo, permite_regra_cadastrada, tamanho_maximo) VALUES (95, 'CNPJ', 'N', 14);

-- Cadastra rgos emissores de identidade
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (1, 'SSP', 'SSP', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (2, 'MMil', 'Ministrios Militares', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (3, 'MAer', 'Ministrio da Aeronutica', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (4, 'MExe', 'Ministrio do Exrcito', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (5, 'MMar', 'Ministrio da Marinha', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (6, 'PF', 'Polcia Federal', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (7, 'CIC', 'Carteira de Identidade Classista', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (8, 'CRA', 'Conselho Regional de Administrao', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (10, 'CRB', 'Conselho Regional de Biblioteconomia', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (11, 'CRC', 'Conselho Regional de Contabilidade', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (12, 'CRECI', 'Conselho Regional de Corretores Imveis', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (14, 'CREA', 'Conselho Regional de Engenharia, Arquitetura e Agronomia', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (18, 'CRM', 'Conselho Regional de Medicina', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (19, 'CRMV', 'Conselho Regional de Medicina Veterinria', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (20, 'OMB', 'Ordem dos Msicos do Brasil', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (22, 'CRO', 'Conselho Regional de Odontologia', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (24, 'CRP', 'Conselho Regional de Psicologia', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (25, 'CRQ', 'Conselho Regional de Qumica', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (27, 'OAB', 'Ordem dos Advogados do Brasil', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (28, 'OEmi', 'Outros Emissores', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (29, 'DExt', 'Documento Estrangeiro', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (9, 'CRESS', 'Conselho Regional de Assist. Social', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (13, 'COREN', 'Conselho Regional de Enfermagem', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (15, 'CONRE', 'Conselho Regional de Estatstica', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (16, 'CRF', 'Conselho Regional de Farmcia', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (17, 'CREFITO', 'Conselho Regional de Fisioterapia e Terapia Ocupacional', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (21, 'CRN', 'Conselho Regional de Nutrio', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (23, 'CONRERP', 'Conselho Regional de Profissionais de Relaes Pblicas', 'I');
INSERT INTO cadastro.orgao_emissor_rg (idorg_rg, sigla, descricao, situacao) VALUES (26, 'CORE', 'Conselho Regional de Representantes Comerciais', 'I');

-- Cadastra estados civis para pessoa fsica
INSERT INTO cadastro.estado_civil (ideciv, descricao) VALUES (1, 'Solteiro(a)');
INSERT INTO cadastro.estado_civil (ideciv, descricao) VALUES (2, 'Casado(a)');
INSERT INTO cadastro.estado_civil (ideciv, descricao) VALUES (3, 'Divorciado(a)');
INSERT INTO cadastro.estado_civil (ideciv, descricao) VALUES (4, 'Separado(a)');
INSERT INTO cadastro.estado_civil (ideciv, descricao) VALUES (5, 'Vivo(a)');
INSERT INTO cadastro.estado_civil (ideciv, descricao) VALUES (6, 'Companheiro(a)');

-- Cadastra cdigos de sistemas (valores esto handcoded na aplicao)
INSERT INTO acesso.sistema(
            idsis, nome, descricao, contexto, situacao)
    VALUES (1, 'i-Educar', 'Sistema bsico', '', 'A');
INSERT INTO acesso.sistema(
            idsis, nome, descricao, contexto, situacao)
    VALUES (9, 'Cdigo legado', 'Sistema bsico', '', 'A');    
INSERT INTO acesso.sistema(
            idsis, nome, descricao, contexto, situacao)
    VALUES (17, 'Cdigo legado', 'Sistema bsico', '', 'A');

-- Cadastra usurio administrador
INSERT INTO cadastro.pessoa (
            nome, idpes_cad, data_cad, url, tipo, idpes_rev, data_rev, email, situacao, origem_gravacao, operacao, idsis_rev, idsis_cad) 
    VALUES ('Administrador', NULL, NOW(), NULL, 'F', NULL, NULL, '', 'A', 'M', 'I', NULL, 1);

-- Cadastra administrador como pessoa fsica
INSERT INTO cadastro.fisica(
            idpes, data_nasc, sexo, idpes_mae, idpes_pai, idpes_responsavel, 
            idesco, ideciv, idpes_con, data_uniao, data_obito, nacionalidade, 
            idpais_estrangeiro, data_chegada_brasil, idmun_nascimento, ultima_empresa, 
            idocup, nome_mae, nome_pai, nome_conjuge, nome_responsavel, justificativa_provisorio, 
            idpes_rev, data_rev, origem_gravacao, idpes_cad, data_cad, operacao, 
            idsis_rev, idsis_cad, ref_cod_sistema, cpf, ref_cod_religiao)
    VALUES (1, NULL, NULL, NULL, NULL, NULL, 
            NULL, NULL, NULL, NULL, NULL, NULL, 
            NULL, NULL, NULL, NULL, 
            NULL, NULL, NULL, NULL, NULL, NULL, 
            NULL, NULL, 'M', NULL, NOW(), 'I', 
            NULL, 1, NULL, NULL, NULL);

-- Cadastra administrador como funcionrio (possibilita o login na aplicao)
INSERT INTO portal.funcionario 
  (ref_cod_pessoa_fj, matricula, senha, ativo, ref_sec, ramal, sequencial, opcao_menu, ref_cod_setor, ref_cod_funcionario_vinculo, tempo_expira_senha, tempo_expira_conta, data_troca_senha, data_reativa_conta, ref_ref_cod_pessoa_fj, proibido, ref_cod_setor_new, matricula_new, matricula_permanente, tipo_menu, ip_logado, data_login) 
VALUES 
  (1, 'admin', MD5('admin'), 1, NULL, NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, 1, '127.0.0.1', NOW());

-- Menu
INSERT INTO pmicontrolesis.tutormenu (cod_tutormenu, nm_tutormenu) VALUES (7, 'i-Pauta');
INSERT INTO pmicontrolesis.tutormenu (cod_tutormenu, nm_tutormenu) VALUES (15, 'i-Educar');
INSERT INTO pmicontrolesis.tutormenu (cod_tutormenu, nm_tutormenu) VALUES (16, 'i-Educar Biblioteca');

-- Tipo de imagem
INSERT INTO portal.imagem_tipo (cod_imagem_tipo, nm_tipo) VALUES (1, 'Icone');
INSERT INTO portal.imagem_tipo (cod_imagem_tipo, nm_tipo) VALUES (6, 'Acervo');

-- Menu portal (barra lateral)
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (1, 'Todos', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (4, 'Menu', 'Menus', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (5, 'Agenda', 'Agendas', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (12, 'Administrao', 'Sistemas da Administrao', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (16, 'Controle Intranet', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (25, 'DRH', 'Sistemas do RH', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (7, 'Pessoa F/J', 'Pessoas Fsicas e Jurdicas', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (23, 'Principal', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (67, 'Controle Portal', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (6, 'Jornalistico', 'Menus de Jornalismo', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (54, 'Aes Governo', 'Aes Governo', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (19, 'Compras', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (68, 'Endereamento', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (38, 'i-Pauta', '', NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (55, 'i-Educar - Escola', NULL, NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (56, 'i-Educar - Controle', NULL, NULL);
INSERT INTO portal.menu_menu (cod_menu_menu, nm_menu, title, ref_cod_menu_pai) VALUES (57, 'i-Educar - Biblioteca', NULL, NULL);

-- Submenus portal (barra lateral)
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (0, 1, 0, 'Super Usurio', '', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (79, 4, 2, 'Cadastro de Menus', 'menu_menu_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (35, 4, 2, 'Cadastro de Submenus', 'menu_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (445, 4, 2, 'Menu Suspenso', 'menu_suspenso_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (345, 5, 2, 'Agenda Pessoal', 'agenda.php', 'Agenda pessoal', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (343, 5, 2, 'Agenda Admin', 'agenda_admin_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (341, 5, 2, 'Agendas', 'agenda_responsavel.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (375, 12, 2, 'Cadastro de Setores', 'oprot_setor_lst.php', 'Setores', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (170, 12, 2, 'Estrutura Secretarias', 'administracao_estrutura.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (473, 16, 2, 'Banco de Imagens', 'imagem_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (89, 67, 2, 'Banners', 'banner_lst.php', 'Banners do Portal', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (244, 16, 2, 'Acesso Indevido', 'acesso_indevido_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (158, 16, 2, 'Conexes Intranet', 'conexoes_todos_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (588, 16, 2, 'Sistemas', 'controlesis_sistema_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (666, 16, 2, 'Bloqueio de senha - intranet', 'portal_acesso_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (36, 25, 2, 'Cadastro de Funcionrios', 'funcionario_lst.php', 'Clique aqui para inserir, editar ou excluir um usurio.', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (190, 25, 2, 'Vnculos', 'funcionario_vinculo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (43, 7, 2, 'Pessoa Fsica', 'atendidos_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (41, 7, 2, 'Pessoa Jurdica', 'empresas_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (155, 23, 2, 'Minha Agenda', 'agenda.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (157, 23, 2, 'Minhas Conexes', 'conexoes_lst.php', 'Minhas Conexes', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (475, 23, 2, 'Preferncias', 'opcao_menu_lst.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (293, 25, 2, 'Dirias', 'diaria_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (297, 25, 2, 'Dirias Grupo', 'diaria_grupo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (295, 25, 2, 'Dirias Valores', 'diaria_valores_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (612, 67, 2, 'Menu Portal', 'controlesis_menu_portal_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (613, 67, 2, 'Submenu Portal', 'controlesis_submenu_portal_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (614, 67, 2, 'Portal - Itinerrio', 'controlesis_itinerario_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (615, 67, 2, 'Portal - Portais', 'controlesis_portais_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (616, 67, 2, 'Portal - Servios', 'controlesis_servicos_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (694, 67, 2, 'Topo portal', 'controlesis_topo_portal_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (611, 67, 2, 'Telefones teis', 'controlesis_telefones_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (605, 6, 2, 'Acontecimentos', 'controlesis_acontecimento_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (604, 6, 2, 'Tipo Acontecimento', 'controlesis_tipo_acontecimento_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (27, 6, 2, 'Cadastro de Fotos', 'fotos_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (104, 6, 2, 'Tipo de Notcia', 'not_tipos_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (26, 6, 2, 'Cadastro de Notcias', 'noticias_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (669, 6, 2, 'Galeria de Fotos', 'fotos_galeria_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (34, 6, 2, 'Cadastro de Jornal', 'jornal_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (551, 54, 2, 'Ao Governo', 'acoes_acao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (553, 54, 2, 'Secretaria Responsvel', 'acoes_setor_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (552, 54, 2, 'Categoria', 'acoes_categoria_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (137, 19, 2, 'Compras - Funcionrios', 'compras_funcionarios_lst.php', 'Cadastro de Funcionarios', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (29, 19, 2, 'Licitaes - Cadastro', 'licitacoes_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (135, 19, 2, 'Licitaes - Equipe', 'licitacoes_funcionarios_lst.php', 'Cadastro de equipe de Licitao', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (136, 19, 2, 'Licitaes - Finalizar', 'licitacoes_finalizar_lst.php', 'Finalizar uma licitao', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (159, 19, 2, 'Licitaes - Finalizadas', 'licitacoes_finalizadas_lst.php', 'Lista de Licitaoes Finalizadas', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (138, 19, 2, 'Licitaes - Status', 'licitacoes_statusfinal_lst.php', 'Cadastro de status final de licitacao', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (154, 19, 2, 'Relatrio de Licitaes', 'licitacoes_relatorio.php', 'Relatrio de Licitaes', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (239, 19, 2, 'Licitaes - Edital', 'licitacoes_edital_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (240, 19, 2, 'Licitaes - Edital - Empresas', 'licitacoes_edital_empresa_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (241, 19, 2, 'Licitaes - Edital - Relatorio', 'licitacoes_edital_relatorio.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (773, 19, 2, 'Licitaes - Modalidade', 'portal_compras_modalidade_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (753, 68, 2, 'Pais', 'public_pais_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (754, 68, 2, 'Estado', 'public_uf_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (755, 68, 2, 'Municpio', 'public_municipio_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (756, 68, 2, 'Bairro', 'public_bairro_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (757, 68, 2, 'Logradouro', 'public_logradouro_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (758, 68, 2, 'CEP', 'urbano_cep_logradouro_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (296, 38, 2, 'Cadastro de Grupos', 'otopic_grupos_lst.php', 'Cadastro de Grupos', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (459, 38, 2, 'Apresentao', 'topic_index.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (294, 38, 2, 'Meus Grupos', 'otopic_meus_grupos_lst.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (335, 38, 2, 'Super Usurio ', 'otopic_su_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (648, 25, 2, 'Dirias Relatrio Data Secretaria', 'diaria_rel_data_secretaria.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (336, 25, 2, 'Dirias Relatrio Geral', 'diaria_relatorio.php', 'Relatrio de Dirias', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (299, 25, 2, 'Dirias Relatrio Data', 'diaria_rel_data.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (332, 25, 2, 'Dirias Relatrio Funcionrio', 'diaria_rel_funcionario.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (333, 25, 2, 'Dirias Relatrio Valor', 'diaria_rel_valor.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (337, 25, 2, 'Dirias Relatrio Secretaria', 'diaria_rel_secretaria.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (116, 6, 2, 'Graf. Mailling - Dirio', 'mailling_grafico_enviados_dia.php', 'Grfico de mailling diario', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (114, 6, 2, 'Graf. Mailling - Mensal', 'mailling_grafico_enviados_mes.php', 'Grfico de Maillings enviados', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (115, 6, 2, 'Graf. Mailling - Semanal', 'mailling_grafico_enviados_semana.php', 'Grfico de e-mails enviados por semana', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (109, 6, 2, 'Graf. Noticias - Tipo', 'noticias_grafico_tipo.php', 'Grafico de notcias por tipo', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (86, 6, 2, 'Mailling - Emails', 'mailling_email_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (87, 6, 2, 'Mailling - Enviar', 'mailling_enviar_email.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (741, 6, 2, 'Mailling - Enviar Convites', 'mailling_enviar_convite.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (85, 6, 2, 'Mailling - Grupos', 'mailling_grupos_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (209, 67, 2, 'Publicaes', 'concursos_lst.php', 'Cadastro de concursos publicos', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (811, 55, 2, 'Espelho de Notas Bimestral', 'educar_relatorio_alunos_nota_semestre_disc.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (824, 55, 2, 'Acompanhamento Mensal', 'educar_relatorio_acompanhamento_mensal.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (829, 55, 2, 'Categorias  de Nveis', 'educar_categoria_nivel_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (831, 55, 2, 'Servidores por Nvel', 'educar_relatorio_servidor_nivel.php', 'Servidores por Nvel', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (746, 55, 2, 'Histrico Escolar', 'educar_relatorio_historico_escolar.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (568, 55, 2, 'Tipo Regime', 'educar_tipo_regime_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (569, 55, 2, 'Material Didtico', 'educar_material_didatico_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (561, 55, 2, 'Escola', 'educar_escola_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (557, 55, 2, 'Disciplina', 'educar_disciplina_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (570, 55, 2, 'Turma Tipo', 'educar_turma_tipo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (558, 55, 2, 'Tipo Ensino', 'educar_tipo_ensino_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (560, 55, 2, 'Tipo de Avaliao', 'educar_tipo_avaliacao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (562, 55, 2, 'Escola Localizao', 'educar_escola_localizacao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (571, 55, 2, 'Nvel Ensino', 'educar_nivel_ensino_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (563, 55, 2, 'Tipo Material Didtico', 'educar_material_tipo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (574, 55, 2, 'Cmodo Prdio', 'educar_infra_predio_comodo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (566, 55, 2, 'Curso', 'educar_curso_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (567, 55, 2, 'Prdio Escola', 'educar_infra_predio_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (576, 55, 2, 'Calendrio Dia Motivo', 'educar_calendario_dia_motivo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (573, 55, 2, 'Habilitao', 'educar_habilitacao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (572, 55, 2, 'Funo Cmodo Prdio', 'educar_infra_comodo_funcao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (575, 55, 2, 'Transferncia Tipo', 'educar_transferencia_tipo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (577, 55, 2, 'Tipo Dispensa Disciplina', 'educar_tipo_dispensa_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (578, 55, 2, 'Aluno', 'educar_aluno_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (579, 55, 2, 'Religio', 'educar_religiao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (559, 55, 2, 'Instituio', 'educar_instituicao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (580, 55, 2, 'Tipo Ocorrncia Disciplinar', 'educar_tipo_ocorrencia_disciplinar_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (581, 55, 2, 'Benefcio Aluno', 'educar_aluno_beneficio_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (583, 55, 2, 'Srie', 'educar_serie_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (631, 55, 2, 'Deficincia', 'educar_deficiencia_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (585, 55, 2, 'Escola Srie', 'educar_escola_serie_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (586, 55, 2, 'Turma', 'educar_turma_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (587, 55, 2, 'Seqncia Enturmao', 'educar_sequencia_serie_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (620, 55, 2, 'Calendrio', 'educar_calendario_ano_letivo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (624, 55, 2, 'Apresentao', 'educar_index.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (584, 55, 2, 'Mdulo', 'educar_modulo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (632, 55, 2, 'Escolaridade', 'educar_escolaridade_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (633, 55, 2, 'Motivo de Afastamento', 'educar_motivo_afastamento_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (634, 55, 2, 'Funo Servidor', 'educar_funcao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (635, 55, 2, 'Servidor', 'educar_servidor_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (639, 55, 2, 'Reserva Vaga', 'educar_reserva_vaga_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (641, 55, 2, 'Quadro de Horrio', 'educar_quadro_horario_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (642, 55, 2, 'Faltas/Notas Aluno', 'educar_falta_nota_aluno_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (647, 55, 2, 'Rede Ensino', 'educar_escola_rede_ensino_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (650, 55, 2, 'Nota Turma', 'educar_turma_mvto_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (654, 55, 2, 'Controle Desempenho de Alunos', 'educar_relatorio_controle_bim_desempenho.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (653, 55, 2, 'Demonstrativo Alunos Defasados', 'educar_relatorio_demonstrativo_defasado.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (659, 55, 2, 'Enturmao', 'educar_matriculas_turma_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (661, 55, 2, 'Relatrio Movimentao Mensal de Alunos', 'educar_relatorio_mov_mensal_aluno.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (670, 55, 2, 'Dirio de Classe - Avaliaes', 'educar_relatorio_diario_classe_avaliacao.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (664, 55, 2, 'Dirio de Classe', 'educar_relatorio_diario_classe.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (674, 55, 2, 'Boletim Escolar', 'educar_relatorio_boletim.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (678, 55, 2, 'Raa', 'educar_raca_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (684, 55, 2, 'Relatrio de Alunos Enturmados', 'educar_relatorio_alunos_enturmados.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (685, 55, 2, 'Relatrio de Alunos No Enturmados', 'educar_relatorio_alunos_nao_enturmados.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (690, 55, 2, 'Relatrio Relao Professores', 'educar_relatorio_quadro_professores.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (711, 55, 2, 'Documentos Pendentes', 'educar_relatorio_documentos_pendentes.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (707, 55, 2, 'Alunos Matriculados - Sinttico', 'educar_relatorio_alunos_matriculados_sintetico.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (772, 55, 2, 'Quadro Sinttico Aluno', 'educar_relatorio_quadro_alunos_sintetico.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (774, 55, 2, 'Relatrio Alunos Idade x Sexo', 'educar_relatorio_quadro_idade_sexo_serie.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (786, 55, 2, 'Demonstrativo Alunos Defasados Geral', 'educar_relatorio_demonstrativo_defasado_geral.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (807, 55, 2, 'Espelho de Notas', 'educar_relatorio_alunos_nota_semestre.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (830, 55, 2, 'Relatrio Alunos Benefcios', 'educar_relatorio_alunos_beneficios.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (823, 55, 2, 'Resultado Final', 'educar_relatorio_resultado_final.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (825, 55, 2, 'Ficha de Leitura, Escrita', 'educar_relatorio_ficha_leitura.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (826, 55, 2, 'Acompanhamento Leitura', 'educar_relatorio_acompanhamento_leitura_livros.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (827, 55, 2, 'Professores por Disciplina', 'educar_relatorio_professor_disciplina.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (835, 55, 2, 'Relatrio Quadros de Horrio', 'educar_relatorio_quadro_horario.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (836, 55, 2, 'Relatorio de alunos por idade', 'educar_relatorio_alunos_idade.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (652, 55, 2, 'Relao de Alunos ANEEs', 'educar_relatorio_relacao_aluno_pnee_escola.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (845, 55, 2, 'Rematrcula Automtica', 'educar_avancar_mod_cad.php', 'Rematrcula Automtica', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (944, 55, 2, 'Demonstrativo Alunos Defasados Nominal', 'educar_alunos_defasados_nominal.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (930, 55, 2, 'Levantamento Alfab. e no Alfab.', 'educar_relatorio_alfabetizados.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (918, 55, 2, 'Ata Resultado Final', 'educar_relatorio_ata_resultado_final.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (917, 55, 2, 'Alunos 5 Avaliao', 'educar_relatorio_alunos_quinta_avaliacao.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (911, 55, 2, 'Ficha de Rematrcula', 'educar_relatorio_ficha_rematricula.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (916, 55, 2, 'Registro de Transferncias Expedidas', 'educar_relatorio_registro_transferencias.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (900, 55, 2, 'Relao de Alunos ANEEs Quantidade', 'educar_relatorio_relacao_qtd_aluno_pnee_escola.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (927, 55, 2, 'Dirio de Frequncia Temporrio', 'educar_relatorio_diario_classe_temp.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (933, 55, 2, 'Levantamento Turma Perodo', 'educar_relatorio_levantamento_turma_periodo_aluno.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (555, 56, 2, 'Usurio', 'educar_usuario_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (554, 56, 2, 'Tipo Usurio', 'educar_tipo_usuario_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (592, 57, 2, 'Assunto', 'educar_acervo_assunto_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (594, 57, 2, 'Autor', 'educar_acervo_autor_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (603, 57, 2, 'Cliente', 'educar_cliente_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (590, 57, 2, 'Idioma', 'educar_acervo_idioma_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (591, 57, 2, 'Biblioteca', 'educar_biblioteca_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (593, 57, 2, 'Coleo', 'educar_acervo_colecao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (595, 57, 2, 'Editora', 'educar_acervo_editora_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (596, 57, 2, 'Tipo de Cliente', 'educar_cliente_tipo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (597, 57, 2, 'Tipo Exemplar', 'educar_exemplar_tipo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (606, 57, 2, 'Exemplares', 'educar_exemplar_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (600, 57, 2, 'Motivo Baixa', 'educar_motivo_baixa_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (602, 57, 2, 'Situao', 'educar_situacao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (598, 57, 2, 'Obras', 'educar_acervo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (607, 57, 2, 'Motivo Suspenso', 'educar_motivo_suspensao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (608, 57, 2, 'Fonte', 'educar_fonte_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (609, 57, 2, 'Reservas', 'educar_reservas_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (622, 57, 2, 'Dvidas', 'educar_pagamento_multa_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (610, 57, 2, 'Emprstimo', 'educar_exemplar_emprestimo_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (625, 57, 2, 'Apresentao', 'educar_biblioteca_index.php', '', 2);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (628, 57, 2, 'Devoluo', 'educar_exemplar_devolucao_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (629, 57, 2, 'Dados Biblioteca', 'educar_biblioteca_dados_lst.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (696, 55, 2, 'Quadro Curricular', 'educar_relatorio_quadro_curricular.php', '', 3);
INSERT INTO portal.menu_submenu (cod_menu_submenu, ref_cod_menu_menu, cod_sistema, nm_submenu, arquivo, title, nivel) VALUES (693, 55, 2, 'Registro de Matrculas', 'educar_relatorio_registro_matriculas.php', '', 3);

-- Cria pases, estados e municpios
SET search_path TO public;

-- Desabilita triggers de FK para as tabelas pais, uf e municipio
UPDATE 
  pg_catalog.pg_class SET reltriggers = 0 
  WHERE 
    relname = 'pais' 
    AND relnamespace = 
    (SELECT oid FROM pg_catalog.pg_namespace WHERE
     pg_namespace.nspname = 'public');

UPDATE 
  pg_catalog.pg_class SET reltriggers = 0 
  WHERE 
    relname = 'uf' 
    AND relnamespace = 
    (SELECT oid FROM pg_catalog.pg_namespace WHERE
     pg_namespace.nspname = 'public');

UPDATE 
  pg_catalog.pg_class SET reltriggers = 0 
  WHERE 
    relname = 'municipio' 
    AND relnamespace = 
    (SELECT oid FROM pg_catalog.pg_namespace WHERE
     pg_namespace.nspname = 'public');

-- Pases
INSERT INTO pais (idpais, nome, geom) VALUES (1, 'Abissnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (2, 'Aores', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (3, 'Afar Francs', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (4, 'Afeganisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (5, 'Albnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (6, 'Alemanha', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (7, 'Alto Volta', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (8, 'Andorra', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (9, 'Angola', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (10, 'Antrtica Francesa', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (11, 'Antrtico Argentino', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (12, 'Antrtico Britnico, Territrio', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (13, 'Antrtico Chileno', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (14, 'Antrtico Noruegues', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (15, 'Antgua E. Dep. Barbuda', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (16, 'Antilhas Holandesas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (17, 'Aptrida', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (18, 'Arbia Saudita', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (19, 'Arglia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (20, 'Argentina', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (21, 'Armnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (22, 'Arquiplago de Bismark', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (23, 'Arquiplago Manahiki', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (24, 'Arquiplago Midway', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (25, 'Aruba', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (26, 'Ascenso e Tristo da Cunha,is', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (27, 'Ashmore e Cartier', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (28, 'Austrlia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (29, 'ustria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (30, 'Azerbaijo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (31, 'Bahrein', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (32, 'Bangladesh', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (33, 'Barbados', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (34, 'Bashkista', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (35, 'Bechuanalndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (36, 'Blgica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (37, 'Belize', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (38, 'Benin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (39, 'Bermudas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (40, 'Bhutan', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (41, 'Birmnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (42, 'Bolvia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (43, 'Bsnia Herzegovina', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (44, 'Botsuana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (45, 'Brasil', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (46, 'Brunei', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (47, 'Bulgria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (48, 'Burkina Fasso', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (49, 'Burundi', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (50, 'Buryat', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (51, 'Cabo Verde', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (52, 'Camares', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (53, 'Canad', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (54, 'Carlia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (55, 'Catar', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (56, 'Cazaquisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (57, 'Ceilo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (58, 'Ceuta e Melilla', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (59, 'Chade', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (60, 'Chechen Ingusth', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (61, 'Chile', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (62, 'China', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (63, 'China (taiwan)', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (64, 'Chipre', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (65, 'Chuvash', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (66, 'Cingapura', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (67, 'Colmbia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (68, 'Comunidade das Bahamas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (69, 'Comunidade Dominicana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (70, 'Congo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (71, 'Coria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (72, 'Costa do Marfim', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (73, 'Costa Rica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (74, 'Coveite', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (75, 'Crocia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (76, 'Cuba', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (77, 'Curaao', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (78, 'Dagesta', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (79, 'Daom', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (80, 'Dependncia de Ross', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (81, 'Dinamarca', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (82, 'Djibuti', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (83, 'Eire', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (84, 'Emirados rabes Unidos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (85, 'Equador', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (86, 'Esccia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (87, 'Eslovquia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (88, 'Eslovnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (89, 'Espanha', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (90, 'Estado da Cidade do Vaticano', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (91, 'Estados Assoc. das Antilhas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (92, 'Estados Unidos da Amrica (eua)', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (93, 'Estnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (94, 'Etipia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (95, 'Filipinas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (96, 'Finlndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (97, 'Frana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (98, 'Gmbia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (99, 'Gana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (100, 'Gaza', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (101, 'Gergia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (102, 'Gibraltar', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (103, 'Gorno Altai', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (104, 'Gr-bretanha', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (105, 'Granada', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (106, 'Grcia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (107, 'Groenlndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (108, 'Guam', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (109, 'Guatemala', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (110, 'Guiana Francesa', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (111, 'Guin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (112, 'Guin Bissau', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (113, 'Guin Equatorial', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (114, 'Holanda', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (115, 'Honduras', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (116, 'Honduras Britnicas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (117, 'Hong-kong', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (118, 'Hungria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (119, 'Iemen', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (120, 'Iemen do Sul', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (121, 'Ifni', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (122, 'Ilha Johnston e Sand', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (123, 'Ilha Milhos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (124, 'Ilhas Baker', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (125, 'Ilhas Baleares', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (126, 'Ilhas Canrias', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (127, 'Ilhas Canto e Enderburg', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (128, 'Ilhas Carolinas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (129, 'Ilhas Christmas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (130, 'Ilhas Comores', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (131, 'Ilhas Cook', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (132, 'Ilhas Cosmoledo (lomores)', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (133, 'Ilhas de Man', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (134, 'Ilhas do Canal', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (135, 'Ilhas do Pacfico', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (136, 'Ilhas Falklands', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (137, 'Ilhas Faroes', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (138, 'Ilhas Gilbert', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (139, 'Ilhas Guadalupe', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (140, 'Ilhas Howland e Jarvis', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (141, 'Ilhas Kingman Reef', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (142, 'Ilhas Linha', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (143, 'Ilhas Macdonal e Heard', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (144, 'Ilhas Macquaire', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (145, 'Ilhas Malvinas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (146, 'Ilhas Marianas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (147, 'Ilhas Marshall', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (148, 'Ilhas Niue', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (149, 'Ilhas Norfolk', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (150, 'Ilhas Nova Calednia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (151, 'Ilhas Novas Hebridas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (152, 'Ilhas Palau', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (153, 'Ilhas Pscoa', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (154, 'Ilhas Pitcairin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (155, 'Ilhas Salomo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (156, 'Ilhas Santa Cruz', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (157, 'Ilhas Serranas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (158, 'Ilhas Tokelau', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (159, 'Ilhas Turca', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (160, 'Ilhas Turks e Caicos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (161, 'Ilhas Virgens Americanas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (162, 'Ilhas Virgens Britnicas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (163, 'Ilhas Wake', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (164, 'Ilhas Wallis e Futuna', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (165, 'ndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (166, 'Indonsia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (167, 'Inglaterra', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (168, 'Ir', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (169, 'Iraque', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (170, 'Irlanda', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (171, 'Irlanda do Norte', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (172, 'Islndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (173, 'Israel', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (174, 'Itlia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (175, 'Iugoslvia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (176, 'Jamaica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (177, 'Japo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (178, 'Jordnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (179, 'Kabardino Balkar', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (180, 'Kalimatan', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (181, 'Kalmir', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (182, 'Kara Kalpak', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (183, 'Karachaevocherkess', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (184, 'Khakass', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (185, 'Kmer/camboja', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (186, 'Komi', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (187, 'Kuwait', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (188, 'Laos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (189, 'Lesoto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (190, 'Letnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (191, 'Lbano', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (192, 'Libria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (193, 'Lbia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (194, 'Liechtenstein', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (195, 'Litunia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (196, 'Luxemburgo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (197, 'Macau', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (198, 'Madagascar', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (199, 'Madeira', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (200, 'Malsia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (201, 'Malawi', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (202, 'Maldivas,is', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (203, 'Mali', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (204, 'Mari', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (205, 'Marrocos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (206, 'Martinica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (207, 'Mascate', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (208, 'Maurcio', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (209, 'Mauritnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (210, 'Mxico', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (211, 'Mianma', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (212, 'Moambique', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (213, 'Moldvia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (214, 'Mnaco', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (215, 'Monglia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (216, 'Monte Serrat', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (217, 'Montenegro', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (218, 'Nambia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (219, 'Nauru', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (220, 'Nepal', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (221, 'Nguane', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (222, 'Nicargua', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (223, 'Nigria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (224, 'Noruega', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (225, 'Nova Guin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (226, 'Nova Zelndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (227, 'Oman', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (228, 'Ossetia Setentrional', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (229, 'Pas de Gales', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (230, 'Pases Baixos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (231, 'Palestina', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (232, 'Panam', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (233, 'Panam - Zona do Canal', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (234, 'Papua Nova Guin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (235, 'Paquisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (236, 'Paraguai', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (237, 'Peru', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (238, 'Polinsia Francesa', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (239, 'Polnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (240, 'Porto Rico', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (241, 'Portugal', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (242, 'Praas Norte Africanas', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (243, 'Protetor do Sudoeste Africano', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (244, 'Qunia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (245, 'Quirguisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (246, 'Quitasueno', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (247, 'Repblica rabe do Egito', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (248, 'Repblica Centro Africana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (249, 'Repblica da frica do Sul', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (250, 'Repblica da Bielorrssia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (251, 'Repblica da Macednia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (252, 'Repblica de El Salvador', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (253, 'Repblica de Fiji', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (254, 'Repblica de Malta', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (255, 'Repblica do Gabo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (256, 'Repblica do Haiti', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (257, 'Repblica do Nger', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (258, 'Repblica Dominicana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (259, 'Repblica Guiana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (260, 'Repblica Tcheca', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (261, 'Reservado', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (262, 'Reservado', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (263, 'Reservado', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (264, 'Reservado', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (265, 'Reunio', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (266, 'Rodsia (zimbbwe)', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (267, 'Romnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (268, 'Roncador', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (269, 'Ruanda', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (270, 'Ruiquiu,is', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (271, 'Rssia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (272, 'Saara Espanhol', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (273, 'Sabah', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (274, 'Samoa Americana', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (275, 'Samoa Ocidental', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (276, 'San Marino', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (277, 'Santa Helena', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (278, 'Santa Lcia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (279, 'So Cristvo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (280, 'So Tom e Prncipe', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (281, 'So Vicente', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (282, 'Sarawak', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (283, 'Senegal', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (284, 'Sequin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (285, 'Serra Leoa', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (286, 'Srvia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (287, 'Seychelles', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (288, 'Sria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (289, 'Somlia, Repblica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (290, 'Sri-lanka', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (291, 'St. Pierre et Miquelon', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (292, 'Suazilndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (293, 'Sudo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (294, 'Sucia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (295, 'Sua', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (296, 'Suriname', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (297, 'Svalbard e Jan Mayer,is', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (298, 'Tadjiquisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (299, 'Tailndia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (300, 'Tanganica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (301, 'Tanznia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (302, 'Tartaria', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (303, 'Tchecoslovquia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (304, 'Terr. Antrtico da Austrlia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (305, 'Terras Austrais', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (306, 'Territ. Britnico do Oceano ndico', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (307, 'Territrio de Cocos', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (308, 'Territrio de Papua', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (309, 'Timor', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (310, 'Togo', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (311, 'Tonga', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (312, 'Transkei', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (313, 'Trgua, Estado', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (314, 'Trinidad e Tobago', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (315, 'Tunsia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (316, 'Turcomenisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (317, 'Turquia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (318, 'Tuvalu', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (319, 'Tuvin', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (320, 'Ucrnia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (321, 'Udmurt', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (322, 'Uganda', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (323, 'Unio Sovitica', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (324, 'Uruguai', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (325, 'Uzbequisto', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (326, 'Venezuela', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (327, 'Vietn do Norte', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (328, 'Vietn do Sul', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (329, 'Yakut', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (330, 'Zaire', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (331, 'Zmbia', NULL);
INSERT INTO pais (idpais, nome, geom) VALUES (332, 'Zimbbwe', NULL);

-- Municpios
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1, 'Alta Floresta D''oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2, 'Alto Alegre dos Parecis', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (3, 'Alto Paraiso', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (4, 'Alvorada D''oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (5, 'Ariquemes', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (6, 'Buritis', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (7, 'Cabixi', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (8, 'Cacaulandia', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (9, 'Cacoal', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (10, 'Campo Novo de Rondonia', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (11, 'Candeias do Jamari', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (12, 'Castanheiras', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (13, 'Cerejeiras', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (14, 'Chupinguaia', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (15, 'Colorado do Oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (16, 'Corumbiara', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (17, 'Costa Marques', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (18, 'Cujubim', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (19, 'Espigao D''oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (20, 'Governador Jorge Teixeira', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (21, 'Guajara-mirim', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (22, 'Itapua do Oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (23, 'Jaru', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (24, 'Ji-parana', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (25, 'Machadinho D''oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (26, 'Ministro Andreazza', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (27, 'Mirante da Serra', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (28, 'Monte Negro', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (29, 'Nova Brasilandia D''oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (30, 'Nova Mamore', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (31, 'Nova Uniao', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (32, 'Novo Horizonte do Oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (33, 'Ouro Preto do Oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (34, 'Parecis', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (35, 'Pimenta Bueno', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (36, 'Pimenteiras do Oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (37, 'Porto Velho', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (38, 'Presidente Medici', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (39, 'Primavera de Rondonia', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (40, 'Rio Crespo', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (41, 'Rolim de Moura', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (42, 'Santa Luzia D''oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (43, 'Sao Felipe D Oeste', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (44, 'Sao Francisco do Guapore', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (45, 'Sao Miguel do Guapore', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (46, 'Seringueiras', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (47, 'Teixeiropolis', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (48, 'Theobroma', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (49, 'Urupa', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (50, 'Vale do Anari', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (51, 'Vale do Paraiso', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (52, 'Vilhena', 'RO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (53, 'Acrelandia', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (54, 'Assis Brasil', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (55, 'Brasileia', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (56, 'Bujari', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (57, 'Capixaba', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (58, 'Cruzeiro do Sul', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (59, 'Epitaciolandia', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (60, 'Feijo', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (61, 'Jordao', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (62, 'Mancio Lima', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (63, 'Manoel Urbano', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (64, 'Marechal Thaumaturgo', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (65, 'Placido de Castro', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (66, 'Porto Acre', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (67, 'Porto Walter', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (68, 'Rio Branco', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (69, 'Rodrigues Alves', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (70, 'Santa Rosa do Purus', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (71, 'Sena Madureira', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (72, 'Senador Guiomard', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (73, 'Tarauaca', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (74, 'Xapuri', 'AC', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (75, 'Alvaraes', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (76, 'Amatura', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (77, 'Anama', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (78, 'Anori', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (79, 'Apui', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (80, 'Atalaia do Norte', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (81, 'Autazes', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (82, 'Barcelos', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (83, 'Barreirinha', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (84, 'Benjamin Constant', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (85, 'Beruri', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (86, 'Boa Vista do Ramos', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (87, 'Boca do Acre', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (88, 'Borba', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (89, 'Caapiranga', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (90, 'Canutama', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (91, 'Carauari', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (92, 'Careiro', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (93, 'Careiro da Varzea', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (94, 'Coari', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (95, 'Codajas', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (96, 'Eirunepe', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (97, 'Envira', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (98, 'Fonte Boa', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (99, 'Guajara', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (100, 'Humaita', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (101, 'Ipixuna', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (102, 'Iranduba', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (103, 'Itamarati', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (104, 'Itapiranga', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (105, 'Japura', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (106, 'Jurua', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (107, 'Jutai', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (108, 'Labrea', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (109, 'Manacapuru', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (110, 'Manaquiri', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (111, 'Manaus', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (112, 'Manicore', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (113, 'Maraa', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (114, 'Maues', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (115, 'Nhamunda', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (116, 'Nova Olinda do Norte', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (117, 'Novo Airao', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (118, 'Novo Aripuana', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (119, 'Parintins', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (120, 'Pauini', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (121, 'Presidente Figueiredo', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (122, 'Rio Preto da Eva', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (123, 'Santa Isabel do Rio Negro', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (124, 'Santo Antonio do Ica', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (125, 'Sao Gabriel da Cachoeira', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (126, 'Sao Paulo de Olivenca', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (127, 'Sao Sebastiao do Uatuma', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (128, 'Silves', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (129, 'Tabatinga', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (130, 'Tapaua', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (131, 'Tefe', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (132, 'Tonantins', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (133, 'Uarini', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (134, 'Urucara', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (135, 'Urucurituba', 'AM', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (136, 'Alto Alegre', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (137, 'Amajari', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (138, 'Boa Vista', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (139, 'Bonfim', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (140, 'Canta', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (141, 'Caracarai', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (142, 'Caroebe', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (143, 'Iracema', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (144, 'Mucajai', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (145, 'Normandia', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (146, 'Pacaraima', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (147, 'Rorainopolis', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (148, 'Sao Joao da Baliza', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (149, 'Sao Luiz', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (150, 'Uiramuta', 'RR', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (151, 'Abaetetuba', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (152, 'Abel Figueiredo', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (153, 'Acara', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (154, 'Afua', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (155, 'Agua Azul do Norte', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (156, 'Alenquer', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (157, 'Almeirim', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (158, 'Altamira', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (159, 'Anajas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (160, 'Ananindeua', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (161, 'Anapu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (162, 'Augusto Correa', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (163, 'Aurora do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (164, 'Aveiro', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (165, 'Bagre', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (166, 'Baiao', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (167, 'Bannach', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (168, 'Barcarena', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (169, 'Belem', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (170, 'Belterra', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (171, 'Benevides', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (172, 'Bom Jesus do Tocantins', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (173, 'Bonito', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (174, 'Braganca', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (175, 'Brasil Novo', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (176, 'Brejo Grande do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (177, 'Breu Branco', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (178, 'Breves', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (179, 'Bujaru', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (180, 'Cachoeira do Arari', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (181, 'Cachoeira do Piria', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (182, 'Cameta', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (183, 'Canaa dos Carajas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (184, 'Capanema', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (185, 'Capitao Poco', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (186, 'Castanhal', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (187, 'Chaves', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (188, 'Colares', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (189, 'Conceicao do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (190, 'Concordia do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (191, 'Cumaru do Norte', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (192, 'Curionopolis', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (193, 'Curralinho', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (194, 'Curua', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (195, 'Curuca', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (196, 'Dom Eliseu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (197, 'Eldorado dos Carajas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (198, 'Faro', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (199, 'Floresta do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (200, 'Garrafao do Norte', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (201, 'Goianesia do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (202, 'Gurupa', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (203, 'Igarape-acu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (204, 'Igarape-miri', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (205, 'Inhangapi', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (206, 'Ipixuna do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (207, 'Irituia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (208, 'Itaituba', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (209, 'Itupiranga', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (210, 'Jacareacanga', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (211, 'Jacunda', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (212, 'Juruti', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (213, 'Limoeiro do Ajuru', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (214, 'Mae do Rio', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (215, 'Magalhaes Barata', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (216, 'Maraba', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (217, 'Maracana', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (218, 'Marapanim', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (219, 'Marituba', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (220, 'Medicilandia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (221, 'Melgaco', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (222, 'Mocajuba', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (223, 'Moju', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (224, 'Monte Alegre', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (225, 'Muana', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (226, 'Nova Esperanca do Piria', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (227, 'Nova Ipixuna', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (228, 'Nova Timboteua', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (229, 'Novo Progresso', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (230, 'Novo Repartimento', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (231, 'Obidos', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (232, 'Oeiras do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (233, 'Oriximina', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (234, 'Ourem', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (235, 'Ourilandia do Norte', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (236, 'Pacaja', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (237, 'Palestina do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (238, 'Paragominas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (239, 'Parauapebas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (240, 'Pau D''arco', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (241, 'Peixe-boi', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (242, 'Picarra', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (243, 'Placas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (244, 'Ponta de Pedras', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (245, 'Portel', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (246, 'Porto de Moz', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (247, 'Prainha', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (248, 'Primavera', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (249, 'Quatipuru', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (250, 'Redencao', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (251, 'Rio Maria', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (252, 'Rondon do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (253, 'Ruropolis', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (254, 'Salinopolis', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (255, 'Salvaterra', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (256, 'Santa Barbara do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (257, 'Santa Cruz do Arari', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (258, 'Santa Isabel do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (259, 'Santa Luzia do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (260, 'Santa Maria das Barreiras', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (261, 'Santa Maria do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (262, 'Santana do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (263, 'Santarem', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (264, 'Santarem Novo', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (265, 'Santo Antonio do Taua', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (266, 'Sao Caetano de Odivelas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (267, 'Sao Domingos do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (268, 'Sao Domingos do Capim', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (269, 'Sao Felix do Xingu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (270, 'Sao Francisco do Para', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (271, 'Sao Geraldo do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (272, 'Sao Joao da Ponta', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (273, 'Sao Joao de Pirabas', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (274, 'Sao Joao do Araguaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (275, 'Sao Miguel do Guama', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (276, 'Sao Sebastiao da Boa Vista', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (277, 'Sapucaia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (278, 'Senador Jose Porfirio', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (279, 'Soure', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (280, 'Tailandia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (281, 'Terra Alta', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (282, 'Terra Santa', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (283, 'Tome-acu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (284, 'Tracuateua', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (285, 'Trairao', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (286, 'Tucuma', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (287, 'Tucurui', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (288, 'Ulianopolis', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (289, 'Uruara', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (290, 'Vigia', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (291, 'Viseu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (292, 'Vitoria do Xingu', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (293, 'Xinguara', 'PA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (294, 'Amapa', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (295, 'Calcoene', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (296, 'Cutias', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (297, 'Ferreira Gomes', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (298, 'Itaubal', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (299, 'Laranjal do Jari', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (300, 'Macapa', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (301, 'Mazagao', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (302, 'Oiapoque', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (303, 'Pedra Branca do Amapari', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (304, 'Porto Grande', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (305, 'Pracuuba', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (306, 'Santana', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (307, 'Serra do Navio', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (308, 'Tartarugalzinho', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (309, 'Vitoria do Jari', 'AP', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (310, 'Abreulandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (311, 'Aguiarnopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (312, 'Alianca do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (313, 'Almas', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (314, 'Alvorada', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (315, 'Ananas', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (316, 'Angico', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (317, 'Aparecida do Rio Negro', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (318, 'Aragominas', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (319, 'Araguacema', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (320, 'Araguacu', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (321, 'Araguaina', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (322, 'Araguana', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (323, 'Araguatins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (324, 'Arapoema', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (325, 'Arraias', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (326, 'Augustinopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (327, 'Aurora do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (328, 'Axixa do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (329, 'Babaculandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (330, 'Bandeirantes do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (331, 'Barra do Ouro', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (332, 'Barrolandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (333, 'Bernardo Sayao', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (334, 'Bom Jesus do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (335, 'Brasilandia do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (336, 'Brejinho de Nazare', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (337, 'Buriti do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (338, 'Cachoeirinha', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (339, 'Campos Lindos', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (340, 'Cariri do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (341, 'Carmolandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (342, 'Carrasco Bonito', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (343, 'Caseara', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (344, 'Centenario', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (345, 'Chapada da Natividade', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (346, 'Chapada de Areia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (347, 'Colinas do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (348, 'Colmeia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (349, 'Combinado', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (350, 'Conceicao do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (351, 'Couto de Magalhaes', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (352, 'Cristalandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (353, 'Crixas do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (354, 'Darcinopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (355, 'Dianopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (356, 'Divinopolis do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (357, 'Dois Irmaos do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (358, 'Duere', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (359, 'Esperantina', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (360, 'Fatima', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (361, 'Figueiropolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (362, 'Filadelfia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (363, 'Formoso do Araguaia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (364, 'Fortaleza do Tabocao', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (365, 'Goianorte', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (366, 'Goiatins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (367, 'Guarai', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (368, 'Gurupi', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (369, 'Ipueiras', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (370, 'Itacaja', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (371, 'Itaguatins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (372, 'Itapiratins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (373, 'Itapora do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (374, 'Jau do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (375, 'Juarina', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (376, 'Lagoa da Confusao', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (377, 'Lagoa do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (378, 'Lajeado', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (379, 'Lavandeira', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (380, 'Lizarda', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (381, 'Luzinopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (382, 'Marianopolis do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (383, 'Mateiros', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (384, 'Maurilandia do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (385, 'Miracema do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (386, 'Miranorte', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (387, 'Monte do Carmo', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (388, 'Monte Santo do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (389, 'Muricilandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (390, 'Natividade', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (391, 'Nazare', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (392, 'Nova Olinda', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (393, 'Nova Rosalandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (394, 'Novo Acordo', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (395, 'Novo Alegre', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (396, 'Novo Jardim', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (397, 'Oliveira de Fatima', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (398, 'Palmas', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (399, 'Palmeirante', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (400, 'Palmeiras do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (401, 'Palmeiropolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (402, 'Paraiso do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (403, 'Parana', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (404, 'Pau D''arco', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (405, 'Pedro Afonso', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (406, 'Peixe', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (407, 'Pequizeiro', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (408, 'Pindorama do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (409, 'Piraque', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (410, 'Pium', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (411, 'Ponte Alta do Bom Jesus', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (412, 'Ponte Alta do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (413, 'Porto Alegre do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (414, 'Porto Nacional', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (415, 'Praia Norte', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (416, 'Presidente Kennedy', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (417, 'Pugmil', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (418, 'Recursolandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (419, 'Riachinho', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (420, 'Rio da Conceicao', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (421, 'Rio dos Bois', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (422, 'Rio Sono', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (423, 'Sampaio', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (424, 'Sandolandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (425, 'Santa Fe do Araguaia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (426, 'Santa Maria do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (427, 'Santa Rita do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (428, 'Santa Rosa do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (429, 'Santa Tereza do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (430, 'Santa Terezinha do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (431, 'Sao Bento do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (432, 'Sao Felix do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (433, 'Sao Miguel do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (434, 'Sao Salvador do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (435, 'Sao Sebastiao do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (436, 'Sao Valerio da Natividade', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (437, 'Silvanopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (438, 'Sitio Novo do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (439, 'Sucupira', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (440, 'Taguatinga', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (441, 'Taipas do Tocantins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (442, 'Talisma', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (443, 'Tocantinia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (444, 'Tocantinopolis', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (445, 'Tupirama', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (446, 'Tupiratins', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (447, 'Wanderlandia', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (448, 'Xambioa', 'TO', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (449, 'Acailandia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (450, 'Afonso Cunha', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (451, 'Agua Doce do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (452, 'Alcantara', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (453, 'Aldeias Altas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (454, 'Altamira do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (455, 'Alto Alegre do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (456, 'Alto Alegre do Pindare', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (457, 'Alto Parnaiba', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (458, 'Amapa do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (459, 'Amarante do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (460, 'Anajatuba', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (461, 'Anapurus', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (462, 'Apicum-acu', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (463, 'Araguana', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (464, 'Araioses', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (465, 'Arame', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (466, 'Arari', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (467, 'Axixa', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (468, 'Bacabal', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (469, 'Bacabeira', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (470, 'Bacuri', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (471, 'Bacurituba', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (472, 'Balsas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (473, 'Barao de Grajau', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (474, 'Barra do Corda', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (475, 'Barreirinhas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (476, 'Bela Vista do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (477, 'Belagua', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (478, 'Benedito Leite', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (479, 'Bequimao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (480, 'Bernardo do Mearim', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (481, 'Boa Vista do Gurupi', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (482, 'Bom Jardim', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (483, 'Bom Jesus das Selvas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (484, 'Bom Lugar', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (485, 'Brejo', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (486, 'Brejo de Areia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (487, 'Buriti', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (488, 'Buriti Bravo', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (489, 'Buriticupu', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (490, 'Buritirana', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (491, 'Cachoeira Grande', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (492, 'Cajapio', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (493, 'Cajari', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (494, 'Campestre do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (495, 'Candido Mendes', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (496, 'Cantanhede', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (497, 'Capinzal do Norte', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (498, 'Carolina', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (499, 'Carutapera', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (500, 'Caxias', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (501, 'Cedral', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (502, 'Central do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (503, 'Centro do Guilherme', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (504, 'Centro Novo do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (505, 'Chapadinha', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (506, 'Cidelandia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (507, 'Codo', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (508, 'Coelho Neto', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (509, 'Colinas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (510, 'Conceicao do Lago-acu', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (511, 'Coroata', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (512, 'Cururupu', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (513, 'Davinopolis', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (514, 'Dom Pedro', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (515, 'Duque Bacelar', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (516, 'Esperantinopolis', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (517, 'Estreito', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (518, 'Feira Nova do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (519, 'Fernando Falcao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (520, 'Formosa da Serra Negra', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (521, 'Fortaleza dos Nogueiras', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (522, 'Fortuna', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (523, 'Godofredo Viana', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (524, 'Goncalves Dias', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (525, 'Governador Archer', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (526, 'Governador Edison Lobao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (527, 'Governador Eugenio Barros', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (528, 'Governador Luiz Rocha', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (529, 'Governador Newton Bello', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (530, 'Governador Nunes Freire', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (531, 'Graca Aranha', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (532, 'Grajau', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (533, 'Guimaraes', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (534, 'Humberto de Campos', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (535, 'Icatu', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (536, 'Igarape do Meio', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (537, 'Igarape Grande', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (538, 'Imperatriz', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (539, 'Itaipava do Grajau', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (540, 'Itapecuru Mirim', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (541, 'Itinga do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (542, 'Jatoba', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (543, 'Jenipapo dos Vieiras', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (544, 'Joao Lisboa', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (545, 'Joselandia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (546, 'Junco do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (547, 'Lago da Pedra', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (548, 'Lago do Junco', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (549, 'Lago dos Rodrigues', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (550, 'Lago Verde', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (551, 'Lagoa do Mato', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (552, 'Lagoa Grande do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (553, 'Lajeado Novo', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (554, 'Lima Campos', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (555, 'Loreto', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (556, 'Luis Domingues', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (557, 'Magalhaes de Almeida', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (558, 'Maracacume', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (559, 'Maraja do Sena', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (560, 'Maranhaozinho', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (561, 'Mata Roma', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (562, 'Matinha', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (563, 'Matoes', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (564, 'Matoes do Norte', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (565, 'Milagres do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (566, 'Mirador', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (567, 'Miranda do Norte', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (568, 'Mirinzal', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (569, 'Moncao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (570, 'Montes Altos', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (571, 'Morros', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (572, 'Nina Rodrigues', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (573, 'Nova Colinas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (574, 'Nova Iorque', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (575, 'Nova Olinda do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (576, 'Olho D''agua das Cunhas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (577, 'Olinda Nova do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (578, 'Paco do Lumiar', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (579, 'Palmeirandia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (580, 'Paraibano', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (581, 'Parnarama', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (582, 'Passagem Franca', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (583, 'Pastos Bons', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (584, 'Paulino Neves', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (585, 'Paulo Ramos', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (586, 'Pedreiras', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (587, 'Pedro do Rosario', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (588, 'Penalva', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (589, 'Peri Mirim', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (590, 'Peritoro', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (591, 'Pindare Mirim', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (592, 'Pinheiro', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (593, 'Pio Xii', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (594, 'Pirapemas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (595, 'Pocao de Pedras', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (596, 'Porto Franco', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (597, 'Porto Rico do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (598, 'Presidente Dutra', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (599, 'Presidente Juscelino', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (600, 'Presidente Medici', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (601, 'Presidente Sarney', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (602, 'Presidente Vargas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (603, 'Primeira Cruz', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (604, 'Raposa', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (605, 'Riachao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (606, 'Ribamar Fiquene', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (607, 'Rosario', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (608, 'Sambaiba', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (609, 'Santa Filomena do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (610, 'Santa Helena', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (611, 'Santa Ines', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (612, 'Santa Luzia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (613, 'Santa Luzia do Parua', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (614, 'Santa Quiteria do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (615, 'Santa Rita', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (616, 'Santana do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (617, 'Santo Amaro do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (618, 'Santo Antonio dos Lopes', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (619, 'Sao Benedito do Rio Preto', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (620, 'Sao Bento', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (621, 'Sao Bernardo', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (622, 'Sao Domingos do Azeitao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (623, 'Sao Domingos do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (624, 'Sao Felix de Balsas', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (625, 'Sao Francisco do Brejao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (626, 'Sao Francisco do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (627, 'Sao Joao Batista', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (628, 'Sao Joao do Caru', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (629, 'Sao Joao do Paraiso', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (630, 'Sao Joao do Soter', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (631, 'Sao Joao dos Patos', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (632, 'Sao Jose de Ribamar', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (633, 'Sao Jose dos Basilios', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (634, 'Sao Luis', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (635, 'Sao Luis Gonzaga do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (636, 'Sao Mateus do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (637, 'Sao Pedro da Agua Branca', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (638, 'Sao Pedro dos Crentes', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (639, 'Sao Raimundo das Mangabeiras', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (640, 'Sao Raimundo do Doca Bezerra', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (641, 'Sao Roberto', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (642, 'Sao Vicente Ferrer', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (643, 'Satubinha', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (644, 'Senador Alexandre Costa', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (645, 'Senador La Rocque', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (646, 'Serrano do Maranhao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (647, 'Sitio Novo', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (648, 'Sucupira do Norte', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (649, 'Sucupira do Riachao', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (650, 'Tasso Fragoso', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (651, 'Timbiras', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (652, 'Timon', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (653, 'Trizidela do Vale', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (654, 'Tufilandia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (655, 'Tuntum', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (656, 'Turiacu', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (657, 'Turilandia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (658, 'Tutoia', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (659, 'Urbano Santos', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (660, 'Vargem Grande', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (661, 'Viana', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (662, 'Vila Nova dos Martirios', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (663, 'Vitoria do Mearim', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (664, 'Vitorino Freire', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (665, 'Ze Doca', 'MA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (666, 'Acaua', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (667, 'Agricolandia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (668, 'Agua Branca', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (669, 'Alagoinha do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (670, 'Alegrete do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (671, 'Alto Longa', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (672, 'Altos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (673, 'Alvorada do Gurgueia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (674, 'Amarante', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (675, 'Angical do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (676, 'Anisio de Abreu', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (677, 'Antonio Almeida', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (678, 'Aroazes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (679, 'Aroeira do Itaim', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (680, 'Arraial', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (681, 'Assuncao do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (682, 'Avelino Lopes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (683, 'Baixa Grande do Ribeiro', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (684, 'Barra D Alcantara', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (685, 'Barras', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (686, 'Barreiras do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (687, 'Barro Duro', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (688, 'Batalha', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (689, 'Bela Vista do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (690, 'Belem do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (691, 'Beneditinos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (692, 'Bertolinia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (693, 'Betania do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (694, 'Boa Hora', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (695, 'Bocaina', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (696, 'Bom Jesus', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (697, 'Bom Principio do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (698, 'Bonfim do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (699, 'Boqueirao do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (700, 'Brasileira', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (701, 'Brejo do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (702, 'Buriti dos Lopes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (703, 'Buriti dos Montes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (704, 'Cabeceiras do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (705, 'Cajazeiras do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (706, 'Cajueiro da Praia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (707, 'Caldeirao Grande do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (708, 'Campinas do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (709, 'Campo Alegre do Fidalgo', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (710, 'Campo Grande do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (711, 'Campo Largo do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (712, 'Campo Maior', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (713, 'Canavieira', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (714, 'Canto do Buriti', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (715, 'Capitao de Campos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (716, 'Capitao Gervasio Oliveira', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (717, 'Caracol', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (718, 'Caraubas do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (719, 'Caridade do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (720, 'Castelo do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (721, 'Caxingo', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (722, 'Cocal', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (723, 'Cocal de Telha', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (724, 'Cocal dos Alves', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (725, 'Coivaras', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (726, 'Colonia do Gurgueia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (727, 'Colonia do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (728, 'Conceicao do Caninde', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (729, 'Coronel Jose Dias', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (730, 'Corrente', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (731, 'Cristalandia do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (732, 'Cristino Castro', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (733, 'Curimata', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (734, 'Currais', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (735, 'Curral Novo do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (736, 'Curralinhos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (737, 'Demerval Lobao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (738, 'Dirceu Arcoverde', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (739, 'Dom Expedito Lopes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (740, 'Dom Inocencio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (741, 'Domingos Mourao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (742, 'Elesbao Veloso', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (743, 'Eliseu Martins', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (744, 'Esperantina', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (745, 'Fartura do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (746, 'Flores do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (747, 'Floresta do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (748, 'Floriano', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (749, 'Francinopolis', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (750, 'Francisco Ayres', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (751, 'Francisco Macedo', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (752, 'Francisco Santos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (753, 'Fronteiras', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (754, 'Geminiano', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (755, 'Gilbues', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (756, 'Guadalupe', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (757, 'Guaribas', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (758, 'Hugo Napoleao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (759, 'Ilha Grande', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (760, 'Inhuma', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (761, 'Ipiranga do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (762, 'Isaias Coelho', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (763, 'Itainopolis', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (764, 'Itaueira', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (765, 'Jacobina do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (766, 'Jaicos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (767, 'Jardim do Mulato', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (768, 'Jatoba do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (769, 'Jerumenha', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (770, 'Joao Costa', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (771, 'Joaquim Pires', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (772, 'Joca Marques', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (773, 'Jose de Freitas', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (774, 'Juazeiro do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (775, 'Julio Borges', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (776, 'Jurema', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (777, 'Lagoa Alegre', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (778, 'Lagoa de Sao Francisco', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (779, 'Lagoa do Barro do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (780, 'Lagoa do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (781, 'Lagoa do Sitio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (782, 'Lagoinha do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (783, 'Landri Sales', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (784, 'Luis Correia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (785, 'Luzilandia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (786, 'Madeiro', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (787, 'Manoel Emidio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (788, 'Marcolandia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (789, 'Marcos Parente', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (790, 'Massape do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (791, 'Matias Olimpio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (792, 'Miguel Alves', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (793, 'Miguel Leao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (794, 'Milton Brandao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (795, 'Monsenhor Gil', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (796, 'Monsenhor Hipolito', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (797, 'Monte Alegre do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (798, 'Morro Cabeca No Tempo', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (799, 'Morro do Chapeu do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (800, 'Murici dos Portelas', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (801, 'Nazare do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (802, 'Nazria', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (803, 'Nossa Senhora de Nazare', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (804, 'Nossa Senhora dos Remedios', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (805, 'Nova Santa Rita', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (806, 'Novo Oriente do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (807, 'Novo Santo Antonio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (808, 'Oeiras', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (809, 'Olho D Agua do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (810, 'Padre Marcos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (811, 'Paes Landim', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (812, 'Pajeu do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (813, 'Palmeira do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (814, 'Palmeirais', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (815, 'Paqueta', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (816, 'Parnagua', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (817, 'Parnaiba', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (818, 'Passagem Franca do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (819, 'Patos do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (820, 'Pau D''arco do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (821, 'Paulistana', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (822, 'Pavussu', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (823, 'Pedro Ii', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (824, 'Pedro Laurentino', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (825, 'Picos', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (826, 'Pimenteiras', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (827, 'Pio Ix', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (828, 'Piracuruca', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (829, 'Piripiri', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (830, 'Porto', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (831, 'Porto Alegre do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (832, 'Prata do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (833, 'Queimada Nova', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (834, 'Redencao do Gurgueia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (835, 'Regeneracao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (836, 'Riacho Frio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (837, 'Ribeira do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (838, 'Ribeiro Goncalves', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (839, 'Rio Grande do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (840, 'Santa Cruz do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (841, 'Santa Cruz dos Milagres', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (842, 'Santa Filomena', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (843, 'Santa Luz', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (844, 'Santa Rosa do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (845, 'Santana do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (846, 'Santo Antonio de Lisboa', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (847, 'Santo Antonio dos Milagres', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (848, 'Santo Inacio do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (849, 'Sao Braz do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (850, 'Sao Felix do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (851, 'Sao Francisco de Assis do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (852, 'Sao Francisco do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (853, 'Sao Goncalo do Gurgueia', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (854, 'Sao Goncalo do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (855, 'Sao Joao da Canabrava', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (856, 'Sao Joao da Fronteira', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (857, 'Sao Joao da Serra', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (858, 'Sao Joao da Varjota', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (859, 'Sao Joao do Arraial', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (860, 'Sao Joao do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (861, 'Sao Jose do Divino', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (862, 'Sao Jose do Peixe', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (863, 'Sao Jose do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (864, 'Sao Juliao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (865, 'Sao Lourenco do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (866, 'Sao Luis do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (867, 'Sao Miguel da Baixa Grande', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (868, 'Sao Miguel do Fidalgo', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (869, 'Sao Miguel do Tapuio', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (870, 'Sao Pedro do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (871, 'Sao Raimundo Nonato', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (872, 'Sebastiao Barros', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (873, 'Sebastiao Leal', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (874, 'Sigefredo Pacheco', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (875, 'Simoes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (876, 'Simplicio Mendes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (877, 'Socorro do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (878, 'Sussuapara', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (879, 'Tamboril do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (880, 'Tanque do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (881, 'Teresina', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (882, 'Uniao', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (883, 'Urucui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (884, 'Valenca do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (885, 'Varzea Branca', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (886, 'Varzea Grande', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (887, 'Vera Mendes', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (888, 'Vila Nova do Piaui', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (889, 'Wall Ferraz', 'PI', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (890, 'Abaiara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (891, 'Acarape', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (892, 'Acarau', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (893, 'Acopiara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (894, 'Aiuaba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (895, 'Alcantaras', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (896, 'Altaneira', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (897, 'Alto Santo', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (898, 'Amontada', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (899, 'Antonina do Norte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (900, 'Apuiares', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (901, 'Aquiraz', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (902, 'Aracati', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (903, 'Aracoiaba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (904, 'Ararenda', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (905, 'Araripe', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (906, 'Aratuba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (907, 'Arneiroz', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (908, 'Assare', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (909, 'Aurora', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (910, 'Baixio', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (911, 'Banabuiu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (912, 'Barbalha', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (913, 'Barreira', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (914, 'Barro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (915, 'Barroquinha', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (916, 'Baturite', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (917, 'Beberibe', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (918, 'Bela Cruz', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (919, 'Boa Viagem', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (920, 'Brejo Santo', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (921, 'Camocim', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (922, 'Campos Sales', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (923, 'Caninde', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (924, 'Capistrano', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (925, 'Caridade', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (926, 'Carire', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (927, 'Caririacu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (928, 'Carius', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (929, 'Carnaubal', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (930, 'Cascavel', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (931, 'Catarina', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (932, 'Catunda', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (933, 'Caucaia', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (934, 'Cedro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (935, 'Chaval', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (936, 'Choro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (937, 'Chorozinho', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (938, 'Coreau', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (939, 'Crateus', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (940, 'Crato', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (941, 'Croata', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (942, 'Cruz', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (943, 'Deputado Irapuan Pinheiro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (944, 'Erere', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (945, 'Eusebio', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (946, 'Farias Brito', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (947, 'Forquilha', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (948, 'Fortaleza', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (949, 'Fortim', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (950, 'Frecheirinha', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (951, 'General Sampaio', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (952, 'Graca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (953, 'Granja', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (954, 'Granjeiro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (955, 'Groairas', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (956, 'Guaiuba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (957, 'Guaraciaba do Norte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (958, 'Guaramiranga', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (959, 'Hidrolandia', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (960, 'Horizonte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (961, 'Ibaretama', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (962, 'Ibiapina', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (963, 'Ibicuitinga', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (964, 'Icapui', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (965, 'Ico', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (966, 'Iguatu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (967, 'Independencia', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (968, 'Ipaporanga', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (969, 'Ipaumirim', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (970, 'Ipu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (971, 'Ipueiras', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (972, 'Iracema', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (973, 'Iraucuba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (974, 'Itaicaba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (975, 'Itaitinga', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (976, 'Itapage', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (977, 'Itapipoca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (978, 'Itapiuna', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (979, 'Itarema', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (980, 'Itatira', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (981, 'Jaguaretama', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (982, 'Jaguaribara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (983, 'Jaguaribe', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (984, 'Jaguaruana', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (985, 'Jardim', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (986, 'Jati', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (987, 'Jijoca de Jericoacoara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (988, 'Juazeiro do Norte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (989, 'Jucas', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (990, 'Lavras da Mangabeira', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (991, 'Limoeiro do Norte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (992, 'Madalena', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (993, 'Maracanau', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (994, 'Maranguape', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (995, 'Marco', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (996, 'Martinopole', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (997, 'Massape', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (998, 'Mauriti', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (999, 'Meruoca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1000, 'Milagres', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1001, 'Milha', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1002, 'Miraima', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1003, 'Missao Velha', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1004, 'Mombaca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1005, 'Monsenhor Tabosa', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1006, 'Morada Nova', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1007, 'Moraujo', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1008, 'Morrinhos', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1009, 'Mucambo', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1010, 'Mulungu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1011, 'Nova Olinda', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1012, 'Nova Russas', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1013, 'Novo Oriente', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1014, 'Ocara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1015, 'Oros', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1016, 'Pacajus', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1017, 'Pacatuba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1018, 'Pacoti', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1019, 'Pacuja', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1020, 'Palhano', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1021, 'Palmacia', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1022, 'Paracuru', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1023, 'Paraipaba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1024, 'Parambu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1025, 'Paramoti', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1026, 'Pedra Branca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1027, 'Penaforte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1028, 'Pentecoste', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1029, 'Pereiro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1030, 'Pindoretama', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1031, 'Piquet Carneiro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1032, 'Pires Ferreira', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1033, 'Poranga', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1034, 'Porteiras', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1035, 'Potengi', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1036, 'Potiretama', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1037, 'Quiterianopolis', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1038, 'Quixada', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1039, 'Quixelo', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1040, 'Quixeramobim', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1041, 'Quixere', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1042, 'Redencao', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1043, 'Reriutaba', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1044, 'Russas', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1045, 'Saboeiro', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1046, 'Salitre', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1047, 'Santa Quiteria', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1048, 'Santana do Acarau', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1049, 'Santana do Cariri', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1050, 'Sao Benedito', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1051, 'Sao Goncalo do Amarante', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1052, 'Sao Joao do Jaguaribe', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1053, 'Sao Luis do Curu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1054, 'Senador Pompeu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1055, 'Senador Sa', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1056, 'Sobral', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1057, 'Solonopole', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1058, 'Tabuleiro do Norte', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1059, 'Tamboril', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1060, 'Tarrafas', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1061, 'Taua', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1062, 'Tejucuoca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1063, 'Tiangua', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1064, 'Trairi', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1065, 'Tururu', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1066, 'Ubajara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1067, 'Umari', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1068, 'Umirim', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1069, 'Uruburetama', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1070, 'Uruoca', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1071, 'Varjota', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1072, 'Varzea Alegre', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1073, 'Vicosa do Ceara', 'CE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1074, 'Acari', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1075, 'Acu', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1076, 'Afonso Bezerra', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1077, 'Agua Nova', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1078, 'Alexandria', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1079, 'Almino Afonso', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1080, 'Alto do Rodrigues', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1081, 'Angicos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1082, 'Antonio Martins', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1083, 'Apodi', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1084, 'Areia Branca', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1085, 'Ares', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1086, 'Augusto Severo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1087, 'Baia Formosa', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1088, 'Barauna', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1089, 'Barcelona', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1090, 'Bento Fernandes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1091, 'Bodo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1092, 'Bom Jesus', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1093, 'Brejinho', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1094, 'Caicara do Norte', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1095, 'Caicara do Rio do Vento', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1096, 'Caico', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1097, 'Campo Redondo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1098, 'Canguaretama', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1099, 'Caraubas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1100, 'Carnauba dos Dantas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1101, 'Carnaubais', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1102, 'Ceara-mirim', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1103, 'Cerro Cora', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1104, 'Coronel Ezequiel', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1105, 'Coronel Joao Pessoa', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1106, 'Cruzeta', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1107, 'Currais Novos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1108, 'Doutor Severiano', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1109, 'Encanto', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1110, 'Equador', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1111, 'Espirito Santo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1112, 'Extremoz', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1113, 'Felipe Guerra', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1114, 'Fernando Pedroza', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1115, 'Florania', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1116, 'Francisco Dantas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1117, 'Frutuoso Gomes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1118, 'Galinhos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1119, 'Goianinha', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1120, 'Governador Dix-sept Rosado', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1121, 'Grossos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1122, 'Guamare', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1123, 'Ielmo Marinho', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1124, 'Ipanguacu', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1125, 'Ipueira', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1126, 'Itaja', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1127, 'Itau', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1128, 'Jacana', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1129, 'Jandaira', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1130, 'Janduis', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1131, 'Januario Cicco', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1132, 'Japi', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1133, 'Jardim de Angicos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1134, 'Jardim de Piranhas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1135, 'Jardim do Serido', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1136, 'Joao Camara', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1137, 'Joao Dias', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1138, 'Jose da Penha', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1139, 'Jucurutu', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1140, 'Jundia', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1141, 'Lagoa D''anta', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1142, 'Lagoa de Pedras', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1143, 'Lagoa de Velhos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1144, 'Lagoa Nova', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1145, 'Lagoa Salgada', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1146, 'Lajes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1147, 'Lajes Pintadas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1148, 'Lucrecia', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1149, 'Luis Gomes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1150, 'Macaiba', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1151, 'Macau', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1152, 'Major Sales', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1153, 'Marcelino Vieira', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1154, 'Martins', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1155, 'Maxaranguape', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1156, 'Messias Targino', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1157, 'Montanhas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1158, 'Monte Alegre', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1159, 'Monte das Gameleiras', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1160, 'Mossoro', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1161, 'Natal', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1162, 'Nisia Floresta', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1163, 'Nova Cruz', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1164, 'Olho-d''agua do Borges', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1165, 'Ouro Branco', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1166, 'Parana', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1167, 'Parau', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1168, 'Parazinho', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1169, 'Parelhas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1170, 'Parnamirim', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1171, 'Passa e Fica', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1172, 'Passagem', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1173, 'Patu', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1174, 'Pau dos Ferros', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1175, 'Pedra Grande', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1176, 'Pedra Preta', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1177, 'Pedro Avelino', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1178, 'Pedro Velho', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1179, 'Pendencias', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1180, 'Piloes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1181, 'Poco Branco', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1182, 'Portalegre', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1183, 'Porto do Mangue', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1184, 'Presidente Juscelino', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1185, 'Pureza', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1186, 'Rafael Fernandes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1187, 'Rafael Godeiro', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1188, 'Riacho da Cruz', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1189, 'Riacho de Santana', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1190, 'Riachuelo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1191, 'Rio do Fogo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1192, 'Rodolfo Fernandes', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1193, 'Ruy Barbosa', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1194, 'Santa Cruz', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1195, 'Santa Maria', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1196, 'Santana do Matos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1197, 'Santana do Serido', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1198, 'Santo Antonio', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1199, 'Sao Bento do Norte', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1200, 'Sao Bento do Trairi', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1201, 'Sao Fernando', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1202, 'Sao Francisco do Oeste', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1203, 'Sao Goncalo do Amarante', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1204, 'Sao Joao do Sabugi', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1205, 'Sao Jose de Mipibu', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1206, 'Sao Jose do Campestre', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1207, 'Sao Jose do Serido', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1208, 'Sao Miguel', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1209, 'Sao Miguel do Gostoso', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1210, 'Sao Paulo do Potengi', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1211, 'Sao Pedro', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1212, 'Sao Rafael', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1213, 'Sao Tome', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1214, 'Sao Vicente', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1215, 'Senador Eloi de Souza', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1216, 'Senador Georgino Avelino', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1217, 'Serra de Sao Bento', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1218, 'Serra do Mel', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1219, 'Serra Negra do Norte', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1220, 'Serrinha', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1221, 'Serrinha dos Pintos', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1222, 'Severiano Melo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1223, 'Sitio Novo', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1224, 'Taboleiro Grande', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1225, 'Taipu', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1226, 'Tangara', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1227, 'Tenente Ananias', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1228, 'Tenente Laurentino Cruz', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1229, 'Tibau', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1230, 'Tibau do Sul', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1231, 'Timbauba dos Batistas', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1232, 'Touros', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1233, 'Triunfo Potiguar', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1234, 'Umarizal', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1235, 'Upanema', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1236, 'Varzea', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1237, 'Venha-ver', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1238, 'Vera Cruz', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1239, 'Vicosa', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1240, 'Vila Flor', 'RN', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1241, 'Agua Branca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1242, 'Aguiar', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1243, 'Alagoa Grande', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1244, 'Alagoa Nova', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1245, 'Alagoinha', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1246, 'Alcantil', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1247, 'Algodao de Jandaira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1248, 'Alhandra', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1249, 'Amparo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1250, 'Aparecida', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1251, 'Aracagi', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1252, 'Arara', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1253, 'Araruna', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1254, 'Areia', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1255, 'Areia de Baraunas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1256, 'Areial', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1257, 'Aroeiras', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1258, 'Assuncao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1259, 'Baia da Traicao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1260, 'Bananeiras', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1261, 'Barauna', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1262, 'Barra de Santa Rosa', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1263, 'Barra de Santana', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1264, 'Barra de Sao Miguel', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1265, 'Bayeux', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1266, 'Belem', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1267, 'Belem do Brejo do Cruz', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1268, 'Bernardino Batista', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1269, 'Boa Ventura', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1270, 'Boa Vista', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1271, 'Bom Jesus', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1272, 'Bom Sucesso', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1273, 'Bonito de Santa Fe', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1274, 'Boqueirao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1275, 'Borborema', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1276, 'Brejo do Cruz', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1277, 'Brejo dos Santos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1278, 'Caapora', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1279, 'Cabaceiras', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1280, 'Cabedelo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1281, 'Cachoeira dos Indios', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1282, 'Cacimba de Areia', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1283, 'Cacimba de Dentro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1284, 'Cacimbas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1285, 'Caicara', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1286, 'Cajazeiras', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1287, 'Cajazeirinhas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1288, 'Caldas Brandao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1289, 'Camalau', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1290, 'Campina Grande', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1291, 'Campo de Santana', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1292, 'Capim', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1293, 'Caraubas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1294, 'Carrapateira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1295, 'Casserengue', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1296, 'Catingueira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1297, 'Catole do Rocha', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1298, 'Caturite', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1299, 'Conceicao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1300, 'Condado', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1301, 'Conde', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1302, 'Congo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1303, 'Coremas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1304, 'Coxixola', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1305, 'Cruz do Espirito Santo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1306, 'Cubati', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1307, 'Cuite', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1308, 'Cuite de Mamanguape', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1309, 'Cuitegi', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1310, 'Curral de Cima', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1311, 'Curral Velho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1312, 'Damiao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1313, 'Desterro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1314, 'Diamante', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1315, 'Dona Ines', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1316, 'Duas Estradas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1317, 'Emas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1318, 'Esperanca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1319, 'Fagundes', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1320, 'Frei Martinho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1321, 'Gado Bravo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1322, 'Guarabira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1323, 'Gurinhem', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1324, 'Gurjao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1325, 'Ibiara', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1326, 'Igaracy', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1327, 'Imaculada', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1328, 'Inga', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1329, 'Itabaiana', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1330, 'Itaporanga', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1331, 'Itapororoca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1332, 'Itatuba', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1333, 'Jacarau', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1334, 'Jerico', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1335, 'Joao Pessoa', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1336, 'Juarez Tavora', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1337, 'Juazeirinho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1338, 'Junco do Serido', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1339, 'Juripiranga', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1340, 'Juru', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1341, 'Lagoa', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1342, 'Lagoa de Dentro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1343, 'Lagoa Seca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1344, 'Lastro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1345, 'Livramento', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1346, 'Logradouro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1347, 'Lucena', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1348, 'Mae D''agua', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1349, 'Malta', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1350, 'Mamanguape', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1351, 'Manaira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1352, 'Marcacao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1353, 'Mari', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1354, 'Marizopolis', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1355, 'Massaranduba', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1356, 'Mataraca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1357, 'Matinhas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1358, 'Mato Grosso', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1359, 'Matureia', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1360, 'Mogeiro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1361, 'Montadas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1362, 'Monte Horebe', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1363, 'Monteiro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1364, 'Mulungu', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1365, 'Natuba', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1366, 'Nazarezinho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1367, 'Nova Floresta', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1368, 'Nova Olinda', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1369, 'Nova Palmeira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1370, 'Olho D''agua', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1371, 'Olivedos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1372, 'Ouro Velho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1373, 'Parari', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1374, 'Passagem', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1375, 'Patos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1376, 'Paulista', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1377, 'Pedra Branca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1378, 'Pedra Lavrada', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1379, 'Pedras de Fogo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1380, 'Pedro Regis', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1381, 'Pianco', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1382, 'Picui', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1383, 'Pilar', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1384, 'Piloes', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1385, 'Piloezinhos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1386, 'Pirpirituba', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1387, 'Pitimbu', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1388, 'Pocinhos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1389, 'Poco Dantas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1390, 'Poco de Jose de Moura', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1391, 'Pombal', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1392, 'Prata', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1393, 'Princesa Isabel', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1394, 'Puxinana', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1395, 'Queimadas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1396, 'Quixaba', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1397, 'Remigio', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1398, 'Riachao', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1399, 'Riachao do Bacamarte', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1400, 'Riachao do Poco', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1401, 'Riacho de Santo Antonio', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1402, 'Riacho dos Cavalos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1403, 'Rio Tinto', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1404, 'Salgadinho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1405, 'Salgado de Sao Felix', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1406, 'Santa Cecilia', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1407, 'Santa Cruz', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1408, 'Santa Helena', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1409, 'Santa Ines', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1410, 'Santa Luzia', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1411, 'Santa Rita', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1412, 'Santa Teresinha', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1413, 'Santana de Mangueira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1414, 'Santana dos Garrotes', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1415, 'Santarem', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1416, 'Santo Andre', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1417, 'Sao Bentinho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1418, 'Sao Bento', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1419, 'Sao Domingos de Pombal', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1420, 'Sao Domingos do Cariri', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1421, 'Sao Francisco', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1422, 'Sao Joao do Cariri', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1423, 'Sao Joao do Rio do Peixe', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1424, 'Sao Joao do Tigre', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1425, 'Sao Jose da Lagoa Tapada', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1426, 'Sao Jose de Caiana', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1427, 'Sao Jose de Espinharas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1428, 'Sao Jose de Piranhas', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1429, 'Sao Jose de Princesa', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1430, 'Sao Jose do Bonfim', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1431, 'Sao Jose do Brejo do Cruz', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1432, 'Sao Jose do Sabugi', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1433, 'Sao Jose dos Cordeiros', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1434, 'Sao Jose dos Ramos', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1435, 'Sao Mamede', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1436, 'Sao Miguel de Taipu', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1437, 'Sao Sebastiao de Lagoa de Roca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1438, 'Sao Sebastiao do Umbuzeiro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1439, 'Sao Vicente do Serido', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1440, 'Sape', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1441, 'Serra Branca', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1442, 'Serra da Raiz', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1443, 'Serra Grande', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1444, 'Serra Redonda', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1445, 'Serraria', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1446, 'Sertaozinho', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1447, 'Sobrado', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1448, 'Solanea', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1449, 'Soledade', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1450, 'Sossego', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1451, 'Sousa', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1452, 'Sume', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1453, 'Taperoa', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1454, 'Tavares', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1455, 'Teixeira', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1456, 'Tenorio', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1457, 'Triunfo', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1458, 'Uirauna', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1459, 'Umbuzeiro', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1460, 'Varzea', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1461, 'Vieiropolis', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1462, 'Vista Serrana', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1463, 'Zabele', 'PB', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1464, 'Abreu e Lima', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1465, 'Afogados da Ingazeira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1466, 'Afranio', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1467, 'Agrestina', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1468, 'Agua Preta', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1469, 'Aguas Belas', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1470, 'Alagoinha', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1471, 'Alianca', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1472, 'Altinho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1473, 'Amaraji', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1474, 'Angelim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1475, 'Aracoiaba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1476, 'Araripina', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1477, 'Arcoverde', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1478, 'Barra de Guabiraba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1479, 'Barreiros', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1480, 'Belem de Maria', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1481, 'Belem de Sao Francisco', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1482, 'Belo Jardim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1483, 'Betania', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1484, 'Bezerros', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1485, 'Bodoco', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1486, 'Bom Conselho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1487, 'Bom Jardim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1488, 'Bonito', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1489, 'Brejao', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1490, 'Brejinho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1491, 'Brejo da Madre de Deus', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1492, 'Buenos Aires', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1493, 'Buique', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1494, 'Cabo de Santo Agostinho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1495, 'Cabrobo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1496, 'Cachoeirinha', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1497, 'Caetes', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1498, 'Calcado', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1499, 'Calumbi', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1500, 'Camaragibe', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1501, 'Camocim de Sao Felix', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1502, 'Camutanga', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1503, 'Canhotinho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1504, 'Capoeiras', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1505, 'Carnaiba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1506, 'Carnaubeira da Penha', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1507, 'Carpina', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1508, 'Caruaru', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1509, 'Casinhas', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1510, 'Catende', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1511, 'Cedro', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1512, 'Cha de Alegria', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1513, 'Cha Grande', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1514, 'Condado', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1515, 'Correntes', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1516, 'Cortes', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1517, 'Cumaru', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1518, 'Cupira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1519, 'Custodia', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1520, 'Dormentes', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1521, 'Escada', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1522, 'Exu', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1523, 'Feira Nova', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1524, 'Fernando de Noronha', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1525, 'Ferreiros', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1526, 'Flores', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1527, 'Floresta', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1528, 'Frei Miguelinho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1529, 'Gameleira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1530, 'Garanhuns', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1531, 'Gloria do Goita', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1532, 'Goiana', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1533, 'Granito', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1534, 'Gravata', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1535, 'Iati', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1536, 'Ibimirim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1537, 'Ibirajuba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1538, 'Igarassu', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1539, 'Iguaraci', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1540, 'Inaja', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1541, 'Ingazeira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1542, 'Ipojuca', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1543, 'Ipubi', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1544, 'Itacuruba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1545, 'Itaiba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1546, 'Itamaraca', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1547, 'Itambe', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1548, 'Itapetim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1549, 'Itapissuma', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1550, 'Itaquitinga', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1551, 'Jaboatao dos Guararapes', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1552, 'Jaqueira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1553, 'Jatauba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1554, 'Jatoba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1555, 'Joao Alfredo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1556, 'Joaquim Nabuco', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1557, 'Jucati', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1558, 'Jupi', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1559, 'Jurema', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1560, 'Lagoa do Carro', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1561, 'Lagoa do Itaenga', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1562, 'Lagoa do Ouro', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1563, 'Lagoa dos Gatos', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1564, 'Lagoa Grande', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1565, 'Lajedo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1566, 'Limoeiro', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1567, 'Macaparana', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1568, 'Machados', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1569, 'Manari', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1570, 'Maraial', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1571, 'Mirandiba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1572, 'Moreilandia', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1573, 'Moreno', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1574, 'Nazare da Mata', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1575, 'Olinda', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1576, 'Orobo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1577, 'Oroco', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1578, 'Ouricuri', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1579, 'Palmares', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1580, 'Palmeirina', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1581, 'Panelas', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1582, 'Paranatama', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1583, 'Parnamirim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1584, 'Passira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1585, 'Paudalho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1586, 'Paulista', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1587, 'Pedra', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1588, 'Pesqueira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1589, 'Petrolandia', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1590, 'Petrolina', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1591, 'Pocao', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1592, 'Pombos', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1593, 'Primavera', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1594, 'Quipapa', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1595, 'Quixaba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1596, 'Recife', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1597, 'Riacho das Almas', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1598, 'Ribeirao', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1599, 'Rio Formoso', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1600, 'Saire', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1601, 'Salgadinho', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1602, 'Salgueiro', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1603, 'Saloa', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1604, 'Sanharo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1605, 'Santa Cruz', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1606, 'Santa Cruz da Baixa Verde', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1607, 'Santa Cruz do Capibaribe', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1608, 'Santa Filomena', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1609, 'Santa Maria da Boa Vista', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1610, 'Santa Maria do Cambuca', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1611, 'Santa Terezinha', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1612, 'Sao Benedito do Sul', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1613, 'Sao Bento do Una', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1614, 'Sao Caitano', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1615, 'Sao Joao', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1616, 'Sao Joaquim do Monte', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1617, 'Sao Jose da Coroa Grande', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1618, 'Sao Jose do Belmonte', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1619, 'Sao Jose do Egito', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1620, 'Sao Lourenco da Mata', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1621, 'Sao Vicente Ferrer', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1622, 'Serra Talhada', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1623, 'Serrita', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1624, 'Sertania', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1625, 'Sirinhaem', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1626, 'Solidao', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1627, 'Surubim', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1628, 'Tabira', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1629, 'Tacaimbo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1630, 'Tacaratu', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1631, 'Tamandare', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1632, 'Taquaritinga do Norte', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1633, 'Terezinha', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1634, 'Terra Nova', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1635, 'Timbauba', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1636, 'Toritama', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1637, 'Tracunhaem', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1638, 'Trindade', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1639, 'Triunfo', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1640, 'Tupanatinga', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1641, 'Tuparetama', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1642, 'Venturosa', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1643, 'Verdejante', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1644, 'Vertente do Lerio', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1645, 'Vertentes', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1646, 'Vicencia', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1647, 'Vitoria de Santo Antao', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1648, 'Xexeu', 'PE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1649, 'Agua Branca', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1650, 'Anadia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1651, 'Arapiraca', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1652, 'Atalaia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1653, 'Barra de Santo Antonio', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1654, 'Barra de Sao Miguel', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1655, 'Batalha', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1656, 'Belem', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1657, 'Belo Monte', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1658, 'Boca da Mata', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1659, 'Branquinha', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1660, 'Cacimbinhas', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1661, 'Cajueiro', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1662, 'Campestre', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1663, 'Campo Alegre', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1664, 'Campo Grande', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1665, 'Canapi', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1666, 'Capela', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1667, 'Carneiros', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1668, 'Cha Preta', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1669, 'Coite do Noia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1670, 'Colonia Leopoldina', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1671, 'Coqueiro Seco', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1672, 'Coruripe', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1673, 'Craibas', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1674, 'Delmiro Gouveia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1675, 'Dois Riachos', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1676, 'Estrela de Alagoas', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1677, 'Feira Grande', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1678, 'Feliz Deserto', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1679, 'Flexeiras', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1680, 'Girau do Ponciano', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1681, 'Ibateguara', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1682, 'Igaci', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1683, 'Igreja Nova', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1684, 'Inhapi', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1685, 'Jacare dos Homens', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1686, 'Jacuipe', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1687, 'Japaratinga', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1688, 'Jaramataia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1689, 'Jequia da Praia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1690, 'Joaquim Gomes', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1691, 'Jundia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1692, 'Junqueiro', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1693, 'Lagoa da Canoa', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1694, 'Limoeiro de Anadia', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1695, 'Maceio', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1696, 'Major Isidoro', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1697, 'Mar Vermelho', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1698, 'Maragogi', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1699, 'Maravilha', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1700, 'Marechal Deodoro', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1701, 'Maribondo', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1702, 'Mata Grande', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1703, 'Matriz de Camaragibe', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1704, 'Messias', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1705, 'Minador do Negrao', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1706, 'Monteiropolis', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1707, 'Murici', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1708, 'Novo Lino', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1709, 'Olho D''agua das Flores', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1710, 'Olho D''agua do Casado', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1711, 'Olho D''agua Grande', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1712, 'Olivenca', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1713, 'Ouro Branco', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1714, 'Palestina', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1715, 'Palmeira dos Indios', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1716, 'Pao de Acucar', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1717, 'Pariconha', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1718, 'Paripueira', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1719, 'Passo de Camaragibe', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1720, 'Paulo Jacinto', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1721, 'Penedo', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1722, 'Piacabucu', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1723, 'Pilar', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1724, 'Pindoba', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1725, 'Piranhas', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1726, 'Poco das Trincheiras', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1727, 'Porto Calvo', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1728, 'Porto de Pedras', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1729, 'Porto Real do Colegio', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1730, 'Quebrangulo', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1731, 'Rio Largo', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1732, 'Roteiro', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1733, 'Santa Luzia do Norte', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1734, 'Santana do Ipanema', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1735, 'Santana do Mundau', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1736, 'Sao Bras', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1737, 'Sao Jose da Laje', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1738, 'Sao Jose da Tapera', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1739, 'Sao Luis do Quitunde', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1740, 'Sao Miguel dos Campos', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1741, 'Sao Miguel dos Milagres', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1742, 'Sao Sebastiao', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1743, 'Satuba', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1744, 'Senador Rui Palmeira', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1745, 'Tanque D''arca', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1746, 'Taquarana', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1747, 'Teotonio Vilela', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1748, 'Traipu', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1749, 'Uniao dos Palmares', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1750, 'Vicosa', 'AL', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1751, 'Amparo de Sao Francisco', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1752, 'Aquidaba', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1753, 'Aracaju', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1754, 'Araua', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1755, 'Areia Branca', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1756, 'Barra dos Coqueiros', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1757, 'Boquim', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1758, 'Brejo Grande', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1759, 'Campo do Brito', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1760, 'Canhoba', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1761, 'Caninde de Sao Francisco', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1762, 'Capela', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1763, 'Carira', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1764, 'Carmopolis', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1765, 'Cedro de Sao Joao', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1766, 'Cristinapolis', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1767, 'Cumbe', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1768, 'Divina Pastora', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1769, 'Estancia', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1770, 'Feira Nova', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1771, 'Frei Paulo', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1772, 'Gararu', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1773, 'General Maynard', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1774, 'Gracho Cardoso', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1775, 'Ilha das Flores', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1776, 'Indiaroba', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1777, 'Itabaiana', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1778, 'Itabaianinha', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1779, 'Itabi', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1780, 'Itaporanga D''ajuda', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1781, 'Japaratuba', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1782, 'Japoata', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1783, 'Lagarto', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1784, 'Laranjeiras', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1785, 'Macambira', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1786, 'Malhada dos Bois', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1787, 'Malhador', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1788, 'Maruim', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1789, 'Moita Bonita', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1790, 'Monte Alegre de Sergipe', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1791, 'Muribeca', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1792, 'Neopolis', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1793, 'Nossa Senhora Aparecida', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1794, 'Nossa Senhora da Gloria', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1795, 'Nossa Senhora das Dores', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1796, 'Nossa Senhora de Lourdes', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1797, 'Nossa Senhora do Socorro', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1798, 'Pacatuba', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1799, 'Pedra Mole', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1800, 'Pedrinhas', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1801, 'Pinhao', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1802, 'Pirambu', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1803, 'Poco Redondo', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1804, 'Poco Verde', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1805, 'Porto da Folha', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1806, 'Propria', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1807, 'Riachao do Dantas', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1808, 'Riachuelo', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1809, 'Ribeiropolis', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1810, 'Rosario do Catete', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1811, 'Salgado', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1812, 'Santa Luzia do Itanhy', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1813, 'Santa Rosa de Lima', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1814, 'Santana do Sao Francisco', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1815, 'Santo Amaro das Brotas', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1816, 'Sao Cristovao', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1817, 'Sao Domingos', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1818, 'Sao Francisco', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1819, 'Sao Miguel do Aleixo', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1820, 'Simao Dias', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1821, 'Siriri', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1822, 'Telha', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1823, 'Tobias Barreto', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1824, 'Tomar do Geru', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1825, 'Umbauba', 'SE', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1826, 'Abaira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1827, 'Abare', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1828, 'Acajutiba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1829, 'Adustina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1830, 'Agua Fria', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1831, 'Aiquara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1832, 'Alagoinhas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1833, 'Alcobaca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1834, 'Almadina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1835, 'Amargosa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1836, 'Amelia Rodrigues', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1837, 'America Dourada', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1838, 'Anage', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1839, 'Andarai', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1840, 'Andorinha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1841, 'Angical', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1842, 'Anguera', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1843, 'Antas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1844, 'Antonio Cardoso', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1845, 'Antonio Goncalves', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1846, 'Apora', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1847, 'Apuarema', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1848, 'Aracas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1849, 'Aracatu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1850, 'Araci', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1851, 'Aramari', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1852, 'Arataca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1853, 'Aratuipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1854, 'Aurelino Leal', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1855, 'Baianopolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1856, 'Baixa Grande', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1857, 'Banzae', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1858, 'Barra', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1859, 'Barra da Estiva', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1860, 'Barra do Choca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1861, 'Barra do Mendes', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1862, 'Barra do Rocha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1863, 'Barreiras', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1864, 'Barro Alto', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1865, 'Barrocas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1866, 'Belmonte', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1867, 'Belo Campo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1868, 'Biritinga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1869, 'Boa Nova', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1870, 'Boa Vista do Tupim', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1871, 'Bom Jesus da Lapa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1872, 'Bom Jesus da Serra', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1873, 'Boninal', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1874, 'Bonito', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1875, 'Boquira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1876, 'Botupora', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1877, 'Brejoes', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1878, 'Brejolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1879, 'Brotas de Macaubas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1880, 'Brumado', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1881, 'Buerarema', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1882, 'Buritirama', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1883, 'Caatiba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1884, 'Cabaceiras do Paraguacu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1885, 'Cachoeira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1886, 'Cacule', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1887, 'Caem', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1888, 'Caetanos', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1889, 'Caetite', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1890, 'Cafarnaum', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1891, 'Cairu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1892, 'Caldeirao Grande', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1893, 'Camacan', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1894, 'Camacari', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1895, 'Camamu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1896, 'Campo Alegre de Lourdes', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1897, 'Campo Formoso', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1898, 'Canapolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1899, 'Canarana', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1900, 'Canavieiras', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1901, 'Candeal', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1902, 'Candeias', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1903, 'Candiba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1904, 'Candido Sales', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1905, 'Cansancao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1906, 'Canudos', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1907, 'Capela do Alto Alegre', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1908, 'Capim Grosso', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1909, 'Caraibas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1910, 'Caravelas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1911, 'Cardeal da Silva', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1912, 'Carinhanha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1913, 'Casa Nova', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1914, 'Castro Alves', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1915, 'Catolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1916, 'Catu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1917, 'Caturama', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1918, 'Central', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1919, 'Chorrocho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1920, 'Cicero Dantas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1921, 'Cipo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1922, 'Coaraci', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1923, 'Cocos', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1924, 'Conceicao da Feira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1925, 'Conceicao do Almeida', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1926, 'Conceicao do Coite', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1927, 'Conceicao do Jacuipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1928, 'Conde', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1929, 'Condeuba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1930, 'Contendas do Sincora', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1931, 'Coracao de Maria', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1932, 'Cordeiros', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1933, 'Coribe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1934, 'Coronel Joao Sa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1935, 'Correntina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1936, 'Cotegipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1937, 'Cravolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1938, 'Crisopolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1939, 'Cristopolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1940, 'Cruz das Almas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1941, 'Curaca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1942, 'Dario Meira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1943, 'Dias D''avila', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1944, 'Dom Basilio', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1945, 'Dom Macedo Costa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1946, 'Elisio Medrado', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1947, 'Encruzilhada', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1948, 'Entre Rios', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1949, 'Erico Cardoso', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1950, 'Esplanada', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1951, 'Euclides da Cunha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1952, 'Eunapolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1953, 'Fatima', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1954, 'Feira da Mata', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1955, 'Feira de Santana', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1956, 'Filadelfia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1957, 'Firmino Alves', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1958, 'Floresta Azul', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1959, 'Formosa do Rio Preto', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1960, 'Gandu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1961, 'Gaviao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1962, 'Gentio do Ouro', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1963, 'Gloria', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1964, 'Gongogi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1965, 'Governador Lomanto Junior', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1966, 'Governador Mangabeira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1967, 'Guajeru', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1968, 'Guanambi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1969, 'Guaratinga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1970, 'Heliopolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1971, 'Iacu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1972, 'Ibiassuce', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1973, 'Ibicarai', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1974, 'Ibicoara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1975, 'Ibicui', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1976, 'Ibipeba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1977, 'Ibipitanga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1978, 'Ibiquera', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1979, 'Ibirapitanga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1980, 'Ibirapua', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1981, 'Ibirataia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1982, 'Ibitiara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1983, 'Ibitita', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1984, 'Ibotirama', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1985, 'Ichu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1986, 'Igapora', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1987, 'Igrapiuna', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1988, 'Iguai', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1989, 'Ilheus', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1990, 'Inhambupe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1991, 'Ipecaeta', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1992, 'Ipiau', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1993, 'Ipira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1994, 'Ipupiara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1995, 'Irajuba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1996, 'Iramaia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1997, 'Iraquara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1998, 'Irara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (1999, 'Irece', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2000, 'Itabela', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2001, 'Itaberaba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2002, 'Itabuna', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2003, 'Itacare', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2004, 'Itaete', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2005, 'Itagi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2006, 'Itagiba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2007, 'Itagimirim', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2008, 'Itaguacu da Bahia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2009, 'Itaju do Colonia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2010, 'Itajuipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2011, 'Itamaraju', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2012, 'Itamari', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2013, 'Itambe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2014, 'Itanagra', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2015, 'Itanhem', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2016, 'Itaparica', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2017, 'Itape', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2018, 'Itapebi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2019, 'Itapetinga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2020, 'Itapicuru', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2021, 'Itapitanga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2022, 'Itaquara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2023, 'Itarantim', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2024, 'Itatim', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2025, 'Itirucu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2026, 'Itiuba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2027, 'Itororo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2028, 'Ituacu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2029, 'Itubera', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2030, 'Iuiu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2031, 'Jaborandi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2032, 'Jacaraci', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2033, 'Jacobina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2034, 'Jaguaquara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2035, 'Jaguarari', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2036, 'Jaguaripe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2037, 'Jandaira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2038, 'Jequie', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2039, 'Jeremoabo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2040, 'Jiquirica', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2041, 'Jitauna', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2042, 'Joao Dourado', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2043, 'Juazeiro', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2044, 'Jucurucu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2045, 'Jussara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2046, 'Jussari', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2047, 'Jussiape', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2048, 'Lafaiete Coutinho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2049, 'Lagoa Real', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2050, 'Laje', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2051, 'Lajedao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2052, 'Lajedinho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2053, 'Lajedo do Tabocal', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2054, 'Lamarao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2055, 'Lapao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2056, 'Lauro de Freitas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2057, 'Lencois', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2058, 'Licinio de Almeida', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2059, 'Livramento de Nossa Senhora', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2060, 'Luis Eduardo Magalhaes', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2061, 'Macajuba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2062, 'Macarani', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2063, 'Macaubas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2064, 'Macurure', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2065, 'Madre de Deus', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2066, 'Maetinga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2067, 'Maiquinique', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2068, 'Mairi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2069, 'Malhada', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2070, 'Malhada de Pedras', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2071, 'Manoel Vitorino', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2072, 'Mansidao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2073, 'Maracas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2074, 'Maragogipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2075, 'Marau', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2076, 'Marcionilio Souza', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2077, 'Mascote', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2078, 'Mata de Sao Joao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2079, 'Matina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2080, 'Medeiros Neto', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2081, 'Miguel Calmon', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2082, 'Milagres', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2083, 'Mirangaba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2084, 'Mirante', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2085, 'Monte Santo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2086, 'Morpara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2087, 'Morro do Chapeu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2088, 'Mortugaba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2089, 'Mucuge', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2090, 'Mucuri', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2091, 'Mulungu do Morro', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2092, 'Mundo Novo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2093, 'Muniz Ferreira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2094, 'Muquem de Sao Francisco', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2095, 'Muritiba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2096, 'Mutuipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2097, 'Nazare', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2098, 'Nilo Pecanha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2099, 'Nordestina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2100, 'Nova Canaa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2101, 'Nova Fatima', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2102, 'Nova Ibia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2103, 'Nova Itarana', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2104, 'Nova Redencao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2105, 'Nova Soure', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2106, 'Nova Vicosa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2107, 'Novo Horizonte', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2108, 'Novo Triunfo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2109, 'Olindina', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2110, 'Oliveira dos Brejinhos', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2111, 'Ouricangas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2112, 'Ourolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2113, 'Palmas de Monte Alto', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2114, 'Palmeiras', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2115, 'Paramirim', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2116, 'Paratinga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2117, 'Paripiranga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2118, 'Pau Brasil', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2119, 'Paulo Afonso', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2120, 'Pe de Serra', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2121, 'Pedrao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2122, 'Pedro Alexandre', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2123, 'Piata', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2124, 'Pilao Arcado', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2125, 'Pindai', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2126, 'Pindobacu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2127, 'Pintadas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2128, 'Pirai do Norte', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2129, 'Piripa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2130, 'Piritiba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2131, 'Planaltino', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2132, 'Planalto', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2133, 'Pocoes', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2134, 'Pojuca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2135, 'Ponto Novo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2136, 'Porto Seguro', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2137, 'Potiragua', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2138, 'Prado', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2139, 'Presidente Dutra', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2140, 'Presidente Janio Quadros', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2141, 'Presidente Tancredo Neves', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2142, 'Queimadas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2143, 'Quijingue', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2144, 'Quixabeira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2145, 'Rafael Jambeiro', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2146, 'Remanso', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2147, 'Retirolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2148, 'Riachao das Neves', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2149, 'Riachao do Jacuipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2150, 'Riacho de Santana', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2151, 'Ribeira do Amparo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2152, 'Ribeira do Pombal', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2153, 'Ribeirao do Largo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2154, 'Rio de Contas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2155, 'Rio do Antonio', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2156, 'Rio do Pires', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2157, 'Rio Real', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2158, 'Rodelas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2159, 'Ruy Barbosa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2160, 'Salinas da Margarida', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2161, 'Salvador', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2162, 'Santa Barbara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2163, 'Santa Brigida', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2164, 'Santa Cruz Cabralia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2165, 'Santa Cruz da Vitoria', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2166, 'Santa Ines', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2167, 'Santa Luzia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2168, 'Santa Maria da Vitoria', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2169, 'Santa Rita de Cassia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2170, 'Santa Teresinha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2171, 'Santaluz', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2172, 'Santana', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2173, 'Santanopolis', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2174, 'Santo Amaro', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2175, 'Santo Antonio de Jesus', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2176, 'Santo Estevao', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2177, 'Sao Desiderio', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2178, 'Sao Domingos', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2179, 'Sao Felipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2180, 'Sao Felix', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2181, 'Sao Felix do Coribe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2182, 'Sao Francisco do Conde', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2183, 'Sao Gabriel', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2184, 'Sao Goncalo dos Campos', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2185, 'Sao Jose da Vitoria', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2186, 'Sao Jose do Jacuipe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2187, 'Sao Miguel das Matas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2188, 'Sao Sebastiao do Passe', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2189, 'Sapeacu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2190, 'Satiro Dias', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2191, 'Saubara', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2192, 'Saude', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2193, 'Seabra', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2194, 'Sebastiao Laranjeiras', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2195, 'Senhor do Bonfim', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2196, 'Sento Se', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2197, 'Serra do Ramalho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2198, 'Serra Dourada', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2199, 'Serra Preta', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2200, 'Serrinha', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2201, 'Serrolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2202, 'Simoes Filho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2203, 'Sitio do Mato', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2204, 'Sitio do Quinto', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2205, 'Sobradinho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2206, 'Souto Soares', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2207, 'Tabocas do Brejo Velho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2208, 'Tanhacu', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2209, 'Tanque Novo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2210, 'Tanquinho', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2211, 'Taperoa', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2212, 'Tapiramuta', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2213, 'Teixeira de Freitas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2214, 'Teodoro Sampaio', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2215, 'Teofilandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2216, 'Teolandia', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2217, 'Terra Nova', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2218, 'Tremedal', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2219, 'Tucano', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2220, 'Uaua', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2221, 'Ubaira', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2222, 'Ubaitaba', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2223, 'Ubata', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2224, 'Uibai', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2225, 'Umburanas', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2226, 'Una', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2227, 'Urandi', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2228, 'Urucuca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2229, 'Utinga', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2230, 'Valenca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2231, 'Valente', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2232, 'Varzea da Roca', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2233, 'Varzea do Poco', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2234, 'Varzea Nova', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2235, 'Varzedo', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2236, 'Vera Cruz', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2237, 'Vereda', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2238, 'Vitoria da Conquista', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2239, 'Wagner', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2240, 'Wanderley', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2241, 'Wenceslau Guimaraes', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2242, 'Xique-xique', 'BA', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2243, 'Abadia dos Dourados', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2244, 'Abaete', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2245, 'Abre Campo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2246, 'Acaiaca', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2247, 'Acucena', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2248, 'Agua Boa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2249, 'Agua Comprida', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2250, 'Aguanil', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2251, 'Aguas Formosas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2252, 'Aguas Vermelhas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2253, 'Aimores', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2254, 'Aiuruoca', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2255, 'Alagoa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2256, 'Albertina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2257, 'Alem Paraiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2258, 'Alfenas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2259, 'Alfredo Vasconcelos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2260, 'Almenara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2261, 'Alpercata', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2262, 'Alpinopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2263, 'Alterosa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2264, 'Alto Caparao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2265, 'Alto Jequitiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2266, 'Alto Rio Doce', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2267, 'Alvarenga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2268, 'Alvinopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2269, 'Alvorada de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2270, 'Amparo do Serra', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2271, 'Andradas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2272, 'Andrelandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2273, 'Angelandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2274, 'Antonio Carlos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2275, 'Antonio Dias', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2276, 'Antonio Prado de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2277, 'Aracai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2278, 'Aracitaba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2279, 'Aracuai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2280, 'Araguari', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2281, 'Arantina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2282, 'Araponga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2283, 'Arapora', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2284, 'Arapua', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2285, 'Araujos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2286, 'Araxa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2287, 'Arceburgo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2288, 'Arcos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2289, 'Areado', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2290, 'Argirita', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2291, 'Aricanduva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2292, 'Arinos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2293, 'Astolfo Dutra', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2294, 'Ataleia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2295, 'Augusto de Lima', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2296, 'Baependi', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2297, 'Baldim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2298, 'Bambui', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2299, 'Bandeira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2300, 'Bandeira do Sul', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2301, 'Barao de Cocais', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2302, 'Barao de Monte Alto', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2303, 'Barbacena', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2304, 'Barra Longa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2305, 'Barroso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2306, 'Bela Vista de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2307, 'Belmiro Braga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2308, 'Belo Horizonte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2309, 'Belo Oriente', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2310, 'Belo Vale', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2311, 'Berilo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2312, 'Berizal', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2313, 'Bertopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2314, 'Betim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2315, 'Bias Fortes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2316, 'Bicas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2317, 'Biquinhas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2318, 'Boa Esperanca', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2319, 'Bocaina de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2320, 'Bocaiuva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2321, 'Bom Despacho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2322, 'Bom Jardim de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2323, 'Bom Jesus da Penha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2324, 'Bom Jesus do Amparo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2325, 'Bom Jesus do Galho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2326, 'Bom Repouso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2327, 'Bom Sucesso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2328, 'Bonfim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2329, 'Bonfinopolis de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2330, 'Bonito de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2331, 'Borda da Mata', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2332, 'Botelhos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2333, 'Botumirim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2334, 'Bras Pires', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2335, 'Brasilandia de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2336, 'Brasilia de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2337, 'Brasopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2338, 'Braunas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2339, 'Brumadinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2340, 'Bueno Brandao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2341, 'Buenopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2342, 'Bugre', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2343, 'Buritis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2344, 'Buritizeiro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2345, 'Cabeceira Grande', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2346, 'Cabo Verde', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2347, 'Cachoeira da Prata', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2348, 'Cachoeira de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2349, 'Cachoeira de Pajeu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2350, 'Cachoeira Dourada', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2351, 'Caetanopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2352, 'Caete', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2353, 'Caiana', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2354, 'Cajuri', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2355, 'Caldas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2356, 'Camacho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2357, 'Camanducaia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2358, 'Cambui', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2359, 'Cambuquira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2360, 'Campanario', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2361, 'Campanha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2362, 'Campestre', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2363, 'Campina Verde', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2364, 'Campo Azul', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2365, 'Campo Belo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2366, 'Campo do Meio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2367, 'Campo Florido', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2368, 'Campos Altos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2369, 'Campos Gerais', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2370, 'Cana Verde', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2371, 'Canaa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2372, 'Canapolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2373, 'Candeias', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2374, 'Cantagalo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2375, 'Caparao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2376, 'Capela Nova', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2377, 'Capelinha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2378, 'Capetinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2379, 'Capim Branco', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2380, 'Capinopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2381, 'Capitao Andrade', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2382, 'Capitao Eneas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2383, 'Capitolio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2384, 'Caputira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2385, 'Carai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2386, 'Caranaiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2387, 'Carandai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2388, 'Carangola', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2389, 'Caratinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2390, 'Carbonita', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2391, 'Careacu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2392, 'Carlos Chagas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2393, 'Carmesia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2394, 'Carmo da Cachoeira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2395, 'Carmo da Mata', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2396, 'Carmo de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2397, 'Carmo do Cajuru', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2398, 'Carmo do Paranaiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2399, 'Carmo do Rio Claro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2400, 'Carmopolis de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2401, 'Carneirinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2402, 'Carrancas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2403, 'Carvalhopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2404, 'Carvalhos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2405, 'Casa Grande', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2406, 'Cascalho Rico', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2407, 'Cassia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2408, 'Cataguases', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2409, 'Catas Altas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2410, 'Catas Altas da Noruega', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2411, 'Catuji', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2412, 'Catuti', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2413, 'Caxambu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2414, 'Cedro do Abaete', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2415, 'Central de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2416, 'Centralina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2417, 'Chacara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2418, 'Chale', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2419, 'Chapada do Norte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2420, 'Chapada Gaucha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2421, 'Chiador', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2422, 'Cipotanea', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2423, 'Claraval', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2424, 'Claro dos Pocoes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2425, 'Claudio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2426, 'Coimbra', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2427, 'Coluna', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2428, 'Comendador Gomes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2429, 'Comercinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2430, 'Conceicao da Aparecida', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2431, 'Conceicao da Barra de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2432, 'Conceicao das Alagoas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2433, 'Conceicao das Pedras', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2434, 'Conceicao de Ipanema', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2435, 'Conceicao do Mato Dentro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2436, 'Conceicao do Para', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2437, 'Conceicao do Rio Verde', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2438, 'Conceicao dos Ouros', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2439, 'Conego Marinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2440, 'Confins', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2441, 'Congonhal', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2442, 'Congonhas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2443, 'Congonhas do Norte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2444, 'Conquista', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2445, 'Conselheiro Lafaiete', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2446, 'Conselheiro Pena', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2447, 'Consolacao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2448, 'Contagem', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2449, 'Coqueiral', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2450, 'Coracao de Jesus', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2451, 'Cordisburgo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2452, 'Cordislandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2453, 'Corinto', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2454, 'Coroaci', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2455, 'Coromandel', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2456, 'Coronel Fabriciano', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2457, 'Coronel Murta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2458, 'Coronel Pacheco', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2459, 'Coronel Xavier Chaves', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2460, 'Corrego Danta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2461, 'Corrego do Bom Jesus', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2462, 'Corrego Fundo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2463, 'Corrego Novo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2464, 'Couto de Magalhaes de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2465, 'Crisolita', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2466, 'Cristais', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2467, 'Cristalia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2468, 'Cristiano Otoni', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2469, 'Cristina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2470, 'Crucilandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2471, 'Cruzeiro da Fortaleza', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2472, 'Cruzilia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2473, 'Cuparaque', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2474, 'Curral de Dentro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2475, 'Curvelo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2476, 'Datas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2477, 'Delfim Moreira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2478, 'Delfinopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2479, 'Delta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2480, 'Descoberto', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2481, 'Desterro de Entre Rios', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2482, 'Desterro do Melo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2483, 'Diamantina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2484, 'Diogo de Vasconcelos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2485, 'Dionisio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2486, 'Divinesia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2487, 'Divino', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2488, 'Divino das Laranjeiras', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2489, 'Divinolandia de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2490, 'Divinopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2491, 'Divisa Alegre', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2492, 'Divisa Nova', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2493, 'Divisopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2494, 'Dom Bosco', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2495, 'Dom Cavati', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2496, 'Dom Joaquim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2497, 'Dom Silverio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2498, 'Dom Vicoso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2499, 'Dona Eusebia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2500, 'Dores de Campos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2501, 'Dores de Guanhaes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2502, 'Dores do Indaia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2503, 'Dores do Turvo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2504, 'Doresopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2505, 'Douradoquara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2506, 'Durande', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2507, 'Eloi Mendes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2508, 'Engenheiro Caldas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2509, 'Engenheiro Navarro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2510, 'Entre Folhas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2511, 'Entre Rios de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2512, 'Ervalia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2513, 'Esmeraldas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2514, 'Espera Feliz', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2515, 'Espinosa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2516, 'Espirito Santo do Dourado', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2517, 'Estiva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2518, 'Estrela Dalva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2519, 'Estrela do Indaia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2520, 'Estrela do Sul', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2521, 'Eugenopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2522, 'Ewbank da Camara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2523, 'Extrema', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2524, 'Fama', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2525, 'Faria Lemos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2526, 'Felicio dos Santos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2527, 'Felisburgo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2528, 'Felixlandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2529, 'Fernandes Tourinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2530, 'Ferros', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2531, 'Fervedouro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2532, 'Florestal', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2533, 'Formiga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2534, 'Formoso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2535, 'Fortaleza de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2536, 'Fortuna de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2537, 'Francisco Badaro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2538, 'Francisco Dumont', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2539, 'Francisco Sa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2540, 'Franciscopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2541, 'Frei Gaspar', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2542, 'Frei Inocencio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2543, 'Frei Lagonegro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2544, 'Fronteira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2545, 'Fronteira dos Vales', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2546, 'Fruta de Leite', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2547, 'Frutal', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2548, 'Funilandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2549, 'Galileia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2550, 'Gameleiras', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2551, 'Glaucilandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2552, 'Goiabeira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2553, 'Goiana', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2554, 'Goncalves', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2555, 'Gonzaga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2556, 'Gouveia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2557, 'Governador Valadares', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2558, 'Grao Mogol', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2559, 'Grupiara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2560, 'Guanhaes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2561, 'Guape', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2562, 'Guaraciaba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2563, 'Guaraciama', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2564, 'Guaranesia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2565, 'Guarani', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2566, 'Guarara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2567, 'Guarda-mor', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2568, 'Guaxupe', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2569, 'Guidoval', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2570, 'Guimarania', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2571, 'Guiricema', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2572, 'Gurinhata', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2573, 'Heliodora', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2574, 'Iapu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2575, 'Ibertioga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2576, 'Ibia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2577, 'Ibiai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2578, 'Ibiracatu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2579, 'Ibiraci', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2580, 'Ibirite', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2581, 'Ibitiura de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2582, 'Ibituruna', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2583, 'Icarai de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2584, 'Igarape', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2585, 'Igaratinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2586, 'Iguatama', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2587, 'Ijaci', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2588, 'Ilicinea', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2589, 'Imbe de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2590, 'Inconfidentes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2591, 'Indaiabira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2592, 'Indianopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2593, 'Ingai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2594, 'Inhapim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2595, 'Inhauma', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2596, 'Inimutaba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2597, 'Ipaba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2598, 'Ipanema', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2599, 'Ipatinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2600, 'Ipiacu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2601, 'Ipuiuna', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2602, 'Irai de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2603, 'Itabira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2604, 'Itabirinha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2605, 'Itabirito', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2606, 'Itacambira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2607, 'Itacarambi', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2608, 'Itaguara', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2609, 'Itaipe', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2610, 'Itajuba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2611, 'Itamarandiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2612, 'Itamarati de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2613, 'Itambacuri', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2614, 'Itambe do Mato Dentro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2615, 'Itamogi', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2616, 'Itamonte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2617, 'Itanhandu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2618, 'Itanhomi', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2619, 'Itaobim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2620, 'Itapagipe', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2621, 'Itapecerica', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2622, 'Itapeva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2623, 'Itatiaiucu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2624, 'Itau de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2625, 'Itauna', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2626, 'Itaverava', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2627, 'Itinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2628, 'Itueta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2629, 'Ituiutaba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2630, 'Itumirim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2631, 'Iturama', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2632, 'Itutinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2633, 'Jaboticatubas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2634, 'Jacinto', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2635, 'Jacui', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2636, 'Jacutinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2637, 'Jaguaracu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2638, 'Jaiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2639, 'Jampruca', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2640, 'Janauba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2641, 'Januaria', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2642, 'Japaraiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2643, 'Japonvar', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2644, 'Jeceaba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2645, 'Jenipapo de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2646, 'Jequeri', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2647, 'Jequitai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2648, 'Jequitiba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2649, 'Jequitinhonha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2650, 'Jesuania', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2651, 'Joaima', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2652, 'Joanesia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2653, 'Joao Monlevade', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2654, 'Joao Pinheiro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2655, 'Joaquim Felicio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2656, 'Jordania', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2657, 'Jose Goncalves de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2658, 'Jose Raydan', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2659, 'Josenopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2660, 'Juatuba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2661, 'Juiz de Fora', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2662, 'Juramento', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2663, 'Juruaia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2664, 'Juvenilia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2665, 'Ladainha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2666, 'Lagamar', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2667, 'Lagoa da Prata', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2668, 'Lagoa dos Patos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2669, 'Lagoa Dourada', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2670, 'Lagoa Formosa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2671, 'Lagoa Grande', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2672, 'Lagoa Santa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2673, 'Lajinha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2674, 'Lambari', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2675, 'Lamim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2676, 'Laranjal', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2677, 'Lassance', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2678, 'Lavras', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2679, 'Leandro Ferreira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2680, 'Leme do Prado', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2681, 'Leopoldina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2682, 'Liberdade', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2683, 'Lima Duarte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2684, 'Limeira do Oeste', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2685, 'Lontra', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2686, 'Luisburgo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2687, 'Luislandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2688, 'Luminarias', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2689, 'Luz', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2690, 'Machacalis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2691, 'Machado', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2692, 'Madre de Deus de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2693, 'Malacacheta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2694, 'Mamonas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2695, 'Manga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2696, 'Manhuacu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2697, 'Manhumirim', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2698, 'Mantena', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2699, 'Mar de Espanha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2700, 'Maravilhas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2701, 'Maria da Fe', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2702, 'Mariana', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2703, 'Marilac', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2704, 'Mario Campos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2705, 'Maripa de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2706, 'Marlieria', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2707, 'Marmelopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2708, 'Martinho Campos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2709, 'Martins Soares', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2710, 'Mata Verde', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2711, 'Materlandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2712, 'Mateus Leme', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2713, 'Mathias Lobato', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2714, 'Matias Barbosa', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2715, 'Matias Cardoso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2716, 'Matipo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2717, 'Mato Verde', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2718, 'Matozinhos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2719, 'Matutina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2720, 'Medeiros', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2721, 'Medina', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2722, 'Mendes Pimentel', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2723, 'Merces', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2724, 'Mesquita', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2725, 'Minas Novas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2726, 'Minduri', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2727, 'Mirabela', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2728, 'Miradouro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2729, 'Mirai', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2730, 'Miravania', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2731, 'Moeda', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2732, 'Moema', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2733, 'Monjolos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2734, 'Monsenhor Paulo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2735, 'Montalvania', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2736, 'Monte Alegre de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2737, 'Monte Azul', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2738, 'Monte Belo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2739, 'Monte Carmelo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2740, 'Monte Formoso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2741, 'Monte Santo de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2742, 'Monte Siao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2743, 'Montes Claros', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2744, 'Montezuma', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2745, 'Morada Nova de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2746, 'Morro da Garca', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2747, 'Morro do Pilar', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2748, 'Munhoz', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2749, 'Muriae', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2750, 'Mutum', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2751, 'Muzambinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2752, 'Nacip Raydan', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2753, 'Nanuque', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2754, 'Naque', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2755, 'Natalandia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2756, 'Natercia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2757, 'Nazareno', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2758, 'Nepomuceno', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2759, 'Ninheira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2760, 'Nova Belem', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2761, 'Nova Era', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2762, 'Nova Lima', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2763, 'Nova Modica', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2764, 'Nova Ponte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2765, 'Nova Porteirinha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2766, 'Nova Resende', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2767, 'Nova Serrana', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2768, 'Nova Uniao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2769, 'Novo Cruzeiro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2770, 'Novo Oriente de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2771, 'Novorizonte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2772, 'Olaria', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2773, 'Olhos-d Agua', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2774, 'Olimpio Noronha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2775, 'Oliveira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2776, 'Oliveira Fortes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2777, 'Onca de Pitangui', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2778, 'Oratorios', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2779, 'Orizania', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2780, 'Ouro Branco', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2781, 'Ouro Fino', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2782, 'Ouro Preto', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2783, 'Ouro Verde de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2784, 'Padre Carvalho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2785, 'Padre Paraiso', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2786, 'Pai Pedro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2787, 'Paineiras', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2788, 'Pains', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2789, 'Paiva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2790, 'Palma', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2791, 'Palmopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2792, 'Papagaios', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2793, 'Para de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2794, 'Paracatu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2795, 'Paraguacu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2796, 'Paraisopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2797, 'Paraopeba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2798, 'Passa Quatro', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2799, 'Passa Tempo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2800, 'Passa Vinte', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2801, 'Passabem', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2802, 'Passos', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2803, 'Patis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2804, 'Patos de Minas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2805, 'Patrocinio', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2806, 'Patrocinio do Muriae', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2807, 'Paula Candido', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2808, 'Paulistas', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2809, 'Pavao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2810, 'Pecanha', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2811, 'Pedra Azul', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2812, 'Pedra Bonita', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2813, 'Pedra do Anta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2814, 'Pedra do Indaia', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2815, 'Pedra Dourada', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2816, 'Pedralva', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2817, 'Pedras de Maria da Cruz', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2818, 'Pedrinopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2819, 'Pedro Leopoldo', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2820, 'Pedro Teixeira', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2821, 'Pequeri', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2822, 'Pequi', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2823, 'Perdigao', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2824, 'Perdizes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2825, 'Perdoes', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2826, 'Periquito', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2827, 'Pescador', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2828, 'Piau', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2829, 'Piedade de Caratinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2830, 'Piedade de Ponte Nova', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2831, 'Piedade do Rio Grande', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2832, 'Piedade dos Gerais', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2833, 'Pimenta', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2834, 'Pingo D Agua', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2835, 'Pintopolis', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2836, 'Piracema', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2837, 'Pirajuba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2838, 'Piranga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2839, 'Pirangucu', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2840, 'Piranguinho', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2841, 'Pirapetinga', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2842, 'Pirapora', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 'I', NULL, 9);
INSERT INTO municipio (idmun, nome, sigla_uf, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, idpes_cad, data_rev, data_cad, origem_gravacao, operacao, idsis_rev, idsis_cad) VALUES (2843, 'Pirauba', 'MG', NULL, NULL, NULL, NULL, NULL, 'M', NULL, NULL, 1, NULL, 'NOW()', 'M', 