--
-- PostgreSQL database dump
--

SET client_encoding = 'LATIN1';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: acesso; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA acesso;


--
-- Name: alimentos; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA alimentos;


--
-- Name: cadastro; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA cadastro;


--
-- Name: consistenciacao; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA consistenciacao;


--
-- Name: historico; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA historico;


--
-- Name: modules; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA modules;


--
-- Name: pmiacoes; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA pmiacoes;


--
-- Name: pmicontrolesis; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA pmicontrolesis;


--
-- Name: pmidrh; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA pmidrh;


--
-- Name: pmieducar; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA pmieducar;


--
-- Name: pmiotopic; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA pmiotopic;


--
-- Name: portal; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA portal;


--
-- Name: urbano; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA urbano;


--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: -
--

CREATE PROCEDURAL LANGUAGE plpgsql;


SET search_path = public, pg_catalog;

--
-- Name: typ_idlog; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE typ_idlog AS (
	idlog integer
);


--
-- Name: typ_idpes; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE typ_idpes AS (
	idpes integer
);


SET search_path = alimentos, pg_catalog;

--
-- Name: fcn_calcular_qtde_cardapio(character varying, integer, integer, numeric); Type: FUNCTION; Schema: alimentos; Owner: -
--

CREATE FUNCTION fcn_calcular_qtde_cardapio(character varying, integer, integer, numeric) RETURNS character varying
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_cli ALIAS for $1;
  v_id_car ALIAS for $2;
  v_id_pro ALIAS for $3;
  v_qtde_per_capita ALIAS for $4;
  reg_unidade RECORD;
  v_inscritos char(1);
  v_correcao numeric:=0;
  v_coccao numeric:=0;
  v_qtde numeric:= 0;
  v_qtde_retorno varchar(20);
BEGIN
  SELECT INTO v_inscritos inscritos
  FROM alimentos.cliente
  WHERE alimentos.cliente.idcli = v_id_cli;
  SELECT INTO v_correcao,v_coccao fator_correcao,fator_coccao
  FROM alimentos.produto
  WHERE alimentos.produto.idpro = v_id_pro;
  FOR reg_unidade IN SELECT unf.num_inscritos as insc, unf.num_matriculados as matr
        FROM alimentos.cardapio_faixa_unidade car,
                     alimentos.unidade_faixa_etaria unf
        WHERE car.idfeu = unf.idfeu
        AND   car.idcar = v_id_car LOOP
    IF v_inscritos = 'S' THEN
      v_qtde := v_qtde + (v_qtde_per_capita * reg_unidade.insc * v_correcao * v_coccao);
    ELSE
      v_qtde := v_qtde + (v_qtde_per_capita * reg_unidade.matr * v_correcao * v_coccao);
    END IF;
  END LOOP;

  v_qtde_retorno := trim(to_char(v_qtde, '9999999999.99'));
  RETURN v_qtde_retorno;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_calcular_qtde_percapita(character varying, integer, integer, integer, integer); Type: FUNCTION; Schema: alimentos; Owner: -
--

CREATE FUNCTION fcn_calcular_qtde_percapita(character varying, integer, integer, integer, integer) RETURNS numeric
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_cli ALIAS for $1;
  v_id_uni ALIAS for $2;
  v_id_pro ALIAS for $3;
  v_data_inicial ALIAS for $4;
  v_data_final ALIAS for $5;
  v_sql_qtde_produto text;
  v_reg_qtde_produto RECORD;
  v_qtde_produto_periodo numeric;
  v_existe_unidade integer;
BEGIN
  v_sql_qtde_produto := 'SELECT car.dt_cardapio
    ,cap.quantidade as qtde
    ,car.idcar as idcar
  FROM alimentos.cardapio car
      ,alimentos.cardapio_produto cap
  WHERE car.idcar = cap.idcar
  AND cap.idpro = ' || v_id_pro || '
  AND car.finalizado = ''S''
  AND car.idcli = ''' ||  v_id_cli || '''
  AND TO_NUMBER(TO_CHAR(car.dt_cardapio,''YYYYMMDD''),''99999999'') BETWEEN ' || v_data_inicial || ' AND  ' || v_data_final;
  v_qtde_produto_periodo := 0;
  v_existe_unidade := 0;
  FOR v_reg_qtde_produto IN EXECUTE v_sql_qtde_produto LOOP
    --
    -- Verifica se o cardpio atende a unidade em questo
    --
    SELECT INTO v_existe_unidade distinct uni.iduni
    FROM alimentos.cardapio car
      ,alimentos.cardapio_faixa_unidade caf
      ,alimentos.unidade_atendida uni
      ,alimentos.unidade_faixa_etaria ufa
    WHERE car.idcar = caf.idcar
    AND caf.idfeu = ufa.idfeu
    AND ufa.iduni = uni.iduni
    AND uni.iduni = v_id_uni
    AND car.idcar = v_reg_qtde_produto.idcar;
    IF v_existe_unidade > 0 THEN
      v_qtde_produto_periodo := v_qtde_produto_periodo  + v_reg_qtde_produto.qtde;
    END IF;
  END LOOP;
  RETURN v_qtde_produto_periodo;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_calcular_qtde_unidade(character varying, integer, integer, numeric, integer, integer); Type: FUNCTION; Schema: alimentos; Owner: -
--

CREATE FUNCTION fcn_calcular_qtde_unidade(character varying, integer, integer, numeric, integer, integer) RETURNS numeric
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_cli ALIAS for $1;
  v_id_uni ALIAS for $2;
  v_id_pro ALIAS for $3;
  v_qtde_per_capita ALIAS for $4;
  v_data_inicial ALIAS for $5;
  v_data_final ALIAS for $6;
  v_reg_faixa RECORD;
  v_inscritos char(1);
  v_correcao numeric:=0;
  v_coccao numeric:=0;
  v_qtde numeric:= 0;
  v_peso numeric:=0;
  v_qtde_produto_periodo numeric:=0;
  v_num_inscritos integer;
  v_num_matriculados integer;
BEGIN
  SELECT INTO v_inscritos inscritos
  FROM alimentos.cliente
  WHERE alimentos.cliente.idcli = v_id_cli;
  SELECT INTO v_correcao,v_coccao,v_peso pro.fator_correcao, pro.fator_coccao, unp.peso
  FROM alimentos.produto pro, alimentos.unidade_produto unp
  WHERE   pro.idunp = unp.idunp
  AND unp.idcli = v_id_cli
  AND     pro.idpro = v_id_pro;
  --
  -- Obtm inscritos e matriculados para a unidade
  --
  v_num_inscritos:=0;
  v_num_matriculados:=0;
  FOR v_reg_faixa IN SELECT distinct ufa.idfae as idfae
      ,ufa.num_inscritos as num_inscritos
      ,ufa.num_matriculados as num_matriculados
    FROM  alimentos.cardapio car
      ,alimentos.cardapio_faixa_unidade caf
      ,alimentos.unidade_atendida uni
      ,alimentos.unidade_faixa_etaria ufa
    WHERE car.idcar = caf.idcar
    AND   caf.idfeu = ufa.idfeu
    AND ufa.iduni = uni.iduni
    AND     uni.iduni = v_id_uni
    AND     car.finalizado = 'S'
    AND car.idcli = v_id_cli
    AND TO_NUMBER(TO_CHAR(car.dt_cardapio,'YYYYMMDD'),'99999999') BETWEEN v_data_inicial AND v_data_final LOOP
    v_num_inscritos:=v_num_inscritos + v_reg_faixa.num_inscritos;
    v_num_matriculados:=v_num_matriculados + v_reg_faixa.num_matriculados;
  END LOOP;
  --
  -- Calcula a qtde percapita necessria do produto para o perodo
  --
  select INTO v_qtde_produto_periodo
  alimentos.fcn_calcular_qtde_percapita (v_id_cli,v_id_uni,v_id_pro,v_data_inicial,v_data_final);
  IF v_inscritos = 'S' THEN
    v_qtde := v_qtde_produto_periodo * v_num_inscritos * v_correcao * v_coccao;
  ELSE
    v_qtde := v_qtde_produto_periodo * v_num_matriculados * v_correcao * v_coccao;
  END IF;
  RETURN round(v_qtde/v_peso);
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_gerar_guia_remessa(text, text, integer, integer, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: alimentos; Owner: -
--

CREATE FUNCTION fcn_gerar_guia_remessa(text, text, integer, integer, character varying, character varying, character varying, integer) RETURNS text
    AS $_$DECLARE
   -- Parmetro recebidos
   v_array_fornecedor ALIAS for $1;
   v_array_unidade ALIAS for $2;
   v_data_inicial ALIAS for $3;
   v_data_final ALIAS for $4;
   v_classe ALIAS for $5;
   v_id_cliente ALIAS for $6;
   v_login ALIAS for $7;
   v_id_log ALIAS for $8;
   v_sql_unidade text;
   v_reg_unidade RECORD;
   v_reg_faixa RECORD;
   v_sql_produto text;
   v_reg_produto RECORD;
   v_sql_fornecedor text;
   v_reg_fornecedor RECORD;
   v_num_inscritos integer;
   v_num_matriculados integer;
   v_inscritos char(1);
   v_qtde_necessaria numeric;         -- quantidade total necessaria para o produto
   v_qtde_necessaria_saldo numeric;   -- saldo do produto a fornecer
   v_qtde_nec_saldo_ant numeric;      -- saldo anterior do produto
   v_qtde_guia_produto numeric;       -- qtde do produto com guia de remessa gerada
   v_qtde_disponivel numeric;         -- qtde total disponvel no(s) fornecedor(res)
   v_qtde_total_contrato numeric;     -- qtde total contratada com o fornecedor
   v_percentual_forn numeric;         -- percentual que pode ser fornecido pelo forn
   -- quantidade fornecida para o produto pelo fornecedor na guia
   v_qtde_forn numeric;
   v_qtde_guia integer:=0;
   v_qtde_produto_periodo numeric:=0; -- qtde de produto necessria para o perodo
              --(somatria da qtde percapita da receita)

   v_id_guia integer:=0;
   v_id_guia_produto integer:=0;
   v_sequencial integer:=0;         -- sequencial da guia de remessa gerada
   v_num_inscr_matr integer:=0;
   v_num_refeicao integer:=0;
   v_dt_cardapio_ini_x date;
   v_dt_cardapio_ini_y integer:=0;
   v_dt_cardapio_ini date;
   v_dt_cardapio_fim date;
   v_classe_aux VARCHAR(2);
   v_peso numeric;
   v_existe_forn integer:=0;
   v_existe_produto integer:=0;
   v_existe_estoque integer:=0;
   --v_id_log integer:=0;

BEGIN
   --
   -- Converte data numrica invertida para o formato DD/MM/YYYY
   --
   v_dt_cardapio_ini := TO_DATE(substr(TRIM(TO_CHAR(v_data_inicial,'99999999')),7,2)|| '/' || substr(TRIM(TO_CHAR(v_data_inicial,'99999999')),5,2)|| '/' || substr(TRIM(TO_CHAR(v_data_inicial,'99999999')),1,4),'DD/MM/YYYY');
   v_dt_cardapio_ini_x := v_dt_cardapio_ini;
   v_dt_cardapio_fim := TO_DATE(substr(TRIM(TO_CHAR(v_data_final,'99999999')),7,2)|| '/' || substr(TRIM(TO_CHAR(v_data_final,'99999999')),5,2)|| '/' || substr(TRIM(TO_CHAR(v_data_final,'99999999')),1,4),'DD/MM/YYYY');
   --
   -- INSERE LOG
   --
   --v_id_log:=nextval('alimentos.log_guia_remessa_idlogguia_seq'::text);
   INSERT INTO alimentos.log_guia_remessa
    (idlogguia
    ,login
    ,idcli
    ,dt_inicial
    ,dt_final
    ,unidade
    ,fornecedor
    ,classe
    ,dt_geracao
    ,mensagem)
  VALUES
    (v_id_log
    ,v_login
    ,v_id_cliente
    ,v_dt_cardapio_ini
    ,v_dt_cardapio_fim
    ,v_array_unidade
    ,v_array_fornecedor
    ,v_classe
    ,CURRENT_TIMESTAMP
    ,'*** INCIO ***');
   --
   -- Obtm indicao de inscritos ou matriculados para o cliente
   --
   SELECT INTO v_inscritos inscritos
   FROM alimentos.cliente
   WHERE alimentos.cliente.idcli = v_id_cliente;
   RAISE NOTICE 'Inscritos(%)',v_inscritos;
   --
   -- GRAVA LOG
   --
   UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n Inscritos: ' || v_inscritos WHERE idlogguia = v_id_log;
   --
   -- Obtm o nmero de tipos de refeies que sero atendidas
   -- (total caf da manh, total almoo, etc)
   --
   SELECT INTO v_num_refeicao COUNT(distinct idtre)
   FROM alimentos.cardapio car
   WHERE car.idcli = v_id_cliente
   AND car.finalizado = 'S'
   AND TO_NUMBER(TO_CHAR(car.dt_cardapio,'YYYYMMDD'),'99999999') BETWEEN v_data_inicial AND v_data_final;
   WHILE v_dt_cardapio_ini_x <= v_dt_cardapio_fim LOOP

      RAISE NOTICE '---------------->>1 Loop Data(%)',v_dt_cardapio_ini_x;

      --
      -- GRAVA LOG
      --
      UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      ----- 1 Loop Data ' || TO_CHAR(v_dt_cardapio_ini_x,'DD/MM/YYYY') || ' -----' WHERE idlogguia = v_id_log;
      --
      -- Prepara SELECT para obter as unidades que atendem aos filtros informados
      --
      v_sql_unidade := 'SELECT distinct uni.iduni as iduni
      ,TRIM(uni.nome) as nome
      FROM alimentos.cardapio car
       ,alimentos.cardapio_faixa_unidade caf
       ,alimentos.unidade_atendida uni
       ,alimentos.unidade_faixa_etaria ufa
      WHERE car.idcar = caf.idcar
      AND caf.idfeu = ufa.idfeu
      AND ufa.iduni = uni.iduni';

      IF v_array_unidade <> '0' THEN
         v_sql_unidade := v_sql_unidade || ' AND uni.iduni IN (' || v_array_unidade || ')';
      END IF;

      v_sql_unidade := v_sql_unidade || ' AND car.finalizado = ''S''
      AND car.idcli = ''' || v_id_cliente || '''
      AND car.dt_cardapio = ''' || v_dt_cardapio_ini_x || '''';

      --
      -- Executa SELECT para obter as unidades
      --
      FOR v_reg_unidade IN EXECUTE v_sql_unidade LOOP

         RAISE NOTICE '                                          ';
         RAISE NOTICE '2 Loop Unidade(%)',v_reg_unidade.nome;

         --
         -- GRAVA LOG
         --
         UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      ----- 2 Loop Unidade ' || TRIM(TO_CHAR(v_reg_unidade.iduni, '9999999999')) || '-' || v_reg_unidade.nome || ' -----' WHERE idlogguia = v_id_log;
         v_num_inscritos:=0;
   v_num_matriculados:=0;

         --
         -- Obtm inscritos e matriculados para a unidade
         --

         FOR v_reg_faixa IN SELECT distinct ufa.idfae as idfae
                   ,ufa.num_inscritos as num_inscritos
             ,ufa.num_matriculados as num_matriculados
      FROM alimentos.cardapio car
    ,alimentos.cardapio_faixa_unidade caf
    ,alimentos.unidade_atendida uni
    ,alimentos.unidade_faixa_etaria ufa
      WHERE car.idcar = caf.idcar
      AND caf.idfeu = ufa.idfeu
      AND ufa.iduni = uni.iduni
      AND uni.iduni = v_reg_unidade.iduni
      AND car.finalizado = 'S'
      AND car.idcli = v_id_cliente
      AND car.dt_cardapio = v_dt_cardapio_ini_x LOOP

            v_num_inscritos:=v_num_inscritos + v_reg_faixa.num_inscritos;
      v_num_matriculados:=v_num_matriculados + v_reg_faixa.num_matriculados;

   END LOOP;
   RAISE NOTICE 'Inscritos(%)',v_num_inscritos;
   RAISE NOTICE 'Matriculados(%)',v_num_matriculados;

         --
         -- GRAVA LOG
         --
         UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      N Inscritos: ' || TRIM(TO_CHAR(v_num_inscritos, '9999999999')) WHERE idlogguia = v_id_log;
   UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      N Matriculados: ' || TRIM(TO_CHAR(v_num_matriculados, '9999999999')) WHERE idlogguia = v_id_log;
   --
   -- Prepara SELECT para carregar produtos existentes no cardpio
   --
         v_sql_produto := 'SELECT distinct cap.idpro as idpro
        ,cap.quantidade as qtde
        ,pro.fator_correcao as fator_correcao
        ,pro.fator_coccao as fator_coccao
        ,TRIM(pro.nome_compra) as nome_compra
        ,unp.peso as peso
      FROM  alimentos.cardapio car
        ,alimentos.cardapio_produto cap
        ,alimentos.produto pro
        ,alimentos.unidade_produto unp
        ,alimentos.cardapio_faixa_unidade caf
        ,alimentos.unidade_atendida uni
        ,alimentos.unidade_faixa_etaria ufa
      WHERE car.idcar = cap.idcar
      AND cap.idpro = pro.idpro
      AND     pro.idunp = unp.idunp
      AND     unp.idcli = ''' || v_id_cliente || '''
      AND car.idcar = caf.idcar
      AND   caf.idfeu = ufa.idfeu
      AND ufa.iduni = uni.iduni';
   IF v_classe is not null THEN
      v_sql_produto := v_sql_produto || ' AND pro.classe = ''' || v_classe || '''';
         END IF;

         --
   -- Seleciona somente os produtos do cardpio que o fornecedor
         -- pode fornecedor
   --
         IF v_array_fornecedor <> '0' THEN
      v_sql_produto := v_sql_produto || ' AND pro.idpro IN (
         SELECT cop.idpro
            FROM alimentos.contrato con
          ,alimentos.contrato_produto cop
                  WHERE cop.idcon = con.idcon
                AND con.cancelado = ''N''
                AND con.finalizado = ''S''
                AND con.ultimo_contrato = ''S''
                AND con.idfor IN (' || v_array_fornecedor || ')
                  AND cop.qtde_remessa < cop.qtde_contratada
                  AND cop.idpro = pro.idpro)';
         END IF;

         v_sql_produto := v_sql_produto || '
      AND uni.iduni = ' || v_reg_unidade.iduni || '
            AND car.finalizado = ''S''
            AND car.idcli = ''' || v_id_cliente || '''
            AND car.dt_cardapio = ''' || v_dt_cardapio_ini_x || '''
            ORDER BY TRIM(pro.nome_compra)';

         --
         -- Obtm os produtos do cardpio utilizados pela unidade
         --

         FOR v_reg_produto IN EXECUTE v_sql_produto LOOP

            RAISE NOTICE '                                          ';
            RAISE NOTICE '3 Loop Produto(%)',v_reg_produto.nome_compra;

            --
            -- GRAVA LOG
            --
            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n      3 Loop Produto ' || TRIM(TO_CHAR(v_reg_produto.idpro, '9999999999')) || '-' || v_reg_produto.nome_compra WHERE idlogguia = v_id_log;

            v_existe_produto := v_existe_produto + 1;

            --
            -- Calcula a qtde percapita necessria do produto para o perodo
            --

            v_dt_cardapio_ini_y := TO_NUMBER(TO_CHAR(v_dt_cardapio_ini_x, 'YYYYMMDD'),'99999999');

            select INTO v_qtde_produto_periodo alimentos.fcn_calcular_qtde_percapita (v_id_cliente, v_reg_unidade.iduni, v_reg_produto.idpro, v_dt_cardapio_ini_y, v_dt_cardapio_ini_y);

            --
            --
            -- Calcula a qtde necessria para o produto e para a unidade considerando
            -- os inscritos/matriculados
            --
            if v_inscritos = 'S' THEN
               v_qtde_necessaria := v_qtde_produto_periodo * v_num_inscritos * v_reg_produto.fator_correcao * v_reg_produto.fator_coccao;
            ELSE
               v_qtde_necessaria := v_qtde_produto_periodo * v_num_matriculados * v_reg_produto.fator_correcao * v_reg_produto.fator_coccao;
            END IF;

            --
            -- Divide qtde total em gramas pelo peso da unidade do produto
            --
            v_qtde_necessaria := ROUND(v_qtde_necessaria / v_reg_produto.peso);

            --
            -- Obtm qtde do produto j gerado em outras guias
            --
            v_qtde_guia_produto := 0;

            SELECT INTO v_qtde_guia_produto COALESCE(SUM(qtde),0)
               FROM alimentos.guia_produto_diario
               WHERE idpro = v_reg_produto.idpro
               AND iduni = v_reg_unidade.iduni
               AND dt_guia = v_dt_cardapio_ini_x;

            v_qtde_necessaria_saldo:=v_qtde_necessaria - v_qtde_guia_produto;


            --
            -- GRAVA LOG
            --
            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      Qtde per capita: ' || TRIM(TO_CHAR(v_qtde_produto_periodo, '9999999999.99')) WHERE idlogguia = v_id_log;

            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      Fator correo: ' || TRIM(TO_CHAR(v_reg_produto.fator_correcao, '9999999999.99')) WHERE idlogguia = v_id_log;

            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      Fator coco: ' || TRIM(TO_CHAR(v_reg_produto.fator_coccao, '9999999999.99')) WHERE idlogguia = v_id_log;

            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      Peso: ' || TRIM(TO_CHAR(v_reg_produto.peso, '9999999999.99')) WHERE idlogguia = v_id_log;
            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      Qtde necessria: ' || TRIM(TO_CHAR(v_qtde_necessaria, '9999999999.99')) WHERE idlogguia = v_id_log;

            RAISE NOTICE 'Qtde per capita(%)',v_qtde_produto_periodo;
            RAISE NOTICE 'Fator correo(%)',v_reg_produto.fator_correcao;
            RAISE NOTICE 'Fator coco(%)',v_reg_produto.fator_coccao;
            RAISE NOTICE 'Peso(%)',v_reg_produto.peso;
            RAISE NOTICE 'Qtde Necessria(%)',v_qtde_necessaria;

            --
            -- Obtm qtde do produto em contrato, incluindo
            -- todos os fornecedores autorizados a fornecer para a unidade
            -- e que tenham produtos a fornecer (qtde remessa < qtde contrato)
            -- ou qtde remessa = qtde_contrato (estoque zerado) e contrato vigente porque
            -- possuem outros produtos a fornecer
            --
            v_sql_fornecedor := 'SELECT con.idfor as idfor
               ,COALESCE(SUM(cop.qtde_contratada-cop.qtde_remessa),0) as qtde
               ,SUM(cop.qtde_contratada) as qtde_contratada
               FROM alimentos.contrato con
                   ,alimentos.contrato_produto cop
               WHERE con.idcon = cop.idcon
         AND con.cancelado = ''N''
         AND con.finalizado = ''S''
         AND con.ultimo_contrato = ''S''
         AND con.idfor IN (SELECT idfor
                  FROM alimentos.fornecedor_unidade_atendida
                  WHERE iduni = ' || v_reg_unidade.iduni || ')
               AND (cop.qtde_remessa < cop.qtde_contratada
               OR  (cop.qtde_remessa  = cop.qtde_contratada
               AND (SELECT COALESCE(SUM(cop2.qtde_contratada-cop2.qtde_remessa),0)
                       FROM alimentos.contrato_produto cop2
                       WHERE cop2.idcon = con.idcon
                       AND cop2.idpro <> ' ||  v_reg_produto.idpro || ' ) > 0 ))
               AND cop.idpro = ' || v_reg_produto.idpro || '
               GROUP BY con.idfor ';

            v_qtde_total_contrato := 0;
            v_existe_forn := 0;

            FOR v_reg_fornecedor IN EXECUTE v_sql_fornecedor LOOP
               v_existe_forn := 1;
               v_qtde_total_contrato:= v_qtde_total_contrato + v_reg_fornecedor.qtde_contratada;
            END LOOP;

            RAISE NOTICE 'Qtde total contrato(%)',v_qtde_total_contrato;

            --
            -- GRAVA LOG
            --
            UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      Qtde total contrato: ' || TRIM(TO_CHAR(v_qtde_total_contrato, '9999999999.99')) WHERE idlogguia = v_id_log;

            --
            -- Testa se fornecedor tem contrato e autorizao para fornecer para a
            -- unidade
            --
            IF v_existe_forn = 0 THEN

               --
               -- GRAVA LOG
               --
               UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n      *** existe forn: N ***' WHERE idlogguia = v_id_log;

               RETURN '-1 Produto: ' || v_reg_produto.nome_compra || ' no tem contrato ou o fornecedor contratado no est autorizado a fornecer para a unidade ' || v_reg_unidade.nome || '.';

            END IF;

            --
            -- Qtde necessria deve ser > 0
            --
            IF v_qtde_necessaria > 0 THEN

               --
               -- Calcula a quantidade a ser fornecida por cada fornecedor
               --

               -- PREPARA SELECT
               v_sql_fornecedor := 'SELECT con.idcon as idcon
                  ,con.idfor as idfor
                  ,TRIM(con.codigo) as codigo
                  ,cop.qtde_contratada as qtde_contratada
                  ,cop.qtde_remessa as qtde_remessa
                  ,cop.idcop as idcop
                  ,TRIM(forn.nome_fantasia) as nome
                  FROM  alimentos.contrato con
                       ,alimentos.contrato_produto cop
                       ,alimentos.fornecedor forn
                  WHERE con.idcon = cop.idcon
                  AND con.idfor = forn.idfor
                  AND     con.cancelado = ''N''
                  AND     con.finalizado = ''S''
                  AND con.ultimo_contrato = ''S''';

               IF v_array_fornecedor <> '0' THEN
                  v_sql_fornecedor := v_sql_fornecedor || ' AND con.idfor IN (' || v_array_fornecedor || ')';
               END IF;

               v_sql_fornecedor := v_sql_fornecedor || ' AND con.idfor IN
                  (SELECT idfor
                      FROM alimentos.fornecedor_unidade_atendida
                      WHERE iduni = ' || v_reg_unidade.iduni || ')
                      AND cop.qtde_remessa < cop.qtde_contratada
                      AND cop.idpro = ' || v_reg_produto.idpro;

               v_qtde_disponivel := 0;
               v_existe_estoque := 0;

               -- EXECUTA SELECT PREPARADO
               FOR v_reg_fornecedor IN EXECUTE v_sql_fornecedor LOOP

                  RAISE NOTICE '                                          ';
                  RAISE NOTICE '4 Loop Fornecedor(%)',v_reg_fornecedor.nome;

                  --
                  -- GRAVA LOG
                  --
                  UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n           4 Loop Fornecedor ' || TRIM(TO_CHAR(v_reg_fornecedor.idfor, '9999999999')) || '-' || v_reg_fornecedor.nome || ' Contrato: ' || v_reg_fornecedor.codigo  WHERE idlogguia = v_id_log;

                  v_existe_estoque := 1;

                  v_qtde_disponivel:=COALESCE(v_reg_fornecedor.qtde_contratada- v_reg_fornecedor.qtde_remessa,0);

                  v_percentual_forn:=(v_reg_fornecedor.qtde_contratada * 100) / v_qtde_total_contrato;

                  v_qtde_forn:=ROUND((v_qtde_necessaria * v_percentual_forn) / 100 );

                  --
                  -- Verifica quantidade de saldo a ser fornecida  < 0
                  -- Deve ser verificado por questes de arredondamento,
                  -- evitando enviar uma qtde maior que a necessria

                  v_qtde_nec_saldo_ant := v_qtde_necessaria_saldo;
                  v_qtde_necessaria_saldo:=v_qtde_necessaria_saldo - v_qtde_forn;

                  RAISE NOTICE 'Qtde disponvel(%)',v_qtde_disponivel;
                  RAISE NOTICE 'Percentual(%)',v_percentual_forn;
                  RAISE NOTICE 'Qtde a fornecer(%)',v_qtde_forn;

                  --
                  -- GRAVA LOG
                  --
                  UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || '  \n           Qtde disponvel: ' || TRIM(TO_CHAR(v_qtde_disponivel, '9999999999.99')) WHERE idlogguia = v_id_log;

                  UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || '  \n           Percentual: ' || TRIM(TO_CHAR(v_percentual_forn, '9999999999.9999999999')) WHERE idlogguia = v_id_log;

                  UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || '  \n           Qtde a fornecer: ' || TRIM(TO_CHAR(v_qtde_forn, '9999999999')) WHERE idlogguia = v_id_log;

                  IF v_qtde_necessaria_saldo < 0 THEN

                     v_qtde_forn := v_qtde_nec_saldo_ant;
                     RAISE NOTICE 'Qtde a fornecer ajustada(%)',v_qtde_forn;

                     --
                     -- GRAVA LOG
                     --
                     UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || '  \n           Qtde a fornecer ajustada: ' || TRIM(TO_CHAR(v_qtde_forn, '9999999999')) WHERE idlogguia = v_id_log;

                  END IF;

                  --
                  -- Qtde a ser fornecida do produto deve ser maior que zero
                  -- Qtde disponvel > qtde a ser fornecida

                  IF v_qtde_forn > 0 AND v_qtde_disponivel >= v_qtde_forn THEN

                     --
                     -- Grava a Guia de Remessa para a Unidade, Forn, Produto
                     -- e Contrato
                     --
                     v_id_guia:=0;
                     -- Verifica se existe guia gravada
                     SELECT INTO v_id_guia gui.idgui
                        FROM alimentos.guia_remessa gui
                        WHERE gui.iduni = v_reg_unidade.iduni
                        AND gui.idfor = v_reg_fornecedor.idfor
                        AND gui.idcon = v_reg_fornecedor.idcon
                        AND gui.classe_produto = COALESCE (v_classe, gui.classe_produto)
                        AND gui.situacao = 'E'
                        AND gui.dt_cardapio_inicial  = v_dt_cardapio_ini
                        AND gui.dt_cardapio_final = v_dt_cardapio_fim FOR UPDATE;

                     IF v_id_guia IS NULL THEN

                        -- Obtm ID prxima guia
                        v_id_guia := nextval( 'alimentos.guia_remessa_idgui_seq'::text);

                        IF v_inscritos = 'S' THEN
                           v_num_inscr_matr := v_num_inscritos;
                        ELSE
                           v_num_inscr_matr := v_num_matriculados;
                        END IF;

                        v_classe_aux := v_classe;
                        IF v_classe IS NULL THEN
                           v_classe_aux := 'PN';
                        END IF;

                        -- Obtm o prximo sequencial anual para guia
                        SELECT INTO v_sequencial
                           COALESCE(MAX(sequencial),0) + 1
                           FROM alimentos.guia_remessa gui
                           WHERE gui.ano = TO_NUMBER(TO_CHAR(CURRENT_TIMESTAMP, 'YYYY'),'9999')
                           AND gui.idcli = v_id_cliente;

                        --
                        -- GRAVA LOG
                        --
                        UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n           ID Nova guia: ' || TRIM(TO_CHAR(v_id_guia, '9999999999')) || ' Sequencial: ' || TRIM(TO_CHAR(v_sequencial, '9999999999')) WHERE idlogguia = v_id_log;

                        INSERT INTO alimentos.guia_remessa
         (idgui
                           ,idcon
                           ,login_emissao
                           ,idfor
                           ,iduni
                           ,idcli
                           ,dt_emissao
                           ,ano
                           ,sequencial
                           ,dt_cardapio_inicial
                           ,dt_cardapio_final
                           ,num_inscr_matr
                           ,num_refeicao
                           ,situacao
                           ,classe_produto)
                           VALUES (v_id_guia
                           ,v_reg_fornecedor.idcon
                           ,v_login
                           ,v_reg_fornecedor.idfor
                           ,v_reg_unidade.iduni
                           ,v_id_cliente
                           ,CURRENT_TIMESTAMP
                           ,TO_NUMBER(TO_CHAR(CURRENT_TIMESTAMP,'YYYY'),'9999')
                           ,v_sequencial
                           ,v_dt_cardapio_ini
                           ,v_dt_cardapio_fim
                           ,v_num_inscr_matr
                           ,v_num_refeicao
                           ,'E'
                           ,v_classe_aux);

                        v_qtde_guia := v_qtde_guia + 1;

                     END IF;

                     v_id_guia_produto:=0;
                     -- Verifica se produto j existe na guia
                     SELECT INTO v_id_guia_produto gup.idgup
                        FROM alimentos.guia_remessa_produto gup
                            ,alimentos.guia_remessa gui
                        WHERE gui.idgui = gup.idgui
                        AND gup.idpro = v_reg_produto.idpro
                        AND TRIM(gui.login_emissao) = TRIM(v_login)
                        AND gui.idgui = v_id_guia FOR UPDATE;

                     v_peso := v_reg_produto.peso;

                     IF v_peso = 0 THEN
                        v_peso := 1;
                     END IF;

                     IF v_id_guia_produto IS NULL THEN

                        --
                        -- GRAVA LOG
                        --
                        UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n           *** Novo produto na guia ***   ID Guia:  ' || TRIM(TO_CHAR(v_id_guia, '9999999999')) || ' *** ' WHERE idlogguia = v_id_log;

                        -- Insere novo produto na guia
                        INSERT INTO alimentos.guia_remessa_produto (
                            idgui
                           ,idpro
                           ,qtde_per_capita
                           ,qtde_guia
                           ,peso
                           ,qtde_recebida
                           ,peso_total)
                           VALUES(v_id_guia
                           ,v_reg_produto.idpro
                           ,v_reg_produto.qtde
                           ,v_qtde_forn
                           ,v_peso
                           ,0
                           ,ROUND((v_qtde_forn*v_peso),3));

                     ELSE

                        --
                        -- GRAVA LOG
                        --
                        UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n           Update ID guia_produto: ' || TRIM(TO_CHAR(v_id_guia_produto, '9999999999')) || '   ID Guia: ' || TRIM(TO_CHAR(v_id_guia, '9999999999')) WHERE idlogguia = v_id_log;

                        UPDATE alimentos.guia_remessa_produto
                           SET qtde_guia = (qtde_guia + v_qtde_forn)
                           ,peso_total = ROUND(((qtde_guia + v_qtde_forn)*v_peso),3)
                           WHERE idgup = v_id_guia_produto;

                     END IF;

                     --
                     -- Grava guia_produto_diario.
                     -- Armazena a qtde a ser fornecida do produto em uma data
                     -- e unidade, ou seja, diariamente.
                     --
                     INSERT INTO alimentos.guia_produto_diario
                        (idgui
                        ,idpro
                        ,iduni
                        ,dt_guia
                        ,qtde)
                        VALUES
                        (v_id_guia
                        ,v_reg_produto.idpro
                        ,v_reg_unidade.iduni
                        ,v_dt_cardapio_ini_x
                        ,v_qtde_forn);

                     --
                     -- Diminui estoque do produto
                     --
                     UPDATE alimentos.produto
                        SET qtde_estoque = ROUND((qtde_estoque - v_qtde_forn),2)
                        WHERE idpro = v_reg_produto.idpro;

                     --
                     -- Aumenta quantidade de remessa emitida para o contrato
                     --
                     UPDATE alimentos.contrato_produto
                        SET qtde_remessa = ROUND((qtde_remessa + v_qtde_forn),2)
                        WHERE idcop = v_reg_fornecedor.idcop;

                  ELSE

                     IF v_qtde_disponivel < v_qtde_forn THEN

                        --
                        -- GRAVA LOG
                        --
                        UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n           *** Estoque insuficiente ***' WHERE idlogguia = v_id_log;

                        RETURN '-1 Fornecedor: ' ||  v_reg_fornecedor.nome || ' est com estoque insuficiente para o produto: ' || v_reg_produto.nome_compra || '.';

                     END IF;

                  END IF;

               END LOOP;

               --
               -- Identifica que existe contrato com fornecedor, porm
               -- contrato est com estoque zerado.
               IF v_existe_estoque = 0 THEN

                  --
                  -- GRAVA LOG
                  --
                  UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n      *** Estoque zerado ***' WHERE idlogguia = v_id_log;

                  RETURN '-1 Produto: ' ||  v_reg_produto.nome_compra || ' est com estoque zerado.';

               END IF;

            END IF;

         END LOOP;

      END LOOP;

      v_dt_cardapio_ini_x := v_dt_cardapio_ini_x + interval '1 day';

   END LOOP;

   IF v_existe_produto = 0 AND v_array_fornecedor <> '0' THEN

      --
      -- GRAVA LOG
      --
      UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n     *** Fornecedor no possui produtos para fornecer no perodo. ***' WHERE idlogguia = v_id_log;

      RETURN '-1 Fornecedor no possui produtos para fornecer no perodo. Verifique os contratos elaborados com o fornecedor.';

   ELSIF v_qtde_guia > 0 THEN

      --
      -- GRAVA LOG
      --
      UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n *** GUIAS GERADAS: ' ||  TRIM(TO_CHAR(v_qtde_guia, '9999999999')) || ' ***' WHERE idlogguia = v_id_log;

      RETURN 'Foram geradas ' || REPLACE(TRIM(TO_CHAR(v_qtde_guia,'9,999,999,999')),',','.') || ' guias de remessas.';

   ELSE

      --
      -- GRAVA LOG
      --
      UPDATE alimentos.log_guia_remessa SET mensagem = mensagem || ' \n \n     *** No existem dados para gerar guias de acordo com os filtros informados. ***' WHERE idlogguia = v_id_log;

      RETURN 'No existem dados para gerar guias de acordo com os filtros informados.';

   END IF;

END;$_$
    LANGUAGE plpgsql;


SET search_path = cadastro, pg_catalog;

--
-- Name: fcn_aft_documento(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_documento() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes   numeric;
  BEGIN
    v_idpes := NEW.idpes;
    EXECUTE 'DELETE FROM cadastro.documento WHERE ( (rg = 0 OR rg IS NULL) AND (idorg_exp_rg IS NULL) AND data_exp_rg IS NULL AND (sigla_uf_exp_rg IS NULL OR length(trim(sigla_uf_exp_rg))=0) AND (tipo_cert_civil = 0 OR tipo_cert_civil IS NULL) AND (num_termo = 0 OR num_termo IS NULL) AND (num_livro = 0 OR num_livro IS NULL) AND (num_livro = 0 OR num_livro IS NULL) AND (num_folha = 0 OR num_folha IS NULL) AND data_emissao_cert_civil IS NULL AND (sigla_uf_cert_civil IS NULL OR length(trim(sigla_uf_cert_civil))=0) AND (sigla_uf_cart_trabalho IS NULL OR length(trim(sigla_uf_cart_trabalho))=0) AND (cartorio_cert_civil IS NULL OR length(trim(cartorio_cert_civil))=0) AND (num_cart_trabalho = 0 OR num_cart_trabalho IS NULL) AND (serie_cart_trabalho = 0 OR serie_cart_trabalho IS NULL) AND data_emissao_cart_trabalho IS NULL AND (num_tit_eleitor = 0 OR num_tit_eleitor IS NULL) AND (zona_tit_eleitor = 0 OR zona_tit_eleitor IS NULL) AND (secao_tit_eleitor = 0 OR secao_tit_eleitor IS NULL) ) AND idpes='||quote_literal(v_idpes)||'';
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_documento_provisorio(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_documento_provisorio() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_rg        numeric;
  v_uf_expedicao      text;
  v_verificacao_provisorio  numeric;

  v_comando     text;
  v_registro      record;

  BEGIN
    v_idpes     := NEW.idpes;
    v_rg      := COALESCE(NEW.rg, -1);
    v_uf_expedicao    := TRIM(COALESCE(NEW.sigla_uf_exp_rg, ''));

    v_verificacao_provisorio:= 0;

    -- verificar se a situao do cadastro da pessoa  provisrio
    FOR v_registro IN SELECT situacao FROM cadastro.pessoa WHERE idpes=v_idpes LOOP
      IF v_registro.situacao = 'P' THEN
        v_verificacao_provisorio := 1;
      END IF;
    END LOOP;

    -- Verificao para atualizar ou no a situao do cadastro da pessoa para Ativo
    IF LENGTH(v_uf_expedicao) > 0 AND v_rg > 0 AND v_verificacao_provisorio = 1 THEN
      EXECUTE 'UPDATE cadastro.pessoa SET situacao='||quote_literal('A')||'WHERE idpes='||quote_literal(v_idpes)||';';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_fisica(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_fisica() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_idpes_mae     numeric;
  v_idpes_pai     numeric;
  v_idpes_responsavel   numeric;
  v_idpes_conjuge     numeric;

  v_nome_mae      text;
  v_nome_pai      text;
  v_nome_responsavel    text;
  v_nome_conjuge      text;

  v_verificacao_mae   numeric;
  v_verificacao_pai   numeric;
  v_verificacao_conjuge   numeric;
  v_verificacao_responsavel numeric;

  v_num_aviso_mae     numeric;
  v_num_aviso_pai     numeric;
  v_num_aviso_conjuge   numeric;
  v_num_aviso_responsavel   numeric;

  v_existe_aviso_mae    numeric;
  v_existe_aviso_pai    numeric;
  v_existe_aviso_conjuge    numeric;
  v_existe_aviso_responsavel  numeric;

  v_comando     text;
  v_registro      record;

  BEGIN
    v_idpes     := NEW.idpes;
    v_idpes_mae   := NEW.idpes_mae;
    v_idpes_pai   := NEW.idpes_pai;
    v_idpes_responsavel := NEW.idpes_responsavel;
    v_idpes_conjuge   := NEW.idpes_con;
    v_nome_mae    := TRIM(NEW.nome_mae);
    v_nome_pai    := TRIM(NEW.nome_pai);
    v_nome_responsavel  := TRIM(NEW.nome_responsavel);
    v_nome_conjuge    := TRIM(NEW.nome_conjuge);

    v_num_aviso_mae   := 1;
    v_num_aviso_pai   := 2;
    v_num_aviso_conjuge := 3;
    v_num_aviso_responsavel := 4;

    v_verificacao_mae   := 0;
    v_verificacao_pai   := 0;
    v_verificacao_conjuge   := 0;
    v_verificacao_responsavel := 0;

    v_existe_aviso_mae    := 0;
    v_existe_aviso_pai    := 0;
    v_existe_aviso_conjuge    := 0;
    v_existe_aviso_responsavel  := 0;

    -- obter os avisos j existentes para a pessoa
    FOR v_registro IN SELECT aviso FROM cadastro.aviso_nome WHERE idpes=v_idpes LOOP
      IF v_registro.aviso = 1 THEN
        v_existe_aviso_mae := 1;
      ELSIF v_registro.aviso = 2 THEN
        v_existe_aviso_pai := 1;
      ELSIF v_registro.aviso = 3 THEN
        v_existe_aviso_conjuge := 1;
      ELSIF v_registro.aviso = 4 THEN
        v_existe_aviso_responsavel := 1;
      END IF;
    END LOOP;

    -- MAE
    IF v_idpes_mae > 0 AND v_idpes_mae IS NOT NULL AND LENGTH(v_nome_mae) > 0 AND v_nome_mae IS NOT NULL THEN
      FOR v_registro IN SELECT * from public.fcn_compara_nome_pessoa_fonetica(v_nome_mae, v_idpes_mae) LOOP
        v_verificacao_mae := v_registro.fcn_compara_nome_pessoa_fonetica;
      END LOOP;
    ELSE
      v_verificacao_mae := 1;
    END IF;

    -- PAI
    IF v_idpes_pai > 0 AND v_idpes_pai IS NOT NULL AND LENGTH(v_nome_pai) > 0 AND v_nome_pai IS NOT NULL THEN
      FOR v_registro IN SELECT * from public.fcn_compara_nome_pessoa_fonetica(v_nome_pai, v_idpes_pai) LOOP
        v_verificacao_pai := v_registro.fcn_compara_nome_pessoa_fonetica;
      END LOOP;
    ELSE
      v_verificacao_pai := 1;
    END IF;

    -- CONJUGE
    IF v_idpes_conjuge > 0 AND v_idpes_conjuge IS NOT NULL AND LENGTH(v_nome_conjuge) > 0 AND v_nome_conjuge IS NOT NULL THEN
      FOR v_registro IN SELECT * from public.fcn_compara_nome_pessoa_fonetica(v_nome_conjuge, v_idpes_conjuge) LOOP
        v_verificacao_conjuge := v_registro.fcn_compara_nome_pessoa_fonetica;
      END LOOP;
    ELSE
      v_verificacao_conjuge := 1;
    END IF;

    -- RESPONSAVEL
    IF v_idpes_responsavel > 0 AND v_idpes_responsavel IS NOT NULL AND LENGTH(v_nome_responsavel) > 0 AND v_nome_responsavel IS NOT NULL THEN
      FOR v_registro IN SELECT * from public.fcn_compara_nome_pessoa_fonetica(v_nome_responsavel, v_idpes_responsavel) LOOP
        v_verificacao_responsavel := v_registro.fcn_compara_nome_pessoa_fonetica;
      END LOOP;
    ELSE
      v_verificacao_responsavel := 1;
    END IF;
    -- Inserir ou Deletar aviso da MAE
    IF v_verificacao_mae = 0 AND v_existe_aviso_mae = 0 THEN
      EXECUTE 'INSERT INTO cadastro.aviso_nome (idpes, aviso) VALUES ('||quote_literal(v_idpes)||','||v_num_aviso_mae||');';
    ELSIF v_verificacao_mae = 1 AND v_existe_aviso_mae = 1 THEN
      EXECUTE 'DELETE FROM cadastro.aviso_nome WHERE idpes='||quote_literal(v_idpes)||' AND aviso='||v_num_aviso_mae||';';
    END IF;

    -- Inserir ou Deletar aviso do PAI
    IF v_verificacao_pai = 0 AND v_existe_aviso_pai = 0 THEN
      EXECUTE 'INSERT INTO cadastro.aviso_nome (idpes, aviso) VALUES ('||quote_literal(v_idpes)||','||v_num_aviso_pai||');';
    ELSIF v_verificacao_pai = 1 AND v_existe_aviso_pai = 1 THEN
      EXECUTE 'DELETE FROM cadastro.aviso_nome WHERE idpes='||quote_literal(v_idpes)||' AND aviso='||v_num_aviso_pai||';';
    END IF;

    -- Inserir ou Deletar aviso do CONJUGE
    IF v_verificacao_conjuge = 0 AND v_existe_aviso_conjuge = 0 THEN
      EXECUTE 'INSERT INTO cadastro.aviso_nome (idpes, aviso) VALUES ('||quote_literal(v_idpes)||','||v_num_aviso_conjuge||');';
    ELSIF v_verificacao_conjuge = 1 AND v_existe_aviso_conjuge = 1 THEN
      EXECUTE 'DELETE FROM cadastro.aviso_nome WHERE idpes='||quote_literal(v_idpes)||' AND aviso='||v_num_aviso_conjuge||';';
    END IF;

    -- Inserir ou Deletar aviso do RESPONSAVEL
    IF v_verificacao_responsavel = 0 AND v_existe_aviso_responsavel = 0 THEN
      EXECUTE 'INSERT INTO cadastro.aviso_nome (idpes, aviso) VALUES ('||quote_literal(v_idpes)||','||v_num_aviso_responsavel||');';
    ELSIF v_verificacao_responsavel = 1 AND v_existe_aviso_responsavel = 1 THEN
      EXECUTE 'DELETE FROM cadastro.aviso_nome WHERE idpes='||quote_literal(v_idpes)||' AND aviso='||v_num_aviso_responsavel||';';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_fisica_cpf_provisorio(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_fisica_cpf_provisorio() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_cpf       numeric;
  v_verificacao_provisorio  numeric;

  v_comando     text;
  v_registro      record;

  BEGIN
    v_idpes     := NEW.idpes;
    v_cpf     := COALESCE(NEW.cpf, -1);

    v_verificacao_provisorio:= 0;

    -- verificar se a situao do cadastro da pessoa  provisrio
    FOR v_registro IN SELECT situacao FROM cadastro.pessoa WHERE idpes=v_idpes LOOP
      IF v_registro.situacao = 'P' THEN
        v_verificacao_provisorio := 1;
      END IF;
    END LOOP;

    -- Verificao para atualizar ou no a situao do cadastro da pessoa para Ativo
    IF v_cpf > 0 AND v_verificacao_provisorio = 1 THEN
      EXECUTE 'UPDATE cadastro.pessoa SET situacao='||quote_literal('A')||'WHERE idpes='||quote_literal(v_idpes)||';';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_fisica_provisorio(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_fisica_provisorio() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_idpes_mae     numeric;
  v_nome_mae      text;
  v_data_nascimento   text;
  v_verificacao_provisorio  numeric;

  v_comando     text;
  v_registro      record;

  BEGIN
    v_idpes     := NEW.idpes;
    v_idpes_mae   := COALESCE(NEW.idpes_mae, -1);
    v_nome_mae    := TRIM(COALESCE(NEW.nome_mae, ''));
    v_data_nascimento := COALESCE(TO_CHAR(NEW.data_nasc, 'DD/MM/YYYY'), '');

    v_verificacao_provisorio:= 0;

    -- verificar se a situao do cadastro da pessoa  provisrio
    FOR v_registro IN SELECT situacao FROM cadastro.pessoa WHERE idpes=v_idpes LOOP
      IF v_registro.situacao = 'P' THEN
        v_verificacao_provisorio := 1;
      END IF;
    END LOOP;

    -- Verificao para atualizar ou no a situao do cadastro da pessoa para Ativo
    IF v_data_nascimento <> '' AND (LENGTH(v_nome_mae) > 0 OR v_idpes_mae > 0) AND v_verificacao_provisorio = 1 THEN
      EXECUTE 'UPDATE cadastro.pessoa SET situacao='||quote_literal('A')||'WHERE idpes='||quote_literal(v_idpes)||';';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_ins_endereco_externo(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_ins_endereco_externo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes   numeric;
  v_tipo_endereco text;
  BEGIN
    v_idpes   := NEW.idpes;
    v_tipo_endereco := NEW.tipo;
    EXECUTE 'DELETE FROM cadastro.endereco_pessoa WHERE idpes='||quote_literal(v_idpes)||' AND tipo='||v_tipo_endereco||';';
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_ins_endereco_pessoa(); Type: FUNCTION; Schema: cadastro; Owner: -
--

CREATE FUNCTION fcn_aft_ins_endereco_pessoa() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes   numeric;
  v_tipo_endereco text;
  BEGIN
    v_idpes   := NEW.idpes;
    v_tipo_endereco := NEW.tipo;
    EXECUTE 'DELETE FROM cadastro.endereco_externo WHERE idpes='||quote_literal(v_idpes)||' AND tipo='||v_tipo_endereco||';';
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


SET search_path = consistenciacao, pg_catalog;

--
-- Name: fcn_delete_temp_cadastro_unificacao_cmf(integer); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_delete_temp_cadastro_unificacao_cmf(integer) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpes ALIAS for $1;
BEGIN
  -- Deleta dados da tabela temp_cadastro_unificacao_cmf
  DELETE FROM consistenciacao.temp_cadastro_unificacao_cmf WHERE idpes = v_idpes;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_temp_cadastro_unificacao_siam(integer); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_delete_temp_cadastro_unificacao_siam(integer) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpes ALIAS for $1;
BEGIN
  -- Deleta dados da tabela temp_cadastro_unificacao_siam
  DELETE FROM consistenciacao.temp_cadastro_unificacao_siam WHERE idpes = v_idpes;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_documento_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_documento_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes         numeric;

  v_data_expedicao_rg_nova    date;
  v_data_expedicao_rg_antiga    date;
  v_data_emissao_cert_civil_nova    date;
  v_data_emissao_cert_civil_antiga  date;
  v_data_emissao_cart_trabalho_nova date;
  v_data_emissao_cart_trabalho_antiga date;
  v_orgao_expedicao_rg_novo   numeric;
  v_orgao_expedicao_rg_antigo   numeric;
  v_numero_rg_novo      numeric;
  v_numero_rg_antigo      numeric;
  v_numero_titulo_eleitor_novo    numeric;
  v_numero_titulo_eleitor_antigo    numeric;
  v_numero_zona_titulo_novo   numeric;
  v_numero_zona_titulo_antigo   numeric;
  v_numero_secao_titulo_novo    numeric;
  v_numero_secao_titulo_antigo    numeric;
  v_numero_cart_trabalho_novo   numeric;
  v_numero_cart_trabalho_antigo   numeric;
  v_numero_serie_cart_trabalho_novo numeric;
  v_numero_serie_cart_trabalho_antigo numeric;
  v_tipo_certidao_civil_novo    numeric;
  v_tipo_certidao_civil_antigo    numeric;
  v_numero_termo_certidao_civil_novo  numeric;
  v_numero_termo_certidao_civil_antigo  numeric;
  v_numero_livro_certidao_civil_novo  varchar;
  v_numero_livro_certidao_civil_antigo  varchar;
  v_numero_folha_certidao_civil_novo  numeric;
  v_numero_folha_certidao_civil_antigo  numeric;
  v_cartorio_certidao_civil_novo    text;
  v_cartorio_certidao_civil_antigo  text;
  v_uf_expedicao_rg_novo      text;
  v_uf_expedicao_rg_antigo    text;
  v_uf_emissao_certidao_civil_novo  text;
  v_uf_emissao_certidao_civil_antigo  text;
  v_uf_emissao_carteira_trabalho_novo text;
  v_uf_emissao_carteira_trabalho_antigo text;

  v_comando     text;
  v_origem_gravacao   text;

  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;

  v_nova_credibilidade    numeric;

  v_registro      record;
  v_aux_data_nova     text;
  v_aux_data_antiga   text;

  -- ID dos campos
  v_idcam_numero_rg     numeric;
  v_idcam_orgao_expedidor_rg    numeric;
  v_idcam_data_expedicao_rg   numeric;
  v_idcam_uf_expedicao_rg     numeric;
  v_idcam_tipo_certidao_civil   numeric;
  v_idcam_numero_termo_certidao_civil numeric;
  v_idcam_numero_livro_certidao_civil numeric;
  v_idcam_numero_folha_certidao_civil numeric;
  v_idcam_data_emissao_certidao_civil numeric;
  v_idcam_cartorio_certidao_civil        numeric;
  v_idcam_uf_emissao_certidao_civil numeric;
  v_idcam_numero_carteira_trabalho  numeric;
  v_idcam_numero_serie_carteira_trabalho  numeric;
  v_idcam_data_emissao_carteira_trabalho  numeric;
  v_idcam_uf_emissao_carteira_trabalho  numeric;
  v_idcam_numero_titulo_eleitor   numeric;
  v_idcam_numero_zona_titulo_eleitor  numeric;
  v_idcam_numero_secao_titulo_eleitor numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Maxima, 2 = Alta, 3 = Media, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migracao, U = Usuario, C = Rotina de confrontacao, O = Oscar
  */
  BEGIN
    v_idpes         := NEW.idpes;

    v_data_expedicao_rg_nova    := NEW.data_exp_rg;
    v_data_emissao_cert_civil_nova    := NEW.data_emissao_cert_civil;
    v_data_emissao_cart_trabalho_nova := NEW.data_emissao_cart_trabalho;
    v_orgao_expedicao_rg_novo   := NEW.idorg_exp_rg;
    v_numero_rg_novo      := NEW.rg;
    v_numero_titulo_eleitor_novo    := NEW.num_tit_eleitor;
    v_numero_zona_titulo_novo   := NEW.zona_tit_eleitor;
    v_numero_secao_titulo_novo    := NEW.secao_tit_eleitor;
    v_numero_cart_trabalho_novo   := NEW.num_cart_trabalho;
    v_numero_serie_cart_trabalho_novo := NEW.serie_cart_trabalho;
    v_tipo_certidao_civil_novo    := NEW.tipo_cert_civil;
    v_numero_termo_certidao_civil_novo  := NEW.num_termo;
    v_numero_livro_certidao_civil_novo  := NEW.num_livro;
    v_numero_folha_certidao_civil_novo  := NEW.num_folha;
    v_cartorio_certidao_civil_novo    := NEW.cartorio_cert_civil;
    v_uf_expedicao_rg_novo      := NEW.sigla_uf_exp_rg;
    v_uf_emissao_certidao_civil_novo  := NEW.sigla_uf_cert_civil;
    v_uf_emissao_carteira_trabalho_novo := NEW.sigla_uf_cart_trabalho;

    IF TG_OP <> 'UPDATE' THEN
      v_data_expedicao_rg_antiga    := NULL;
      v_data_emissao_cert_civil_antiga  := NULL;
      v_data_emissao_cart_trabalho_antiga := NULL;
      v_orgao_expedicao_rg_antigo   := 0;
      v_numero_rg_antigo      := 0;
      v_numero_titulo_eleitor_antigo    := 0;
      v_numero_zona_titulo_antigo   := 0;
      v_numero_secao_titulo_antigo    := 0;
      v_numero_cart_trabalho_antigo   := 0;
      v_numero_serie_cart_trabalho_antigo := 0;
      v_tipo_certidao_civil_antigo    := 0;
      v_numero_termo_certidao_civil_antigo  := 0;
      v_numero_livro_certidao_civil_antigo  := '';
      v_numero_folha_certidao_civil_antigo  := 0;
      v_cartorio_certidao_civil_antigo  := '';
      v_uf_expedicao_rg_antigo    := '';
      v_uf_emissao_certidao_civil_antigo  := '';
      v_uf_emissao_carteira_trabalho_antigo := '';
    ELSE
      v_data_expedicao_rg_antiga    := OLD.data_exp_rg;
      v_data_emissao_cert_civil_antiga  := OLD.data_emissao_cert_civil;
      v_data_emissao_cart_trabalho_antiga := OLD.data_emissao_cart_trabalho;
      v_orgao_expedicao_rg_antigo   := COALESCE(OLD.idorg_exp_rg, 0);
      v_numero_rg_antigo      := COALESCE(OLD.rg, 0);
      v_numero_titulo_eleitor_antigo    := COALESCE(OLD.num_tit_eleitor, 0);
      v_numero_zona_titulo_antigo   := COALESCE(OLD.zona_tit_eleitor, 0);
      v_numero_secao_titulo_antigo    := COALESCE(OLD.secao_tit_eleitor, 0);
      v_numero_cart_trabalho_antigo   := COALESCE(OLD.num_cart_trabalho, 0);
      v_numero_serie_cart_trabalho_antigo := COALESCE(OLD.serie_cart_trabalho, 0);
      v_tipo_certidao_civil_antigo    := COALESCE(OLD.tipo_cert_civil, 0);
      v_numero_termo_certidao_civil_antigo  := COALESCE(OLD.num_termo, 0);
      v_numero_livro_certidao_civil_antigo  := OLD.num_livro;
      v_numero_folha_certidao_civil_antigo  := COALESCE(OLD.num_folha, 0);
      v_cartorio_certidao_civil_antigo  := COALESCE(OLD.cartorio_cert_civil, '');
      v_uf_expedicao_rg_antigo    := COALESCE(OLD.sigla_uf_exp_rg, '');
      v_uf_emissao_certidao_civil_antigo  := COALESCE(OLD.sigla_uf_cert_civil, '');
      v_uf_emissao_carteira_trabalho_antigo := COALESCE(OLD.sigla_uf_cart_trabalho, '');
    END IF;

    v_idcam_numero_rg     := 6;
    v_idcam_orgao_expedidor_rg    := 7;
    v_idcam_data_expedicao_rg   := 8;
    v_idcam_uf_expedicao_rg     := 9;
    v_idcam_tipo_certidao_civil   := 10;
    v_idcam_numero_termo_certidao_civil := 11;
    v_idcam_numero_livro_certidao_civil := 12;
    v_idcam_numero_folha_certidao_civil := 13;
    v_idcam_data_emissao_certidao_civil := 14;
    v_idcam_cartorio_certidao_civil   := 15;
    v_idcam_uf_emissao_certidao_civil := 16;
    v_idcam_numero_carteira_trabalho  := 17;
    v_idcam_numero_serie_carteira_trabalho  := 18;
    v_idcam_data_emissao_carteira_trabalho  := 19;
    v_idcam_uf_emissao_carteira_trabalho  := 20;
    v_idcam_numero_titulo_eleitor   := 21;
    v_idcam_numero_zona_titulo_eleitor  := 22;
    v_idcam_numero_secao_titulo_eleitor := 23;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;

    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usuario ou pelo usuario do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migracao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;

    IF v_nova_credibilidade > 0 THEN

      -- DATA DE EXPEDICAO DO RG
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_expedicao_rg_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_expedicao_rg_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_expedicao_rg||','||v_nova_credibilidade||');';
      END IF;

      -- DATA DE EMISSAO CERTIDAO CIVIL
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_emissao_cert_civil_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_emissao_cert_civil_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_emissao_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- DATA DE EMISSAO CARTEIRA DE TRABALHO
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_emissao_cart_trabalho_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_emissao_cart_trabalho_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_emissao_carteira_trabalho||','||v_nova_credibilidade||');';
      END IF;

      -- ORGAO EXPEDIDOR DO RG
      IF v_orgao_expedicao_rg_novo <> v_orgao_expedicao_rg_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_orgao_expedidor_rg||','||v_nova_credibilidade||');';
      END IF;

      -- RG
      IF v_numero_rg_novo <> v_numero_rg_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_rg||','||v_nova_credibilidade||');';
      END IF;

      -- TITULO ELEITOR
      IF v_numero_titulo_eleitor_novo <> v_numero_titulo_eleitor_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_titulo_eleitor||','||v_nova_credibilidade||');';
      END IF;

      -- ZONA TITULO ELEITOR
      IF v_numero_zona_titulo_novo <> v_numero_zona_titulo_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_zona_titulo_eleitor||','||v_nova_credibilidade||');';
      END IF;

      -- SECAO TITULO ELEITOR
      IF v_numero_secao_titulo_novo <> v_numero_secao_titulo_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_secao_titulo_eleitor||','||v_nova_credibilidade||');';
      END IF;

      -- CARTEIRA DE TRABALHO
      IF v_numero_cart_trabalho_novo <> v_numero_cart_trabalho_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_carteira_trabalho||','||v_nova_credibilidade||');';
      END IF;

      -- SERIE CARTEIRA DE TRABALHO
      IF v_numero_serie_cart_trabalho_novo <> v_numero_serie_cart_trabalho_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_serie_carteira_trabalho||','||v_nova_credibilidade||');';
      END IF;

      -- TIPO CERTIDAO CIVIL
      IF v_tipo_certidao_civil_novo <> v_tipo_certidao_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_tipo_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- NUMERO TERMO CERTIDAO CIVIL
      IF v_numero_termo_certidao_civil_novo <> v_numero_termo_certidao_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_termo_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- NUMERO LIVRO CERTIDAO CIVIL
      IF v_numero_livro_certidao_civil_novo <> v_numero_livro_certidao_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_livro_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- NUMERO FOLHA CERTIDAO CIVIL
      IF v_numero_folha_certidao_civil_novo <> v_numero_folha_certidao_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_folha_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- CARTORIO CERTIDAO CIVIL
      IF v_cartorio_certidao_civil_novo <> v_cartorio_certidao_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cartorio_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- UF EXPEDICAO RG
      IF v_uf_expedicao_rg_novo <> v_uf_expedicao_rg_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_uf_expedicao_rg||','||v_nova_credibilidade||');';
      END IF;

      -- UF EMISSAO CERTIDAO CIVIL
      IF v_uf_emissao_certidao_civil_novo <> v_uf_emissao_certidao_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_uf_emissao_certidao_civil||','||v_nova_credibilidade||');';
      END IF;

      -- UF EMISSAO CARTEIRA DE TRABALHO
      IF v_uf_emissao_carteira_trabalho_novo <> v_uf_emissao_carteira_trabalho_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_uf_emissao_carteira_trabalho||','||v_nova_credibilidade||');';
      END IF;

    END IF;
    -- Verificar os campos Vazios ou Nulos
    -- DATA DE EXPEDICAO DO RG
    IF TRIM(v_data_expedicao_rg_nova)='' OR v_data_expedicao_rg_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_expedicao_rg||','||v_sem_credibilidade||');';
    END IF;
    -- DATA DE EMISSAO CERTIDAO CIVIL
    IF TRIM(v_data_emissao_cert_civil_nova)='' OR v_data_emissao_cert_civil_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_emissao_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- DATA DE EMISSAO CARTEIRA DE TRABALHO
    IF TRIM(v_data_emissao_cart_trabalho_nova)='' OR v_data_emissao_cart_trabalho_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_emissao_carteira_trabalho||','||v_sem_credibilidade||');';
    END IF;
    -- ORGAO EXPEDIDOR DO RG
    IF v_orgao_expedicao_rg_novo <= 0 OR v_orgao_expedicao_rg_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_orgao_expedidor_rg||','||v_sem_credibilidade||');';
    END IF;
    -- RG
    IF v_numero_rg_novo <= 0 OR v_numero_rg_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_rg||','||v_sem_credibilidade||');';
    END IF;
    -- TITULO ELEITOR
    IF v_numero_titulo_eleitor_novo <= 0 OR v_numero_titulo_eleitor_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_titulo_eleitor||','||v_sem_credibilidade||');';
    END IF;
    -- ZONA TITULO ELEITOR
    IF v_numero_zona_titulo_novo <= 0 OR v_numero_zona_titulo_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_zona_titulo_eleitor||','||v_sem_credibilidade||');';
    END IF;
    -- SECAO TITULO ELEITOR
    IF v_numero_secao_titulo_novo <= 0 OR v_numero_secao_titulo_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_secao_titulo_eleitor||','||v_sem_credibilidade||');';
    END IF;
    -- CARTEIRA DE TRABALHO
    IF v_numero_cart_trabalho_novo <= 0 OR v_numero_cart_trabalho_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_carteira_trabalho||','||v_sem_credibilidade||');';
    END IF;
    -- SERIE CARTEIRA DE TRABALHO
    IF v_numero_serie_cart_trabalho_novo <= 0 OR v_numero_serie_cart_trabalho_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_serie_carteira_trabalho||','||v_sem_credibilidade||');';
    END IF;
    -- TIPO CERTIDAO CIVIL
    IF v_tipo_certidao_civil_novo <= 0 OR v_tipo_certidao_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_tipo_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- NUMERO TERMO CERTIDAO CIVIL
    IF v_numero_termo_certidao_civil_novo <= 0 OR v_numero_termo_certidao_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_termo_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- NUMERO LIVRO CERTIDAO CIVIL
    IF v_numero_livro_certidao_civil_novo = '' OR v_numero_livro_certidao_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_livro_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- NUMERO FOLHA CERTIDAO CIVIL
    IF v_numero_folha_certidao_civil_novo <= 0 OR v_numero_folha_certidao_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero_folha_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- CARTORIO CERTIDAO CIVIL
    IF TRIM(v_cartorio_certidao_civil_novo)='' OR v_cartorio_certidao_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cartorio_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- UF EXPEDICAO RG
    IF TRIM(v_uf_expedicao_rg_novo)='' OR v_uf_expedicao_rg_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_uf_expedicao_rg||','||v_sem_credibilidade||');';
    END IF;
    -- UF EMISSAO CERTIDAO CIVIL
    IF TRIM(v_uf_emissao_certidao_civil_novo)='' OR v_uf_emissao_certidao_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_uf_emissao_certidao_civil||','||v_sem_credibilidade||');';
    END IF;
    -- UF EMISSAO CARTEIRA DE TRABALHO
    IF TRIM(v_uf_emissao_carteira_trabalho_novo)='' OR v_uf_emissao_carteira_trabalho_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_uf_emissao_carteira_trabalho||','||v_sem_credibilidade||');';
    END IF;

  RETURN NEW;
END;$$
    LANGUAGE plpgsql;


--
-- Name: fcn_endereco_externo_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_endereco_externo_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;

  v_sigla_uf_antiga   text;
  v_sigla_uf_nova     text;
  v_id_tipo_logradouro_antigo text;
  v_id_tipo_logradouro_novo text;
  v_logradouro_antigo   text;
  v_logradouro_novo   text;
  v_numero_antigo     numeric;
  v_numero_novo     numeric;
  v_letra_antiga      text;
  v_letra_nova      text;
  v_complemento_antigo    text;
  v_complemento_novo    text;
  v_bairro_antigo     text;
  v_bairro_novo     text;
  v_cep_antigo      numeric;
  v_cep_novo      numeric;
  v_cidade_antiga     text;
  v_cidade_nova     text;

  v_tipo_endereco     numeric;

  v_comando     text;
  v_origem_gravacao   text;

  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;

  v_nova_credibilidade    numeric;

  v_registro      record;

  -- ID dos campos
  v_idcam_sigla_uf_correspondencia    numeric;
  v_idcam_id_tipo_logradouro_correspondencia  numeric;
  v_idcam_logradouro_correspondencia    numeric;
  v_idcam_numero_correspondencia      numeric;
  v_idcam_letra_correspondencia     numeric;
  v_idcam_complemento_correspondencia   numeric;
  v_idcam_bairro_correspondencia      numeric;
  v_idcam_cep_correspondencia     numeric;
  v_idcam_cidade_correspondencia      numeric;

  v_idcam_sigla_uf_residencial      numeric;
  v_idcam_id_tipo_logradouro_residencial    numeric;
  v_idcam_logradouro_residencial      numeric;
  v_idcam_numero_residencial      numeric;
  v_idcam_letra_residencial     numeric;
  v_idcam_complemento_residencial     numeric;
  v_idcam_bairro_residencial      numeric;
  v_idcam_cep_residencial       numeric;
  v_idcam_cidade_residencial      numeric;

  v_idcam_sigla_uf_comercial      numeric;
  v_idcam_id_tipo_logradouro_comercial    numeric;
  v_idcam_logradouro_comercial      numeric;
  v_idcam_numero_comercial      numeric;
  v_idcam_letra_comercial       numeric;
  v_idcam_complemento_comercial     numeric;
  v_idcam_bairro_comercial      numeric;
  v_idcam_cep_comercial       numeric;
  v_idcam_cidade_comercial      numeric;

  v_idcam_sigla_uf    numeric;
  v_idcam_id_tipo_logradouro  numeric;
  v_idcam_logradouro    numeric;
  v_idcam_numero      numeric;
  v_idcam_letra     numeric;
  v_idcam_complemento   numeric;
  v_idcam_bairro      numeric;
  v_idcam_cep     numeric;
  v_idcam_cidade      numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Mxima, 2 = Alta, 3 = Mdia, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migrao, U = Usurio, C = Rotina de confrontao, O = Oscar
  */
  BEGIN
    v_idpes       := NEW.idpes;
    v_tipo_endereco     := NEW.tipo;

    v_sigla_uf_nova     := NEW.sigla_uf;
    v_id_tipo_logradouro_novo := NEW.idtlog;
    v_logradouro_novo   := NEW.logradouro;
    v_numero_novo     := NEW.numero;
    v_letra_nova      := NEW.letra;
    v_complemento_novo    := NEW.complemento;
    v_bairro_novo     := NEW.bairro;
    v_cep_novo      := NEW.cep;
    v_cidade_nova     := NEW.cidade;

    IF TG_OP <> 'UPDATE' THEN
      v_sigla_uf_antiga   := '';
      v_id_tipo_logradouro_antigo := '';
      v_logradouro_antigo   := '';
      v_numero_antigo     := 0;
      v_letra_antiga      := '';
      v_complemento_antigo    := '';
      v_bairro_antigo     := '';
      v_cep_antigo      := 0;
      v_cidade_antiga     := '';
    ELSE
      v_sigla_uf_antiga   := COALESCE(OLD.sigla_uf, '');
      v_id_tipo_logradouro_antigo := COALESCE(OLD.idtlog, '');
      v_logradouro_antigo   := COALESCE(OLD.logradouro, '');
      v_numero_antigo     := COALESCE(OLD.numero, 0);
      v_letra_antiga      := COALESCE(OLD.letra, '');
      v_complemento_antigo    := COALESCE(OLD.complemento, '');
      v_bairro_antigo     := COALESCE(OLD.bairro, '');
      v_cep_antigo      := COALESCE(OLD.cep, 0);
      v_cidade_antiga     := COALESCE(OLD.cidade, '');
    END IF;

    v_idcam_sigla_uf_correspondencia    := 55;
    v_idcam_id_tipo_logradouro_correspondencia  := 48;
    v_idcam_logradouro_correspondencia    := 47;
    v_idcam_numero_correspondencia      := 49;
    v_idcam_letra_correspondencia     := 50;
    v_idcam_complemento_correspondencia   := 51;
    v_idcam_bairro_correspondencia      := 52;
    v_idcam_cep_correspondencia     := 53;
    v_idcam_cidade_correspondencia      := 54;
    v_idcam_sigla_uf_residencial      := 64;
    v_idcam_id_tipo_logradouro_residencial    := 57;
    v_idcam_logradouro_residencial      := 56;
    v_idcam_numero_residencial      := 58;
    v_idcam_letra_residencial     := 59;
    v_idcam_complemento_residencial     := 60;
    v_idcam_bairro_residencial      := 61;
    v_idcam_cep_residencial       := 62;
    v_idcam_cidade_residencial      := 63;
    v_idcam_sigla_uf_comercial      := 73;
    v_idcam_id_tipo_logradouro_comercial    := 66;
    v_idcam_logradouro_comercial      := 65;
    v_idcam_numero_comercial      := 67;
    v_idcam_letra_comercial       := 68;
    v_idcam_complemento_comercial     := 69;
    v_idcam_bairro_comercial      := 70;
    v_idcam_cep_comercial       := 71;
    v_idcam_cidade_comercial      := 72;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;

    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usurio ou usurio do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migrao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;

    IF v_tipo_endereco = 1 THEN
      v_idcam_sigla_uf    := v_idcam_sigla_uf_correspondencia;
      v_idcam_id_tipo_logradouro  := v_idcam_id_tipo_logradouro_correspondencia;
      v_idcam_logradouro    := v_idcam_logradouro_correspondencia;
      v_idcam_numero      := v_idcam_numero_correspondencia;
      v_idcam_letra     := v_idcam_letra_correspondencia;
      v_idcam_complemento   := v_idcam_complemento_correspondencia;
      v_idcam_bairro      := v_idcam_bairro_correspondencia;
      v_idcam_cep     := v_idcam_cep_correspondencia;
      v_idcam_cidade      := v_idcam_cidade_correspondencia;
    ELSIF v_tipo_endereco = 2 THEN
      v_idcam_sigla_uf    := v_idcam_sigla_uf_residencial;
      v_idcam_id_tipo_logradouro  := v_idcam_id_tipo_logradouro_residencial;
      v_idcam_logradouro    := v_idcam_logradouro_residencial;
      v_idcam_numero      := v_idcam_numero_residencial;
      v_idcam_letra     := v_idcam_letra_residencial;
      v_idcam_complemento   := v_idcam_complemento_residencial;
      v_idcam_bairro      := v_idcam_bairro_residencial;
      v_idcam_cep     := v_idcam_cep_residencial;
      v_idcam_cidade      := v_idcam_cidade_residencial;
    ELSIF v_tipo_endereco = 3 THEN
      v_idcam_sigla_uf    := v_idcam_sigla_uf_comercial;
      v_idcam_id_tipo_logradouro  := v_idcam_id_tipo_logradouro_comercial;
      v_idcam_logradouro    := v_idcam_logradouro_comercial;
      v_idcam_numero      := v_idcam_numero_comercial;
      v_idcam_letra     := v_idcam_letra_comercial;
      v_idcam_complemento   := v_idcam_complemento_comercial;
      v_idcam_bairro      := v_idcam_bairro_comercial;
      v_idcam_cep     := v_idcam_cep_comercial;
      v_idcam_cidade      := v_idcam_cidade_comercial;
    END IF;

    IF v_nova_credibilidade > 0 THEN
      -- UF
      IF v_sigla_uf_nova <> v_sigla_uf_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_sigla_uf||','||v_nova_credibilidade||');';
      END IF;

      -- ID TIPO LOGRADOURO
      IF v_id_tipo_logradouro_novo <> v_id_tipo_logradouro_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_id_tipo_logradouro||','||v_nova_credibilidade||');';
      END IF;

      -- LOGRADOURO
      IF v_logradouro_novo <> v_logradouro_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_logradouro||','||v_nova_credibilidade||');';
      END IF;

      -- NUMERO
      IF v_numero_novo <> v_numero_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero||','||v_nova_credibilidade||');';
      END IF;

      -- LETRA
      IF v_letra_nova <> v_letra_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_letra||','||v_nova_credibilidade||');';
      END IF;

      -- COMPLEMENTO
      IF v_complemento_novo <> v_complemento_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_complemento||','||v_nova_credibilidade||');';
      END IF;

      -- BAIRRO
      IF v_bairro_novo <> v_bairro_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_bairro||','||v_nova_credibilidade||');';
      END IF;

      -- CEP
      IF v_cep_novo <> v_cep_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cep||','||v_nova_credibilidade||');';
      END IF;

      -- CIDADE
      IF v_cidade_nova <> v_cidade_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cidade||','||v_nova_credibilidade||');';
      END IF;

    END IF;

    -- Verificar os campos Vazios ou Nulos

    -- UF
    IF TRIM(v_sigla_uf_nova)='' OR v_sigla_uf_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_sigla_uf||','||v_sem_credibilidade||');';
    END IF;

    -- ID TIPO LOGRADOURO
    IF TRIM(v_id_tipo_logradouro_novo)='' OR v_id_tipo_logradouro_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_id_tipo_logradouro||','||v_sem_credibilidade||');';
    END IF;

    -- LOGRADOURO
    IF TRIM(v_logradouro_novo)='' OR v_logradouro_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_logradouro||','||v_sem_credibilidade||');';
    END IF;
    -- NUMERO
    IF v_numero_novo <= 0 OR v_numero_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero||','||v_sem_credibilidade||');';
    END IF;

    -- LETRA
    IF TRIM(v_letra_nova)='' OR v_letra_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_letra||','||v_sem_credibilidade||');';
    END IF;

    -- COMPLEMENTO
    IF TRIM(v_complemento_novo)='' OR v_complemento_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_complemento||','||v_sem_credibilidade||');';
    END IF;

    -- BAIRRO
    IF TRIM(v_bairro_novo)='' OR v_bairro_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_bairro||','||v_sem_credibilidade||');';
    END IF;
    -- CEP
    IF v_cep_novo <= 0 OR v_cep_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cep||','||v_sem_credibilidade||');';
    END IF;

    -- CIDADE
    IF TRIM(v_cidade_nova)='' OR v_cidade_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cidade||','||v_sem_credibilidade||');';
    END IF;

  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_endereco_pessoa_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_endereco_pessoa_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_cep_antigo      numeric;
  v_cep_novo      numeric;
  v_id_logradouro_antigo    numeric;
  v_id_logradouro_novo    numeric;
  v_id_bairro_antigo    numeric;
  v_id_bairro_novo    numeric;
  v_numero_antigo     numeric;
  v_numero_novo     numeric;
  v_letra_antiga      text;
  v_letra_nova      text;
  v_complemento_antigo    text;
  v_complemento_novo    text;
  v_tipo_endereco     numeric;
  v_comando     text;
  v_origem_gravacao   text;
  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;
  v_nova_credibilidade    numeric;

  v_registro      record;

  -- ID dos campos
  v_idcam_cep_correspondencia     numeric;
  v_idcam_id_logradouro_correspondencia   numeric;
  v_idcam_id_bairro_correspondencia   numeric;
  v_idcam_numero_correspondencia      numeric;
  v_idcam_letra_correspondencia     numeric;
  v_idcam_complemento_correspondencia   numeric;

  v_idcam_cep_residencial       numeric;
  v_idcam_id_logradouro_residencial   numeric;
  v_idcam_id_bairro_residencial     numeric;
  v_idcam_numero_residencial      numeric;
  v_idcam_letra_residencial     numeric;
  v_idcam_complemento_residencial     numeric;

  v_idcam_cep_comercial       numeric;
  v_idcam_id_logradouro_comercial     numeric;
  v_idcam_id_bairro_comercial     numeric;
  v_idcam_numero_comercial      numeric;
  v_idcam_letra_comercial       numeric;
  v_idcam_complemento_comercial     numeric;

  v_idcam_cep     numeric;
  v_idcam_id_logradouro   numeric;
  v_idcam_id_bairro   numeric;
  v_idcam_numero      numeric;
  v_idcam_letra     numeric;
  v_idcam_complemento   numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Mxima, 2 = Alta, 3 = Mdia, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migrao, U = Usurio, C = Rotina de confrontao, O = Oscar
  */
  BEGIN
    v_idpes       := NEW.idpes;
    v_tipo_endereco     := NEW.tipo;

    v_cep_novo      := NEW.cep;
    v_id_logradouro_novo    := NEW.idlog;
    v_id_bairro_novo    := NEW.idbai;
    v_numero_novo     := NEW.numero;
    v_letra_nova      := NEW.letra;
    v_complemento_novo    := NEW.complemento;

    IF TG_OP <> 'UPDATE' THEN
      v_cep_antigo    := 0;
      v_id_logradouro_antigo  := 0;
      v_id_bairro_antigo  := 0;
      v_numero_antigo   := 0;
      v_letra_antiga    := '';
      v_complemento_antigo  := '';
    ELSE
      v_cep_antigo    := COALESCE(OLD.cep, 0);
      v_id_logradouro_antigo  := COALESCE(OLD.idlog, 0);
      v_id_bairro_antigo  := COALESCE(OLD.idbai, 0);
      v_numero_antigo   := COALESCE(OLD.numero, 0);
      v_letra_antiga    := COALESCE(OLD.letra, '');
      v_complemento_antigo  := COALESCE(OLD.complemento, '');
    END IF;

    v_idcam_cep_correspondencia     := 53;
    v_idcam_id_logradouro_correspondencia   := 47;
    v_idcam_id_bairro_correspondencia   := 52;
    v_idcam_numero_correspondencia      := 49;
    v_idcam_letra_correspondencia     := 50;
    v_idcam_complemento_correspondencia   := 51;
    v_idcam_cep_residencial       := 62;
    v_idcam_id_logradouro_residencial   := 56;
    v_idcam_id_bairro_residencial     := 61;
    v_idcam_numero_residencial      := 58;
    v_idcam_letra_residencial     := 59;
    v_idcam_complemento_residencial     := 60;
    v_idcam_cep_comercial       := 71;
    v_idcam_id_logradouro_comercial     := 65;
    v_idcam_id_bairro_comercial     := 70;
    v_idcam_numero_comercial      := 67;
    v_idcam_letra_comercial       := 68;
    v_idcam_complemento_comercial     := 69;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;
    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usurio ou pelo usurio do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migrao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;
    IF v_tipo_endereco = 1 THEN
      v_idcam_cep     := v_idcam_cep_correspondencia;
      v_idcam_id_logradouro   := v_idcam_id_logradouro_correspondencia;
      v_idcam_id_bairro   := v_idcam_id_bairro_correspondencia;
      v_idcam_numero      := v_idcam_numero_correspondencia;
      v_idcam_letra     := v_idcam_letra_correspondencia;
      v_idcam_complemento   := v_idcam_complemento_correspondencia;
    ELSIF v_tipo_endereco = 2 THEN
      v_idcam_cep     := v_idcam_cep_residencial;
      v_idcam_id_logradouro   := v_idcam_id_logradouro_residencial;
      v_idcam_id_bairro   := v_idcam_id_bairro_residencial;
      v_idcam_numero      := v_idcam_numero_residencial;
      v_idcam_letra     := v_idcam_letra_residencial;
      v_idcam_complemento   := v_idcam_complemento_residencial;
    ELSIF v_tipo_endereco = 3 THEN
      v_idcam_cep     := v_idcam_cep_comercial;
      v_idcam_id_logradouro   := v_idcam_id_logradouro_comercial;
      v_idcam_id_bairro   := v_idcam_id_bairro_comercial;
      v_idcam_numero      := v_idcam_numero_comercial;
      v_idcam_letra     := v_idcam_letra_comercial;
      v_idcam_complemento   := v_idcam_complemento_comercial;
    END IF;
    IF v_nova_credibilidade > 0 THEN
      -- CEP
      IF v_cep_novo <> v_cep_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cep||','||v_nova_credibilidade||');';
      END IF;
      -- ID LOGRADOURO
      IF v_id_logradouro_novo <> v_id_logradouro_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_id_logradouro||','||v_nova_credibilidade||');';
      END IF;
      -- BAIRRO
      IF v_id_bairro_novo <> v_id_bairro_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_id_bairro||','||v_nova_credibilidade||');';
      END IF;

      -- NUMERO
      IF v_numero_novo <> v_numero_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero||','||v_nova_credibilidade||');';
      END IF;

      -- LETRA
      IF v_letra_nova <> v_letra_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_letra||','||v_nova_credibilidade||');';
      END IF;

      -- COMPLEMENTO
      IF v_complemento_novo <> v_complemento_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_complemento||','||v_nova_credibilidade||');';
      END IF;
    END IF;

    -- Verificar os campos Vazios ou Nulos

    -- CEP
    IF v_cep_novo <= 0 OR v_cep_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cep||','||v_sem_credibilidade||');';
    END IF;

    -- ID LOGRADOURO
    IF v_id_logradouro_novo <= 0 OR v_id_logradouro_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_id_logradouro||','||v_sem_credibilidade||');';
    END IF;

    -- BAIRRO
    IF v_id_bairro_novo <= 0 OR v_id_bairro_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_id_bairro||','||v_sem_credibilidade||');';
    END IF;

    -- NUMERO
    IF v_numero_novo <= 0 OR v_numero_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_numero||','||v_sem_credibilidade||');';
    END IF;

    -- LETRA
    IF TRIM(v_letra_nova)='' OR v_letra_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_letra||','||v_sem_credibilidade||');';
    END IF;

    -- COMPLEMENTO
    IF TRIM(v_complemento_novo)='' OR v_complemento_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_complemento||','||v_sem_credibilidade||');';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_fisica_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_fisica_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_data_nasc_nova    date;
  v_data_nasc_antiga    date;
  v_sexo_novo     text;
  v_sexo_antigo     text;
  v_nome_mae_novo     text;
  v_nome_mae_antigo   text;
  v_nome_pai_novo     text;
  v_nome_pai_antigo   text;
  v_nome_conjuge_novo   text;
  v_nome_conjuge_antigo   text;
  v_nome_responsavel_novo   text;
  v_nome_responsavel_antigo text;
  v_nome_ultima_empresa_novo  text;
  v_nome_ultima_empresa_antigo  text;
  v_id_ocupacao_novo    numeric;
  v_id_ocupacao_antigo    numeric;
  v_id_escolaridade_novo    numeric;
  v_id_escolaridade_antigo  numeric;
  v_id_estado_civil_novo    numeric;
  v_id_estado_civil_antigo  numeric;
  v_id_pais_origem_novo   numeric;
  v_id_pais_origem_antigo   numeric;
  v_data_chegada_brasil_nova  date;
  v_data_chegada_brasil_antiga  date;
  v_data_obito_nova   date;
  v_data_obito_antiga   date;
  v_data_uniao_nova   date;
  v_data_uniao_antiga   date;

  v_comando     text;
  v_origem_gravacao   text;

  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;

  v_nova_credibilidade    numeric;

  v_registro      record;
  v_aux_data_nova     text;
  v_aux_data_antiga   text;

  -- ID dos campos
  v_idcam_data_nasc   numeric;
  v_idcam_sexo      numeric;
  v_idcam_nome_mae    numeric;
  v_idcam_nome_pai    numeric;
  v_idcam_nome_conjuge    numeric;
  v_idcam_nome_responsavel  numeric;
  v_idcam_nome_ultima_empresa numeric;
  v_idcam_ocupacao    numeric;
  v_idcam_escolaridade    numeric;
  v_idcam_estado_civil    numeric;
  v_idcam_pais_origem   numeric;
  v_idcam_data_chegada_brasil numeric;
  v_idcam_data_obito    numeric;
  v_idcam_data_uniao    numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Mxima, 2 = Alta, 3 = Mdia, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migrao, U = Usurio, C = Rotina de confrontao, O = Oscar
  */
  BEGIN
    v_idpes       := NEW.idpes;
    v_data_nasc_nova    := NEW.data_nasc;
    v_sexo_novo     := NEW.sexo;
    v_nome_mae_novo     := NEW.nome_mae;
    v_nome_pai_novo     := NEW.nome_pai;
    v_nome_conjuge_novo   := NEW.nome_conjuge;
    v_nome_responsavel_novo   := NEW.nome_responsavel;
    v_nome_ultima_empresa_novo  := NEW.ultima_empresa;
    v_id_ocupacao_novo    := NEW.idocup;
    v_id_escolaridade_novo    := NEW.idesco;
    v_id_estado_civil_novo    := NEW.ideciv;
    v_id_pais_origem_novo   := NEW.idpais_estrangeiro;
    v_data_chegada_brasil_nova  := NEW.data_chegada_brasil;
    v_data_obito_nova   := NEW.data_obito;
    v_data_uniao_nova   := NEW.data_uniao;

    IF TG_OP <> 'UPDATE' THEN
      v_data_nasc_antiga    := NULL;
      v_sexo_antigo     := '';
      v_nome_mae_antigo   := '';
      v_nome_pai_antigo   := '';
      v_nome_conjuge_antigo   := '';
      v_nome_responsavel_antigo := '';
      v_nome_ultima_empresa_antigo  := '';
      v_id_ocupacao_antigo    := 0;
      v_id_escolaridade_antigo  := 0;
      v_id_estado_civil_antigo  := 0;
      v_id_pais_origem_antigo   := 0;
      v_data_chegada_brasil_antiga  := NULL;
      v_data_obito_antiga   := NULL;
      v_data_uniao_antiga   := NULL;
    ELSE
      v_data_nasc_antiga    := OLD.data_nasc;
      v_sexo_antigo     := COALESCE(OLD.sexo, '');
      v_nome_mae_antigo   := COALESCE(OLD.nome_mae, '');
      v_nome_pai_antigo   := COALESCE(OLD.nome_pai, '');
      v_nome_conjuge_antigo   := COALESCE(OLD.nome_conjuge, '');
      v_nome_responsavel_antigo := COALESCE(OLD.nome_responsavel, '');
      v_nome_ultima_empresa_antigo  := COALESCE(OLD.ultima_empresa, '');
      v_id_ocupacao_antigo    := COALESCE(OLD.idocup, 0);
      v_id_escolaridade_antigo  := COALESCE(OLD.idesco, 0);
      v_id_estado_civil_antigo  := COALESCE(OLD.ideciv, 0);
      v_id_pais_origem_antigo   := COALESCE(OLD.idpais_estrangeiro, 0);
      v_data_chegada_brasil_antiga  := OLD.data_chegada_brasil;
      v_data_obito_antiga   := OLD.data_obito;
      v_data_uniao_antiga   := OLD.data_uniao;
    END IF;

    v_idcam_data_nasc   := 5;
    v_idcam_sexo      := 26;
    v_idcam_nome_mae    := 27;
    v_idcam_nome_pai    := 28;
    v_idcam_nome_conjuge    := 29;
    v_idcam_nome_responsavel  := 30;
    v_idcam_nome_ultima_empresa := 31;
    v_idcam_ocupacao    := 32;
    v_idcam_escolaridade    := 33;
    v_idcam_estado_civil    := 34;
    v_idcam_pais_origem   := 35;
    v_idcam_data_chegada_brasil := 36;
    v_idcam_data_obito    := 37;
    v_idcam_data_uniao    := 38;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;

    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usurio ou pelo usurio do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migrao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;

    IF v_nova_credibilidade > 0 THEN

      -- DATA DE NASCIMENTO
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_nasc_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_nasc_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_nasc||','||v_nova_credibilidade||');';
      END IF;

      -- DATA DE UNIO
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_uniao_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_uniao_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_uniao||','||v_nova_credibilidade||');';
      END IF;

      -- DATA DE BITO
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_obito_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_obito_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_obito||','||v_nova_credibilidade||');';
      END IF;

      -- DATA DE CHEGADA AO BRASIL
      v_aux_data_nova := COALESCE(TO_CHAR (v_data_chegada_brasil_nova, 'DD/MM/YYYY'), '');
      v_aux_data_antiga := COALESCE(TO_CHAR (v_data_chegada_brasil_antiga, 'DD/MM/YYYY'), '');

      IF v_aux_data_nova <> v_aux_data_antiga THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_chegada_brasil||','||v_nova_credibilidade||');';
      END IF;

      -- NOME DA ME
      IF v_nome_mae_novo <> v_nome_mae_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_mae||','||v_nova_credibilidade||');';
      END IF;

      -- NOME DO PAI
      IF v_nome_pai_novo <> v_nome_pai_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_pai||','||v_nova_credibilidade||');';
      END IF;

      -- NOME DO CONJUGE
      IF v_nome_conjuge_novo <> v_nome_conjuge_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_conjuge||','||v_nova_credibilidade||');';
      END IF;

      -- NOME DO RESPONSAVEL
      IF v_nome_responsavel_novo <> v_nome_responsavel_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_responsavel||','||v_nova_credibilidade||');';
      END IF;

      -- NOME LTIMA EMPRESA
      IF v_nome_ultima_empresa_novo <> v_nome_ultima_empresa_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_ultima_empresa||','||v_nova_credibilidade||');';
      END IF;

      -- SEXO
      IF v_sexo_novo <> v_sexo_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_sexo||','||v_nova_credibilidade||');';
      END IF;

      -- ID OCUPAO PROFISSIONAL
      IF v_id_ocupacao_novo <> v_id_ocupacao_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_ocupacao||','||v_nova_credibilidade||');';
      END IF;

      -- ID ESCOLARIDADE
      IF v_id_escolaridade_novo <> v_id_escolaridade_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_escolaridade||','||v_nova_credibilidade||');';
      END IF;

      -- ID ESTADO CIVIL
      IF v_id_estado_civil_novo <> v_id_estado_civil_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_estado_civil||','||v_nova_credibilidade||');';
      END IF;

      -- ID PAIS ORIGEM
      IF v_id_pais_origem_novo <> v_id_pais_origem_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_pais_origem||','||v_nova_credibilidade||');';
      END IF;

    END IF;

    -- Verificar os campos Vazios ou Nulos
    -- DATA DE NASCIMENTO
    IF TRIM(v_data_nasc_nova)='' OR v_data_nasc_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_nasc||','||v_sem_credibilidade||');';
    END IF;
    -- DATA DE UNIO
    IF TRIM(v_data_uniao_nova)='' OR v_data_uniao_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_uniao||','||v_sem_credibilidade||');';
    END IF;
    -- DATA DE BITO
    IF TRIM(v_data_obito_nova)='' OR v_data_obito_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_obito||','||v_sem_credibilidade||');';
    END IF;
    -- DATA DE CHEGADA AO BRASIL
    IF TRIM(v_data_chegada_brasil_nova)='' OR v_data_chegada_brasil_nova IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_data_chegada_brasil||','||v_sem_credibilidade||');';
    END IF;
    -- NOME DA ME
    IF TRIM(v_nome_mae_novo)='' OR v_nome_mae_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_mae||','||v_sem_credibilidade||');';
    END IF;
    -- NOME DO PAI
    IF TRIM(v_nome_pai_novo)='' OR v_nome_pai_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_pai||','||v_sem_credibilidade||');';
    END IF;
    -- NOME DO CONJUGE
    IF TRIM(v_nome_conjuge_novo)='' OR v_nome_conjuge_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_conjuge||','||v_sem_credibilidade||');';
    END IF;
    -- NOME DO RESPONSAVEL
    IF TRIM(v_nome_responsavel_novo)='' OR v_nome_responsavel_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_responsavel||','||v_sem_credibilidade||');';
    END IF;
    -- NOME LTIMA EMPRESA
    IF TRIM(v_nome_ultima_empresa_novo)='' OR v_nome_ultima_empresa_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome_ultima_empresa||','||v_sem_credibilidade||');';
    END IF;
    -- SEXO
    IF TRIM(v_sexo_novo)='' OR v_sexo_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_sexo||','||v_sem_credibilidade||');';
    END IF;
    -- ID OCUPAO PROFISSIONAL
    IF v_id_ocupacao_novo <= 0 OR v_id_ocupacao_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_ocupacao||','||v_sem_credibilidade||');';
    END IF;
    -- ID ESCOLARIDADE
    IF v_id_escolaridade_novo <= 0 OR v_id_escolaridade_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_escolaridade||','||v_sem_credibilidade||');';
    END IF;
    -- ID ESTADO CIVIL
    IF v_id_estado_civil_novo <= 0 OR v_id_estado_civil_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_estado_civil||','||v_sem_credibilidade||');';
    END IF;
    -- ID PAIS ORIGEM
    IF v_id_pais_origem_novo <= 0 OR v_id_pais_origem_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_pais_origem||','||v_sem_credibilidade||');';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_fone_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_fone_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;

  v_ddd_antigo      numeric;
  v_ddd_novo      numeric;
  v_fone_antigo     numeric;
  v_fone_novo     numeric;
  v_tipo_fone     numeric;

  v_comando     text;
  v_origem_gravacao   text;

  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;

  v_nova_credibilidade    numeric;

  v_registro      record;

  -- ID dos campos
  v_idcam_ddd_fone_residencial  numeric;
  v_idcam_fone_residencial  numeric;
  v_idcam_ddd_fone_comercial  numeric;
  v_idcam_fone_comercial    numeric;
  v_idcam_ddd_fone_celular  numeric;
  v_idcam_fone_celular    numeric;
  v_idcam_ddd_fax     numeric;
  v_idcam_fax     numeric;

  v_idcam_ddd     numeric;
  v_idcam_fone      numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Mxima, 2 = Alta, 3 = Mdia, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migrao, U = Usurio, C = Rotina de confrontao, O = Oscar
  */
  BEGIN
    v_idpes   := NEW.idpes;
    v_tipo_fone := NEW.tipo;
    v_ddd_novo  := NEW.ddd;
    v_fone_novo := NEW.fone;

    IF TG_OP <> 'UPDATE' THEN
      v_ddd_antigo  := 0;
      v_fone_antigo := 0;
    ELSE
      v_ddd_antigo  := COALESCE(OLD.ddd, 0);
      v_fone_antigo := COALESCE(OLD.fone, 0);
    END IF;

    v_idcam_ddd_fone_residencial  := 39;
    v_idcam_fone_residencial  := 40;
    v_idcam_ddd_fone_comercial  := 41;
    v_idcam_fone_comercial    := 42;
    v_idcam_ddd_fone_celular  := 43;
    v_idcam_fone_celular    := 44;
    v_idcam_ddd_fax     := 45;
    v_idcam_fax     := 46;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;

    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usurio ou usurio do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migrao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;

    IF v_tipo_fone = 1 THEN
      v_idcam_ddd := v_idcam_ddd_fone_residencial;
      v_idcam_fone := v_idcam_fone_residencial;
    ELSIF v_tipo_fone = 2 THEN
      v_idcam_ddd := v_idcam_ddd_fone_comercial;
      v_idcam_fone := v_idcam_fone_comercial;
    ELSIF v_tipo_fone = 3 THEN
      v_idcam_ddd := v_idcam_ddd_fone_celular;
      v_idcam_fone := v_idcam_fone_celular;
    ELSIF v_tipo_fone = 4 THEN
      v_idcam_ddd := v_idcam_ddd_fax;
      v_idcam_fone := v_idcam_fax;
    END IF;

    IF v_nova_credibilidade > 0 THEN
      IF v_ddd_novo <> v_ddd_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_ddd||','||v_nova_credibilidade||');';
      END IF;

      IF v_fone_novo <> v_fone_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_fone||','||v_nova_credibilidade||');';
      END IF;
    END IF;

    -- Verificar os campos Vazios ou Nulos
    IF v_ddd_novo <= 0 OR v_ddd_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_ddd||','||v_sem_credibilidade||');';
    END IF;
    IF v_fone_novo <= 0 OR v_fone_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_fone||','||v_sem_credibilidade||');';
    END IF;

  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_gravar_historico_campo(numeric, numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_gravar_historico_campo(numeric, numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  v_idpes ALIAS for $1;
  v_idcam ALIAS for $2;
  v_credibilidade ALIAS for $3;

  v_comando   text;
  v_existe_historico  numeric;
  v_registro    record;

  BEGIN
    -- verificar se j existe histrico para o campo
    v_comando := 'SELECT idcam FROM consistenciacao.historico_campo WHERE idpes='||quote_literal(v_idpes)||' AND idcam='||quote_literal(v_idcam)||';';
    FOR v_registro IN EXECUTE v_comando LOOP
      v_existe_historico := v_registro.idcam;
    END LOOP;
    IF v_existe_historico > 0 THEN
      EXECUTE 'UPDATE consistenciacao.historico_campo SET credibilidade='||v_credibilidade||', data_hora=CURRENT_TIMESTAMP WHERE idpes='||quote_literal(v_idpes)||' AND idcam='||quote_literal(v_idcam)||';';
    ELSE
      EXECUTE 'INSERT INTO consistenciacao.historico_campo(idpes, idcam, credibilidade, data_hora) VALUES ('||quote_literal(v_idpes)||','|| quote_literal(v_idcam)||', '||quote_literal(v_credibilidade)||', CURRENT_TIMESTAMP);';
    END IF;
  RETURN 1;
END; $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_juridica_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_juridica_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_cnpj_novo     numeric;
  v_cnpj_antigo     numeric;
  v_fantasia_novo     text;
  v_fantasia_antigo   text;
  v_inscricao_estadual_novo numeric;
  v_inscricao_estadual_antigo numeric;

  v_comando     text;
  v_origem_gravacao   text;

  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;

  v_nova_credibilidade    numeric;

  v_registro      record;

  -- ID dos campos
  v_idcam_cnpj      numeric;
  v_idcam_fantasia    numeric;
  v_idcam_inscricao_estadual  numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Mxima, 2 = Alta, 3 = Mdia, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migrao, U = Usurio, C = Rotina de confrontao, O = Oscar
  */
  BEGIN
    v_idpes       := NEW.idpes;
    v_cnpj_novo     := NEW.cnpj;
    v_fantasia_novo     := NEW.fantasia;
    v_inscricao_estadual_novo := NEW.insc_estadual;

    IF TG_OP <> 'UPDATE' THEN
      v_cnpj_antigo     := 0;
      v_fantasia_antigo   := '';
      v_inscricao_estadual_antigo := 0;
    ELSE
      v_cnpj_antigo     := COALESCE(OLD.cnpj, 0);
      v_fantasia_antigo   := COALESCE(OLD.fantasia, '');
      v_inscricao_estadual_antigo := COALESCE(OLD.insc_estadual, 0);
    END IF;

    v_idcam_cnpj      := 1;
    v_idcam_fantasia    := 24;
    v_idcam_inscricao_estadual  := 25;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;

    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usurio ou pelo usurio do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migrao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;

    IF v_nova_credibilidade > 0 THEN

      -- CNPJ
      IF v_cnpj_novo <> v_cnpj_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cnpj||','||v_nova_credibilidade||');';
      END IF;

      -- NOME FANTASIA
      IF v_fantasia_novo <> v_fantasia_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_fantasia||','||v_nova_credibilidade||');';
      END IF;

      -- INSCRIO ESTADUAL
      IF v_inscricao_estadual_novo <> v_inscricao_estadual_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_inscricao_estadual||','||v_nova_credibilidade||');';
      END IF;
    END IF;

    -- Verificar os campos Vazios ou Nulos
    -- CNPJ
    IF v_cnpj_novo <= 0 OR v_cnpj_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_cnpj||','||v_sem_credibilidade||');';
    END IF;
    -- NOME FANTASIA
    IF TRIM(v_fantasia_novo)='' OR v_fantasia_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_fantasia||','||v_sem_credibilidade||');';
    END IF;

    -- INSCRIO ESTADUAL
    IF v_inscricao_estadual_novo <= 0 OR v_inscricao_estadual_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_inscricao_estadual||','||v_sem_credibilidade||');';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_pessoa_historico_campo(); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_pessoa_historico_campo() RETURNS "trigger"
    AS $$
DECLARE
  v_idpes       numeric;
  v_nome_novo     text;
  v_nome_antigo     text;
  v_email_novo      text;
  v_email_antigo      text;
  v_url_novo      text;
  v_url_antigo      text;

  v_comando     text;
  v_origem_gravacao   text;

  v_credibilidade_maxima    numeric;
  v_credibilidade_alta    numeric;
  v_sem_credibilidade   numeric;

  v_nova_credibilidade    numeric;

  v_registro      record;

  -- ID dos campos
  v_idcam_nome      numeric;
  v_idcam_email     numeric;
  v_idcam_url     numeric;

  /*
  consistenciacao.historico_campo.credibilidade: 1 = Mxima, 2 = Alta, 3 = Mdia, 4 = Baixa, 5 = Sem credibilidade
  cadastro.pessoa.origem_gravacao: M = Migrao, U = Usurio, C = Rotina de confrontao, O = Oscar
  */
  BEGIN
    v_idpes   := NEW.idpes;
    v_nome_novo := NEW.nome;
    v_email_novo  := NEW.email;
    v_url_novo  := NEW.url;

    IF TG_OP <> 'UPDATE' THEN
      v_nome_antigo := '';
      v_email_antigo  := '';
      v_url_antigo  := '';
    ELSE
      v_nome_antigo := COALESCE(OLD.nome, '');
      v_email_antigo  := COALESCE(OLD.email, '');
      v_url_antigo  := COALESCE(OLD.url, '');
    END IF;

    v_idcam_nome  := 2;
    v_idcam_email := 3;
    v_idcam_url := 4;

    v_nova_credibilidade := 0;
    v_credibilidade_maxima := 1;
    v_credibilidade_alta := 2;
    v_sem_credibilidade := 5;
    v_comando := 'SELECT origem_gravacao FROM cadastro.pessoa WHERE idpes='||quote_literal(v_idpes)||';';

    FOR v_registro IN EXECUTE v_comando LOOP
      v_origem_gravacao := v_registro.origem_gravacao;
    END LOOP;

    IF v_origem_gravacao = 'U' OR v_origem_gravacao = 'O' THEN -- os dados foram editados pelo usurio ou pelo usurio do Oscar
      v_nova_credibilidade := v_credibilidade_maxima;
    ELSIF v_origem_gravacao = 'M' THEN -- os dados foram originados por migrao
      v_nova_credibilidade := v_credibilidade_alta;
    END IF;

    IF v_nova_credibilidade > 0 THEN

      -- NOME
      IF v_nome_novo <> v_nome_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome||','||v_nova_credibilidade||');';
      END IF;

      -- E-MAIL
      IF v_email_novo <> v_email_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_email||','||v_nova_credibilidade||');';
      END IF;

      -- URL
      IF v_url_novo <> v_url_antigo THEN
        EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_url||','||v_nova_credibilidade||');';
      END IF;
    END IF;

    -- Verificar os campos Vazios ou Nulos
    -- NOME
    IF TRIM(v_nome_novo)='' OR v_nome_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_nome||','||v_sem_credibilidade||');';
    END IF;
    -- E-MAIL
    IF TRIM(v_email_novo)='' OR v_email_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_email||','||v_sem_credibilidade||');';
    END IF;
    -- URL
    IF TRIM(v_url_novo)='' OR v_url_novo IS NULL THEN
      EXECUTE 'SELECT consistenciacao.fcn_gravar_historico_campo('||v_idpes||','||v_idcam_url||','||v_sem_credibilidade||');';
    END IF;
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_cadastro(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_cadastro(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpesVelho     ALIAS for $1;
  v_idpesNovo      ALIAS for $2;
  v_cpfAux           NUMERIC;
  v_cpfIdpesNovo     NUMERIC;
  v_reg          record;
  v_regAux         record;
BEGIN
  --Unificando registros das tabelas do cadastros de pessoas--
  SET search_path = cadastro, pg_catalog;
  --FONE_PESSOA--
  FOR v_reg IN SELECT *
       FROM fone_pessoa
       WHERE
       idpes = v_idpesVelho AND
       tipo NOT IN (SELECT tipo FROM fone_pessoa WHERE idpes = v_idpesNovo) LOOP
    INSERT INTO fone_pessoa (idpes, tipo, ddd, fone) VALUES (v_idpesNovo,v_reg.tipo, v_reg.ddd, v_reg.fone);
  END LOOP;
  --Atualizando os telefones do idpeNovo que tenham o DDD e o FONE igual a zero--
  FOR v_reg IN SELECT * FROM fone_pessoa WHERE idpes = v_idpesNovo AND ddd = 0 AND fone = 0 LOOP
    DELETE FROM fone_pessoa WHERE idpes = v_reg.idpes AND tipo = v_reg.tipo;
    FOR v_regAux IN SELECT * FROM fone_pessoa WHERE idpes = v_idpesVelho AND tipo = v_reg.tipo LOOP
      INSERT INTO fone_pessoa(idpes,tipo,ddd,fone) VALUES (v_reg.idpes,v_regAux.tipo,v_regAux.ddd,v_regAux.fone);
    END LOOP;
  END LOOP;
  DELETE FROM fone_pessoa WHERE idpes = v_idpesVelho;
  --JURIDICA--
  DELETE FROM juridica WHERE idpes = v_idpesVelho;
  --HISTORICO_CARTAO--
  UPDATE historico_cartao SET idpes_cidadao = v_idpesNovo WHERE idpes_cidadao = v_idpesVelho;
  --ENDERECO_PESSOA--
  FOR v_reg IN SELECT *
         FROM endereco_pessoa
         WHERE
         idpes = v_idpesVelho AND
         tipo NOT IN (SELECT tipo FROM endereco_pessoa WHERE idpes = v_idpesNovo) LOOP
    INSERT INTO endereco_pessoa (idpes, tipo, cep, idlog, idbai, numero, letra, complemento, reside_desde)
    VALUES (v_idpesNovo,v_reg.tipo, v_reg.cep, v_reg.idlog, v_reg.idbai, v_reg.numero, v_reg.letra, v_reg.complemento, v_reg.reside_desde);
  END LOOP;
  DELETE FROM endereco_pessoa WHERE idpes = v_idpesVelho;
  --ENDERECO_EXTERNO--
  FOR v_reg IN SELECT *
     FROM endereco_externo
     WHERE
     idpes = v_idpesVelho AND
     tipo NOT IN (SELECT tipo FROM endereco_externo WHERE idpes = v_idpesNovo) LOOP
    INSERT INTO endereco_externo (idpes, tipo, idtlog, logradouro, numero, letra, complemento, bairro, cep, cidade, sigla_uf,reside_desde)
    VALUES (v_idpesNovo, v_reg.tipo, v_reg.idtlog, v_reg.logradouro, v_reg.numero, v_reg.letra, v_reg.complemento, v_reg.bairro, v_reg.cep, v_reg.cidade, v_reg.sigla_uf,v_reg.reside_desde);
  END LOOP;
  DELETE FROM endereco_externo WHERE idpes = v_idpesVelho;
  --FISICA_CPF--
  --Obtendo enventual CPF da pessoa antiga para ser inserido na pessoa nova--
  FOR v_reg IN SELECT cpf FROM fisica_cpf WHERE idpes = v_idpesVelho AND idpes <> v_idpesNovo LOOP
    v_cpfAux := v_reg.cpf;
  END LOOP;
  DELETE FROM fisica_cpf WHERE idpes = v_idpesVelho;
  IF v_cpfAux IS NOT NULL THEN
    FOR v_reg IN SELECT cpf FROM fisica_cpf WHERE idpes = v_idpesNovo LOOP
      v_cpfIdpesNovo := v_reg.cpf;
    END LOOP;
    --Verificando se o idpess j possu um CPF--
    IF v_cpfIdpesNovo IS NULL THEN
      INSERT INTO fisica_cpf (idpes, cpf) VALUES (v_idpesNovo,v_cpfAux);
    END IF;
  END IF;
  --FUNCIONARIO--
  UPDATE funcionario SET idpes = v_idpesNovo WHERE idpes = v_idpesVelho;
  --DOCUMENTO--
  DELETE FROM documento WHERE idpes = v_idpesVelho;
  --FISICA--
  DELETE FROM fisica WHERE idpes = v_idpesVelho;
  --PESSOA--
  DELETE FROM pessoa WHERE idpes = v_idpesVelho;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_cmf(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_cmf(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpesVelho ALIAS for $1;
  v_idpesNovo ALIAS for $2;

BEGIN
  --Unificando registros do SECM (Sistema de Emissao de Certidoes Municipais)--
  EXECUTE 'SELECT consistenciacao.fcn_unifica_secm('||v_idpesVelho||','||v_idpesNovo||');';
  --Unificando as tabelas do sistema de SGDO (Sistema de Gestao de Despesas Orcamentarias)--
  EXECUTE 'SELECT consistenciacao.fcn_unifica_sgdo('||v_idpesVelho||','||v_idpesNovo||');';
  --Unificando as tabelas do sistema de SGP (Sistema de Gerenciamento de Protocolo)--
  EXECUTE 'SELECT consistenciacao.fcn_unifica_sgp('||v_idpesVelho||','||v_idpesNovo||');';
  --Unificando as tabelas do sistema de SGPA (Sistema de Gestao da Praca de Atendimento)--
  EXECUTE 'SELECT consistenciacao.fcn_unifica_sgpa('||v_idpesVelho||','||v_idpesNovo||');';
  --Unificando as tabelas do sistema de SGSP (Sistema de Gerenciamento de Servicos consistenciacaoos)--
  EXECUTE 'SELECT consistenciacao.fcn_unifica_sgsp('||v_idpesVelho||','||v_idpesNovo||');';
      --Unificando registros das tabelas do SCD (Sistema de Consintenciacao de Dados)--
   EXECUTE 'SELECT consistenciacao.fcn_unifica_scd('||v_idpesVelho||','||v_idpesNovo||');';
  --Unificando registros das tabelas do SCA (Controle de acesso)--
  EXECUTE 'SELECT consistenciacao.fcn_unifica_sca('||v_idpesVelho||','||v_idpesNovo||');';
  --Unificando registros das tabelas de cadastro--
   EXECUTE 'SELECT consistenciacao.fcn_unifica_cadastro('||v_idpesVelho||','||v_idpesNovo||');';
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_sca(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_sca(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  --Parametro recebidos--
  v_idpesVelho ALIAS for $1;
  v_idpesNovo  ALIAS for $2;
  v_loginAux   varchar;
  v_reg      record;
BEGIN
  --Unificando registros das tabelas do SCA (Sistema de Controle de Acesso)--
  SET search_path = acesso, pg_catalog;
  --PESSOA_INSTITUICAO--
  --Inserindo as instituicoes do idvelho para o id novo--
  FOR v_reg IN SELECT *
               FROM pessoa_instituicao
               WHERE
         idpes = v_idpesVelho AND
         idins NOT IN
        (SELECT idins FROM
         pessoa_instituicao
         WHERE idpes = v_idpesNovo) LOOP
    INSERT INTO pessoa_instituicao (idpes,idins) VALUES (v_idpesNovo, v_reg.idins);
  END LOOP;
  --Apagando os registro do id velho--
  EXECUTE 'DELETE FROM pessoa_instituicao WHERE idpes = '||v_idpesVelho||';';
  --LOG_ACESSO--
  EXECUTE 'UPDATE log_acesso SET idpes ='||v_idpesNovo||' WHERE idpes = '||v_idpesVelho||';';
  --USUARIO_GRUPO--
  --Obtendo o login do novo idpes para ser usado na unificacao da tabela usuario_grupo--
  FOR v_reg IN SELECT login FROM usuario WHERE idpes = v_idpesNovo LOOP
    v_loginAux := v_reg.login;
  END LOOP;
  --Inserindo os grupos do idpes velho para o idpes novo--
  FOR v_reg IN SELECT *
         FROM usuario_grupo
         WHERE
         login IN (SELECT login FROM usuario WHERE idpes = v_idpesVelho) AND
         idgrp NOT IN (SELECT idgrp
                       FROM usuario_grupo
           WHERE
           login = v_loginAux) LOOP
    INSERT INTO usuario_grupo (idgrp,login) VALUES (v_reg.idgrp, v_loginAux);
  END LOOP;
  --Deletando os registros do idpes velho--
  EXECUTE 'DELETE FROM usuario_grupo
            WHERE login IN
         (SELECT login FROM usuario WHERE idpes ='|| v_idpesVelho ||');';
  --LOG_ERRO--
  EXECUTE 'UPDATE log_erro SET idpes = '||v_idpesNovo||' WHERE idpes = '||v_idpesVelho||';';

  --USUARIO--
  EXECUTE 'DELETE FROM usuario WHERE idpes ='|| v_idpesVelho||';';
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_scd(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_scd(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpesVelho ALIAS for $1;
  v_idpesNovo  ALIAS for $2;
BEGIN
  --Unificando registros das tabelas do SCD (Sistema de Consintenciacao de Dados)--
  SET search_path = consistenciacao, pg_catalog;
  --INCOERENCIA--
  UPDATE incoerencia_pessoa_possivel SET idpes =  v_idpesNovo WHERE idpes = v_idpesVelho;
  --CONFRONTACAO--
  UPDATE confrontacao SET idpes =  v_idpesNovo WHERE idpes = v_idpesVelho;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_sgp(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_sgp(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpesVelho ALIAS for $1;
  v_idpesNovo ALIAS for $2;
BEGIN
  --Unificando as tabelas do sistema de SGP (Sistema de Gerenciamento de Protocolo)--
  SET search_path = protocolo, pg_catalog;
  --ATIVIDADE--
  UPDATE atividade SET idpes_ini = v_idpesNovo WHERE idpes_ini = v_idpesVelho;
  UPDATE atividade SET idpes_fim = v_idpesNovo WHERE idpes_fim = v_idpesVelho;
  --LOG_FUNC_PROCESSO--
  UPDATE log_func_processo SET idpes = v_idpesNovo WHERE idpes = v_idpesVelho;
  --PROCESSO--
  UPDATE processo SET idpesreq = v_idpesNovo WHERE idpesreq = v_idpesVelho;
  UPDATE processo SET idpesfav = v_idpesNovo WHERE idpesfav = v_idpesVelho;
  --TEMP_ATIVIDADE--
  UPDATE temp_atividade SET idpes = v_idpesNovo WHERE idpes = v_idpesVelho;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_sgpa(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_sgpa(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpesVelho  ALIAS for $1;
  v_idpesNovo   ALIAS for $2;
  v_reg       record;
  v_idAtnVelho  numeric;
  v_idAtnNovo numeric;
BEGIN
  --Unificando as tabelas do sistema de SGPA (Sistema de getao da Praca de Atendimento)--
  SET search_path = praca, pg_catalog;
  --Obtendo o id do atendente velho para poder fazer UPDATE nas tabelas para o id do atendeentente novo--
  FOR v_reg IN SELECT idatn FROM atendente WHERE idpes = v_idpesVelho LOOP
    v_idAtnVelho := v_reg.idatn;
  END LOOP;
  FOR v_reg IN SELECT idatn FROM atendente WHERE idpes = v_idpesNovo LOOP
    v_idAtnNovo := v_reg.idatn;
  END LOOP;
  --ATENDIMENTO--
  UPDATE atendimento SET idpes = v_idpesNovo WHERE idpes = v_idpesVelho;
  UPDATE atendimento SET idatn = v_idAtnNovo WHERE idatn = v_idAtnVelho;
  --TURNO_ATENDENTE--
  FOR v_reg IN SELECT * FROM turno_atendente
         WHERE
         idatn = v_idAtnVelho AND
         idtur NOT IN (SELECT idtur FROM turno_atendente WHERE idatn = v_idAtnNovo) LOOP
    INSERT INTO turno_atendente (idmes,idins,idatn,idtur) VALUES (v_reg.idmes, v_reg.idins, v_idAtnNovo,v_reg.idtur);
  END LOOP;
  DELETE FROM turno_atendente WHERE idatn = v_idAtnVelho;
  --AUSENCIA--
  UPDATE ausencia SET idatn = v_idAtnNovo WHERE idatn = v_idAtnVelho;
  --SITUCAO_ATENDENTE--
  UPDATE situacao_atendente SET idatn = v_idAtnNovo WHERE idatn = v_idAtnVelho;
  --PRODUTIVIDADE--
  UPDATE produtividade SET idatn = v_idAtnNovo WHERE idatn = v_idAtnVelho;
  --ATENDENTE--
  DELETE FROM atendente WHERE idpes = v_idpesVelho;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_unifica_sgsp(numeric, numeric); Type: FUNCTION; Schema: consistenciacao; Owner: -
--

CREATE FUNCTION fcn_unifica_sgsp(numeric, numeric) RETURNS integer
    AS $_$
DECLARE
  -- Parametro recebidos
  v_idpesVelho ALIAS for $1;
  v_idpesNovo  ALIAS for $2;
  v_reg      record;
BEGIN
  --Unificando registros das tabelas do SGSP (Sistema de Gererenciamento de Servios Pblicos)--
  SET search_path = servicos, pg_catalog;
  --FUNCIONARIO_AUTORIZADO--
  FOR v_reg IN SELECT *
         FROM funcionario_autorizado
         WHERE
         idpes = v_idpesVelho AND
         idpes <> v_idpesNovo LOOP
    INSERT INTO funcionario_autorizado (idpes, idins) VALUES (v_idpesNovo, v_reg.idins);
  END LOOP;
  --SOLICITACAO_SERVICO--
  UPDATE solicitacao_servico SET idpes_atendente = v_idpesNovo WHERE idpes_atendente = v_idpesVelho;
  UPDATE solicitacao_servico SET idpes_planejamento = v_idpesNovo WHERE idpes_planejamento = v_idpesVelho;
  --SOLICITANTE--
  UPDATE solicitante SET idpes = v_idpesNovo WHERE idpes = v_idpesVelho;
  --ORDEM_SERVICO--
  UPDATE ordem_servico SET idpes = v_idpesNovo WHERE idpes = v_idpesVelho;
  --APROVACAO--
  UPDATE aprovacao SET idpes_resposta = v_idpesNovo WHERE idpes_resposta = v_idpesVelho;
  --AUTORIZACAO_DIARIA--
  UPDATE autorizacao_diaria SET idpes_usuario = v_idpesNovo WHERE idpes_usuario = v_idpesVelho;
  UPDATE autorizacao_diaria SET idpes_autorizacao = v_idpesNovo WHERE idpes_autorizacao = v_idpesVelho;
  --FUNCIONARIO_AUTORIZADO--
  DELETE FROM funcionario_autorizado WHERE idpes = v_idpesVelho;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


SET search_path = historico, pg_catalog;

--
-- Name: fcn_delete_grava_historico_bairro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_bairro() RETURNS "trigger"
    AS $$
DECLARE
   v_idbai    numeric;
   v_idmun    numeric;
   v_nome   varchar;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
BEGIN
   v_idbai    := OLD.idbai;
   v_idmun    := OLD.idmun;
   v_nome   := OLD.nome;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA BAIRRO
      INSERT INTO historico.bairro
      (idbai, idmun, nome, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idbai, v_idmun, v_nome, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_cep_logradouro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_cep_logradouro() RETURNS "trigger"
    AS $$
DECLARE
   v_cep    numeric;
   v_idlog    numeric;
   v_nroini   numeric;
   v_nrofin   numeric;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
BEGIN
   v_cep    := OLD.cep;
   v_idlog    := OLD.idlog;
   v_nroini   := OLD.nroini;
   v_nrofin   := OLD.nrofin;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA CEP_LOGRADOURO
      INSERT INTO historico.cep_logradouro
      (cep, idlog, nroini, nrofin, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_cep, v_idlog, v_nroini, v_nrofin, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_cep_logradouro_bairro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_cep_logradouro_bairro() RETURNS "trigger"
    AS $$
DECLARE
   v_idbai    numeric;
   v_idlog    numeric;
   v_cep    numeric;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idbai    := OLD.idbai;
   v_idlog    := OLD.idlog;
   v_cep    := OLD.cep;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA CEP_LOGRADOURO_BAIRRO
      INSERT INTO historico.cep_logradouro_bairro
      (idbai, idlog, cep, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idbai, v_idlog, v_cep, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_documento(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_documento() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_sigla_uf_exp_rg  char(2);
   v_rg     numeric;
   v_data_exp_rg  date;
   v_tipo_cert_civil  numeric;
   v_num_termo    numeric;
   v_num_livro    varchar;
   v_num_folha    numeric;
   v_data_emissao_cert_civil  date;
   v_sigla_uf_cert_civil  char(2);
   v_sigla_uf_cart_trabalho char(2);
   v_cartorio_cert_civil  varchar;
   v_num_cart_trabalho    numeric;
   v_serie_cart_trabalho  numeric;
   v_data_emissao_cart_trabalho date;
   v_num_tit_eleitor  numeric;
   v_zona_tit_eleitor numeric;
   v_secao_tit_eleitor  numeric;
   v_idorg_exp_rg   numeric;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
BEGIN
   v_idpes      := OLD.idpes;
   v_sigla_uf_exp_rg    := OLD.sigla_uf_exp_rg;
   v_rg       := OLD.rg;
   v_data_exp_rg    := OLD.data_exp_rg;
   v_tipo_cert_civil    := OLD.tipo_cert_civil;
   v_num_termo      := OLD.num_termo;
   v_num_livro      := OLD.num_livro;
   v_num_folha      := OLD.num_folha;
   v_data_emissao_cert_civil  := OLD.data_emissao_cert_civil;
   v_sigla_uf_cert_civil  := OLD.sigla_uf_cert_civil;
   v_sigla_uf_cart_trabalho := OLD.sigla_uf_cart_trabalho;
   v_cartorio_cert_civil  := OLD.cartorio_cert_civil;
   v_num_cart_trabalho    := OLD.num_cart_trabalho;
   v_serie_cart_trabalho  := OLD.serie_cart_trabalho;
   v_data_emissao_cart_trabalho := OLD.data_emissao_cart_trabalho;
   v_num_tit_eleitor    := OLD.num_tit_eleitor;
   v_zona_tit_eleitor   := OLD.zona_tit_eleitor;
   v_secao_tit_eleitor    := OLD.secao_tit_eleitor;
   v_idorg_exp_rg   := OLD.idorg_exp_rg;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA DOCUMENTO
      INSERT INTO historico.documento
      (idpes, sigla_uf_exp_rg, rg, data_exp_rg, tipo_cert_civil, num_termo, num_livro, num_folha, data_emissao_cert_civil, sigla_uf_cert_civil, sigla_uf_cart_trabalho, cartorio_cert_civil, num_cart_trabalho, serie_cart_trabalho, data_emissao_cart_trabalho, num_tit_eleitor, zona_tit_eleitor, secao_tit_eleitor, idorg_exp_rg, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_sigla_uf_exp_rg, v_rg, v_data_exp_rg, v_tipo_cert_civil, v_num_termo, v_num_livro, v_num_folha, v_data_emissao_cert_civil, v_sigla_uf_cert_civil, v_sigla_uf_cart_trabalho, v_cartorio_cert_civil, v_num_cart_trabalho, v_serie_cart_trabalho, v_data_emissao_cart_trabalho, v_num_tit_eleitor, v_zona_tit_eleitor, v_secao_tit_eleitor, v_idorg_exp_rg, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_endereco_externo(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_endereco_externo() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_tipo   numeric;
   v_sigla_uf   char(2);
   v_idtlog   varchar;
   v_logradouro   varchar;
   v_numero   numeric;
   v_letra    char(1);
   v_complemento  varchar;
   v_bairro   varchar;
   v_cep    numeric;
   v_cidade   varchar;
   v_reside_desde date;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
BEGIN
   v_idpes      := OLD.idpes;
   v_tipo     := OLD.tipo;
   v_sigla_uf     := OLD.sigla_uf;
   v_idtlog     := OLD.idtlog;
   v_logradouro     := OLD.logradouro;
   v_numero     := OLD.numero;
   v_letra      := OLD.letra;
   v_complemento    := OLD.complemento;
   v_bairro     := OLD.bairro;
   v_cep      := OLD.cep;
   v_cidade     := OLD.cidade;
   v_reside_desde   := OLD.reside_desde;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA ENDERECO_EXTERNO
      INSERT INTO historico.endereco_externo
      (idpes, tipo, sigla_uf, idtlog, logradouro, numero, letra, complemento, bairro, cep, cidade, reside_desde, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_tipo, v_sigla_uf, v_idtlog, v_logradouro, v_numero, v_letra, v_complemento, v_bairro, v_cep, v_cidade, v_reside_desde, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_endereco_pessoa(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_endereco_pessoa() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_tipo   numeric;
   v_cep    numeric;
   v_idlog    numeric;
   v_idbai    numeric;
   v_numero   numeric;
   v_letra    char(1);
   v_complemento  varchar;
   v_reside_desde date;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
BEGIN
   v_idpes    := OLD.idpes;
   v_tipo   := OLD.tipo;
   v_cep    := OLD.cep;
   v_idlog    := OLD.idlog;
   v_idbai    := OLD.idbai;
   v_numero   := OLD.numero;
   v_letra    := OLD.letra;
   v_complemento  := OLD.complemento;
   v_reside_desde := OLD.reside_desde;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA ENDERECO_PESSOA
      INSERT INTO historico.endereco_pessoa
      (idpes, tipo, cep, idlog, idbai, numero, letra, complemento, reside_desde, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_tipo, v_cep, v_idlog, v_idbai, v_numero, v_letra, v_complemento, v_reside_desde, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_fisica(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_fisica() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_data_nasc      date;
   v_sexo     char(1);
   v_idpes_mae      numeric;
   v_idpes_pai      numeric;
   v_idpes_responsavel    numeric;
   v_idesco     numeric;
   v_ideciv     numeric;
   v_idpes_con      numeric;
   v_data_uniao     date;
   v_data_obito     date;
   v_nacionalidade    numeric;
   v_idpais_estrangeiro   numeric;
   v_data_chegada_brasil  date;
   v_idmun_nascimento   numeric;
   v_ultima_empresa   varchar;
   v_idocup     numeric;
   v_nome_mae     varchar;
   v_nome_pai     varchar;
   v_nome_conjuge   varchar;
   v_nome_responsavel   varchar;
   v_justificativa_provisorio varchar;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idpes      := OLD.idpes;
   v_data_nasc      := OLD.data_nasc;
   v_sexo     := OLD.sexo;
   v_idpes_mae      := OLD.idpes_mae;
   v_idpes_pai      := OLD.idpes_pai;
   v_idpes_responsavel    := OLD.idpes_responsavel;
   v_idesco     := OLD.idesco;
   v_ideciv     := OLD.ideciv;
   v_idpes_con      := OLD.idpes_con;
   v_data_uniao     := OLD.data_uniao;
   v_data_obito     := OLD.data_obito;
   v_nacionalidade    := OLD.nacionalidade;
   v_idpais_estrangeiro   := OLD.idpais_estrangeiro;
   v_data_chegada_brasil  := OLD.data_chegada_brasil;
   v_idmun_nascimento   := OLD.idmun_nascimento;
   v_ultima_empresa   := OLD.ultima_empresa;
   v_idocup     := OLD.idocup;
   v_nome_mae     := OLD.nome_mae;
   v_nome_pai     := OLD.nome_pai;
   v_nome_conjuge   := OLD.nome_conjuge;
   v_nome_responsavel   := OLD.nome_responsavel;
   v_justificativa_provisorio := OLD.justificativa_provisorio;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FISICA
      INSERT INTO historico.fisica
      (idpes, data_nasc, sexo, idpes_mae, idpes_pai, idpes_responsavel, idesco, ideciv, idpes_con, data_uniao, data_obito, nacionalidade, idpais_estrangeiro, data_chegada_brasil, idmun_nascimento, ultima_empresa, idocup, nome_mae, nome_pai, nome_conjuge, nome_responsavel, justificativa_provisorio, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_data_nasc, v_sexo, v_idpes_mae, v_idpes_pai, v_idpes_responsavel, v_idesco, v_ideciv, v_idpes_con, v_data_uniao, v_data_obito, v_nacionalidade, v_idpais_estrangeiro, v_data_chegada_brasil, v_idmun_nascimento, v_ultima_empresa, v_idocup, v_nome_mae, v_nome_pai, v_nome_conjuge, v_nome_responsavel, v_justificativa_provisorio, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_fisica_cpf(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_fisica_cpf() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_cpf      numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idpes      := OLD.idpes;
   v_cpf      := OLD.cpf;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FISICA_CPF
      INSERT INTO historico.fisica_cpf
      (idpes, cpf, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_cpf, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_fone_pessoa(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_fone_pessoa() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_tipo     numeric;
   v_ddd      numeric;
   v_fone     numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idpes      := OLD.idpes;
   v_tipo     := OLD.tipo;
   v_ddd      := OLD.ddd;
   v_fone     := OLD.fone;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FONE_PESSOA
      INSERT INTO historico.fone_pessoa
      (idpes, tipo, ddd, fone, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_tipo, v_ddd, v_fone, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_funcionario(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_funcionario() RETURNS "trigger"
    AS $$
DECLARE
   v_matricula      numeric;
   v_idins      numeric;
   v_idset      numeric;
   v_idpes      numeric;
   v_situacao     char(1);
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_matricula      := OLD.matricula;
   v_idins      := OLD.idins;
   v_idset      := OLD.idset;
   v_idpes      := OLD.idpes;
   v_situacao     := OLD.situacao;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FUNCIONARIO
      INSERT INTO historico.funcionario
      (matricula, idins, idset, idpes, situacao, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_matricula, v_idins, v_idset, v_idpes, v_situacao, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_juridica(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_juridica() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_cnpj     numeric;
   v_fantasia     varchar;
   v_insc_estadual    numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idpes      := OLD.idpes;
   v_cnpj     := OLD.cnpj;
   v_fantasia     := OLD.fantasia;
   v_insc_estadual    := OLD.insc_estadual;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA JURIDICA
      INSERT INTO historico.juridica
      (idpes, cnpj, fantasia, insc_estadual, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_cnpj, v_fantasia, v_insc_estadual, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_logradouro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_logradouro() RETURNS "trigger"
    AS $$
DECLARE
   v_idlog      numeric;
   v_idtlog     varchar;
   v_nome     varchar;
   v_idmun      numeric;
   v_ident_oficial    char(1);
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idlog      := OLD.idlog;
   v_idtlog     := OLD.idtlog;
   v_nome     := OLD.nome;
   v_idmun      := OLD.idmun;
   v_ident_oficial    := OLD.ident_oficial;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA LOGRADOURO
      INSERT INTO historico.logradouro
      (idlog, idtlog, nome, idmun, ident_oficial, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idlog, v_idtlog, v_nome, v_idmun, v_ident_oficial, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_municipio(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_municipio() RETURNS "trigger"
    AS $$
DECLARE
   v_idmun      numeric;
   v_sigla_uf     char(2);
   v_nome     varchar;
   v_area_km2     numeric;
   v_idmreg     numeric;
   v_idasmun      numeric;
   v_cod_ibge     numeric;
   v_geom     TEXT;
   v_tipo     char(1);
   v_idmun_pai      numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idmun      := OLD.idmun;
   v_sigla_uf     := OLD.sigla_uf;
   v_nome     := OLD.nome;
   v_area_km2     := OLD.area_km2;
   v_idmreg     := OLD.idmreg;
   v_idasmun      := OLD.idasmun;
   v_cod_ibge     := OLD.cod_ibge;
   v_geom     := OLD.geom;
   v_tipo     := OLD.tipo;
   v_idmun_pai      := OLD.idmun_pai;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA MUNICIPIO
      INSERT INTO historico.municipio
      (idmun, sigla_uf, nome, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idmun, v_sigla_uf, v_nome, v_area_km2, v_idmreg, v_idasmun, v_cod_ibge, v_geom, v_tipo, v_idmun_pai, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_pessoa(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_pessoa() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_nome   TEXT;
   v_idpes_cad    numeric;
   v_data_cad   timestamp;
   v_url    TEXT;
   v_tipo   char;
   v_idpes_rev    numeric;
   v_data_rev   timestamp;
   v_email    TEXT;
   v_situacao   char;
   v_origem_gravacao  char;
   v_idsis_rev    numeric;
   v_idsis_cad    numeric;
BEGIN
   v_idpes    := OLD.idpes;
   v_nome   := OLD.nome;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_url    := OLD.url;
   v_tipo   := OLD.tipo;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_email    := OLD.email;
   v_situacao   := OLD.situacao;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idsis_cad    := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA PESSOA
      INSERT INTO historico.pessoa
      (idpes, nome, idpes_cad, data_cad, url, tipo, idpes_rev, data_rev, email, situacao, origem_gravacao, idsis_rev, idsis_cad, operacao) VALUES
      (v_idpes, v_nome, v_idpes_cad, v_data_cad, v_url, v_tipo, v_idpes_rev, v_data_rev, v_email, v_situacao, v_origem_gravacao, v_idsis_rev, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_grava_historico_socio(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_delete_grava_historico_socio() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes_juridica   numeric;
   v_idpes_fisica   numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
BEGIN
   v_idpes_juridica   := OLD.idpes_juridica;
   v_idpes_fisica   := OLD.idpes_fisica;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA SOCIO
      INSERT INTO historico.socio
      (idpes_juridica, idpes_fisica, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes_juridica, v_idpes_fisica, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, 'E');

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_bairro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_bairro() RETURNS "trigger"
    AS $$
DECLARE
   v_idbai    numeric;
   v_idmun    numeric;
   v_nome   varchar;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idbai    := OLD.idbai;
   v_idmun    := OLD.idmun;
   v_nome   := OLD.nome;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;
   v_operacao   := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA BAIRRO
      INSERT INTO historico.bairro
      (idbai, idmun, nome, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idbai, v_idmun, v_nome, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_cep_logradouro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_cep_logradouro() RETURNS "trigger"
    AS $$
DECLARE
   v_cep    numeric;
   v_idlog    numeric;
   v_nroini   numeric;
   v_nrofin   numeric;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_cep    := OLD.cep;
   v_idlog    := OLD.idlog;
   v_nroini   := OLD.nroini;
   v_nrofin   := OLD.nrofin;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;
   v_operacao   := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA CEP_LOGRADOURO
      INSERT INTO historico.cep_logradouro
      (cep, idlog, nroini, nrofin, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_cep, v_idlog, v_nroini, v_nrofin, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_cep_logradouro_bairro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_cep_logradouro_bairro() RETURNS "trigger"
    AS $$
DECLARE
   v_idbai    numeric;
   v_idlog    numeric;
   v_cep    numeric;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idbai    := OLD.idbai;
   v_idlog    := OLD.idlog;
   v_cep    := OLD.cep;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;
   v_operacao   := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA CEP_LOGRADOURO_BAIRRO
      INSERT INTO historico.cep_logradouro_bairro
      (idbai, idlog, cep, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idbai, v_idlog, v_cep, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_documento(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_documento() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_sigla_uf_exp_rg  char(2);
   v_rg     numeric;
   v_data_exp_rg  date;
   v_tipo_cert_civil  numeric;
   v_num_termo    numeric;
   v_num_livro    varchar;
   v_num_folha    numeric;
   v_data_emissao_cert_civil  date;
   v_sigla_uf_cert_civil  char(2);
   v_sigla_uf_cart_trabalho char(2);
   v_cartorio_cert_civil  varchar;
   v_num_cart_trabalho    numeric;
   v_serie_cart_trabalho  numeric;
   v_data_emissao_cart_trabalho date;
   v_num_tit_eleitor  numeric;
   v_zona_tit_eleitor numeric;
   v_secao_tit_eleitor  numeric;
   v_idorg_exp_rg   numeric;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idpes      := OLD.idpes;
   v_sigla_uf_exp_rg    := OLD.sigla_uf_exp_rg;
   v_rg       := OLD.rg;
   v_data_exp_rg    := OLD.data_exp_rg;
   v_tipo_cert_civil    := OLD.tipo_cert_civil;
   v_num_termo      := OLD.num_termo;
   v_num_livro      := OLD.num_livro;
   v_num_folha      := OLD.num_folha;
   v_data_emissao_cert_civil  := OLD.data_emissao_cert_civil;
   v_sigla_uf_cert_civil  := OLD.sigla_uf_cert_civil;
   v_sigla_uf_cart_trabalho := OLD.sigla_uf_cart_trabalho;
   v_cartorio_cert_civil  := OLD.cartorio_cert_civil;
   v_num_cart_trabalho    := OLD.num_cart_trabalho;
   v_serie_cart_trabalho  := OLD.serie_cart_trabalho;
   v_data_emissao_cart_trabalho := OLD.data_emissao_cart_trabalho;
   v_num_tit_eleitor    := OLD.num_tit_eleitor;
   v_zona_tit_eleitor   := OLD.zona_tit_eleitor;
   v_secao_tit_eleitor    := OLD.secao_tit_eleitor;
   v_idorg_exp_rg   := OLD.idorg_exp_rg;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA DOCUMENTO
      INSERT INTO historico.documento
      (idpes, sigla_uf_exp_rg, rg, data_exp_rg, tipo_cert_civil, num_termo, num_livro, num_folha, data_emissao_cert_civil, sigla_uf_cert_civil, sigla_uf_cart_trabalho, cartorio_cert_civil, num_cart_trabalho, serie_cart_trabalho, data_emissao_cart_trabalho, num_tit_eleitor, zona_tit_eleitor, secao_tit_eleitor, idorg_exp_rg, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_sigla_uf_exp_rg, v_rg, v_data_exp_rg, v_tipo_cert_civil, v_num_termo, v_num_livro, v_num_folha, v_data_emissao_cert_civil, v_sigla_uf_cert_civil, v_sigla_uf_cart_trabalho, v_cartorio_cert_civil, v_num_cart_trabalho, v_serie_cart_trabalho, v_data_emissao_cart_trabalho, v_num_tit_eleitor, v_zona_tit_eleitor, v_secao_tit_eleitor, v_idorg_exp_rg, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_endereco_externo(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_endereco_externo() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_tipo   numeric;
   v_sigla_uf   char(2);
   v_idtlog   varchar;
   v_logradouro   varchar;
   v_numero   numeric;
   v_letra    char(1);
   v_complemento  varchar;
   v_bairro   varchar;
   v_cep    numeric;
   v_cidade   varchar;
   v_reside_desde date;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idpes    := OLD.idpes;
   v_tipo   := OLD.tipo;
   v_sigla_uf   := OLD.sigla_uf;
   v_idtlog   := OLD.idtlog;
   v_logradouro   := OLD.logradouro;
   v_numero   := OLD.numero;
   v_letra    := OLD.letra;
   v_complemento  := OLD.complemento;
   v_bairro   := OLD.bairro;
   v_cep    := OLD.cep;
   v_cidade   := OLD.cidade;
   v_reside_desde := OLD.reside_desde;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;
   v_operacao   := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA ENDERECO_EXTERNO
      INSERT INTO historico.endereco_externo
      (idpes, tipo, sigla_uf, idtlog, logradouro, numero, letra, complemento, bairro, cep, cidade, reside_desde, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_tipo, v_sigla_uf, v_idtlog, v_logradouro, v_numero, v_letra, v_complemento, v_bairro, v_cep, v_cidade, v_reside_desde, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_endereco_pessoa(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_endereco_pessoa() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_tipo   numeric;
   v_cep    numeric;
   v_idlog    numeric;
   v_idbai    numeric;
   v_numero   numeric;
   v_letra    char(1);
   v_complemento  varchar;
   v_reside_desde date;
   v_idpes_rev    numeric;
   v_data_rev   TIMESTAMP;
   v_origem_gravacao  char(1);
   v_idsis_rev    numeric;
   v_idpes_cad    numeric;
   v_data_cad   TIMESTAMP;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idpes    := OLD.idpes;
   v_tipo   := OLD.tipo;
   v_cep    := OLD.cep;
   v_idlog    := OLD.idlog;
   v_idbai    := OLD.idbai;
   v_numero   := OLD.numero;
   v_letra    := OLD.letra;
   v_complemento  := OLD.complemento;
   v_reside_desde := OLD.reside_desde;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_idsis_cad    := OLD.idsis_cad;
   v_operacao   := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA ENDERECO_PESSOA
      INSERT INTO historico.endereco_pessoa
      (idpes, tipo, cep, idlog, idbai, numero, letra, complemento, reside_desde, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_tipo, v_cep, v_idlog, v_idbai, v_numero, v_letra, v_complemento, v_reside_desde, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_fisica(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_fisica() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_data_nasc      date;
   v_sexo     char(1);
   v_idpes_mae      numeric;
   v_idpes_pai      numeric;
   v_idpes_responsavel    numeric;
   v_idesco     numeric;
   v_ideciv     numeric;
   v_idpes_con      numeric;
   v_data_uniao     date;
   v_data_obito     date;
   v_nacionalidade    numeric;
   v_idpais_estrangeiro   numeric;
   v_data_chegada_brasil  date;
   v_idmun_nascimento   numeric;
   v_ultima_empresa   varchar;
   v_idocup     numeric;
   v_nome_mae     varchar;
   v_nome_pai     varchar;
   v_nome_conjuge   varchar;
   v_nome_responsavel   varchar;
   v_justificativa_provisorio varchar;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idpes      := OLD.idpes;
   v_data_nasc      := OLD.data_nasc;
   v_sexo     := OLD.sexo;
   v_idpes_mae      := OLD.idpes_mae;
   v_idpes_pai      := OLD.idpes_pai;
   v_idpes_responsavel    := OLD.idpes_responsavel;
   v_idesco     := OLD.idesco;
   v_ideciv     := OLD.ideciv;
   v_idpes_con      := OLD.idpes_con;
   v_data_uniao     := OLD.data_uniao;
   v_data_obito     := OLD.data_obito;
   v_nacionalidade    := OLD.nacionalidade;
   v_idpais_estrangeiro   := OLD.idpais_estrangeiro;
   v_data_chegada_brasil  := OLD.data_chegada_brasil;
   v_idmun_nascimento   := OLD.idmun_nascimento;
   v_ultima_empresa   := OLD.ultima_empresa;
   v_idocup     := OLD.idocup;
   v_nome_mae     := OLD.nome_mae;
   v_nome_pai     := OLD.nome_pai;
   v_nome_conjuge   := OLD.nome_conjuge;
   v_nome_responsavel   := OLD.nome_responsavel;
   v_justificativa_provisorio := OLD.justificativa_provisorio;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FISICA
      INSERT INTO historico.fisica
      (idpes, data_nasc, sexo, idpes_mae, idpes_pai, idpes_responsavel, idesco, ideciv, idpes_con, data_uniao, data_obito, nacionalidade, idpais_estrangeiro, data_chegada_brasil, idmun_nascimento, ultima_empresa, idocup, nome_mae, nome_pai, nome_conjuge, nome_responsavel, justificativa_provisorio, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_data_nasc, v_sexo, v_idpes_mae, v_idpes_pai, v_idpes_responsavel, v_idesco, v_ideciv, v_idpes_con, v_data_uniao, v_data_obito, v_nacionalidade, v_idpais_estrangeiro, v_data_chegada_brasil, v_idmun_nascimento, v_ultima_empresa, v_idocup, v_nome_mae, v_nome_pai, v_nome_conjuge, v_nome_responsavel, v_justificativa_provisorio, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_fisica_cpf(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_fisica_cpf() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_cpf      numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idpes      := OLD.idpes;
   v_cpf      := OLD.cpf;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FISICA_CPF
      INSERT INTO historico.fisica_cpf
      (idpes, cpf, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_cpf, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_fone_pessoa(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_fone_pessoa() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_tipo     numeric;
   v_ddd      numeric;
   v_fone     numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idpes      := OLD.idpes;
   v_tipo     := OLD.tipo;
   v_ddd      := OLD.ddd;
   v_fone     := OLD.fone;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FONE_PESSOA
      INSERT INTO historico.fone_pessoa
      (idpes, tipo, ddd, fone, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_tipo, v_ddd, v_fone, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_funcionario(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_funcionario() RETURNS "trigger"
    AS $$
DECLARE
   v_matricula      numeric;
   v_idins      numeric;
   v_idset      numeric;
   v_idpes      numeric;
   v_situacao     char(1);
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_matricula      := OLD.matricula;
   v_idins      := OLD.idins;
   v_idset      := OLD.idset;
   v_idpes      := OLD.idpes;
   v_situacao     := OLD.situacao;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA FUNCIONARIO
      INSERT INTO historico.funcionario
      (matricula, idins, idset, idpes, situacao, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_matricula, v_idins, v_idset, v_idpes, v_situacao, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_juridica(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_juridica() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes      numeric;
   v_cnpj     numeric;
   v_fantasia     varchar;
   v_insc_estadual    numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idpes      := OLD.idpes;
   v_cnpj     := OLD.cnpj;
   v_fantasia     := OLD.fantasia;
   v_insc_estadual    := OLD.insc_estadual;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA JURIDICA
      INSERT INTO historico.juridica
      (idpes, cnpj, fantasia, insc_estadual, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes, v_cnpj, v_fantasia, v_insc_estadual, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_logradouro(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_logradouro() RETURNS "trigger"
    AS $$
DECLARE
   v_idlog      numeric;
   v_idtlog     varchar;
   v_nome     varchar;
   v_idmun      numeric;
   v_ident_oficial    char(1);
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idlog      := OLD.idlog;
   v_idtlog     := OLD.idtlog;
   v_nome     := OLD.nome;
   v_idmun      := OLD.idmun;
   v_ident_oficial    := OLD.ident_oficial;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA LOGRADOURO
      INSERT INTO historico.logradouro
      (idlog, idtlog, nome, idmun, ident_oficial, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idlog, v_idtlog, v_nome, v_idmun, v_ident_oficial, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_municipio(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_municipio() RETURNS "trigger"
    AS $$
DECLARE
   v_idmun      numeric;
   v_sigla_uf     char(2);
   v_nome     varchar;
   v_area_km2     numeric;
   v_idmreg     numeric;
   v_idasmun      numeric;
   v_cod_ibge     numeric;
   v_geom     TEXT;
   v_tipo     char(1);
   v_idmun_pai      numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idmun      := OLD.idmun;
   v_sigla_uf     := OLD.sigla_uf;
   v_nome     := OLD.nome;
   v_area_km2     := OLD.area_km2;
   v_idmreg     := OLD.idmreg;
   v_idasmun      := OLD.idasmun;
   v_cod_ibge     := OLD.cod_ibge;
   v_geom     := OLD.geom;
   v_tipo     := OLD.tipo;
   v_idmun_pai      := OLD.idmun_pai;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA MUNICIPIO
      INSERT INTO historico.municipio
      (idmun, sigla_uf, nome, area_km2, idmreg, idasmun, cod_ibge, geom, tipo, idmun_pai, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idmun, v_sigla_uf, v_nome, v_area_km2, v_idmreg, v_idasmun, v_cod_ibge, v_geom, v_tipo, v_idmun_pai, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_pessoa(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_pessoa() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes    numeric;
   v_nome   TEXT;
   v_idpes_cad    numeric;
   v_data_cad   timestamp;
   v_url    TEXT;
   v_tipo   char;
   v_idpes_rev    numeric;
   v_data_rev   timestamp;
   v_email    TEXT;
   v_situacao   char;
   v_origem_gravacao  char;
   v_idsis_rev    numeric;
   v_idsis_cad    numeric;
   v_operacao   char(1);
BEGIN
   v_idpes    := OLD.idpes;
   v_nome   := OLD.nome;
   v_idpes_cad    := OLD.idpes_cad;
   v_data_cad   := OLD.data_cad;
   v_url    := OLD.url;
   v_tipo   := OLD.tipo;
   v_idpes_rev    := OLD.idpes_rev;
   v_data_rev   := OLD.data_rev;
   v_email    := OLD.email;
   v_situacao   := OLD.situacao;
   v_origem_gravacao  := OLD.origem_gravacao;
   v_idsis_rev    := OLD.idsis_rev;
   v_idsis_cad    := OLD.idsis_cad;
   v_operacao   := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA PESSOA
      INSERT INTO historico.pessoa
      (idpes, nome, idpes_cad, data_cad, url, tipo, idpes_rev, data_rev, email, situacao, origem_gravacao, idsis_rev, idsis_cad, operacao) VALUES
      (v_idpes, v_nome, v_idpes_cad, v_data_cad, v_url, v_tipo, v_idpes_rev, v_data_rev, v_email, v_situacao, v_origem_gravacao, v_idsis_rev, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


--
-- Name: fcn_grava_historico_socio(); Type: FUNCTION; Schema: historico; Owner: -
--

CREATE FUNCTION fcn_grava_historico_socio() RETURNS "trigger"
    AS $$
DECLARE
   v_idpes_juridica   numeric;
   v_idpes_fisica   numeric;
   v_idpes_rev      numeric;
   v_data_rev     TIMESTAMP;
   v_origem_gravacao    char(1);
   v_idsis_rev      numeric;
   v_idpes_cad      numeric;
   v_data_cad     TIMESTAMP;
   v_idsis_cad      numeric;
   v_operacao     char(1);
BEGIN
   v_idpes_juridica   := OLD.idpes_juridica;
   v_idpes_fisica   := OLD.idpes_fisica;
   v_idpes_rev      := OLD.idpes_rev;
   v_data_rev     := OLD.data_rev;
   v_origem_gravacao    := OLD.origem_gravacao;
   v_idsis_rev      := OLD.idsis_rev;
   v_idpes_cad      := OLD.idpes_cad;
   v_data_cad     := OLD.data_cad;
   v_idsis_cad      := OLD.idsis_cad;
   v_operacao     := OLD.operacao;

  IF v_data_rev IS NULL THEN
          v_data_rev := CURRENT_TIMESTAMP;
        END IF;

      -- GRAVA HISTRICO PARA TABELA SOCIO
      INSERT INTO historico.socio
      (idpes_juridica, idpes_fisica, idpes_rev, data_rev, origem_gravacao, idsis_rev, idpes_cad, data_cad, idsis_cad, operacao) VALUES
      (v_idpes_juridica, v_idpes_fisica, v_idpes_rev, v_data_rev, v_origem_gravacao, v_idsis_rev, v_idpes_cad, v_data_cad, v_idsis_cad, v_operacao);

   RETURN NEW;

END; $$
    LANGUAGE plpgsql;


SET search_path = pmieducar, pg_catalog;

--
-- Name: fcn_aft_update(); Type: FUNCTION; Schema: pmieducar; Owner: -
--

CREATE FUNCTION fcn_aft_update() RETURNS "trigger"
    AS $$
DECLARE
  nm_tabela   varchar(255);
  alteracoes    text;
  data_cadastro   TIMESTAMP;
  v_insercao    int2;


  BEGIN
    v_insercao    := 0;
    nm_tabela   := TG_RELNAME;
    alteracoes    := NEW;
    data_cadastro   := CURRENT_TIMESTAMP;
    IF TG_OP = 'INSERT' THEN
      v_insercao := 1;
    END IF;
    insert into pmieducar.historico_educar (tabela, alteracao, data, insercao) values (nm_tabela, alteracoes, data_cadastro, v_insercao);
  RETURN NEW;
END; $$
    LANGUAGE plpgsql;


SET search_path = public, pg_catalog;

--
-- Name: fcn_aft_logradouro_fonetiza(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_aft_logradouro_fonetiza() RETURNS "trigger"
    AS $$
   DECLARE
    v_idlog    bigint;
    v_nome_n   text;
    v_nome_v   text;
    v_fonema   text;
    v_reg_fon  record;
   BEGIN
    IF TG_OP = 'INSERT' THEN
     v_idlog  := NEW.idlog;
     v_nome_n := NEW.nome;
     FOR v_reg_fon IN SELECT DISTINCT * from public.fcn_fonetiza(v_nome_n) LOOP
      v_fonema := v_reg_fon.fcn_fonetiza;
      EXECUTE 'INSERT INTO public.logradouro_fonetico (fonema,idlog) VALUES ('||quote_literal(v_fonema)||','||quote_literal(v_idlog)||');';
     END LOOP;
    ELSIF TG_OP = 'UPDATE' THEN
     v_idlog  := NEW.idlog;
     v_nome_n := NEW.nome;
     v_nome_v := OLD.nome;
     IF v_nome_n <> v_nome_v THEN
      EXECUTE 'DELETE FROM public.logradouro_fonetico WHERE idlog = '||quote_literal(v_idlog)||';';
      FOR v_reg_fon IN SELECT DISTINCT * from public.fcn_fonetiza(v_nome_n) LOOP
       v_fonema := v_reg_fon.fcn_fonetiza;
       EXECUTE 'INSERT INTO public.logradouro_fonetico (fonema,idlog) VALUES ('||quote_literal(v_fonema)||','||quote_literal(v_idlog)||');';
      END LOOP;
     END IF;
    END IF;
    RETURN NEW;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_aft_pessoa_fonetiza(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_aft_pessoa_fonetiza() RETURNS "trigger"
    AS $$
   DECLARE
    v_idpes    bigint;
    v_nome_n   text;
    v_nome_v   text;
    v_fonema   text;
    v_reg_fon  record;
   BEGIN
    IF TG_OP = 'INSERT' THEN
     v_idpes  := NEW.idpes;
     v_nome_n := NEW.nome;
     FOR v_reg_fon IN SELECT DISTINCT * from public.fcn_fonetiza(v_nome_n) LOOP
      v_fonema := v_reg_fon.fcn_fonetiza;
      EXECUTE 'INSERT INTO cadastro.pessoa_fonetico (fonema,idpes) VALUES ('||quote_literal(v_fonema)||','||quote_literal(v_idpes)||');';
     END LOOP;
    ELSIF TG_OP = 'UPDATE' THEN
     v_idpes  := NEW.idpes;
     v_nome_n := NEW.nome;
     v_nome_v := OLD.nome;
     IF v_nome_n <> v_nome_v THEN
      EXECUTE 'DELETE FROM cadastro.pessoa_fonetico WHERE idpes = '||quote_literal(v_idpes)||';';
      FOR v_reg_fon IN SELECT DISTINCT * from public.fcn_fonetiza(v_nome_n) LOOP
       v_fonema := v_reg_fon.fcn_fonetiza;
       EXECUTE 'INSERT INTO cadastro.pessoa_fonetico (fonema,idpes) VALUES
 ('||quote_literal(v_fonema)||','||quote_literal(v_idpes)||');';
      END LOOP;
     END IF;
    END IF;
    RETURN NEW;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_bef_ins_fisica(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_bef_ins_fisica() RETURNS "trigger"
    AS $$
   DECLARE
    v_idpes    cadastro.fisica.idpes%TYPE;
    v_contador integer;
   BEGIN
    SELECT INTO v_contador count(idpes) from cadastro.juridica where idpes = NEW.idpes;
    IF v_contador = 1 THEN
     RAISE EXCEPTION 'O Identificador % j est cadastrado como Pessoa Jurdica', NEW.idpes;
    END IF;
    RETURN NEW;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_bef_ins_juridica(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_bef_ins_juridica() RETURNS "trigger"
    AS $$
   DECLARE
    v_idpes    cadastro.juridica.idpes%TYPE;
    v_contador integer;
   BEGIN
    SELECT INTO v_contador count(idpes) from cadastro.fisica where idpes = NEW.idpes;
    IF v_contador = 1 THEN
     RAISE EXCEPTION 'O Identificador % j est cadastrado como Pessoa Fsica', NEW.idpes;
    END IF;
    RETURN NEW;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_bef_logradouro_fonetiza(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_bef_logradouro_fonetiza() RETURNS "trigger"
    AS $$
   DECLARE
    v_idlog    bigint;
   BEGIN
    v_idlog := OLD.idlog;
    EXECUTE 'DELETE FROM public.logradouro_fonetico WHERE idlog = '||quote_literal(v_idlog)||';';
    RETURN OLD;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_bef_pessoa_fonetiza(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_bef_pessoa_fonetiza() RETURNS "trigger"
    AS $$
   DECLARE
    v_idpes    bigint;
   BEGIN
    v_idpes := OLD.idpes;
    EXECUTE 'DELETE FROM cadastro.pessoa_fonetico WHERE idpes = '||quote_literal(v_idpes)||';';
    RETURN OLD;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_compara_nome_pessoa_fonetica(text, numeric); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_compara_nome_pessoa_fonetica(text, numeric) RETURNS integer
    AS $_$
DECLARE
  v_nome_parametro      ALIAS FOR $1;
  v_idpes_parametro     ALIAS FOR $2;
  v_nome_pessoa_1       text;
  v_nome_pessoa_2       text;
  v_registro        record;
  v_nome_primeiro_ultimo_pessoa_1   text;
  v_nome_primeiro_ultimo_pessoa_2   text;
  v_cont     integer;
  v_fonema   text;
  v_comando  text;

  BEGIN

  -- obter o nome da pessoa referente ao IDPES passado como parametro
  v_comando := 'SELECT nome FROM cadastro.pessoa WHERE idpes = '||quote_literal(v_idpes_parametro)||';';
  FOR v_registro IN EXECUTE v_comando LOOP
    v_nome_pessoa_1 := v_registro.nome;
  END LOOP;

  v_nome_pessoa_2 := v_nome_parametro;

  v_nome_primeiro_ultimo_pessoa_1 := '';
  v_nome_primeiro_ultimo_pessoa_2 := '';
  v_cont := 0;

  -- primeiro e ltimo nome da pessoa com fontica
  FOR v_registro IN SELECT * FROM public.fcn_fonetiza(public.fcn_obter_primeiro_ultimo_nome(v_nome_pessoa_1)) LOOP
    v_cont := v_cont + 1;
    v_fonema := v_registro.fcn_fonetiza;

    IF v_cont > 1 THEN
      v_nome_primeiro_ultimo_pessoa_1 := v_nome_primeiro_ultimo_pessoa_1 || ' ';
    END IF;
    v_nome_primeiro_ultimo_pessoa_1 := v_nome_primeiro_ultimo_pessoa_1 || v_fonema;
  END LOOP;

  v_cont := 0;
  FOR v_registro IN SELECT * FROM public.fcn_fonetiza(public.fcn_obter_primeiro_ultimo_nome(v_nome_pessoa_2)) LOOP
    v_cont := v_cont + 1;
    v_fonema := v_registro.fcn_fonetiza;

    IF v_cont > 1 THEN
      v_nome_primeiro_ultimo_pessoa_2 := v_nome_primeiro_ultimo_pessoa_2 || ' ';
    END IF;
    v_nome_primeiro_ultimo_pessoa_2 := v_nome_primeiro_ultimo_pessoa_2 || v_fonema;
  END LOOP;

  IF v_nome_primeiro_ultimo_pessoa_1 = v_nome_primeiro_ultimo_pessoa_2 THEN
    RETURN 1;
  ELSE
    RETURN 0;
  END IF;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_cons_log_fonetica(text, bigint); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_cons_log_fonetica(text, bigint) RETURNS SETOF typ_idlog
    AS $_$
   DECLARE
    v_texto    ALIAS FOR $1;
    v_idmun    ALIAS FOR $2;
    v_fonema   text;
    v_comando  text;
    v_idlog    bigint;
    v_reg_fon  record;
    v_cont     integer;
    retorno    typ_idlog%ROWTYPE;
   BEGIN
    v_cont := 0;
    v_comando := 'select public.logradouro_fonetico.idlog from public.logradouro_fonetico, public.logradouro where (fonema = ';
    FOR v_reg_fon IN SELECT DISTINCT * FROM public.fcn_fonetiza(v_texto) LOOP v_cont := v_cont + 1;
     v_fonema := v_reg_fon.fcn_fonetiza;
     IF v_cont > 1 THEN
      v_comando := v_comando||' or fonema = ';
     END IF;
     v_comando := v_comando||quote_literal(v_fonema);
    END LOOP;
    v_comando := v_comando||') AND public.logradouro.idlog = public.logradouro_fonetico.idlog';
    v_comando := v_comando||' AND public.logradouro.idmun = '||v_idmun;
    v_comando := v_comando||' group by public.logradouro_fonetico.idlog having count(fonema) = '||quote_literal(v_cont)||';';
    FOR retorno IN EXECUTE v_comando LOOP
     RETURN NEXT retorno;
    END LOOP;
    RETURN;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_consulta_fonetica(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_consulta_fonetica(text) RETURNS SETOF typ_idpes
    AS $_$
   DECLARE
    v_texto    ALIAS FOR $1;
    v_fonema   text;
    v_comando  text;
    v_idpes    bigint;
    v_reg_fon  record;
    v_cont     integer;
    retorno typ_idpes%ROWTYPE;
   BEGIN
    v_cont := 0;
    v_comando := 'select idpes from cadastro.pessoa_fonetico where fonema = ';
    FOR v_reg_fon IN SELECT DISTINCT * FROM public.fcn_fonetiza(v_texto) LOOP
     v_cont := v_cont + 1;
     v_fonema := v_reg_fon.fcn_fonetiza;
     IF v_cont > 1 THEN
      v_comando := v_comando||' or fonema = ';
     END IF;
     v_comando := v_comando||quote_literal(v_fonema);
    END LOOP;
    v_comando := v_comando||' group by idpes having count(fonema) = '||quote_literal(v_cont)||';';
    FOR retorno IN EXECUTE v_comando LOOP
     RETURN NEXT retorno;
    END LOOP;
    RETURN;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_endereco_externo(integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_delete_endereco_externo(integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_idpes ALIAS for $1;
  v_tipo ALIAS for $2;

BEGIN
  -- Deleta dados da tabela endereco_externo
  DELETE FROM cadastro.endereco_externo WHERE idpes = v_idpes AND tipo = v_tipo;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_endereco_pessoa(integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_delete_endereco_pessoa(integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_idpes ALIAS for $1;
  v_tipo ALIAS for $2;

BEGIN
  -- Deleta dados da tabela endereco_pessoa
  DELETE FROM cadastro.endereco_pessoa WHERE idpes = v_idpes AND tipo = v_tipo;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_fone_pessoa(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_delete_fone_pessoa(integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;

BEGIN
  -- Deleta dados da tabela fone_pessoa
  DELETE FROM cadastro.fone_pessoa WHERE idpes = v_id_pes;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_delete_funcionario(integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_delete_funcionario(integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_matricula ALIAS for $1;
  v_id_ins ALIAS for $2;

BEGIN
  -- Deleta dados da tabela funcionrio
  DELETE FROM cadastro.funcionario WHERE matricula = v_matricula AND idins = v_id_ins;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_dia_util(date, date); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_dia_util(date, date) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_dt_ini ALIAS for $1;
  v_dt_fim ALIAS for $2;
  v_dt_ini_x date;
  v_qtde integer;
BEGIN
  v_qtde := 0;
  v_dt_ini_x := v_dt_ini;
  WHILE v_dt_ini_x <= v_dt_fim LOOP
    IF to_char(v_dt_ini_x,'D') NOT IN ('1','7') THEN
      IF NOT EXISTS(SELECT idfer
             from servicos.feriado
             WHERE to_char(data,'DD/MM/YYYY') =
             to_char(v_dt_ini_x,'DD/MM/YYYY')) THEN
        v_qtde := v_qtde + 1;
      END IF;
    END IF;
    v_dt_ini_x := v_dt_ini_x + interval '1 day';
  END LOOP;
  RETURN v_qtde;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_fonetiza(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_fonetiza(text) RETURNS SETOF text
    AS $_$
   DECLARE
    v_array         ALIAS FOR $1;
    orig            text := '';
    dest            text := '';
    ori             integer := 1;
    v_campo         integer;
   BEGIN
    orig := public.fcn_upper_nrm(v_array)||'  ';
    FOR ori IN 1..152 LOOP
     IF substr(orig, ori, 1) = ' ' THEN
      IF substr(orig, ori + 1, 1) = ' ' THEN
       IF dest IN ('DA','DAS','DOS','DU','DUS','DI','E','S/A','LTDA','OTIDA','S.A','DO','DE','-','AVI','I','OA','A','SA') THEN
        dest := '';
       END IF;
       IF dest <> ' ' AND
          dest <> '' THEN
        RETURN NEXT trim(dest);
        dest := '';
       END IF;
       ori := 152;
       EXIT;
      ELSE
       IF dest IN ('DA','DAS','DOS','DU','DUS','DI','E','S/A','LTDA','OTIDA','S.A','DO','DE','-','AVI','I','OA','A','SA') THEN
        dest := '';
       END IF;
       IF dest <> ' ' AND
          dest <> '' THEN
        RETURN NEXT trim(dest);
        dest := '';
       END IF;
       ori := ori + 1;
      END IF;
     ELSIF substr(orig,ori + 1,1) = '-' OR
           substr(orig,ori + 1,1) = '/' THEN
      IF substr(orig,ori,1) <> ' ' AND
         substr(orig,ori + 2,1) <> ' ' THEN
       orig = substr(orig,1,ori)||' '||substr(orig,ori + 1,42);
      END IF;
     END IF;
     -- Numero
     IF substr(orig,ori,1) >= '0' and
        substr(orig,ori,1) <= '9' THEN
      dest := dest||substr(orig,ori,1);
     -- Letra Igual
     ELSIF substr(orig,ori,1) = substr(orig,ori + 1,1) THEN
      IF length(dest) = 1 THEN
       dest := '';
      END IF;
     -- Letras A, I ou O
     ELSIF substr(orig,ori,1) = 'A' OR
           substr(orig,ori,1) = 'I' OR
           substr(orig,ori,1) = 'O' THEN
      dest := dest||substr(orig,ori,1);
     -- Letra E
     ELSIF substr(orig,ori,1) = 'E' THEN
      dest := dest||'I';
     -- Letra R
     ELSIF substr(orig,ori,1) = 'R' THEN
       dest := dest||'H';
     -- Letra S
     ELSIF substr(orig,ori,1) = 'S' THEN
      IF substr(orig,ori + 1,1) NOT IN ('A','E','I','O','U','Y') AND
         length(dest) = 0 THEN
       dest := dest||'IS';
      ELSIF substr(orig,ori + 1,1) = 'C' AND
            substr(orig,ori + 2,1) = 'H' THEN
       IF length(dest) = 1 THEN
        dest := '';
       END IF;
      ELSIF substr(orig,ori + 1,1) = 'H' THEN
       dest := dest||'KS';
       ori := ori + 1;
      ELSE
       dest := dest||substr(orig,ori,1);
      END IF;
     -- Letra N
     ELSIF substr(orig,ori,1) = 'N' THEN
      IF substr(orig,ori + 1,1) = 'H' THEN
       dest := dest||'NI';
      ELSE
       IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||substr(orig,ori,1);
       ELSE
        dest := dest||'M';
       END IF;
      END IF;
     -- Letra L
     ELSIF substr(orig,ori,1) = 'L' THEN
      IF substr(orig,ori + 1,1) = 'H' THEN
       dest := dest||'LI';
      ELSIF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'O';
      END IF;
     -- Letra D
     ELSIF substr(orig,ori,1) = 'D' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'DI';
      END IF;
     -- Letra C
     ELSIF substr(orig,ori,1) = 'C' THEN
      IF substr(orig,ori + 1,1) = 'H' THEN
       IF substr(orig,ori + 2,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||'KS';
        ori := ori + 1;
       END IF;
      ELSIF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       IF substr(orig,ori + 1,1) IN ('E','I','Y') THEN
        dest := dest||'S';
       ELSE
        dest := dest||'K';
       END IF;
      ELSE
       IF length(dest) = 1 THEN
        dest := '';
       END IF;
      END IF;
     -- Letra M
     ELSIF substr(orig,ori,1) = 'M' THEN
      IF substr(orig,ori + 1,1) = 'N' THEN
       IF length(dest) = 1 THEN
        dest := '';
       END IF;
      ELSE
       dest := dest||substr(orig,ori,1);
      END IF;
     -- Letra T
     ELSIF substr(orig,ori,1) = 'T' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'TI';
      END IF;
     -- Letra U
     ELSIF substr(orig,ori,1) = 'U' THEN
      dest := dest||'O';
     -- Letra V
     ELSIF substr(orig,ori,1) = 'V' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'VI';
      END IF;
     -- Letra G
     ELSIF substr(orig,ori,1) = 'G' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       IF substr(orig,ori + 1,1) = 'U' AND
          substr(orig,ori + 2,1) IN ('I','E','Y') THEN
        dest := dest||'J';
        ori := ori + 1;
       ELSE
        dest := dest||'J';
       END IF;
      ELSE
       dest := dest||'JI';
      END IF;
     -- Letra B
     ELSIF substr(orig,ori,1) = 'B' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'BI';
      END IF;
     -- Letra P
     ELSIF substr(orig,ori,1) = 'P' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       IF substr(orig,ori + 1,1) = 'H' THEN
        dest := dest||'F';
       ELSE
        dest := dest||'PI';
       END IF;
      END IF;
     -- Letra Z
     ELSIF substr(orig,ori,1) = 'Z' THEN
       dest := dest||'S';
     -- Letra F
     ELSIF substr(orig,ori,1) = 'F' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'FI';
      END IF;
     -- Letra J
     ELSIF substr(orig,ori,1) = 'J' THEN
      dest := dest||'J';
     -- Letra K
     ELSIF substr(orig,ori,1) = 'K' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'KI';
      END IF;
     -- Letra Y
     ELSIF substr(orig,ori,1) = 'Y' THEN
      dest := dest||'I';
     -- Letra W
     ELSIF substr(orig,ori,1) = 'W' THEN
      IF ori = 1 THEN
       IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||'V';
       ELSE
        dest := dest||'VI';
       END IF;
      ELSIF substr(orig,ori - 1,1) IN ('E','I') THEN
       IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||'V';
       ELSE
        dest := dest||'O';
       END IF;
      ELSE
       dest := dest||'V';
      END IF;
     -- Letra Q
     ELSIF substr(orig,ori,1) = 'Q' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y',' ') THEN
       dest := dest||'K';
       IF substr(orig,ori + 1,1) = 'U' AND
          substr(orig,ori + 2,1) IN ('I','E','Y') THEN
        ori := ori + 1;
       END IF;
      ELSE
       dest := dest||'QI';
      END IF;
     -- Letra X
     ELSIF substr(orig,ori,1) = 'X' THEN
      dest := dest||'KS';
     END IF;
    END LOOP;
    dest := NULL;
    RETURN;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_fonetiza_logr_geral(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_fonetiza_logr_geral() RETURNS text
    AS $$
   DECLARE
    v_fonema   text;
    v_nomlog   text;
    v_idlog    bigint;
    v_reg_log  record;
    v_reg_fon  record;
    v_cont     integer;
   BEGIN
    FOR v_reg_log IN SELECT idlog, nome FROM public.logradouro LOOP
     v_nomlog := v_reg_log.nome;
     v_idlog  := v_reg_log.idlog;
     FOR v_reg_fon IN SELECT DISTINCT * FROM public.fcn_fonetiza(v_nomlog) LOOP
      v_fonema := v_reg_fon.fcn_fonetiza;
      EXECUTE 'INSERT INTO public.logradouro_fonetico (fonema,idlog) VALUES ('||quote_literal(v_fonema)||','||quote_literal(v_idlog)||');';
     END LOOP;
    END LOOP;
    SELECT count(idlog) INTO v_cont FROM public.logradouro_fonetico;
    v_fonema := 'Foram gravados '||to_char(v_cont,'9999999')||' registros em logradouro_fonetico';
    RETURN v_fonema;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_fonetiza_palavra(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_fonetiza_palavra(text) RETURNS text
    AS $_$
DECLARE
    v_array         ALIAS FOR $1;
    orig            text := '';
    dest            text := '';
    ori             integer := 1;
    v_campo         integer;
   BEGIN
    orig := public.fcn_upper_nrm(v_array)||'  ';
    FOR ori IN 1..152 LOOP
     IF substr(orig, ori, 1) = ' ' THEN
      IF substr(orig, ori + 1, 1) = ' ' THEN
       IF dest IN ('DA','DAS','DOS','DU','DUS','DI','E','S/A','LTDA','OTIDA','S.A','DO','DE','-','AVI','I','OA','A','SA') THEN
        dest := '';
       END IF;
       IF dest <> ' ' AND
          dest <> '' THEN
        RETURN trim(dest);
        dest := '';
       END IF;
       ori := 152;
       EXIT;
      ELSE
       IF dest IN ('DA','DAS','DOS','DU','DUS','DI','E','S/A','LTDA','OTIDA','S.A','DO','DE','-','AVI','I','OA','A','SA') THEN
        dest := '';
       END IF;
       IF dest <> ' ' AND
          dest <> '' THEN
        RETURN trim(dest);
        dest := '';
       END IF;
       ori := ori + 1;
      END IF;
     ELSIF substr(orig,ori + 1,1) = '-' OR
           substr(orig,ori + 1,1) = '/' THEN
      IF substr(orig,ori,1) <> ' ' AND
         substr(orig,ori + 2,1) <> ' ' THEN
       orig = substr(orig,1,ori)||' '||substr(orig,ori + 1,42);
      END IF;
     END IF;
     -- Numero
     IF substr(orig,ori,1) >= '0' and
        substr(orig,ori,1) <= '9' THEN
      dest := dest||substr(orig,ori,1);
     -- Letra Igual
     ELSIF substr(orig,ori,1) = substr(orig,ori + 1,1) THEN
      IF length(dest) = 1 THEN
       dest := '';
      END IF;
     -- Letras A, I ou O
     ELSIF substr(orig,ori,1) = 'A' OR
           substr(orig,ori,1) = 'I' OR
           substr(orig,ori,1) = 'O' THEN
      dest := dest||substr(orig,ori,1);
     -- Letra E
     ELSIF substr(orig,ori,1) = 'E' THEN
      dest := dest||'I';
     -- Letra R
     ELSIF substr(orig,ori,1) = 'R' THEN
       dest := dest||'H';
     -- Letra S
     ELSIF substr(orig,ori,1) = 'S' THEN
      IF substr(orig,ori + 1,1) NOT IN ('A','E','I','O','U','Y') AND
         length(dest) = 0 THEN
       dest := dest||'IS';
      ELSIF substr(orig,ori + 1,1) = 'C' AND
            substr(orig,ori + 2,1) = 'H' THEN
       IF length(dest) = 1 THEN
        dest := '';
       END IF;
      ELSIF substr(orig,ori + 1,1) = 'H' THEN
       dest := dest||'KS';
       ori := ori + 1;
      ELSE
       dest := dest||substr(orig,ori,1);
      END IF;
     -- Letra N
     ELSIF substr(orig,ori,1) = 'N' THEN
      IF substr(orig,ori + 1,1) = 'H' THEN
       dest := dest||'NI';
      ELSE
       IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||substr(orig,ori,1);
       ELSE
        dest := dest||'M';
       END IF;
      END IF;
     -- Letra L
     ELSIF substr(orig,ori,1) = 'L' THEN
      IF substr(orig,ori + 1,1) = 'H' THEN
       dest := dest||'LI';
      ELSIF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'O';
      END IF;
     -- Letra D
     ELSIF substr(orig,ori,1) = 'D' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'DI';
      END IF;
     -- Letra C
     ELSIF substr(orig,ori,1) = 'C' THEN
      IF substr(orig,ori + 1,1) = 'H' THEN
       IF substr(orig,ori + 2,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||'KS';
        ori := ori + 1;
       END IF;
      ELSIF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       IF substr(orig,ori + 1,1) IN ('E','I','Y') THEN
        dest := dest||'S';
       ELSE
        dest := dest||'K';
       END IF;
      ELSE
       IF length(dest) = 1 THEN
        dest := '';
       END IF;
      END IF;
     -- Letra M
     ELSIF substr(orig,ori,1) = 'M' THEN
      IF substr(orig,ori + 1,1) = 'N' THEN
       IF length(dest) = 1 THEN
        dest := '';
       END IF;
      ELSE
       dest := dest||substr(orig,ori,1);
      END IF;
     -- Letra T
     ELSIF substr(orig,ori,1) = 'T' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'TI';
      END IF;
     -- Letra U
     ELSIF substr(orig,ori,1) = 'U' THEN
      dest := dest||'O';
     -- Letra V
     ELSIF substr(orig,ori,1) = 'V' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'VI';
      END IF;
     -- Letra G
     ELSIF substr(orig,ori,1) = 'G' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       IF substr(orig,ori + 1,1) = 'U' AND
          substr(orig,ori + 2,1) IN ('I','E','Y') THEN
        dest := dest||'J';
        ori := ori + 1;
       ELSE
        dest := dest||'J';
       END IF;
      ELSE
       dest := dest||'JI';
      END IF;
     -- Letra B
     ELSIF substr(orig,ori,1) = 'B' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'BI';
      END IF;
     -- Letra P
     ELSIF substr(orig,ori,1) = 'P' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       IF substr(orig,ori + 1,1) = 'H' THEN
        dest := dest||'F';
       ELSE
        dest := dest||'PI';
       END IF;
      END IF;
     -- Letra Z
     ELSIF substr(orig,ori,1) = 'Z' THEN
       dest := dest||'S';
     -- Letra F
     ELSIF substr(orig,ori,1) = 'F' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'FI';
      END IF;
     -- Letra J
     ELSIF substr(orig,ori,1) = 'J' THEN
      dest := dest||'J';
     -- Letra K
     ELSIF substr(orig,ori,1) = 'K' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') OR
         (substr(orig,ori + 1,1) = 'H' AND
          substr(orig,ori + 2,1) <> ' ') THEN
       dest := dest||substr(orig,ori,1);
      ELSE
       dest := dest||'KI';
      END IF;
     -- Letra Y
     ELSIF substr(orig,ori,1) = 'Y' THEN
      dest := dest||'I';
     -- Letra W
     ELSIF substr(orig,ori,1) = 'W' THEN
      IF ori = 1 THEN
       IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||'V';
       ELSE
        dest := dest||'VI';
       END IF;
      ELSIF substr(orig,ori - 1,1) IN ('E','I') THEN
       IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y') THEN
        dest := dest||'V';
       ELSE
        dest := dest||'O';
       END IF;
      ELSE
       dest := dest||'V';
      END IF;
     -- Letra Q
     ELSIF substr(orig,ori,1) = 'Q' THEN
      IF substr(orig,ori + 1,1) IN ('A','E','I','O','U','Y',' ') THEN
       dest := dest||'K';
       IF substr(orig,ori + 1,1) = 'U' AND
          substr(orig,ori + 2,1) IN ('I','E','Y') THEN
        ori := ori + 1;
       END IF;
      ELSE
       dest := dest||'QI';
      END IF;
     -- Letra X
     ELSIF substr(orig,ori,1) = 'X' THEN
      dest := dest||'KS';
     END IF;
    END LOOP;
    dest := NULL;
    RETURN;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_fonetiza_pessoa_geral(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_fonetiza_pessoa_geral() RETURNS text
    AS $$
   DECLARE
    v_fonema   text;
    v_nome     text;
    v_idpes    bigint;
    v_reg_pes  record;
    v_reg_fon  record;
    v_cont     integer;
   BEGIN
    FOR v_reg_pes IN SELECT idpes, nome FROM cadastro.pessoa LOOP
     v_nome  := v_reg_pes.nome;
     v_idpes := v_reg_pes.idpes;
     FOR v_reg_fon IN SELECT DISTINCT * FROM public.fcn_fonetiza(v_nome) LOOP
      v_fonema := v_reg_fon.fcn_fonetiza;
      EXECUTE 'INSERT INTO cadastro.pessoa_fonetico (fonema,idpes) VALUES ('||quote_literal(v_fonema)||','||quote_literal(v_idpes)||');';
     END LOOP;
    END LOOP;
    SELECT count(idpes) INTO v_cont FROM cadastro.pessoa_fonetico;
    v_fonema := 'Foram gravados '||to_char(v_cont,'999999')||' registros em pessoa_fonetico';
    RETURN v_fonema;
   END;
  $$
    LANGUAGE plpgsql;


--
-- Name: fcn_fonetiza_primeiro_ultimo_nome(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_fonetiza_primeiro_ultimo_nome(text) RETURNS text
    AS $_$
DECLARE
  v_nome_parametro    ALIAS FOR $1;
  v_registro      record;
  v_nome_primeiro_ultimo_pessoa text;
  v_cont          integer;
  v_fonema        text;
  BEGIN
  v_nome_primeiro_ultimo_pessoa := '';
  v_cont := 0;
  -- primeiro e ltimo nome da pessoa com fontica
  FOR v_registro IN SELECT * FROM public.fcn_fonetiza(public.fcn_obter_primeiro_ultimo_nome(v_nome_parametro)) LOOP
    v_cont := v_cont + 1;
    v_fonema := v_registro.fcn_fonetiza;
    IF v_cont > 1 THEN
      v_nome_primeiro_ultimo_pessoa := v_nome_primeiro_ultimo_pessoa || ' ';
    END IF;
    v_nome_primeiro_ultimo_pessoa := v_nome_primeiro_ultimo_pessoa || v_fonema;
  END LOOP;
  RETURN v_nome_primeiro_ultimo_pessoa;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_documento(integer, character varying, character varying, character varying, character varying, integer, integer, integer, integer, character varying, character varying, character varying, character varying, integer, integer, character varying, character varying, integer, integer, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_documento(integer, character varying, character varying, character varying, character varying, integer, integer, integer, integer, character varying, character varying, character varying, character varying, integer, integer, character varying, character varying, integer, integer, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_rg ALIAS for $2;
  v_orgao_exp_rg ALIAS for $3;
  v_data_exp_rg ALIAS for $4;
  v_sigla_uf_exp_rg ALIAS for $5;
      v_tipo_cert_civil ALIAS for $6;
      v_num_termo ALIAS for $7;
  v_num_livro ALIAS for $8;
  v_num_folha ALIAS for $9;
      v_data_emissao_cert_civil ALIAS for $10;
      v_sigla_uf_cert_civil ALIAS for $11;
  v_sigla_uf_cart_trabalho ALIAS for $12;
  v_cartorio_cert_civil ALIAS for $13;
  v_num_cart_trabalho ALIAS for $14;
      v_serie_cart_trabalho ALIAS for $15;
      v_data_emissao_cart_trabalho ALIAS for $16;
  v_num_tit_eleitor ALIAS for $17;
  v_zona_tit_eleitor ALIAS for $18;
  v_secao_tit_eleitor ALIAS for $19;
  v_origem_gravacao ALIAS for $20;
  v_idpes_cad ALIAS for $21;
  v_idsis_cad ALIAS for $22;

    -- Outras variveis
      v_rg_aux varchar(10);
      v_orgao_exp_rg_aux varchar(10);
      v_sigla_uf_exp_rg_aux varchar(2);
  v_tipo_cert_civil_aux integer;
  v_num_termo_aux integer;
  v_num_livro_aux integer;
  v_num_folha_aux integer;
      v_sigla_uf_cert_civil_aux varchar(2);
  v_sigla_uf_cart_trabalho_aux varchar(2);
      v_cartorio_cert_civil_aux varchar(150);
      v_num_cart_trabalho_aux integer;
      v_serie_cart_trabalho_aux integer;
      v_num_tit_eleitor_aux varchar(13);
      v_zona_tit_eleitor_aux integer;
      v_secao_tit_eleitor_aux integer;
BEGIN
    IF v_rg = '' THEN
        v_rg_aux := NULL;
    ELSE
        v_rg_aux := v_rg;
    END IF;
    IF v_orgao_exp_rg = '' THEN
        v_orgao_exp_rg_aux := NULL;
    ELSE
        v_orgao_exp_rg_aux := v_orgao_exp_rg;
    END IF;
    IF v_sigla_uf_exp_rg = '' THEN
        v_sigla_uf_exp_rg_aux := NULL;
    ELSE
        v_sigla_uf_exp_rg_aux := v_sigla_uf_exp_rg;
    END IF;
    IF v_tipo_cert_civil = 0 THEN
        v_tipo_cert_civil_aux := NULL;
    ELSE
        v_tipo_cert_civil_aux := v_tipo_cert_civil;
    END IF;
    IF v_num_termo = 0 THEN
        v_num_termo_aux := NULL;
    ELSE
        v_num_termo_aux := v_num_termo;
    END IF;
    IF v_num_livro = 0 THEN
        v_num_livro_aux := NULL;
    ELSE
        v_num_livro_aux := v_num_livro;
    END IF;
    IF v_num_folha = 0 THEN
        v_num_folha_aux := NULL;
    ELSE
        v_num_folha_aux := v_num_folha;
    END IF;
    IF v_sigla_uf_cert_civil = '' THEN
        v_sigla_uf_cert_civil_aux := NULL;
    ELSE
        v_sigla_uf_cert_civil_aux := v_sigla_uf_cert_civil;
    END IF;
    IF v_sigla_uf_cart_trabalho = '' THEN
        v_sigla_uf_cart_trabalho_aux := NULL;
    ELSE
        v_sigla_uf_cart_trabalho_aux := v_sigla_uf_cart_trabalho;
    END IF;
    IF v_cartorio_cert_civil = '' THEN
        v_cartorio_cert_civil_aux := NULL;
    ELSE
        v_cartorio_cert_civil_aux := v_cartorio_cert_civil;
    END IF;
    IF v_num_cart_trabalho = 0 THEN
        v_num_cart_trabalho_aux := NULL;
    ELSE
        v_num_cart_trabalho_aux := v_num_cart_trabalho;
    END IF;
    IF v_serie_cart_trabalho = 0 THEN
        v_serie_cart_trabalho_aux := NULL;
    ELSE
        v_serie_cart_trabalho_aux := v_serie_cart_trabalho;
    END IF;
    IF v_num_tit_eleitor = '' THEN
        v_num_tit_eleitor_aux := NULL;
    ELSE
        v_num_tit_eleitor_aux := v_num_tit_eleitor;
    END IF;
    IF v_zona_tit_eleitor = 0 THEN
        v_zona_tit_eleitor_aux := NULL;
    ELSE
        v_zona_tit_eleitor_aux := v_zona_tit_eleitor;
    END IF;
    IF v_secao_tit_eleitor = 0 THEN
        v_secao_tit_eleitor_aux := NULL;
    ELSE
        v_secao_tit_eleitor_aux := v_secao_tit_eleitor;
    END IF;

  -- Insere dados na tabela funcionrio
    INSERT INTO cadastro.documento (idpes, rg, idorg_exp_rg,
                                data_exp_rg, sigla_uf_exp_rg,
                                tipo_cert_civil, num_termo,
                                num_livro, num_folha,
                                data_emissao_cert_civil, sigla_uf_cert_civil,
                                sigla_uf_cart_trabalho, cartorio_cert_civil,
                                num_cart_trabalho, serie_cart_trabalho,
                                data_emissao_cart_trabalho, num_tit_eleitor,                                              zona_tit_eleitor, secao_tit_eleitor, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
    VALUES(v_id_pes, to_number(v_rg_aux,9999999999), to_number(v_orgao_exp_rg_aux,9999999999),
           to_date(v_data_exp_rg,'DD/MM/YYYY'), v_sigla_uf_exp_rg_aux,
           v_tipo_cert_civil_aux, v_num_termo_aux,
           v_num_livro_aux, v_num_folha_aux,
           to_date(v_data_emissao_cert_civil,'DD/MM/YYYY'), v_sigla_uf_cert_civil_aux,
           v_sigla_uf_cart_trabalho_aux, v_cartorio_cert_civil_aux,
           v_num_cart_trabalho_aux, v_serie_cart_trabalho_aux,
           to_date(v_data_emissao_cart_trabalho,'DD/MM/YYYY'), to_number(v_num_tit_eleitor_aux,9999999999999),
           v_zona_tit_eleitor_aux, v_secao_tit_eleitor_aux, v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_endereco_externo(integer, integer, character varying, character varying, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_endereco_externo(integer, integer, character varying, character varying, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_tipo ALIAS for $2;
  v_sigla_uf ALIAS for $3;
  v_idtlog ALIAS for $4;
    v_logradouro ALIAS for $5;
    v_numero ALIAS for $6;
    v_letra ALIAS for $7;
    v_complemento ALIAS for $8;
    v_bairro ALIAS for $9;
    v_cep ALIAS for $10;
    v_cidade ALIAS for $11;
    v_reside_desde ALIAS for $12;
    v_origem_gravacao ALIAS for $13;
    v_idpes_cad ALIAS for $14;
    v_idsis_cad ALIAS for $15;

BEGIN
  -- Atualiza dados na tabela endereco_externo
    INSERT INTO cadastro.endereco_externo(idpes, tipo, sigla_uf, idtlog, logradouro, numero, letra, complemento, bairro, cep, cidade, reside_desde, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
    VALUES (v_id_pes, v_tipo, v_sigla_uf, v_idtlog, public.fcn_upper(v_logradouro), v_numero, public.fcn_upper(v_letra), public.fcn_upper(v_complemento), public.fcn_upper(v_bairro), v_cep, public.fcn_upper(v_cidade), to_date(v_reside_desde,'DD/MM/YYYY'), v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');

  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_endereco_pessoa(integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_endereco_pessoa(integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_tipo ALIAS for $2;
  v_cep ALIAS for $3;
  v_idlog ALIAS for $4;
  v_idbai ALIAS for $5;
  v_numero ALIAS for $6;
  v_letra ALIAS for $7;
  v_complemento ALIAS for $8;
  v_reside_desde ALIAS for $9;
  v_origem_gravacao ALIAS for $10;
      v_idpes_cad ALIAS for $11;
      v_idsis_cad ALIAS for $12;
BEGIN
  -- Insere dados na tabela endereco_pessoa
    INSERT INTO cadastro.endereco_pessoa (idpes,tipo,cep,idlog,idbai,numero,letra,complemento,reside_desde, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
  VALUES(v_id_pes,v_tipo,v_cep,v_idlog,v_idbai,v_numero,public.fcn_upper(v_letra),public.fcn_upper(v_complemento),to_date(v_reside_desde,'DD/MM/YYYY'), v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_fisica(integer, character varying, character varying, integer, integer, integer, integer, integer, integer, character varying, character varying, integer, integer, character varying, integer, character varying, integer, character varying, character varying, character varying, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_fisica(integer, character varying, character varying, integer, integer, integer, integer, integer, integer, character varying, character varying, integer, integer, character varying, integer, character varying, integer, character varying, character varying, character varying, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_data_nasc ALIAS for $2;
  v_sexo ALIAS for $3;
  v_id_pes_mae ALIAS for $4;
      v_id_pes_pai ALIAS for $5;
      v_id_pes_responsavel ALIAS for $6;
  v_id_esco ALIAS for $7;
  v_id_eciv ALIAS for $8;
  v_id_pes_con ALIAS for $9;
      v_data_uniao ALIAS for $10;
      v_data_obito ALIAS for $11;
  v_nacionalidade ALIAS for $12;
  v_id_pais_estrangeiro ALIAS for $13;
  v_data_chegada ALIAS for $14;
      v_id_mun_nascimento ALIAS for $15;
      v_ultima_empresa ALIAS for $16;
  v_id_ocup ALIAS for $17;
  v_nome_mae ALIAS for $18;
  v_nome_pai ALIAS for $19;
      v_nome_conjuge ALIAS for $20;
      v_nome_responsavel ALIAS for $21;
      v_justificativa_provisorio ALIAS for $22;
  v_origem_gravacao ALIAS for $23;
      v_idpes_cad ALIAS for $24;
      v_idsis_cad ALIAS for $25;
      -- Outras variveis
      v_id_pes_mae_aux integer;
      v_id_pes_pai_aux integer;
      v_id_pes_responsavel_aux integer;
  v_id_esco_aux integer;
  v_id_eciv_aux integer;
  v_id_pes_con_aux integer;
      v_nacionalidade_aux integer;
  v_id_pais_estrangeiro_aux integer;
      v_id_mun_nascimento_aux integer;
      v_id_ocup_aux integer;
      v_sexo_aux text;
BEGIN
    IF v_id_pes_mae = 0 THEN
        v_id_pes_mae_aux := NULL;
    ELSE
        v_id_pes_mae_aux := v_id_pes_mae;
    END IF;
    IF v_id_pes_pai = 0 THEN
        v_id_pes_pai_aux := NULL;
    ELSE
        v_id_pes_pai_aux := v_id_pes_pai;
    END IF;
    IF v_id_pes_responsavel = 0 THEN
        v_id_pes_responsavel_aux := NULL;
    ELSE
        v_id_pes_responsavel_aux := v_id_pes_responsavel;
    END IF;
    IF v_id_esco = 0 THEN
        v_id_esco_aux := NULL;
    ELSE
        v_id_esco_aux := v_id_esco;
    END IF;
    IF v_id_eciv = 0 THEN
        v_id_eciv_aux := NULL;
    ELSE
        v_id_eciv_aux := v_id_eciv;
    END IF;
    IF v_id_pes_con = 0 THEN
        v_id_pes_con_aux := NULL;
    ELSE
        v_id_pes_con_aux := v_id_pes_con;
    END IF;
    IF v_nacionalidade = 0 THEN
        v_nacionalidade_aux := NULL;
    ELSE
        v_nacionalidade_aux := v_nacionalidade;
    END IF;
    IF v_id_pais_estrangeiro = 0 THEN
        v_id_pais_estrangeiro_aux := NULL;
    ELSE
        v_id_pais_estrangeiro_aux := v_id_pais_estrangeiro;
    END IF;
    IF v_id_mun_nascimento = 0 THEN
        v_id_mun_nascimento_aux := NULL;
    ELSE
        v_id_mun_nascimento_aux := v_id_mun_nascimento;
    END IF;
    IF v_id_ocup = 0 THEN
        v_id_ocup_aux := NULL;
    ELSE
        v_id_ocup_aux := v_id_ocup;
    END IF;
    IF TRIM(v_sexo) = '' THEN
        v_sexo_aux := NULL;
    ELSE
        v_sexo_aux := public.fcn_upper(v_sexo);
    END IF;
  -- Insere dados na tabela funcionrio
    INSERT INTO cadastro.fisica (idpes, data_nasc, sexo,
                                idpes_mae,idpes_pai, idpes_responsavel,
                                idesco, ideciv, idpes_con,
                                data_uniao, data_obito, nacionalidade,
                                idpais_estrangeiro, data_chegada_brasil, idmun_nascimento,
                                ultima_empresa, idocup, nome_mae,
                                nome_pai, nome_conjuge,
                                nome_responsavel, justificativa_provisorio, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
    VALUES(v_id_pes,to_date(v_data_nasc,'DD/MM/YYYY'),v_sexo_aux,
           v_id_pes_mae_aux, v_id_pes_pai_aux, v_id_pes_responsavel_aux,
           v_id_esco_aux, v_id_eciv_aux, v_id_pes_con_aux,
           to_date(v_data_uniao,'DD/MM/YYYY'), to_date(v_data_obito,'DD/MM/YYYY'), v_nacionalidade_aux,
           v_id_pais_estrangeiro_aux, to_date(v_data_chegada,'DD/MM/YYYY'), v_id_mun_nascimento_aux,             public.fcn_upper(v_ultima_empresa), v_id_ocup_aux, public.fcn_upper(v_nome_mae),
           public.fcn_upper(v_nome_pai), public.fcn_upper(v_nome_conjuge),
           public.fcn_upper(v_nome_responsavel), v_justificativa_provisorio, v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');

  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_fisica_cpf(integer, text, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_fisica_cpf(integer, text, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_cpf ALIAS for $2;
  v_origem_gravacao ALIAS for $3;
      v_idpes_cad ALIAS for $4;
      v_idsis_cad ALIAS for $5;
BEGIN
  INSERT INTO cadastro.fisica_cpf (idpes,cpf, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao) VALUES (v_id_pes,to_number(v_cpf,99999999999), v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_fone_pessoa(integer, integer, integer, integer, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_fone_pessoa(integer, integer, integer, integer, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_tipo ALIAS for $2;
  v_ddd ALIAS for $3;
  v_fone ALIAS for $4;
  v_origem_gravacao ALIAS for $5;
      v_idpes_cad ALIAS for $6;
      v_idsis_cad ALIAS for $7;
BEGIN
  -- Insere dados na tabela fone_pessoa
  INSERT INTO cadastro.fone_pessoa (idpes,tipo,ddd,fone, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
    VALUES (v_id_pes,v_tipo,v_ddd,v_fone, v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_funcionario(integer, integer, integer, integer, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_funcionario(integer, integer, integer, integer, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_matricula ALIAS for $1;
  v_id_ins ALIAS for $2;
  v_id_set ALIAS for $3;
  v_id_pes ALIAS for $4;
      v_situacao ALIAS for $5;
  v_origem_gravacao ALIAS for $6;
      v_idpes_cad ALIAS for $7;
      v_idsis_cad ALIAS for $8;
    -- Outras variveis
    v_id_set_aux integer;
BEGIN
    IF v_id_set = 0 THEN
        v_id_set_aux := NULL;
    ELSE
        v_id_set_aux := v_id_set;
    END IF;
  -- Insere dados na tabela funcionrio
    INSERT INTO cadastro.funcionario (matricula,idins,idset,idpes,situacao, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
    VALUES(v_matricula,v_id_ins,v_id_set_aux,v_id_pes,public.fcn_upper(v_situacao), v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_juridica(integer, character varying, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_juridica(integer, character varying, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_cnpj ALIAS for $2;
  v_fantasia ALIAS for $3;
  v_inscr_estadual ALIAS for $4;
  v_origem_gravacao ALIAS for $5;
      v_idpes_cad ALIAS for $6;
      v_idsis_cad ALIAS for $7;

BEGIN
  -- Insere dados na tabela juridica
    INSERT INTO cadastro.juridica (idpes,cnpj,fantasia,insc_estadual, origem_gravacao, idpes_cad, idsis_cad, data_cad, operacao)
    VALUES (v_id_pes,to_number(v_cnpj,99999999999999),public.fcn_upper(v_fantasia),to_number(v_inscr_estadual,9999999999), v_origem_gravacao, v_idpes_cad, v_idsis_cad, CURRENT_TIMESTAMP, 'I');
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_insert_pessoa(integer, character varying, character varying, character varying, character varying, integer, character varying, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_insert_pessoa(integer, character varying, character varying, character varying, character varying, integer, character varying, character varying, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_razao_social ALIAS for $2;
  v_url ALIAS for $3;
  v_email ALIAS for $4;
  v_situacao ALIAS for $5;
  v_id_pes_logado ALIAS for $6;
  v_tipo ALIAS for $7;
  v_origem_gravacao ALIAS for $8;
      v_idpes_cad ALIAS for $9;
      v_idsis_cad ALIAS for $10;

  idpes_logado integer;
BEGIN
  idpes_logado := v_id_pes_logado;
  IF (idpes_logado <= 0) THEN
    INSERT INTO cadastro.pessoa (idpes,nome,idpes_cad,data_cad,url,tipo,email,situacao,origem_gravacao, idsis_cad, operacao) VALUES (v_id_pes,public.fcn_upper(v_razao_social),NULL,CURRENT_TIMESTAMP,v_url,v_tipo,v_email,v_situacao,v_origem_gravacao, v_idsis_cad, 'I');
  ELSE
    INSERT INTO cadastro.pessoa (idpes,nome,idpes_cad,data_cad,url,tipo,email,situacao,origem_gravacao, idsis_cad, operacao) VALUES (v_id_pes,public.fcn_upper(v_razao_social),idpes_logado,CURRENT_TIMESTAMP,v_url,v_tipo,v_email,v_situacao,v_origem_gravacao, v_idsis_cad, 'I');
  END IF;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_obter_primeiro_ultimo_nome(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_obter_primeiro_ultimo_nome(text) RETURNS text
    AS $_$
DECLARE
  v_nome_parametro    ALIAS FOR $1;
  v_nome        text;
  v_primeiro_nome     text;
  v_ultimo_nome     text;
  v_posicao_espaco_primeiro_nome  integer;
  v_posicao_espaco_ultimo_nome  integer;
  v_cont        integer;
  v_fonema_junior     text;
  v_fonema_sobrinho   text;
  v_fonema_sobrinha   text;
  v_fonema_filho      text;
  v_fonema_filha      text;
  v_fonema_ultimo_nome    text;
  v_reg       record;
  v_total_caracteres    integer;
  BEGIN
  v_primeiro_nome := '';
  v_ultimo_nome := '';
  v_nome := TRIM(v_nome_parametro);
  v_total_caracteres := LENGTH(v_nome);
  -- obter somente o primeiro e o ltimo nome das pessoas
  IF v_total_caracteres > 0 THEN
    -- retirar os espaos duplicados
    WHILE POSITION('  ' IN v_nome) > 0 LOOP
      v_nome := REPLACE(UPPER(v_nome),'  ', ' ');
    END LOOP;
    -- retirar ocorrncias que devem ser ignoradas no nome
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUTROS', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUTRAS', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUTRO', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUTRA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUTRS', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OTS', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUTA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OUT', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E SM', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E S/M', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E OT', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' S/M', ''));
    v_total_caracteres := LENGTH(v_nome);
    IF v_total_caracteres = (POSITION(' OUTRO' IN v_nome) + 5) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUTRO', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OUTRA' IN v_nome) + 5) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUTRA', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OUTROS' IN v_nome) + 6) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUTROS', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OUTRAS' IN v_nome) + 6) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUTRAS', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OTS' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OTS', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OUTA' IN v_nome) + 4) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUTA', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OUT' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUT', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' OUTRS' IN v_nome) + 5) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' OUTRS', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' SM' IN v_nome) + 2) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' SM', ''));
    END IF;
    v_nome := TRIM(v_nome);
    -- posio do espao em branco para obter o primeiro nome
    v_posicao_espaco_primeiro_nome := POSITION(' ' IN v_nome);
    IF v_posicao_espaco_primeiro_nome > 0 THEN
      v_primeiro_nome := SUBSTR(v_nome, 1, (v_posicao_espaco_primeiro_nome - 1));
    ELSE
      v_primeiro_nome := v_nome;
    END IF;
    -- obter o ltimo nome
    v_posicao_espaco_ultimo_nome := 0;
    IF v_posicao_espaco_primeiro_nome > 0 THEN
      v_cont := v_posicao_espaco_ultimo_nome + 1;
      -- obter posio do espao em branco anterior ao ltimo nome
      WHILE v_cont < LENGTH(v_nome) LOOP
        IF SUBSTR(v_nome, v_cont, 1) = ' ' THEN
          v_posicao_espaco_ultimo_nome = v_cont;
        END IF;
        v_cont := v_cont + 1;
      END LOOP;
      v_ultimo_nome := SUBSTR(v_nome, (v_posicao_espaco_ultimo_nome + 1));
      -- fonema do ltimo nome
      FOR v_reg IN SELECT * FROM public.fcn_fonetiza(v_ultimo_nome) LOOP
        v_fonema_ultimo_nome := v_reg.fcn_fonetiza;
      END LOOP;
      -- verificar se o ltimo nome termina com Junior, Sobrinho ou Filho e outros
      FOR v_reg IN SELECT * FROM public.fcn_fonetiza('junior') LOOP
        v_fonema_junior := v_reg.fcn_fonetiza;
      END LOOP;
      FOR v_reg IN SELECT * FROM public.fcn_fonetiza('sobrinho') LOOP
        v_fonema_sobrinho := v_reg.fcn_fonetiza;
      END LOOP;
      FOR v_reg IN SELECT * FROM public.fcn_fonetiza('filho') LOOP
        v_fonema_filho := v_reg.fcn_fonetiza;
      END LOOP;
      FOR v_reg IN SELECT * FROM public.fcn_fonetiza('filha') LOOP
        v_fonema_filha := v_reg.fcn_fonetiza;
      END LOOP;
      FOR v_reg IN SELECT * FROM public.fcn_fonetiza('sobrinha') LOOP
        v_fonema_sobrinha := v_reg.fcn_fonetiza;
      END LOOP;
      IF v_fonema_ultimo_nome = v_fonema_junior OR
                          v_fonema_ultimo_nome = v_fonema_sobrinho OR
                          v_fonema_ultimo_nome = v_fonema_filho OR
                          v_fonema_ultimo_nome = v_fonema_filha OR
                          v_fonema_ultimo_nome = v_fonema_sobrinha
                        THEN
        v_nome := TRIM(SUBSTR(v_nome, 1, (LENGTH(v_nome) - LENGTH(v_ultimo_nome) - 1)));
        v_primeiro_nome := '';
        v_ultimo_nome := '';
        -- obter novamente o primeiro nome
        v_posicao_espaco_primeiro_nome := POSITION(' ' IN v_nome);
        IF v_posicao_espaco_primeiro_nome > 0 THEN
          v_primeiro_nome := SUBSTR(v_nome, 1, (v_posicao_espaco_primeiro_nome - 1));
        END IF;

        -- obter o penultimo nome
        IF v_posicao_espaco_primeiro_nome > 0 THEN
          v_posicao_espaco_ultimo_nome := 0;
          v_cont := 1;

          -- obter posio do espao em branco anterior ao ltimo nome
          WHILE v_cont < LENGTH(v_nome) LOOP
          IF SUBSTR(v_nome, v_cont, 1) = ' ' THEN
            v_posicao_espaco_ultimo_nome = v_cont;
          END IF;
          v_cont := v_cont + 1;
          END LOOP;
          v_ultimo_nome := SUBSTR(v_nome, (v_posicao_espaco_ultimo_nome + 1));
        END IF;
      END IF;
    END IF;
  END IF;
  RETURN v_primeiro_nome || ' ' || v_ultimo_nome;
  END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_obter_primeiro_ultimo_nome_juridica(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_obter_primeiro_ultimo_nome_juridica(text) RETURNS text
    AS $_$
DECLARE
  v_nome_parametro    ALIAS FOR $1;
  v_nome        text;
  v_primeiro_nome     text;
  v_ultimo_nome     text;
  v_posicao_espaco_primeiro_nome  integer;
  v_posicao_espaco_ultimo_nome  integer;
  v_cont        integer;
  v_fonema_ultimo_nome    text;
  v_reg       record;
  v_total_caracteres    integer;
  BEGIN
  v_primeiro_nome := '';
  v_ultimo_nome := '';
  v_nome := TRIM(v_nome_parametro);
  v_total_caracteres := LENGTH(v_nome);
  -- obter somente o primeiro e o ultimo nome das pessoas
  IF v_total_caracteres > 0 THEN
    -- retirar os espaos duplicados
    WHILE POSITION('  ' IN v_nome) > 0 LOOP
      v_nome := REPLACE(UPPER(v_nome),'  ', ' ');
    END LOOP;
    -- retirar ocorrncias que devem ser ignoradas no nome
    v_nome := TRIM(REPLACE(UPPER(v_nome),'&', ' '));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E CIA LTDA ME', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E CIA LTDA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' LTDA E OUTRA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA LTDA ME', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA LTDA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA. LTDA.', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA.LTDA.', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA.LTDA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA LTDA.', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' CIA. LTDA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' SC LT', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' S/C LT', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' S/C L', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' SC L', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' S/C LTD', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' SC LTD', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' E CIA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' LTDA ME', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' LTDA. ME', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),' LTDA.ME', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),'LTDA', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),'LTDA.', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),'S/C', ''));
    v_nome := TRIM(REPLACE(UPPER(v_nome),'S/A', ''));
    v_total_caracteres := LENGTH(v_nome);
    IF v_total_caracteres = (POSITION(' LT' IN v_nome) + 2) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' LT', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' LT.' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' LT.', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' LTD' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' LTD', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' LTD.' IN v_nome) + 4) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' LTD.', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' ME.' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' ME.', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' ME' IN v_nome) + 2) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' ME', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' -ME' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' -ME', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' -ME.' IN v_nome) + 4) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' -ME.', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' SA' IN v_nome) + 2) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' SA', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' S.A.' IN v_nome) + 4) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' S.A.', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' S.A' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' S.A', ''));
    END IF;
    IF v_total_caracteres = (POSITION(' S A' IN v_nome) + 3) THEN
      v_nome := TRIM(REPLACE(UPPER(v_nome),' S A', ''));
    END IF;
    v_nome := TRIM(v_nome);
    -- posio do espaco em branco para obter o primeiro nome
    v_posicao_espaco_primeiro_nome := POSITION(' ' IN v_nome);
    IF v_posicao_espaco_primeiro_nome > 0 THEN
      v_primeiro_nome := SUBSTR(v_nome, 1, (v_posicao_espaco_primeiro_nome - 1));
    ELSE
      v_primeiro_nome := v_nome;
    END IF;
    -- obter o ultimo nome
    v_posicao_espaco_ultimo_nome := 0;
    IF v_posicao_espaco_primeiro_nome > 0 THEN
      v_cont := v_posicao_espaco_ultimo_nome + 1;
      -- obter posicao do espaco em branco anterior ao ultimo nome
      WHILE v_cont < LENGTH(v_nome) LOOP
        IF SUBSTR(v_nome, v_cont, 1) = ' ' THEN
          v_posicao_espaco_ultimo_nome = v_cont;
        END IF;
        v_cont := v_cont + 1;
      END LOOP;
      v_ultimo_nome := SUBSTR(v_nome, (v_posicao_espaco_ultimo_nome + 1));
    END IF;
  END IF;
  --Fonetizando o primeiro nome--
  FOR v_reg IN SELECT * FROM public.fcn_fonetiza(v_primeiro_nome) LOOP
    v_primeiro_nome := v_reg.fcn_fonetiza;
  END LOOP;
  --Fonetizando o ultimo nome nome--
  FOR v_reg IN SELECT * FROM public.fcn_fonetiza(v_ultimo_nome) LOOP
    v_ultimo_nome := v_reg.fcn_fonetiza;
  END LOOP;
  RETURN v_primeiro_nome || ' ' || v_ultimo_nome;
  END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_documento(integer, character varying, character varying, character varying, character varying, integer, integer, integer, integer, character varying, character varying, character varying, character varying, integer, integer, character varying, character varying, integer, integer, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_documento(integer, character varying, character varying, character varying, character varying, integer, integer, integer, integer, character varying, character varying, character varying, character varying, integer, integer, character varying, character varying, integer, integer, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_rg ALIAS for $2;
  v_orgao_exp_rg ALIAS for $3;
  v_data_exp_rg ALIAS for $4;
  v_sigla_uf_exp_rg ALIAS for $5;
    v_tipo_cert_civil ALIAS for $6;
    v_num_termo ALIAS for $7;
  v_num_livro ALIAS for $8;
  v_num_folha ALIAS for $9;
    v_data_emissao_cert_civil ALIAS for $10;
    v_sigla_uf_cert_civil ALIAS for $11;
  v_sigla_uf_cart_trabalho ALIAS for $12;
  v_cartorio_cert_civil ALIAS for $13;
  v_num_cart_trabalho ALIAS for $14;
    v_serie_cart_trabalho ALIAS for $15;
    v_data_emissao_cart_trabalho ALIAS for $16;
  v_num_tit_eleitor ALIAS for $17;
  v_zona_tit_eleitor ALIAS for $18;
  v_secao_tit_eleitor ALIAS for $19;
  v_origem_gravacao ALIAS for $20;
  v_idpes_rev ALIAS for $21;
  v_idsis_rev ALIAS for $22;

    -- Outras variveis
    v_rg_aux varchar(10);
    v_orgao_exp_rg_aux varchar(10);
    v_sigla_uf_exp_rg_aux varchar(2);
    v_tipo_cert_civil_aux integer;
  v_num_termo_aux integer;
  v_num_livro_aux integer;
  v_num_folha_aux integer;
    v_sigla_uf_cert_civil_aux varchar(2);
  v_sigla_uf_cart_trabalho_aux varchar(2);
    v_cartorio_cert_civil_aux varchar(150);
    v_num_cart_trabalho_aux integer;
    v_serie_cart_trabalho_aux integer;
    v_num_tit_eleitor_aux varchar(13);
    v_zona_tit_eleitor_aux integer;
    v_secao_tit_eleitor_aux integer;
BEGIN
    IF v_rg = '' THEN
        v_rg_aux := NULL;
    ELSE
        v_rg_aux := v_rg;
    END IF;
    IF v_orgao_exp_rg = '' THEN
        v_orgao_exp_rg_aux := NULL;
    ELSE
        v_orgao_exp_rg_aux := v_orgao_exp_rg;
    END IF;
    IF v_sigla_uf_exp_rg = '' THEN
        v_sigla_uf_exp_rg_aux := NULL;
    ELSE
        v_sigla_uf_exp_rg_aux := v_sigla_uf_exp_rg;
    END IF;
    IF v_tipo_cert_civil = 0 THEN
        v_tipo_cert_civil_aux := NULL;
    ELSE
        v_tipo_cert_civil_aux := v_tipo_cert_civil;
    END IF;
    IF v_num_termo = 0 THEN
        v_num_termo_aux := NULL;
    ELSE
        v_num_termo_aux := v_num_termo;
    END IF;
    IF v_num_livro = 0 THEN
        v_num_livro_aux := NULL;
    ELSE
        v_num_livro_aux := v_num_livro;
    END IF;
    IF v_num_folha = 0 THEN
        v_num_folha_aux := NULL;
    ELSE
        v_num_folha_aux := v_num_folha;
    END IF;
    IF v_sigla_uf_cert_civil = '' THEN
        v_sigla_uf_cert_civil_aux := NULL;
    ELSE
        v_sigla_uf_cert_civil_aux := v_sigla_uf_cert_civil;
    END IF;
    IF v_sigla_uf_cart_trabalho = '' THEN
        v_sigla_uf_cart_trabalho_aux := NULL;
    ELSE
        v_sigla_uf_cart_trabalho_aux := v_sigla_uf_cart_trabalho;
    END IF;
    IF v_cartorio_cert_civil = '' THEN
        v_cartorio_cert_civil_aux := NULL;
    ELSE
        v_cartorio_cert_civil_aux := v_cartorio_cert_civil;
    END IF;
    IF v_num_cart_trabalho = 0 THEN
        v_num_cart_trabalho_aux := NULL;
    ELSE
        v_num_cart_trabalho_aux := v_num_cart_trabalho;
    END IF;
    IF v_serie_cart_trabalho = 0 THEN
        v_serie_cart_trabalho_aux := NULL;
    ELSE
        v_serie_cart_trabalho_aux := v_serie_cart_trabalho;
    END IF;
    IF v_num_tit_eleitor = '' THEN
        v_num_tit_eleitor_aux := NULL;
    ELSE
        v_num_tit_eleitor_aux := v_num_tit_eleitor;
    END IF;
    IF v_zona_tit_eleitor = 0 THEN
        v_zona_tit_eleitor_aux := NULL;
    ELSE
        v_zona_tit_eleitor_aux := v_zona_tit_eleitor;
    END IF;
    IF v_secao_tit_eleitor = 0 THEN
        v_secao_tit_eleitor_aux := NULL;
    ELSE
        v_secao_tit_eleitor_aux := v_secao_tit_eleitor;
    END IF;

  -- Insere dados na tabela funcionrio
    UPDATE cadastro.documento
    SET rg = to_number(v_rg_aux,9999999999),
        idorg_exp_rg = to_number(v_orgao_exp_rg_aux,9999999999),
        data_exp_rg = to_date(v_data_exp_rg,'DD/MM/YYYY'),
        sigla_uf_exp_rg = v_sigla_uf_exp_rg_aux,
        tipo_cert_civil = v_tipo_cert_civil_aux,
        num_termo = v_num_termo_aux,
        num_livro = v_num_livro_aux,
        num_folha = v_num_folha_aux,
        data_emissao_cert_civil = to_date(v_data_emissao_cert_civil,'DD/MM/YYYY'),
        sigla_uf_cert_civil = v_sigla_uf_cert_civil_aux,
        sigla_uf_cart_trabalho = v_sigla_uf_cart_trabalho_aux,
        cartorio_cert_civil = v_cartorio_cert_civil_aux,
        num_cart_trabalho = v_num_cart_trabalho_aux,
        serie_cart_trabalho = v_serie_cart_trabalho_aux,
        data_emissao_cart_trabalho = to_date(v_data_emissao_cart_trabalho,'DD/MM/YYYY'),
        num_tit_eleitor = to_number(v_num_tit_eleitor_aux,9999999999999),                                              zona_tit_eleitor = v_zona_tit_eleitor_aux,
        secao_tit_eleitor = v_secao_tit_eleitor_aux,
  origem_gravacao = v_origem_gravacao,
  idpes_rev = v_idpes_rev,
  idsis_rev = v_idsis_rev,
  data_rev = CURRENT_TIMESTAMP,
  operacao = 'A'
    WHERE idpes = v_id_pes;


  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_endereco_externo(integer, integer, character varying, character varying, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_endereco_externo(integer, integer, character varying, character varying, character varying, integer, character varying, character varying, character varying, integer, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_tipo ALIAS for $2;
  v_sigla_uf ALIAS for $3;
  v_idtlog ALIAS for $4;
    v_logradouro ALIAS for $5;
    v_numero ALIAS for $6;
    v_letra ALIAS for $7;
    v_complemento ALIAS for $8;
    v_bairro ALIAS for $9;
    v_cep ALIAS for $10;
    v_cidade ALIAS for $11;
    v_reside_desde ALIAS for $12;
    v_origem_gravacao ALIAS for $13;
    v_idpes_rev ALIAS for $14;
    v_idsis_rev ALIAS for $15;

BEGIN
  -- Atualiza dados na tabela endereco_externo
  UPDATE cadastro.endereco_externo
    SET sigla_uf = v_sigla_uf,
        idtlog = v_idtlog,
        logradouro = public.fcn_upper(v_logradouro),
        numero = v_numero,
        letra = public.fcn_upper(v_letra),
        complemento = public.fcn_upper(v_complemento),
        bairro = public.fcn_upper(v_bairro),
        cep = v_cep,
        cidade = public.fcn_upper(v_cidade),
        reside_desde = to_date(v_reside_desde,'DD/MM/YYYY'),
  origem_gravacao = v_origem_gravacao,
  idpes_rev = v_idpes_rev,
  idsis_rev = v_idsis_rev,
  data_rev = CURRENT_TIMESTAMP,
  operacao = 'A'
    WHERE idpes = v_id_pes
    AND tipo = v_tipo;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_endereco_pessoa(integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_endereco_pessoa(integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
    -- Parmetro recebidos
    v_id_pes ALIAS for $1;
    v_tipo ALIAS for $2;
    v_cep ALIAS for $3;
    v_idlog ALIAS for $4;
    v_idbai ALIAS for $5;
    v_numero ALIAS for $6;
    v_letra ALIAS for $7;
    v_complemento ALIAS for $8;
    v_reside_desde ALIAS for $9;
    v_origem_gravacao ALIAS for $10;
    v_idpes_rev ALIAS for $11;
    v_idsis_rev ALIAS for $12;
    v_sql_update text;
BEGIN
    -- Atualiza dados na tabela endereco_pessoa
    UPDATE cadastro.endereco_pessoa
    SET cep = v_cep,
        idlog = v_idlog,
        idbai = v_idbai,
        numero = v_numero,
        letra = public.fcn_upper(v_letra),
        complemento = public.fcn_upper(v_complemento),
        reside_desde = to_date(v_reside_desde,'DD/MM/YYYY'),
  origem_gravacao = v_origem_gravacao,
  idpes_rev = v_idpes_rev,
  idsis_rev = v_idsis_rev,
  data_rev = CURRENT_TIMESTAMP,
  operacao = 'A'
    WHERE idpes = v_id_pes
    AND tipo = v_tipo;
    RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_fisica(integer, character varying, character varying, integer, integer, integer, integer, integer, integer, character varying, character varying, integer, integer, character varying, integer, character varying, integer, character varying, character varying, character varying, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_fisica(integer, character varying, character varying, integer, integer, integer, integer, integer, integer, character varying, character varying, integer, integer, character varying, integer, character varying, integer, character varying, character varying, character varying, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_data_nasc ALIAS for $2;
  v_sexo ALIAS for $3;
  v_id_pes_mae ALIAS for $4;
      v_id_pes_pai ALIAS for $5;
      v_id_pes_responsavel ALIAS for $6;
  v_id_esco ALIAS for $7;
  v_id_eciv ALIAS for $8;
  v_id_pes_con ALIAS for $9;
      v_data_uniao ALIAS for $10;
      v_data_obito ALIAS for $11;
  v_nacionalidade ALIAS for $12;
  v_id_pais_estrangeiro ALIAS for $13;
  v_data_chegada ALIAS for $14;
      v_id_mun_nascimento ALIAS for $15;
      v_ultima_empresa ALIAS for $16;
  v_id_ocup ALIAS for $17;
  v_nome_mae ALIAS for $18;
  v_nome_pai ALIAS for $19;
      v_nome_conjuge ALIAS for $20;
      v_nome_responsavel ALIAS for $21;
      v_justificativa_provisorio ALIAS for $22;
      v_origem_gravacao ALIAS for $23;
      v_idpes_rev ALIAS for $24;
      v_idsis_rev ALIAS for $25;

      -- Outras variveis
      v_id_pes_mae_aux integer;
      v_id_pes_pai_aux integer;
      v_id_pes_responsavel_aux integer;
  v_id_esco_aux integer;
  v_id_eciv_aux integer;
  v_id_pes_con_aux integer;
      v_nacionalidade_aux integer;
  v_id_pais_estrangeiro_aux integer;
      v_id_mun_nascimento_aux integer;
      v_id_ocup_aux integer;
  v_sexo_aux text;
BEGIN
    IF v_id_pes_mae = 0 THEN
        v_id_pes_mae_aux := NULL;
    ELSE
        v_id_pes_mae_aux := v_id_pes_mae;
    END IF;
    IF v_id_pes_pai = 0 THEN
        v_id_pes_pai_aux := NULL;
    ELSE
        v_id_pes_pai_aux := v_id_pes_pai;
    END IF;
    IF v_id_pes_responsavel = 0 THEN
        v_id_pes_responsavel_aux := NULL;
    ELSE
        v_id_pes_responsavel_aux := v_id_pes_responsavel;
    END IF;
    IF v_id_esco = 0 THEN
        v_id_esco_aux := NULL;
    ELSE
        v_id_esco_aux := v_id_esco;
    END IF;
    IF v_id_eciv = 0 THEN
        v_id_eciv_aux := NULL;
    ELSE
        v_id_eciv_aux := v_id_eciv;
    END IF;
    IF v_id_pes_con = 0 THEN
        v_id_pes_con_aux := NULL;
    ELSE
        v_id_pes_con_aux := v_id_pes_con;
    END IF;
    IF v_nacionalidade = 0 THEN
        v_nacionalidade_aux := NULL;
    ELSE
        v_nacionalidade_aux := v_nacionalidade;
    END IF;
    IF v_id_pais_estrangeiro = 0 THEN
        v_id_pais_estrangeiro_aux := NULL;
    ELSE
        v_id_pais_estrangeiro_aux := v_id_pais_estrangeiro;
    END IF;
    IF v_id_mun_nascimento = 0 THEN
        v_id_mun_nascimento_aux := NULL;
    ELSE
        v_id_mun_nascimento_aux := v_id_mun_nascimento;
    END IF;
    IF v_id_ocup = 0 THEN
        v_id_ocup_aux := NULL;
    ELSE
        v_id_ocup_aux := v_id_ocup;
    END IF;
    IF TRIM(v_sexo) = '' THEN
        v_sexo_aux := NULL;
    ELSE
        v_sexo_aux := public.fcn_upper(v_sexo);
    END IF;
  -- Insere dados na tabela funcionrio
    UPDATE cadastro.fisica
    SET data_nasc = to_date(v_data_nasc,'DD/MM/YYYY'),
        sexo = v_sexo_aux,
        idpes_mae = v_id_pes_mae_aux,
        idpes_pai = v_id_pes_pai_aux,
        idpes_responsavel = v_id_pes_responsavel_aux,
        idesco = v_id_esco_aux,
        ideciv = v_id_eciv_aux,
        idpes_con = v_id_pes_con_aux,
        data_uniao = to_date(v_data_uniao,'DD/MM/YYYY'),
        data_obito = to_date(v_data_obito,'DD/MM/YYYY'),
        nacionalidade = v_nacionalidade_aux,
        idpais_estrangeiro = v_id_pais_estrangeiro_aux,
        data_chegada_brasil = to_date(v_data_chegada,'DD/MM/YYYY'),
        idmun_nascimento = v_id_mun_nascimento_aux,
        ultima_empresa = public.fcn_upper(v_ultima_empresa),
        idocup = v_id_ocup_aux,
        nome_mae = public.fcn_upper(v_nome_mae),
        nome_pai = public.fcn_upper(v_nome_pai),
        nome_conjuge = public.fcn_upper(v_nome_conjuge),
        nome_responsavel = public.fcn_upper(v_nome_responsavel),
        justificativa_provisorio = v_justificativa_provisorio,
  origem_gravacao = v_origem_gravacao,
  idpes_rev = v_idpes_rev,
  idsis_rev = v_idsis_rev,
  data_rev = CURRENT_TIMESTAMP,
  operacao = 'A'
    WHERE idpes = v_id_pes;

  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_fisica_cpf(integer, text, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_fisica_cpf(integer, text, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_cpf ALIAS for $2;
  v_origem_gravacao ALIAS for $3;
  v_idpes_rev ALIAS for $4;
  v_idsis_rev ALIAS for $5;

BEGIN
  -- Atualiza dados na tabela fisica_cpf
  UPDATE cadastro.fisica_cpf SET
    origem_gravacao = v_origem_gravacao,
    idpes_rev = v_idpes_rev,
    idsis_rev = v_idsis_rev,
    data_rev = CURRENT_TIMESTAMP,
    operacao = 'A',
    cpf = to_number(v_cpf,99999999999)
    WHERE cadastro.fisica_cpf.idpes = v_id_pes;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_fone_pessoa(integer, integer, integer, integer, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_fone_pessoa(integer, integer, integer, integer, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_tipo ALIAS for $2;
  v_ddd ALIAS for $3;
  v_fone ALIAS for $4;
  v_origem_gravacao ALIAS for $5;
      v_idpes_rev ALIAS for $6;
      v_idsis_rev ALIAS for $7;

BEGIN
  -- Atualiza dados na tabela fone_pessoa
  UPDATE cadastro.fone_pessoa
    SET ddd = v_ddd,
        fone = v_fone,
  origem_gravacao = v_origem_gravacao,
  idpes_rev = v_idpes_rev,
  idsis_rev = v_idsis_rev,
  data_rev = CURRENT_TIMESTAMP,
  operacao = 'A'
    WHERE idpes = v_id_pes
    AND tipo = v_tipo;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_funcionario(numeric, integer, integer, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_funcionario(numeric, integer, integer, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_matricula ALIAS for $1;
  v_id_ins ALIAS for $2;
  v_id_set ALIAS for $3;
  v_situacao ALIAS for $4;
      v_origem_gravacao ALIAS for $5;
      v_idpes_rev ALIAS for $6;
      v_idsis_rev ALIAS for $7;
  -- Outras variveis
  v_id_set_aux integer;
  v_matricula_aux numeric;
  v_id_ins_aux integer;
  v_situacao_aux varchar(1);
BEGIN
  v_matricula_aux := v_matricula;
  v_id_ins_aux := v_id_ins;
  v_situacao_aux := v_situacao;
  IF v_id_set <= 0 THEN
    v_id_set_aux := NULL;
  ELSE
    v_id_set_aux := v_id_set;
  END IF;

  IF v_id_set_aux IS NULL AND v_id_set = -1 THEN
    -- Sql utilizado para ativar e desativar o registro na tabela funcionrio
     UPDATE cadastro.funcionario
      SET situacao=v_situacao_aux,
      origem_gravacao = v_origem_gravacao,
      idpes_rev = v_idpes_rev,
      idsis_rev = v_idsis_rev,
      data_rev = CURRENT_DATE,
      operacao = 'A'
      WHERE
          matricula=v_matricula_aux AND
          idins=v_id_ins_aux;
  ELSE
    UPDATE cadastro.funcionario
      SET idset=v_id_set_aux,
          situacao=v_situacao_aux,
          origem_gravacao = v_origem_gravacao,
          idpes_rev = v_idpes_rev,
          idsis_rev = v_idsis_rev,
          data_rev = CURRENT_TIMESTAMP,
            operacao = 'A'
      WHERE
          matricula=v_matricula_aux AND
          idins=v_id_ins_aux;
  END IF;

  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_juridica(integer, character varying, character varying, character varying, character, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_juridica(integer, character varying, character varying, character varying, character, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_cnpj ALIAS for $2;
  v_fantasia ALIAS for $3;
  v_inscr_estadual ALIAS for $4;
      v_origem_gravacao ALIAS for $5;
      v_idpes_rev ALIAS for $6;
      v_idsis_rev ALIAS for $7;

BEGIN
  -- Atualiza dados na tabela juridica
  UPDATE cadastro.juridica
    SET cnpj = to_number(v_cnpj,99999999999999),
        fantasia = public.fcn_upper(v_fantasia),
        insc_estadual = to_number(v_inscr_estadual,9999999999),
  origem_gravacao = v_origem_gravacao,
  idpes_rev = v_idpes_rev,
  idsis_rev = v_idsis_rev,
  data_rev = CURRENT_TIMESTAMP,
  operacao = 'A'
    WHERE idpes = v_id_pes;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_update_pessoa(integer, text, character varying, character varying, character varying, integer, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_update_pessoa(integer, text, character varying, character varying, character varying, integer, character varying, integer, integer) RETURNS integer
    AS $_$
DECLARE
  -- Parmetro recebidos
  v_id_pes ALIAS for $1;
  v_razao_social ALIAS for $2;
  v_url ALIAS for $3;
  v_email ALIAS for $4;
  v_situacao ALIAS for $5;
  v_id_pes_logado ALIAS for $6;
  v_origem_gravacao ALIAS for $7;
      v_idpes_rev ALIAS for $8;
      v_idsis_rev ALIAS for $9;

  idpes_logado integer;
BEGIN
  idpes_logado := v_id_pes_logado;
  IF (idpes_logado <= 0) THEN
    -- Atualiza dados na tabela pessoa
    UPDATE cadastro.pessoa SET
        nome = public.fcn_upper(v_razao_social),
        url = v_url,
        email = v_email,
        situacao = v_situacao,
        idpes_rev = NULL,
        data_rev = CURRENT_TIMESTAMP,
              origem_gravacao = v_origem_gravacao,
        idsis_rev = v_idsis_rev,
        operacao = 'A'
        WHERE idpes = v_id_pes;
  ELSE
    -- Atualiza dados na tabela pessoa
    UPDATE cadastro.pessoa SET
        nome = public.fcn_upper(v_razao_social),
        url = v_url,
        email = v_email,
        situacao = v_situacao,
        idpes_rev = idpes_logado,
        data_rev = CURRENT_TIMESTAMP,
              origem_gravacao = v_origem_gravacao,
        idsis_rev = v_idsis_rev,
        operacao = 'A'
        WHERE idpes = v_id_pes;
    END IF;
  RETURN 0;
END;$_$
    LANGUAGE plpgsql;


--
-- Name: fcn_upper(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_upper(text) RETURNS text
    AS $_$
   DECLARE
    v_texto     ALIAS FOR $1;
    v_retorno   text := '';
   BEGIN
    IF v_texto IS NOT NULL THEN
     SELECT translate(upper(v_texto),'','') INTO v_retorno;
    END IF;
    RETURN v_retorno;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: fcn_upper_nrm(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION fcn_upper_nrm(text) RETURNS text
    AS $_$
   DECLARE
    v_texto     ALIAS FOR $1;
    v_retorno   text := '';
   BEGIN
    IF v_texto IS NOT NULL THEN
     SELECT translate(upper(v_texto),'','AEIOUYAEIOUAOAEIOUAEIOUYCAEIOUYAEIOUAOAEIOUAEIOUC') INTO v_retorno;
    END IF;
    RETURN v_retorno;
   END;
  $_$
    LANGUAGE plpgsql;


--
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    AS '$libdir/plpgsql', 'plpgsql_call_handler'
    LANGUAGE c;


SET search_path = acesso, pg_catalog;

--
-- Name: funcao_idfunc_seq; Type: SEQUENCE; Schema: acesso; Owner: -
--

CREATE SEQUENCE funcao_idfunc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: funcao_idfunc_seq; Type: SEQUENCE SET; Schema: acesso; Owner: -
--

SELECT pg_catalog.setval('funcao_idfunc_seq', 1, false);


SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: funcao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE funcao (
    idfunc integer DEFAULT nextval('funcao_idfunc_seq'::regclass) NOT NULL,
    idsis integer NOT NULL,
    idmen integer NOT NULL,
    nome character varying(100) NOT NULL,
    situacao character(1) NOT NULL,
    url character varying(250) NOT NULL,
    ordem numeric(2,0) NOT NULL,
    descricao character varying(250) NOT NULL,
    CONSTRAINT ck_funcao_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: grupo_idgrp_seq; Type: SEQUENCE; Schema: acesso; Owner: -
--

CREATE SEQUENCE grupo_idgrp_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: grupo_idgrp_seq; Type: SEQUENCE SET; Schema: acesso; Owner: -
--

SELECT pg_catalog.setval('grupo_idgrp_seq', 1, false);


--
-- Name: grupo; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE grupo (
    idgrp integer DEFAULT nextval('grupo_idgrp_seq'::regclass) NOT NULL,
    nome character varying(40) NOT NULL,
    situacao character(1) NOT NULL,
    descricao character varying(250),
    CONSTRAINT ck_grupo_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: grupo_funcao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE grupo_funcao (
    idmen integer NOT NULL,
    idsis integer NOT NULL,
    idgrp integer NOT NULL,
    idfunc integer NOT NULL
);


--
-- Name: grupo_menu; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE grupo_menu (
    idgrp integer NOT NULL,
    idsis integer NOT NULL,
    idmen integer NOT NULL
);


--
-- Name: grupo_operacao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE grupo_operacao (
    idfunc integer NOT NULL,
    idgrp integer NOT NULL,
    idsis integer NOT NULL,
    idmen integer NOT NULL,
    idope integer NOT NULL
);


--
-- Name: grupo_sistema; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE grupo_sistema (
    idsis integer NOT NULL,
    idgrp integer NOT NULL
);


--
-- Name: historico_senha; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE historico_senha (
    login character varying(16) NOT NULL,
    senha character varying(60) NOT NULL,
    data_cad timestamp without time zone NOT NULL
);


--
-- Name: instituicao_idins_seq; Type: SEQUENCE; Schema: acesso; Owner: -
--

CREATE SEQUENCE instituicao_idins_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: instituicao_idins_seq; Type: SEQUENCE SET; Schema: acesso; Owner: -
--

SELECT pg_catalog.setval('instituicao_idins_seq', 1, false);


--
-- Name: instituicao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE instituicao (
    idins integer DEFAULT nextval('instituicao_idins_seq'::regclass) NOT NULL,
    nome character varying(60) NOT NULL,
    situacao character(1) NOT NULL,
    CONSTRAINT ck_instituicao_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: log_acesso; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE log_acesso (
    data timestamp without time zone NOT NULL,
    idpes numeric(8,0) NOT NULL,
    idsis integer,
    idins integer,
    idcli character varying(10),
    operacao character(1) NOT NULL,
    CONSTRAINT ck_log_acesso_situacao CHECK (((operacao = 'I'::bpchar) OR (operacao = 'O'::bpchar)))
);


--
-- Name: log_erro; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE log_erro (
    data timestamp without time zone NOT NULL,
    idpes numeric(8,0),
    idsis integer,
    idmen integer,
    idfunc integer,
    idope integer,
    msg_erro text NOT NULL
);


--
-- Name: menu_idmen_seq; Type: SEQUENCE; Schema: acesso; Owner: -
--

CREATE SEQUENCE menu_idmen_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: menu_idmen_seq; Type: SEQUENCE SET; Schema: acesso; Owner: -
--

SELECT pg_catalog.setval('menu_idmen_seq', 1, false);


--
-- Name: menu; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE menu (
    idmen integer DEFAULT nextval('menu_idmen_seq'::regclass) NOT NULL,
    idsis integer NOT NULL,
    menu_idsis integer,
    menu_idmen integer,
    nome character varying(40) NOT NULL,
    descricao character varying(250) NOT NULL,
    situacao character(1) NOT NULL,
    ordem numeric(2,0) NOT NULL,
    CONSTRAINT ck_menu_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: operacao_idope_seq; Type: SEQUENCE; Schema: acesso; Owner: -
--

CREATE SEQUENCE operacao_idope_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: operacao_idope_seq; Type: SEQUENCE SET; Schema: acesso; Owner: -
--

SELECT pg_catalog.setval('operacao_idope_seq', 1, false);


--
-- Name: operacao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE operacao (
    idope integer DEFAULT nextval('operacao_idope_seq'::regclass) NOT NULL,
    idsis integer,
    nome character varying(40) NOT NULL,
    situacao character(1) NOT NULL,
    descricao character varying(250) NOT NULL,
    CONSTRAINT ck_operacao_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: operacao_funcao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE operacao_funcao (
    idmen integer NOT NULL,
    idsis integer NOT NULL,
    idfunc integer NOT NULL,
    idope integer NOT NULL
);


--
-- Name: pessoa_instituicao; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE pessoa_instituicao (
    idins integer NOT NULL,
    idpes numeric(8,0) NOT NULL
);


--
-- Name: sistema_idsis_seq; Type: SEQUENCE; Schema: acesso; Owner: -
--

CREATE SEQUENCE sistema_idsis_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: sistema_idsis_seq; Type: SEQUENCE SET; Schema: acesso; Owner: -
--

SELECT pg_catalog.setval('sistema_idsis_seq', 17, true);


--
-- Name: sistema; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE sistema (
    idsis integer DEFAULT nextval('sistema_idsis_seq'::regclass) NOT NULL,
    nome character varying(60) NOT NULL,
    descricao character varying(100) NOT NULL,
    contexto character varying(30) NOT NULL,
    situacao character(1) NOT NULL,
    CONSTRAINT ck_sistema_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: usuario; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE usuario (
    login character varying(16) NOT NULL,
    idpes numeric(8,0) NOT NULL,
    idpes_sga numeric(8,0),
    senha character varying(60) NOT NULL,
    datacad date NOT NULL,
    lastlogin timestamp without time zone NOT NULL,
    dica character varying(60),
    situacao character(1) NOT NULL,
    data_alt_senha date NOT NULL,
    exp_senha character(1),
    mudar_senha character(1),
    num_sessao_atual numeric(2,0) NOT NULL,
    prazo_exp numeric(3,0),
    estilo_menu character(1),
    CONSTRAINT ck_usuario_estilo_menu CHECK (((estilo_menu = 'C'::bpchar) OR (estilo_menu = 'D'::bpchar))),
    CONSTRAINT ck_usuario_exp_senha CHECK (((exp_senha = 'S'::bpchar) OR (exp_senha = 'N'::bpchar))),
    CONSTRAINT ck_usuario_mudar_senha CHECK (((mudar_senha = 'S'::bpchar) OR (mudar_senha = 'N'::bpchar))),
    CONSTRAINT ck_usuario_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: usuario_grupo; Type: TABLE; Schema: acesso; Owner: -; Tablespace:
--

CREATE TABLE usuario_grupo (
    idgrp integer NOT NULL,
    login character varying(16) NOT NULL
);


SET search_path = alimentos, pg_catalog;

--
-- Name: baixa_guia_produto_idbap_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE baixa_guia_produto_idbap_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: baixa_guia_produto_idbap_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('baixa_guia_produto_idbap_seq', 1, false);


--
-- Name: baixa_guia_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE baixa_guia_produto (
    idbap integer DEFAULT nextval('baixa_guia_produto_idbap_seq'::regclass) NOT NULL,
    idgup integer NOT NULL,
    idbai integer NOT NULL,
    dt_validade date,
    qtde_recebida numeric NOT NULL,
    dt_operacao date NOT NULL,
    login_baixa character varying(80) NOT NULL
);


--
-- Name: baixa_guia_remessa_idbai_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE baixa_guia_remessa_idbai_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: baixa_guia_remessa_idbai_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('baixa_guia_remessa_idbai_seq', 1, false);


--
-- Name: baixa_guia_remessa; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE baixa_guia_remessa (
    idbai integer DEFAULT nextval('baixa_guia_remessa_idbai_seq'::regclass) NOT NULL,
    login_baixa character varying(80) NOT NULL,
    idgui integer NOT NULL,
    dt_recebimento date NOT NULL,
    nome_recebedor character varying(40) NOT NULL,
    cargo_recebedor character varying(40) NOT NULL,
    dt_operacao date NOT NULL
);


--
-- Name: calendario_idcad_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE calendario_idcad_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: calendario_idcad_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('calendario_idcad_seq', 1, false);


--
-- Name: calendario; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE calendario (
    idcad integer DEFAULT nextval('calendario_idcad_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    ano integer NOT NULL,
    descricao character varying(40) NOT NULL
);


--
-- Name: cardapio_idcar_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE cardapio_idcar_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: cardapio_idcar_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('cardapio_idcar_seq', 1, false);


--
-- Name: cardapio; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE cardapio (
    idcar integer DEFAULT nextval('cardapio_idcar_seq'::regclass) NOT NULL,
    login_inclusao character varying(80) NOT NULL,
    login_alteracao character varying(80),
    idcli character varying(10) NOT NULL,
    idtre integer NOT NULL,
    dt_cardapio date NOT NULL,
    dt_inclusao timestamp without time zone NOT NULL,
    dt_ultima_alteracao timestamp without time zone,
    valor numeric NOT NULL,
    finalizado character(1) NOT NULL,
    CONSTRAINT ck_cardapio_finalizado CHECK (((finalizado = 'S'::bpchar) OR (finalizado = 'N'::bpchar)))
);


--
-- Name: cardapio_faixa_unidade; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE cardapio_faixa_unidade (
    idfeu integer NOT NULL,
    idcar integer NOT NULL
);


--
-- Name: cardapio_produto_idcpr_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE cardapio_produto_idcpr_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: cardapio_produto_idcpr_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('cardapio_produto_idcpr_seq', 1, false);


--
-- Name: cardapio_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE cardapio_produto (
    idcpr integer DEFAULT nextval('cardapio_produto_idcpr_seq'::regclass) NOT NULL,
    idpro integer NOT NULL,
    idcar integer NOT NULL,
    quantidade numeric NOT NULL,
    valor numeric NOT NULL
);


--
-- Name: cardapio_receita; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE cardapio_receita (
    idcar integer NOT NULL,
    idrec integer NOT NULL
);


--
-- Name: cliente; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE cliente (
    idcli character varying(10) NOT NULL,
    nome character varying(40) NOT NULL,
    cnpj character varying(14) NOT NULL,
    endereco character varying(60) NOT NULL,
    bairro character varying(30) NOT NULL,
    cidade character varying(18) NOT NULL,
    cep character varying(8),
    uf character varying(2) NOT NULL,
    telefone character varying(11) NOT NULL,
    fax character varying(11),
    email character varying(40),
    prefeito character varying(40) NOT NULL,
    educacao character varying(40) NOT NULL,
    administracao character varying(40) NOT NULL,
    coordenacao character varying(40) NOT NULL,
    inscritos character(1) NOT NULL,
    idpes integer NOT NULL,
    identificacao character varying(20) NOT NULL,
    tab_produtos character(1),
    CONSTRAINT ck_tab_produtos CHECK (((tab_produtos = '1'::bpchar) OR (tab_produtos = '2'::bpchar)))
);


--
-- Name: composto_quimico_idcom_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE composto_quimico_idcom_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: composto_quimico_idcom_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('composto_quimico_idcom_seq', 1, false);


--
-- Name: composto_quimico; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE composto_quimico (
    idcom integer DEFAULT nextval('composto_quimico_idcom_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    idgrpq integer NOT NULL,
    descricao character varying(50) NOT NULL,
    unidade character varying(5) NOT NULL
);


--
-- Name: contrato_idcon_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE contrato_idcon_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: contrato_idcon_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('contrato_idcon_seq', 1, false);


--
-- Name: contrato; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE contrato (
    idcon integer DEFAULT nextval('contrato_idcon_seq'::regclass) NOT NULL,
    codigo character varying(20) NOT NULL,
    idcli character varying(10) NOT NULL,
    login character varying(80) NOT NULL,
    num_aditivo integer NOT NULL,
    idfor integer NOT NULL,
    dt_vigencia date NOT NULL,
    tipo character(1) NOT NULL,
    vlr_atual numeric NOT NULL,
    cancelado character(1) NOT NULL,
    dt_cancelamento timestamp without time zone,
    dt_inclusao timestamp without time zone NOT NULL,
    ultimo_contrato character(1) NOT NULL,
    vlr_original numeric NOT NULL,
    finalizado character(1) NOT NULL,
    CONSTRAINT ck_contrato_cancelado CHECK (((cancelado = 'S'::bpchar) OR (cancelado = 'N'::bpchar))),
    CONSTRAINT ck_contrato_finalizado CHECK (((finalizado = 'S'::bpchar) OR (finalizado = 'N'::bpchar))),
    CONSTRAINT ck_contrato_tipo CHECK (((tipo = 'C'::bpchar) OR (tipo = 'A'::bpchar))),
    CONSTRAINT ck_contrato_ultimo_contrato CHECK (((ultimo_contrato = 'S'::bpchar) OR (ultimo_contrato = 'N'::bpchar)))
);


--
-- Name: contrato_produto_idcop_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE contrato_produto_idcop_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: contrato_produto_idcop_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('contrato_produto_idcop_seq', 1, false);


--
-- Name: contrato_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE contrato_produto (
    idcop integer DEFAULT nextval('contrato_produto_idcop_seq'::regclass) NOT NULL,
    idcon integer NOT NULL,
    idpro integer NOT NULL,
    qtde_contratada numeric NOT NULL,
    vlr_unitario_atual numeric NOT NULL,
    qtde_remessa numeric NOT NULL,
    qtde_recebida numeric NOT NULL,
    qtde_aditivo numeric NOT NULL,
    vlr_unitario_original numeric NOT NULL,
    operacao character(1) NOT NULL,
    ajuste numeric,
    CONSTRAINT ck_contrato_operacao CHECK (((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar)) OR (operacao = 'N'::bpchar)))
);


--
-- Name: evento_ideve_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE evento_ideve_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: evento_ideve_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('evento_ideve_seq', 1, false);


--
-- Name: evento; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE evento (
    ideve integer DEFAULT nextval('evento_ideve_seq'::regclass) NOT NULL,
    idcad integer NOT NULL,
    mes integer NOT NULL,
    dia integer NOT NULL,
    dia_util character(1) NOT NULL,
    descricao character varying(50) NOT NULL,
    CONSTRAINT ck_evento_dia_util CHECK (((dia_util = 'S'::bpchar) OR (dia_util = 'N'::bpchar)))
);


--
-- Name: faixa_composto_quimico_idfcp_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE faixa_composto_quimico_idfcp_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: faixa_composto_quimico_idfcp_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('faixa_composto_quimico_idfcp_seq', 1, false);


--
-- Name: faixa_composto_quimico; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE faixa_composto_quimico (
    idfcp integer DEFAULT nextval('faixa_composto_quimico_idfcp_seq'::regclass) NOT NULL,
    idcom integer NOT NULL,
    idfae integer NOT NULL,
    quantidade numeric NOT NULL,
    qtde_max_min character(3) NOT NULL,
    CONSTRAINT ck_qtde_max_min CHECK (((qtde_max_min = 'MAX'::bpchar) OR (qtde_max_min = 'MIN'::bpchar)))
);


--
-- Name: faixa_etaria_idfae_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE faixa_etaria_idfae_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: faixa_etaria_idfae_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('faixa_etaria_idfae_seq', 1, false);


--
-- Name: faixa_etaria; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE faixa_etaria (
    idfae integer DEFAULT nextval('faixa_etaria_idfae_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(50) NOT NULL,
    vlr_base_refeicao numeric NOT NULL
);


--
-- Name: fornecedor_idfor_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE fornecedor_idfor_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: fornecedor_idfor_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('fornecedor_idfor_seq', 1, false);


--
-- Name: fornecedor; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE fornecedor (
    idfor integer DEFAULT nextval('fornecedor_idfor_seq'::regclass) NOT NULL,
    idpes integer NOT NULL,
    idcli character varying(10) NOT NULL,
    razao_social character varying(50) NOT NULL,
    nome_fantasia character varying(50) NOT NULL,
    endereco character varying(40) NOT NULL,
    complemento character varying(30),
    bairro character varying(30) NOT NULL,
    cep character varying(8),
    cidade character varying(18) NOT NULL,
    uf character varying(2) NOT NULL,
    telefone character varying(11) NOT NULL,
    fax character varying(11),
    email character varying(40),
    contato character varying(40) NOT NULL,
    cpf_cnpj character varying(14) NOT NULL,
    inscr_estadual character varying(20),
    inscr_municipal character varying(20),
    tipo character(1) NOT NULL,
    CONSTRAINT ck_fornecedor CHECK (((tipo = 'F'::bpchar) OR (tipo = 'J'::bpchar)))
);


--
-- Name: fornecedor_unidade_atendida; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE fornecedor_unidade_atendida (
    iduni integer NOT NULL,
    idfor integer NOT NULL
);


--
-- Name: grupo_quimico_idgrpq_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE grupo_quimico_idgrpq_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: grupo_quimico_idgrpq_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('grupo_quimico_idgrpq_seq', 1, false);


--
-- Name: grupo_quimico; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE grupo_quimico (
    idgrpq integer DEFAULT nextval('grupo_quimico_idgrpq_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(50) NOT NULL
);


--
-- Name: guia_produto_diario_idguiaprodiario_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE guia_produto_diario_idguiaprodiario_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: guia_produto_diario_idguiaprodiario_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('guia_produto_diario_idguiaprodiario_seq', 1, false);


--
-- Name: guia_produto_diario; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE guia_produto_diario (
    idguiaprodiario integer DEFAULT nextval('guia_produto_diario_idguiaprodiario_seq'::regclass) NOT NULL,
    idgui integer NOT NULL,
    idpro integer NOT NULL,
    iduni integer NOT NULL,
    dt_guia date NOT NULL,
    qtde numeric NOT NULL
);


--
-- Name: guia_remessa_idgui_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE guia_remessa_idgui_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: guia_remessa_idgui_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('guia_remessa_idgui_seq', 1, false);


--
-- Name: guia_remessa; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE guia_remessa (
    idgui integer DEFAULT nextval('guia_remessa_idgui_seq'::regclass) NOT NULL,
    idcon integer NOT NULL,
    login_cancelamento character varying(80),
    login_emissao character varying(80) NOT NULL,
    idfor integer NOT NULL,
    iduni integer NOT NULL,
    idcli character varying(10) NOT NULL,
    dt_emissao timestamp without time zone NOT NULL,
    ano integer NOT NULL,
    sequencial integer NOT NULL,
    dt_cardapio_inicial date NOT NULL,
    dt_cardapio_final date NOT NULL,
    num_inscr_matr integer NOT NULL,
    num_refeicao integer NOT NULL,
    situacao character(1) NOT NULL,
    dt_cancelamento timestamp without time zone,
    justificativa_cancelamento character varying(300),
    classe_produto character varying(2) NOT NULL,
    CONSTRAINT ck_guia_remessa_classe_produto CHECK (((((classe_produto)::text = 'P'::text) OR ((classe_produto)::text = 'N'::text)) OR ((classe_produto)::text = 'PN'::text))),
    CONSTRAINT ck_guia_remessa_situacao CHECK (((((situacao = 'E'::bpchar) OR (situacao = 'R'::bpchar)) OR (situacao = 'C'::bpchar)) OR (situacao = 'P'::bpchar)))
);


--
-- Name: guia_remessa_produto_idgup_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE guia_remessa_produto_idgup_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: guia_remessa_produto_idgup_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('guia_remessa_produto_idgup_seq', 1, false);


--
-- Name: guia_remessa_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE guia_remessa_produto (
    idgup integer DEFAULT nextval('guia_remessa_produto_idgup_seq'::regclass) NOT NULL,
    idgui integer NOT NULL,
    idpro integer NOT NULL,
    qtde_per_capita numeric NOT NULL,
    qtde_guia numeric NOT NULL,
    peso numeric NOT NULL,
    qtde_recebida numeric NOT NULL,
    peso_total numeric NOT NULL
);


--
-- Name: log_guia_remessa_idlogguia_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE log_guia_remessa_idlogguia_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: log_guia_remessa_idlogguia_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('log_guia_remessa_idlogguia_seq', 1, false);


--
-- Name: log_guia_remessa; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE log_guia_remessa (
    idlogguia integer DEFAULT nextval('log_guia_remessa_idlogguia_seq'::regclass) NOT NULL,
    login character varying(80) NOT NULL,
    idcli character varying(10) NOT NULL,
    dt_inicial date NOT NULL,
    dt_final date NOT NULL,
    unidade character varying(80) NOT NULL,
    fornecedor character varying(80) NOT NULL,
    classe character(2),
    dt_geracao timestamp without time zone NOT NULL,
    mensagem text NOT NULL
);


--
-- Name: medidas_caseiras; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE medidas_caseiras (
    idmedcas character varying(20) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(50) NOT NULL
);


--
-- Name: pessoa_idpes_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE pessoa_idpes_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: pessoa_idpes_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('pessoa_idpes_seq', 1, false);


--
-- Name: pessoa; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE pessoa (
    idpes integer DEFAULT nextval('pessoa_idpes_seq'::regclass) NOT NULL,
    tipo character varying(1) NOT NULL,
    CONSTRAINT ck_pessoa CHECK (((((tipo)::text = 'C'::text) OR ((tipo)::text = 'F'::text)) OR ((tipo)::text = 'U'::text)))
);


--
-- Name: produto_idpro_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE produto_idpro_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: produto_idpro_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('produto_idpro_seq', 1, false);


--
-- Name: produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE produto (
    idpro integer DEFAULT nextval('produto_idpro_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    idunp character varying(20) NOT NULL,
    idfnde character varying(15) NOT NULL,
    idtip integer NOT NULL,
    descricao character varying(60) NOT NULL,
    nome_compra character varying(60) NOT NULL,
    referencia_ceasa character varying(1) NOT NULL,
    fator_coccao numeric NOT NULL,
    fator_correcao numeric NOT NULL,
    vlr_unitario numeric NOT NULL,
    penultimo_vlr_unitario numeric,
    dt_ultima_compra timestamp without time zone,
    dt_penultima_compra timestamp without time zone,
    qtde_estoque numeric NOT NULL,
    classe character varying(1) NOT NULL,
    desc_composto character varying(300),
    idfor integer,
    CONSTRAINT ck_produto_classe CHECK ((((classe)::text = 'P'::text) OR ((classe)::text = 'N'::text))),
    CONSTRAINT ck_produto_referencia_ceasa CHECK ((((referencia_ceasa)::text = '1'::text) OR ((referencia_ceasa)::text = '0'::text)))
);


--
-- Name: produto_composto_quimico_idpcq_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE produto_composto_quimico_idpcq_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: produto_composto_quimico_idpcq_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('produto_composto_quimico_idpcq_seq', 1, false);


--
-- Name: produto_composto_quimico; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE produto_composto_quimico (
    idpcq integer DEFAULT nextval('produto_composto_quimico_idpcq_seq'::regclass) NOT NULL,
    idpro integer NOT NULL,
    idcom integer NOT NULL,
    quantidade numeric NOT NULL
);


--
-- Name: produto_fornecedor_idprf_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE produto_fornecedor_idprf_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: produto_fornecedor_idprf_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('produto_fornecedor_idprf_seq', 1, false);


--
-- Name: produto_fornecedor; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE produto_fornecedor (
    idprf integer DEFAULT nextval('produto_fornecedor_idprf_seq'::regclass) NOT NULL,
    idfor integer NOT NULL,
    idpro integer NOT NULL,
    codigo_ean character varying(18) NOT NULL
);


--
-- Name: produto_medida_caseira_idpmc_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE produto_medida_caseira_idpmc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: produto_medida_caseira_idpmc_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('produto_medida_caseira_idpmc_seq', 1, false);


--
-- Name: produto_medida_caseira; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE produto_medida_caseira (
    idpmc integer DEFAULT nextval('produto_medida_caseira_idpmc_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    idmedcas character varying(20) NOT NULL,
    idpro integer NOT NULL,
    peso numeric NOT NULL
);


--
-- Name: receita_idrec_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE receita_idrec_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: receita_idrec_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('receita_idrec_seq', 1, false);


--
-- Name: receita; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE receita (
    idrec integer DEFAULT nextval('receita_idrec_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    valor numeric NOT NULL,
    descricao character varying(60) NOT NULL,
    modo_preparo text NOT NULL,
    rendimento integer NOT NULL,
    valor_percapita numeric NOT NULL
);


--
-- Name: receita_composto_quimico_idrcq_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE receita_composto_quimico_idrcq_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: receita_composto_quimico_idrcq_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('receita_composto_quimico_idrcq_seq', 1, false);


--
-- Name: receita_composto_quimico; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE receita_composto_quimico (
    idrcq integer DEFAULT nextval('receita_composto_quimico_idrcq_seq'::regclass) NOT NULL,
    idcom integer NOT NULL,
    idrec integer NOT NULL,
    quantidade numeric NOT NULL
);


--
-- Name: receita_produto_idrpr_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE receita_produto_idrpr_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: receita_produto_idrpr_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('receita_produto_idrpr_seq', 1, false);


--
-- Name: receita_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE receita_produto (
    idrpr integer DEFAULT nextval('receita_produto_idrpr_seq'::regclass) NOT NULL,
    idpro integer NOT NULL,
    idrec integer NOT NULL,
    idmedcas character varying(20),
    quantidade numeric NOT NULL,
    valor numeric NOT NULL,
    qtdemedidacaseira integer NOT NULL,
    valor_percapita numeric NOT NULL
);


--
-- Name: tipo_produto_idtip_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE tipo_produto_idtip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_produto_idtip_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('tipo_produto_idtip_seq', 1, false);


--
-- Name: tipo_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE tipo_produto (
    idtip integer DEFAULT nextval('tipo_produto_idtip_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(50) NOT NULL
);


--
-- Name: tipo_refeicao_idtre_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE tipo_refeicao_idtre_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_refeicao_idtre_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('tipo_refeicao_idtre_seq', 1, false);


--
-- Name: tipo_refeicao; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE tipo_refeicao (
    idtre integer DEFAULT nextval('tipo_refeicao_idtre_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(30) NOT NULL
);


--
-- Name: tipo_unidade_idtip_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE tipo_unidade_idtip_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_unidade_idtip_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('tipo_unidade_idtip_seq', 1, false);


--
-- Name: tipo_unidade; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE tipo_unidade (
    idtip integer DEFAULT nextval('tipo_unidade_idtip_seq'::regclass) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(50) NOT NULL
);


--
-- Name: unidade_atendida_iduni_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE unidade_atendida_iduni_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: unidade_atendida_iduni_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('unidade_atendida_iduni_seq', 1, false);


--
-- Name: unidade_atendida; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE unidade_atendida (
    iduni integer DEFAULT nextval('unidade_atendida_iduni_seq'::regclass) NOT NULL,
    idcad integer NOT NULL,
    idtip integer NOT NULL,
    codigo character varying(10) NOT NULL,
    idcli character varying(10) NOT NULL,
    nome character varying(40) NOT NULL,
    endereco character varying(60) NOT NULL,
    complemento character varying(30),
    bairro character varying(30) NOT NULL,
    cep character varying(8),
    telefone character varying(11) NOT NULL,
    fax character varying(11),
    email character varying(40),
    idpes integer NOT NULL,
    diretor character varying(40) NOT NULL
);


--
-- Name: unidade_faixa_etaria_idfeu_seq; Type: SEQUENCE; Schema: alimentos; Owner: -
--

CREATE SEQUENCE unidade_faixa_etaria_idfeu_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: unidade_faixa_etaria_idfeu_seq; Type: SEQUENCE SET; Schema: alimentos; Owner: -
--

SELECT pg_catalog.setval('unidade_faixa_etaria_idfeu_seq', 1, false);


--
-- Name: unidade_faixa_etaria; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE unidade_faixa_etaria (
    idfeu integer DEFAULT nextval('unidade_faixa_etaria_idfeu_seq'::regclass) NOT NULL,
    iduni integer NOT NULL,
    idfae integer NOT NULL,
    num_inscritos integer NOT NULL,
    num_matriculados integer NOT NULL
);


--
-- Name: unidade_produto; Type: TABLE; Schema: alimentos; Owner: -; Tablespace:
--

CREATE TABLE unidade_produto (
    idunp character varying(20) NOT NULL,
    idcli character varying(10) NOT NULL,
    descricao character varying(50) NOT NULL,
    peso numeric NOT NULL
);


SET search_path = cadastro, pg_catalog;

--
-- Name: aviso_nome; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE aviso_nome (
    idpes numeric(8,0) NOT NULL,
    aviso numeric(1,0) NOT NULL,
    CONSTRAINT ck_aviso_nome_aviso CHECK (((aviso >= (1)::numeric) AND (aviso <= (4)::numeric)))
);


--
-- Name: deficiencia_cod_deficiencia_seq; Type: SEQUENCE; Schema: cadastro; Owner: -
--

CREATE SEQUENCE deficiencia_cod_deficiencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: deficiencia_cod_deficiencia_seq; Type: SEQUENCE SET; Schema: cadastro; Owner: -
--

SELECT pg_catalog.setval('deficiencia_cod_deficiencia_seq', 1, false);


--
-- Name: deficiencia; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE deficiencia (
    cod_deficiencia integer DEFAULT nextval('deficiencia_cod_deficiencia_seq'::regclass) NOT NULL,
    nm_deficiencia character varying(70) NOT NULL
);


--
-- Name: documento; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE documento (
    idpes numeric(8,0) NOT NULL,
    rg numeric(20,0),
    data_exp_rg date,
    sigla_uf_exp_rg character(2),
    tipo_cert_civil numeric(2,0),
    num_termo numeric(8,0),
    num_livro character varying(8),
    num_folha numeric(4,0),
    data_emissao_cert_civil date,
    sigla_uf_cert_civil character(2),
    cartorio_cert_civil character varying(150),
    num_cart_trabalho numeric(9,0),
    serie_cart_trabalho numeric(5,0),
    data_emissao_cart_trabalho date,
    sigla_uf_cart_trabalho character(2),
    num_tit_eleitor numeric(13,0),
    zona_tit_eleitor numeric(4,0),
    secao_tit_eleitor numeric(4,0),
    idorg_exp_rg integer,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_documento_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_documento_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_documento_tipo_cert CHECK (((tipo_cert_civil >= (91)::numeric) AND (tipo_cert_civil <= (92)::numeric)))
);


--
-- Name: endereco_externo; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE endereco_externo (
    idpes numeric(8,0) NOT NULL,
    tipo numeric(1,0) NOT NULL,
    idtlog character varying(5) NOT NULL,
    logradouro character varying(150) NOT NULL,
    numero numeric(6,0),
    letra character(1),
    complemento character varying(20),
    bairro character varying(40),
    cep numeric(8,0),
    cidade character varying(60) NOT NULL,
    sigla_uf character(2) NOT NULL,
    reside_desde date,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    bloco character varying(20),
    andar numeric(2,0),
    apartamento numeric(6,0),
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    zona_localizacao integer DEFAULT 1,
    CONSTRAINT ck_endereco_externo_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_endereco_externo_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_endereco_externo_tipo CHECK (((tipo >= (1)::numeric) AND (tipo <= (3)::numeric)))
);


--
-- Name: endereco_pessoa; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE endereco_pessoa (
    idpes numeric(8,0) NOT NULL,
    tipo numeric(1,0) NOT NULL,
    cep numeric(8,0) NOT NULL,
    idlog numeric(6,0) NOT NULL,
    numero numeric(6,0),
    letra character(1),
    complemento character varying(20),
    reside_desde date,
    idbai numeric(6,0) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    bloco character varying(20),
    andar numeric(2,0),
    apartamento numeric(6,0),
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_endereco_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_endereco_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_endereco_pessoa_tipo CHECK (((tipo >= (1)::numeric) AND (tipo <= (3)::numeric)))
);


--
-- Name: escolaridade; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE escolaridade (
    idesco numeric(2,0) NOT NULL,
    descricao character varying(60) NOT NULL
);


--
-- Name: estado_civil; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE estado_civil (
    ideciv numeric(1,0) NOT NULL,
    descricao character varying(15) NOT NULL
);


--
-- Name: fisica; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fisica (
    idpes numeric(8,0) NOT NULL,
    data_nasc date,
    sexo character(1),
    idpes_mae numeric(8,0),
    idpes_pai numeric(8,0),
    idpes_responsavel numeric(8,0),
    idesco numeric(2,0),
    ideciv numeric(1,0),
    idpes_con numeric(8,0),
    data_uniao date,
    data_obito date,
    nacionalidade numeric(1,0),
    idpais_estrangeiro numeric(3,0),
    data_chegada_brasil date,
    idmun_nascimento numeric(6,0),
    ultima_empresa character varying(150),
    idocup numeric(6,0),
    nome_mae character varying(150),
    nome_pai character varying(150),
    nome_conjuge character varying(150),
    nome_responsavel character varying(150),
    justificativa_provisorio character varying(150),
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    ref_cod_sistema integer,
    cpf numeric(11,0),
    ref_cod_religiao integer,
    CONSTRAINT ck_fisica_nacionalidade CHECK (((nacionalidade >= (1)::numeric) AND (nacionalidade <= (3)::numeric))),
    CONSTRAINT ck_fisica_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_fisica_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_fisica_sexo CHECK (((sexo = 'M'::bpchar) OR (sexo = 'F'::bpchar)))
);


--
-- Name: fisica_cpf; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fisica_cpf (
    idpes numeric(8,0) NOT NULL,
    cpf numeric(11,0) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_fisica_cpf_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_fisica_cpf_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: fisica_deficiencia; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fisica_deficiencia (
    ref_idpes integer NOT NULL,
    ref_cod_deficiencia integer NOT NULL
);


--
-- Name: fisica_foto; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fisica_foto (
    idpes integer NOT NULL,
    caminho character varying(255)
);


--
-- Name: fisica_raca; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fisica_raca (
    ref_idpes integer NOT NULL,
    ref_cod_raca integer NOT NULL
);


--
-- Name: fisica_sangue; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fisica_sangue (
    idpes numeric(8,0) NOT NULL,
    grupo character(2) NOT NULL,
    rh smallint NOT NULL
);


--
-- Name: fone_pessoa; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE fone_pessoa (
    idpes numeric(8,0) NOT NULL,
    tipo numeric(1,0) NOT NULL,
    ddd numeric(3,0) NOT NULL,
    fone numeric(11,0) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_fone_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_fone_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_fone_pessoa_tipo CHECK (((tipo >= (1)::numeric) AND (tipo <= (4)::numeric)))
);


--
-- Name: funcionario; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE funcionario (
    matricula numeric(8,0) NOT NULL,
    idins integer NOT NULL,
    idset integer,
    idpes numeric(8,0) NOT NULL,
    situacao character(1) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_funcionario_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_funcionario_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_funcionario_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: historico_cartao; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE historico_cartao (
    idpes_cidadao numeric(8,0) NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    idpes_emitiu numeric(8,0) NOT NULL,
    tipo character(1) NOT NULL,
    CONSTRAINT ck_historico_cartao_tipo CHECK (((tipo = 'P'::bpchar) OR (tipo = 'D'::bpchar)))
);


--
-- Name: juridica; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE juridica (
    idpes numeric(8,0) NOT NULL,
    cnpj numeric(14,0) NOT NULL,
    insc_estadual numeric(20,0),
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    fantasia character varying(255),
    capital_social character varying(255),
    CONSTRAINT ck_juridica_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_juridica_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: ocupacao; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE ocupacao (
    idocup numeric(6,0) NOT NULL,
    descricao character varying(250) NOT NULL
);


--
-- Name: orgao_emissor_rg_idorg_rg_seq; Type: SEQUENCE; Schema: cadastro; Owner: -
--

CREATE SEQUENCE orgao_emissor_rg_idorg_rg_seq
    START WITH 30
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: orgao_emissor_rg_idorg_rg_seq; Type: SEQUENCE SET; Schema: cadastro; Owner: -
--

SELECT pg_catalog.setval('orgao_emissor_rg_idorg_rg_seq', 30, false);


--
-- Name: orgao_emissor_rg; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE orgao_emissor_rg (
    idorg_rg integer DEFAULT nextval('orgao_emissor_rg_idorg_rg_seq'::regclass) NOT NULL,
    sigla character varying(20) NOT NULL,
    descricao character varying(60) NOT NULL,
    situacao character(1) NOT NULL,
    CONSTRAINT ck_orgao_emissor_rg_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: pessoa; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE pessoa (
    idpes numeric(8,0) DEFAULT nextval(('cadastro.seq_pessoa'::text)::regclass) NOT NULL,
    nome character varying(150) NOT NULL,
    idpes_cad numeric(8,0),
    data_cad timestamp without time zone NOT NULL,
    url character varying(60),
    tipo character(1) NOT NULL,
    idpes_rev numeric(8,0),
    data_rev timestamp without time zone,
    email character varying(50),
    situacao character(1) NOT NULL,
    origem_gravacao character(1) NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_pessoa_situacao CHECK ((((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)) OR (situacao = 'P'::bpchar))),
    CONSTRAINT ck_pessoa_tipo CHECK (((tipo = 'F'::bpchar) OR (tipo = 'J'::bpchar)))
);


--
-- Name: pessoa_fonetico; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE pessoa_fonetico (
    idpes numeric(8,0) NOT NULL,
    fonema character varying(30) NOT NULL
);


--
-- Name: raca_cod_raca_seq; Type: SEQUENCE; Schema: cadastro; Owner: -
--

CREATE SEQUENCE raca_cod_raca_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: raca_cod_raca_seq; Type: SEQUENCE SET; Schema: cadastro; Owner: -
--

SELECT pg_catalog.setval('raca_cod_raca_seq', 1, false);


--
-- Name: raca; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE raca (
    cod_raca integer DEFAULT nextval('raca_cod_raca_seq'::regclass) NOT NULL,
    idpes_exc integer,
    idpes_cad integer NOT NULL,
    nm_raca character varying(50) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo boolean DEFAULT false
);


--
-- Name: religiao_cod_religiao_seq; Type: SEQUENCE; Schema: cadastro; Owner: -
--

CREATE SEQUENCE religiao_cod_religiao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: religiao_cod_religiao_seq; Type: SEQUENCE SET; Schema: cadastro; Owner: -
--

SELECT pg_catalog.setval('religiao_cod_religiao_seq', 1, false);


SET default_with_oids = false;

--
-- Name: religiao; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE religiao (
    cod_religiao integer DEFAULT nextval('religiao_cod_religiao_seq'::regclass) NOT NULL,
    idpes_exc integer,
    idpes_cad integer NOT NULL,
    nm_religiao character varying(50) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo boolean DEFAULT false
);


--
-- Name: seq_pessoa; Type: SEQUENCE; Schema: cadastro; Owner: -
--

CREATE SEQUENCE seq_pessoa
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: seq_pessoa; Type: SEQUENCE SET; Schema: cadastro; Owner: -
--

SELECT pg_catalog.setval('seq_pessoa', 1, true);


SET default_with_oids = true;

--
-- Name: socio; Type: TABLE; Schema: cadastro; Owner: -; Tablespace:
--

CREATE TABLE socio (
    idpes_juridica numeric(8,0) NOT NULL,
    idpes_fisica numeric(8,0) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_socio_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_socio_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


SET search_path = public, pg_catalog;

--
-- Name: bairro; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE bairro (
    idmun numeric(6,0) NOT NULL,
    geom character varying,
    idbai numeric(6,0) DEFAULT nextval(('public.seq_bairro'::text)::regclass) NOT NULL,
    nome character varying(80) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    zona_localizacao integer DEFAULT 1,
    CONSTRAINT ck_bairro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_bairro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: logradouro; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE logradouro (
    idlog numeric(6,0) DEFAULT nextval(('public.seq_logradouro'::text)::regclass) NOT NULL,
    idtlog character varying(5) NOT NULL,
    nome character varying(150) NOT NULL,
    idmun numeric(6,0) NOT NULL,
    geom character varying,
    ident_oficial character(1),
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_logradouro_ident_oficial CHECK (((ident_oficial = 'S'::bpchar) OR (ident_oficial = 'N'::bpchar))),
    CONSTRAINT ck_logradouro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_logradouro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: municipio; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE municipio (
    idmun numeric(6,0) DEFAULT nextval(('public.seq_municipio'::text)::regclass) NOT NULL,
    nome character varying(60) NOT NULL,
    sigla_uf character(2) NOT NULL,
    area_km2 numeric(6,0),
    idmreg numeric(2,0),
    idasmun numeric(2,0),
    cod_ibge numeric(6,0),
    geom character varying,
    tipo character(1) NOT NULL,
    idmun_pai numeric(6,0),
    idpes_rev numeric,
    idpes_cad numeric,
    data_rev timestamp without time zone,
    data_cad timestamp without time zone NOT NULL,
    origem_gravacao character(1) NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_municipio_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_municipio_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_municipio_tipo CHECK (((((tipo = 'D'::bpchar) OR (tipo = 'M'::bpchar)) OR (tipo = 'P'::bpchar)) OR (tipo = 'R'::bpchar)))
);


SET search_path = cadastro, pg_catalog;

--
-- Name: v_endereco; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_endereco AS
    SELECT e.idpes, e.cep, e.idlog, e.numero, e.letra, e.complemento, e.idbai, e.bloco, e.andar, e.apartamento, l.nome AS logradouro, l.idtlog, b.nome AS bairro, m.nome AS cidade, m.sigla_uf, b.zona_localizacao FROM endereco_pessoa e, public.logradouro l, public.bairro b, public.municipio m WHERE ((((e.idlog = l.idlog) AND (e.idbai = b.idbai)) AND (b.idmun = m.idmun)) AND (e.tipo = (1)::numeric)) UNION SELECT e.idpes, e.cep, NULL::"unknown" AS idlog, e.numero, e.letra, e.complemento, NULL::"unknown" AS idbai, e.bloco, e.andar, e.apartamento, e.logradouro, e.idtlog, e.bairro, e.cidade, e.sigla_uf, e.zona_localizacao FROM endereco_externo e WHERE (e.tipo = (1)::numeric);


--
-- Name: v_fone_pessoa; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_fone_pessoa AS
    SELECT DISTINCT t.idpes, (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (1)::numeric) AND (t.idpes = t1.idpes))) AS ddd_1, (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (1)::numeric) AND (t.idpes = t1.idpes))) AS fone_1, (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (2)::numeric) AND (t.idpes = t1.idpes))) AS ddd_2, (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (2)::numeric) AND (t.idpes = t1.idpes))) AS fone_2, (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (3)::numeric) AND (t.idpes = t1.idpes))) AS ddd_mov, (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (3)::numeric) AND (t.idpes = t1.idpes))) AS fone_mov, (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (4)::numeric) AND (t.idpes = t1.idpes))) AS ddd_fax, (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (4)::numeric) AND (t.idpes = t1.idpes))) AS fone_fax FROM fone_pessoa t ORDER BY t.idpes, (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (1)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (1)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (2)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (2)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (3)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (3)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.ddd FROM fone_pessoa t1 WHERE ((t1.tipo = (4)::numeric) AND (t.idpes = t1.idpes))), (SELECT t1.fone FROM fone_pessoa t1 WHERE ((t1.tipo = (4)::numeric) AND (t.idpes = t1.idpes)));


--
-- Name: v_pessoa_fisica; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_pessoa_fisica AS
    SELECT p.idpes, p.nome, p.url, p.email, p.situacao, f.data_nasc, f.sexo, f.cpf, f.ref_cod_sistema, f.idesco FROM pessoa p, fisica f WHERE (p.idpes = f.idpes);


--
-- Name: v_pessoa_fisica_simples; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_pessoa_fisica_simples AS
    SELECT p.idpes, (SELECT fisica_cpf.cpf FROM fisica_cpf WHERE (fisica_cpf.idpes = p.idpes)) AS cpf, f.ref_cod_sistema, f.idesco FROM pessoa p, fisica f WHERE (p.idpes = f.idpes);


--
-- Name: v_pessoa_fj; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_pessoa_fj AS
    SELECT p.idpes, p.nome, (SELECT fisica.ref_cod_sistema FROM fisica WHERE (fisica.idpes = p.idpes)) AS ref_cod_sistema, (SELECT juridica.fantasia FROM juridica WHERE (juridica.idpes = p.idpes)) AS fantasia, p.tipo, COALESCE((SELECT fisica.cpf FROM fisica WHERE (fisica.idpes = p.idpes)), (SELECT juridica.cnpj FROM juridica WHERE (juridica.idpes = p.idpes))) AS id_federal FROM pessoa p;


--
-- Name: v_pessoa_juridica; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_pessoa_juridica AS
    SELECT j.idpes, j.fantasia, j.cnpj, j.insc_estadual, j.capital_social, (SELECT pessoa.nome FROM pessoa WHERE (pessoa.idpes = j.idpes)) AS nome FROM juridica j;


--
-- Name: v_pessoafj_count; Type: VIEW; Schema: cadastro; Owner: -
--

CREATE VIEW v_pessoafj_count AS
    SELECT fisica.ref_cod_sistema, fisica.cpf AS id_federal FROM fisica UNION ALL SELECT NULL::"unknown" AS ref_cod_sistema, juridica.cnpj AS id_federal FROM juridica;


SET search_path = consistenciacao, pg_catalog;

--
-- Name: campo_consistenciacao; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE campo_consistenciacao (
    idcam numeric(3,0) NOT NULL,
    campo character varying(50) NOT NULL,
    permite_regra_cadastrada character(1) NOT NULL,
    tamanho_maximo numeric(4,0),
    CONSTRAINT ck_campo_consistenciacao_permite_regra CHECK (((permite_regra_cadastrada = 'S'::bpchar) OR (permite_regra_cadastrada = 'N'::bpchar)))
);


--
-- Name: campo_metadado_id_campo_met_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE campo_metadado_id_campo_met_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: campo_metadado_id_campo_met_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('campo_metadado_id_campo_met_seq', 1, false);


--
-- Name: campo_metadado; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE campo_metadado (
    id_campo_met integer DEFAULT nextval('campo_metadado_id_campo_met_seq'::regclass) NOT NULL,
    idmet integer NOT NULL,
    idreg integer,
    idcam numeric(3,0),
    posicao_inicial numeric(5,0),
    posicao_final numeric(5,0),
    posicao_coluna numeric(5,0),
    credibilidade numeric(1,0) NOT NULL,
    data_atualizacao character(1) NOT NULL,
    CONSTRAINT ck_cam_met_campo_cred CHECK (((credibilidade >= (2)::numeric) AND (credibilidade <= (4)::numeric))),
    CONSTRAINT ck_cam_met_data_atualizacao CHECK (((data_atualizacao = 'S'::bpchar) OR (data_atualizacao = 'N'::bpchar)))
);


--
-- Name: confrontacao_idcon_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE confrontacao_idcon_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: confrontacao_idcon_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('confrontacao_idcon_seq', 1, false);


--
-- Name: confrontacao; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE confrontacao (
    idcon integer DEFAULT nextval('confrontacao_idcon_seq'::regclass) NOT NULL,
    idins integer NOT NULL,
    idpes integer NOT NULL,
    idmet integer NOT NULL,
    arquivo_fonte_dados character varying(250) NOT NULL,
    ignorar_reg_fonte date,
    desconsiderar_reg_cred_maxima date,
    data_hora timestamp without time zone NOT NULL
);


--
-- Name: fonte_idfon_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE fonte_idfon_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: fonte_idfon_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('fonte_idfon_seq', 1, false);


--
-- Name: fonte; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE fonte (
    idfon integer DEFAULT nextval('fonte_idfon_seq'::regclass) NOT NULL,
    nome character varying(60) NOT NULL,
    situacao character(1) NOT NULL,
    CONSTRAINT ck_fonte_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: historico_campo; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE historico_campo (
    idpes numeric(8,0) NOT NULL,
    idcam numeric(3,0) NOT NULL,
    credibilidade numeric(1,0) NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    CONSTRAINT ck_historico_campo_cred CHECK (((credibilidade >= (1)::numeric) AND (credibilidade <= (5)::numeric)))
);


--
-- Name: incoerencia_idinc_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE incoerencia_idinc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: incoerencia_idinc_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('incoerencia_idinc_seq', 1, false);


--
-- Name: incoerencia; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE incoerencia (
    idinc integer DEFAULT nextval('incoerencia_idinc_seq'::regclass) NOT NULL,
    idcon integer NOT NULL,
    data_gravacao date NOT NULL,
    ultima_etapa numeric(1,0) NOT NULL,
    cpf_cnpj numeric(14,0),
    nome character varying(150),
    email character varying(100),
    url character varying(60),
    data_nasc character varying(20),
    fantasia character varying(50),
    insc_estadual numeric(10,0),
    sexo character varying(10),
    nome_mae character varying(150),
    nome_pai character varying(150),
    nome_responsavel character varying(150),
    nome_conjuge character varying(150),
    ultima_empresa character varying(150),
    ocupacao character varying(250),
    escolaridade character varying(60),
    estado_civil character varying(15),
    pais_estrangeiro character varying(60),
    data_chegada_brasil character varying(20),
    data_obito character varying(20),
    data_uniao character varying(20)
);


--
-- Name: incoerencia_documento_id_inc_doc_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE incoerencia_documento_id_inc_doc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: incoerencia_documento_id_inc_doc_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('incoerencia_documento_id_inc_doc_seq', 1, false);


--
-- Name: incoerencia_documento; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE incoerencia_documento (
    id_inc_doc integer DEFAULT nextval('incoerencia_documento_id_inc_doc_seq'::regclass) NOT NULL,
    idinc integer NOT NULL,
    rg numeric(10,0),
    orgao_exp_rg character varying(20),
    data_exp_rg character varying(20),
    sigla_uf_rg_exp character varying(30),
    tipo_cert_civil numeric(2,0),
    num_termo numeric(8,0),
    num_livro numeric(8,0),
    num_folha numeric(4,0),
    data_emissao_cert_civil character varying(20),
    cartorio_cert_civil character varying(150),
    sigla_uf_cert_civil character varying(30),
    num_cart_trabalho numeric(7,0),
    serie_cart_trabalho numeric(5,0),
    data_emissao_cart_trabalho character varying(20),
    sigla_uf_cart_trabalho character varying(30),
    num_tit_eleitor numeric(13,0),
    zona_tit_eleitor numeric(4,0),
    secao_tit_eleitor numeric(4,0)
);


--
-- Name: incoerencia_endereco_id_inc_end_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE incoerencia_endereco_id_inc_end_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: incoerencia_endereco_id_inc_end_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('incoerencia_endereco_id_inc_end_seq', 1, false);


--
-- Name: incoerencia_endereco; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE incoerencia_endereco (
    id_inc_end integer DEFAULT nextval('incoerencia_endereco_id_inc_end_seq'::regclass) NOT NULL,
    idinc integer NOT NULL,
    tipo character varying(60) NOT NULL,
    tipo_logradouro character varying(15),
    logradouro character varying(150),
    numero numeric(6,0),
    letra character(1),
    complemento character varying(20),
    bairro character varying(40),
    cep numeric(8,0),
    cidade character varying(60),
    uf character varying(30),
    CONSTRAINT ck_incoerencia_endereco_tipo CHECK ((((tipo)::text >= ((1)::numeric)::text) AND ((tipo)::text <= ((3)::numeric)::text)))
);


--
-- Name: incoerencia_fone_id_inc_fone_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE incoerencia_fone_id_inc_fone_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: incoerencia_fone_id_inc_fone_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('incoerencia_fone_id_inc_fone_seq', 1, false);


--
-- Name: incoerencia_fone; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE incoerencia_fone (
    id_inc_fone integer DEFAULT nextval('incoerencia_fone_id_inc_fone_seq'::regclass) NOT NULL,
    idinc integer NOT NULL,
    tipo character varying(60) NOT NULL,
    ddd numeric(3,0),
    fone numeric(8,0),
    CONSTRAINT ck_incoerencia_fone_tipo CHECK ((((tipo)::text >= ((1)::numeric)::text) AND ((tipo)::text <= ((4)::numeric)::text)))
);


--
-- Name: incoerencia_pessoa_possivel; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE incoerencia_pessoa_possivel (
    idinc integer NOT NULL,
    idpes numeric(8,0) NOT NULL
);


--
-- Name: incoerencia_tipo_incoerencia; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE incoerencia_tipo_incoerencia (
    id_tipo_inc numeric(3,0) NOT NULL,
    idinc integer NOT NULL
);


--
-- Name: metadado_idmet_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE metadado_idmet_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: metadado_idmet_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('metadado_idmet_seq', 1, false);


--
-- Name: metadado; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE metadado (
    idmet integer DEFAULT nextval('metadado_idmet_seq'::regclass) NOT NULL,
    idfon integer NOT NULL,
    nome character varying(60) NOT NULL,
    situacao character(1) NOT NULL,
    separador character(1),
    CONSTRAINT ck_metadado_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: ocorrencia_regra_campo; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE ocorrencia_regra_campo (
    idreg integer NOT NULL,
    conteudo_padrao character varying(60) NOT NULL,
    ocorrencias text NOT NULL
);


--
-- Name: regra_campo_idreg_seq; Type: SEQUENCE; Schema: consistenciacao; Owner: -
--

CREATE SEQUENCE regra_campo_idreg_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: regra_campo_idreg_seq; Type: SEQUENCE SET; Schema: consistenciacao; Owner: -
--

SELECT pg_catalog.setval('regra_campo_idreg_seq', 1, false);


--
-- Name: regra_campo; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE regra_campo (
    idreg integer DEFAULT nextval('regra_campo_idreg_seq'::regclass) NOT NULL,
    nome character varying(60) NOT NULL,
    tipo character(1) NOT NULL,
    CONSTRAINT ck_regra_campo_tipo CHECK (((tipo = 'S'::bpchar) OR (tipo = 'N'::bpchar)))
);


--
-- Name: temp_cadastro_unificacao_cmf; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE temp_cadastro_unificacao_cmf (
    idpes numeric(8,0) NOT NULL,
    nome character varying(150) NOT NULL,
    cpf_cnpj character varying(14),
    rg character varying(10),
    uf_rg character varying(50),
    data_nascimento character varying(10),
    logradouro character varying(150),
    cep character varying(10),
    bairro character varying(40),
    numero character varying(6),
    cidade_end character varying(60),
    uf_end character varying(2),
    complemento character varying(20),
    fone character varying(14),
    nome_mae character varying(150),
    nome_mae_idpes character varying(150),
    data_cadastro character varying(10),
    data_atualizacao character varying(10),
    situacao character varying(15),
    tipo_pess character varying(1),
    nome_fantasia character varying(50),
    inscr_estadual character varying(10)
);


--
-- Name: temp_cadastro_unificacao_siam; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE temp_cadastro_unificacao_siam (
    idpes numeric(8,0) NOT NULL,
    nome character varying(40) NOT NULL,
    cpf_cnpj character varying(14),
    rg character varying(15),
    logradouro character varying(40),
    cep character varying(10),
    bairro character varying(20),
    cidade_end character varying(20),
    uf_end character varying(2),
    fone character varying(14),
    data_cadastro character varying(10)
);


--
-- Name: tipo_incoerencia; Type: TABLE; Schema: consistenciacao; Owner: -; Tablespace:
--

CREATE TABLE tipo_incoerencia (
    id_tipo_inc numeric(3,0) NOT NULL,
    idcam numeric(3,0) NOT NULL,
    descricao character varying(250) NOT NULL
);


SET search_path = historico, pg_catalog;

--
-- Name: bairro; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE bairro (
    idbai numeric(6,0) NOT NULL,
    idmun numeric(6,0) NOT NULL,
    nome character varying(80) NOT NULL,
    geom character varying,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_bairro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_bairro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: cep_logradouro; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE cep_logradouro (
    cep numeric(8,0) NOT NULL,
    idlog numeric(6,0) NOT NULL,
    nroini numeric(6,0),
    nrofin numeric(6,0),
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_cep_logradouro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_cep_logradouro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: cep_logradouro_bairro; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE cep_logradouro_bairro (
    idbai numeric(6,0) NOT NULL,
    idlog numeric(6,0) NOT NULL,
    cep numeric(8,0) NOT NULL,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_cep_logradouro_bairro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_cep_logradouro_bairro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: documento; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE documento (
    idpes numeric(8,0) NOT NULL,
    rg numeric(20,0),
    data_exp_rg date,
    sigla_uf_exp_rg character(2),
    tipo_cert_civil numeric(2,0),
    num_termo numeric(8,0),
    num_livro character varying(8),
    num_folha numeric(4,0),
    data_emissao_cert_civil date,
    sigla_uf_cert_civil character(2),
    cartorio_cert_civil character varying(150),
    num_cart_trabalho numeric(7,0),
    serie_cart_trabalho numeric(5,0),
    data_emissao_cart_trabalho date,
    sigla_uf_cart_trabalho character(2),
    num_tit_eleitor numeric(13,0),
    zona_tit_eleitor numeric(4,0),
    secao_tit_eleitor numeric(4,0),
    idorg_exp_rg integer,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_documento_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_documento_tipo_cert CHECK (((tipo_cert_civil >= (91)::numeric) AND (tipo_cert_civil <= (92)::numeric))),
    CONSTRAINT ck_fone_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: endereco_externo; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE endereco_externo (
    idpes numeric(8,0) NOT NULL,
    tipo numeric(1,0) NOT NULL,
    idtlog character varying(5) NOT NULL,
    logradouro character varying(150) NOT NULL,
    numero numeric(6,0),
    letra character(1),
    complemento character varying(20),
    bairro character varying(40),
    cep numeric(8,0),
    cidade character varying(60) NOT NULL,
    sigla_uf character(2) NOT NULL,
    reside_desde date,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_endereco_externo_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_endereco_externo_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_endereco_externo_tipo CHECK (((tipo >= (1)::numeric) AND (tipo <= (3)::numeric)))
);


--
-- Name: endereco_pessoa; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE endereco_pessoa (
    idpes numeric(8,0) NOT NULL,
    tipo numeric(1,0) NOT NULL,
    cep numeric(8,0) NOT NULL,
    idlog numeric(6,0) NOT NULL,
    idbai numeric(6,0) NOT NULL,
    numero numeric(6,0),
    letra character(1),
    complemento character varying(20),
    reside_desde date,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_endereco_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_endereco_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_endereco_pessoa_tipo CHECK (((tipo >= (1)::numeric) AND (tipo <= (3)::numeric)))
);


--
-- Name: fisica; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE fisica (
    idpes numeric(8,0) NOT NULL,
    data_nasc date,
    sexo character(1),
    idpes_mae numeric(8,0),
    idpes_pai numeric(8,0),
    idpes_responsavel numeric(8,0),
    idesco numeric(2,0),
    ideciv numeric(1,0),
    idpes_con numeric(8,0),
    data_uniao date,
    data_obito date,
    nacionalidade numeric(1,0),
    idpais_estrangeiro numeric(3,0),
    data_chegada_brasil date,
    idmun_nascimento numeric(6,0),
    ultima_empresa character varying(150),
    idocup numeric(6,0),
    nome_mae character varying(150),
    nome_pai character varying(150),
    nome_conjuge character varying(150),
    nome_responsavel character varying(150),
    justificativa_provisorio character varying(150),
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_fisica_nacionalidade CHECK (((nacionalidade >= (1)::numeric) AND (nacionalidade <= (3)::numeric))),
    CONSTRAINT ck_fisica_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_fisica_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_fisica_sexo CHECK (((sexo = 'M'::bpchar) OR (sexo = 'F'::bpchar)))
);


--
-- Name: fisica_cpf; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE fisica_cpf (
    idpes numeric(8,0) NOT NULL,
    cpf numeric(11,0) NOT NULL,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_fisica_cpf_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_fone_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar)))
);


--
-- Name: fone_pessoa; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE fone_pessoa (
    idpes numeric(8,0) NOT NULL,
    tipo numeric(1,0) NOT NULL,
    ddd numeric(3,0) NOT NULL,
    fone numeric(11,0) NOT NULL,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_fone_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_fone_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_fone_pessoa_tipo CHECK (((tipo >= (1)::numeric) AND (tipo <= (4)::numeric)))
);


--
-- Name: funcionario; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE funcionario (
    matricula numeric(8,0) NOT NULL,
    idins integer NOT NULL,
    idset integer,
    idpes numeric(8,0) NOT NULL,
    situacao character(1) NOT NULL,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_fone_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_funcionario_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_funcionario_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: juridica; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE juridica (
    idpes numeric(8,0) NOT NULL,
    cnpj numeric(14,0) NOT NULL,
    insc_estadual numeric(20,0),
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    fantasia character varying(255),
    CONSTRAINT ck_juridica_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_juridica_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: logradouro; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE logradouro (
    idlog numeric(6,0) NOT NULL,
    idtlog character varying(5) NOT NULL,
    nome character varying(150) NOT NULL,
    idmun numeric(6,0) NOT NULL,
    geom character varying,
    ident_oficial character(1) NOT NULL,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_logradouro_ident_oficial CHECK (((ident_oficial = 'S'::bpchar) OR (ident_oficial = 'N'::bpchar))),
    CONSTRAINT ck_logradouro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_logradouro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


--
-- Name: municipio; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE municipio (
    idmun numeric(6,0) NOT NULL,
    nome character varying(60) NOT NULL,
    sigla_uf character(2) NOT NULL,
    area_km2 numeric(6,0),
    idmreg numeric(2,0),
    idasmun numeric(2,0),
    cod_ibge numeric(6,0),
    geom character varying,
    tipo character(1) NOT NULL,
    idmun_pai numeric(6,0),
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_municipio_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_municipio_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_municipio_tipo CHECK (((((tipo = 'D'::bpchar) OR (tipo = 'M'::bpchar)) OR (tipo = 'P'::bpchar)) OR (tipo = 'R'::bpchar)))
);


--
-- Name: pessoa; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE pessoa (
    idpes numeric(8,0) NOT NULL,
    nome character varying(150) NOT NULL,
    idpes_cad numeric(8,0),
    data_cad timestamp without time zone NOT NULL,
    url character varying(60),
    tipo character(1) NOT NULL,
    idpes_rev numeric(8,0),
    data_rev timestamp without time zone,
    email character varying(50),
    situacao character(1) NOT NULL,
    origem_gravacao character(1) NOT NULL,
    idsis_rev numeric,
    idsis_cad numeric NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_pessoa_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_pessoa_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_pessoa_situacao CHECK ((((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)) OR (situacao = 'P'::bpchar))),
    CONSTRAINT ck_pessoa_tipo CHECK (((tipo = 'F'::bpchar) OR (tipo = 'J'::bpchar)))
);


--
-- Name: socio; Type: TABLE; Schema: historico; Owner: -; Tablespace:
--

CREATE TABLE socio (
    idpes_juridica numeric(8,0) NOT NULL,
    idpes_fisica numeric(8,0) NOT NULL,
    idpes_rev numeric,
    idsis_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    idsis_cad numeric NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    CONSTRAINT ck_socio_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar))),
    CONSTRAINT ck_socio_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar)))
);


SET search_path = modules, pg_catalog;

SET default_with_oids = false;

--
-- Name: area_conhecimento; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE area_conhecimento (
    id integer NOT NULL,
    instituicao_id integer NOT NULL,
    nome character varying(40) NOT NULL
);


--
-- Name: area_conhecimento_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE area_conhecimento_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: area_conhecimento_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE area_conhecimento_id_seq OWNED BY area_conhecimento.id;


--
-- Name: area_conhecimento_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('area_conhecimento_id_seq', 1, false);


--
-- Name: calendario_turma; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE calendario_turma (
    calendario_ano_letivo_id integer NOT NULL,
    ano integer NOT NULL,
    mes integer NOT NULL,
    dia integer NOT NULL,
    turma_id integer NOT NULL
);


--
-- Name: componente_curricular; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE componente_curricular (
    id integer NOT NULL,
    instituicao_id integer NOT NULL,
    area_conhecimento_id integer NOT NULL,
    nome character varying(100) NOT NULL,
    abreviatura character varying(15) NOT NULL,
    tipo_base smallint NOT NULL
);


--
-- Name: componente_curricular_ano_escolar; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE componente_curricular_ano_escolar (
    componente_curricular_id integer NOT NULL,
    ano_escolar_id integer NOT NULL,
    carga_horaria numeric(6,3)
);


--
-- Name: componente_curricular_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE componente_curricular_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: componente_curricular_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE componente_curricular_id_seq OWNED BY componente_curricular.id;


--
-- Name: componente_curricular_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('componente_curricular_id_seq', 1, false);


--
-- Name: componente_curricular_turma; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE componente_curricular_turma (
    componente_curricular_id integer NOT NULL,
    ano_escolar_id integer NOT NULL,
    escola_id integer NOT NULL,
    turma_id integer NOT NULL,
    carga_horaria numeric(6,3)
);


--
-- Name: docente_licenciatura; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE docente_licenciatura (
    id integer NOT NULL,
    servidor_id integer NOT NULL,
    licenciatura integer NOT NULL,
    curso_id integer,
    ano_conclusao integer NOT NULL,
    ies_id integer,
    user_id integer NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone
);


--
-- Name: docente_licenciatura_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE docente_licenciatura_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: docente_licenciatura_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE docente_licenciatura_id_seq OWNED BY docente_licenciatura.id;


--
-- Name: docente_licenciatura_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('docente_licenciatura_id_seq', 1, false);


--
-- Name: educacenso_cod_aluno; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE educacenso_cod_aluno (
    cod_aluno integer NOT NULL,
    cod_aluno_inep bigint NOT NULL,
    nome_inep character varying(255),
    fonte character varying(255),
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone
);


--
-- Name: educacenso_cod_docente; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE educacenso_cod_docente (
    cod_servidor integer NOT NULL,
    cod_docente_inep bigint NOT NULL,
    nome_inep character varying(255),
    fonte character varying(255),
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone
);


--
-- Name: educacenso_curso_superior; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE educacenso_curso_superior (
    id integer NOT NULL,
    curso_id character varying(100) NOT NULL,
    nome character varying(255) NOT NULL,
    classe_id integer NOT NULL,
    user_id integer NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone
);


--
-- Name: educacenso_curso_superior_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE educacenso_curso_superior_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: educacenso_curso_superior_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE educacenso_curso_superior_id_seq OWNED BY educacenso_curso_superior.id;


--
-- Name: educacenso_curso_superior_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('educacenso_curso_superior_id_seq', 124, true);


--
-- Name: educacenso_ies; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE educacenso_ies (
    id integer NOT NULL,
    ies_id integer NOT NULL,
    nome character varying(255) NOT NULL,
    dependencia_administrativa_id integer NOT NULL,
    tipo_instituicao_id integer NOT NULL,
    uf character(2),
    user_id integer NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone
);


--
-- Name: educacenso_ies_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE educacenso_ies_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: educacenso_ies_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE educacenso_ies_id_seq OWNED BY educacenso_ies.id;


--
-- Name: educacenso_ies_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('educacenso_ies_id_seq', 5301, true);


--
-- Name: falta_aluno; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE falta_aluno (
    id integer NOT NULL,
    matricula_id integer NOT NULL,
    tipo_falta smallint NOT NULL
);


--
-- Name: falta_aluno_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE falta_aluno_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: falta_aluno_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE falta_aluno_id_seq OWNED BY falta_aluno.id;


--
-- Name: falta_aluno_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('falta_aluno_id_seq', 1, false);


--
-- Name: falta_componente_curricular; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE falta_componente_curricular (
    id integer NOT NULL,
    falta_aluno_id integer NOT NULL,
    componente_curricular_id integer NOT NULL,
    quantidade integer DEFAULT 0,
    etapa character varying(2) NOT NULL
);


--
-- Name: falta_componente_curricular_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE falta_componente_curricular_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: falta_componente_curricular_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE falta_componente_curricular_id_seq OWNED BY falta_componente_curricular.id;


--
-- Name: falta_componente_curricular_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('falta_componente_curricular_id_seq', 1, false);


--
-- Name: falta_geral; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE falta_geral (
    id integer NOT NULL,
    falta_aluno_id integer NOT NULL,
    quantidade integer DEFAULT 0,
    etapa character varying(2) NOT NULL
);


--
-- Name: falta_geral_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE falta_geral_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: falta_geral_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE falta_geral_id_seq OWNED BY falta_geral.id;


--
-- Name: falta_geral_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('falta_geral_id_seq', 1, false);


--
-- Name: formula_media; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE formula_media (
    id integer NOT NULL,
    instituicao_id integer NOT NULL,
    nome character varying(50) NOT NULL,
    formula_media character varying(50) NOT NULL,
    tipo_formula smallint DEFAULT 1
);


--
-- Name: formula_media_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE formula_media_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: formula_media_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE formula_media_id_seq OWNED BY formula_media.id;


--
-- Name: formula_media_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('formula_media_id_seq', 1, false);


--
-- Name: nota_aluno; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE nota_aluno (
    id integer NOT NULL,
    matricula_id integer NOT NULL
);


--
-- Name: nota_aluno_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE nota_aluno_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: nota_aluno_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE nota_aluno_id_seq OWNED BY nota_aluno.id;


--
-- Name: nota_aluno_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('nota_aluno_id_seq', 1, false);


--
-- Name: nota_componente_curricular; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE nota_componente_curricular (
    id integer NOT NULL,
    nota_aluno_id integer NOT NULL,
    componente_curricular_id integer NOT NULL,
    nota numeric(5,3) DEFAULT 0,
    nota_arredondada character varying(5) DEFAULT 0,
    etapa character varying(2) NOT NULL
);


--
-- Name: nota_componente_curricular_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE nota_componente_curricular_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: nota_componente_curricular_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE nota_componente_curricular_id_seq OWNED BY nota_componente_curricular.id;


--
-- Name: nota_componente_curricular_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('nota_componente_curricular_id_seq', 1, false);


--
-- Name: nota_componente_curricular_media; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE nota_componente_curricular_media (
    nota_aluno_id integer NOT NULL,
    componente_curricular_id integer NOT NULL,
    media numeric(5,3) DEFAULT 0,
    media_arredondada character varying(5) DEFAULT 0,
    etapa character varying(2) NOT NULL
);


--
-- Name: parecer_aluno; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE parecer_aluno (
    id integer NOT NULL,
    matricula_id integer NOT NULL,
    parecer_descritivo smallint NOT NULL
);


--
-- Name: parecer_aluno_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE parecer_aluno_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: parecer_aluno_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE parecer_aluno_id_seq OWNED BY parecer_aluno.id;


--
-- Name: parecer_aluno_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('parecer_aluno_id_seq', 1, false);


--
-- Name: parecer_componente_curricular; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE parecer_componente_curricular (
    id integer NOT NULL,
    parecer_aluno_id integer NOT NULL,
    componente_curricular_id integer NOT NULL,
    parecer text,
    etapa character varying(2) NOT NULL
);


--
-- Name: parecer_componente_curricular_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE parecer_componente_curricular_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: parecer_componente_curricular_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE parecer_componente_curricular_id_seq OWNED BY parecer_componente_curricular.id;


--
-- Name: parecer_componente_curricular_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('parecer_componente_curricular_id_seq', 1, false);


--
-- Name: parecer_geral; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE parecer_geral (
    id integer NOT NULL,
    parecer_aluno_id integer NOT NULL,
    parecer text,
    etapa character varying(2) NOT NULL
);


--
-- Name: parecer_geral_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE parecer_geral_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: parecer_geral_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE parecer_geral_id_seq OWNED BY parecer_geral.id;


--
-- Name: parecer_geral_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('parecer_geral_id_seq', 1, false);


--
-- Name: regra_avaliacao; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE regra_avaliacao (
    id integer NOT NULL,
    instituicao_id integer NOT NULL,
    formula_media_id integer,
    formula_recuperacao_id integer DEFAULT 0,
    tabela_arredondamento_id integer,
    nome character varying(50) NOT NULL,
    tipo_nota smallint NOT NULL,
    tipo_progressao smallint NOT NULL,
    media numeric(5,3) DEFAULT 0.000,
    porcentagem_presenca numeric(6,3) DEFAULT 0.000,
    parecer_descritivo smallint DEFAULT 0,
    tipo_presenca smallint NOT NULL
);


--
-- Name: regra_avaliacao_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE regra_avaliacao_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: regra_avaliacao_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE regra_avaliacao_id_seq OWNED BY regra_avaliacao.id;


--
-- Name: regra_avaliacao_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('regra_avaliacao_id_seq', 1, false);


--
-- Name: tabela_arredondamento; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE tabela_arredondamento (
    id integer NOT NULL,
    instituicao_id integer NOT NULL,
    nome character varying(50) NOT NULL,
    tipo_nota smallint DEFAULT 1 NOT NULL
);


--
-- Name: tabela_arredondamento_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE tabela_arredondamento_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: tabela_arredondamento_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE tabela_arredondamento_id_seq OWNED BY tabela_arredondamento.id;


--
-- Name: tabela_arredondamento_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('tabela_arredondamento_id_seq', 1, false);


--
-- Name: tabela_arredondamento_valor; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE tabela_arredondamento_valor (
    id integer NOT NULL,
    tabela_arredondamento_id integer NOT NULL,
    nome character varying(5) NOT NULL,
    descricao character varying(25),
    valor_minimo numeric(5,3) NOT NULL,
    valor_maximo numeric(5,3) NOT NULL
);


--
-- Name: tabela_arredondamento_valor_id_seq; Type: SEQUENCE; Schema: modules; Owner: -
--

CREATE SEQUENCE tabela_arredondamento_valor_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: tabela_arredondamento_valor_id_seq; Type: SEQUENCE OWNED BY; Schema: modules; Owner: -
--

ALTER SEQUENCE tabela_arredondamento_valor_id_seq OWNED BY tabela_arredondamento_valor.id;


--
-- Name: tabela_arredondamento_valor_id_seq; Type: SEQUENCE SET; Schema: modules; Owner: -
--

SELECT pg_catalog.setval('tabela_arredondamento_valor_id_seq', 1, false);


--
-- Name: transporte_aluno; Type: TABLE; Schema: modules; Owner: -; Tablespace:
--

CREATE TABLE transporte_aluno (
    aluno_id integer NOT NULL,
    responsavel integer NOT NULL,
    user_id integer NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone
);


SET search_path = pmiacoes, pg_catalog;

--
-- Name: acao_governo_cod_acao_governo_seq; Type: SEQUENCE; Schema: pmiacoes; Owner: -
--

CREATE SEQUENCE acao_governo_cod_acao_governo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acao_governo_cod_acao_governo_seq; Type: SEQUENCE SET; Schema: pmiacoes; Owner: -
--

SELECT pg_catalog.setval('acao_governo_cod_acao_governo_seq', 1, false);


SET default_with_oids = true;

--
-- Name: acao_governo; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo (
    cod_acao_governo integer DEFAULT nextval('acao_governo_cod_acao_governo_seq'::regclass) NOT NULL,
    ref_funcionario_exc integer,
    ref_funcionario_cad integer NOT NULL,
    nm_acao character varying(255) NOT NULL,
    descricao text,
    data_inauguracao timestamp without time zone,
    valor double precision,
    destaque smallint DEFAULT (0)::smallint NOT NULL,
    status_acao smallint DEFAULT (0)::smallint NOT NULL,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    numero_acao smallint DEFAULT 0,
    categoria smallint,
    idbai bigint
);


--
-- Name: acao_governo_arquivo_cod_acao_governo_arquivo_seq; Type: SEQUENCE; Schema: pmiacoes; Owner: -
--

CREATE SEQUENCE acao_governo_arquivo_cod_acao_governo_arquivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acao_governo_arquivo_cod_acao_governo_arquivo_seq; Type: SEQUENCE SET; Schema: pmiacoes; Owner: -
--

SELECT pg_catalog.setval('acao_governo_arquivo_cod_acao_governo_arquivo_seq', 1, false);


--
-- Name: acao_governo_arquivo; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo_arquivo (
    cod_acao_governo_arquivo integer DEFAULT nextval('acao_governo_arquivo_cod_acao_governo_arquivo_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_cod_acao_governo integer NOT NULL,
    nm_arquivo character varying(255) NOT NULL,
    caminho_arquivo character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: acao_governo_categoria; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo_categoria (
    ref_cod_categoria integer NOT NULL,
    ref_cod_acao_governo integer NOT NULL
);


--
-- Name: acao_governo_foto_cod_acao_governo_foto_seq; Type: SEQUENCE; Schema: pmiacoes; Owner: -
--

CREATE SEQUENCE acao_governo_foto_cod_acao_governo_foto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acao_governo_foto_cod_acao_governo_foto_seq; Type: SEQUENCE SET; Schema: pmiacoes; Owner: -
--

SELECT pg_catalog.setval('acao_governo_foto_cod_acao_governo_foto_seq', 1, false);


--
-- Name: acao_governo_foto; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo_foto (
    cod_acao_governo_foto integer DEFAULT nextval('acao_governo_foto_cod_acao_governo_foto_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_cod_acao_governo integer NOT NULL,
    nm_foto character varying(255) NOT NULL,
    caminho character varying(255) NOT NULL,
    data_foto timestamp without time zone,
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: acao_governo_foto_portal; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo_foto_portal (
    ref_cod_acao_governo integer NOT NULL,
    ref_cod_foto_portal integer NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: acao_governo_noticia; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo_noticia (
    ref_cod_acao_governo integer NOT NULL,
    ref_cod_not_portal integer NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: acao_governo_setor; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE acao_governo_setor (
    ref_cod_acao_governo integer NOT NULL,
    ref_cod_setor integer NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: categoria_cod_categoria_seq; Type: SEQUENCE; Schema: pmiacoes; Owner: -
--

CREATE SEQUENCE categoria_cod_categoria_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: categoria_cod_categoria_seq; Type: SEQUENCE SET; Schema: pmiacoes; Owner: -
--

SELECT pg_catalog.setval('categoria_cod_categoria_seq', 1, false);


--
-- Name: categoria; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE categoria (
    cod_categoria integer DEFAULT nextval('categoria_cod_categoria_seq'::regclass) NOT NULL,
    ref_funcionario_exc integer,
    ref_funcionario_cad integer NOT NULL,
    nm_categoria character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: secretaria_responsavel; Type: TABLE; Schema: pmiacoes; Owner: -; Tablespace:
--

CREATE TABLE secretaria_responsavel (
    ref_cod_setor integer NOT NULL,
    ref_cod_funcionario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL
);


SET search_path = pmicontrolesis, pg_catalog;

--
-- Name: acontecimento_cod_acontecimento_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE acontecimento_cod_acontecimento_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acontecimento_cod_acontecimento_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('acontecimento_cod_acontecimento_seq', 1, false);


--
-- Name: acontecimento; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE acontecimento (
    cod_acontecimento integer DEFAULT nextval('acontecimento_cod_acontecimento_seq'::regclass) NOT NULL,
    ref_cod_tipo_acontecimento integer NOT NULL,
    ref_cod_funcionario_cad integer NOT NULL,
    ref_cod_funcionario_exc integer,
    titulo character varying(255),
    descricao text,
    dt_inicio timestamp without time zone,
    dt_fim timestamp without time zone,
    hr_inicio time without time zone,
    hr_fim time without time zone,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint,
    local character varying,
    contato character varying,
    link character varying
);


--
-- Name: artigo_cod_artigo_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE artigo_cod_artigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: artigo_cod_artigo_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('artigo_cod_artigo_seq', 1, false);


--
-- Name: artigo; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE artigo (
    cod_artigo integer DEFAULT nextval('artigo_cod_artigo_seq'::regclass) NOT NULL,
    texto text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint
);


--
-- Name: foto_evento_cod_foto_evento_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE foto_evento_cod_foto_evento_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: foto_evento_cod_foto_evento_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('foto_evento_cod_foto_evento_seq', 1, false);


--
-- Name: foto_evento; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE foto_evento (
    cod_foto_evento integer DEFAULT nextval('foto_evento_cod_foto_evento_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    data_foto timestamp without time zone,
    titulo character varying(255),
    descricao text,
    caminho character varying(255),
    altura integer,
    largura integer,
    nm_credito character varying(255)
);


--
-- Name: foto_vinc_cod_foto_vinc_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE foto_vinc_cod_foto_vinc_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: foto_vinc_cod_foto_vinc_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('foto_vinc_cod_foto_vinc_seq', 1, false);


SET default_with_oids = false;

--
-- Name: foto_vinc; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE foto_vinc (
    cod_foto_vinc integer DEFAULT nextval('foto_vinc_cod_foto_vinc_seq'::regclass) NOT NULL,
    ref_cod_acontecimento integer NOT NULL,
    ref_cod_foto_evento integer NOT NULL
);


--
-- Name: itinerario_cod_itinerario_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE itinerario_cod_itinerario_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: itinerario_cod_itinerario_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('itinerario_cod_itinerario_seq', 1, false);


SET default_with_oids = true;

--
-- Name: itinerario; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE itinerario (
    cod_itinerario integer DEFAULT nextval('itinerario_cod_itinerario_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    numero integer,
    itinerario text,
    retorno text,
    horarios text,
    descricao_horario text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    nome character varying(255) NOT NULL
);


--
-- Name: menu_cod_menu_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE menu_cod_menu_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: menu_cod_menu_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('menu_cod_menu_seq', 20709, true);


--
-- Name: menu; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE menu (
    cod_menu integer DEFAULT nextval('menu_cod_menu_seq'::regclass) NOT NULL,
    ref_cod_menu_submenu integer,
    ref_cod_menu_pai integer,
    tt_menu character varying(40) NOT NULL,
    ord_menu integer NOT NULL,
    caminho character varying(255),
    alvo character varying(20),
    suprime_menu smallint DEFAULT 1,
    ref_cod_tutormenu integer,
    ref_cod_ico integer
);


--
-- Name: menu_portal_cod_menu_portal_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE menu_portal_cod_menu_portal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: menu_portal_cod_menu_portal_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('menu_portal_cod_menu_portal_seq', 1, false);


--
-- Name: menu_portal; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE menu_portal (
    cod_menu_portal integer DEFAULT nextval('menu_portal_cod_menu_portal_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    nm_menu character varying(15) DEFAULT ''::character varying NOT NULL,
    title character varying(255),
    caminho character varying(255),
    cor character varying(255),
    posicao character(1) DEFAULT 'E'::bpchar NOT NULL,
    ordem double precision DEFAULT (0)::double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    expansivel smallint
);


--
-- Name: portais_cod_portais_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE portais_cod_portais_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: portais_cod_portais_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('portais_cod_portais_seq', 1, false);


--
-- Name: portais; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE portais (
    cod_portais integer DEFAULT nextval('portais_cod_portais_seq'::regclass) NOT NULL,
    ref_cod_funcionario_cad integer NOT NULL,
    ref_cod_funcionario_exc integer,
    url character varying(255),
    caminho character varying(255),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint,
    title character varying(255),
    descricao text
);


--
-- Name: servicos_cod_servicos_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE servicos_cod_servicos_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: servicos_cod_servicos_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('servicos_cod_servicos_seq', 1, false);


--
-- Name: servicos; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE servicos (
    cod_servicos integer DEFAULT nextval('servicos_cod_servicos_seq'::regclass) NOT NULL,
    ref_cod_funcionario_cad integer NOT NULL,
    ref_cod_funcionario_exc integer,
    url character varying(255),
    caminho character varying(255),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint,
    title character varying(255),
    descricao text
);


--
-- Name: sistema_cod_sistema_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE sistema_cod_sistema_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: sistema_cod_sistema_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('sistema_cod_sistema_seq', 1, false);


--
-- Name: sistema; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE sistema (
    cod_sistema integer DEFAULT nextval('sistema_cod_sistema_seq'::regclass) NOT NULL,
    nm_sistema character varying(255) NOT NULL,
    ref_cod_funcionario_cad integer NOT NULL,
    ref_cod_funcionario_exc integer,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint
);


--
-- Name: submenu_portal_cod_submenu_portal_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE submenu_portal_cod_submenu_portal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: submenu_portal_cod_submenu_portal_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('submenu_portal_cod_submenu_portal_seq', 1, false);


--
-- Name: submenu_portal; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE submenu_portal (
    cod_submenu_portal integer DEFAULT nextval('submenu_portal_cod_submenu_portal_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    ref_cod_menu_portal integer DEFAULT 0 NOT NULL,
    nm_submenu character varying(255) DEFAULT ''::character varying NOT NULL,
    arquivo character varying(255) DEFAULT ''::character varying NOT NULL,
    target character(1) DEFAULT 'S'::bpchar NOT NULL,
    title text,
    ordem double precision DEFAULT (0)::double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: telefones_cod_telefones_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE telefones_cod_telefones_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: telefones_cod_telefones_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('telefones_cod_telefones_seq', 1, false);


--
-- Name: telefones; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE telefones (
    cod_telefones integer DEFAULT nextval('telefones_cod_telefones_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    nome character varying(255) NOT NULL,
    numero character varying,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: tipo_acontecimento_cod_tipo_acontecimento_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE tipo_acontecimento_cod_tipo_acontecimento_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_acontecimento_cod_tipo_acontecimento_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('tipo_acontecimento_cod_tipo_acontecimento_seq', 1, false);


--
-- Name: tipo_acontecimento; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE tipo_acontecimento (
    cod_tipo_acontecimento integer DEFAULT nextval('tipo_acontecimento_cod_tipo_acontecimento_seq'::regclass) NOT NULL,
    ref_cod_funcionario_cad integer NOT NULL,
    ref_cod_funcionario_exc integer,
    nm_tipo character varying(255),
    caminho character varying(255),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint
);


--
-- Name: topo_portal_cod_topo_portal_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE topo_portal_cod_topo_portal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: topo_portal_cod_topo_portal_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('topo_portal_cod_topo_portal_seq', 1, false);


--
-- Name: topo_portal; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE topo_portal (
    cod_topo_portal integer DEFAULT nextval('topo_portal_cod_topo_portal_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    ref_cod_menu_portal integer DEFAULT 0,
    caminho1 character varying(255),
    caminho2 character varying(255),
    caminho3 character varying(255),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: tutormenu_cod_tutormenu_seq; Type: SEQUENCE; Schema: pmicontrolesis; Owner: -
--

CREATE SEQUENCE tutormenu_cod_tutormenu_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tutormenu_cod_tutormenu_seq; Type: SEQUENCE SET; Schema: pmicontrolesis; Owner: -
--

SELECT pg_catalog.setval('tutormenu_cod_tutormenu_seq', 16, true);


--
-- Name: tutormenu; Type: TABLE; Schema: pmicontrolesis; Owner: -; Tablespace:
--

CREATE TABLE tutormenu (
    cod_tutormenu integer DEFAULT nextval('tutormenu_cod_tutormenu_seq'::regclass) NOT NULL,
    nm_tutormenu character varying(200) NOT NULL
);


SET search_path = pmidrh, pg_catalog;

--
-- Name: diaria_cod_diaria_seq; Type: SEQUENCE; Schema: pmidrh; Owner: -
--

CREATE SEQUENCE diaria_cod_diaria_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: diaria_cod_diaria_seq; Type: SEQUENCE SET; Schema: pmidrh; Owner: -
--

SELECT pg_catalog.setval('diaria_cod_diaria_seq', 1, false);


--
-- Name: diaria; Type: TABLE; Schema: pmidrh; Owner: -; Tablespace:
--

CREATE TABLE diaria (
    cod_diaria integer DEFAULT nextval('diaria_cod_diaria_seq'::regclass) NOT NULL,
    ref_funcionario_cadastro integer NOT NULL,
    ref_cod_diaria_grupo integer NOT NULL,
    ref_funcionario integer NOT NULL,
    conta_corrente integer,
    agencia integer,
    banco integer,
    dotacao_orcamentaria character varying(50),
    objetivo text,
    data_partida timestamp without time zone,
    data_chegada timestamp without time zone,
    estadual smallint,
    destino character varying(100),
    data_pedido timestamp without time zone,
    vl100 double precision,
    vl75 double precision,
    vl50 double precision,
    vl25 double precision,
    roteiro integer,
    ativo boolean DEFAULT true,
    ref_cod_setor integer,
    num_diaria numeric(6,0)
);


--
-- Name: diaria_grupo_cod_diaria_grupo_seq; Type: SEQUENCE; Schema: pmidrh; Owner: -
--

CREATE SEQUENCE diaria_grupo_cod_diaria_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: diaria_grupo_cod_diaria_grupo_seq; Type: SEQUENCE SET; Schema: pmidrh; Owner: -
--

SELECT pg_catalog.setval('diaria_grupo_cod_diaria_grupo_seq', 1, false);


--
-- Name: diaria_grupo; Type: TABLE; Schema: pmidrh; Owner: -; Tablespace:
--

CREATE TABLE diaria_grupo (
    cod_diaria_grupo integer DEFAULT nextval('diaria_grupo_cod_diaria_grupo_seq'::regclass) NOT NULL,
    desc_grupo character varying(255) NOT NULL
);


--
-- Name: diaria_valores_cod_diaria_valores_seq; Type: SEQUENCE; Schema: pmidrh; Owner: -
--

CREATE SEQUENCE diaria_valores_cod_diaria_valores_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: diaria_valores_cod_diaria_valores_seq; Type: SEQUENCE SET; Schema: pmidrh; Owner: -
--

SELECT pg_catalog.setval('diaria_valores_cod_diaria_valores_seq', 1, false);


--
-- Name: diaria_valores; Type: TABLE; Schema: pmidrh; Owner: -; Tablespace:
--

CREATE TABLE diaria_valores (
    cod_diaria_valores integer DEFAULT nextval('diaria_valores_cod_diaria_valores_seq'::regclass) NOT NULL,
    ref_funcionario_cadastro integer NOT NULL,
    ref_cod_diaria_grupo integer NOT NULL,
    estadual smallint NOT NULL,
    p100 double precision,
    p75 double precision,
    p50 double precision,
    p25 double precision,
    data_vigencia timestamp without time zone NOT NULL
);


--
-- Name: setor_cod_setor_seq; Type: SEQUENCE; Schema: pmidrh; Owner: -
--

CREATE SEQUENCE setor_cod_setor_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: setor_cod_setor_seq; Type: SEQUENCE SET; Schema: pmidrh; Owner: -
--

SELECT pg_catalog.setval('setor_cod_setor_seq', 1, false);


--
-- Name: setor; Type: TABLE; Schema: pmidrh; Owner: -; Tablespace:
--

CREATE TABLE setor (
    cod_setor integer DEFAULT nextval('setor_cod_setor_seq'::regclass) NOT NULL,
    ref_cod_pessoa_exc integer,
    ref_cod_pessoa_cad integer NOT NULL,
    ref_cod_setor integer,
    nm_setor character varying(255) NOT NULL,
    sgl_setor character varying(15) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    nivel smallint DEFAULT (1)::smallint NOT NULL,
    no_paco smallint DEFAULT 1,
    endereco text,
    tipo character(1),
    ref_idpes_resp integer
);


SET search_path = pmieducar, pg_catalog;

--
-- Name: acervo_cod_acervo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE acervo_cod_acervo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acervo_cod_acervo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('acervo_cod_acervo_seq', 1, false);


--
-- Name: acervo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo (
    cod_acervo integer DEFAULT nextval('acervo_cod_acervo_seq'::regclass) NOT NULL,
    ref_cod_exemplar_tipo integer NOT NULL,
    ref_cod_acervo integer,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_acervo_colecao integer,
    ref_cod_acervo_idioma integer NOT NULL,
    ref_cod_acervo_editora integer NOT NULL,
    titulo character varying(255) NOT NULL,
    sub_titulo character varying(255),
    cdu character varying(20),
    cutter character varying(20),
    volume integer NOT NULL,
    num_edicao integer NOT NULL,
    ano numeric(4,0) NOT NULL,
    num_paginas integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer NOT NULL,
    isbn numeric(13,0)
);


--
-- Name: acervo_acervo_assunto; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_acervo_assunto (
    ref_cod_acervo integer NOT NULL,
    ref_cod_acervo_assunto integer NOT NULL
);


--
-- Name: acervo_acervo_autor; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_acervo_autor (
    ref_cod_acervo_autor integer NOT NULL,
    ref_cod_acervo integer NOT NULL,
    principal smallint DEFAULT (0)::smallint NOT NULL
);


--
-- Name: acervo_assunto_cod_acervo_assunto_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE acervo_assunto_cod_acervo_assunto_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acervo_assunto_cod_acervo_assunto_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('acervo_assunto_cod_acervo_assunto_seq', 1, false);


--
-- Name: acervo_assunto; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_assunto (
    cod_acervo_assunto integer DEFAULT nextval('acervo_assunto_cod_acervo_assunto_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_assunto character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: acervo_autor_cod_acervo_autor_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE acervo_autor_cod_acervo_autor_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acervo_autor_cod_acervo_autor_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('acervo_autor_cod_acervo_autor_seq', 1, false);


--
-- Name: acervo_autor; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_autor (
    cod_acervo_autor integer DEFAULT nextval('acervo_autor_cod_acervo_autor_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_autor character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer NOT NULL
);


--
-- Name: acervo_colecao_cod_acervo_colecao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE acervo_colecao_cod_acervo_colecao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acervo_colecao_cod_acervo_colecao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('acervo_colecao_cod_acervo_colecao_seq', 1, false);


--
-- Name: acervo_colecao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_colecao (
    cod_acervo_colecao integer DEFAULT nextval('acervo_colecao_cod_acervo_colecao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_colecao character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: acervo_editora_cod_acervo_editora_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE acervo_editora_cod_acervo_editora_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acervo_editora_cod_acervo_editora_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('acervo_editora_cod_acervo_editora_seq', 1, false);


--
-- Name: acervo_editora; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_editora (
    cod_acervo_editora integer DEFAULT nextval('acervo_editora_cod_acervo_editora_seq'::regclass) NOT NULL,
    ref_usuario_cad integer NOT NULL,
    ref_usuario_exc integer,
    ref_idtlog character varying(20) NOT NULL,
    ref_sigla_uf character(2) NOT NULL,
    nm_editora character varying(255) NOT NULL,
    cep numeric(8,0) NOT NULL,
    cidade character varying(60) NOT NULL,
    bairro character varying(60) NOT NULL,
    logradouro character varying(255) NOT NULL,
    numero numeric(6,0),
    telefone integer,
    ddd_telefone numeric(3,0),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: acervo_idioma_cod_acervo_idioma_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE acervo_idioma_cod_acervo_idioma_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acervo_idioma_cod_acervo_idioma_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('acervo_idioma_cod_acervo_idioma_seq', 1, false);


--
-- Name: acervo_idioma; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE acervo_idioma (
    cod_acervo_idioma integer DEFAULT nextval('acervo_idioma_cod_acervo_idioma_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_idioma character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: aluno_cod_aluno_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE aluno_cod_aluno_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: aluno_cod_aluno_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('aluno_cod_aluno_seq', 1, false);


--
-- Name: aluno; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE aluno (
    cod_aluno integer DEFAULT nextval('aluno_cod_aluno_seq'::regclass) NOT NULL,
    ref_cod_aluno_beneficio integer,
    ref_cod_religiao integer,
    ref_usuario_exc integer,
    ref_usuario_cad integer,
    ref_idpes integer,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    caminho_foto character varying(255),
    analfabeto smallint DEFAULT (0)::smallint,
    nm_pai character varying(255),
    nm_mae character varying(255),
    tipo_responsavel character(1)
);


--
-- Name: aluno_beneficio_cod_aluno_beneficio_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE aluno_beneficio_cod_aluno_beneficio_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: aluno_beneficio_cod_aluno_beneficio_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('aluno_beneficio_cod_aluno_beneficio_seq', 1, false);


--
-- Name: aluno_beneficio; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE aluno_beneficio (
    cod_aluno_beneficio integer DEFAULT nextval('aluno_beneficio_cod_aluno_beneficio_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_beneficio character varying(255) NOT NULL,
    desc_beneficio text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: ano_letivo_modulo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE ano_letivo_modulo (
    ref_ano integer NOT NULL,
    ref_ref_cod_escola integer NOT NULL,
    sequencial integer NOT NULL,
    ref_cod_modulo integer NOT NULL,
    data_inicio date NOT NULL,
    data_fim date NOT NULL
);


--
-- Name: avaliacao_desempenho; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE avaliacao_desempenho (
    sequencial integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    descricao text NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    titulo_avaliacao character varying(255) NOT NULL
);


--
-- Name: biblioteca_cod_biblioteca_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE biblioteca_cod_biblioteca_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: biblioteca_cod_biblioteca_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('biblioteca_cod_biblioteca_seq', 1, false);


--
-- Name: biblioteca; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE biblioteca (
    cod_biblioteca integer DEFAULT nextval('biblioteca_cod_biblioteca_seq'::regclass) NOT NULL,
    ref_cod_instituicao integer,
    ref_cod_escola integer,
    nm_biblioteca character varying(255) NOT NULL,
    valor_multa double precision,
    max_emprestimo integer,
    valor_maximo_multa double precision,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    requisita_senha smallint DEFAULT (0)::smallint NOT NULL,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    dias_espera numeric(2,0),
    tombo_automatico boolean DEFAULT true
);


--
-- Name: biblioteca_dia; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE biblioteca_dia (
    ref_cod_biblioteca integer NOT NULL,
    dia numeric(1,0) NOT NULL
);


--
-- Name: biblioteca_feriados_cod_feriado_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE biblioteca_feriados_cod_feriado_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: biblioteca_feriados_cod_feriado_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('biblioteca_feriados_cod_feriado_seq', 1, false);


--
-- Name: biblioteca_feriados; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE biblioteca_feriados (
    cod_feriado integer DEFAULT nextval('biblioteca_feriados_cod_feriado_seq'::regclass) NOT NULL,
    ref_cod_biblioteca integer NOT NULL,
    nm_feriado character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    data_feriado date NOT NULL
);


--
-- Name: biblioteca_usuario; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE biblioteca_usuario (
    ref_cod_biblioteca integer NOT NULL,
    ref_cod_usuario integer NOT NULL
);


--
-- Name: calendario_ano_letivo_cod_calendario_ano_letivo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE calendario_ano_letivo_cod_calendario_ano_letivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: calendario_ano_letivo_cod_calendario_ano_letivo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('calendario_ano_letivo_cod_calendario_ano_letivo_seq', 1, false);


--
-- Name: calendario_ano_letivo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE calendario_ano_letivo (
    cod_calendario_ano_letivo integer DEFAULT nextval('calendario_ano_letivo_cod_calendario_ano_letivo_seq'::regclass) NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ano integer NOT NULL,
    data_cadastra timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: calendario_anotacao_cod_calendario_anotacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE calendario_anotacao_cod_calendario_anotacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: calendario_anotacao_cod_calendario_anotacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('calendario_anotacao_cod_calendario_anotacao_seq', 1, false);


--
-- Name: calendario_anotacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE calendario_anotacao (
    cod_calendario_anotacao integer DEFAULT nextval('calendario_anotacao_cod_calendario_anotacao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_anotacao character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint NOT NULL
);


--
-- Name: calendario_dia; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE calendario_dia (
    ref_cod_calendario_ano_letivo integer NOT NULL,
    mes integer NOT NULL,
    dia integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_calendario_dia_motivo integer,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    descricao text
);


--
-- Name: calendario_dia_anotacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE calendario_dia_anotacao (
    ref_dia integer NOT NULL,
    ref_mes integer NOT NULL,
    ref_ref_cod_calendario_ano_letivo integer NOT NULL,
    ref_cod_calendario_anotacao integer NOT NULL
);


--
-- Name: calendario_dia_motivo_cod_calendario_dia_motivo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE calendario_dia_motivo_cod_calendario_dia_motivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: calendario_dia_motivo_cod_calendario_dia_motivo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('calendario_dia_motivo_cod_calendario_dia_motivo_seq', 1, false);


--
-- Name: calendario_dia_motivo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE calendario_dia_motivo (
    cod_calendario_dia_motivo integer DEFAULT nextval('calendario_dia_motivo_cod_calendario_dia_motivo_seq'::regclass) NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    sigla character varying(15) NOT NULL,
    descricao text,
    tipo character(1) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    nm_motivo character varying(255) NOT NULL
);


--
-- Name: categoria_nivel_cod_categoria_nivel_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE categoria_nivel_cod_categoria_nivel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: categoria_nivel_cod_categoria_nivel_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('categoria_nivel_cod_categoria_nivel_seq', 1, false);


SET default_with_oids = false;

--
-- Name: categoria_nivel; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE categoria_nivel (
    cod_categoria_nivel integer DEFAULT nextval('categoria_nivel_cod_categoria_nivel_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_categoria_nivel character varying(100) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo boolean DEFAULT true NOT NULL
);


--
-- Name: cliente_cod_cliente_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE cliente_cod_cliente_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: cliente_cod_cliente_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('cliente_cod_cliente_seq', 1, false);


SET default_with_oids = true;

--
-- Name: cliente; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE cliente (
    cod_cliente integer DEFAULT nextval('cliente_cod_cliente_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_idpes integer NOT NULL,
    login integer,
    senha character varying(255),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: cliente_suspensao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE cliente_suspensao (
    sequencial integer NOT NULL,
    ref_cod_cliente integer NOT NULL,
    ref_cod_motivo_suspensao integer NOT NULL,
    ref_usuario_libera integer,
    ref_usuario_suspende integer NOT NULL,
    dias integer NOT NULL,
    data_suspensao timestamp without time zone NOT NULL,
    data_liberacao timestamp without time zone
);


--
-- Name: cliente_tipo_cod_cliente_tipo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE cliente_tipo_cod_cliente_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: cliente_tipo_cod_cliente_tipo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('cliente_tipo_cod_cliente_tipo_seq', 1, false);


--
-- Name: cliente_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE cliente_tipo (
    cod_cliente_tipo integer DEFAULT nextval('cliente_tipo_cod_cliente_tipo_seq'::regclass) NOT NULL,
    ref_cod_biblioteca integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


SET default_with_oids = false;

--
-- Name: cliente_tipo_cliente; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE cliente_tipo_cliente (
    ref_cod_cliente_tipo integer NOT NULL,
    ref_cod_cliente integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ref_usuario_cad integer NOT NULL,
    ref_usuario_exc integer,
    ativo smallint DEFAULT (1)::smallint,
    ref_cod_biblioteca integer
);


SET default_with_oids = true;

--
-- Name: cliente_tipo_exemplar_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE cliente_tipo_exemplar_tipo (
    ref_cod_cliente_tipo integer NOT NULL,
    ref_cod_exemplar_tipo integer NOT NULL,
    dias_emprestimo numeric(3,0)
);


--
-- Name: coffebreak_tipo_cod_coffebreak_tipo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE coffebreak_tipo_cod_coffebreak_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: coffebreak_tipo_cod_coffebreak_tipo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('coffebreak_tipo_cod_coffebreak_tipo_seq', 1, false);


--
-- Name: coffebreak_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE coffebreak_tipo (
    cod_coffebreak_tipo integer DEFAULT nextval('coffebreak_tipo_cod_coffebreak_tipo_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    desc_tipo text,
    custo_unitario double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: curso_cod_curso_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE curso_cod_curso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: curso_cod_curso_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('curso_cod_curso_seq', 1, false);


--
-- Name: curso; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE curso (
    cod_curso integer DEFAULT nextval('curso_cod_curso_seq'::regclass) NOT NULL,
    ref_usuario_cad integer NOT NULL,
    ref_cod_tipo_regime integer,
    ref_cod_nivel_ensino integer NOT NULL,
    ref_cod_tipo_ensino integer NOT NULL,
    nm_curso character varying(255) NOT NULL,
    sgl_curso character varying(15) NOT NULL,
    qtd_etapas smallint NOT NULL,
    carga_horaria double precision NOT NULL,
    ato_poder_publico character varying(255),
    objetivo_curso text,
    publico_alvo text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_usuario_exc integer,
    ref_cod_instituicao integer NOT NULL,
    padrao_ano_escolar smallint DEFAULT (0)::smallint NOT NULL,
    hora_falta double precision DEFAULT 0.00 NOT NULL
);


--
-- Name: disciplina_cod_disciplina_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE disciplina_cod_disciplina_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: disciplina_cod_disciplina_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('disciplina_cod_disciplina_seq', 1, false);


--
-- Name: disciplina; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE disciplina (
    cod_disciplina integer DEFAULT nextval('disciplina_cod_disciplina_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    desc_disciplina text,
    desc_resumida text,
    abreviatura character varying(15) NOT NULL,
    carga_horaria integer NOT NULL,
    apura_falta smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    nm_disciplina character varying(255) NOT NULL,
    ref_cod_curso integer
);


SET default_with_oids = false;

--
-- Name: disciplina_serie; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE disciplina_serie (
    ref_cod_disciplina integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: disciplina_topico_cod_disciplina_topico_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE disciplina_topico_cod_disciplina_topico_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: disciplina_topico_cod_disciplina_topico_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('disciplina_topico_cod_disciplina_topico_seq', 1, false);


SET default_with_oids = true;

--
-- Name: disciplina_topico; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE disciplina_topico (
    cod_disciplina_topico integer DEFAULT nextval('disciplina_topico_cod_disciplina_topico_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_topico character varying(255) NOT NULL,
    desc_topico text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


SET default_with_oids = false;

--
-- Name: dispensa_disciplina; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE dispensa_disciplina (
    ref_cod_matricula integer NOT NULL,
    ref_cod_disciplina integer NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_tipo_dispensa integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    observacao text,
    cod_dispensa integer NOT NULL
);


--
-- Name: escola_cod_escola_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE escola_cod_escola_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: escola_cod_escola_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('escola_cod_escola_seq', 1, false);


SET default_with_oids = true;

--
-- Name: escola; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola (
    cod_escola integer DEFAULT nextval('escola_cod_escola_seq'::regclass) NOT NULL,
    ref_usuario_cad integer NOT NULL,
    ref_usuario_exc integer,
    ref_cod_instituicao integer NOT NULL,
    ref_cod_escola_localizacao integer NOT NULL,
    ref_cod_escola_rede_ensino integer NOT NULL,
    ref_idpes integer,
    sigla character varying(20) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: escola_ano_letivo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_ano_letivo (
    ref_cod_escola integer NOT NULL,
    ano integer NOT NULL,
    ref_usuario_cad integer NOT NULL,
    ref_usuario_exc integer,
    andamento smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: escola_complemento; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_complemento (
    ref_cod_escola integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    cep numeric(8,0) NOT NULL,
    numero numeric(6,0),
    complemento character varying(50),
    email character varying(50),
    nm_escola character varying(255) NOT NULL,
    municipio character varying(60) NOT NULL,
    bairro character varying(40) NOT NULL,
    logradouro character varying(150) NOT NULL,
    ddd_telefone numeric(2,0),
    telefone numeric(11,0),
    ddd_fax numeric(2,0),
    fax numeric(11,0),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: escola_curso; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_curso (
    ref_cod_escola integer NOT NULL,
    ref_cod_curso integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: escola_localizacao_cod_escola_localizacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE escola_localizacao_cod_escola_localizacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: escola_localizacao_cod_escola_localizacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('escola_localizacao_cod_escola_localizacao_seq', 1, false);


--
-- Name: escola_localizacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_localizacao (
    cod_escola_localizacao integer DEFAULT nextval('escola_localizacao_cod_escola_localizacao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_localizacao character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: escola_rede_ensino_cod_escola_rede_ensino_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE escola_rede_ensino_cod_escola_rede_ensino_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: escola_rede_ensino_cod_escola_rede_ensino_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('escola_rede_ensino_cod_escola_rede_ensino_seq', 1, false);


--
-- Name: escola_rede_ensino; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_rede_ensino (
    cod_escola_rede_ensino integer DEFAULT nextval('escola_rede_ensino_cod_escola_rede_ensino_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_rede character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: escola_serie; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_serie (
    ref_cod_escola integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    hora_inicial time without time zone NOT NULL,
    hora_final time without time zone NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    hora_inicio_intervalo time without time zone NOT NULL,
    hora_fim_intervalo time without time zone NOT NULL
);


SET default_with_oids = false;

--
-- Name: escola_serie_disciplina; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE escola_serie_disciplina (
    ref_ref_cod_serie integer NOT NULL,
    ref_ref_cod_escola integer NOT NULL,
    ref_cod_disciplina integer NOT NULL,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    carga_horaria numeric(6,3)
);


--
-- Name: exemplar_cod_exemplar_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE exemplar_cod_exemplar_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: exemplar_cod_exemplar_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('exemplar_cod_exemplar_seq', 1, false);


SET default_with_oids = true;

--
-- Name: exemplar; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE exemplar (
    cod_exemplar integer DEFAULT nextval('exemplar_cod_exemplar_seq'::regclass) NOT NULL,
    ref_cod_fonte integer NOT NULL,
    ref_cod_motivo_baixa integer,
    ref_cod_acervo integer NOT NULL,
    ref_cod_situacao integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    permite_emprestimo smallint DEFAULT (1)::smallint NOT NULL,
    preco double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    data_aquisicao timestamp without time zone,
    tombo integer
);


--
-- Name: exemplar_emprestimo_cod_emprestimo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE exemplar_emprestimo_cod_emprestimo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: exemplar_emprestimo_cod_emprestimo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('exemplar_emprestimo_cod_emprestimo_seq', 1, false);


--
-- Name: exemplar_emprestimo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE exemplar_emprestimo (
    cod_emprestimo integer DEFAULT nextval('exemplar_emprestimo_cod_emprestimo_seq'::regclass) NOT NULL,
    ref_usuario_devolucao integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_cliente integer NOT NULL,
    ref_cod_exemplar integer NOT NULL,
    data_retirada timestamp without time zone NOT NULL,
    data_devolucao timestamp without time zone,
    valor_multa double precision
);


--
-- Name: exemplar_tipo_cod_exemplar_tipo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE exemplar_tipo_cod_exemplar_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: exemplar_tipo_cod_exemplar_tipo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('exemplar_tipo_cod_exemplar_tipo_seq', 1, false);


--
-- Name: exemplar_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE exemplar_tipo (
    cod_exemplar_tipo integer DEFAULT nextval('exemplar_tipo_cod_exemplar_tipo_seq'::regclass) NOT NULL,
    ref_cod_biblioteca integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: falta_aluno_cod_falta_aluno_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE falta_aluno_cod_falta_aluno_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: falta_aluno_cod_falta_aluno_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('falta_aluno_cod_falta_aluno_seq', 1, false);


SET default_with_oids = false;

--
-- Name: falta_aluno; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE falta_aluno (
    cod_falta_aluno integer DEFAULT nextval('falta_aluno_cod_falta_aluno_seq'::regclass) NOT NULL,
    ref_cod_disciplina integer,
    ref_cod_escola integer,
    ref_cod_serie integer,
    ref_cod_matricula integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    faltas integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    modulo smallint NOT NULL,
    ref_cod_curso_disciplina integer
);


--
-- Name: falta_atraso_cod_falta_atraso_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE falta_atraso_cod_falta_atraso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: falta_atraso_cod_falta_atraso_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('falta_atraso_cod_falta_atraso_seq', 1, false);


SET default_with_oids = true;

--
-- Name: falta_atraso; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE falta_atraso (
    cod_falta_atraso integer DEFAULT nextval('falta_atraso_cod_falta_atraso_seq'::regclass) NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    tipo smallint NOT NULL,
    data_falta_atraso timestamp without time zone NOT NULL,
    qtd_horas integer,
    qtd_min integer,
    justificada smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: falta_atraso_compensado_cod_compensado_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE falta_atraso_compensado_cod_compensado_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: falta_atraso_compensado_cod_compensado_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('falta_atraso_compensado_cod_compensado_seq', 1, false);


--
-- Name: falta_atraso_compensado; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE falta_atraso_compensado (
    cod_compensado integer DEFAULT nextval('falta_atraso_compensado_cod_compensado_seq'::regclass) NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    data_inicio timestamp without time zone NOT NULL,
    data_fim timestamp without time zone NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: faltas_sequencial_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE faltas_sequencial_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: faltas_sequencial_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('faltas_sequencial_seq', 1, false);


SET default_with_oids = false;

--
-- Name: faltas; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE faltas (
    ref_cod_matricula integer NOT NULL,
    sequencial integer DEFAULT nextval('faltas_sequencial_seq'::regclass) NOT NULL,
    ref_usuario_cad integer NOT NULL,
    falta integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: fonte_cod_fonte_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE fonte_cod_fonte_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: fonte_cod_fonte_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('fonte_cod_fonte_seq', 1, false);


SET default_with_oids = true;

--
-- Name: fonte; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE fonte (
    cod_fonte integer DEFAULT nextval('fonte_cod_fonte_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_fonte character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: funcao_cod_funcao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE funcao_cod_funcao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: funcao_cod_funcao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('funcao_cod_funcao_seq', 1, false);


--
-- Name: funcao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE funcao (
    cod_funcao integer DEFAULT nextval('funcao_cod_funcao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_funcao character varying(255) NOT NULL,
    abreviatura character varying(30) NOT NULL,
    professor smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: habilitacao_cod_habilitacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE habilitacao_cod_habilitacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: habilitacao_cod_habilitacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('habilitacao_cod_habilitacao_seq', 1, false);


--
-- Name: habilitacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE habilitacao (
    cod_habilitacao integer DEFAULT nextval('habilitacao_cod_habilitacao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: habilitacao_curso; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE habilitacao_curso (
    ref_cod_habilitacao integer NOT NULL,
    ref_cod_curso integer NOT NULL
);


--
-- Name: historico_disciplinas; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE historico_disciplinas (
    sequencial integer NOT NULL,
    ref_ref_cod_aluno integer NOT NULL,
    ref_sequencial integer NOT NULL,
    nm_disciplina character varying(255) NOT NULL,
    nota character varying(255) NOT NULL,
    faltas integer,
    import numeric(1,0)
);


SET default_with_oids = false;

--
-- Name: historico_educar; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE historico_educar (
    tabela character varying(50),
    alteracao text,
    data timestamp without time zone,
    insercao smallint DEFAULT 0
);


SET default_with_oids = true;

--
-- Name: historico_escolar; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE historico_escolar (
    ref_cod_aluno integer NOT NULL,
    sequencial integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ano integer NOT NULL,
    carga_horaria double precision NOT NULL,
    dias_letivos integer,
    escola character varying(255) NOT NULL,
    escola_cidade character varying(255) NOT NULL,
    escola_uf character(2),
    observacao text,
    aprovado smallint DEFAULT (1)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    faltas_globalizadas integer,
    nm_serie character varying(255),
    origem smallint DEFAULT (1)::smallint,
    extra_curricular smallint DEFAULT (0)::smallint,
    ref_cod_matricula integer,
    ref_cod_instituicao integer,
    import numeric(1,0)
);


--
-- Name: infra_comodo_funcao_cod_infra_comodo_funcao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE infra_comodo_funcao_cod_infra_comodo_funcao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: infra_comodo_funcao_cod_infra_comodo_funcao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('infra_comodo_funcao_cod_infra_comodo_funcao_seq', 1, false);


--
-- Name: infra_comodo_funcao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE infra_comodo_funcao (
    cod_infra_comodo_funcao integer DEFAULT nextval('infra_comodo_funcao_cod_infra_comodo_funcao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_funcao character varying(255) NOT NULL,
    desc_funcao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_escola integer
);


--
-- Name: infra_predio_cod_infra_predio_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE infra_predio_cod_infra_predio_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: infra_predio_cod_infra_predio_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('infra_predio_cod_infra_predio_seq', 1, false);


--
-- Name: infra_predio; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE infra_predio (
    cod_infra_predio integer DEFAULT nextval('infra_predio_cod_infra_predio_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_escola integer NOT NULL,
    nm_predio character varying(255) NOT NULL,
    desc_predio text,
    endereco text NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: infra_predio_comodo_cod_infra_predio_comodo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE infra_predio_comodo_cod_infra_predio_comodo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: infra_predio_comodo_cod_infra_predio_comodo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('infra_predio_comodo_cod_infra_predio_comodo_seq', 1, false);


--
-- Name: infra_predio_comodo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE infra_predio_comodo (
    cod_infra_predio_comodo integer DEFAULT nextval('infra_predio_comodo_cod_infra_predio_comodo_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_infra_comodo_funcao integer NOT NULL,
    ref_cod_infra_predio integer NOT NULL,
    nm_comodo character varying(255) NOT NULL,
    desc_comodo text,
    area double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: instituicao_cod_instituicao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE instituicao_cod_instituicao_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: instituicao_cod_instituicao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('instituicao_cod_instituicao_seq', 1, true);


--
-- Name: instituicao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE instituicao (
    cod_instituicao integer DEFAULT nextval('instituicao_cod_instituicao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_idtlog character varying(20) NOT NULL,
    ref_sigla_uf character(2) NOT NULL,
    cep numeric(8,0) NOT NULL,
    cidade character varying(60) NOT NULL,
    bairro character varying(40) NOT NULL,
    logradouro character varying(255) NOT NULL,
    numero numeric(6,0),
    complemento character varying(50),
    nm_responsavel character varying(255) NOT NULL,
    ddd_telefone numeric(2,0),
    telefone numeric(11,0),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    nm_instituicao character varying(255) NOT NULL
);


--
-- Name: material_didatico_cod_material_didatico_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE material_didatico_cod_material_didatico_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: material_didatico_cod_material_didatico_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('material_didatico_cod_material_didatico_seq', 1, false);


--
-- Name: material_didatico; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE material_didatico (
    cod_material_didatico integer DEFAULT nextval('material_didatico_cod_material_didatico_seq'::regclass) NOT NULL,
    ref_cod_instituicao integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_material_tipo integer NOT NULL,
    nm_material character varying(255) NOT NULL,
    desc_material text,
    custo_unitario double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: material_tipo_cod_material_tipo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE material_tipo_cod_material_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: material_tipo_cod_material_tipo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('material_tipo_cod_material_tipo_seq', 1, false);


--
-- Name: material_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE material_tipo (
    cod_material_tipo integer DEFAULT nextval('material_tipo_cod_material_tipo_seq'::regclass) NOT NULL,
    ref_usuario_cad integer NOT NULL,
    ref_usuario_exc integer,
    nm_tipo character varying(255) NOT NULL,
    desc_tipo text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: matricula_cod_matricula_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE matricula_cod_matricula_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: matricula_cod_matricula_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('matricula_cod_matricula_seq', 1, false);


--
-- Name: matricula; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE matricula (
    cod_matricula integer DEFAULT nextval('matricula_cod_matricula_seq'::regclass) NOT NULL,
    ref_cod_reserva_vaga integer,
    ref_ref_cod_escola integer,
    ref_ref_cod_serie integer,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_aluno integer NOT NULL,
    aprovado smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ano integer NOT NULL,
    ultima_matricula smallint DEFAULT (0)::smallint NOT NULL,
    modulo smallint DEFAULT 1 NOT NULL,
    descricao_reclassificacao text,
    formando smallint DEFAULT (0)::smallint NOT NULL,
    matricula_reclassificacao smallint DEFAULT (0)::smallint,
    ref_cod_curso integer,
    matricula_transferencia boolean DEFAULT false NOT NULL,
    semestre smallint
);


--
-- Name: matricula_excessao_cod_aluno_excessao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE matricula_excessao_cod_aluno_excessao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: matricula_excessao_cod_aluno_excessao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('matricula_excessao_cod_aluno_excessao_seq', 1, false);


SET default_with_oids = false;

--
-- Name: matricula_excessao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE matricula_excessao (
    cod_aluno_excessao integer DEFAULT nextval('matricula_excessao_cod_aluno_excessao_seq'::regclass) NOT NULL,
    ref_cod_matricula integer NOT NULL,
    ref_cod_turma integer NOT NULL,
    ref_sequencial integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_cod_disciplina integer NOT NULL,
    reprovado_faltas boolean NOT NULL,
    precisa_exame boolean NOT NULL,
    permite_exame boolean
);


SET default_with_oids = true;

--
-- Name: matricula_ocorrencia_disciplinar; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE matricula_ocorrencia_disciplinar (
    ref_cod_matricula integer NOT NULL,
    ref_cod_tipo_ocorrencia_disciplinar integer NOT NULL,
    sequencial integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    observacao text NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: matricula_turma; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE matricula_turma (
    ref_cod_matricula integer NOT NULL,
    ref_cod_turma integer NOT NULL,
    sequencial integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: menu_tipo_usuario; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE menu_tipo_usuario (
    ref_cod_tipo_usuario integer NOT NULL,
    ref_cod_menu_submenu integer NOT NULL,
    cadastra smallint DEFAULT 0 NOT NULL,
    visualiza smallint DEFAULT 0 NOT NULL,
    exclui smallint DEFAULT 0 NOT NULL
);


--
-- Name: modulo_cod_modulo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE modulo_cod_modulo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: modulo_cod_modulo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('modulo_cod_modulo_seq', 1, false);


--
-- Name: modulo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE modulo (
    cod_modulo integer DEFAULT nextval('modulo_cod_modulo_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    num_meses numeric(2,0) NOT NULL,
    num_semanas integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: motivo_afastamento_cod_motivo_afastamento_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE motivo_afastamento_cod_motivo_afastamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: motivo_afastamento_cod_motivo_afastamento_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('motivo_afastamento_cod_motivo_afastamento_seq', 1, false);


--
-- Name: motivo_afastamento; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE motivo_afastamento (
    cod_motivo_afastamento integer DEFAULT nextval('motivo_afastamento_cod_motivo_afastamento_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_motivo character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: motivo_baixa_cod_motivo_baixa_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE motivo_baixa_cod_motivo_baixa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: motivo_baixa_cod_motivo_baixa_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('motivo_baixa_cod_motivo_baixa_seq', 1, false);


--
-- Name: motivo_baixa; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE motivo_baixa (
    cod_motivo_baixa integer DEFAULT nextval('motivo_baixa_cod_motivo_baixa_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_motivo_baixa character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: motivo_suspensao_cod_motivo_suspensao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE motivo_suspensao_cod_motivo_suspensao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: motivo_suspensao_cod_motivo_suspensao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('motivo_suspensao_cod_motivo_suspensao_seq', 1, false);


--
-- Name: motivo_suspensao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE motivo_suspensao (
    cod_motivo_suspensao integer DEFAULT nextval('motivo_suspensao_cod_motivo_suspensao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_motivo character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer
);


--
-- Name: nivel_cod_nivel_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE nivel_cod_nivel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: nivel_cod_nivel_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('nivel_cod_nivel_seq', 1, false);


SET default_with_oids = false;

--
-- Name: nivel; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE nivel (
    cod_nivel integer DEFAULT nextval('nivel_cod_nivel_seq'::regclass) NOT NULL,
    ref_cod_categoria_nivel integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_nivel_anterior integer,
    nm_nivel character varying(100) NOT NULL,
    salario_base double precision,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo boolean DEFAULT true NOT NULL
);


--
-- Name: nivel_ensino_cod_nivel_ensino_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE nivel_ensino_cod_nivel_ensino_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: nivel_ensino_cod_nivel_ensino_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('nivel_ensino_cod_nivel_ensino_seq', 1, false);


SET default_with_oids = true;

--
-- Name: nivel_ensino; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE nivel_ensino (
    cod_nivel_ensino integer DEFAULT nextval('nivel_ensino_cod_nivel_ensino_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_nivel character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: nota_aluno_cod_nota_aluno_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE nota_aluno_cod_nota_aluno_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: nota_aluno_cod_nota_aluno_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('nota_aluno_cod_nota_aluno_seq', 1, false);


SET default_with_oids = false;

--
-- Name: nota_aluno; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE nota_aluno (
    cod_nota_aluno integer DEFAULT nextval('nota_aluno_cod_nota_aluno_seq'::regclass) NOT NULL,
    ref_cod_disciplina integer,
    ref_cod_escola integer,
    ref_cod_serie integer,
    ref_cod_matricula integer NOT NULL,
    ref_sequencial integer,
    ref_ref_cod_tipo_avaliacao integer,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    modulo smallint NOT NULL,
    ref_cod_curso_disciplina integer,
    nota double precision
);


--
-- Name: operador_cod_operador_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE operador_cod_operador_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: operador_cod_operador_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('operador_cod_operador_seq', 1, false);


SET default_with_oids = true;

--
-- Name: operador; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE operador (
    cod_operador integer DEFAULT nextval('operador_cod_operador_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nome character varying(50) NOT NULL,
    valor text NOT NULL,
    fim_sentenca smallint DEFAULT (1)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: pagamento_multa_cod_pagamento_multa_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE pagamento_multa_cod_pagamento_multa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: pagamento_multa_cod_pagamento_multa_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('pagamento_multa_cod_pagamento_multa_seq', 1, false);


--
-- Name: pagamento_multa; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE pagamento_multa (
    cod_pagamento_multa integer DEFAULT nextval('pagamento_multa_cod_pagamento_multa_seq'::regclass) NOT NULL,
    ref_usuario_cad integer NOT NULL,
    ref_cod_cliente integer NOT NULL,
    valor_pago double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    ref_cod_biblioteca integer NOT NULL
);


--
-- Name: pre_requisito_cod_pre_requisito_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE pre_requisito_cod_pre_requisito_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: pre_requisito_cod_pre_requisito_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('pre_requisito_cod_pre_requisito_seq', 1, false);


--
-- Name: pre_requisito; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE pre_requisito (
    cod_pre_requisito integer DEFAULT nextval('pre_requisito_cod_pre_requisito_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    schema_ character varying(50) NOT NULL,
    tabela character varying(50) NOT NULL,
    nome character varying(50) NOT NULL,
    sql text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: quadro_horario_cod_quadro_horario_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE quadro_horario_cod_quadro_horario_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: quadro_horario_cod_quadro_horario_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('quadro_horario_cod_quadro_horario_seq', 1, false);


--
-- Name: quadro_horario; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE quadro_horario (
    cod_quadro_horario integer DEFAULT nextval('quadro_horario_cod_quadro_horario_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_turma integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


SET default_with_oids = false;

--
-- Name: quadro_horario_horarios; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE quadro_horario_horarios (
    ref_cod_quadro_horario integer NOT NULL,
    sequencial integer NOT NULL,
    ref_cod_disciplina integer NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    ref_cod_instituicao_substituto integer,
    ref_cod_instituicao_servidor integer NOT NULL,
    ref_servidor_substituto integer,
    ref_servidor integer NOT NULL,
    dia_semana integer NOT NULL,
    hora_inicial time without time zone NOT NULL,
    hora_final time without time zone NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: quadro_horario_horarios_aux; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE quadro_horario_horarios_aux (
    ref_cod_quadro_horario integer NOT NULL,
    sequencial integer NOT NULL,
    ref_cod_disciplina integer NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    ref_cod_instituicao_servidor integer NOT NULL,
    ref_servidor integer NOT NULL,
    dia_semana integer NOT NULL,
    hora_inicial time without time zone NOT NULL,
    hora_final time without time zone NOT NULL,
    identificador character varying(30),
    data_cadastro timestamp without time zone NOT NULL
);


--
-- Name: religiao_cod_religiao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE religiao_cod_religiao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: religiao_cod_religiao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('religiao_cod_religiao_seq', 1, false);


SET default_with_oids = true;

--
-- Name: religiao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE religiao (
    cod_religiao integer DEFAULT nextval('religiao_cod_religiao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_religiao character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: reserva_vaga_cod_reserva_vaga_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE reserva_vaga_cod_reserva_vaga_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: reserva_vaga_cod_reserva_vaga_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('reserva_vaga_cod_reserva_vaga_seq', 1, false);


--
-- Name: reserva_vaga; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE reserva_vaga (
    cod_reserva_vaga integer DEFAULT nextval('reserva_vaga_cod_reserva_vaga_seq'::regclass) NOT NULL,
    ref_ref_cod_escola integer NOT NULL,
    ref_ref_cod_serie integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_aluno integer,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    nm_aluno character varying(255),
    cpf_responsavel numeric(11,0)
);


--
-- Name: reservas_cod_reserva_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE reservas_cod_reserva_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: reservas_cod_reserva_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('reservas_cod_reserva_seq', 1, false);


--
-- Name: reservas; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE reservas (
    cod_reserva integer DEFAULT nextval('reservas_cod_reserva_seq'::regclass) NOT NULL,
    ref_usuario_libera integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_cliente integer NOT NULL,
    data_reserva timestamp without time zone,
    data_prevista_disponivel timestamp without time zone,
    data_retirada timestamp without time zone,
    ref_cod_exemplar integer NOT NULL,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: sequencia_serie; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE sequencia_serie (
    ref_serie_origem integer NOT NULL,
    ref_serie_destino integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: serie_cod_serie_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE serie_cod_serie_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: serie_cod_serie_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('serie_cod_serie_seq', 1, false);


--
-- Name: serie; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE serie (
    cod_serie integer DEFAULT nextval('serie_cod_serie_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_curso integer NOT NULL,
    nm_serie character varying(255) NOT NULL,
    etapa_curso integer NOT NULL,
    concluinte smallint DEFAULT (0)::smallint NOT NULL,
    carga_horaria double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    intervalo integer NOT NULL,
    idade_inicial numeric(3,0),
    idade_final numeric(3,0),
    regra_avaliacao_id integer
);


--
-- Name: serie_pre_requisito; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE serie_pre_requisito (
    ref_cod_pre_requisito integer NOT NULL,
    ref_cod_operador integer NOT NULL,
    ref_cod_serie integer NOT NULL,
    valor character varying
);


--
-- Name: servidor; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor (
    cod_servidor integer NOT NULL,
    ref_cod_instituicao integer NOT NULL,
    ref_cod_deficiencia integer,
    ref_idesco numeric(2,0),
    carga_horaria double precision NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_subnivel integer
);


--
-- Name: servidor_afastamento; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_afastamento (
    ref_cod_servidor integer NOT NULL,
    sequencial integer NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_cod_motivo_afastamento integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    data_retorno timestamp without time zone,
    data_saida timestamp without time zone NOT NULL,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: servidor_alocacao_cod_servidor_alocacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE servidor_alocacao_cod_servidor_alocacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: servidor_alocacao_cod_servidor_alocacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('servidor_alocacao_cod_servidor_alocacao_seq', 1, false);


--
-- Name: servidor_alocacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_alocacao (
    cod_servidor_alocacao integer DEFAULT nextval('servidor_alocacao_cod_servidor_alocacao_seq'::regclass) NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_escola integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    carga_horaria character varying(8),
    periodo smallint DEFAULT (1)::smallint,
    hora_final time without time zone,
    hora_inicial time without time zone,
    dia_semana integer
);


--
-- Name: servidor_curso_cod_servidor_curso_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE servidor_curso_cod_servidor_curso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: servidor_curso_cod_servidor_curso_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('servidor_curso_cod_servidor_curso_seq', 1, false);


--
-- Name: servidor_curso; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_curso (
    cod_servidor_curso integer DEFAULT nextval('servidor_curso_cod_servidor_curso_seq'::regclass) NOT NULL,
    ref_cod_formacao integer NOT NULL,
    data_conclusao timestamp without time zone NOT NULL,
    data_registro timestamp without time zone,
    diplomas_registros text
);


SET default_with_oids = false;

--
-- Name: servidor_curso_ministra; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_curso_ministra (
    ref_cod_curso integer NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_cod_servidor integer NOT NULL
);


--
-- Name: servidor_disciplina; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_disciplina (
    ref_cod_disciplina integer NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    ref_cod_curso integer NOT NULL
);


--
-- Name: servidor_formacao_cod_formacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE servidor_formacao_cod_formacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: servidor_formacao_cod_formacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('servidor_formacao_cod_formacao_seq', 1, false);


SET default_with_oids = true;

--
-- Name: servidor_formacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_formacao (
    cod_formacao integer DEFAULT nextval('servidor_formacao_cod_formacao_seq'::regclass) NOT NULL,
    ref_ref_cod_instituicao integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    nm_formacao character varying(255) NOT NULL,
    tipo character(1) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


SET default_with_oids = false;

--
-- Name: servidor_funcao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_funcao (
    ref_ref_cod_instituicao integer NOT NULL,
    ref_cod_servidor integer NOT NULL,
    ref_cod_funcao integer NOT NULL
);


--
-- Name: servidor_titulo_concurso_cod_servidor_titulo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE servidor_titulo_concurso_cod_servidor_titulo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: servidor_titulo_concurso_cod_servidor_titulo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('servidor_titulo_concurso_cod_servidor_titulo_seq', 1, false);


SET default_with_oids = true;

--
-- Name: servidor_titulo_concurso; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE servidor_titulo_concurso (
    cod_servidor_titulo integer DEFAULT nextval('servidor_titulo_concurso_cod_servidor_titulo_seq'::regclass) NOT NULL,
    ref_cod_formacao integer NOT NULL,
    data_vigencia_homolog timestamp without time zone NOT NULL,
    data_publicacao timestamp without time zone NOT NULL
);


--
-- Name: situacao_cod_situacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE situacao_cod_situacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: situacao_cod_situacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('situacao_cod_situacao_seq', 1, false);


--
-- Name: situacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE situacao (
    cod_situacao integer DEFAULT nextval('situacao_cod_situacao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_situacao character varying(255) NOT NULL,
    permite_emprestimo smallint DEFAULT (1)::smallint NOT NULL,
    descricao text,
    situacao_padrao smallint DEFAULT (0)::smallint NOT NULL,
    situacao_emprestada smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_biblioteca integer NOT NULL
);


--
-- Name: subnivel_cod_subnivel_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE subnivel_cod_subnivel_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: subnivel_cod_subnivel_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('subnivel_cod_subnivel_seq', 1, false);


SET default_with_oids = false;

--
-- Name: subnivel; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE subnivel (
    cod_subnivel integer DEFAULT nextval('subnivel_cod_subnivel_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_subnivel_anterior integer,
    ref_cod_nivel integer NOT NULL,
    nm_subnivel character varying(100),
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo boolean DEFAULT true NOT NULL,
    salario double precision NOT NULL
);


--
-- Name: tipo_avaliacao_cod_tipo_avaliacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE tipo_avaliacao_cod_tipo_avaliacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_avaliacao_cod_tipo_avaliacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('tipo_avaliacao_cod_tipo_avaliacao_seq', 1, false);


SET default_with_oids = true;

--
-- Name: tipo_avaliacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_avaliacao (
    cod_tipo_avaliacao integer DEFAULT nextval('tipo_avaliacao_cod_tipo_avaliacao_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    conceitual smallint DEFAULT 1,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: tipo_avaliacao_valores; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_avaliacao_valores (
    ref_cod_tipo_avaliacao integer NOT NULL,
    sequencial integer NOT NULL,
    nome character varying(255) NOT NULL,
    valor double precision NOT NULL,
    valor_min double precision NOT NULL,
    valor_max double precision NOT NULL,
    ativo boolean DEFAULT true
);


--
-- Name: tipo_dispensa_cod_tipo_dispensa_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE tipo_dispensa_cod_tipo_dispensa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_dispensa_cod_tipo_dispensa_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('tipo_dispensa_cod_tipo_dispensa_seq', 1, false);


--
-- Name: tipo_dispensa; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_dispensa (
    cod_tipo_dispensa integer DEFAULT nextval('tipo_dispensa_cod_tipo_dispensa_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: tipo_ensino_cod_tipo_ensino_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE tipo_ensino_cod_tipo_ensino_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_ensino_cod_tipo_ensino_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('tipo_ensino_cod_tipo_ensino_seq', 1, false);


--
-- Name: tipo_ensino; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_ensino (
    cod_tipo_ensino integer DEFAULT nextval('tipo_ensino_cod_tipo_ensino_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: tipo_ocorrencia_disciplinar_cod_tipo_ocorrencia_disciplinar_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE tipo_ocorrencia_disciplinar_cod_tipo_ocorrencia_disciplinar_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_ocorrencia_disciplinar_cod_tipo_ocorrencia_disciplinar_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('tipo_ocorrencia_disciplinar_cod_tipo_ocorrencia_disciplinar_seq', 1, false);


--
-- Name: tipo_ocorrencia_disciplinar; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_ocorrencia_disciplinar (
    cod_tipo_ocorrencia_disciplinar integer DEFAULT nextval('tipo_ocorrencia_disciplinar_cod_tipo_ocorrencia_disciplinar_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    max_ocorrencias integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: tipo_regime_cod_tipo_regime_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE tipo_regime_cod_tipo_regime_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_regime_cod_tipo_regime_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('tipo_regime_cod_tipo_regime_seq', 1, false);


--
-- Name: tipo_regime; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_regime (
    cod_tipo_regime integer DEFAULT nextval('tipo_regime_cod_tipo_regime_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint NOT NULL,
    ref_cod_instituicao integer NOT NULL
);


--
-- Name: tipo_usuario_cod_tipo_usuario_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE tipo_usuario_cod_tipo_usuario_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: tipo_usuario_cod_tipo_usuario_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('tipo_usuario_cod_tipo_usuario_seq', 3, true);


--
-- Name: tipo_usuario; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE tipo_usuario (
    cod_tipo_usuario integer DEFAULT nextval('tipo_usuario_cod_tipo_usuario_seq'::regclass) NOT NULL,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    nm_tipo character varying(255) NOT NULL,
    descricao text,
    nivel integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: transferencia_solicitacao_cod_transferencia_solicitacao_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE transferencia_solicitacao_cod_transferencia_solicitacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: transferencia_solicitacao_cod_transferencia_solicitacao_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('transferencia_solicitacao_cod_transferencia_solicitacao_seq', 1, false);


--
-- Name: transferencia_solicitacao; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE transferencia_solicitacao (
    cod_transferencia_solicitacao integer DEFAULT nextval('transferencia_solicitacao_cod_transferencia_solicitacao_seq'::regclass) NOT NULL,
    ref_cod_transferencia_tipo integer NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_cod_matricula_entrada integer,
    ref_cod_matricula_saida integer NOT NULL,
    observacao text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    data_transferencia timestamp without time zone
);


--
-- Name: transferencia_tipo_cod_transferencia_tipo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE transferencia_tipo_cod_transferencia_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: transferencia_tipo_cod_transferencia_tipo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('transferencia_tipo_cod_transferencia_tipo_seq', 1, false);


--
-- Name: transferencia_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE transferencia_tipo (
    cod_transferencia_tipo integer DEFAULT nextval('transferencia_tipo_cod_transferencia_tipo_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    desc_tipo text,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_escola integer NOT NULL
);


--
-- Name: turma_cod_turma_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE turma_cod_turma_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: turma_cod_turma_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('turma_cod_turma_seq', 1, false);


--
-- Name: turma; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE turma (
    cod_turma integer DEFAULT nextval('turma_cod_turma_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    ref_ref_cod_serie integer,
    ref_ref_cod_escola integer,
    ref_cod_infra_predio_comodo integer,
    nm_turma character varying(255) NOT NULL,
    sgl_turma character varying(15),
    max_aluno integer NOT NULL,
    multiseriada smallint DEFAULT (0)::smallint NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_turma_tipo integer NOT NULL,
    hora_inicial time without time zone,
    hora_final time without time zone,
    hora_inicio_intervalo time without time zone,
    hora_fim_intervalo time without time zone,
    ref_cod_regente integer,
    ref_cod_instituicao_regente integer,
    ref_cod_instituicao integer,
    ref_cod_curso integer,
    ref_ref_cod_serie_mult integer,
    ref_ref_cod_escola_mult integer,
    visivel boolean
);


--
-- Name: turma_dia_semana; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE turma_dia_semana (
    dia_semana numeric(1,0) NOT NULL,
    ref_cod_turma integer NOT NULL,
    hora_inicial time without time zone,
    hora_final time without time zone
);


--
-- Name: turma_modulo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE turma_modulo (
    ref_cod_turma integer NOT NULL,
    ref_cod_modulo integer NOT NULL,
    sequencial integer NOT NULL,
    data_inicio date NOT NULL,
    data_fim date NOT NULL
);


--
-- Name: turma_tipo_cod_turma_tipo_seq; Type: SEQUENCE; Schema: pmieducar; Owner: -
--

CREATE SEQUENCE turma_tipo_cod_turma_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: turma_tipo_cod_turma_tipo_seq; Type: SEQUENCE SET; Schema: pmieducar; Owner: -
--

SELECT pg_catalog.setval('turma_tipo_cod_turma_tipo_seq', 1, false);


--
-- Name: turma_tipo; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE turma_tipo (
    cod_turma_tipo integer DEFAULT nextval('turma_tipo_cod_turma_tipo_seq'::regclass) NOT NULL,
    ref_usuario_exc integer,
    ref_usuario_cad integer NOT NULL,
    nm_tipo character varying(255) NOT NULL,
    sgl_tipo character varying(15) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_instituicao integer
);


--
-- Name: usuario; Type: TABLE; Schema: pmieducar; Owner: -; Tablespace:
--

CREATE TABLE usuario (
    cod_usuario integer NOT NULL,
    ref_cod_escola integer,
    ref_cod_instituicao integer,
    ref_funcionario_cad integer NOT NULL,
    ref_funcionario_exc integer,
    ref_cod_tipo_usuario integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: v_matricula_matricula_turma; Type: VIEW; Schema: pmieducar; Owner: -
--

CREATE VIEW v_matricula_matricula_turma AS
    SELECT ma.cod_matricula, ma.ref_ref_cod_escola AS ref_cod_escola, ma.ref_ref_cod_serie AS ref_cod_serie, ma.ref_cod_aluno, ma.ref_cod_curso, mt.ref_cod_turma, ma.ano, ma.aprovado, ma.ultima_matricula, ma.modulo, mt.sequencial, ma.ativo, (SELECT count(0) AS count FROM dispensa_disciplina dd WHERE (dd.ref_cod_matricula = ma.cod_matricula)) AS qtd_dispensa_disciplina, (SELECT COALESCE((max(n.modulo))::integer, 0) AS "coalesce" FROM nota_aluno n WHERE ((n.ref_cod_matricula = ma.cod_matricula) AND (n.ativo = 1))) AS maior_modulo_com_nota FROM matricula ma, matricula_turma mt WHERE ((mt.ref_cod_matricula = ma.cod_matricula) AND (mt.ativo = ma.ativo));


SET search_path = pmiotopic, pg_catalog;

--
-- Name: funcionario_su; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE funcionario_su (
    ref_ref_cod_pessoa_fj integer NOT NULL
);


--
-- Name: grupomoderador; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE grupomoderador (
    ref_ref_cod_pessoa_fj integer NOT NULL,
    ref_cod_grupos integer NOT NULL,
    ref_pessoa_exc integer,
    ref_pessoa_cad integer NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: grupopessoa; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE grupopessoa (
    ref_idpes integer NOT NULL,
    ref_cod_grupos integer NOT NULL,
    ref_grupos_exc integer,
    ref_pessoa_exc integer,
    ref_grupos_cad integer,
    ref_pessoa_cad integer,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_cod_auxiliar_cad integer,
    ref_ref_cod_atendimento_cad integer
);


--
-- Name: grupos_cod_grupos_seq; Type: SEQUENCE; Schema: pmiotopic; Owner: -
--

CREATE SEQUENCE grupos_cod_grupos_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: grupos_cod_grupos_seq; Type: SEQUENCE SET; Schema: pmiotopic; Owner: -
--

SELECT pg_catalog.setval('grupos_cod_grupos_seq', 1, false);


--
-- Name: grupos; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE grupos (
    cod_grupos integer DEFAULT nextval('grupos_cod_grupos_seq'::regclass) NOT NULL,
    ref_pessoa_exc integer,
    ref_pessoa_cad integer NOT NULL,
    nm_grupo character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    atendimento smallint DEFAULT 0 NOT NULL
);


--
-- Name: notas; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE notas (
    sequencial integer NOT NULL,
    ref_idpes integer NOT NULL,
    ref_pessoa_exc integer,
    ref_pessoa_cad integer NOT NULL,
    nota text NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: participante; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE participante (
    sequencial integer NOT NULL,
    ref_ref_cod_grupos integer NOT NULL,
    ref_ref_idpes integer NOT NULL,
    ref_cod_reuniao integer NOT NULL,
    data_chegada timestamp without time zone NOT NULL,
    data_saida timestamp without time zone
);


--
-- Name: reuniao_cod_reuniao_seq; Type: SEQUENCE; Schema: pmiotopic; Owner: -
--

CREATE SEQUENCE reuniao_cod_reuniao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: reuniao_cod_reuniao_seq; Type: SEQUENCE SET; Schema: pmiotopic; Owner: -
--

SELECT pg_catalog.setval('reuniao_cod_reuniao_seq', 1, false);


--
-- Name: reuniao; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE reuniao (
    cod_reuniao integer DEFAULT nextval('reuniao_cod_reuniao_seq'::regclass) NOT NULL,
    ref_grupos_moderador integer NOT NULL,
    ref_moderador integer NOT NULL,
    data_inicio_marcado timestamp without time zone NOT NULL,
    data_fim_marcado timestamp without time zone NOT NULL,
    data_inicio_real timestamp without time zone,
    data_fim_real timestamp without time zone,
    descricao text NOT NULL,
    email_enviado timestamp without time zone,
    publica smallint DEFAULT 0 NOT NULL
);


--
-- Name: topico_cod_topico_seq; Type: SEQUENCE; Schema: pmiotopic; Owner: -
--

CREATE SEQUENCE topico_cod_topico_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: topico_cod_topico_seq; Type: SEQUENCE SET; Schema: pmiotopic; Owner: -
--

SELECT pg_catalog.setval('topico_cod_topico_seq', 1, false);


--
-- Name: topico; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE topico (
    cod_topico integer DEFAULT nextval('topico_cod_topico_seq'::regclass) NOT NULL,
    ref_idpes_cad integer NOT NULL,
    ref_cod_grupos_cad integer NOT NULL,
    assunto character varying(255) NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_exclusao timestamp without time zone,
    ativo smallint DEFAULT (1)::smallint NOT NULL,
    ref_idpes_exc integer,
    ref_cod_grupos_exc integer
);


--
-- Name: topicoreuniao; Type: TABLE; Schema: pmiotopic; Owner: -; Tablespace:
--

CREATE TABLE topicoreuniao (
    ref_cod_topico integer NOT NULL,
    ref_cod_reuniao integer NOT NULL,
    parecer text,
    finalizado smallint,
    data_parecer timestamp without time zone
);


SET search_path = portal, pg_catalog;

--
-- Name: acesso_cod_acesso_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE acesso_cod_acesso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: acesso_cod_acesso_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('acesso_cod_acesso_seq', 1, false);


--
-- Name: acesso; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE acesso (
    cod_acesso integer DEFAULT nextval('acesso_cod_acesso_seq'::regclass) NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    ip_externo character varying(15) DEFAULT ''::character varying NOT NULL,
    ip_interno character varying(255) DEFAULT ''::character varying NOT NULL,
    cod_pessoa integer DEFAULT 0 NOT NULL,
    obs text,
    sucesso boolean DEFAULT true NOT NULL
);


--
-- Name: agenda_cod_agenda_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE agenda_cod_agenda_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: agenda_cod_agenda_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('agenda_cod_agenda_seq', 1, false);


--
-- Name: agenda; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE agenda (
    cod_agenda integer DEFAULT nextval('agenda_cod_agenda_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_exc integer,
    ref_ref_cod_pessoa_cad integer NOT NULL,
    nm_agenda character varying NOT NULL,
    publica smallint DEFAULT 0 NOT NULL,
    envia_alerta smallint DEFAULT 0 NOT NULL,
    data_cad timestamp without time zone NOT NULL,
    data_edicao timestamp without time zone,
    ref_ref_cod_pessoa_own integer
);


--
-- Name: agenda_compromisso; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE agenda_compromisso (
    cod_agenda_compromisso integer NOT NULL,
    versao integer NOT NULL,
    ref_cod_agenda integer NOT NULL,
    ref_ref_cod_pessoa_cad integer NOT NULL,
    ativo smallint DEFAULT 1,
    data_inicio timestamp without time zone,
    titulo character varying,
    descricao text,
    importante smallint DEFAULT 0 NOT NULL,
    publico smallint DEFAULT 0 NOT NULL,
    data_cadastro timestamp without time zone NOT NULL,
    data_fim timestamp without time zone
);


--
-- Name: agenda_pref_cod_comp_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE agenda_pref_cod_comp_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: agenda_pref_cod_comp_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('agenda_pref_cod_comp_seq', 1, false);


--
-- Name: agenda_pref; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE agenda_pref (
    cod_comp integer DEFAULT nextval('agenda_pref_cod_comp_seq'::regclass) NOT NULL,
    data_comp date NOT NULL,
    hora_comp time without time zone NOT NULL,
    hora_f_comp time without time zone NOT NULL,
    comp_comp text NOT NULL,
    local_comp character(1) DEFAULT 'I'::bpchar NOT NULL,
    publico_comp character(1) DEFAULT 'S'::bpchar NOT NULL,
    agenda_de character(1) DEFAULT 'P'::bpchar,
    ref_cad integer,
    versao integer DEFAULT 1 NOT NULL,
    ref_auto_cod integer
);


--
-- Name: agenda_responsavel; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE agenda_responsavel (
    ref_cod_agenda integer NOT NULL,
    ref_ref_cod_pessoa_fj integer NOT NULL,
    principal smallint
);


--
-- Name: compras_editais_editais_cod_compras_editais_editais_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_editais_editais_cod_compras_editais_editais_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_editais_editais_cod_compras_editais_editais_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_editais_editais_cod_compras_editais_editais_seq', 1, false);


--
-- Name: compras_editais_editais; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_editais_editais (
    cod_compras_editais_editais integer DEFAULT nextval('compras_editais_editais_cod_compras_editais_editais_seq'::regclass) NOT NULL,
    ref_cod_compras_licitacoes integer DEFAULT 0 NOT NULL,
    versao integer DEFAULT 0 NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    arquivo character varying(255) DEFAULT ''::character varying NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    motivo_alteracao text,
    visivel smallint DEFAULT 1 NOT NULL
);


--
-- Name: compras_editais_editais_empresas; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_editais_editais_empresas (
    ref_cod_compras_editais_editais integer DEFAULT 0 NOT NULL,
    ref_cod_compras_editais_empresa integer DEFAULT 0 NOT NULL,
    data_hora timestamp without time zone NOT NULL
);


--
-- Name: compras_editais_empresa_cod_compras_editais_empresa_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_editais_empresa_cod_compras_editais_empresa_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_editais_empresa_cod_compras_editais_empresa_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_editais_empresa_cod_compras_editais_empresa_seq', 1, false);


--
-- Name: compras_editais_empresa; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_editais_empresa (
    cod_compras_editais_empresa integer DEFAULT nextval('compras_editais_empresa_cod_compras_editais_empresa_seq'::regclass) NOT NULL,
    cnpj character varying(20) DEFAULT ''::character varying NOT NULL,
    nm_empresa character varying(255) DEFAULT ''::character varying NOT NULL,
    email character varying(255) DEFAULT ''::character varying NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    endereco text,
    ref_sigla_uf character(2),
    cidade character varying(255),
    bairro character varying(255),
    telefone bigint,
    fax bigint,
    cep bigint,
    nome_contato character varying(255),
    senha character varying(32) DEFAULT ''::character varying NOT NULL
);


--
-- Name: compras_final_pregao_cod_compras_final_pregao_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_final_pregao_cod_compras_final_pregao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_final_pregao_cod_compras_final_pregao_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_final_pregao_cod_compras_final_pregao_seq', 1, false);


--
-- Name: compras_final_pregao; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_final_pregao (
    cod_compras_final_pregao integer DEFAULT nextval('compras_final_pregao_cod_compras_final_pregao_seq'::regclass) NOT NULL,
    nm_final character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: compras_funcionarios; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_funcionarios (
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL
);


--
-- Name: compras_licitacoes_cod_compras_licitacoes_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_licitacoes_cod_compras_licitacoes_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_licitacoes_cod_compras_licitacoes_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_licitacoes_cod_compras_licitacoes_seq', 1, false);


--
-- Name: compras_licitacoes; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_licitacoes (
    cod_compras_licitacoes integer DEFAULT nextval('compras_licitacoes_cod_compras_licitacoes_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    ref_cod_compras_modalidade integer DEFAULT 0 NOT NULL,
    numero character varying(30) DEFAULT ''::character varying NOT NULL,
    objeto text NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    cod_licitacao_semasa integer,
    oculto boolean DEFAULT false
);


--
-- Name: compras_modalidade_cod_compras_modalidade_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_modalidade_cod_compras_modalidade_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_modalidade_cod_compras_modalidade_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_modalidade_cod_compras_modalidade_seq', 1, false);


--
-- Name: compras_modalidade; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_modalidade (
    cod_compras_modalidade integer DEFAULT nextval('compras_modalidade_cod_compras_modalidade_seq'::regclass) NOT NULL,
    nm_modalidade character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: compras_pregao_execucao_cod_compras_pregao_execucao_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_pregao_execucao_cod_compras_pregao_execucao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_pregao_execucao_cod_compras_pregao_execucao_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_pregao_execucao_cod_compras_pregao_execucao_seq', 1, false);


--
-- Name: compras_pregao_execucao; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_pregao_execucao (
    cod_compras_pregao_execucao integer DEFAULT nextval('compras_pregao_execucao_cod_compras_pregao_execucao_seq'::regclass) NOT NULL,
    ref_cod_compras_licitacoes integer DEFAULT 0 NOT NULL,
    ref_pregoeiro integer DEFAULT 0 NOT NULL,
    ref_equipe1 integer DEFAULT 0 NOT NULL,
    ref_equipe2 integer DEFAULT 0 NOT NULL,
    ref_equipe3 integer DEFAULT 0 NOT NULL,
    ano_processo integer,
    mes_processo integer,
    seq_processo integer,
    seq_portaria integer,
    ano_portaria integer,
    valor_referencia double precision,
    valor_real double precision,
    ref_cod_compras_final_pregao integer
);


--
-- Name: compras_prestacao_contas_cod_compras_prestacao_contas_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE compras_prestacao_contas_cod_compras_prestacao_contas_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: compras_prestacao_contas_cod_compras_prestacao_contas_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('compras_prestacao_contas_cod_compras_prestacao_contas_seq', 1, false);


--
-- Name: compras_prestacao_contas; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE compras_prestacao_contas (
    cod_compras_prestacao_contas integer DEFAULT nextval('compras_prestacao_contas_cod_compras_prestacao_contas_seq'::regclass) NOT NULL,
    caminho character varying(255) DEFAULT ''::character varying NOT NULL,
    mes integer DEFAULT 0 NOT NULL,
    ano integer DEFAULT 0 NOT NULL
);


--
-- Name: foto_portal_cod_foto_portal_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE foto_portal_cod_foto_portal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: foto_portal_cod_foto_portal_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('foto_portal_cod_foto_portal_seq', 1, false);


--
-- Name: foto_portal; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE foto_portal (
    cod_foto_portal integer DEFAULT nextval('foto_portal_cod_foto_portal_seq'::regclass) NOT NULL,
    ref_cod_foto_secao integer,
    ref_cod_credito integer,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    data_foto timestamp without time zone,
    titulo character varying(255),
    descricao text,
    caminho character varying(255),
    altura integer,
    largura integer,
    nm_credito character varying(255),
    bkp_ref_secao bigint
);


--
-- Name: foto_secao_cod_foto_secao_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE foto_secao_cod_foto_secao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: foto_secao_cod_foto_secao_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('foto_secao_cod_foto_secao_seq', 1, false);


--
-- Name: foto_secao; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE foto_secao (
    cod_foto_secao integer DEFAULT nextval('foto_secao_cod_foto_secao_seq'::regclass) NOT NULL,
    nm_secao character varying(255)
);


--
-- Name: funcionario; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE funcionario (
    ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    matricula character varying(12),
    senha character varying(32),
    ativo smallint,
    ref_sec integer,
    ramal character varying(10),
    sequencial character(3),
    opcao_menu text,
    ref_cod_setor integer,
    ref_cod_funcionario_vinculo integer,
    tempo_expira_senha integer,
    tempo_expira_conta integer,
    data_troca_senha date,
    data_reativa_conta date,
    ref_ref_cod_pessoa_fj integer,
    proibido integer DEFAULT 0 NOT NULL,
    ref_cod_setor_new integer,
    matricula_new bigint,
    matricula_permanente smallint DEFAULT 0,
    tipo_menu smallint DEFAULT 0 NOT NULL,
    ip_logado character varying(15),
    data_login timestamp without time zone
);


--
-- Name: funcionario_vinculo_cod_funcionario_vinculo_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE funcionario_vinculo_cod_funcionario_vinculo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: funcionario_vinculo_cod_funcionario_vinculo_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('funcionario_vinculo_cod_funcionario_vinculo_seq', 1, false);


--
-- Name: funcionario_vinculo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE funcionario_vinculo (
    cod_funcionario_vinculo integer DEFAULT nextval('funcionario_vinculo_cod_funcionario_vinculo_seq'::regclass) NOT NULL,
    nm_vinculo character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: imagem_cod_imagem_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE imagem_cod_imagem_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: imagem_cod_imagem_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('imagem_cod_imagem_seq', 186, true);


--
-- Name: imagem; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE imagem (
    cod_imagem integer DEFAULT nextval('imagem_cod_imagem_seq'::regclass) NOT NULL,
    ref_cod_imagem_tipo integer NOT NULL,
    caminho character varying(255) NOT NULL,
    nm_imagem character varying(100),
    extensao character(3) NOT NULL,
    altura integer,
    largura integer,
    data_cadastro timestamp without time zone NOT NULL,
    ref_cod_pessoa_cad integer NOT NULL,
    data_exclusao timestamp without time zone,
    ref_cod_pessoa_exc integer
);


--
-- Name: imagem_tipo_cod_imagem_tipo_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE imagem_tipo_cod_imagem_tipo_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: imagem_tipo_cod_imagem_tipo_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('imagem_tipo_cod_imagem_tipo_seq', 6, true);


--
-- Name: imagem_tipo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE imagem_tipo (
    cod_imagem_tipo integer DEFAULT nextval('imagem_tipo_cod_imagem_tipo_seq'::regclass) NOT NULL,
    nm_tipo character varying(100) NOT NULL
);


--
-- Name: intranet_segur_permissao_nega_cod_intranet_segur_permissao__seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE intranet_segur_permissao_nega_cod_intranet_segur_permissao__seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: intranet_segur_permissao_nega_cod_intranet_segur_permissao__seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('intranet_segur_permissao_nega_cod_intranet_segur_permissao__seq', 1, false);


--
-- Name: intranet_segur_permissao_negada; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE intranet_segur_permissao_negada (
    cod_intranet_segur_permissao_negada integer DEFAULT nextval('intranet_segur_permissao_nega_cod_intranet_segur_permissao__seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer,
    ip_externo character varying(15) DEFAULT ''::character varying NOT NULL,
    ip_interno character varying(255),
    data_hora timestamp without time zone NOT NULL,
    pagina character varying(255),
    variaveis text
);


--
-- Name: jor_arquivo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE jor_arquivo (
    ref_cod_jor_edicao integer DEFAULT 0 NOT NULL,
    jor_arquivo smallint DEFAULT (0)::smallint NOT NULL,
    jor_caminho character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: jor_edicao_cod_jor_edicao_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE jor_edicao_cod_jor_edicao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: jor_edicao_cod_jor_edicao_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('jor_edicao_cod_jor_edicao_seq', 1, false);


--
-- Name: jor_edicao; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE jor_edicao (
    cod_jor_edicao integer DEFAULT nextval('jor_edicao_cod_jor_edicao_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    jor_ano_edicao character varying(5) DEFAULT ''::character varying NOT NULL,
    jor_edicao integer DEFAULT 0 NOT NULL,
    jor_dt_inicial date NOT NULL,
    jor_dt_final date,
    jor_extra smallint DEFAULT (0)::smallint
);


--
-- Name: mailling_email_cod_mailling_email_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE mailling_email_cod_mailling_email_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: mailling_email_cod_mailling_email_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('mailling_email_cod_mailling_email_seq', 1, false);


--
-- Name: mailling_email; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE mailling_email (
    cod_mailling_email integer DEFAULT nextval('mailling_email_cod_mailling_email_seq'::regclass) NOT NULL,
    nm_pessoa character varying(255) DEFAULT ''::character varying NOT NULL,
    email character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: mailling_email_conteudo_cod_mailling_email_conteudo_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE mailling_email_conteudo_cod_mailling_email_conteudo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: mailling_email_conteudo_cod_mailling_email_conteudo_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('mailling_email_conteudo_cod_mailling_email_conteudo_seq', 1, false);


--
-- Name: mailling_email_conteudo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE mailling_email_conteudo (
    cod_mailling_email_conteudo integer DEFAULT nextval('mailling_email_conteudo_cod_mailling_email_conteudo_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    conteudo text NOT NULL,
    nm_remetente character varying(255),
    email_remetente character varying(255),
    assunto character varying(255)
);


--
-- Name: mailling_fila_envio_cod_mailling_fila_envio_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE mailling_fila_envio_cod_mailling_fila_envio_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: mailling_fila_envio_cod_mailling_fila_envio_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('mailling_fila_envio_cod_mailling_fila_envio_seq', 1, false);


--
-- Name: mailling_fila_envio; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE mailling_fila_envio (
    cod_mailling_fila_envio integer DEFAULT nextval('mailling_fila_envio_cod_mailling_fila_envio_seq'::regclass) NOT NULL,
    ref_cod_mailling_email_conteudo integer DEFAULT 0 NOT NULL,
    ref_cod_mailling_email integer,
    ref_ref_cod_pessoa_fj integer,
    data_cadastro timestamp without time zone NOT NULL,
    data_envio timestamp without time zone
);


--
-- Name: mailling_grupo_cod_mailling_grupo_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE mailling_grupo_cod_mailling_grupo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: mailling_grupo_cod_mailling_grupo_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('mailling_grupo_cod_mailling_grupo_seq', 1, false);


--
-- Name: mailling_grupo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE mailling_grupo (
    cod_mailling_grupo integer DEFAULT nextval('mailling_grupo_cod_mailling_grupo_seq'::regclass) NOT NULL,
    nm_grupo character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: mailling_grupo_email; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE mailling_grupo_email (
    ref_cod_mailling_email integer DEFAULT 0 NOT NULL,
    ref_cod_mailling_grupo integer DEFAULT 0 NOT NULL
);


--
-- Name: mailling_historico_cod_mailling_historico_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE mailling_historico_cod_mailling_historico_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: mailling_historico_cod_mailling_historico_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('mailling_historico_cod_mailling_historico_seq', 1, false);


--
-- Name: mailling_historico; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE mailling_historico (
    cod_mailling_historico integer DEFAULT nextval('mailling_historico_cod_mailling_historico_seq'::regclass) NOT NULL,
    ref_cod_not_portal integer DEFAULT 0 NOT NULL,
    ref_cod_mailling_grupo integer DEFAULT 0 NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    data_hora timestamp without time zone NOT NULL
);


--
-- Name: menu_funcionario; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE menu_funcionario (
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    cadastra smallint DEFAULT (0)::smallint NOT NULL,
    exclui smallint DEFAULT (0)::smallint NOT NULL,
    ref_cod_menu_submenu integer DEFAULT 0 NOT NULL
);


--
-- Name: menu_menu_cod_menu_menu_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE menu_menu_cod_menu_menu_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: menu_menu_cod_menu_menu_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('menu_menu_cod_menu_menu_seq', 68, true);


--
-- Name: menu_menu; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE menu_menu (
    cod_menu_menu integer DEFAULT nextval('menu_menu_cod_menu_menu_seq'::regclass) NOT NULL,
    nm_menu character varying(255) DEFAULT ''::character varying NOT NULL,
    title character varying(255),
    ref_cod_menu_pai integer
);


--
-- Name: menu_submenu_cod_menu_submenu_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE menu_submenu_cod_menu_submenu_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: menu_submenu_cod_menu_submenu_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('menu_submenu_cod_menu_submenu_seq', 944, true);


--
-- Name: menu_submenu; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE menu_submenu (
    cod_menu_submenu integer DEFAULT nextval('menu_submenu_cod_menu_submenu_seq'::regclass) NOT NULL,
    ref_cod_menu_menu integer,
    cod_sistema integer,
    nm_submenu character varying(100) DEFAULT ''::character varying NOT NULL,
    arquivo character varying(255) DEFAULT ''::character varying NOT NULL,
    title text,
    nivel smallint DEFAULT (3)::smallint NOT NULL
);


--
-- Name: not_portal_cod_not_portal_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE not_portal_cod_not_portal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: not_portal_cod_not_portal_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('not_portal_cod_not_portal_seq', 1, false);


--
-- Name: not_portal; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE not_portal (
    cod_not_portal integer DEFAULT nextval('not_portal_cod_not_portal_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    titulo character varying(255),
    descricao text,
    data_noticia timestamp without time zone NOT NULL
);


--
-- Name: not_portal_tipo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE not_portal_tipo (
    ref_cod_not_portal integer DEFAULT 0 NOT NULL,
    ref_cod_not_tipo integer DEFAULT 0 NOT NULL
);


--
-- Name: not_tipo_cod_not_tipo_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE not_tipo_cod_not_tipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: not_tipo_cod_not_tipo_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('not_tipo_cod_not_tipo_seq', 1, false);


--
-- Name: not_tipo; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE not_tipo (
    cod_not_tipo integer DEFAULT nextval('not_tipo_cod_not_tipo_seq'::regclass) NOT NULL,
    nm_tipo character varying(255) DEFAULT ''::character varying NOT NULL
);


--
-- Name: not_vinc_portal; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE not_vinc_portal (
    ref_cod_not_portal integer DEFAULT 0 NOT NULL,
    vic_num integer DEFAULT 0 NOT NULL,
    tipo character(1) DEFAULT 'F'::bpchar NOT NULL,
    cod_vinc integer,
    caminho character varying(255),
    nome_arquivo character varying(255)
);


--
-- Name: notificacao_cod_notificacao_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE notificacao_cod_notificacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: notificacao_cod_notificacao_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('notificacao_cod_notificacao_seq', 1, false);


--
-- Name: notificacao; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE notificacao (
    cod_notificacao integer DEFAULT nextval('notificacao_cod_notificacao_seq'::regclass) NOT NULL,
    ref_cod_funcionario integer NOT NULL,
    titulo character varying,
    conteudo text,
    data_hora_ativa timestamp without time zone,
    url character varying,
    visualizacoes smallint DEFAULT 0 NOT NULL
);


--
-- Name: pessoa_atividade_cod_pessoa_atividade_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE pessoa_atividade_cod_pessoa_atividade_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: pessoa_atividade_cod_pessoa_atividade_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('pessoa_atividade_cod_pessoa_atividade_seq', 1, false);


--
-- Name: pessoa_atividade; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE pessoa_atividade (
    cod_pessoa_atividade integer DEFAULT nextval('pessoa_atividade_cod_pessoa_atividade_seq'::regclass) NOT NULL,
    ref_cod_ramo_atividade integer DEFAULT 0 NOT NULL,
    nm_atividade character varying(255)
);


--
-- Name: pessoa_fj_cod_pessoa_fj_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE pessoa_fj_cod_pessoa_fj_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: pessoa_fj_cod_pessoa_fj_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('pessoa_fj_cod_pessoa_fj_seq', 1, false);


--
-- Name: pessoa_fj; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE pessoa_fj (
    cod_pessoa_fj integer DEFAULT nextval('pessoa_fj_cod_pessoa_fj_seq'::regclass) NOT NULL,
    nm_pessoa character varying(255) DEFAULT ''::character varying NOT NULL,
    id_federal character varying(30),
    endereco text,
    cep character varying(9),
    ref_bairro integer,
    ddd_telefone_1 integer,
    telefone_1 character varying(15),
    ddd_telefone_2 integer,
    telefone_2 character varying(15),
    ddd_telefone_mov integer,
    telefone_mov character varying(15),
    ddd_telefone_fax integer,
    telefone_fax character varying(15),
    email character varying(255),
    http character varying(255),
    tipo_pessoa character(1) DEFAULT 'F'::bpchar NOT NULL,
    sexo smallint,
    razao_social character varying(255),
    ins_est character varying(30),
    ins_mun character varying(30),
    rg character varying(30),
    ref_cod_pessoa_pai integer,
    ref_cod_pessoa_mae integer,
    data_nasc date,
    ref_ref_cod_pessoa_fj integer
);


--
-- Name: pessoa_fj_pessoa_atividade; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE pessoa_fj_pessoa_atividade (
    ref_cod_pessoa_atividade integer DEFAULT 0 NOT NULL,
    ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL
);


--
-- Name: pessoa_ramo_atividade_cod_ramo_atividade_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE pessoa_ramo_atividade_cod_ramo_atividade_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: pessoa_ramo_atividade_cod_ramo_atividade_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('pessoa_ramo_atividade_cod_ramo_atividade_seq', 1, false);


--
-- Name: pessoa_ramo_atividade; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE pessoa_ramo_atividade (
    cod_ramo_atividade integer DEFAULT nextval('pessoa_ramo_atividade_cod_ramo_atividade_seq'::regclass) NOT NULL,
    nm_ramo_atividade character varying(255)
);


--
-- Name: portal_banner_cod_portal_banner_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE portal_banner_cod_portal_banner_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: portal_banner_cod_portal_banner_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('portal_banner_cod_portal_banner_seq', 1, false);


--
-- Name: portal_banner; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE portal_banner (
    cod_portal_banner integer DEFAULT nextval('portal_banner_cod_portal_banner_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    caminho character varying(255) DEFAULT ''::character varying NOT NULL,
    title character varying(255),
    prioridade integer DEFAULT 0 NOT NULL,
    link character varying(255) DEFAULT ''::character varying NOT NULL,
    lateral smallint DEFAULT (1)::smallint NOT NULL
);


--
-- Name: portal_concurso_cod_portal_concurso_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE portal_concurso_cod_portal_concurso_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: portal_concurso_cod_portal_concurso_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('portal_concurso_cod_portal_concurso_seq', 1, false);


--
-- Name: portal_concurso; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE portal_concurso (
    cod_portal_concurso integer DEFAULT nextval('portal_concurso_cod_portal_concurso_seq'::regclass) NOT NULL,
    ref_ref_cod_pessoa_fj integer DEFAULT 0 NOT NULL,
    nm_concurso character varying(255) DEFAULT ''::character varying NOT NULL,
    descricao text,
    caminho character varying(255) DEFAULT ''::character varying NOT NULL,
    tipo_arquivo character(3) DEFAULT ''::bpchar NOT NULL,
    data_hora timestamp without time zone
);


--
-- Name: sistema_cod_sistema_seq; Type: SEQUENCE; Schema: portal; Owner: -
--

CREATE SEQUENCE sistema_cod_sistema_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: sistema_cod_sistema_seq; Type: SEQUENCE SET; Schema: portal; Owner: -
--

SELECT pg_catalog.setval('sistema_cod_sistema_seq', 1, false);


--
-- Name: sistema; Type: TABLE; Schema: portal; Owner: -; Tablespace:
--

CREATE TABLE sistema (
    cod_sistema integer DEFAULT nextval('sistema_cod_sistema_seq'::regclass) NOT NULL,
    nome character varying(255),
    versao smallint NOT NULL,
    release smallint NOT NULL,
    patch smallint NOT NULL,
    tipo character varying(255)
);


--
-- Name: v_funcionario; Type: VIEW; Schema: portal; Owner: -
--

CREATE VIEW v_funcionario AS
    SELECT f.ref_cod_pessoa_fj, f.matricula, f.senha, f.ativo, f.ramal, f.sequencial, f.opcao_menu, f.ref_cod_setor, f.ref_cod_funcionario_vinculo, f.tempo_expira_senha, f.tempo_expira_conta, f.data_troca_senha, f.data_reativa_conta, f.ref_ref_cod_pessoa_fj, f.proibido, f.ref_cod_setor_new, (SELECT pessoa.nome FROM cadastro.pessoa WHERE (pessoa.idpes = (f.ref_cod_pessoa_fj)::numeric)) AS nome FROM funcionario f;


SET search_path = public, pg_catalog;

--
-- Name: bairro_regiao; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE bairro_regiao (
    ref_cod_regiao integer NOT NULL,
    ref_idbai integer NOT NULL
);


SET default_with_oids = false;

--
-- Name: changelog; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE changelog (
    change_number bigint NOT NULL,
    delta_set character varying(10) NOT NULL,
    start_dt timestamp without time zone NOT NULL,
    complete_dt timestamp without time zone,
    applied_by character varying(100) NOT NULL,
    description character varying(500) NOT NULL
);


SET default_with_oids = true;

--
-- Name: logradouro_fonetico; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE logradouro_fonetico (
    fonema character varying(30) NOT NULL,
    idlog numeric(8,0) NOT NULL
);


--
-- Name: pais; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE pais (
    idpais numeric(3,0) NOT NULL,
    nome character varying(60) NOT NULL,
    geom character varying
);


--
-- Name: regiao_cod_regiao_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE regiao_cod_regiao_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: regiao_cod_regiao_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('regiao_cod_regiao_seq', 1, false);


--
-- Name: regiao; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE regiao (
    cod_regiao integer DEFAULT nextval('regiao_cod_regiao_seq'::regclass) NOT NULL,
    nm_regiao character varying(100)
);


--
-- Name: seq_bairro; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_bairro
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: seq_bairro; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_bairro', 1, false);


--
-- Name: seq_logradouro; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_logradouro
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: seq_logradouro; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_logradouro', 1, false);


--
-- Name: seq_municipio; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE seq_municipio
    START WITH 5565
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: seq_municipio; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('seq_municipio', 5565, false);


--
-- Name: setor_idset_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE setor_idset_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


--
-- Name: setor_idset_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('setor_idset_seq', 1, false);


--
-- Name: setor; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE setor (
    idset integer DEFAULT nextval('setor_idset_seq'::regclass) NOT NULL,
    nivel numeric(1,0) NOT NULL,
    nome character varying(100) NOT NULL,
    sigla character varying(25),
    idsetsub integer,
    idsetredir integer,
    situacao character(1) NOT NULL,
    localizacao character(1) NOT NULL,
    CONSTRAINT ck_setor_localizacao CHECK (((localizacao = 'E'::bpchar) OR (localizacao = 'I'::bpchar))),
    CONSTRAINT ck_setor_situacao CHECK (((situacao = 'A'::bpchar) OR (situacao = 'I'::bpchar)))
);


--
-- Name: uf; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE uf (
    sigla_uf character(2) NOT NULL,
    nome character varying(30) NOT NULL,
    geom character varying,
    idpais numeric(3,0)
);


--
-- Name: vila; Type: TABLE; Schema: public; Owner: -; Tablespace:
--

CREATE TABLE vila (
    idvil numeric(4,0) NOT NULL,
    idmun numeric(6,0) NOT NULL,
    nome character varying(50) NOT NULL,
    geom character varying
);


SET search_path = urbano, pg_catalog;

--
-- Name: cep_logradouro; Type: TABLE; Schema: urbano; Owner: -; Tablespace:
--

CREATE TABLE cep_logradouro (
    cep numeric(8,0) NOT NULL,
    idlog numeric(6,0) NOT NULL,
    nroini numeric(6,0),
    nrofin numeric(6,0),
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_cep_logradouro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_logradouro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar)))
);


--
-- Name: cep_logradouro_bairro; Type: TABLE; Schema: urbano; Owner: -; Tablespace:
--

CREATE TABLE cep_logradouro_bairro (
    idlog numeric(6,0) NOT NULL,
    cep numeric(8,0) NOT NULL,
    idbai numeric(6,0) NOT NULL,
    idpes_rev numeric,
    data_rev timestamp without time zone,
    origem_gravacao character(1) NOT NULL,
    idpes_cad numeric,
    data_cad timestamp without time zone NOT NULL,
    operacao character(1) NOT NULL,
    idsis_rev integer,
    idsis_cad integer NOT NULL,
    CONSTRAINT ck_cep_logradouro_bairro_origem_gravacao CHECK (((((origem_gravacao = 'M'::bpchar) OR (origem_gravacao = 'U'::bpchar)) OR (origem_gravacao = 'C'::bpchar)) OR (origem_gravacao = 'O'::bpchar))),
    CONSTRAINT ck_logradouro_operacao CHECK ((((operacao = 'I'::bpchar) OR (operacao = 'A'::bpchar)) OR (operacao = 'E'::bpchar)))
);


--
-- Name: tipo_logradouro; Type: TABLE; Schema: urbano; Owner: -; Tablespace:
--

CREATE TABLE tipo_logradouro (
    idtlog character varying(5) NOT NULL,
    descricao character varying(40) NOT NULL
);


SET search_path = modules, pg_catalog;

--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE area_conhecimento ALTER COLUMN id SET DEFAULT nextval('area_conhecimento_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE componente_curricular ALTER COLUMN id SET DEFAULT nextval('componente_curricular_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE docente_licenciatura ALTER COLUMN id SET DEFAULT nextval('docente_licenciatura_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE educacenso_curso_superior ALTER COLUMN id SET DEFAULT nextval('educacenso_curso_superior_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE educacenso_ies ALTER COLUMN id SET DEFAULT nextval('educacenso_ies_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE falta_aluno ALTER COLUMN id SET DEFAULT nextval('falta_aluno_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE falta_componente_curricular ALTER COLUMN id SET DEFAULT nextval('falta_componente_curricular_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE falta_geral ALTER COLUMN id SET DEFAULT nextval('falta_geral_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE formula_media ALTER COLUMN id SET DEFAULT nextval('formula_media_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE nota_aluno ALTER COLUMN id SET DEFAULT nextval('nota_aluno_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE nota_componente_curricular ALTER COLUMN id SET DEFAULT nextval('nota_componente_curricular_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE parecer_aluno ALTER COLUMN id SET DEFAULT nextval('parecer_aluno_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE parecer_componente_curricular ALTER COLUMN id SET DEFAULT nextval('parecer_componente_curricular_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE parecer_geral ALTER COLUMN id SET DEFAULT nextval('parecer_geral_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE regra_avaliacao ALTER COLUMN id SET DEFAULT nextval('regra_avaliacao_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE tabela_arredondamento ALTER COLUMN id SET DEFAULT nextval('tabela_arredondamento_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: modules; Owner: -
--

ALTER TABLE tabela_arredondamento_valor ALTER COLUMN id SET DEFAULT nextval('tabela_arredondamento_valor_id_seq'::regclass);


SET search_path = acesso, pg_catalog;

--
-- Data for Name: funcao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: grupo; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: grupo_funcao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: grupo_menu; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: grupo_operacao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: grupo_sistema; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: historico_senha; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: instituicao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: log_acesso; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: log_erro; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: menu; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: operacao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: operacao_funcao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: pessoa_instituicao; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: sistema; Type: TABLE DATA; Schema: acesso; Owner: -
--

INSERT INTO sistema VALUES (1, 'i-Educar', 'Sistema bsico', '', 'A');
INSERT INTO sistema VALUES (9, 'Cdigo legado', 'Sistema bsico', '', 'A');
INSERT INTO sistema VALUES (17, 'Cdigo legado', 'Sistema bsico', '', 'A');


--
-- Data for Name: usuario; Type: TABLE DATA; Schema: acesso; Owner: -
--



--
-- Data for Name: usuario_grupo; Type: TABLE DATA; Schema: acesso; Owner: -
--



SET search_path = alimentos, pg_catalog;

--
-- Data for Name: baixa_guia_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: baixa_guia_remessa; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: calendario; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: cardapio; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: cardapio_faixa_unidade; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: cardapio_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: cardapio_receita; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: cliente; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: composto_quimico; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: contrato; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: contrato_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: evento; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: faixa_composto_quimico; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: faixa_etaria; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: fornecedor; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: fornecedor_unidade_atendida; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: grupo_quimico; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: guia_produto_diario; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: guia_remessa; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: guia_remessa_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: log_guia_remessa; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: medidas_caseiras; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: pessoa; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: produto_composto_quimico; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: produto_fornecedor; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: produto_medida_caseira; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: receita; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: receita_composto_quimico; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: receita_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: tipo_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: tipo_refeicao; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: tipo_unidade; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: unidade_atendida; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: unidade_faixa_etaria; Type: TABLE DATA; Schema: alimentos; Owner: -
--



--
-- Data for Name: unidade_produto; Type: TABLE DATA; Schema: alimentos; Owner: -
--



SET search_path = cadastro, pg_catalog;

--
-- Data for Name: aviso_nome; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: deficiencia; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: documento; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: endereco_externo; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: endereco_pessoa; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: escolaridade; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: estado_civil; Type: TABLE DATA; Schema: cadastro; Owner: -
--

INSERT INTO estado_civil VALUES (1, 'Solteiro(a)');
INSERT INTO estado_civil VALUES (2, 'Casado(a)');
INSERT INTO estado_civil VALUES (3, 'Divorciado(a)');
INSERT INTO estado_civil VALUES (4, 'Separado(a)');
INSERT INTO estado_civil VALUES (5, 'Vivo(a)');
INSERT INTO estado_civil VALUES (6, 'Companheiro(a)');


--
-- Data for Name: fisica; Type: TABLE DATA; Schema: cadastro; Owner: -
--

INSERT INTO fisica VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'M', NULL, 'NOW()', 'I', NULL, 1, NULL, NULL, NULL);


--
-- Data for Name: fisica_cpf; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: fisica_deficiencia; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: fisica_foto; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: fisica_raca; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: fisica_sangue; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: fone_pessoa; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: funcionario; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: historico_cartao; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: juridica; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: ocupacao; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: orgao_emissor_rg; Type: TABLE DATA; Schema: cadastro; Owner: -
--

INSERT INTO orgao_emissor_rg VALUES (1, 'SSP', 'SSP', 'I');
INSERT INTO orgao_emissor_rg VALUES (2, 'MMil', 'Ministrios Militares', 'I');
INSERT INTO orgao_emissor_rg VALUES (3, 'MAer', 'Ministrio da Aeronutica', 'I');
INSERT INTO orgao_emissor_rg VALUES (4, 'MExe', 'Ministrio do Exrcito', 'I');
INSERT INTO orgao_emissor_rg VALUES (5, 'MMar', 'Ministrio da Marinha', 'I');
INSERT INTO orgao_emissor_rg VALUES (6, 'PF', 'Polcia Federal', 'I');
INSERT INTO orgao_emissor_rg VALUES (7, 'CIC', 'Carteira de Identidade Classista', 'I');
INSERT INTO orgao_emissor_rg VALUES (8, 'CRA', 'Conselho Regional de Administrao', 'I');
INSERT INTO orgao_emissor_rg VALUES (10, 'CRB', 'Conselho Regional de Biblioteconomia', 'I');
INSERT INTO orgao_emissor_rg VALUES (11, 'CRC', 'Conselho Regional de Contabilidade', 'I');
INSERT INTO orgao_emissor_rg VALUES (12, 'CRECI', 'Conselho Regional de Corretores Imveis', 'I');
INSERT INTO orgao_emissor_rg VALUES (14, 'CREA', 'Conselho Regional de Engenharia, Arquitetura e Agronomia', 'I');
INSERT INTO orgao_emissor_rg VALUES (18, 'CRM', 'Conselho Regional de Medicina', 'I');
INSERT INTO orgao_emissor_rg VALUES (19, 'CRMV', 'Conselho Regional de Medicina Veterinria', 'I');
INSERT INTO orgao_emissor_rg VALUES (20, 'OMB', 'Ordem dos Msicos do Brasil', 'I');
INSERT INTO orgao_emissor_rg VALUES (22, 'CRO', 'Conselho Regional de Odontologia', 'I');
INSERT INTO orgao_emissor_rg VALUES (24, 'CRP', 'Conselho Regional de Psicologia', 'I');
INSERT INTO orgao_emissor_rg VALUES (25, 'CRQ', 'Conselho Regional de Qumica', 'I');
INSERT INTO orgao_emissor_rg VALUES (27, 'OAB', 'Ordem dos Advogados do Brasil', 'I');
INSERT INTO orgao_emissor_rg VALUES (28, 'OEmi', 'Outros Emissores', 'I');
INSERT INTO orgao_emissor_rg VALUES (29, 'DExt', 'Documento Estrangeiro', 'I');
INSERT INTO orgao_emissor_rg VALUES (9, 'CRESS', 'Conselho Regional de Assist. Social', 'I');
INSERT INTO orgao_emissor_rg VALUES (13, 'COREN', 'Conselho Regional de Enfermagem', 'I');
INSERT INTO orgao_emissor_rg VALUES (15, 'CONRE', 'Conselho Regional de Estatstica', 'I');
INSERT INTO orgao_emissor_rg VALUES (16, 'CRF', 'Conselho Regional de Farmcia', 'I');
INSERT INTO orgao_emissor_rg VALUES (17, 'CREFITO', 'Conselho Regional de Fisioterapia e Terapia Ocupacional', 'I');
INSERT INTO orgao_emissor_rg VALUES (21, 'CRN', 'Conselho Regional de Nutrio', 'I');
INSERT INTO orgao_emissor_rg VALUES (23, 'CONRERP', 'Conselho Regional de Profissionais de Relaes Pblicas', 'I');
INSERT INTO orgao_emissor_rg VALUES (26, 'CORE', 'Conselho Regional de Representantes Comerciais', 'I');


--
-- Data for Name: pessoa; Type: TABLE DATA; Schema: cadastro; Owner: -
--

INSERT INTO pessoa VALUES (1, 'Administrador', NULL, 'NOW()', NULL, 'F', NULL, NULL, '', 'A', 'M', 'I', NULL, 1);


--
-- Data for Name: pessoa_fonetico; Type: TABLE DATA; Schema: cadastro; Owner: -
--

INSERT INTO pessoa_fonetico VALUES (1, 'ADIMINISTIHADOH');


--
-- Data for Name: raca; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: religiao; Type: TABLE DATA; Schema: cadastro; Owner: -
--



--
-- Data for Name: socio; Type: TABLE DATA; Schema: cadastro; Owner: -
--



SET search_path = consistenciacao, pg_catalog;

--
-- Data for Name: campo_consistenciacao; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--

INSERT INTO campo_consistenciacao VALUES (1, 'CPF ou CNPJ', 'N', 14);
INSERT INTO campo_consistenciacao VALUES (2, 'Nome pessoa fsica ou jurdica', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (3, 'E-mail', 'N', 50);
INSERT INTO campo_consistenciacao VALUES (4, 'URL', 'N', 60);
INSERT INTO campo_consistenciacao VALUES (5, 'Data nascimento', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (6, 'Nmero RG', 'N', 10);
INSERT INTO campo_consistenciacao VALUES (7, 'rgo expedidor RG', 'S', 20);
INSERT INTO campo_consistenciacao VALUES (8, 'Data expedio RG', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (9, 'UF expedio RG', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (10, 'Tipo certido civil', 'S', 2);
INSERT INTO campo_consistenciacao VALUES (11, 'Nmero termo certido civil', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (12, 'Nmero livro certido civil', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (13, 'Nmero folha certido civil', 'N', 4);
INSERT INTO campo_consistenciacao VALUES (14, 'Data emisso certido civil', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (15, 'Cartrio emissor certido civil', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (16, 'UF emisso certido civil', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (17, 'Nmero carteira trabalho', 'N', 7);
INSERT INTO campo_consistenciacao VALUES (18, 'Nmero srie carteira trabalho', 'N', 5);
INSERT INTO campo_consistenciacao VALUES (19, 'Data emisso carteira trabalho', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (20, 'UF emisso carteira trabalho', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (21, 'Nmero ttulo de eleitor', 'N', 13);
INSERT INTO campo_consistenciacao VALUES (22, 'Nmero zona ttulo eleitor', 'N', 4);
INSERT INTO campo_consistenciacao VALUES (23, 'Nmero seo ttulo eleitor', 'N', 4);
INSERT INTO campo_consistenciacao VALUES (24, 'Nome fantasia pessoa jurdica', 'N', 50);
INSERT INTO campo_consistenciacao VALUES (25, 'Nmero inscrio estadual', 'N', 10);
INSERT INTO campo_consistenciacao VALUES (26, 'Sexo pessoa fsica', 'S', 10);
INSERT INTO campo_consistenciacao VALUES (27, 'Nome me', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (28, 'Nome pai', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (29, 'Nome cnjuge', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (30, 'Nome responsvel', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (31, 'Nome ltima empresa', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (32, 'Ocupao profissional', 'S', 250);
INSERT INTO campo_consistenciacao VALUES (33, 'Escolaridade', 'S', 60);
INSERT INTO campo_consistenciacao VALUES (34, 'Estado civil', 'S', 15);
INSERT INTO campo_consistenciacao VALUES (35, 'Pas de origem(se estrangeiro)', 'S', 60);
INSERT INTO campo_consistenciacao VALUES (36, 'Data chegada ao Brasil', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (37, 'Data bito', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (38, 'Data unio com cnjuge', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (39, 'DDD telefone residencial', 'N', 3);
INSERT INTO campo_consistenciacao VALUES (40, 'Telefone residencial', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (41, 'DDD telefone comercial', 'N', 3);
INSERT INTO campo_consistenciacao VALUES (42, 'Telefone comercial', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (43, 'DDD telefone celular', 'N', 3);
INSERT INTO campo_consistenciacao VALUES (44, 'Telefone celular', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (45, 'DDD fax', 'N', 3);
INSERT INTO campo_consistenciacao VALUES (46, 'Fax', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (47, 'Logradouro (end. correspondncia)', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (48, 'Tipo logradouro (end. correspondncia)', 'S', 15);
INSERT INTO campo_consistenciacao VALUES (49, 'Nmero (end. correspondncia)', 'N', 6);
INSERT INTO campo_consistenciacao VALUES (50, 'Letra (end. correspondncia)', 'N', 1);
INSERT INTO campo_consistenciacao VALUES (51, 'Complemento (end. correspondncia)', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (52, 'Bairro (end. correspondncia)', 'N', 40);
INSERT INTO campo_consistenciacao VALUES (53, 'CEP (end. correspondncia)', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (54, 'Cidade (end. correspondncia)', 'N', 60);
INSERT INTO campo_consistenciacao VALUES (55, 'UF (end. correspondncia)', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (56, 'Logradouro (end. residencial)', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (57, 'Tipo logradouro (end. residencial)', 'S', 15);
INSERT INTO campo_consistenciacao VALUES (58, 'Nmero (end. residencial)', 'N', 6);
INSERT INTO campo_consistenciacao VALUES (59, 'Letra (end. residencial)', 'N', 1);
INSERT INTO campo_consistenciacao VALUES (60, 'Complemento (end. residencial)', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (61, 'Bairro (end. residencial)', 'N', 40);
INSERT INTO campo_consistenciacao VALUES (62, 'CEP (end. residencial)', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (63, 'Cidade (end. residencial)', 'N', 60);
INSERT INTO campo_consistenciacao VALUES (64, 'UF (end. residencial)', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (65, 'Logradouro (end. comercial)', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (66, 'Tipo logradouro (end. comercial)', 'S', 15);
INSERT INTO campo_consistenciacao VALUES (67, 'Nmero (end. comercial)', 'N', 6);
INSERT INTO campo_consistenciacao VALUES (68, 'Letra (end. comercial)', 'N', 1);
INSERT INTO campo_consistenciacao VALUES (69, 'Complemento (end. comercial)', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (70, 'Bairro (end. comercial)', 'N', 40);
INSERT INTO campo_consistenciacao VALUES (71, 'CEP (end. comercial)', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (72, 'Cidade (end. comercial)', 'N', 60);
INSERT INTO campo_consistenciacao VALUES (73, 'UF (end. comercial)', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (74, 'Logradouro (correspondncia ou residencial)', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (75, 'Tipo logradouro (correspondncia ou residencial)', 'S', 15);
INSERT INTO campo_consistenciacao VALUES (76, 'Nmero (correspondncia ou residencial)', 'N', 6);
INSERT INTO campo_consistenciacao VALUES (77, 'Letra (correspondncia ou residencial)', 'N', 1);
INSERT INTO campo_consistenciacao VALUES (78, 'Complemento (correspondncia ou residencial)', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (79, 'Bairro (correspondncia ou residencial)', 'N', 40);
INSERT INTO campo_consistenciacao VALUES (80, 'CEP (correspondncia ou residencial)', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (81, 'Cidade (correspondncia ou residencial)', 'N', 60);
INSERT INTO campo_consistenciacao VALUES (82, 'UF (correspondncia ou residencial)', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (83, 'Logradouro (correspondncia ou comercial)', 'N', 150);
INSERT INTO campo_consistenciacao VALUES (84, 'Tipo logradouro (correspondncia ou comercial)', 'S', 15);
INSERT INTO campo_consistenciacao VALUES (85, 'Nmero (correspondncia ou comercial)', 'N', 6);
INSERT INTO campo_consistenciacao VALUES (86, 'Letra (correspondncia ou comercial)', 'N', 1);
INSERT INTO campo_consistenciacao VALUES (87, 'Complemento (correspondncia ou comercial)', 'N', 20);
INSERT INTO campo_consistenciacao VALUES (88, 'Bairro (correspondncia ou comercial)', 'N', 40);
INSERT INTO campo_consistenciacao VALUES (89, 'CEP (correspondncia ou comercial)', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (90, 'Cidade (correspondncia ou comercial)', 'N', 60);
INSERT INTO campo_consistenciacao VALUES (91, 'UF (correspondncia ou comercial)', 'S', 30);
INSERT INTO campo_consistenciacao VALUES (92, 'DDD telefone comercial ou residencial', 'N', 3);
INSERT INTO campo_consistenciacao VALUES (93, 'Telefone comercial ou residencial', 'N', 8);
INSERT INTO campo_consistenciacao VALUES (94, 'CPF', 'N', 14);
INSERT INTO campo_consistenciacao VALUES (95, 'CNPJ', 'N', 14);


--
-- Data for Name: campo_metadado; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: confrontacao; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: fonte; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: historico_campo; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--

INSERT INTO historico_campo VALUES (1, 2, 2, 'NOW()');
INSERT INTO historico_campo VALUES (1, 3, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 4, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 5, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 38, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 37, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 36, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 27, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 28, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 29, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 30, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 31, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 26, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 32, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 33, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 34, 5, 'NOW()');
INSERT INTO historico_campo VALUES (1, 35, 5, 'NOW()');


--
-- Data for Name: incoerencia; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: incoerencia_documento; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: incoerencia_endereco; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: incoerencia_fone; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: incoerencia_pessoa_possivel; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: incoerencia_tipo_incoerencia; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: metadado; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: ocorrencia_regra_campo; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: regra_campo; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: temp_cadastro_unificacao_cmf; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: temp_cadastro_unificacao_siam; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



--
-- Data for Name: tipo_incoerencia; Type: TABLE DATA; Schema: consistenciacao; Owner: -
--



SET search_path = historico, pg_catalog;

--
-- Data for Name: bairro; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: cep_logradouro; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: cep_logradouro_bairro; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: documento; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: endereco_externo; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: endereco_pessoa; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: fisica; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: fisica_cpf; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: fone_pessoa; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: funcionario; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: juridica; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: logradouro; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: municipio; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: pessoa; Type: TABLE DATA; Schema: historico; Owner: -
--



--
-- Data for Name: socio; Type: TABLE DATA; Schema: historico; Owner: -
--



SET search_path = modules, pg_catalog;

--
-- Data for Name: area_conhecimento; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: calendario_turma; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: componente_curricular; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: componente_curricular_ano_escolar; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: componente_curricular_turma; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: docente_licenciatura; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: educacenso_cod_aluno; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: educacenso_cod_docente; Type: TABLE DATA; Schema: modules; Owner: -
--



--
-- Data for Name: educacenso_curso_superior; Type: TABLE DATA; Schema: modules; Owner: -
--

INSERT INTO educacenso_curso_superior VALUES (1, '142C01', 'Cincias da educao', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (2, '143F01', 'Formao de professor de creche', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (3, '143F02', 'Formao de professor de educao infantil', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (4, '143F03', 'Formao de professor de pr-escola', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (5, '144F01', 'Formao de professor das sries finais do ensino fundamental', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (6, '144F02', 'Formao de professor das sries iniciais do ensino fundamental', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (7, '144F03', 'Formao de professor de alfabetizao', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (8, '144F04', 'Formao de professor de educao especial', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (9, '144F05', 'Formao de professor de educao infantil e sries iniciais do ensino fundamental', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (10, '144F06', 'Formao de professor do ensino fundamental', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (11, '144F07', 'Formao de professor do ensino mdio', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (12, '144F08', 'Formao de professor de jovens e adultos', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (13, '144F11', 'Formao de professor para a educao bsica', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (14, '144N01', 'Normal superior', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (15, '145F01', 'Formao de professor de biologia', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (16, '145F02', 'Formao de professor de cincias', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (17, '145F05', 'Formao de professor de educao religiosa', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (18, '145F07', 'Formao de professor de estudos sociais', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (19, '145F08', 'Formao de professor de filosofia', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (20, '145F09', 'Formao de professor de fsica', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (21, '145F10', 'Formao de professor de geografia', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (22, '145F11', 'Formao de professor de histria', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (23, '145F13', 'Formao de professor de lngua estrangeira', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (24, '145F15', 'Formao de professor de portugus', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (25, '145F16', 'Formao de professor de portugus e lngua estrangeira', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (26, '145F18', 'Formao de professor de matemtica', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (27, '145F21', 'Formao de professor de qumica', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (28, '145F24', 'Formao de professor de sociologia', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (29, '145F25', 'Formao de professor em cincias sociais', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (30, '146A01', 'Formao de professor de disciplinas profissionais - AMBIENTE, SADE E SEGURANA', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (31, '146E01', 'Formao de professor de disciplinas profissionais - APOIO EDUCACIONAL', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (32, '146P01', 'Formao de professor de disciplinas profissionais - CONTROLE E PROCESSOS INDUSTRIAIS', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (33, '146G01', 'Formao de professor de disciplinas profissionais - GESTO E NEGCIOS', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (34, '146C01', 'Formao de professor de disciplinas profissionais - INFORMAO E COMUNICAO', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (35, '146I01', 'Formao de professor de disciplinas profissionais - INFRA-ESTRUTURA', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (36, '146D01', 'Formao de professor de disciplinas profissionais - PRODUO CULTURAL E DESIGN', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (37, '146N01', 'Formao de professor de disciplinas profissionais - RECURSOS NATURAIS', 1, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (38, '210A01', 'Artes', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (39, '212999', 'Msica e artes cnicas', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (40, '213999', 'Tcnicas audiovisuais e produo de mdia', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (41, '214999', 'Design e estilismo', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (42, '215999', 'Artesanato', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (43, '220H01', 'Humanidades', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (44, '220L01', 'Letras', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (45, '220P01', 'Letras portugus', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (46, '220E01', 'Letras lnguas estrangeiras', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (47, '220L03', 'Letras portugus e lnguas estrangeiras', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (48, '221999', 'Religio e teologia', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (49, '225A01', 'Arqueologia', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (50, '225H01', 'Histria', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (51, '225M01', 'Museologia', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (52, '226999', 'Filosofia e tica', 2, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (53, '312999', 'Sociologia e estudos culturais', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (54, '311P02', 'Psicologia', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (55, '313999', 'Cincia poltica e educao cvica', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (56, '314E02', 'Economia', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (57, '321999', 'Jornalismo e reportagem', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (58, '322999', 'Biblioteconomia, informao, arquivos', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (59, '341999', 'Vendas em atacado e varejo', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (60, '342999', 'Marketing e publicidade', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (61, '343F01', 'Finanas, bancos, seguros', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (62, '344999', 'Contabilidade e tributao', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (63, '345999', 'Gerenciamento e administrao', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (64, '346999', 'Secretariado e trabalhos de escritrio', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (65, '347V01', 'Vida profissional', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (66, '380D01', 'Direito', 3, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (67, '420C01', 'Cincias', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (68, '421B01', 'Biofsica', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (69, '421B02', 'Biologia', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (70, '421B07', 'Biomedicina', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (71, '421B09', 'Bioqumica', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (72, '441F01', 'Fsica', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (73, '442Q01', 'Qumica', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (74, '443999', 'Cincias da terra', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (75, '443G04', 'Geografia', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (76, '443M01', 'Meteorologia', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (77, '443P01', 'Paleontologia', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (78, '461M01', 'Matemtica', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (79, '462E01', 'Estatstica', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (80, '481C01', 'Cincia da computao', 4, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (81, '520999', 'Engenharia e profisses de engenharia', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (82, '520D01', 'Desenho industrial', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (83, '521999', 'Engenharia mecnica e metalurgia (trabalhos com metais)', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (84, '522999', 'Eletricidade e energia', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (85, '523999', 'Eletrnica e automao', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (86, '523E04', 'Engenharia de computao', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (87, '523E04', 'Engenharia de redes de comunicao', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (88, '524999', 'Qumica e engenharia de processos', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (89, '524E02', 'Engenharia de biotecnologia', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (90, '524E06', 'Engenharia nuclear', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (91, '525999', 'Veculos a motor, construo naval e aeronutica', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (92, '540F01', 'Fabricao e processamento', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (93, '541P04', 'Processamento de alimentos e bebidas', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (94, '542999', 'Txteis, roupas, calados, couros', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (95, '543999', 'Materiais (madeira, papel, plstico, vidro)', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (96, '544M02', 'Minerao e extrao', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (97, '581A05', 'Arquitetura e urbanismo', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (98, '582999', 'Engenharia civil e de construo', 5, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (99, '621999', 'Produo agrcola e pecuria', 6, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (100, '623E01', 'Engenharia florestal - silvicultura', 6, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (101, '624999', 'Recursos pesqueiros', 6, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (102, '641999', 'Veterinria', 6, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (103, '720S01', 'Sade', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (104, '813E01', 'Educao fsica', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (105, '721M01', 'Medicina', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (106, '723999', 'Enfermagem e ateno primria (assistncia bsica)', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (107, '724O01', 'Odontologia', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (108, '726999', 'Terapia e reabilitao', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (109, '726F01', 'Fisioterapia', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (110, '726F03', 'Fonoaudiologia', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (111, '726N02', 'Nutrio', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (112, '727F01', 'Farmcia', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (113, '762999', 'Servio social e orientao', 7, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (114, '811999', 'Hotelaria, restaurantes  e servios de alimentao', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (115, '812999', 'Viagens, turismo e lazer', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (116, '813E01', 'Esportes', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (117, '814C01', 'Cincias domsticas', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (118, '815999', 'Servios de beleza', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (119, '840999', 'Transportes e servios', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (120, '850999', 'Proteo ambiental e saneamento', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (121, '861999', 'Proteo de pessoas e de propriedades', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (122, '862999', 'Sade e segurana do trabalho', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (123, '863999', 'Setor militar e de defesa', 8, 1, 'NOW()', NULL);
INSERT INTO educacenso_curso_superior VALUES (124, '999999', 'Outro curso de formao superior', 9, 1, 'NOW()', NULL);


--
-- Data for Name: educacenso_ies; Type: TABLE DATA; Schema: modules; Owner: -
--

INSERT INTO educacenso_ies VALUES (1, 1, 'UNIVERSIDADE FEDERAL DE MATO GROSSO', 1, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2, 2, 'UNIVERSIDADE DE BRASLIA', 1, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3, 3, 'UNIVERSIDADE FEDERAL DE SERGIPE', 1, 1, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (4, 4, 'UNIVERSIDADE FEDERAL DO AMAZONAS', 1, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (5, 5, 'UNIVERSIDADE FEDERAL DO PIAU', 1, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (6, 6, 'UNIVERSIDADE FEDERAL DE OURO PRETO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (7, 7, 'UNIVERSIDADE FEDERAL DE SO CARLOS', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (8, 8, 'FUNDAO UNIVERSIDADE FEDERAL DE VIOSA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (9, 9, 'UNIVERSIDADE ESTADUAL DE LONDRINA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (10, 10, 'PONTIFCIA UNIVERSIDADE CATLICA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (11, 11, 'UNIVERSIDADE CATLICA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (12, 12, 'FUNDAO UNIVERSIDADE FEDERAL DO RIO GRANDE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (13, 13, 'UNIVERSIDADE DE CAXIAS DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (14, 14, 'UNIVERSIDADE DO VALE DO RIO DOS SINOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (15, 15, 'UNIVERSIDADE CATLICA DE PETRPOLIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (16, 16, 'UNIVERSIDADE GAMA FILHO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (17, 17, 'UNIVERSIDADE FEDERAL DE UBERLNDIA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (18, 18, 'UNIVERSIDADE CATLICA DE PELOTAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (19, 19, 'PONTIFCIA UNIVERSIDADE CATLICA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (20, 20, 'UNIVERSIDADE DE PASSO FUNDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (21, 21, 'PONTIFCIA UNIVERSIDADE CATLICA DO RIO GRANDE DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (22, 22, 'UNIVERSIDADE PRESBITERIANA MACKENZIE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (23, 23, 'CENTRO UNIVERSITRIO FEEVALE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (24, 24, 'UNIVERSIDADE ESTADUAL DE SANTA CRUZ', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (25, 26, 'ESCOLA NACIONAL DE CINCIAS ESTATSTICAS', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (26, 27, 'UNIVERSIDADE VALE DO RIO VERDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (27, 29, 'UNIVERSIDADE ESTADUAL DO CEAR', 2, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (28, 30, 'UNIVERSIDADE JOS DO ROSRIO VELLANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (29, 31, 'CENTRO DE EDUCAO TCNICA DA UTRAMIG', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (30, 32, 'UNIVERSIDADE ESTADUAL DE CINCIAS DA SADE DE ALAGOAS - UNCISAL', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (31, 33, 'FACULDADE DE TECNOLOGIA DE SOROCABA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (32, 34, 'FACULDADE DE TECNOLOGIA DE SO PAULO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (33, 35, 'FACULDADE DE TECNOLOGIA DE AMERICANA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (34, 36, 'FACULDADE DE TECNOLOGIA DA BAIXADA SANTISTA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (35, 37, 'FACULDADE DE TECNOLOGIA DE JAHU', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (36, 38, 'UNIVERSIDADE DO ESTADO DO PAR', 2, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (37, 39, 'INSTITUTO DE TECNOLOGIA DA AMAZNIA', 2, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (38, 40, 'UNIVERSIDADE DO ESTADO DA BAHIA', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (39, 41, 'FACULDADE ESTADUAL DE EDUCAO FSICA DE JACAREZINHO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (40, 42, 'FACULDADE ESTADUAL DE DIREITO DO NORTE PIONEIRO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (41, 43, 'FUNDAO UNIVERSIDADE DO ESTADO DE SANTA CATARINA', 2, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (42, 44, 'FACULDADE DE ENGENHARIA CIVIL DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (43, 45, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (44, 46, 'FACULDADE ESTADUAL DE CINCIAS ECONMICAS DE APUCARANA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (45, 47, 'UNIVERSIDADE ESTADUAL DE GOIS', 2, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (46, 54, 'UNIVERSIDADE ESTADUAL DE CAMPINAS', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (47, 55, 'UNIVERSIDADE DE SO PAULO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (48, 56, 'UNIVERSIDADE ESTADUAL PAULISTA JLIO DE MESQUITA FILHO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (49, 57, 'UNIVERSIDADE ESTADUAL DE MARING', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (50, 58, 'FACULDADE DE DIREITO DE SO BERNARDO DO CAMPO', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (51, 59, 'FACULDADE DE DIREITO DE FRANCA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (52, 60, 'CENTRO UNIVERSITRIO DE FRANCA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (53, 61, 'ESCOLA SUPERIOR DE EDUCAO FSICA DE AVAR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (54, 62, 'FACULDADE DE CINCIAS E LETRAS DE AVAR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (55, 63, 'FACULDADE DE CINCIAS DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (56, 64, 'FACULDADE DE ENGENHARIA DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (57, 65, 'FACULDADE DE ODONTOLOGIA DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (58, 66, 'FACULDADE DE DIREITO E ADMINISTRAO DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (59, 67, 'ESCOLA DE ENGENHARIA DE PIRACICABA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (60, 68, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PENPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (61, 71, 'UNIVERSIDADE DO ESTADO DO RIO GRANDE DO NORTE', 2, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (62, 72, 'FACULDADE DE FORMAO DE PROFESSORES DA MATA SUL', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (63, 73, 'CENTRO DE ENSINO SUPERIOR DE ARCOVERDE', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (64, 74, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE SO JOS DO RIO PARDO', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (65, 75, 'FACULDADE ESTADUAL DE EDUCAO CINCIAS E LETRAS DE PARANAVA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (66, 76, 'UNIVERSIDADE REGIONAL DE BLUMENAU', 3, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (67, 77, 'FACULDADE DA REGIO DOS LAGOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (68, 78, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ALEGRE', 3, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (69, 79, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE CATANDUVA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (70, 80, 'CENTRO UNIVERSITRIO PARA O DESENVOLVIMENTO DO ALTO VALE DO ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (71, 81, 'UNIVERSIDADE DA REGIO DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (72, 82, 'UNIVERSIDADE DO OESTE DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (73, 83, 'UNIVERSIDADE DO VALE DO ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (74, 84, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE MACA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (75, 85, 'FACULDADE DE FILOSOFIA DE ITAPERUNA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (76, 86, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS PADRE HUMBERTO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (77, 87, 'CENTRO UNIVERSITRIO DE BRUSQUE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (78, 88, 'FACULDADE DE FORMAO DE PROFESSORES DE PENEDO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (79, 89, 'FUNDAO FACULDADES LUIZ MENEGHEL', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (80, 90, 'ESCOLA SUPERIOR DE EDUCAO CINCIAS E LETRAS DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (81, 91, 'ESCOLA SUPERIOR DE CINCIAS AGRRIAS DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (82, 92, 'ESCOLA SUPERIOR CINCIAS HUMANAS E EXATAS DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (83, 93, 'FACULDADE DE MEDICINA DE JUNDIA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (84, 94, 'ESCOLA SUPERIOR DE EDUCAO FSICA DE JUNDIA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (85, 95, 'UNIVERSIDADE ESTADUAL DO VALE DO ACARA', 2, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (86, 96, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS PROFESSOR JOS AUGUSTO VIEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (87, 97, 'ESCOLA SUPERIOR DE AGRICULTURA E CINCIAS DE MACHADO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (88, 98, 'FACULDADE DE ADMINISTRAO E FINANAS DE MACHADO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (89, 99, 'FACULDADE DE DIREITO DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (90, 100, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ARAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (91, 101, 'FACULDADE DE CINCIAS GERENCIAIS DO ALTO PARANABA', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (92, 102, 'FACULDADE DE DIREITO DO ALTO PARANABA', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (93, 103, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE ARAGUARI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (94, 104, 'FACULDADE DE CINCIAS ECONMICAS DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (95, 105, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (96, 106, 'FACULDADE DE EDUCAO DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (97, 107, 'UNIVERSIDADE FEDERAL DE SO JOO DEL REI', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (98, 108, 'ESCOLA SUPERIOR DE EDUCAO FSICA E TCNICAS DESPORTIVAS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (99, 109, 'FACULDADES INTEGRADAS RUI BARBOSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (100, 110, 'FACULDADE DE DIREITO DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (101, 111, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (102, 122, 'FACULDADE DE ENGENHARIA DE AGRIMENSURA DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (103, 123, 'FACULDADE DE ENGENHARIA CIVIL DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (104, 124, 'CENTRO UNIVERSITRIO DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (105, 125, 'CENTRO UNIVERSITRIO DE ARARAS - "DR. EDMUNDO ULSON" - UNAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (106, 126, 'INSTITUTO NACIONAL DE TELECOMUNICAES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (107, 127, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE ATIBAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (108, 128, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (109, 129, 'FACULDADE DE DIREITO DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (110, 130, 'FACULDADE DE ADMINISTRAO DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (111, 131, 'FACULDADE DE EDUCAO FSICA DE BARRA BONITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (112, 132, 'FACULDADE DE EDUCAO ANTNIO AUGUSTO REIS NEVES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (113, 133, 'FACULDADE DE CINCIAS CONTBEIS DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (114, 134, 'FACULDADE DE TECNOLOGIA E PROCESSAMENTO DE DADOS - BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (115, 135, 'CENTRO UNIVERSITRIO CLARETIANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (116, 136, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE BEBEDOURO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (117, 137, 'UNIVERSIDADE DO SAGRADO CORAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (118, 138, 'CENTRO UNIVERSITRIO BARO DE MAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (119, 139, 'FACULDADE DE CINCIAS ECONMICAS DO TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (120, 140, 'UNIVERSIDADE SEVERINO SOMBRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (121, 141, 'FACULDADE DE DIREITO DE VARGINHA - FADIVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (122, 142, 'CENTRO UNIVERSITRIO DO TRINGULO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (123, 143, 'UNIVERSIDADE DE UBERABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (124, 144, 'FACULDADE DE CINCIAS HUMANAS DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (125, 145, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (126, 146, 'CENTRO UNIVERSITRIO DE RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (127, 149, 'FACULDADE DE MEDICINA DE SO JOS DO RIO PRETO', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (128, 150, 'UNIVERSIDADE DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (129, 151, 'ESCOLA DE ADMINISTRAO DE EMPRESAS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (130, 152, 'FACULDADE DE CINCIAS CONTBEIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (131, 158, 'CONSERVATRIO BRASILEIRO DE MSICA - CENTRO UNIVERSITRIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (132, 159, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (133, 160, 'FACULDADE FRASSINETTI DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (134, 161, 'CENTRO UNIVERSITRIO ASSUNO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (135, 162, 'CENTRO UNIVERSITRIO BELAS ARTES DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (136, 163, 'UNIVERSIDADE ESTCIO DE S', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (137, 165, 'UNIVERSIDADE VEIGA DE ALMEIDA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (138, 166, 'FACULDADE DE ADMINISTRAO E INFORMTICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (139, 167, 'UNIVERSIDADE METODISTA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (140, 170, 'FACULDADES DA FUNDAO DE ENSINO DE MOCOCA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (141, 171, 'FACULDADE DE DIREITO DO SUL DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (142, 172, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS EUGNIO PACELLI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (143, 173, 'FACULDADE DE CINCIAS MDICAS DR. JOS ANTONIO GARCIA COUTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (144, 174, 'INSTITUTO SUPERIOR DE ESTUDOS SOCIAIS CLVIS BEVILACQUA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (145, 176, 'UNIVERSIDADE CASTELO BRANCO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (146, 177, 'FACULDADE DE CINCIAS ECONMICAS E DE ADMINISTRAO DE EMPRESAS DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (147, 178, 'FACULDADE DE ENGENHARIA DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (148, 179, 'FACULDADE DE ARQUITETURA E URBANISMO DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (149, 180, 'FACULDADE DE DIREITO DE CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (150, 181, 'FACULDADE DE ODONTOLOGIA DE CARUARU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (151, 190, 'ESCOLA DE MEDICINA SOUZA MARQUES DA FUNDAO TCNICO-EDUCACIONAL SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (152, 191, 'FACULDADE DE CINCIAS CONTBEIS E DE ADMINISTRAO DE EMPRESAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (153, 192, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (154, 193, 'FACULDADE DE ENGENHARIA SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (155, 194, 'ESCOLA DE ENFERMAGEM DA FUNDAO TCNICO EDUCACIONAL SOUZA MARQUES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (156, 195, 'FACULDADE MORAES JNIOR - MACKENZIE RIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (157, 197, 'INSTITUTO DE CINCIAS SOCIAIS DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (158, 198, 'CENTRO UNIVERSITRIO DA CIDADE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (159, 199, 'FACULDADE SO LUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (160, 200, 'FACULDADE CSPER LBERO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (161, 201, 'FACULDADE BRASILEIRA DE CINCIAS JURDICAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (162, 202, 'FACULDADE DE ECONOMIA E FINANAS DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (163, 203, 'UNIVERSIDADE SO JUDAS TADEU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (164, 206, 'CENTRO UNIVERSITRIO TALO-BRASILEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (165, 207, 'CENTRO UNIVERSITRIO MOURA LACERDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (166, 208, 'UNIVERSIDADE DE RIBEIRO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (167, 210, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (168, 211, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (169, 212, 'FACULDADE DE FILOSOFIA DE CAMPO GRANDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (170, 213, 'CENTRO UNIVERSITRIO LVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (171, 214, 'FACULDADE DE ENGENHARIA DE MINAS GERAIS - FEAMIG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (172, 215, 'UNIVERSIDADE DO GRANDE ABC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (173, 216, 'CENTRO UNIVERSITRIO METODISTA IZABELA HENDRIX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (174, 217, 'CENTRO UNIVERSITRIO DAS FACULDADES ASSOCIADAS DE ENSINO - FAE', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (175, 218, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (176, 219, 'FACULDADE DE EDUCAO CINCIAS E ARTES DOM BOSCO DE MONTE APRAZVEL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (177, 220, 'FACULDADE SO JUDAS TADEU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (178, 221, 'UNIVERSIDADE CRUZEIRO DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (179, 222, 'CENTRO UNIVERSITRIO DE VOTUPORANGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (180, 223, 'FACULDADE DE EDUCAO FSICA DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (181, 224, 'FACULDADE DE MEDICINA DO ABC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (182, 225, 'INSTITUTO DE ENSINO SUPERIOR SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (183, 226, 'CENTRO UNIVERSITRIO LUSADA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (184, 227, 'UNIVERSIDADE CATLICA DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (185, 228, 'FACULDADE DE ENGENHARIA INDUSTRIAL DE SO BERNARDO DO CAMPO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (186, 229, 'ESCOLA SUPERIOR DE ADMINISTRAO DE NEGCIOS DE SO BERNARDO DO CAMPO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (187, 230, 'ESCOLA SUPERIOR DE ADMINISTRAO DE NEGCIOS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (188, 231, 'FACULDADE DE SO BERNARDO DO CAMPO - FASB', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (189, 234, 'FACULDADES OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (190, 236, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE SO JOO DA BOA VISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (191, 237, 'FACULDADE DE DIREITO DE SO JOO DA BOA VISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (192, 238, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE SO JOO DA BOA VISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (193, 239, 'FACULDADE DE MEDICINA VETERINRIA OCTVIO BASTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (194, 240, 'UNIVERSIDADE SANTA RSULA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (195, 241, 'FACULDADE DE ENGENHARIA QUMICA DE LORENA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (196, 242, 'CENTRO UNIVERSITRIO DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (197, 243, 'FACULDADE DO CLUBE NUTICO MOGIANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (198, 244, 'CENTRO UNIVERSITRIO FIEO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (199, 245, 'FACULDADE DE ADMINISTRAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (200, 254, 'CENTRO UNIVERSITRIO CAPITAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (201, 255, 'FACULDADE DE ENGENHARIA E AGRIMENSURA DE PIRASSUNUNGA - FEAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (202, 256, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE PIRAJU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (203, 257, 'FACULDADE DE ADMINISTRAO E CINCIAS CONTBEIS LUZWELL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (204, 263, 'FACULDADES INTEGRADAS CAMPOS SALLES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (205, 264, 'UNIVERSIDADE SO MARCOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (206, 265, 'FACULDADES INTEGRADAS DE OURINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (207, 266, 'UNIVERSIDADE METODISTA DE PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (208, 267, 'FACULDADES INTEGRADAS ESPRITO SANTENSES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (209, 268, 'FACULDADE DE DIREITO DA ALTA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (210, 269, 'FACULDADE FACCAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (211, 270, 'FACULDADES ESEFAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (212, 271, 'UNIVERSIDADE DO OESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (213, 273, 'ESCOLA DE ENGENHARIA INDUSTRIAL DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (214, 274, 'FACULDADE DE CINCIAS APLICADAS DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (215, 275, 'UNIVERSIDADE DO VALE DO PARABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (216, 276, 'FACULDADE DE DIREITO DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (217, 277, 'CENTRO UNIVERSITRIO AUGUSTO MOTTA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (218, 278, 'FACULDADES INTEGRADAS SIMONSEN', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (219, 279, 'FACULDADES INTEGRADAS HLIO ALONSO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (220, 280, 'FACULDADE DE DIREITO DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (221, 281, 'CONSERVATRIO DRAMTICO MUSICAL SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (222, 282, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (223, 283, 'FACULDADE DE EDUCAO COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (224, 284, 'FACULDADE DE MEDICINA DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (225, 288, 'FACULDADE DE DIREITO DO VALE DO RIO DOCE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (226, 289, 'FACULDADE DE EDUCAO DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (227, 290, 'FACULDADE DE DIREITO DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (228, 291, 'FACULDADE DE PSICOLOGIA DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (229, 292, 'FACULDADE DE CINCIAS DA SADE DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (230, 293, 'FACULDADE DE CINCIAS E TECNOLOGIA DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (231, 294, 'FACULDADE TRS DE MAIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (232, 295, 'UNIVERSIDADE DE SANTA CRUZ DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (233, 296, 'UNIVERSIDADE DA REGIO DA CAMPANHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (234, 297, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS SO JUDAS TADEU', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (235, 298, 'UNIVERSIDADE NORTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (236, 299, 'FACULDADE DE JANDAIA DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (237, 300, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (238, 301, 'ESCOLA DE BIBLIOTECONOMIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (239, 302, 'FACULDADE DE CINCIAS ECONMICAS, ADMINISTRATIVAS E CONTBEIS DE DIVINPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (240, 303, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (241, 304, 'FACULDADE DE CINCIAS CONTBEIS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (242, 307, 'FACULDADE DE MEDICINA DE BARBACENA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (243, 308, 'UNIVERSIDADE PRESIDENTE ANTNIO CARLOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (244, 316, 'UNIVERSIDADE NOVE DE JULHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (245, 317, 'FACULDADES INTEGRADAS ALCNTARA MACHADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (246, 318, 'FACULDADE DE ARTES ALCNTARA MACHADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (247, 319, 'UNIVERSIDADE CAMILO CASTELO BRANCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (248, 320, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE TATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (249, 321, 'FACULDADE DE DESENHO DE TATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (250, 322, 'UNIVERSIDADE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (251, 328, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS VIANNA JNIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (252, 329, 'ESCOLA SUPERIOR DE AGRONOMIA DE PARAGUA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (253, 330, 'UNIVERSIDADE IGUAU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (254, 332, 'ESCOLA DE ENGENHARIA DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (255, 333, 'FACULDADE DE INFORMTICA DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (256, 334, 'FACULDADE DE SERVIO SOCIAL DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (257, 335, 'FACULDADE DE EDUCAO E CINCIAS PINHEIRENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (258, 336, 'FACULDADE MACHADO SOBRINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (259, 337, 'CENTRO DE ENSINO SUPERIOR DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (260, 338, 'PONTIFCIA UNIVERSIDADE CATLICA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (261, 339, 'FACULDADE SANTA EMLIA DE RODAT', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (262, 343, 'CENTRO UNIVERSITRIO NEWTON PAIVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (263, 344, 'CENTRO UNIVERSITRIO UNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (264, 345, 'ESCOLA DE ENGENHARIA KENNEDY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (265, 346, 'INSTITUTO SUPERIOR DE CINCIAS APLICADAS - ISCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (266, 349, 'CENTRO UNIVERSITRIO DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (267, 351, 'FACULDADE DE CINCIAS MDICAS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (268, 352, 'CENTRO UNIVERSITRIO DE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (269, 353, 'FACULDADE EVANGLICA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (270, 355, 'UNIVERSIDADE TUIUTI DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (271, 359, 'ESCOLA SUPERIOR DE EDUCAO FSICA DE MUZAMBINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (272, 360, 'CENTRO UNIVERSITRIO PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (273, 361, 'FACULDADE PAULISTA DE SERVIO SOCIAL DE SO CAETANO DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (274, 362, 'FACULDADE PAULISTA DE SERVIO SOCIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (275, 363, 'FACULDADE MOZARTEUM DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (276, 364, 'FACULDADE DE CINCIAS CONTBEIS DE PONTE NOVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (277, 367, 'UNIVERSIDADE ESTADUAL DE MONTES CLAROS', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (278, 368, 'FACULDADE DE EDUCAO FSICA DA ASSOCIAO CRIST DE MOOS DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (279, 369, 'FACULDADE AUXILIUM DE FILOSOFIA CINCIAS E LETRAS DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (280, 370, 'FACULDADE PAULISTA DE ARTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (281, 371, 'FACULDADE DE MSICA CARLOS GOMES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (282, 372, 'FACULDADE DE BIBLIOTECONOMIA E CINCIA DA INFORMAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (283, 373, 'ESCOLA DE SOCIOLOGIA E POLTICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (284, 374, 'CENTRO UNIVERSITRIO DAS FACULDADES METROPOLITANAS UNIDAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (285, 375, 'UNIVERSIDADE DE SANTO AMARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (286, 376, 'CENTRO UNIVERSITRIO IBERO-AMERICANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (287, 377, 'FACULDADE DE EDUCAO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (288, 378, 'FACULDADE DE DIREITO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (289, 379, 'FACULDADE DE CINCIAS E LETRAS PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (290, 380, 'FACULDADE DE CINCIAS ECONMICAS, CONTBEIS E DE ADM DE EMPRESAS PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (291, 381, 'FACULDADE DE PSICOLOGIA PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (292, 382, 'FACULDADE DE TECNOLOGIA PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (293, 383, 'UNIVERSIDADE DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (294, 384, 'CENTRO UNIVERSITRIO DE ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (295, 385, 'UNIVERSIDADE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (296, 386, 'CENTRO UNIVERSITRIO DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (297, 387, 'UNIVERSIDADE CATLICA DOM BOSCO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (298, 388, 'FACULDADE DE CINCIAS CONTBEIS E ATUARIAIS DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (299, 389, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (300, 390, 'FACULDADE DE EDUCAO FSICA DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (301, 391, 'FACULDADE DE TECNOLOGIA DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (302, 395, 'FACULDADE DE CINCIAS CONTBEIS DE LUCLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (303, 396, 'FACULDADE RUY BARBOSA DE ADMINISTRAO E DE DIREITO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (304, 397, 'FACULDADE RUY BARBOSA DE TECNOLOGIA EM PROCESSAMENTO DE DADOS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (305, 398, 'UNIVERSIDADE TIRADENTES', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (306, 399, 'ESCOLA DE ENGENHARIA DE AGRIMENSURA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (307, 400, 'FACULDADE DE DIREITO DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (308, 401, 'CENTRO DE ESTUDOS SUPERIORES BARROS MELO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (309, 402, 'CENTRO UNIVERSITRIO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (310, 403, 'UNIVERSIDADE CATLICA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (311, 404, 'FACULDADES INTEGRADAS DA UPIS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (312, 405, 'FOCCA - FACULDADE DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (313, 408, 'ESCOLA SUPERIOR DE RELAES PBLICAS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (314, 409, 'UNIVERSIDADE DE PERNAMBUCO', 2, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (315, 410, 'FACULDADE DE CINCIAS HUMANAS ESUDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (316, 413, 'FACULDADE PORTO-ALEGRENSE DE EDUCAO, CINCIAS E LETRAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (317, 414, 'FACULDADE PORTO-ALEGRENSE DE CINCIAS CONTBEIS E ADMINISTRATIVAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (318, 415, 'FACULDADE DE CINCIAS MDICAS DA SANTA CASA SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (319, 416, 'FACULDADES INTEGRADAS TERESA MARTIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (320, 417, 'UNIVERSIDADE CIDADE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (321, 420, 'UNIVERSIDADE DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (322, 421, 'FACULDADE ESTADUAL DE CINCIAS E LETRAS DE CAMPO MOURO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (323, 423, 'UNIVERSIDADE REGIONAL INTEGRADA DO ALTO URUGUAI E DAS MISSES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (324, 424, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE SANTA ROSA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (325, 425, 'FACULDADE DE EDUCAO ARTSTICA DE SANTA ROSA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (326, 426, 'CENTRO UNIVERSITRIO FRANCISCANO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (327, 428, 'FACULDADE DE CINCIAS CONTBEIS E DE ADMINISTRAO DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (328, 429, 'FACULDADE DE DIREITO DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (329, 430, 'CENTRO UNIVERSITRIO FILADLFIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (330, 431, 'FACULDADE DE MEDICINA DE MARLIA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (331, 432, 'FACULDADE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (332, 433, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PALMAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (333, 434, 'FACULDADE SANTA MARCELINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (334, 435, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS SANTA MARCELINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (335, 436, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (336, 437, 'UNIVERSIDADE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (337, 438, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITUVERAVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (338, 439, 'FACULDADE DOUTOR FRANCISCO MAEDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (339, 440, 'FACULDADE DE DIREITO DE IT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (340, 441, 'UNIVERSIDADE DO CONTESTADO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (341, 442, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITARAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (342, 443, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE ITARAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (343, 446, 'UNIVERSIDADE DE CRUZ ALTA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (344, 447, 'FACULDADE CATLICA DE CINCIAS ECONMICAS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (345, 448, 'CENTRO UNIVERSITRIO RITTER DOS REIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (346, 449, 'UNIVERSIDADE LUTERANA DO BRASIL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (347, 450, 'CENTRO UNIVERSITRIO LUTERANO DE JI-PARAN', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (348, 451, 'CENTRO UNIVERSITRIO LUTERANO DE SANTARM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (349, 452, 'CENTRO UNIVERSITRIO LUTERANO DE MANAUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (350, 453, 'CENTRO UNIVERSITRIO LUTERANO DE PALMAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (351, 454, 'FACULDADE CAMAQENSE DE CINCIAS CONTBEIS E ADMINISTRATIVAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (352, 455, 'FACULDADE DE FORMAO DE PROFESSORES E ESPECIALISTAS DE EDUCAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (353, 456, 'CENTRO UNIVERSITRIO SANTANNA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (354, 457, 'UNIVERSIDADE BANDEIRANTE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (355, 458, 'UNIVERSIDADE IBIRAPUERA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (356, 459, 'FACULDADE RENASCENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (357, 460, 'FACULDADE DE ARTES PLSTICAS DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (358, 461, 'FACULDADE DE ADMINISTRAO DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (359, 462, 'FACULDADE DE ENGENHARIA DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (360, 463, 'FACULDADE DE COMUNICAO E MARKETING DA - FUNDAO ARMANDO LVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (361, 464, 'FACULDADE DE ECONOMIA DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (362, 465, 'FACULDADE DE COMPUTAO E INFORMTICA DA FUNDAO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (363, 466, 'UNIVERSIDADE ANHEMBI MORUMBI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (364, 467, 'FACULDADE DE CINCIAS CONTBEIS DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (365, 468, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (366, 469, 'ABEU FACULDADES INTEGRADAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (367, 470, 'FACULDADE DE ODONTOLOGIA DE NOVA FRIBURGO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (368, 472, 'UNIVERSIDADE DO GRANDE RIO PROFESSOR JOS DE SOUZA HERDY', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (369, 473, 'FACULDADE DE CINCIAS ECONMICAS, ADMINISTRATIVAS E DA COMPUTAO DOM BOSCO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (370, 474, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DOM BOSCO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (371, 475, 'FACULDADE DE MEDICINA DE PETRPOLIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (372, 480, 'CENTRO UNIVERSITRIO SERRA DOS RGOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (373, 481, 'UNIVERSIDADE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (374, 482, 'UNIVERSIDADE DO EXTREMO SUL CATARINENSE', 3, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (375, 483, 'CENTRO UNIVERSITRIO METROPOLITANO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (376, 486, 'FACULDADE DE FORMAO DE PROFESSORES DE ARAPIRACA', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (377, 487, 'FACULDADE DE ADMINISTRAO, CINCIAS CONTBEIS, JURDICAS E SOCIAIS DO ESTADO DE ALAGOAS', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (378, 488, 'ESCOLA SUPERIOR DE CINCIAS HUMANAS FSICAS E BIOLGICAS DO SERTO', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (379, 489, 'CENTRO UNIVERSITRIO DE VOLTA REDONDA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (380, 490, 'CENTRO DE ENSINO SUPERIOR DE VALENA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (381, 491, 'FACULDADE DE EDUCAO CINCIAS E LETRAS DON DOMNICO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (382, 492, 'FACULDADE DE ADMINISTRAO CINCIAS ECON E CONTBEIS DE GUARATINGUET', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (383, 493, 'FACULDADE DE EDUCAO DE GUARATINGUET', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (384, 494, 'UNIVERSIDADE DO SUL DE SANTA CATARINA', 3, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (385, 495, 'FACULDADE DE CINCIAS E LETRAS DE BRAGANA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (386, 496, 'UNIVERSIDADE DE FRANCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (387, 498, 'ESCOLA SUPERIOR DE EDUCAO FSICA E DESPORTOS DE CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (388, 499, 'FACULDADE DE DIREITO E ADMINISTRAO CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (389, 500, 'FACULDADE DE MEDICINA DE CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (390, 501, 'ESCOLA SUPERIOR DE CINCIAS DA SANTA CASA DE MISERICRDIA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (391, 502, 'CENTRO UNIVERSITRIO MONTE SERRAT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (392, 503, 'FACULDADE DE DIREITO DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (393, 504, 'FACULDADE DE ODONTOLOGIA DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (394, 505, 'FACULDADE DE FILOSOFIA DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (395, 506, 'FACULDADE DE MEDICINA DE CAMPOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (396, 507, 'FACULDADE TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (397, 508, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO SUL DE MINAS - FACESM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (398, 509, 'FACULDADES INTEGRADAS DE CRUZEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (399, 510, 'ESCOLA DE ENFERMAGEM WENCESLAU BRAZ', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (400, 511, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE GUAXUP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (401, 512, 'FACULDADE DE CINCIAS ADMINISTRATIVAS ECONMICAS E CONTBEIS DE GUAXUP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (402, 513, 'UNIVERSIDADE VALE DO RIO DOCE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (403, 514, 'CENTRO UNIVERSITRIO DE BARRA MANSA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (404, 515, 'CENTRO UNIVERSITRIO PLNIO LEITE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (405, 516, 'CENTRO UNIVERSITRIO MOACYR SREDER BASTOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (406, 517, 'FACULDADE DE EDUCAO SO LUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (407, 518, 'CENTRO UNIVERSITRIO DO DISTRITO FEDERAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (408, 519, 'UNIVERSIDADE CATLICA DO SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (409, 521, 'UNIVERSIDADE DE MOGI DAS CRUZES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (410, 522, 'CENTRO UNIVERSITRIO CELSO LISBOA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (411, 524, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (412, 526, 'UNIVERSIDADE BRAZ CUBAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (413, 527, 'UNIVERSIDADE CATLICA DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (414, 528, 'PONTIFCIA UNIVERSIDADE CATLICA DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (415, 530, 'FACULDADE DE MSICA DO ESPRITO SANTO', 2, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (416, 531, 'FACULDADE DE FORMAO DE PROFESSORES DE VITRIA DE SANTO ANTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (417, 532, 'UNIVERSIDADE REGIONAL DO NOROESTE DO ESTADO DO RIO GRANDE DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (418, 533, 'FACULDADES INTEGRADAS DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (419, 534, 'ESCOLA BAHIANA DE MEDICINA E SADE PBLICA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (420, 535, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE MANDAGUARI', 3, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (421, 543, 'FACULDADE DE CINCIAS DA FUNDAO INSTITUTO TECNOLGICO DE OSASCO', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (422, 544, 'FACULDADE DE CINCIAS HUMANAS DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (423, 545, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (424, 546, 'PONTIFCIA UNIVERSIDADE CATLICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (425, 547, 'UNIVERSIDADE DO ESTADO DO RIO DE JANEIRO', 2, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (426, 548, 'UNIVERSIDADE FEDERAL DO MARANHO', 1, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (427, 549, 'UNIVERSIDADE FEDERAL DO ACRE', 1, 1, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (428, 550, 'UNIVERSIDADE ESTADUAL DA PARABA', 2, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (429, 552, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (430, 553, 'FACULDADE DE CINCIAS ADMINISTRATIVAS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (431, 554, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE BOA ESPERANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (432, 555, 'UNIVERSIDADE DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (433, 556, 'CONSERVATRIO DE MSICA DE NITERI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (434, 557, 'ESCOLA DE MSICA E BELAS ARTES DO PARAN', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (435, 558, 'FACULDADE DE ARTES DO PARAN', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (436, 568, 'UNIVERSIDADE ESTADUAL DO MARANHO', 2, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (437, 569, 'UNIVERSIDADE FEDERAL DO PAR', 1, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (438, 570, 'UNIVERSIDADE FEDERAL DO RIO GRANDE DO NORTE', 1, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (439, 571, 'UNIVERSIDADE FEDERAL DO PARAN', 1, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (440, 572, 'UNIVERSIDADE FEDERAL FLUMINENSE', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (441, 573, 'UNIVERSIDADE FEDERAL DO ESPRITO SANTO', 1, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (442, 574, 'UNIVERSIDADE FEDERAL RURAL DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (443, 575, 'UNIVERSIDADE FEDERAL DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (444, 576, 'UNIVERSIDADE FEDERAL DE JUIZ DE FORA', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (445, 577, 'UNIVERSIDADE FEDERAL DE ALAGOAS', 1, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (446, 578, 'UNIVERSIDADE FEDERAL DA BAHIA', 1, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (447, 579, 'UNIVERSIDADE FEDERAL DA PARABA', 1, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (448, 580, 'UNIVERSIDADE FEDERAL DE PERNAMBUCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (449, 581, 'UNIVERSIDADE FEDERAL DO RIO GRANDE DO SUL', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (450, 582, 'UNIVERSIDADE FEDERAL DE SANTA MARIA', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (451, 583, 'UNIVERSIDADE FEDERAL DO CEAR', 1, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (452, 584, 'UNIVERSIDADE FEDERAL DE GOIS', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (453, 585, 'UNIVERSIDADE FEDERAL DE SANTA CATARINA', 1, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (454, 586, 'UNIVERSIDADE FEDERAL DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (455, 587, 'UNIVERSIDADE FEDERAL RURAL DE PERNAMBUCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (456, 588, 'UNIVERSIDADE TECNOLGICA FEDERAL DO PARAN', 1, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (457, 589, 'UNIVERSIDADE FEDERAL RURAL DO SEMI-RIDO', 1, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (458, 590, 'UNIVERSIDADE FEDERAL RURAL DA AMAZNIA', 1, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (459, 591, 'UNIVERSIDADE FEDERAL DE SO PAULO', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (460, 592, 'UNIVERSIDADE FEDERAL DE LAVRAS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (461, 593, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA CELSO SUCKOW DA FONSECA', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (462, 594, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (463, 595, 'UNIVERSIDADE FEDERAL DE ALFENAS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (464, 596, 'UNIVERSIDADE FEDERAL DOS VALES DO JEQUITINHONHA E MUCURI', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (465, 597, 'UNIVERSIDADE FEDERAL DO TRINGULO MINEIRO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (466, 598, 'UNIVERSIDADE FEDERAL DE ITAJUB - UNIFEI', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (467, 599, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DA BAHIA', 1, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (468, 600, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO MARANHO', 1, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (469, 601, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO RIO GRANDE DO SUL', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (470, 602, 'INSTITUTO TECNOLGICO DE AERONUTICA', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (471, 605, 'UNIVERSIDADE MUNICIPAL DE SO CAETANO DO SUL', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (472, 606, 'FACULDADE DE DIREITO DE CACHOEIRO DO ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (473, 607, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE CACHOEIRO DO ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (474, 608, 'ESCOLA SUPERIOR DE CRUZEIRO "PREFEITO HAMILTON VIEIRA MENDES"', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (475, 609, 'UNIVERSIDADE ESTADUAL DO OESTE DO PARAN', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (476, 610, 'CENTRO UNIVERSITRIO METODISTA BENNETT', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (477, 614, 'FACULDADE DE FILOSOFIA SANTA DOROTIA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (478, 615, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS PROFESSORA NAIR FORTES ABU-MERHY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (479, 616, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (480, 617, 'FACULDADE DE ENFERMAGEM E OBSTETRCIA DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (481, 618, 'FACULDADE DE FISIOTERAPIA DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (482, 621, 'CENTRO DE ESTUDOS SUPERIORES DE MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (483, 622, 'FACULDADES INTEGRADAS SILVA E SOUZA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (484, 623, 'FACULDADES DE FILOSOFIA CINCIAS E LETRAS DE SANTA CRUZ DO RIO PARDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (485, 624, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS CARLOS QUEIROZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (486, 625, 'FACULDADE CENECISTA DE CAPIVARI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (487, 626, 'FACULDADE CENECISTA DE OSRIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (488, 627, 'FACULDADE CENECISTA DE VARGINHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (489, 629, 'FACULDADE CENECISTA DE VITRIA - FACEV', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (490, 630, 'FACULDADE CENECISTA DE CINCIAS ADMINISTRATIVAS DE OSRIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (491, 631, 'CENTRO DE ENSINO SUPERIOR CENECISTA DE FARROUPILHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (492, 632, 'FACULDADE DE CINCIAS ECONMICAS, ADMINISTRATIVAS E CONTBEIS DE SO SEBASTIO DO PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (493, 633, 'INSTITUTO MILITAR DE ENGENHARIA', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (494, 634, 'UNIVERSIDADE FEDERAL DE PELOTAS', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (495, 636, 'ESCOLA SUPERIOR DE PROPAGANDA E MARKETING', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (496, 637, 'FACULDADE DE ENGENHARIA SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (497, 638, 'FACULDADE DE DIREITO MILTON CAMPOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (498, 639, 'FACULDADE DE DESENHO INDUSTRIAL DE MAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (499, 640, 'FACULDADES INTEGRADAS MARIA THEREZA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (500, 641, 'CENTRO UNIVERSITRIO LA SALLE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (501, 645, 'CENTRO UNIVERSITRIO DE JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (502, 646, 'FACULDADES ASSOCIADAS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (503, 647, 'FACULDADE DE ENFERMAGEM LUIZA DE MARILLAC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (504, 648, 'FACULDADES ASSOCIADAS DE UBERABA - FAZU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (505, 649, 'CENTRO UNIVERSITRIO DE UNIO DA VITRIA', 3, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (506, 650, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE AVAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (507, 651, 'FACULDADE DE ADMINISTRAO DE GOVERNADOR VALADARES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (508, 652, 'FACULDADE SANTA CECLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (509, 657, 'FACULDADE DE FORMAO DE PROFESSORES DE SERRA TALHADA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (510, 659, 'FACULDADE DE CINCIAS HUMANAS DO SUL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (511, 660, 'FACULDADE METODISTA DO SUL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (512, 661, 'FACULDADE PIO DCIMO', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (513, 662, 'FACULDADES INTEGRADAS CORAO DE JESUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (514, 663, 'UNIVERSIDADE SALGADO DE OLIVEIRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (515, 664, 'CENTRO UNIVERSITRIO VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (516, 665, 'UNIVERSIDADE DE TAUBAT', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (517, 666, 'UNIVERSIDADE ESTADUAL DE FEIRA DE SANTANA', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (518, 667, 'FACULDADES INTEGRADAS DE JACAREPAGU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (519, 668, 'CENTRO UNIVERSITRIO DE ENSINO SUPERIOR DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (520, 669, 'CENTRO UNIVERSITRIO NILTON LINS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (521, 670, 'UNIVERSIDADE SO FRANCISCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (522, 671, 'UNIVERSIDADE ANHANGUERA - UNIDERP', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (523, 672, 'FACULDADE DE ENGENHARIA DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (524, 673, 'CENTRO UNIVERSITRIO DA GRANDE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (525, 674, 'CENTRO DE ENSINO SUPERIOR DO VALE SO FRANCISCO', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (526, 677, 'FACULDADE DE REABILITAO DA ASCE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (527, 678, 'FACULDADE DE ODONTOLOGIA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (528, 679, 'FACULDADE DE REABILITAO DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (529, 680, 'FACULDADES INTEGRADAS DE PEDRO LEOPOLDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (530, 681, 'FACULDADES INTEGRADAS ANGLO-AMERICANO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (531, 682, 'FACULDADE DO NOROESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (532, 683, 'FACULDADE DE CINCIAS ECONMICAS DE COLATINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (533, 684, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE COLATINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (534, 685, 'FACULDADE DE FORMAO DE PROFESSORES DE BELO JARDIM', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (535, 686, 'FACULDADE DE CINCIAS DA ADMINISTRAO DO LIMOEIRO', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (536, 687, 'FACULDADE ESTADUAL DE FILOSOFIA CINCIAS LETRAS UNIO DA VITRIA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (537, 688, 'UNIVERSIDADE ESTADUAL DO SUDOESTE DA BAHIA', 2, 1, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (538, 689, 'FACULDADE DE NUTRIO E FONOAUDIOLOGIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (539, 690, 'FACULDADE DE CINCIAS CONTBEIS E ADMINISTRATIVAS DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (540, 691, 'FACULDADE DE EDUCAO DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (541, 692, 'FACULDADE DE CINCIAS APLICADAS E SOCIAIS DE PETROLINA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (542, 693, 'UNIVERSIDADE FEDERAL DO ESTADO DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (543, 694, 'UNIVERSIDADE FEDERAL DE MATO GROSSO DO SUL', 1, 1, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (544, 695, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (545, 696, 'FACULDADE DE CINCIAS AGRRIAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (546, 697, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (547, 699, 'FUNDAO UNIVERSIDADE FEDERAL DE RONDNIA', 1, 1, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (548, 700, 'FACULDADE DE EDUCAO DE ITABORA', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (549, 701, 'FACULDADE DE CINCIAS DA ADMINISTRAO DE GARANHUNS', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (550, 702, 'FACULDADE DE FORMAO DE PROFESSORES DE GOIANA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (551, 703, 'FACULDADE DE FORMAO DE PROFESSORES DE ARARIPINA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (552, 704, 'FACULDADE DE CINCIAS AGRRIAS DE ARARIPINA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (553, 705, 'FACULDADE SO JOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (554, 706, 'FACULDADE DE ARTES DULCINA DE MORAES', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (555, 707, 'CENTRO UNIVERSITRIO CENTRAL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (556, 708, 'INSTITUTO DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (557, 709, 'INSTITUTO DE CINCIAS EXATAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (558, 710, 'FACULDADE BTHENCOURT DA SILVA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (559, 711, 'FACULDADES REUNIDAS DE ADMINISTRAO CINCIAS CONTBEIS E ECONMICAS DE PALMAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (560, 712, 'CENTRO UNIVERSITRIO HERMNIO DA SILVEIRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (561, 713, 'ESCOLA SUPERIOR DE ESTATSTICA DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (562, 714, 'FACULDADE ESTADUAL DE FILOSOFIA CINCIAS E LETRAS DE CORNLIO PROCPIO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (563, 715, 'CENTRO UNIVERSITRIO FRANCISCANO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (564, 716, 'FACULDADES INTEGRADAS DE BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (565, 717, 'FUNDAO UNIVERSIDADE FEDERAL DE CINCIAS DA SADE DE PORTO ALEGRE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (566, 718, 'UNIVERSIDADE POTIGUAR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (567, 719, 'UNIVERSIDADE DO ESTADO DE MATO GROSSO', 2, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (568, 720, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS APLICADAS DO CABO DE SANTO AGOSTINHO', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (569, 721, 'FACULDADE DE EDUCAO DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (570, 722, 'ESCOLA DE EDUCAO FSICA DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (571, 723, 'FACULDADE DE ADMINISTRAO DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (572, 724, 'FACULDADE DE CINCIAS, CULTURA E EXTENSO DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (573, 725, 'FACULDADE ESTADUAL DE FILOSOFIA, CINCIAS E LETRAS DE PARANAGU', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (574, 726, 'FACULDADE ESTADUAL DE FILOSOFIA CINCIAS E LETRAS DE JACAREZINHO', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (575, 727, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (576, 728, 'FACULDADE DE CINCIAS HUMANAS DE CURVELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (577, 729, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE PRESIDENTE VENCESLAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (578, 730, 'UNIVERSIDADE ESTADUAL DE PONTA GROSSA', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (579, 734, 'FACULDADES INTEGRADAS MARIA IMACULADA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (580, 736, 'FACULDADE DE CINCIAS APLICADAS SAGRADO CORAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (581, 737, 'CENTRO UNIVERSITRIO SO CAMILO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (582, 738, 'FACULDADES INTEGRADAS TERESA DVILA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (583, 739, 'CENTRO UNIVERSITRIO SO CAMILO - ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (584, 740, 'FACULDADE DE CINCIAS HUMANAS DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (585, 741, 'ESCOLA SUPERIOR DE SECRETARIADO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (586, 742, 'FACULDADE DE ARQUITETURA E URBANISMO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (587, 743, 'ESCOLA SUPERIOR DE ENSINO HELENA ANTIPOFF', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (588, 744, 'FACULDADE DE EDUCAO E CINCIAS HUMANAS DE ANICUNS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (589, 745, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE SO MANUEL', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (590, 746, 'UNIVERSIDADE REGIONAL DO CARIRI', 2, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (591, 747, 'FACULDADE DE CINCIAS HUMANAS DE IVAIPOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (592, 749, 'CENTRO DE ENSINO SUPERIOR DO VALE DO PARNABA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (593, 750, 'CENTRO UNIVERSITRIO UNIRG', 3, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (594, 751, 'FACULDADE DA ILHA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (595, 752, 'FACULDADE DE PAR DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (596, 753, 'FACULDADE DE CINCIAS HUMANAS DO SERTO CENTRAL', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (597, 754, 'CENTRO DE ENSINO SUPERIOR DE CATALO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (598, 755, 'CENTRO DE ENSINO SUPERIOR DE JATA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (599, 756, 'UNIVERSIDADE ESTADUAL DO PIAU', 2, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (600, 757, 'FACULDADES INTEGRADAS DO TAPAJS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (601, 758, 'FACULDADE BRASILEIRA DE RECURSOS HUMANOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (602, 759, 'FACULDADE DE CINCIAS MDICAS E PARAMDICAS FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (603, 760, 'FACULDADE DE CINCIAS HUMANAS DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (604, 761, 'FACULDADES SPEI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (605, 762, 'FACULDADES INTEGRADAS DE FTIMA DO SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (606, 763, 'INSTITUTO UNIFICADO DE ENSINO SUPERIOR OBJETIVO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (607, 764, 'FACULDADE PINHEIRO GUIMARES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (608, 767, 'INSTITUTO SUPERIOR DE INFORMTICA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (609, 768, 'FACULDADE DE ADMINISTRAO DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (610, 769, 'FACULDADES INTEGRADAS DE NAVIRA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (611, 770, 'FACULDADE DE EDUCAO DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (612, 771, 'FACULDADE MARIA AUGUSTA RIBEIRO DAHER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (613, 773, 'FACULDADE DE ADMINISTRAO E CINCIAS CONTBEIS DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (614, 774, 'FACULDADE ALVORADA DE INFORMTICA E PROCESSAMENTO DE DADOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (615, 775, 'FACULDADE ALVORADA DE EDUCAO FSICA E DESPORTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (616, 776, 'FACULDADE DE CINCIAS CONTBEIS DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (617, 777, 'FACULDADE DE EDUCAO THEREZA PORTO MARQUES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (618, 778, 'FACULDADE DE TECNOLOGIA THEREZA PORTO MARQUES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (619, 779, 'FACULDADE DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (620, 780, 'UNIVERSIDADE DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (621, 781, 'FACULDADE DO SUL DE MATO GROSSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (622, 782, 'FACULDADE CUIABANA DE EDUCAO E LETRAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (623, 783, 'FACULDADE MATOGROSSENSE DE CINCIAS CONTBEIS E ADMINISTRATIVA DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (624, 785, 'FACULDADE DE EDUCAO DE TANGAR DA SERRA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (625, 788, 'FACULDADE DE CINCIAS HUMANAS, EXATAS E LETRAS DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (626, 789, 'UNIVERSIDADE FEDERAL DE RORAIMA', 1, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (627, 790, 'FACULDADE DE ENFERMAGEM DO HOSPITAL ISRAELITA ALBERT EINSTEIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (628, 791, 'FACULDADE SENAC DE TURISMO E HOTELARIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (629, 792, 'CENTRO UNIVERSITRIO DO ESTADO DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (630, 793, 'CENTRO UNIVERSITRIO RADIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (631, 794, 'CENTRO UNIVERSITRIO DE VRZEA GRANDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (632, 795, 'FACULDADES INTEGRADAS DE DIAMANTINO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (633, 796, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO VALE DO SO LOURENO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (634, 797, 'FACULDADE DE EDUCAO E CINCIAS ADMINISTRATIVAS DE VILHENA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (635, 798, 'FACULDADE DE ARACRUZ', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (636, 799, 'FACULDADE LEONARDO DA VINCI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (637, 800, 'FACULDADE DE EDUCAO FSICA MONTENEGRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (638, 801, 'FACULDADE DE EDUCAO MONTENEGRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (639, 802, 'CENTRO UNIVERSITRIO CARIOCA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (640, 803, 'FACULDADE INTERAO AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (641, 809, 'FACULDADE DE DIREITO E CINCIAS SOCIAIS DO LESTE DE MINAS - FADILESTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (642, 810, 'CENTRO TCNICO-EDUCACIONAL SUPERIOR DO OESTE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (643, 811, 'FACULDADES INTEGRADAS DE CASSILNDIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (644, 817, 'FACULDADE BATISTA CARIOCA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (645, 818, 'FACULDADE DE ADMINISTRAO DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (646, 819, 'FACULDADE DE AGRONOMIA DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (647, 820, 'FACULDADE DE CINCIAS DA COMPUTAO DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (648, 821, 'FACULDADE DE PEDAGOGIA DE MINEIROS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (649, 822, 'ESCOLA SUPERIOR DE ESTUDOS EMPRESARIAIS E INFORMTICA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (650, 823, 'CENTRO UNIVERSITRIO DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (651, 824, 'FACULDADE DE FILOSOFIA E CINCIAS HUMANAS DE GOIATUBA', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (652, 825, 'FACULDADE PRESBITERIANA GAMMON', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (653, 826, 'CENTRO UNIVERSITRIO DE DESENVOLVIMENTO DO CENTRO-OESTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (654, 827, 'FACULDADES UNIDAS DO VALE DO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (655, 828, 'FACULDADE DE SO LOURENO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (656, 829, 'UNIVERSIDADE DO TOCANTINS', 2, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (657, 830, 'UNIVERSIDADE FEDERAL DO AMAP', 1, 1, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (658, 831, 'FACULDADE DE CINCIAS HUMANAS DO VALE DO RIO GRANDE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (659, 832, 'FACULDADE DE CINCIAS ADMINISTRATIVAS DE CURVELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (660, 833, 'FACULDADES INTEGRADAS DE ARIQUEMES', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (661, 834, 'FACULDADE VARZEAGRANDENSE DE CINCIAS HUMANAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (662, 835, 'FACULDADE VARZEAGRANDENSE DE COMUNICAO SOCIAL', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (663, 837, 'FACULDADE DE CINCIAS HUMANAS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (664, 838, 'FACULDADE DE CINCIAS TECNOLGICAS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (665, 839, 'FACULDADE VITORIANA DE CINCIAS CONTBEIS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (666, 840, 'FACULDADE VITORIANA DE TECNOLOGIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (667, 841, 'FACULDADE DE TURISMO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (668, 843, 'FACULDADE DE CINCIAS E TECNOLOGIA DE BIRIGUI', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (669, 844, 'FACULDADE DE AGRONOMIA E ENGENHARIA FLORESTAL DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (670, 845, 'FACULDADE DA FUNDAO EDUCACIONAL ARAATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (671, 846, 'FACULDADE DE ADMINISTRAO DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (672, 847, 'FACULDADE PIAUIENSE DE PROCESSAMENTO DE DADOS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (673, 848, 'FACULDADE PARAIBANA DE PROCESSAMENTO DE DADOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (674, 849, 'FACULDADE JESUTA DE FILOSOFIA E TEOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (675, 850, 'FACULDADE PRIMUS DE INFORMTICA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (676, 851, 'FACULDADE DE TECNOLOGIA EM PROCESSAMENTO DE DADOS DO LITORAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (677, 852, 'FACULDADE DE INFORMTICA E ADMINISTRAO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (678, 859, 'FACULDADE REGIONAL SANTA CRUZ DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (679, 860, 'FACULDADE DE CINCIAS SOCIAIS DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (680, 861, 'CENTRO DE ENSINO SUPERIOR DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (681, 862, 'FACULDADE ESTCIO DE S DE CAMPO GRANDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (682, 864, 'FACULDADE DE DIREITO DE VRZEA GRANDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (683, 866, 'FACULDADE DE INFORMTICA DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (684, 867, 'FACULDADE DE EDUCAO CINCIAS E LETRAS DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (685, 873, 'FACULDADES UNIFICADAS DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (686, 874, 'FACULDADE DE ESTUDOS SOCIAIS APLICADOS DE VIANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (687, 875, 'FACULDADE DE ESTUDOS SOCIAIS DE BARRA DO GARAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (688, 876, 'FACULDADE DE TECNOLOGIA DO VALE DO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (689, 877, 'FACULDADE DE ECONOMIA E PROCESSAMENTO DE DADOS DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (690, 878, 'CENTRO UNIVERSITRIO DO LESTE DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (691, 880, 'FACULDADE DE CINCIAS E TECNOLOGIA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (692, 881, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (693, 882, 'INSTITUTO MUNICIPAL DE ENSINO SUPERIOR DE BEBEDOURO VICTRIO CARDASSI', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (694, 886, 'FACULDADE PAULISTA DE ADMINISTRAO E CINCIAS CONTBEIS DE HORTOLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (695, 887, 'FACULDADE CHRISTUS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (696, 888, 'FACULDADE BANDEIRANTES DE CINCIAS EXATAS E HUMANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (697, 890, 'ESCOLA DE GOVERNO PROFESSOR PAULO NEVES DE CARVALHO', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (698, 891, 'FACULDADE BRASILEIRA DE CINCIAS EXATAS, HUMANAS E SOCIAIS - FABRAI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (699, 896, 'ESCOLA SUPERIOR DE TURISMO E HOTELARIA - FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (700, 897, 'UNIO DAS ESCOLAS SUPERIORES DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (701, 898, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS SANTA RITA DE CSSIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (702, 899, 'FACULDADES INTEGRADAS DE RIO VERDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (703, 900, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E DE TECNOLOGIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (704, 903, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (705, 904, 'FACULDADE DE PROCESSAMENTO DE DADOS DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (706, 905, 'FACULDADE ESCOLA PAULISTA DE DIREITO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (707, 906, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE SUMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (708, 907, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE INDAIATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (709, 908, 'FACULDADE ALAGOANA DE ADMINISTRAO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (710, 909, 'FACULDADE DE BELFORD ROXO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (711, 910, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS SANTA LCIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (712, 911, 'FACULDADES UNIDAS DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (713, 912, 'FACULDADE COMPACTO DE CINCIAS GERENCIAIS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (714, 913, 'FACULDADES INTEGRADAS DE PARANABA - FIPAR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (715, 914, 'FACULDADE PARANAENSE DE ADMINISTRAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (716, 915, 'FACULDADE DE ADMINISTRAO DE FTIMA DO SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (717, 916, 'FACULDADE DE CINCIAS HUMANAS E JURDICAS DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (718, 917, 'FACULDADE DE CINCIAS CONTBEIS DE NAVIRAI', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (719, 918, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (720, 922, 'FACULDADE DE CINCIAS GERENCIAIS DE DRACENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (721, 923, 'FACULDADE DE ADMINISTRAO E CINCIAS CONTBEIS DE SO ROQUE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (722, 924, 'FACULDADE INTERLAGOS DE EDUCAO E CULTURA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (723, 925, 'FACULDADE DE CINCIAS GERNCIAIS DE VILHENA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (724, 926, 'CENTRO UNIVERSITRIO DE CAMPO GRANDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (725, 927, 'CENTRO DE ESTUDOS SUPERIORES DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (726, 929, 'INSTITUTO MANAUARA DE ENSINO SUPERIOR', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (727, 930, 'FACULDADE DE EDUCAO DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (728, 934, 'FACULDADE SO CARLOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (729, 935, 'FACULDADE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (730, 939, 'FACULDADE CATLICA DE ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (731, 940, 'FACULDADE DE CINCIAS CONTBEIS DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (732, 941, 'FACULDADE DE EDUCAO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (733, 944, 'ESCOLA SUPERIOR DE PROPAGANDA E MARKETING DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (734, 945, 'INSTITUTO DE CINCIAS SOCIAIS E HUMANAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (735, 950, 'UNIO DE ENSINO SUPERIOR DE NOVA MUTUM', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (736, 951, 'FACULDADES INTEGRADAS DE COXIM', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (737, 952, 'UNIVERSIDADE SANTA CECLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (738, 953, 'UNIVERSIDADE METROPOLITANA DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (739, 954, 'FACULDADE DE CINCIAS AGRO- AMBIENTAIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (740, 955, 'FACULDADE DE FILOSOFIA NOSSA SENHORA IMACULADA CONCEIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (741, 959, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (742, 960, 'FACULDADE DE CINCIAS CONTBEIS DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (743, 961, 'FACULDADE GARCIA SILVEIRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (744, 966, 'FACULDADE DE TURISMO - SANTOS DUMONT', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (745, 967, 'FACULDADE DE TECNOLOGIA DE TAQUARITINGA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (746, 968, 'FACULDADE DE TECNOLOGIA EM PROCESSAMENTO DE DADOS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (747, 969, 'FACULDADE DE TURISMO - FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (748, 970, 'FACULDADE DE SERVIO SOCIAL DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (749, 971, 'FACULDADE DE TECNOLOGIA E CINCIAS DE CONSELHEIRO LAFAIETE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (750, 973, 'FACULDADE DE CINCIAS GERENCIAIS E ORAMENTOS E CONTBEIS LUCLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (751, 975, 'FACULDADE DE FISIOTERAPIA DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (752, 976, 'FACULDADES INTEGRADAS DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (753, 977, 'FACULDADE SO CAMILO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (754, 980, 'FACULDADE DE ADMINISTRAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (755, 983, 'FACULDADE PRUDENTE DE MORAES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (756, 984, 'FACULDADE DE EDUCAO DE IVAIPOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (757, 985, 'FACULDADE DE CINCIAS E EDUCAO DE RUBIATABA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (758, 986, 'FACULDADE DE EDUCAO E CULTURA MONTESSORI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (759, 988, 'FACULDADE DE COMUNICAO SOCIAL TAMOIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (760, 989, 'ESCOLA SUPERIOR DE BIOLOGIA E MEIO AMBIENTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (761, 990, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DE CONGONHAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (762, 991, 'FACULDADE SENAI-CETIQT', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (763, 994, 'FACULDADE FLAMA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (764, 997, 'FACULDADE DE CINCIAS ECONMICAS DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (765, 998, 'FACULDADE DE SERVIO SOCIAL DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (766, 999, 'FACULDADE DE DIREITO DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (767, 1001, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (768, 1002, 'FACULDADE DE DIREITO DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (769, 1003, 'FACULDADE DE SERVIO SOCIAL PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (770, 1012, 'FACULDADE DE FORMAO DE PROFESSORES DE AFOGADOS DA INGAZEIRA', 3, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (771, 1013, 'FACULDADE SUDOESTE PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (772, 1014, 'INSTITUTO SUPERIOR E CENTRO EDUCACIONAL LUTERANO - BOM JESUS - IELUSC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (773, 1015, 'FACULDADE DE CINCIAS CONTBEIS MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (774, 1016, 'FACULDADE DE CINCIAS HUMANAS DO VALE DO PIRANGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (775, 1017, 'FACULDADE STEFANINI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (776, 1019, 'FACULDADE DE CINCIAS E TECNOLOGIA DE UNA - FACTU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (777, 1021, 'FACULDADE DE CINCIAS DE TIMBABA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (778, 1027, 'UNIVERSIDADE ESTADUAL DO NORTE FLUMINENSE DARCY RIBEIRO', 2, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (779, 1028, 'UNIVERSIDADE ESTADUAL DE MATO GROSSO DO SUL', 2, 1, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (780, 1030, 'FACULDADE DE ECONOMIA E FINANAS IBMEC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (781, 1031, 'FACULDADE ANDR DA SILVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (782, 1032, 'CENTRO UNIVERSITRIO SALESIANO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (783, 1034, 'UNIO DE ESCOLAS SUPERIORES DA FUNESO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (784, 1036, 'UNIVERSIDADE DO ESTADO DE MINAS GERAIS', 2, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (785, 1038, 'FACULDADES INTEGRADAS DE TRS LAGOAS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (786, 1040, 'FACULDADES DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (787, 1041, 'CENTRO UNIVERSITRIO UNIVATES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (788, 1042, 'UNIVERSIDADE POSITIVO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (789, 1043, 'CENTRO UNIVERSITRIO HERMINIO OMETTO DE ARARAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (790, 1045, 'CENTRO UNIVERSITRIO ANHANGERA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (791, 1046, 'UNIO DAS FACULDADES DOS GRANDES LAGOS - UNILAGO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (792, 1047, 'FACULDADE TECNOLGICA PORTO-ALEGRENSE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (793, 1048, 'FACULDADE CAMPOS ELSEOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (794, 1049, 'INSTITUTO DE ENSINO SUPERIOR FUCAPI', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (795, 1051, 'FACULDADE DE CINCIAS CONTBEIS - MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (796, 1052, 'FACULDADE ADVENTISTA DE ADMINISTRAO DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (797, 1053, 'FACULDADE DE TECNOLOGIA E CINCIAS DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (798, 1054, 'ESCOLA BAHIANA DE ADMINISTRAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (799, 1055, 'FACULDADE MAURCIO DE NASSAU DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (800, 1058, 'CENTRO UNIVERSITRIO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (801, 1059, 'FACULDADE LOURENO FILHO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (802, 1060, 'INSTITUTO DE EDUCAO SUPERIOR DE BRASLIA - IESB', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (803, 1061, 'FACULDADE PLANALTO DE ADMINISTRAO E CINCIAS ECONMICAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (804, 1063, 'FACULDADE BATISTA DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (805, 1064, 'FACULDADE BATISTA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (806, 1065, 'FACULDADE DE CINCIAS ECONMICAS E ADMINISTRATIVAS DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (807, 1066, 'INSTITUTO DE ENSINO E PESQUISA OBJETIVO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (808, 1067, 'FACULDADE DE JUSSARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (809, 1068, 'FACULDADE ALDETE MARIA ALVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (810, 1069, 'CENTRO REGIONAL DE ESTUDOS EM CINCIAS HUMANAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (811, 1070, 'INSTITUTO DE ENSINO SUPERIOR CENECISTA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (812, 1071, 'INSTITUTO DE ENSINO SUPERIOR DA FUNLEC', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (813, 1072, 'FACULDADE AFIRMATIVO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (814, 1075, 'INSTITUTO DE EDUCAO SUPERIOR DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (815, 1076, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE CAJAZEIRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (816, 1077, 'FACULDADE INTEGRADA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (817, 1078, 'FACULDADE INTEGRADO DE CAMPO MOURO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (818, 1079, 'FACULDADE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (819, 1080, 'FACULDADE ARTHUR S EARP NETO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (820, 1081, 'FACULDADE DE ENGENHARIA DE RESENDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (821, 1082, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO RIO GRANDE DO NORTE', 1, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (822, 1084, 'FACULDADE CENECISTA DE BENTO GONALVES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (823, 1085, 'FACULDADE METODISTA DE SANTA MARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (824, 1086, 'FACULDADE DE EDUCAO DE COLORADO DO OESTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (825, 1087, 'FACULDADES INTEGRADAS APARCIO CARVALHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (826, 1088, 'FACULDADE DE DESENHO INDUSTRIAL DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (827, 1089, 'CENTRO DE EDUCAO SUPERIOR - NICA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (828, 1090, 'FACULDADE SO LUS DE FRANA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (829, 1091, 'FACULDADE DE PEDAGOGIA DE VARGEM GRANDE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (830, 1092, 'FACULDADES INTEGRADAS DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (831, 1093, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (832, 1095, 'FACULDADE DE ADMINISTRAO E NEGCIOS DE MONTE ALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (833, 1096, 'FACULDADE DE PRESIDENTE EPITCIO - FAPE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (834, 1097, 'FACULDADES INTEGRADAS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (835, 1099, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (836, 1100, 'FACULDADE CARLOS DRUMMOND DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (837, 1101, 'FACULDADE ADVENTISTA DE CINCIAS DA SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (838, 1102, 'FACULDADE DE INFORMTICA - MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (839, 1103, 'FACULDADE DE ADMINISTRAO SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (840, 1104, 'FACULDADE DE COMUNICAO SOCIAL DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (841, 1107, 'FACULDADE INTEGRADA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (842, 1108, 'FACULDADE DE CINCIAS GERENCIAIS - COTIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (843, 1111, 'FACULDADE DE TURISMO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (844, 1112, 'FACULDADE DE RELAES INTERNACIONAIS DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (845, 1113, 'CENTRO UNIVERSITRIO EURO-AMERICANO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (846, 1114, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS APLICADAS RIO BRANCO - FIRB', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (847, 1115, 'FACULDADE SANTA TEREZINHA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (848, 1116, 'FACULDADE CAIARAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (849, 1117, 'FACULDADE SENAC DE COMUNICAO E ARTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (850, 1118, 'UNIO DAS ESCOLAS DO GRUPO FAIMI DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (851, 1119, 'FACULDADE PLANALTO DE FILOSOFIA, CINCIAS E LETRAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (852, 1120, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA FLUMINENSE', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (853, 1122, 'FACULDADE DE EDUCAO DE OSVALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (854, 1123, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (855, 1124, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (856, 1125, 'FACULDADES INTEGRADAS ESPRITA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (857, 1126, 'UNIVERSIDADE ESTADUAL DO CENTRO OESTE', 2, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (858, 1128, 'UNIVERSIDADE DE ITANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (859, 1129, 'CENTRO UNIVERSITRIO DO NORTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (860, 1130, 'FACULDADE METODISTA DE CINCIAS HUMANAS E EXATAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (861, 1131, 'FACULDADE SANTO AGOSTINHO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (862, 1132, 'FACULDADE DE CINCIA DA COMPUTAO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (863, 1134, 'FACULDADE EVANGLICA LUTERANA MARTINUS*', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (864, 1135, 'FACULDADE PLANALTO DE CINCIA DA COMPUTAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (865, 1136, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DE IGARASSU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (866, 1137, 'CENTRO DE ENSINO SUPERIOR HERIS DE JENIPAPO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (867, 1138, 'CENTRO DE EDUCAO SUPERIOR DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (868, 1139, 'FACULDADE DE ESTUDOS ADMINISTRATIVOS DE MINAS GERAIS - FEAD-MG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (869, 1140, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (870, 1141, 'FACULDADE GAMA E SOUZA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (871, 1142, 'FACULDADES INTEGRADAS DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (872, 1143, 'FACULDADE DE EDUCAO SUPERIOR DE TIMBABA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (873, 1144, 'FACULDADE DE CINCIAS HUMANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (874, 1145, 'FACULDADE DE CINCIAS AGRRIAS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (875, 1147, 'FACULDADE RUY BARBOSA DE PSICOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (876, 1149, 'CENTRO UNIVERSITRIO NOSSA SENHORA DO PATROCNIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (877, 1150, 'FACULDADE SENAI DE TECNOLOGIA GRFICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (878, 1151, 'FACULDADE DE ADMINISTRAO E NEGCIOS DE SERGIPE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (879, 1152, 'INSTITUTO SUL BRASIL DE ENSINO SUPERIOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (880, 1153, 'UNIVERSIDADE CNDIDO MENDES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (881, 1155, 'FACULDADE SALESIANA DE SANTA TERESA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (882, 1156, 'FACULDADE CENECISTA DE ITABORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (883, 1157, 'ESCOLA SUPERIOR SO FRANCISCO DE ASSIS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (884, 1158, 'FACULDADE RUY BARBOSA DE CINCIA DA COMPUTAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (885, 1159, 'CENTRO DE ENSINO SUPERIOR DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (886, 1160, 'FACULDADE CAMBURY', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (887, 1161, 'FACULDADE IBMEC SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (888, 1162, 'FACULDADE DE ADMINISTRAO DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (889, 1163, 'FACULDADE DE CINCIA DA COMPUTAO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (890, 1164, 'FACULDADE VARZEAGRANDENSE DE ADMINISTRAO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (891, 1166, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DA PARABA', 1, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (892, 1168, 'FACULDADE DE ANLISE DE SISTEMAS DE INFORMAO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (893, 1169, 'FACULDADE SENAC DE MODA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (894, 1170, 'FACULDADE METROPOLITANA DE CAMAARI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (895, 1171, 'FACULDADE DE LETRAS - MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (896, 1172, 'FACULDADE AD 1', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (897, 1173, 'FACULDADE JUSCELINO KUBITSCHEK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (898, 1174, 'FACULDADE DE SABAR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (899, 1175, 'FACULDADES RIOGRANDENSES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (900, 1176, 'FACULDADE DE ANGRA DOS REIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (901, 1177, 'ESCOLA SUPERIOR DE CINCIAS AGRRIAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (902, 1179, 'ESCOLA SUPERIOR DE CINCIAS DA SADE DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (903, 1180, 'FACULDADE BARDDAL DE LETRAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (904, 1181, 'FACULDADE BRASLIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (905, 1182, 'INSTITUTO DE ENSINO SUPERIOR DE AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (906, 1183, 'INSTITUTO SO JOS DOS CAMPOS DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (907, 1184, 'CENTRO DE CINCIAS DA SADE DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (908, 1185, 'CENTRO UNIVERSITRIO JORGE AMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (909, 1186, 'FACULDADE DE TURISMO E HOTELARIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (910, 1187, 'CENTRO UNIVERSITRIO MDULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (911, 1189, 'UNIVERSIDADE DO PLANALTO CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (912, 1190, 'FACULDADE INTEGRAL CANTAREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (913, 1191, 'INSTITUTO DE ENSINO SUPERIOR DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (914, 1192, 'FACULDADE DE CINCIAS DA SADE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (915, 1194, 'FACULDADE DE TECNOLOGIA DE PONTA POR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (916, 1195, 'FACULDADE SENAI DE TECNOLOGIA MECATRNICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (917, 1196, 'CENTRO UNIVERSITRIO DE MARING - CEUMAR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (918, 1197, 'FACULDADE DE TURISMO - AEMA/RJ', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (919, 1198, 'FACULDADE DE CINCIAS SOCIAIS E APLICADAS DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (920, 1200, 'INSTITUTO BRASILIENSE DE TECNOLOGIA E CINCIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (921, 1201, 'FACULDADE DE ADMINISTRAO MILTON CAMPOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (922, 1202, 'FACULDADE SANTA RITA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (923, 1203, 'FACULDADE DE ECONOMIA DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (924, 1204, 'FACULDADE DE AMAMBAI', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (925, 1205, 'FACULDADE EDUCACIONAL DA LAPA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (926, 1206, 'FACULDADE ADVENTISTA DE FISIOTERAPIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (927, 1207, 'FACULDADE DE ADMINISTRAO GERAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (928, 1208, 'FACULDADE DE NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (929, 1209, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (930, 1210, 'FACULDADE DE CINCIAS DA COMUNICAO DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (931, 1211, 'INSTITUTO DE ENSINO SUPERIOR DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (932, 1212, 'FACULDADE DE CINCIAS CONTBEIS DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (933, 1213, 'FACULDADE FLEMING', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (934, 1215, 'FACULDADE ANGLO LATINO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (935, 1217, 'CENTRO DE TECNOLOGIA EM AUTOMAO DE INFORMTICA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (936, 1219, 'INSTITUTO ITAPETININGANO DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (937, 1220, 'INSTITUTO MATO DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (938, 1221, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (939, 1222, 'FACULDADE SENAC DE CINCIAS EXATAS E TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (940, 1223, 'FACULDADE RADIAL JABAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (941, 1224, 'CENTRO UNIVERSITRIO DE JALES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (942, 1225, 'CENTRO UNIVERSITRIO AMPARENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (943, 1226, 'INSTITUTO DE ENSINO SUPERIOR DO ACRE', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (944, 1227, 'FACULDADE SO FRANCISCO DE BARREIRAS - FASB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (945, 1228, 'FACULDADE DE TECNOLOGIA EMPRESARIAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (946, 1229, 'INSTITUTO DE ENSINO SUPERIOR DO NORDESTE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (947, 1230, 'CENTRO REGIONAL UNIVERSITRIO DE ESPRITO SANTO DO PINHAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (948, 1231, 'INSTITUTO CENECISTA DE ENSINO SUPERIOR DE SANTO NGELO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (949, 1232, 'CENTRO UNIVERSITRIO CAMPOS DE ANDRADE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (950, 1233, 'CENTRO UNIVERSITRIO CNDIDO RONDON', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (951, 1234, 'FACULDADE METROPOLITANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (952, 1235, 'ESCOLA DE EDUCAO SUPERIOR IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (953, 1236, 'ESCOLA POLITCNICA IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (954, 1237, 'FACULDADE NOSSA SENHORA APARECIDA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (955, 1238, 'FACULDADE DE CINCIAS CONTBEIS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (956, 1239, 'FACULDADE PADRO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (957, 1240, 'FACULDADE DE ESTUDOS SOCIAIS DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (958, 1241, 'FACULDADE ESPRITO SANTENSE DE ENSINO TECNOLGICO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (959, 1243, 'FACULDADE DE ADMINISTRAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (960, 1244, 'FACULDADE BRASILEIRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (961, 1245, 'FACULDADE DE CASTELO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (962, 1246, 'FACULDADE CANDIDO MENDES DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (963, 1247, 'FACULDADE DE CINCIAS CONTBEIS DE NOVA ANDRADINA - FACINAN', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (964, 1248, 'FACULDADE DE PEDAGOGIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (965, 1249, 'FACULDADE DE EDUCAO DE COSTA RICA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (966, 1252, 'FACULDADE PROMOVE DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (967, 1253, 'FACULDADE METODISTA GRANBERY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (968, 1254, 'FACULDADE DE ADMINISTRAO DE ITABIRITO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (969, 1255, 'FACULDADE BOA VIAGEM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (970, 1256, 'FACULDADE DOM BOSCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (971, 1257, 'FACULDADE DE ADMINISTRAO, CINCIAS, EDUCAO E LETRAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (972, 1258, 'FACULDADE DE CINCIAS APLICADAS DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (973, 1259, 'FACULDADE NOBEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (974, 1260, 'FACULDADE OPET', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (975, 1261, 'FACULDADE ADVENTISTA DE CINCIAS CONTBEIS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (976, 1262, 'FACULDADE ADVENTISTA DE EDUCAO DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (977, 1263, 'FACULDADE BEZERRA DE ARAJO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (978, 1264, 'FACULDADE NATALENSE PARA O DESENVOLVIMENTO DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (979, 1265, 'FACULDADE DE PROCESSAMENTO DE DADOS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (980, 1266, 'FACULDADES INTEGRADAS URUBUPUNG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (981, 1267, 'INSTITUTO DE ENSINO SUPERIOR DA GRANDE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (982, 1270, 'INSTITUTO DE ENSINO SUPERIOR COC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (983, 1271, 'FACULDADE DE COMUNICAO SOCIAL DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (984, 1272, 'FACULDADE SANTANNA DE SALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (985, 1273, 'FACULDADE CAMPO LIMPO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (986, 1274, 'FACULDADE DE EDUCAO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (987, 1275, 'FACULDADE DO GUARUJ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (988, 1276, 'INSTITUTO TAUBAT DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (989, 1277, 'FACULDADE DE INFORMTICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (990, 1278, 'FACULDADE ADVENTISTA DE EDUCAO E CINCIAS HUMANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (991, 1279, 'FACULDADE DE ITPOLIS - FACITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (992, 1280, 'INSTITUTO DE ENSINO SUPERIOR DE COTIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (993, 1281, 'FACULDADE DE CINCIAS SOCIAIS E AGRRIAS DE ITAPEVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (994, 1283, 'INSTITUTO MANCHESTER PAULISTA DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (995, 1285, 'INSTITUTO DE ENSINO SUPERIOR DE MAIRIPOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (996, 1286, 'FACULDADE SENAI DE TECNOLOGIA AMBIENTAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (997, 1287, 'FACULDADE DE CINCIAS GERENCIAIS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (998, 1288, 'FACULDADE INDEPENDENTE BUTANT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (999, 1289, 'FACULDADE DE DIREITO DA FUNDAO ARMANDO ALVARES PENTEADO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1000, 1290, 'FACULDADE ALBERT EINSTEIN DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1001, 1291, 'FACULDADE DO NORTE PIONEIRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1002, 1292, 'FACULDADES ADAMANTINENSES INTEGRADAS', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1003, 1293, 'INSTITUTO DE ENSINO SUPERIOR DO OESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1004, 1294, 'FACULDADE DAS AMRICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1005, 1295, 'FACULDADE MORUMBI SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1006, 1296, 'ESCOLA SUPERIOR DE MARKETING', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1007, 1297, 'FACULDADE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1008, 1298, 'FACULDADE DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1009, 1299, 'FACULDADES INTEGRADAS DE FERNANDPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1010, 1300, 'INSTITUTO TAQUARITINGUENSE DE ENSINO SUPERIOR DR. ARISTIDES DE CARVALHO SCHLOBACH', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1011, 1301, 'INSTITUTO MATONENSE MUNICIPAL DE ENSINO SUPERIOR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1012, 1302, 'FACULDADE BATISTA BRASILEIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1013, 1303, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA GOIANO', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1014, 1304, 'FACULDADES INTEGRADAS DE RIBEIRO PIRES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1015, 1305, 'FACULDADE DE CINCIAS JURDICAS, GERENCIAIS E EDUCAO DE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1016, 1306, 'FACULDADE DE CINCIAS CONTBEIS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1017, 1307, 'FACULDADE DE CINCIAS HUMANAS DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1018, 1308, 'FACULDADE NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1019, 1309, 'FACULDADE JESUS MARIA JOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1020, 1310, 'FACULDADE DE AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1021, 1311, 'TREVISAN ESCOLA SUPERIOR DE NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1022, 1312, 'FACULDADES INTEGRADAS DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1023, 1313, 'FACULDADE BANDEIRANTES DE EDUCAO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1024, 1314, 'INSTITUTO DE ENSINO SUPERIOR JOO ALFREDO DE ANDRADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1025, 1315, 'FACULDADE DE EDUCAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1026, 1316, 'FACULDADE DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1027, 1317, 'FACULDADE SUDOESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1028, 1318, 'FACULDADE JUVNCIO TERRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1029, 1319, 'FACULDADE TECSOMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1030, 1320, 'FACULDADE DE EDUCAO FSICA DO LITORAL NORTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1031, 1321, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS DA ZONA NORTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1032, 1322, 'FACULDADE EDUVALE DE AVAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1033, 1323, 'FACULDADE TANCREDO NEVES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1034, 1324, 'FACULDADE DE INFORMTICA LEMOS DE CASTRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1035, 1325, 'FACULDADE DE APUCARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1036, 1326, 'ESCOLA SUPERIOR DE ENSINO ANSIO TEIXEIRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1037, 1327, 'ESCOLA SUPERIOR DE PROPAGANDA E MARKETING DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1038, 1328, 'FACULDADE DE COMUNICAO E TURISMO DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1039, 1329, 'FACULDADE DE ADMINISTRAO DE DIADEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1040, 1330, 'FACULDADE COTEMIG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1041, 1331, 'FACULDADE HOYLER DE COMUNICAO SOCIAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1042, 1332, 'FACULDADE DE COMUNICAO SOCIAL DE HORTOLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1043, 1333, 'FACULDADE CECAP DO LAGO NORTE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1044, 1334, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS - FACISA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1045, 1335, 'INSTITUTO DE ENSINO SUPERIOR THATHI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1046, 1336, 'FACULDADE ASSIS GURGACZ', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1047, 1337, 'FACULDADE MATER DEI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1048, 1338, 'FACULDADE DE EDUCAO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1049, 1339, 'FACULDADE DE CINCIAS ADMINISTRATIVAS DE PARANABA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1050, 1340, 'FACULDADE DE CINCIAS GERENCIAIS DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1051, 1341, 'FACULDADE DE ARQUITETURA E URBANISMO DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1052, 1342, 'FACULDADE DE PEDAGOGIA DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1053, 1343, 'FACULDADE DE EDUCAO DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1054, 1344, 'FACULDADE DO SABER', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1055, 1345, 'FACULDADE INTEGRAO - ZONA OESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1056, 1346, 'FACULDADE BATISTA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1057, 1347, 'FACULDADE ADVENTISTA DE ADMINISTRAO DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1058, 1348, 'FACULDADE BATISTA DE ADMINISTRAO E INFORMTICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1059, 1349, 'FACULDADE DE CINCIAS ECONMICAS DE AFONSO CLUDIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1060, 1350, 'FACULDADE DO VALE DO JAGUARIBE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1061, 1351, 'INSTITUTO SUPERIOR TUPY - IST', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1062, 1352, 'FACULDADE ADVENTISTA DE EDUCAO FSICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1063, 1353, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1064, 1354, 'FACULDADE DE CINCIA DE ADMINISTRAO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1065, 1355, 'FACULDADES INTEGRADAS DE JAHU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1066, 1356, 'FACULDADES INTEGRADAS DE SANTA F DO SUL', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1067, 1357, 'INSTITUTO SUPERIOR DE EDUCAO DO RIO DE JANEIRO', 2, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1068, 1358, 'FACULDADE DE PEDAGOGIA DE AFONSO CLUDIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1069, 1359, 'FACULDADE CAPIXABA DE NOVA VENCIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1070, 1360, 'FACULDADE SO GABRIEL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1071, 1361, 'FACULDADE DOM ORIONE', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1072, 1362, 'FACULDADE UBAENSE OZANAM COELHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1073, 1363, 'FACULDADE VISCONDE DE CAIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1074, 1364, 'FACULDADE DE TECNOLOGIA E CINCIAS DE VITRIA DA CONQUISTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1075, 1365, 'CENTRO UNIVERSITRIO ADVENTISTA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1076, 1366, 'FACULDADE BARDDAL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1077, 1367, 'FACULDADE DE CINCIA DA COMPUTAO DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1078, 1368, 'FACULDADE DE CINCIAS CONTBEIS DE BOM DESPACHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1079, 1369, 'FACULDADE SENAC DE TURISMO E HOTELARIA DE GUAS DE SO PEDRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1080, 1370, 'FACULDADE SENAC DE TURISMO E HOTELARIA DE CAMPOS DO JORDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1081, 1371, 'FACULDADE DE MIRANDPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1082, 1372, 'FACULDADE SENAC DE EDUCAO AMBIENTAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1083, 1373, 'FACULDADE CASA BRANCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1084, 1374, 'FACULDADE DE CINCIAS SOCIAIS DE GUARANT DO NORTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1085, 1375, 'FACULDADE CATLICA RAINHA DA PAZ DE ARAPUTANGA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1086, 1376, 'FACULDADE COMPACTO DE EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1087, 1377, 'FACULDADE DE CINCIA E TECNOLOGIA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1088, 1378, 'FACULDADE ASSEMBLEIANA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1089, 1379, 'FACULDADES INTEGRADAS SO PEDRO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1090, 1380, 'FACULDADE DE DOMINGOS MARTINS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1091, 1381, 'FACULDADE MARTHA FALCO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1092, 1382, 'ESCOLA SUPERIOR DE TEOLOGIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1093, 1383, 'FACULDADE JOS LACERDA FILHO DE CINCIAS APLICADAS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1094, 1384, 'FACULDADE SANTA HELENA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1095, 1385, 'FACULDADES INTEGRADAS IPEP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1096, 1386, 'ESCOLA SUPERIOR DE ADMINISTRAO E MARKETING E COMUNICAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1097, 1387, 'FACULDADE OCTGONO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1098, 1388, 'FACULDADE SUMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1099, 1389, 'FACULDADE TORRICELLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1100, 1390, 'FACULDADE ELITE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1101, 1394, 'FACULDADE CASTRO ALVES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1102, 1395, 'FACULDADE DE CALDAS NOVAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1103, 1396, 'FACULDADE DINMICA DAS CATARATAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1104, 1397, 'FACULDADE OESTE MINEIRA DE INFORMTICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1105, 1398, 'FACULDADE DE DIREITO DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1106, 1399, 'FACULDADE UNISSA DE SARANDI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1107, 1400, 'FACULDADE METROPOLITANA DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1108, 1401, 'FACULDADE ADELMAR ROSADO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1109, 1402, 'INSTITUTO DE CINCIAS SOCIAIS E HUMANAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1110, 1403, 'FACULDADE DE PIMENTA BUENO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1111, 1404, 'FACULDADE DE PIRACANJUBA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1112, 1405, 'FACULDADE DE CINCIAS CONTBEIS DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1113, 1406, 'FACULDADE DE ENGENHARIA E TECNOLOGIA DO INSTITUTO MAIRIPOR DE ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1114, 1407, 'FACULDADE DE ECONOMIA E ADMINISTRAO DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1115, 1408, 'FACULDADE DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1116, 1409, 'FACULDADE DO CENTRO LESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1117, 1410, 'REA1 - FACULDADE DE CINCIA E TECNOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1118, 1411, 'FACULDADE DOIS DE JULHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1119, 1412, 'FACULDADE ANHAGUERA DE JUNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1120, 1413, 'FACULDADE DE PRIMAVERA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1121, 1414, 'FACULDADE SO LUCAS', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1122, 1415, 'FACULDADE MAGISTER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1123, 1416, 'FACULDADE GRANDE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1124, 1417, 'FACULDADE CENECISTA DE CAMPO LARGO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1125, 1418, 'CENTRO UNIVERSITRIO TOLEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1126, 1419, 'CENTRO UNIVERSITRIO CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1127, 1420, 'FACULDADES DE DRACENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1128, 1422, 'CENTRO UNIVERSITRIO DO NORTE', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1129, 1423, 'FACULDADE IDEAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1130, 1424, 'FACULDADE PIO XII', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1131, 1425, 'FACULDADE EVOLUTIVO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1132, 1426, 'INSTITUTO LUTERANO DE ENSINO SUPERIOR DE ITUMBIARA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1133, 1427, 'FACULDADE DA SERRA GACHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1134, 1428, 'INSTITUTO DE ENSINO SUPERIOR PLANALTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1135, 1429, 'FACULDADE BATISTA DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1136, 1430, 'FACULDADE ING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1137, 1431, 'FACULDADE PIRATININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1138, 1432, 'FACULDADE BERTIOGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1139, 1433, 'FACULDADE ORGENES LESSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1140, 1434, 'INSTITUTO DE ENSINO SUPERIOR DE ITAPIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1141, 1435, 'FACULDADE DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1142, 1436, 'ESCOLA SUPERIOR BATISTA DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1143, 1437, 'ESCOLA SUPERIOR DE TECNOLOGIA E EDUCAO DE RIO CLARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1144, 1438, 'FACULDADE DE ADMINISTRAO DE EMPRESAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1145, 1439, 'FACULDADE DE CINCIAS ECONMICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1146, 1440, 'INSTITUTO APHONSIANO DE ENSINO SUPERIOR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1147, 1441, 'FACULDADE DE TECNOLOGIA DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1148, 1442, 'FACULDADE DE DIREITO DE TANGAR DA SERRA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1149, 1443, 'FACULDADE NACIONAL', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1150, 1444, 'FACULDADES INTEGRADAS EINSTEIN DE LIMEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1151, 1445, 'CENTRO UNIVERSITRIO DO INSTITUTO MAU DE TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1152, 1446, 'CENTRO UNIVERSITRIO PLANALTO DO DISTRITO FEDERAL - UNIPLAN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1153, 1447, 'FACULDADE DE DIREITO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1154, 1448, 'FACULDADE DO CENTRO EDUCACIONAL DE NITERI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1155, 1449, 'FACULDADE DE EDUCAO, ADMINISTRAO E TECNOLOGIA DE IBAITI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1156, 1450, 'CENTRO UNIVERSITRIO DO CERRADO-PATROCNIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1157, 1451, 'FACULDADES INTEGRADAS DE SO CARLOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1158, 1452, 'FACULDADE ATENAS MARANHENSE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1159, 1453, 'FACULDADE SARANDI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1160, 1454, 'FACULDADE SALESIANA DO NORDESTE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1161, 1455, 'FACULDADE SANTSSIMO SACRAMENTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1162, 1456, 'FACULDADE DE SERTOZINHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1163, 1457, 'FACULDADE EURO-PANAMERICANA DE HUMANIDADES E TECNOLOGIAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1164, 1458, 'FACULDADE DO NORTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1165, 1459, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1166, 1460, 'FACULDADE DE CINCIAS SOCIAIS E APLICADAS DO COMPLEXO DE ENSINO SUPERIOR DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1167, 1461, 'FACULDADE DE TECNOLOGIA E CINCIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1168, 1462, 'INSTITUTO PARAIBANO DE ENSINO RENOVADO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1169, 1463, 'FACULDADE ALFACASTELO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1170, 1464, 'FACULDADE MDULO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1171, 1465, 'FACULDADE BANDEIRANTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1172, 1466, 'INSTITUTO DE ENSINO SUPERIOR DE ALPHAVILLE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1173, 1467, 'FACULDADE CENECISTA DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1174, 1468, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1175, 1469, 'FACULDADE DE CINCIAS SOCIAIS DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1176, 1470, 'FACULDADE CAMES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1177, 1471, 'INSTITUTO DE ENSINO SUPERIOR DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1178, 1472, 'CENTRO UNIVERSITRIO LEONARDO DA VINCI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1179, 1473, 'FACULDADE DE ADMINISTRAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1180, 1474, 'FACULDADE DE EDUCAO DE ATIBAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1181, 1475, 'FACULDADE DE CINCIAS ECONMICAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1182, 1476, 'FACULDADES INTEGRADAS INTERAMERICANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1183, 1477, 'FACULDADE MICHELANGELO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1184, 1478, 'FACULDADE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1185, 1479, 'FACULDADES INTEGRADAS TIBIRI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1186, 1480, 'FACULDADE DE LETRAS DOMUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1187, 1481, 'FACULDADE DE ADMINISTRAO DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1188, 1482, 'FACULDADE DE CINCIAS ECONMICAS VIANNA JNIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1189, 1483, 'FACULDADE DE CINCIAS ECONMICAS DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1190, 1484, 'FACULDADE IBMEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1191, 1485, 'FACULDADE DE ENFERMAGEM DE CATANDUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1192, 1486, 'FACULDADE ESTCIO DE S DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1193, 1487, 'FACULDADE DOM BOSCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1194, 1488, 'FACULDADE PARASO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1195, 1489, 'FACULDADE DE SELVRIA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1196, 1490, 'FACULDADE DE JAGUARINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1197, 1491, 'FACULDADE INTERNACIONAL DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1198, 1492, 'FACULDADE DE CINCIAS APLICADAS DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1199, 1493, 'FACULDADE ALVES FARIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1200, 1494, 'FACULDADE SALESIANA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1201, 1495, 'FACULDADE UNIO DE QUEDAS DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1202, 1496, 'FACULDADE ESTCIO DE S DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1203, 1497, 'FACULDADE DE ADMINISTRAO DE SANTA CRUZ DO RIO PARDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1204, 1498, 'INSTITUTO DE ENSINO SUPERIOR E FORMAO AVANADA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1205, 1499, 'FACULDADE TABOO DA SERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1206, 1500, 'FACULDADE DE ENSINO SUPERIOR DE SO MIGUEL DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1207, 1501, 'FACULDADE LATINO AMERICANA DE EDUCAO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1208, 1502, 'FACULDADE JAPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1209, 1503, 'FACULDADE DOUTOR LEOCDIO JOS CORREIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1210, 1504, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE MACEI - ESAMC', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1211, 1505, 'FACULDADE DE MEDICINA VETERINRIA E ZOOTECNIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1212, 1506, 'INSTITUTO CENECISTA FAYAL DE ENSINO SUPERIOR', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1213, 1507, 'FACULDADE CENECISTA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1214, 1508, 'FACULDADE METROPOLITANA DE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1215, 1509, 'FACULDADE ESTCIO DE S DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1216, 1510, 'FACULDADE ESTCIO DE S DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1217, 1511, 'FACULDADE DE ENFERMAGEM DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1218, 1512, 'FACULDADE DE CINCIA DA EDUCAO DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1219, 1513, 'INSTITUTO DE CINCIAS JURDICAS E SOCIAIS PROFESSOR CAMILLO FILHO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1220, 1514, 'FACULDADE VALE DO CRICAR', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1221, 1515, 'FACULDADE DE EDUCAO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1222, 1516, 'FACULDADE DE VINHEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1223, 1517, 'FACULDADE NOVO ATENEU DE GUARAPUAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1224, 1518, 'FACULDADE SANTA TEREZINHA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1225, 1519, 'FACULDADE DE PATO BRANCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1226, 1520, 'FACULDADE MRIO DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1227, 1521, 'INSTITUTO DE ESTUDOS SUPERIORES DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1228, 1522, 'FACULDADE DE EDUCAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1229, 1523, 'FACULDADE DE DIREITO FRANCISCO BELTRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1230, 1524, 'FACULDADES INTEGRADAS OLGA METTIG', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1231, 1525, 'FACULDADE DE CINCIAS CONTBEIS DE AFONSO CLUDIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1232, 1526, 'FACULDADE SENAI DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1233, 1527, 'FACULDADE TAMOIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1234, 1528, 'FACULDADE DE CINCIAS HUMANAS SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1235, 1529, 'FACULDADE DE EDUCAO FSICA DE AMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1236, 1530, 'FACULDADE CENECISTA DE JOINVILLE - FACE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1237, 1531, 'FACULDADE DE ENFERMAGEM DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1238, 1532, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS NOSSA SENHORA APARECIDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1239, 1533, 'FACULDADE DE COMUNICAO SOCIAL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1240, 1534, 'FACULDADE DE CINCIAS, LETRAS E EDUCAO DO NOROESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1241, 1535, 'FACULDADE SO JUDAS TADEU DE PINHAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1242, 1536, 'FACULDADE DE TELMACO BORBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1243, 1537, 'FACULDADE EXPONENCIAL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1244, 1538, 'FACULDADE PROJEO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1245, 1539, 'FACULDADE TALO BRASILEIRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1246, 1540, 'INSTITUTO DE ENSINO SUPERIOR DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1247, 1541, 'FACULDADE FLAMINGO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1248, 1542, 'CENTRO UNIVERSITRIO GERALDO DI BIASE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1249, 1543, 'FACULDADE DE DIREITO DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1250, 1544, 'FACULDADE DECISO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1251, 1545, 'INSTITUTO DE EDUCAO SUPERIOR DE BOITUVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1252, 1546, 'FACULDADE DE EDUCAO SO FRANCISCO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1253, 1547, 'FACULDADE DE MEDICINA DE JUAZEIRO DO NORTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1254, 1548, 'FACULDADE CAMPO GRANDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1255, 1549, 'FACULDADE PALAS ATENA DE CHOPINZINHO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1256, 1550, 'FACULDADE DE EDUCAO FSICA DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1257, 1551, 'FACULDADE FRANCO-BRASILEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1258, 1552, 'FACULDADE PIAUIENSE', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1259, 1553, 'FACULDADE DE ODONTOLOGIA DE SO JOS DO RIO PRETO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1260, 1554, 'FACULDADES INTEGRADAS DO VALE DO RIBEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1261, 1555, 'FACULDADE DE DIREITO DE GUARAPUAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1262, 1556, 'FACULDADE SETE DE SETEMBRO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1263, 1557, 'UNIVERSIDADE FUMEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1264, 1558, 'INSTITUTO DE ENSINO SUPERIOR DE JOO MONLEVADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1265, 1559, 'CENTRO UNIVERSITRIO DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1266, 1561, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1267, 1562, 'FACULDADE DE ILHA SOLTEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1268, 1563, 'FACULDADE DE SADE, CINCIAS HUMANAS E TECNOLGICAS DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1269, 1564, 'FACULDADE SUL FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1270, 1565, 'FACULDADE UNIME DE CINCIAS JURDICAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1271, 1566, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1272, 1567, 'FACULDADE VIZINHANA VALE DO IGUAU', 3, 1, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1273, 1568, 'FACULDADES INTEGRADAS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1274, 1569, 'FACULDADES INTEGRADAS DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1275, 1570, 'FACULDADE DE CINCIAS CONTBEIS DE POMBAL', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1276, 1571, 'FACULDADE UNIME DE CINCIAS SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1277, 1572, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1278, 1573, 'FACULDADE ALFREDO NASSER', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1279, 1574, 'FACULDADE EDUCACIONAL DE MEDIANEIRA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1280, 1575, 'CENTRO UNIVERSITRIO DO PLANALTO DE ARAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1281, 1576, 'INSTITUTO DE ENSINO SUPERIOR BLAURO CARDOSO DE MATTOS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1282, 1577, 'FACULDADE INTERMUNICIPAL DO NOROESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1283, 1578, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA SUL-RIO-GRANDENSE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1284, 1579, 'FACULDADE DE CINCIAS SOCIAIS DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1285, 1580, 'FACULDADE DE CINCIAS E EDUCAO SENA AIRES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1286, 1581, 'FACULDADE DA CIDADE DE SANTA LUZIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1287, 1582, 'FACULDADE DECISO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1288, 1583, 'FACULDADE DE TECNOLOGIA DE INDAIATUBA', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1289, 1584, 'FACULDADE DE TECNOLOGIA DE GUARATINGUET', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1290, 1585, 'FACULDADE ENERGIA DE ADMINISTRAO E NEGCIOS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1291, 1586, 'UNIVERSIDADE DO VALE DO SAPUCA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1292, 1587, 'FACULDADES INTEGRADAS DE TANGAR DA SERRA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1293, 1588, 'FACULDADE PITGORAS DE TURISMO E HOTELARIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1294, 1589, 'FACULDADE DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1295, 1590, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS APLICADAS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1296, 1591, 'FACULDADE SEAMA', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1297, 1592, 'FACULDADE DE ODONTOLOGIA DE MANAUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1298, 1593, 'FACULDADE DE PEDAGOGIA DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1299, 1594, 'FACULDADE DE LETRAS DA INSTITUIO DE ENSINO SUPERIOR DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1300, 1595, 'FACULDADE DE LETRAS UNIO DE ENSINO SUPERIOR CERTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1301, 1596, 'FACULDADE DE CINCIAS E EDUCAO DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1302, 1597, 'FACULDADE SANTA F', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1303, 1598, 'FACULDADE POLITCNICA DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1304, 1599, 'INSTITUTO DE ENSINO SUPERIOR PRESIDENTE TANCREDO DE ALMEIDA NEVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1305, 1600, 'INSTITUTO DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1306, 1601, 'FACULDADE CIDADE DE COROMANDEL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1307, 1602, 'FACULDADE DE CINCIAS GERENCIAIS DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1308, 1603, 'FACULDADE DE COMUNICAO SOCIAL DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1309, 1604, 'FACULDADE MAGNUN DE EDUCAO FSICA E ESPORTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1310, 1605, 'FACULDADE DE ADMINISTRAO DE NOVA ANDRADINA - FANOVA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1311, 1606, 'FACULDADE VALE DO APOR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1312, 1607, 'FACULDADE LUTERANA SO MARCOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1313, 1608, 'FACULDADE DE INFORMTICA DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1314, 1609, 'FACULDADE DOS CERRADOS PIAUIENSES', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1315, 1610, 'FACULDADE DAS ATIVIDADES EMPRESARIAIS DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1316, 1611, 'FACULDADE EDUCACIONAL DE ARAPOTI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1317, 1612, 'FACULDADE SUL BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1318, 1613, 'FACULDADE ADVENTISTA PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1319, 1614, 'FACULDADE PALAS ATENA DE ASTORGA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1320, 1615, 'INSTITUTO SUPERIOR DO LITORAL DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1321, 1616, 'FACULDADE ANGEL VIANNA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1322, 1617, 'FACULDADE DE CINCIAS ECONMICAS DA REGIO CARBONFERA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1323, 1618, 'INSTITUTO BLUMENAUENSE DE ENSINO SUPERIOR', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1324, 1619, 'FACULDADE ERNESTO RISCALI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1325, 1620, 'FACULDADE SANTA RITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1326, 1621, 'FACULDADE NETWORK', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1327, 1622, 'FACULDADE DO INTERIOR PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1328, 1623, 'FACULDADE DE CINCIAS AGRRIAS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1329, 1624, 'FACULDADE MARECHAL RONDON', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1330, 1625, 'FACULDADE REUNIDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1331, 1626, 'CENTRO DE TECNOLOGIA E CINCIA - CETEC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1332, 1627, 'FACULDADE DE EDUCAO DE MONTE ALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1333, 1628, 'FACULDADE DE CINCIAS HUMANAS DE AGUA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1334, 1629, 'INSTITUTO DE ENSINO SUPERIOR AQUIDAUANENSE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1335, 1630, 'FACULDADE ITABIRANA DE DESENVOLVIMENTO DAS CINCIAS E TECNOLOGIAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1336, 1631, 'FACULDADE PITGORAS DE FISIOTERAPIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1337, 1632, 'FACULDADE METROPOLITANA LONDRINENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1338, 1633, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE CUIAB', 1, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1339, 1634, 'FACULDADE BATISTA DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1340, 1635, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1341, 1636, 'CASTELLI ESCOLA SUPERIOR DE HOTELARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1342, 1637, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DE MACEI', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1343, 1638, 'FACULDADE DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1344, 1639, 'FACULDADE HLIO ROCHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1345, 1640, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1346, 1641, 'FACULDADE SOCIAL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1347, 1642, 'FACULDADE DE TECNOLOGIA E CINCIAS DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1348, 1643, 'FACULDADE ANSIO TEIXEIRA DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1349, 1644, 'FACULDADE UNIME DE EDUCAO E COMUNICAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1350, 1645, 'FACULDADE DE TECNOLOGIA E CINCIAS DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1351, 1646, 'FACULDADE DE EDUCAO CINCIAS E LETRAS DE PARASO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1352, 1647, 'INSTITUTO DE ENSINO SUPERIOR DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1353, 1648, 'FACULDADE COMPACTO DE COMUNICAO SOCIAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1354, 1649, 'FACULDADE DE COMUNICAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1355, 1650, 'FACULDADE J. SIMES ENSINO SUPERIOR', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1356, 1651, 'FACULDADE DE EDUCAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1357, 1652, 'FACULDADE DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1358, 1653, 'FACULDADE DE GUAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1359, 1654, 'INSTITUTO DE ENSINO SUPERIOR DE NOVA VENCIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1360, 1655, 'FACULDADE CENECISTA DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1361, 1656, 'INSTITUTO DE ENSINO SUPERIOR DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1362, 1657, 'FACULDADE EDUCACIONAL DE DOIS VIZINHOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1363, 1658, 'FACULDADE INTEGRADA DA GRANDE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1364, 1659, 'FACULDADE ESTCIO DE S DE OURINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1365, 1660, 'FACULDADE DE CINCIAS SOCIAIS E TECNOLGICAS FACITEC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1366, 1661, 'FACULDADE DE ADMINISTRAO ESCOLA SUPERIOR PROFESSOR PAULO MARTINS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1367, 1662, 'FACULDADE CAPIXABA DE ADMINISTRAO E EDUCAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1368, 1663, 'FACULDADE ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1369, 1664, 'FACULDADE DA SADE E ECOLOGIA HUMANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1370, 1665, 'FACULDADE KENNEDY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1371, 1666, 'FACULDADE NOVOS HORIZONTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1372, 1667, 'FACULDADE INTERNACIONAL DE CINCIAS EMPRESARIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1373, 1668, 'FACULDADE METROPOLITANA DE BELO HORIZONTE -METROPOLITANA -BH', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1374, 1669, 'INSTITUTO METROPOLITANO DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1375, 1670, 'FACULDADE ASA DE BRUMADINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1376, 1671, 'FACULDADE DE ENSINO UNIFICADO DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1377, 1672, 'INSTITUTO ESPERANA DE ENSINO SUPERIOR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1378, 1673, 'FACULDADE DE AGRONOMIA DE POMBAL', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1379, 1674, 'INSTITUTO SALESIANO DE FILOSOFIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1380, 1675, 'FACULDADE METROPOLITANA DA GRANDE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1381, 1676, 'FACULDADE SO MIGUEL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1382, 1677, 'FACULDADE DE ENSINO SUPERIOR DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1383, 1678, 'FACULDADE DE CINCIAS DE WENCESLAU BRAZ', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1384, 1679, 'FACULDADE DE CAMPINA GRANDE DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1385, 1680, 'FACULDADE DE CINCIAS E TECNOLOGIA MATER CHRISTI', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1386, 1681, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS IBMEC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1387, 1682, 'FACULDADE SALESIANA MARIA AUXILIADORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1388, 1683, 'FACULDADE PIAUIENSE', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1389, 1684, 'FACULDADE DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1390, 1685, 'FACULDADE BARDDAL DE CINCIAS CONTBEIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1391, 1686, 'FACULDADE BARDDAL DE ARTES APLICADAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1392, 1687, 'FACULDADE IDEPE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1393, 1688, 'FACULDADE SENAC DE EDUCAO EM SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1394, 1689, 'FACULDADE SANTA IZILDINHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1395, 1690, 'FACULDADE DE SO VICENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1396, 1691, 'FACULDADE PRXIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1397, 1692, 'ESCOLA SUPERIOR DE TECNOLOGIA E EDUCAO DE PORTO FERREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1398, 1693, 'FACULDADE ITANHAM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1399, 1694, 'ESCOLA SUPERIOR DE CRICIMA - ESUCRI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1400, 1695, 'FACULDADE DE EDUCAO DE BOM DESPACHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1401, 1696, 'FACULDADE CENTRAL DE CRISTALINA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1402, 1697, 'FACULDADE ESCRITOR OSMAN DA COSTA LINS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1403, 1698, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DO CESCARELI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1404, 1699, 'FACULDADE DE EDUCAO DE JARU', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1405, 1700, 'FACULDADE SETE LAGOAS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1406, 1701, 'FACULDADE MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1407, 1702, 'FACULDADE ATUAL DA AMAZNIA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1408, 1703, 'INSTITUTO DE ENSINO SUPERIOR DE RIO VERDE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1409, 1704, 'FACULDADE DE ADMINISTRAO DO ALTO VALE DO RIO TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1410, 1705, 'FACULDADE DE EDUCAO DO ALTO VALE DO RIO TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1411, 1706, 'FACULDADE DE INFORMTICA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1412, 1707, 'FACULDADE DE CINCIAS CONTBEIS DE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1413, 1708, 'INSTITUTO PERNAMBUCANO DE ENSINO SUPERIOR', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1414, 1709, 'FACULDADE INTEGRADA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1415, 1710, 'FACULDADE DE NEGCIOS E TECNOLOGIAS DA INFORMAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1416, 1711, 'FACULDADE DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1417, 1712, 'FACULDADE DE CINCIAS E TECNOLOGIA DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1418, 1713, 'FACULDADE DE TECNOLOGIA DE SO VICENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1419, 1714, 'ESCOLA SUPERIOR DE GESTO COMERCIAL E MARKETING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1420, 1715, 'FACULDADE DO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1421, 1716, 'FACULDADE UNIO DAS AMRICAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1422, 1717, 'FACULDADE DE IMPERATRIZ', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1423, 1718, 'FACULDADE NOBRE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1424, 1719, 'FACULDADE DE ADMINISTRAO DE CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1425, 1720, 'FACULDADE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1426, 1721, 'FACULDADE DE VIOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1427, 1722, 'FACULDADE DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1428, 1723, 'ESCOLA SUPERIOR DE ADMINISTRAO E GESTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1429, 1724, 'FACULDADE DE GUARARAPES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1430, 1725, 'FACULDADE XV DE AGOSTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1431, 1726, 'FACULDADE SANTA AMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1432, 1727, 'FACULDADE DE CARIACICA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1433, 1728, 'FACULDADE INTERAMERICANA DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1434, 1729, 'FACULDADE DE ODONTOLOGIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1435, 1730, 'FACULDADE NORTE CAPIXABA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1436, 1731, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1437, 1732, 'FACULDADE GENNARI E PEARTREE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1438, 1733, 'FACULDADE DE ENSINO SUPERIOR DE MARECHAL CNDIDO RONDON', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1439, 1734, 'FACULDADE INTEGRAL DIFERENCIAL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1440, 1735, 'FACULDADE DE CINCIAS APLICADAS DOUTOR LEO SAMPAIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1441, 1736, 'INSTITUTO SUPERIOR DE EDUCAO LA SALLE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1442, 1737, 'FACULDADE DE INFORMTICA DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1443, 1738, 'INSTITUTO LUTERANO DE ENSINO SUPERIOR DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1444, 1739, 'INSTITUTO DE ENSINO SUPERIOR DO CENTRO OESTE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1445, 1740, 'FACULDADE DE TECNOLOGIA RADIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1446, 1741, 'FACULDADE DE TECNOLOGIA INTERAMRICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1447, 1742, 'FACULDADE DE TECNOLOGIA CARLOS DRUMMOND DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1448, 1743, 'FACULDADE DE TECNOLOGIA OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1449, 1744, 'FACULDADE DE TECNOLOGIA OPET', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1450, 1745, 'FACULDADE DE TECNOLOGIA ALBERT EINSTEIN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1451, 1746, 'FACULDADE DE TECNOLOGIA DAS AMRICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1452, 1747, 'FACULDADE DE TECNOLOGIA FLAMINGO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1453, 1748, 'FACULDADE DE TECNOLOGIA MRIO DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1454, 1749, 'FACULDADE LUSO-BRASILEIRA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1455, 1750, 'UNIDADE DE ENSINO SUPERIOR EXPOENTE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1456, 1751, 'FACULDADE DE DESIGN GRFICO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1457, 1752, 'FACULDADE AUTNOMA DE DIREITO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1458, 1753, 'FACULDADE DE ENFERMAGEM NOVA ESPERANA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1459, 1754, 'INSTITUTO SUPERIOR DE EDUCAO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1460, 1755, 'FACULDADE EQUIPE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1461, 1756, 'FACULDADE ASSOCIADA BRASIL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1462, 1757, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1463, 1758, 'FACULDADE INDEPENDENTE DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1464, 1759, 'FACULDADE PADRE JOO BAGOZZI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1465, 1760, 'FACULDADE DE PEDAGOGIA DE VITRIA DE SANTO ANTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1466, 1761, 'FACULDADE BRASILEIRA DE GESTO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1467, 1762, 'FACULDADE DE TECNOLOGIA JOO XXIII', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1468, 1763, 'FACULDADE DE TECNOLOGIA SENAI CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1469, 1764, 'FACULDADE DE EDUCAO REGIONAL SERRANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1470, 1765, 'FACULDADE DE JOS BONIFCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1471, 1766, 'FACULDADE ESPRITO SANTENSE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1472, 1767, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1473, 1768, 'FACULDADE REGIONAL SERRANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1474, 1769, 'FACULDADE DE TURISMO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1475, 1770, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DA INSTITUIO DE ENSINO SUPERIOR DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1476, 1771, 'FACULDADE SANTA MARIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1477, 1772, 'FACULDADE NORDESTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1478, 1773, 'FACULDADE DE ITAPIRANGA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1479, 1774, 'FACULDADE EDUCACIONAL DE PONTA GROSSA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1480, 1775, 'FACULDADE DO VALE DO IPOJUCA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1481, 1776, 'FACULDADE DE TECNOLOGIA PROF. LUIZ ROSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1482, 1777, 'FACULDADE METROPOLITANA DE GUARAMIRIM', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1483, 1778, 'FACULDADE DE EDUCAO, CINCIAS E LETRAS SO JUDAS TADEU', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1484, 1779, 'FACULDADE AIEC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1485, 1780, 'FACULDADE HORIZONTINA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1486, 1781, 'FACULDADE INTESP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1487, 1782, 'FACULDADE DE ARTES, CINCIAS E TECNOLOGIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1488, 1783, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1489, 1784, 'FACULDADE EDITORA NACIONAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1490, 1785, 'FACULDADE DE COLIDER', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1491, 1786, 'INSTITUTO MACHADENSE DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1492, 1787, 'INSTITUTO DE ENSINO SUPERIOR DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1493, 1788, 'FACULDADE DE ADMINISTRAO E ARTES DE LIMEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1494, 1789, 'INSTITUTO CATUA DE ENSINO SUPERIOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1495, 1790, 'INSTITUTO SUPERIOR DE EDUCAO DO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1496, 1791, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DA UNIO DE ENSINO SUPERIOR CERTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1497, 1792, 'FACULDADE DE EDUCAO DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1498, 1793, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1499, 1794, 'FACULDADE DE CINCIAS HUMANAS DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1500, 1795, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1501, 1796, 'FACULDADE DE MATEMTICA DA INSTITUIO DE ENSINO SUPERIOR DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1502, 1797, 'FACULDADE NORTE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1503, 1798, 'FACULDADE EDUCACIONAL DE CORNLIO PROCPIO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1504, 1799, 'FACULDADE BRASLIA DE TECNOLOGIA, CINCIAS E EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1505, 1800, 'FACULDADE DE REALEZA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1506, 1801, 'FACULDADE DOM BOSCO DE UBIRAT', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1507, 1802, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1508, 1803, 'FACULDADE DE INFORMTICA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1509, 1804, 'FACULDADE DE MAU - FAMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1510, 1805, 'FACULDADE DOS GUARARAPES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1511, 1806, 'FACULDADE FERNO DIAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1512, 1807, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO CEAR', 1, 1, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1513, 1808, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO ESPRITO SANTO', 1, 1, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1514, 1809, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE PERNAMBUCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1515, 1810, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE SO PAULO', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1516, 1811, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE GOIS', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1517, 1812, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DO AMAZONAS', 1, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1518, 1813, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO PAR', 1, 1, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1519, 1814, 'FACULDADE DE CINCIAS SOCIAIS E APLICADAS DE DIAMANTINO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1520, 1815, 'FACULDADE DO INSTITUTO BRASIL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1521, 1816, 'INSTITUTO DE ENSINO SUPERIOR DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1522, 1817, 'FACULDADE RADIAL CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1523, 1818, 'FACULDADE PITGORAS DE ADMINISTRAO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1524, 1819, 'FACULDADE FARIAS BRITO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1525, 1820, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO PIAU', 1, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1526, 1821, 'FACULDADE LIONS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1527, 1822, 'FACULDADE SUL-AMERICANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1528, 1823, 'INSTITUTO DE ENSINO SUPERIOR DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1529, 1824, 'FACULDADE DE CINCIAS CONTBEIS DE ITABIRITO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1530, 1825, 'FACULDADE DE ESTUDOS SUPERIORES DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1531, 1826, 'FACULDADE DE DIREITO DE LEOPOLDINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1532, 1827, 'FACULDADE LUTERANA DE TEOLOGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1533, 1828, 'ESCOLA DA CIDADE - FACULDADE DE ARQUITETURA E URBANISMO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1534, 1829, 'FACULDADE DE TECNOLOGIA UIRAPURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1535, 1830, 'FACULDADE ANHANGUERA DE PASSO FUNDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1536, 1831, 'FACULDADE CENTRO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1537, 1832, 'FACULDADE DE JABOTICABAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1538, 1833, 'FACULDADE DE ARUJ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1539, 1834, 'FACULDADE DE AGUDOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1540, 1835, 'FACULDADE INTEGRADA DE ENSINO SUPERIOR DE COLINAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1541, 1836, 'CENTRO UNIVERSITRIO FUNDAO DE ENSINO OCTVIO BASTOS - FEOB', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1542, 1837, 'ESCOLA DE ESTUDOS SUPERIORES DE VIOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1543, 1838, 'FACULDADES INTEGRADAS RIO BRANCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1544, 1839, 'FACULDADES INTEGRADAS DE VRZEA GRANDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1545, 1840, 'FACULDADE CASTELO BRANCO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1546, 1841, 'FACULDADES INTEGRADAS ANTNIO EUFRSIO DE TOLEDO DE PRESIDENTE PRUDENTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1547, 1842, 'FACULDADES INTEGRADAS MACHADO DE ASSIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1548, 1843, 'FACULDADE DE ADMINISTRAO DE CAMPO BELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1549, 1844, 'FACULDADES INTEGRADAS STELLA MARIS DE ANDRADINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1550, 1845, 'FEFISA - FACULDADES INTEGRADAS DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1551, 1846, 'CENTRO UNIVERSITRIO DE LINS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1552, 1847, 'FACULDADE ATENAS MARANHENSE DE IMPERATRIZ', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1553, 1848, 'FACULDADE CENECISTA DE SANTA TEREZINHA DE ITAIPU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1554, 1849, 'FACULDADE DE DIREITO DE MOGI MIRIM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1555, 1850, 'FACULDADE ALVORADA DE TECNOLOGIA E EDUCAO DE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1556, 1851, 'ESCOLA BRASILEIRA DE ADMINISTRAO PBLICA E DE EMPRESAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1557, 1852, 'FACULDADE SABERES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1558, 1853, 'FACULDADE DE TECNOLOGIA IBTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1559, 1854, 'FACULDADES INTEGRADAS CLARETIANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1560, 1855, 'CENTRO UNIVERSITRIO CATLICO DO SUDOESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1561, 1856, 'FACULDADE DO NORTE NOVO DE APUCARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1562, 1857, 'FACULDADE DEHONIANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1563, 1858, 'FACULDADE DE ADMINISTRAO DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1564, 1859, 'INSTITUTO SUPERIOR DE EDUCAO UIRAPURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1565, 1860, 'FACULDADE DE CINCIAS GERENCIAIS PADRE ARNALDO JANSSEN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1566, 1861, 'FACULDADE DE DIREITO DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1567, 1862, 'FACULDADE DA REGIO SERRANA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1568, 1863, 'FACULDADE DE MANTENA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1569, 1864, 'FACULDADE DE ADMINISTRAO DA ASSOCIAO BRASILIENSE DE EDUCAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1570, 1865, 'INSTITUTO SUPERIOR DE EDUCAO ALVORADA PLUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1571, 1866, 'FACULDADE DE CINCIAS EMPRESARIAIS E ESTUDOS COSTEIROS DE NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1572, 1867, 'FACULDADE DE CINCIAS GERENCIAIS DE SANTOS DUMONT', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1573, 1868, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTOS DUMONT', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1574, 1869, 'CENTRO UNIVERSITRIO DE ITAJUB', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1575, 1870, 'FACULDADES INTEGRADAS REGIONAIS DE AVAR', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1576, 1871, 'FACULDADE DE MEDICINA DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1577, 1872, 'FACULDADES INTEGRADAS SANTA CRUZ DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1578, 1873, 'FACULDADE MERCRIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1579, 1874, 'FACULDADE DE TECNOLOGIA DE OURINHOS', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1580, 1875, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE IBITINGA', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1581, 1876, 'FACULDADE MUNICIPAL PROFESSOR FRANCO MONTORO DE MOGI GUAU', 3, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1582, 1877, 'FACULDADE ATUAL', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1583, 1878, 'CENTRO UNIVERSITRIO DA FUNDAO EDUCACIONAL INACIANA PE SABIA DE MEDEIROS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1584, 1879, 'FACULDADE EDUCACIONAL DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1585, 1880, 'FACULDADE CASA DO ESTUDANTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1586, 1881, 'FACULDADE DA ESCADA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1587, 1882, 'FACULDADE DE ASSUNTOS ACADMICOS E CIENTFICOS MONSENHOR EDISSON VIEIRA LCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1588, 1883, 'FACULDADE DE CINCIAS AGRRIAS E DA SADE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1589, 1884, 'FACULDADE RANCHARIENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1590, 1885, 'UNIDADE DE ENSINO SUPERIOR DOM BOSCO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1591, 1886, 'FACULDADE DE MONTE ALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1592, 1887, 'FACULDADE DE DIREITO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1593, 1888, 'FACULDADE DE SADE TECSOMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1594, 1889, 'FACULDADE HOYLER DE LETRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1595, 1890, 'FACULDADE VILA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1596, 1891, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1597, 1892, 'FACULDADE ENIAC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1598, 1893, 'ESCOLA DE NEGCIOS DO ESTADO DA BAHIA - ENEB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1599, 1894, 'FACULDADE EUROPIA DE ADMINISTRAO E MARKETING', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1600, 1895, 'FACULDADE CHRISTUS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1601, 1896, 'FACULDADE DE TURISMO DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1602, 1897, 'FACULDADE DE LETRAS DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1603, 1898, 'FACULDADE DO LITORAL SUL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1604, 1899, 'FACULDADE DO NOROESTE PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1605, 1900, 'FACULDADE ANCHIETA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1606, 1901, 'FACULDADE CATLICA DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1607, 1902, 'FACULDADE SANTO AGOSTINHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1608, 1903, 'FACULDADE CRISTO REI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1609, 1904, 'FACULDADE SO CAMILO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1610, 1905, 'FACULDADE SANTA ADAME', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1611, 1906, 'INSTITUTO DE ENSINO SUPERIOR MATERDEI', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1612, 1907, 'FACULDADE EDUCACIONAL DE COLOMBO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1613, 1908, 'ESCOLA DE ENSINO SUPERIOR ALTERNATIVO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1614, 1909, 'FACULDADE PEREIRA DE FREITAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1615, 1910, 'FACULDADE BAIANA DE CINCIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1616, 1911, 'FACULDADE CENTRO-OESTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1617, 1912, 'INSTITUTO SUPERIOR DE EDUCAO JAPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1618, 1913, 'FACULDADE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1619, 1914, 'FACULDADE PITGORAS DE ENFERMAGEM DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1620, 1915, 'FACULDADE DE EDUCAO SILVA SERPA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1621, 1916, 'INSTITUTO SUPERIOR DE EDUCAO PITGORAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1622, 1917, 'FACULDADE DE CINCIAS BIOMDICAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1623, 1918, 'FACULDADE CAPIVARI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1624, 1919, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS SANTO AGOSTINHO - FACET', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1625, 1920, 'FACULDADE DE FARMCIA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1626, 1921, 'FACULDADE DE SO BENTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1627, 1922, 'ESCOLA SUPERIOR DE FISIOTERAPIA - ESUFI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1628, 1923, 'FACULDADE DE DIREITO PADRE ARNALDO JANSSEN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1629, 1924, 'FACULDADE DO NORTE PIONEIRO DE JACAREZINHO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1630, 1925, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1631, 1926, 'FACULDADE DE ADMINISTRAO DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1632, 1927, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE DE UNIO DA VITRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1633, 1928, 'FACULDADE CENECISTA ILHA DO GOVERNADOR', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1634, 1929, 'FACULDADE DE CINCIAS CONTBEIS - FACICONT', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1635, 1930, 'INSTITUTO SUPERIOR DE EDUCAO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1636, 1931, 'INSTITUTO DE ENSINO SUPERIOR FRANCISCANO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1637, 1932, 'FACULDADE PALOTINA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1638, 1933, 'FACULDADE BIRIGUI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1639, 1934, 'FACULDADE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1640, 1935, 'FACULDADE SO PAULO DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1641, 1936, 'FACULDADE DE LUCAS DO RIO VERDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1642, 1937, 'FACULDADE EVANGLICA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1643, 1938, 'FACULDADE GLOBAL DE UMUARAMA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1644, 1939, 'INSTITUTO DE ENSINO SUPERIOR DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1645, 1940, 'FACULDADE DE NOVA SERRANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1646, 1941, 'FACULDADE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1647, 1942, 'FACULDADE DE COMUNICAO SOCIAL DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1648, 1943, 'FACULDADE SERRANA DE ENSINO SUPERIOR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1649, 1944, 'FACULDADE DE TECNOLOGIA IBRATEC', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1650, 1945, 'FACULDADE DE SORRISO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1651, 1946, 'FACULDADE MATER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1652, 1947, 'FACULDADE DE ENGENHARIA DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1653, 1948, 'FACULDADE DE ENSINO SUPERIOR DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1654, 1949, 'FACULDADE DE PAULNIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1655, 1950, 'FACULDADE DE ORLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1656, 1951, 'INSTITUTO DE EDUCAO E ENSINO SUPERIOR DE SAMAMBAIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1657, 1952, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS APLICADAS DO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1658, 1953, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1659, 1954, 'FACULDADE DE ECONOMIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1660, 1955, 'FACULDADE DE CINCIAS HUMANAS DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1661, 1956, 'INSTITUTO BATISTA DE ENSINO SUPERIOR DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1662, 1957, 'FACULDADE DE TECNOLOGIA SENAI JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1663, 1958, 'FACULDADE DE TECNOLOGIA SENAI BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1664, 1959, 'FACULDADE DE CINCIAS JURDICAS DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1665, 1960, 'FACULDADE DE MEDICINA DO PLANALTO CENTRAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1666, 1961, 'INSTITUTO TECNOLGICO E DAS CINCIAS SOCIAIS APLICADAS E DA SADE DO CENTRO EDUC. N. SR AUXILIADORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1667, 1962, 'INSTITUTO SUPERIOR DE EDUCAO DO CENTRO EDUCACIONAL NOSSA SENHORA AUXILIADORA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1668, 1963, 'FACULDADE DE FISIOTERAPIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1669, 1964, 'FACULDADE DE TECNOLOGIA EM HOTELARIA, GASTRONOMIA E TURISMO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1670, 1965, 'FACULDADE DE TECNOLOGIA DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1671, 1966, 'FACULDADE ALBERT EINSTEIN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1672, 1967, 'FACULDADE DO VALE DO ITAPECUR', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1673, 1968, 'FACULDADE ATLNTICO', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1674, 1969, 'FACULDADE DOS IMIGRANTES - FAI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1675, 1970, 'FACULDADE DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1676, 1971, 'FACULDADE DE TECNOLOGIA MORUMBI SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1677, 1972, 'FACULDADE TIJUCUSSU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1678, 1973, 'INSTITUTO SUPERIOR DE EDUCAO ORGENES LESSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1679, 1974, 'INSTITUTO SUPERIOR DE EDUCAO DE CAXIAS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1680, 1975, 'FACULDADE DE CINCIAS AGRRIAS DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1681, 1976, 'INSTITUTO SUPERIOR DE EDUCAO DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1682, 1977, 'CENTRO DE ESTUDOS SUPERIORES APRENDIZ', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1683, 1978, 'FACULDADE METROPOLITANA DA GRANDE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1684, 1979, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1685, 1980, 'FACULDADE SINERGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1686, 1981, 'FACULDADE MILLENNIUM', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1687, 1982, 'FACULDADE DE COMUNICAO SOCIAL DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1688, 1983, 'FACULDADE DE CINCIAS E DA SADE DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1689, 1984, 'FACULDADE DE CINCIAS GERENCIAIS DE MANHUAU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1690, 1985, 'FACULDADE COMUNITRIA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1691, 1986, 'FACULDADE ESTCIO DE S DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1692, 1987, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS DEPUTADO JOS LAVIOLA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1693, 1988, 'FACULDADE AVANTIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1694, 1989, 'INSTITUTO SUPERIOR DE EDUCAO AVANTIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1695, 1990, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1696, 1991, 'FACULDADE JOO PAULO PRIMEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1697, 1992, 'INSTITUTO DE ENSINO SUPERIOR DE PIEDADE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1698, 1993, 'FACULDADE DE CINCIAS HUMANAS E DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1699, 1994, 'INSTITUTO DE ENSINO SUPERIOR DE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1700, 1995, 'FACULDADE DE MEDICINA NOVA ESPERANA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1701, 1996, 'INSTITUTO CUIAB DE ENSINO E CULTURA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1702, 1997, 'INSTITUTO DE ENSINO SUPERIOR DE ARIPUAN', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1703, 1998, 'INSTITUTO SUPERIOR DE EDUCAO ELVIRA DAYRELL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1704, 1999, 'JOHN KNOX', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1705, 2000, 'FACULDADE TATUAP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1706, 2001, 'SEMINRIO ADVENTISTA LATINO-AMERICANO DE TEOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1707, 2002, 'INSTITUTO SUPERIOR DE EDUCAO DIVINO SALVADOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1708, 2003, 'FACULADE TEOLGICA SINAL', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1709, 2004, 'FACULDADE DE DIREITO PRESIDENTE CASTELO BRANCO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1710, 2005, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1711, 2006, 'INSTITUTO SUPERIOR DE EDUCAO DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1712, 2007, 'FACULDADE DE CINCIAS EXATAS E TECNOLGICAS DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1713, 2008, 'INSTITUTO SUPERIOR DE EDUCAO DE SO GOTARDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1714, 2009, 'FACULDADE DE TAQUARITINGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1715, 2010, 'FACULDADE DE CINCIAS E LETRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1716, 2011, 'INSTITUTO NACIONAL DE EDUCAO DE PORTO SEGURO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1717, 2012, 'INSTITUTO SUPERIOR DE EDUCAO DE PESQUEIRA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1718, 2013, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1719, 2014, 'FACULDADE SETELAGOANA DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1720, 2015, 'INSTITUTO SANTO TOMS DE AQUINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1721, 2016, 'LOGOS FACULDADE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1722, 2017, 'FACULDADES DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1723, 2018, 'FACULDADE EVOLUO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1724, 2019, 'INSTITUTO SUPERIOR DE EDUCAO DE SALGUEIRO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1725, 2020, 'INSTITUTO DE EDUCAO SUPERIOR EUROBRAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1726, 2021, 'FACULDADES EUROBRAS - ESTUDOS UNIVERSITRIOS REGIONAIS BRASILEIROS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1727, 2022, 'FACULDADE DE ROLIM DE MOURA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1728, 2023, 'FACULDADE DE GUANAMBI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1729, 2024, 'INSTITUTO SUPERIOR DE EDUCAO DAS CLARETIANAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1730, 2025, 'INSTITUTO SUPERIOR DE EDUCAO CARLI GIOVANNI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1731, 2026, 'INSTITUTO SUPERIOR DE EDUCAO BRASIL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1732, 2027, 'FACULDADE DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1733, 2028, 'FALCUDADE DE CINCIAS ECONMICAS, CONTBEIS E ADMINISTRATIVAS DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1734, 2029, 'INSTITUTO SUPERIOR DE EDUCAO DE MARECHAL CNDIDO RONDON', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1735, 2030, 'INSTITUTO SUPERIOR DE EDUCAO CAMPO LIMPO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1736, 2031, 'FACULDADE DE EDUCAO DE PRESIDENTE MDICI', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1737, 2032, 'FACULDADE DE PEDAGOGIA E FORMAO DE NORMALISTAS DE ARAGUANA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1738, 2033, 'INSTITUTO SUPERIOR DE EDUCAO DE FLORESTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1739, 2034, 'FACULDADE DE CINCIAS CONTBEIS DE ARAGUANA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1740, 2035, 'FACULDADE JAGUARIAVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1741, 2036, 'FACULDADE DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1742, 2037, 'FACULDADE UNIME DE CINCIAS EXATAS E TECNOLGICAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1743, 2038, 'INSTITUTO DE EDUCAO SUPERIOR VALE DO MEARIM', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1744, 2039, 'FACULDADE CIDADE LUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1745, 2040, 'FACULDADE DO FUTURO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1746, 2041, 'FACULDADE SUDAMRICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1747, 2042, 'FACULDADE FIGUEIREDO COSTA - FIC', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1748, 2043, 'FACULDADE VALE DO SALGADO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1749, 2044, 'INSTITUTO SUPERIOR DE EDUCAO VALE DO SALGADO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1750, 2045, 'FACULDADE AMADEUS', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1751, 2046, 'INSTITUTO SUPERIOR DE EDUCAO AMADEUS', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1752, 2047, 'FACULDADE DE PSICOLOGIA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1753, 2048, 'FACULDADE DE CINCIAS E TECNOLOGIA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1754, 2049, 'INSTITUTO DE ESTUDOS SUPERIORES DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1755, 2050, 'ESCOLA SUPERIOR DE GESTO E CINCIAS DA SADE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1756, 2051, 'FACULDADE INTERFUTURA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1757, 2052, 'FACULDADE DE DIREITO DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1758, 2053, 'FACULDADE PARA O DESENVOLVIMENTO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1759, 2054, 'FACULDADE DE EDUCAO DE NOVA ANDRADINA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1760, 2055, 'FACULDADE ARAUCRIA DO SUDOESTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1761, 2056, 'FACULDADE DA ALTA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1762, 2057, 'FACULDADE DE MOGI GUAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1763, 2058, 'FACULDADE METROPOLITANA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1764, 2059, 'FACULDADE DE EDUCAO E CINCIAS DE TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1765, 2060, 'FACULDADE PADRE SEVERIANO LTDA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1766, 2061, 'FACULDADE DE FORMAO DE PROFESSORES DE ARAPIRACA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1767, 2062, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE VARGINHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1768, 2063, 'INSTITUTO NOSSA SENHORA APARECIDA DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1769, 2064, 'FACULDADE METROPOLITANA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1770, 2065, 'FACULDADE DE FILOSOFIA E TEOLOGIA DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1771, 2066, 'FACULDADE LEONARDO DA VINCI', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1772, 2067, 'FACULDADE DE CINCIAS EMPRESARIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1773, 2068, 'FACULDADE DE CASTILHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1774, 2069, 'FACULDADE DE TEOLOGIA E CINCIAS HUMANAS', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1775, 2070, 'FACULDADE DE CINCIAS SOCIAIS AMORIL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1776, 2071, 'FACULDADE TEOLGICA BATISTA DO BRASIL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1777, 2072, 'FACULDADE DE DESENVOLVIMENTO SUSTENTVEL DE CRUZEIRO DO SUL', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1778, 2073, 'INSTITUTO SUPERIOR DE EDUCAO PADRO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1779, 2074, 'INSTITUTO EDUCACIONAL SO JOO DA ESCIA DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1780, 2075, 'INSTITUTO DE ENSINO SUPERIOR DE ALAGOAS', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1781, 2076, 'FACULDADE REGIONAL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1782, 2077, 'FACULDADE ANGLO-AMERICANO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1783, 2078, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1784, 2079, 'FACULDADE DE ITAITUBA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1785, 2080, 'FACULDADE UNIVRSICA DE FILOSOFIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1786, 2081, 'FACULDADE DE CINCIAS GERENCIAS DE PEDREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1787, 2082, 'FACULDADE DE CINCIAS MDICAS DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1788, 2083, 'FACULDADE DE IBITINGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1789, 2084, 'FACULDADE CENECISTA DE NOVA PETRPOLIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1790, 2085, 'INSTITUTO BAIANO DE ENSINO SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1791, 2086, 'INSTITUTO DE ENSINO SUPERIOR DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1792, 2087, 'FACULDADE MARECHAL RONDON', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1793, 2088, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1794, 2089, 'FACULDADE CENECISTA DE MOSSOR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1795, 2090, 'FACULDADE DE TURISMO DE CONGONHAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1796, 2091, 'INSTITUTO SUPERIOR DE EDUCAO PR-SABER', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1797, 2092, 'FACULDADE DOM PEDRO II', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1798, 2093, 'FACULDADE GREGOR MENDEL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1799, 2094, 'FACULDADE DE ENSINO A', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1800, 2095, 'INSITUTO SUPERIOR DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1801, 2096, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS DE MANHUAU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1802, 2097, 'ESCOLA SUPERIOR DE GUARARAPES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1803, 2098, 'FACULDADE KURIOS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1804, 2099, 'INSTITUTO DE ENSINO, PESQUISA E EXTENSO DO BRASIL OESTE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1805, 2100, 'FACULDADE DE LETRAS DO SERRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1806, 2101, 'FACULDADE ASCENSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1807, 2102, 'FACULDADE DE AURIFLAMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1808, 2103, 'FACULDADE E CENTRO DE ENSINO DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1809, 2104, 'FACULDADE DE TEOLOGIA DE HOKEMH', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1810, 2105, 'FACULDADE ADVENTISTA DE INFORMTICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1811, 2106, 'FACULDADE DE VIOSA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1812, 2107, 'FACULDADE IBTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1813, 2108, 'FACULDADE DE DIREITO DA SEDES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1814, 2109, 'FACULDADE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1815, 2110, 'FACULDADE DOM CSAR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1816, 2111, 'INSTITUTO SUPERIOR DE TEOLOGIA APLICADA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1817, 2112, 'FACULDADE METODISTA DE BIRIGI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1818, 2113, 'FACULDADE DOM BOSCO DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1819, 2114, 'FACULDADE DE TEOLOGIA FILADLFIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1820, 2115, 'FACULDADE JOO PAULO II', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1821, 2116, 'FACULDADE IGUAPENSE SANTO AUGUSTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1822, 2117, 'FACULDADE DE CINCIA E TECNOLOGIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1823, 2118, 'INSTITUTO DE EDUCAO SUPERIOR GUAIANS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1824, 2119, 'FACULDADE GUARARAPES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1825, 2120, 'INSTITUTO DE FILOSOFIA E DE TEOLOGIA PAULO VI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1826, 2121, 'FACULDADE DE INFORMTICA DE PEDREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1827, 2122, 'FACULDADE DE SERGIPE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1828, 2123, 'FACULDADE MAX PLANCK', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1829, 2124, 'INSTITUTO SUPERIOR DE EDUCAO DE PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1830, 2125, 'FACULDADE DE EDUCAO DE UBERLNDIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1831, 2126, 'ESCOLA DE DIREITO DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1832, 2127, 'FACULDADE BATISTA DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1833, 2128, 'ESCOLA DE DIREITO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1834, 2129, 'ESCOLA DE ECONOMIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1835, 2130, 'FACULDADE EVANGLICA DE TEOLOGIA DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1836, 2131, 'FACULDADE FAPAN', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1837, 2132, 'FACULDADE BARO DO RIO BRANCO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1838, 2133, 'FACULDADE DE CINCIAS, EDUCAO E TEOLOGIA DO NORTE DO BRASIL', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1839, 2134, 'FACULDADE DA IGREJA MINISTRIO FAMA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1840, 2135, 'INSTITUTO FILOSFICO TEOLGICO NOSSA SENHORA IMACULADA RAINHA DO SERTO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1841, 2136, 'INSTITUTO DE JUNA DE ENSINO SUPERIOR', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1842, 2137, 'FACULDADE SO MARCOS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1843, 2138, 'INSTITUTO SUPERIOR DE EDUCAO DIVINO SALVADOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1844, 2139, 'FACULDADE DE INFORMTICA DE PARANABA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1845, 2140, 'INSTITUTO SUPERIOR DE EDUCAO NOSSA SENHORA DE LOURDES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1846, 2141, 'FACULDADE TEOLGICA BATISTA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1847, 2142, 'FACULDADE MULTIEDUCATIVA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1848, 2143, 'INSTITUTO SUPERIOR DE EDUCAO DE DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1849, 2144, 'FACULDADE ECOPORANGA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1850, 2145, 'FACULDADE INFRIUM DE TECNOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1851, 2146, 'FACULDADE DO ACRE', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1852, 2147, 'FACULDADE METROPOLITANA DE MANAUS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1853, 2148, 'INSTITUTO PALMAS DE ENSINO SUPERIOR', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1854, 2149, 'INSTITUTO MATO GROSSO DO SUL DE EDUCAO E CULTURA', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1855, 2150, 'INSTITUTO TERESINA DE ENSINO E CULTURA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1856, 2151, 'INSTITUTO SUPERIOR DE EDUCAO BERLAAR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1857, 2152, 'FACULDADE DE ADMINISTRAO E TECNOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1858, 2153, 'FACULDADE DE DIREITO DE MACA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1859, 2154, 'INSTITUTO SUPERIOR DE CINCIAS HUMANAS E SOCIAIS ANSIO TEIXEIRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1860, 2155, 'FACULDADE DE CINCIAS SOCIAIS E DA SADE DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1861, 2156, 'FACULDADE SO TOMS DE AQUINO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1862, 2157, 'INSTITUTO SUPERIOR DE EDUCAO SANTANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1863, 2158, 'FACULDADE SANTA MARIA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1864, 2160, 'FACULDADE SANT''ANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1865, 2161, 'FACULDADE TEOLGICA DE VALENA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1866, 2162, 'INSTITUTO METROPOLITANO DE ENSINO SUPERIOR DE VESPASIANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1867, 2163, 'INSTITUTO SUPERIOR DE EDUCAO EUGNIO GOMES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1868, 2164, 'FACULDADE PANAMERICANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1869, 2165, 'INSTITUTO FOZ DO IGUAU DE ENSINO E CULTURA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1870, 2166, 'INSTITUTO DE EDUCAO E CULTURA INTEGRADA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1871, 2167, 'FACULDADE DE EDUCAO E CINCIAS GERENCIAIS DE SALTO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1872, 2168, 'INSTITUTO CAMPO GRANDE DE ENSINO SUPERIOR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1873, 2169, 'FACULDADE CENECISTA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1874, 2170, 'FACULDADE DE MATEMTICA JESUS MARIA JOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1875, 2171, 'INSTITUTO BELO HORIZONTE DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1876, 2172, 'FACULDADE CENECISTA DE TRS RIOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1877, 2173, 'FACULDADE GUAIANS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1878, 2174, 'INSTITUTO SANTA CATARINA DE EDUCAO E CULTURA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1879, 2175, 'FACULDADE METROPOLITANA DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1880, 2176, 'FACULDADE DE CINCIAS BIOMDICAS DE COLATINA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1881, 2177, 'INSTITUTO PAULISTA DE ENSINO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1882, 2178, 'FACULDADE CENECISTA DE MACA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1883, 2179, 'FACULDADE DE TURISMO DO ESTADO DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1884, 2180, 'RATIO - FACULDADE TEOLGICA E FILOSFICA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1885, 2181, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE CAPIVARI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1886, 2182, 'FACULDADE BATISTA IDA NELSON', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1887, 2183, 'CENTRO UNIVERSITRIO FUNDAO SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1888, 2184, 'FACULDADE CENECISTA NOSSA SENHORA DOS ANJOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1889, 2185, 'FACULDADE DE NUTRIO DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1890, 2186, 'FACULDADE SALESIANA DOM BOSCO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1891, 2187, 'FACULDADE DE CINCIAS GERENCIAIS DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1892, 2188, 'INSTITUTO SUPERIOR DE EDUCAO NOSSA SENHORA DE SION', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1893, 2189, 'FACULDADE DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1894, 2190, 'FACULDADE JLIO CAMPOS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1895, 2191, 'FACULDADE ATLNTICO SUL DE PELOTAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1896, 2192, 'INSTITUTO SUPERIOR DE EDUCAO IVOTI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1897, 2193, 'INSTITUTO SUPERIOR DE EDUCAO IDEAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1898, 2194, 'FACULDADE ATLNTICO SUL DO RIO GRANDE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1899, 2195, 'FACULDADE DE CINCIAS GERENCIAIS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1900, 2196, 'FACULDADE DE INFORMTICA E TECNOLOGIAS VARZEA-GRANDENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1901, 2197, 'INSTITUTO SUPERIOR DE EDUCAO SANTA MARINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1902, 2198, 'FACULDADE MONTEIRO LOBATO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1903, 2199, 'FACULDADE DE EDUCAO E TEOLOGIA DO BRASIL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1904, 2200, 'FACULDADE VALE DO GORUTUBA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1905, 2201, 'FACULDADE ALPHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1906, 2202, 'INSTITUTO SUPERIOR DE EDUCAO DE GUARATUBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1907, 2203, 'FACULDADE DE EDUCAO ANCHIETA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1908, 2204, 'FACULDADE CATARINENSE DOM BOSCO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1909, 2205, 'FACULDADE DE TUPI PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1910, 2206, 'FACULDADE PILARES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1911, 2207, 'FACULDADE SO JUDAS TADEU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1912, 2208, 'FACULDADE LUS DE CAMES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1913, 2209, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1914, 2210, 'FACULDADE GARAVELO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1915, 2211, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE FARROUPILHA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1916, 2212, 'FACULDADE UNIDADE DAS AMRICAS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1917, 2213, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1918, 2214, 'FACULDADE DE ENGENHARIA DA TERRA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1919, 2215, 'FACULDADE DE TEOLOGIA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1920, 2216, 'INSTITUTO SUPERIOR DE EDUCAO DE INA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1921, 2217, 'FACULDADE DE CINCIAS GERENCIAIS DE INA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1922, 2218, 'FACULDADE DE CINCIAS EXATAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1923, 2219, 'FACULDADE MUNDO MODERNO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1924, 2220, 'FACULDADE DE CINCIAS JURDICAS DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1925, 2221, 'FACULDADE MADEIRA MAMOR', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1926, 2222, 'FACULDADE SETE DE SETEMBRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1927, 2223, 'FACULDADE DE CINCIAS SOCIAIS E DA SADE DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1928, 2224, 'FACULDADES INTEGRADAS DE IMPERATRIZ', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1929, 2225, 'INSTITUTO SUPERIOR DE FORMAO DE PROFESSORES', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1930, 2226, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1931, 2227, 'FACULDADE DE CINCIAS BIOLGICAS JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1932, 2228, 'FACULDADE DA SADE HUMANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1933, 2229, 'FACULDADE VICTOR HUGO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1934, 2230, 'FACULDADE DE ADMINISTRAO JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1935, 2231, 'FACULDADE DE COMUNICAO SOCIAL JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1936, 2232, 'FACULDADE DE ADMINISTRAO E MARKETING DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1937, 2233, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1938, 2234, 'FACULDADE DE PEDAGOGIA DE BETIM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1939, 2235, 'FACULDADE TEOLGICA DAS ASSEMBLIAS DE DEUS EM SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1940, 2236, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SO BERNARDO DO CAMPO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1941, 2237, 'FACULDADE TEOLGICA BATISTA EQUATORIAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1942, 2238, 'FACULDADE DE PSICOLOGIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1943, 2239, 'FACULDADE DE DIREITO DE VILHA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1944, 2240, 'INSTITUTO CEAR DE ENSINO E CULTURA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1945, 2241, 'INSTITUTO SUDESTE MINEIRO DE EDUCAO E CULTURA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1946, 2242, 'INSTITUTO PERNAMBUCO DE ENSINO E CULTURA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1947, 2243, 'INSTITUTO PARABA DE EDUCAO E CULTURA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1948, 2244, 'INSTITUTO MACEI DE ENSINO E CULTURA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1949, 2245, 'INSTITUTO VITRIA DE ENSINO E CULTURA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1950, 2246, 'FACULDADE UNIO AMERICANA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1951, 2247, 'FACULDADE CHAFIC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1952, 2248, 'INSTITUTO SERGIPE DE ENSINO SUPERIOR', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1953, 2249, 'FACULDADE LOGOS EM ARACAJU', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1954, 2250, 'INSTITUTO SANTO TOMS DE AQUINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1955, 2251, 'FACULDADE DE POMPIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1956, 2252, 'FACULDADE DE CINCIA DA EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1957, 2253, 'FACULDADE DE DIREITO DE PRIMAVERA DO LESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1958, 2254, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1959, 2255, 'INSTITUTO DE ENSINO SUPERIOR DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1960, 2256, 'FACULDADE CATLICA STELLA MARIS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1961, 2257, 'FACULDADE DIADEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1962, 2258, 'FACULDADE DE PRIMEIRO MUNDO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1963, 2259, 'INSTITUTO SUPERIOR EDUCAO LEONARDO DA VINCI', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1964, 2260, 'FACULDADE DE TECNOLOGIA IESVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1965, 2261, 'FACULDADE DE CINCIAS HUMANAS E DA SADE DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1966, 2262, 'INSTITUTO DE EDUCAO NORMAL SUPERIOR DE PIMENTA BUENO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1967, 2263, 'FACULDADE SANTO ANTNIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1968, 2264, 'FACULDADE DE COMUNICAO SOCIAL DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1969, 2265, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS DE IBIRAMA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1970, 2266, 'FACULDADE CAMBURY DE FORMOSA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1971, 2267, 'FACULDADE DE SADE DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1972, 2268, 'FACULDADE DE TEOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1973, 2269, 'INSTITUTO SUPERIOR DE EDUCAO LMINI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1974, 2270, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE EXTREMA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1975, 2271, 'FACULDADE PITGORAS DE IPATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1976, 2272, 'FACULDADE DE PSICOLOGIA DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1977, 2273, 'INSTITUTO SUPERIOR DE EDUCAO DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1978, 2274, 'FACULDADE CIDADANIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1979, 2275, 'FACULDADE DE DIREITO SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1980, 2276, 'FACULDADE DE DIREITO DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1981, 2277, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE UNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1982, 2278, 'FACULDADE IGARATA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1983, 2279, 'FACULDADE INTEGRADA METROPOLITANA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1984, 2280, 'FACULDADE SUPERIOR DE RIBAS DO RIO PARDO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1985, 2281, 'FACULDADE DE FILOSOFIA SO BOAVENTURA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1986, 2282, 'FACULDADE DE CAFELNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1987, 2283, 'FACULDADE SO JOS DA COSTA VERDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1988, 2284, 'FACULDADE DE FILOSOFIA, CNCIAS E LETRAS DE FAXINAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1989, 2285, 'FACULDADE DE PEDAGOGIA DE DORES DO INDAI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1990, 2286, 'FACULDADE DE BOM JESUS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1991, 2287, 'ESCOLA SUPERIOR DE TEOLOGIA E ESPIRITUALIDADE FRANCISCANA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1992, 2288, 'FACULDADE ALMEIDA RODRIGUES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1993, 2289, 'FACULDADES INTEGRADAS DE ANGELES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1994, 2290, 'FACULDADE DE EDUCAO, CINCIAS E HUMANIDADES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1995, 2291, 'INSTITUTO SUPERIOR DE EDUCAO DE BEBEDOURO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1996, 2292, 'INSTITUTO DE EDUCAO NORMAL SUPERIOR', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1997, 2293, 'FACULDADE DE CINCIAS HUMANAS, BIOLGICAS E DA SADE', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1998, 2294, 'FACULDADE DE CINCIAS APLICADAS DA REGIO CENTRO SUL DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (1999, 2295, 'INSTITUTO MEDICENSE DE EDUCAO SUPERIOR', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2000, 2296, 'FACULDADE DE LETRAS DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2001, 2297, 'FACULDADE DE DIREITO DE SANTA MARIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2002, 2298, 'ESCOLA SUPERIOR DE DIREITO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2003, 2299, 'FACULDADE ESPECIAL DE EDUCAO E CULTURA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2004, 2300, 'INSTITUTO DE EDUCAO SUPERIOR DE ROLIM DE MOURA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2005, 2301, 'FACULDADE FIDELIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2006, 2302, 'FACULDADE PORTO SEGURO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2007, 2303, 'FACULDADE CIMO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2008, 2304, 'INSTITUTO DE ENSINO SUPERIOR DA FUNLEC DE BONITO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2009, 2305, 'FACULDADE DE DIREITO DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2010, 2306, 'FACULDADE RIO BRANCO DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2011, 2307, 'INSTITUTO SUPERIOR DE EDUCAO DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2012, 2308, 'FACULDADE GEREMRIO DANTAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2013, 2309, 'FACULDADE NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2014, 2310, 'FACULDADE DA REGIO DOS VALES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2015, 2311, 'FACULDADE DE CINCIAS JURDICAS PROFESSOR ALBERTO DEODATO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2016, 2312, 'FACULDADE LUTERANA RUI BARBOSA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2017, 2313, 'FACULDADE DE TEOLOGIA DE BOA VISTA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2018, 2314, 'INSTITUTO DE ENSINO SUPERIOR TECNOLGICO DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2019, 2315, 'FACULDADE CEARENSE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2020, 2316, 'INSTITUTO NACIONAL DE DESENVOLVIMENTO DO ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2021, 2317, 'FACULDADE DO DESCOBRIMENTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2022, 2318, 'FACULDADE DOM BOSCO DE NOVA AURORA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2023, 2319, 'ESCOLA SUPERIOR DE EDUCAO CORPORATIVA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2024, 2320, 'INSTITUTO SUPERIOR DE EDUCAO ATENEU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2025, 2321, 'FACULDADE INESP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2026, 2322, 'FACULDADE ATENEU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2027, 2323, 'FACULDADE DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2028, 2324, 'FACULDADE ANITA GARIBALDI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2029, 2325, 'INSTITUTO SUPERIOR DE EDUCAO DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2030, 2326, 'FACULDADE NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2031, 2327, 'FACULDADE SERRANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2032, 2328, 'FACULDADE ITEANA DE BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2033, 2329, 'FACULDADE BATISTA DO NORDESTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2034, 2330, 'FACULDADE PARA O DESENVOLVIMENTO DO ESTADO E DO PANTANAL MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2035, 2331, 'ESCOLA SUPERIOR DE TEOLOGIA E FILOSOFIA DO BRASIL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2036, 2332, 'FACULDADE CORPORATIVA CESPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2037, 2333, 'FACULDADE DE TEOLOGIA MOKITI OKADA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2038, 2334, 'INSTITUTO SUPERIOR MENDES DE ALMEIDA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2039, 2335, 'FACULDADE JOAQUIM MACHADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2040, 2336, 'FACULDADE MONTES BELOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2041, 2337, 'INSTITUTO SUPERIOR DE EDUCAO DE MONTES BELOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2042, 2338, 'INSTITUTO BRASILEIRO DE ESTUDOS TRIBUTRIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2043, 2339, 'FACULDADE INTERNACIONAL DE HOTELARIA E TURISMO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2044, 2340, 'FACULDE ALPHAVILLE DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2045, 2341, 'FACULDADE DA ALDEIA DE CARAPICUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2046, 2342, 'INSTITUTO SUPERIOR DE EDUCAO CERES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2047, 2343, 'FACULDADE DA AMAZNIA OCIDENTAL - FAAO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2048, 2344, 'FACULDADE ITEANA DE IBITINGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2049, 2345, 'FACULDADE SETE DE SETEMBRO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2050, 2346, 'INSTITUTO SUPERIOR DE FILOSOFIA BERTHIER', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2051, 2347, 'FACULDADE GENNARI & PEARTREE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2052, 2348, 'INSTITUIO DE ENSINO SO FRANCISCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2053, 2349, 'DINMICO FACULDADE DE FLORIANO LTDA.', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2054, 2350, 'ESCOLA SUPERIOR MADRE CELESTE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2055, 2351, 'FACULDADE ESPRITO SANTENSE DE CINCIAS JURDICAS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2056, 2352, 'INSTITUTO DE EDUCAO SUPERIOR PIO XII', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2057, 2353, 'FACULDADE DE ADMINISTRAO DO CENTRO EDUCACIONAL DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2058, 2354, 'INSTITUTO SUPERIOR DE EDUCAO DO BRASIL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2059, 2355, 'FACULDADE ANHANGUERA DE MATO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2060, 2356, 'FACULDADE PAN AMERICANA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2061, 2357, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE DO CESCARELLI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2062, 2358, 'INSTITUTO SUPERIOR DE EDUCAO DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2063, 2359, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2064, 2360, 'INSTITUTO SUPERIOR DE EDUCAO MESTRE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2065, 2361, 'FACULDADE MESTRA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2066, 2362, 'FACULDADE DE CINCIAS MDICAS DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2067, 2363, 'FACULDADE NOVO MILNIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2068, 2364, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE PARASO DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2069, 2365, 'FACULDADE CATLICA DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2070, 2366, 'FACULDADE DE SISTEMAS DE INFORMAO DE PARASO DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2071, 2367, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2072, 2368, 'FACULDADE DE ODONTOLOGIA SO LEOPOLDO MANDIC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2073, 2369, 'INSTITUTO DE ENSINO SUPERIOR SANTO ANTNIO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2074, 2370, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2075, 2371, 'INSTITUTO DE EDUCAO SUPERIOR SO FRANCISCO DE ASSIS DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2076, 2372, 'INSTITUTO DE CINCIAS GERENCIAIS DE BRASLIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2077, 2373, 'FACULDADE TELES PIRES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2078, 2374, 'FACULDADES INTEGRADAS CONTEMPORNEAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2079, 2375, 'FACULDADE VIZCAYA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2080, 2376, 'INSTITUTO SUPERIOR DE EDUCAO DE BRASLIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2081, 2377, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA PRESIDENTE KENNEDY', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2082, 2378, 'FACULDADE DE ADMINISTRAO DE CAMPINA VERDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2083, 2379, 'INSTITUTO SUPERIOR DE EDUCAO DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2084, 2380, 'FACULDADE DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2085, 2381, 'INSTITUTO DE ENSINO E CULTURA DE DOURADOS', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2086, 2382, 'INSTITUTO SUPERIOR DE EDUCAO DE TEOFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2087, 2383, 'FACULDADE MERIDIONAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2088, 2384, 'FACULDADE INTEGRADA DO BRASIL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2089, 2385, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2090, 2386, 'FACULDADE SUL RIOGRANDENSE', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2091, 2387, 'FACULDADES INTEGRADAS POSIVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2092, 2388, 'FACULDADE NOVO MILNIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2093, 2389, 'FACULDADE DE FILOSOFIA E TEOLOGIA PAULO VI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2094, 2390, 'INSTITUTO BRUSQUENSE DE ENSINO SUPERIOR', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2095, 2391, 'INSTITUTO SUPERIOR DE EDUCAO NOVO MILNIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2096, 2392, 'INSTITUTO SUPERIOR DE EDUCAO DE SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2097, 2393, 'FACULDADE MARISTA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2098, 2394, 'FACULDADE DE INFORMTICA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2099, 2395, 'FACULDADE DE CAMPO VERDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2100, 2396, 'INSTITUTO DE EDUCAO SUPEIOR DO SERTO EM PO DE ACAR', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2101, 2397, 'FACULDADE FUCAPE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2102, 2398, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPO VERDE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2103, 2399, 'FACULDADE DE SOROCABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2104, 2400, 'FACULDADE DOM BOSCO DE MARING', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2105, 2401, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPO BELO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2106, 2402, 'FACULDADE CIDADE DO SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2107, 2403, 'FACULDADE SALESIANA DE PINDAMONHANGABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2108, 2404, 'FACULDADES INTEGRADAS DE FILOSOFIA E CINCIAS DO PLANALTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2109, 2405, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTA LUZIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2110, 2406, 'FACULDADE DE GESTO E EMPREENDEDORISMO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2111, 2407, 'FACULDADES INTEGRADAS FACVEST', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2112, 2408, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE SANTOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2113, 2409, 'FACULDADE DO AGRESTE DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2114, 2410, 'FACULDADE CEARENSE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2115, 2411, 'FACULDADE DA CIDADE DO NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2116, 2412, 'FACULDADE ECONOROESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2117, 2413, 'FACULDADE DE ENSINO SUPERIOR DE FLORIANO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2118, 2414, 'INSTITUTO SUPERIOR DE EDUCAO IESDE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2119, 2415, 'FACULDADE BOM JESUS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2120, 2416, 'INSTITUTO SUPERIOR DE EDUCAO DE BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2121, 2417, 'INSTITUTO SUPERIOR DE EDUCAO METROPOLITANO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2122, 2418, 'FACULDADES INTEGRADAS DO RECNCAVO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2123, 2419, 'FACITALGO - FACULDADE DE CIENCIAS E TECNOLOGIA DE AGUAS LINDAS DE GOIAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2124, 2420, 'INSTITUTO DE ENSINO E CULTURA DO PARAN - IECP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2125, 2421, 'INSTITUTO DE ENSINO SUPERIOR', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2126, 2422, 'FACULDADE DE FILOSOFIA LETRAS E ARTES DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2127, 2423, 'FACULDADE DE CINCIA E TECNOLOGIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2128, 2424, 'FACULDADE DE SISTEMA DE INFORMAO DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2129, 2425, 'FACULDADE DE JIPARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2130, 2426, 'FACULDADE INTEGRADA BRASIL AMAZONIA - FIBRA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2131, 2427, 'FACULDADE DE CINCIAS GERENCIAIS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2132, 2428, 'FACULDADE DE CINCIAS DA SADE DE CAMPOS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2133, 2429, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2134, 2430, 'FACULDADE CATLICA ORTODOXA SEDES SAPIENTIAM', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2135, 2431, 'FACULDADE MONTESSORI DE IBINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2136, 2432, 'FACULDADE ALPHAVILLE DE JUNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2137, 2433, 'INSTITUTO SUPERIOR DE EDUCAO PORTO SEGURO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2138, 2434, 'FACULDADE AMRICA LATINA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2139, 2435, 'FACULDADE DE CINCIAS CONTBEIS LUIZ MENDES', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2140, 2436, 'FACULDADE THIRIH', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2141, 2437, 'FACULDADE DE TEIXEIRA DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2142, 2438, 'INSTITUTO TEOLGICO PASTORAL DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2143, 2439, 'FACULDADE OCIDEMNTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2144, 2440, 'FACULDADE CIDADE DE JOO PINHEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2145, 2441, 'INSTITUTO SUPERIOR DE EDUCAO AUXILIUM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2146, 2442, 'FACULDADE DE CINCIAS BIOMDICAS DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2147, 2443, 'INSTITUTO SUPERIOR DE EDUCAO DE JANABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2148, 2444, 'FACULDADE JOO CALVINO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2149, 2445, 'FACULDADE PADRO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2150, 2446, 'INSTITUTO SUPERIOR DE EDUCAO PADRO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2151, 2447, 'INSTITUTO EDUCACIONAL DE CASTRO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2152, 2448, 'INSTITUTO SUPERIOR DE EDUCAO DE JANURIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2153, 2449, 'INSTITUTO MATO GROSSO DE EDUCAO E CULTURA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2154, 2450, 'FACULDADE DE DIREITO PROMOVE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2155, 2451, 'FACULDADE IPIRANGA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2156, 2452, 'INSTITUTO BRASILEIRO DE ENSINO SUPERIOR PROFISSIONALIZANTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2157, 2453, 'FACULDADE BRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2158, 2454, 'FACULDADE MAFRENSE DE TURISMO E CINCIAS HUMANAS DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2159, 2455, 'FACULDADE CASTRO ALVES', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2160, 2456, 'FACULDADE DE ADMINISTRAO DE CHAPADO DO SUL', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2161, 2457, 'FACULDADE ISAAC NEWTON', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2162, 2458, 'CENTRO UNIFICADO DE ENSINO SUPERIOR DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2163, 2459, 'FACULDADE DE ESTUDOS AVANADOS DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2164, 2460, 'FACULDADE CMARA CASCUDO', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2165, 2461, 'FACULDADE CBES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2166, 2462, 'FACULDADE SO LUS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2167, 2463, 'FACULDADE JOANA D''ARC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2168, 2464, 'INSTITUTO SUPERIOR DE EDUCAO ATENEU', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2169, 2465, 'FACULDADE DE DIREITO PROFESSOR DAMSIO DE JESUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2170, 2466, 'FACULDADE ATENEU', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2171, 2467, 'FACULDADE NACIONAL DO NORTE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2172, 2468, 'INSTITUTO TEOLGICO FRANCISCANO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2173, 2469, 'INSTITUTO MACAPAENSE DE ENSINO SUPERIOR', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2174, 2470, 'INSTITUTO SALVADOR DE ENSINO E CULTURA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2175, 2471, 'INTITUTO SUPERIOR DE EDUCAO DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2176, 2472, 'FACULDADE DE EDUCAO, CINCIA E TECNOLOGIA 2001', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2177, 2473, 'INSTITUTO BRASILEIRO DE ADMINISTRAO - BIM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2178, 2474, 'FACULDADE MARIA MILZA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2179, 2475, 'FACULDADE ARQUIDIOCESANA DE MARIANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2180, 2476, 'FACULDADE FNIX DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2181, 2477, 'FACULDADE DE ADMINISTRAO DE MARIANA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2182, 2478, 'FACULDADE DE INTEGRAO DO ENSINO SUPERIOR DO CONE SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2183, 2479, 'FACULDADE LATINO AMERICANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2184, 2480, 'INSTITUTO SUPERIOR DE EDUCAO DE ITPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2185, 2481, 'ESCOLA BRASILEIRA DE FORMAO EMPRESARIAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2186, 2482, 'FACULDADE DE CINCIAS HUMANAS E APLICADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2187, 2483, 'INSTITUTO SUPERIOR DE EDUCAO INTEGRAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2188, 2484, 'FACULDADE PROCESSUS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2189, 2485, 'INSTITUTO DE CINCIAS RELIGIOSAS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2190, 2486, 'FACULDADE LEONARDO DA VINCI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2191, 2487, 'FACULDADE EXMIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2192, 2488, 'FACULDADE ANGLICANA DE ERECHIM', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2193, 2489, 'INSTITUTO SUPERIOR DE EDUCAOBRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2194, 2490, 'INSTITUTO SUPERIOR DE ENSINO DO LITORAL CATARINENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2195, 2491, 'INSTITUTO SUPERIOR DE EDUCAO DO CECAP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2196, 2492, 'INSTITUTO SUPERIOR DE EDUCAO A DISTNCIA DE BRASLIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2197, 2493, 'INSTITUTO SUPERIOR DE EDUCAO  DISTNCIA DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2198, 2494, 'FACULDADE DE PINDAMONHANGABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2199, 2495, 'INSTITUTO DE PESQUISA GRANDE VITRIA - IPGV FACULDADE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2200, 2496, 'INSTITUTO MACHADO DE ASSIS DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2201, 2497, 'FACULDADE ATENEU', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2202, 2498, 'FACULDADE DE MLTIPLAS CINCIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2203, 2499, 'FACULDADE APOIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2204, 2500, 'FACULDADE EINSTEIN', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2205, 2501, 'FACULDADE ESTCIO DE S DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2206, 2502, 'FACULDADE ARINOS DE ADMINISTRAO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2207, 2503, 'FACULDADE DE INTEGRAO NACIONAL LEDA JESUNO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2208, 2504, 'FACULDADE DIVINPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2209, 2505, 'FACULDADE DE ARTE E DESIGN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2210, 2506, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2211, 2507, 'FACULDADE DE TECNOLOGIA E CINCIAS DE SANTO ANTNIO DE JESUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2212, 2508, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2213, 2509, 'FACULDADE DE MEDICINA TRADICIONAL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2214, 2510, 'FACULDADES MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2215, 2511, 'FACULDADE DE DIREITO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2216, 2512, 'INSTITUTO SUPERIOR DE EDUCAO CUIABANO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2217, 2513, 'FACULDADE ARTHUR THOMAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2218, 2514, 'INSTITUTO NATALENSE DE EDUCAO SUPERIOR', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2219, 2515, 'FACULDADE ERUDITA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2220, 2516, 'INSTITUTO SUPERIOR DE EDUCAO SANTA RITA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2221, 2517, 'FACULDADE DE ESTUDOS SOCIAIS E GESTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2222, 2518, 'FACULDADE INTENSIVA DE PEDAGOGIA E FILOSOFIA DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2223, 2519, 'FACULDADE DE INFORMTICA E TECNOLOGIA TERRANOVENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2224, 2520, 'INSTITUTO DE EDUCAO SUPERIOR TERRANOVENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2225, 2521, 'INSTITUTO SUPERIOR DE EDUCAO DO SUL DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2226, 2522, 'INSTITUTO MARISTA SUPERIOR DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2227, 2523, 'FACULDADE BONDESPACHENSE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2228, 2524, 'FACULDADE DE ENGENHARIA DA ITAJUB TECNPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2229, 2525, 'FACULDADE PAULISTA DE CINCIAS APLICADAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2230, 2526, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2231, 2527, 'INSTITUTO SUPERIOR DE EDUCAO DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2232, 2528, 'INSTITUTO SUPERIOR DE EDUCAO ME DE DEUS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2233, 2529, 'INSTITUTO SUPERIOR DE EDUCAO DE IGUAPE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2234, 2530, 'FACULDADE DE CINCIAS DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2235, 2531, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSORA LCIA DANTAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2236, 2532, 'FACULDADE DO SUDESTE GOIANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2237, 2533, 'FACULDADE REGIONAL BARUERI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2238, 2534, 'FACULDADE METROPOLITANA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2239, 2535, 'FACULDADE DOS INCONFIDENTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2240, 2536, 'FACULDADE RORAIMENSE DE ENSINO SUPERIOR', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2241, 2537, 'FACULDADE SO GERALDO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2242, 2538, 'FACULDADE VENDA NOVA DO IMIGRANTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2243, 2539, 'FACULDADE EVANGLICA DO MEIO NORTE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2244, 2540, 'INSTITUTO DE ENSINO SUPERIOR DE CAMAPU', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2245, 2541, 'ESCOLA SUPERIOR DE TECNOLOGIA E EDUCAO DE ARARAQUARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2246, 2542, 'FACULDADE CENECISTA DE QUEIMADOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2247, 2543, 'FACULDADE DA CHAPADA DOS GUIMARES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2248, 2544, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSORA VILMA MONTEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2249, 2545, 'FACULDADE CENECISTA DE PARACAMBI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2250, 2546, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DE VIANNA JNIOR DE MURIAR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2251, 2547, 'FACULDADE MAGNUM DE FORMAO DE PROFESSORES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2252, 2548, 'FACULDADE DE TEOLOGIA, FILOSOFIA E CINCIAS HUMANAS GAMALIEL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2253, 2549, 'FACULDADE PAULISTA DE EDUCAO E COMUNICAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2254, 2550, 'FACULDADE SEPAM', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2255, 2551, 'FACULDADE CENECISTA ITAGUA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2256, 2552, 'INSTITUTO SUPERIOR DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2257, 2553, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA LUIS EDUARDO MAGALHES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2258, 2554, 'FACULDADE DE EDUCAO SANTA TEREZINHA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2259, 2555, 'FACULDADE DE EDUCAO DE UBERABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2260, 2556, 'FIAM-FAAM - CENTRO UNIVERSITRIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2261, 2557, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE PENEDO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2262, 2558, 'FACULDADE DE DIREITO DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2263, 2559, 'INSTITUTO SUPERIOR DE EDUCAO DAS FACULDADES DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2264, 2560, 'FACULDADE DE ENSINO SUPERIOR DA CIDADE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2265, 2561, 'FACULDADE DE CINCIAS ADMINISTRATIVAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2266, 2562, 'FACULDADE JOS LACERDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2267, 2563, 'INSTITUTO SUPERIOR DE EDUCAO PADRE JOO BAGOZZI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2268, 2564, 'UNIVERSIDADE FEDERAL DE CAMPINA GRANDE', 1, 1, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2269, 2565, 'ABEU - CENTRO UNIVERSITRIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2270, 2566, 'INSTITUTO DE ENSINO SUPERIOR DE OLINDA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2271, 2567, 'ESCOLA SUPERIOR DE CINCIAS HUMANAS E ECONMICAS', 2, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2272, 2568, 'FACULDADE ZACARIAS DE GES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2273, 2569, 'FACULDADE DE TECNOLOGIA FAESA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2274, 2570, 'FACULDADE DE CINCIAS EDUCACIONAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2275, 2571, 'FACULDADE REDENTOR', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2276, 2572, 'FACULDADE REGIONAL DE FILOSOFIA, CINCIAS E LETRAS DE CANDEIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2277, 2573, 'FACULDADE TEOLGICA SUL AMERICANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2278, 2574, 'INSTITUTO SUPERIOR DE EDUCAO DAS FACULDADES INTEGRADAS MDULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2279, 2575, 'FACULDADES INTEGRADAS SOARES DE OLIVEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2280, 2576, 'FACULDADES INTEGRADAS PADRE ANCHIETA DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2281, 2577, 'INSTITUTO SUPERIOR DE MSICA DE SO LEOPOLDO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2282, 2578, 'FACULDADE DE TEOLOGIA CARDEAL EUGNIO SALES', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2283, 2579, 'FACULDADE ATENAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2284, 2580, 'INSTITUTO SUPERIOR DE EDUCAO PAULO MARTINS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2285, 2581, 'FACULDADE SO SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2286, 2582, 'FACULDADE DE ENSINO SUPERIOR DO CENTRO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2287, 2583, 'FACULDADE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2288, 2584, 'FACULDADE DO SUDOESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2289, 2585, 'FACULDADE DE FISIOTERAPIA DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2290, 2586, 'INSTITUTO SUPERIOR DE EDUCAO TALO-BRASILEIRO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2291, 2587, 'FACULDADE CNDIDO MENDES DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2292, 2588, 'FALCULDADE MERCATOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2293, 2589, 'FACULDADE DE BROTAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2294, 2590, 'FACULDADE DE CINCIA DA COMPUTAO E INFORMTICA SILVA SERPA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2295, 2591, 'ESCOLA BRASILEIRA DE ECONOMIA E FINANAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2296, 2592, 'FACULDADE PRESBITERIANA 15 DE NOVEMBRO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2297, 2593, 'FACULDADE DE JUAZEIRO DO NORTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2298, 2594, 'FACULDADE TEOLGICA BATISTA ANA WOLLERMAN', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2299, 2595, 'FACULDADES COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2300, 2596, 'INSTITUTO SUPERIOR DE EDUCAO DON DOMNICO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2301, 2597, 'FACULDADE DE CINCIAS DA SADE DA VITRIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2302, 2598, 'FACULDADE PENSAR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2303, 2599, 'FACULDADE DE EDUCAO E CINCIAS HUMANAS NOVA FLRIDA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2304, 2600, 'FACULDADE DE CIENCIAS DA ADMINISTRACAO DA VITORIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2305, 2601, 'FACULDADE DE CINCIAS, FILOSOFIA E LETRAS HAKAY', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2306, 2602, 'INSTITUTO SUPERIOR DE EDUCAO BALO VERMELHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2307, 2603, 'FACULDADE DE ODONTOLOGIA DOS GUARARAPES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2308, 2604, 'FACULDADE TEOLGICA BATISTA DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2309, 2605, 'FACULDADE DE CINCIAS ECONMICAS DE TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2310, 2606, 'FACULDADE AFIRMATIVO DE CAMPO MOURO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2311, 2607, 'FACULDADE PADRE ANTONIO VIEIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2312, 2608, 'INSTITUTO SUPERIOR DE EDUCAO DE LAVRAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2313, 2609, 'INSTITUTO SUPERIOR DE EDUCAO DE TUPI PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2314, 2610, 'FACULDADE DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2315, 2611, 'FACULDADE DE ENSINO SUPERIOR DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2316, 2612, 'INSTITUTO SUPERIOR DE EDUCAO MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2317, 2613, 'FACULDADE RIO BRANCO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2318, 2614, 'FACULDADE EMMANUEL KANT', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2319, 2615, 'FACULDADE INCONFIDNCIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2320, 2616, 'FACULDADE SANTO ANTNIO DE PDUA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2321, 2617, 'FACULDADE SO BENTO DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2322, 2618, 'FACULDADE DOMINGOS SVIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2323, 2619, 'FACULDADE DE DIREITO DE ITABIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2324, 2620, 'FACULDADE AMPRE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2325, 2621, 'INSTITUTO SUPERIOR DE EDUCAO DOMINGOS SVIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2326, 2622, 'INSTITUTO SUPERIOR DE EDUCAO DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2327, 2623, 'FACULDADE DO TAPAJS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2328, 2624, 'FACULDADE DO LITORAL PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2329, 2625, 'FACULDADE DE TECNOLOGIA IBTA - SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2330, 2626, 'FACULDADE DE COMUNICAO SOCIAL SANTA EFIGNIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2331, 2627, 'FACULDADE JOO XXIII', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2332, 2628, 'INSTITUTO DE EDUCAO SUPERIOR ACADEMUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2333, 2629, 'FACULDADE DE CINCIAS CONTBEIS E DE ADMINISTRAO DO VALE DO JURUENA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2334, 2630, 'INSTITUTO SUPERIOR DE EDUCAO DO VALE DO JURUENA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2335, 2631, 'INSTITUTO DE EDUCAO SUPERIOR', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2336, 2632, 'FACULDADES INTEGRADAS DO EXTREMO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2337, 2633, 'INSTITUTO DE EDUCAO E TECNOLOGIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2338, 2634, 'INSTITUTO EDUCACIONAL DALTON CUNHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2339, 2635, 'INSTITUTO SUPERIOR DE EDUCAO JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2340, 2636, 'FACULDADE DINMICA DO VALE DO PIRANGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2341, 2637, 'FACULDADE BOM JESUS DE SIQUEIRA CAMPOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2342, 2638, 'INSTITUTO DE CINCIAS E EDUCAO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2343, 2639, 'FACULDADE DE TECNOLOGIA SENAI CONCRDIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2344, 2640, 'FACULDADE DE CINCIAS DA SADE DA SERRA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2345, 2641, 'FACULDADE TEOLGICA BATISTA FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2346, 2642, 'FACULDADE SO VICENTE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2347, 2643, 'INSTITUTO SUPERIOR DE CINCIAS E TECNOLOGIA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2348, 2644, 'INSTITUTO DE EDUCAO SUPERIOR DO TAPAJS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2349, 2645, 'INSTITUTO DE ENSINO SUPERIOR DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2350, 2646, 'FACULDADE REGIONAL IPIRANGA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2351, 2647, 'FACULDADE SANTA CLARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2352, 2648, 'FACULDADE SUL MINEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2353, 2649, 'FACULDADE DE CINCIAS JURDICAS DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2354, 2650, 'INSTITUTO DE ENSINO SUPERIOR DE ARIQUEMES', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2355, 2651, 'FACULDADE TAMANDAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2356, 2652, 'FACULDADE UNIDA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2357, 2653, 'FACULDADE DE EDUCAO SUPERIOR DO PIEMONTE DA CHAPADA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2358, 2654, 'FACULDADE DE ENSINO TECNOLGICO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2359, 2655, 'FACULDADE DE CINCIAS ADMINISTRATIVAS, SOCIAIS E DA SADE DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2360, 2656, 'FACULDADE SANTA CATARINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2361, 2657, 'FACULDADE ADOLFO CAMINHA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2362, 2658, 'FACULDADE AMEC TRABUCO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2363, 2659, 'FACULDADE DO VALE DO PARNABA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2364, 2660, 'FACULDADE PHNIX DE CINCIAS HUMANAS E SOCIAIS DO BRASIL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2365, 2661, 'INSTITUTO DE ENSINO SUPERIOR DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2366, 2662, 'INSTITUTO SUPERIOR DE ENSINO PAULA CNDIDO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2367, 2663, 'FACULDADE DE ODONTOLOGIA ARGEMIRO FIGUEIREDO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2368, 2664, 'INSTITUTO DE ENSINO SUPERIOR DO VALE DO PARNABA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2369, 2665, 'FACULDADE DE TECNOLOGIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2370, 2666, 'FACULDADE INTEGRADA DE BRUSQUE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2371, 2667, 'INSTITUTO SUPERIOR PAULO FREIRE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2372, 2668, 'FACULDADE TEOLGICA DO SUDOESTE GOIANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2373, 2669, 'FACULDADE CNDIDO MENDES DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2374, 2670, 'INSTITUTO DE EDUCAO SUPERIOR ACREANO EUCLIDES DA CUNHA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2375, 2671, 'FACULDADE DE CINCIAS HUMANAS E PSICOLGICAS EUCLIDES DA CUNHA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2376, 2672, 'FACULDADE HUGO DE SO VITOR', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2377, 2673, 'INSTITUTO SUPERIOR DE EDUCAO VILA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2378, 2674, 'INSTITUTO DE ENSINO SUPERIOR UNILLUZ', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2379, 2675, 'INSTITUTO SUPERIOR DE EDUCAO LATINO AMERICANO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2380, 2676, 'FACULDADE LA SALLE', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2381, 2677, 'INSTITUTO SUPERIOR DE EDUCAO SO JUDAS TADEU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2382, 2678, 'FACULDADE DE COMPUTAO E INFORMTICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2383, 2679, 'FACULDADE DE CINCIA DA COMPUTAO DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2384, 2680, 'FACULDADE DE COMPUTAO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2385, 2681, 'FACULDADE DE ENGENHARIA CIVIL DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2386, 2682, 'FACULDADE DE CINCIAS DA SADE DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2387, 2683, 'FACULDADE DE CINCIAS DA COMPUTAO DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2388, 2684, 'FACULDADE DE CINCIAS GERENCIAIS DE LEOPOLDINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2389, 2685, 'FACULDADE DELTA DE ENSINO SUPERIOR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2390, 2686, 'FACULDADE SANTA IZILDINHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2391, 2687, 'FACULDADE DOM ALBERTO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2392, 2688, 'FACULDADE INESP - INSTITUTO NACIONAL DE ENSINO E PESQUISA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2393, 2689, 'FACULDADE CARLOS LOBO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2394, 2690, 'FACULDADES INTEGRADAS LOGOS - FILOGOS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2395, 2691, 'FACULDADE ASSOCIADA DA BAHIA - FAB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2396, 2692, 'FACULDADE VILA DE CINCIAS HUMANAS E EXATAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2397, 2693, 'FACULDADES INTEGRADAS DO TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2398, 2694, 'FACULDADE VALE DO ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2399, 2695, 'FACULDADE DO CENTRO-OESTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2400, 2696, 'INSUBA - INSTITUTO SUPERIOR DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2401, 2697, 'INSTITUTO SUPERIOR DE EDUCAO DE AMLIA RODRIGUES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2402, 2698, 'INSTITUTO SUPERIOR DE EDUCAO VALE DO ARAGUAIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2403, 2699, 'INSTITUTO DE ENSINO SUPERIOR AVANT GARDE', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2404, 2700, 'FACULDADE UNIPOLI', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2405, 2701, 'FACULDADE DE ORLNDIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2406, 2702, 'FACULDADE DE CINCIAS JURDICAS DE PARASO DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2407, 2703, 'FACULDADE SENAC MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2408, 2704, 'INSTITUTO SUPERIOR DE EDUCAO DO INSTITUTO METODISTA UNIO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2409, 2705, 'FACULDADE DE EDUCAO E CINCIAS HUMANAS NOVA FLRIDA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2410, 2706, 'FACULDADE EUROPEU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2411, 2707, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSOR EDGARDO BEZERRA DA ROCHA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2412, 2708, 'INSTITUTO SUPERIOR DE CINCIAS HUMANAS E FILOSOFIA LA SALLE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2413, 2709, 'INSTITUTO DE ENSINO SUPERIOR NOVO HORIZONTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2414, 2710, 'INSTITUTO SUPERIOR DE EDUCAO RANCHARIENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2415, 2711, 'FACULDADE DE ADMINISTRAO DE EMPRESAS DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2416, 2712, 'FACULDADE DE SISTEMAS DE INFORMAO DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2417, 2713, 'INSTITUTO NORMAL SUPERIOR DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2418, 2714, 'FACULDADE DE ENFERMAGEM E OBSTETRCIA DE CAJAMAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2419, 2715, 'FACULDADE DE CINCIAS HUMANAS DE PONTE NOVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2420, 2716, 'FACULDADE COTEMGE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2421, 2717, 'FACULDADE DE CINCIAS JURDICAS VISCONDE DE CAIRU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2422, 2718, 'INSTITUTO SUPERIOR DE EDUCAO DO NORTE', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2423, 2719, 'FACULDADE DE DIREITO OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2424, 2720, 'FACULDADE AUGUSTO MAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2425, 2721, 'FACULDADE IMPACTA DE TECNOLOGIA DA INFORMAO - FITI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2426, 2722, 'FACULDADE CATLICA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2427, 2723, 'FACULDADE MARISTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2428, 2724, 'INSTITUTO DE ENSINO SUPERIOR DO SUL DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2429, 2725, 'INSTITUTO SUPERIOR DE EDUCAO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2430, 2726, 'ESCOLA SUPERIOR DE ADMINISTRAO DE EMPRESAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2431, 2727, 'FACULDADE DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2432, 2728, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS MAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2433, 2729, 'FACULDADE DE PSICOLOGIA MAX', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2434, 2730, 'UNIPB - FACULDADE UNIDA DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2435, 2731, 'ESCOLA SUPERIOR DE COMPUTAO E TECNOLOGIAS DA INFORMAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2436, 2732, 'FACULDADE UNIDAS DO ENTORNO GOIS/DF - UNIENTORNO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2437, 2733, 'FACULDADE TEOLOGICA ALPHA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2438, 2734, 'FACULDADE DE CINCIAS DA SADE DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2439, 2735, 'FACULDADE DE CINCIAS DA COMPUTAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2440, 2736, 'INSTITUTO TECNOLGICO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2441, 2737, 'FACULDADE DE CINCIAS DA INFORMAO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2442, 2738, 'INSTITUTO SUPERIOR DE EDUCAO DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2443, 2739, 'FACULDADE CASTILHENSE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2444, 2740, 'FACULDADE DO VALE DO JAGUARIBE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2445, 2741, 'FACULDADE CATLICA DOM ORIONE', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2446, 2742, 'FACULDADE DE EDUCAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2447, 2743, 'FACULDADE DE CINCIA DA COMPUTAO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2448, 2744, 'INSTITUTO SUPERIOR DE EDUCAO VERA CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2449, 2745, 'ESCOLA SUPERIOR DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2450, 2746, 'INSTITUTO DE ENSINO SUPERIOR ETAPA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2451, 2747, 'FACULDADE EUROPEU DO CEARA - FEC', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2452, 2748, 'FACULDADE LATO SENSU DO BRASIL', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2453, 2749, 'INSTITUTO DE CINCIAS JURDICAS PITGORAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2454, 2750, 'FACULDADE DE TECNOLOGIA SENAI LUZERNA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2455, 2751, 'INSTITUTO SUPERIOR DE EDUCAO DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2456, 2752, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS PROFESSORA VILMA MONTEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2457, 2753, 'FACULDADE DE CINCIAS AGRRIAS, BIOLGICAS, EXATAS E SOCIAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2458, 2754, 'FACULDADE SO PAULO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2459, 2755, 'FACULDADE DO VALE DO ITAJA MIRIM', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2460, 2756, 'FACULDADE JK VALPARASO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2461, 2757, 'FACULDADE JK ADMINISTRAO DE VALPARASO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2462, 2758, 'INSTITUTO SUPERIOR DE EDUCAO PROFESSOR PAULO ALBINO PIMENTEL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2463, 2759, 'FACULDADE PROFESSOR PAULO ALBINO PIMENTEL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2464, 2760, 'ESCOLA SUPERIOR DE TECNOLOGIA DA INFORMAO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2465, 2761, 'FACULDADE DO SERTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2466, 2762, 'INSTITUTO ISAAC NEWTON', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2467, 2763, 'FACULDADE DE CINCIAS GERENCIAS DE SO GOTARDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2468, 2764, 'INSTITUTO DE ENSINO SUPERIOR DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2469, 2765, 'INSTITUTO DE CINCIAS RELIGIOSAS LUMEN CHRISTI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2470, 2766, 'FACULDADE EMPRESARIAL DE CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2471, 2767, 'INSTITUTO SUPERIOR DE EDUCAO DA AIMORS - M.G.', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2472, 2768, 'INSTITUTO SUPERIOR DE EDUCAO - FACREFI', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2473, 2769, 'FAVE - FACULDADE DE ADMINISTRAO DE VESPASIANO LTDA.', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2474, 2770, 'FACULDADE UNIDA DE CAMPINAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2475, 2771, 'CENTRO DE ENSINO SUPERIOR DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2476, 2772, 'INSTITUTO SUPERIOR DE EDUCAO MANHUMIRIM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2477, 2773, 'FACULDADE DE MACAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2478, 2774, 'FACULDADES INTEGRADAS FAFIBE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2479, 2775, 'FACULDADES INTEGRADAS DESEMBARGADOR SVIO BRANDO - FAUSB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2480, 2776, 'FACULDADES INTEGRADAS NORTE CAPIXABA - FANORTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2481, 2777, 'INSTITUTO DE ENSINO SUPERIOR SANTA MARIA DE ASSIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2482, 2778, 'INSTITUTO SUPERIOR ESPECIAL DE EDUCAO DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2483, 2779, 'FACULDADE DE INFORMTICA DE OURO PRETO DO OESTE', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2484, 2780, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2485, 2781, 'FACULDADE DE CINCIAS DA SADE DA ALTA NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2486, 2782, 'INSTITUTO SUPERIOR DE EDUCAO AFONSO LINARES PRADO', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2487, 2783, 'FACULDADE DE TECNOLOGIA DO NORDESTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2488, 2784, 'FACULDADE FRANCISCANA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2489, 2785, 'ESCOLA SUPERIOR DE EDUCAO CONTINUADA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2490, 2786, 'INSTITUTO DE EDUCAO SUPERIOR E TECNOLOGICA PROF. FRANBRAN', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2491, 2787, 'FACULDADES PEQUENO PRNCIPE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2492, 2788, 'FACULDADE DE CINCIAS AMBIENTAIS DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2493, 2789, 'FACULDADE JOINVILLE DE ENSINO E CULTURA - FAJEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2494, 2790, 'FACULDADE FRANCISCANA DE ENSINO SUPERIOR - FAFRES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2495, 2791, 'FACULDADE DE CINCIAS AGRRIAS E EXATAS DE PRIMAVERA DO LESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2496, 2792, 'FACULDADE DE CINCIAS SOCIAIS E EDUCAO - FACE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2497, 2793, 'FACULDADE UNIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2498, 2794, 'FACULDADE DE CINCIAS SOCIAIS E HUMANAS SOBRAL PINTO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2499, 2795, 'FACULDADE SO FRANCISCO DE ASSIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2500, 2796, 'FACULDADE DE IPOR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2501, 2797, 'FACULDADE DO LITORAL SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2502, 2798, 'FAESP - FACULDADE DE ENSINO SUPERIOR DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2503, 2799, 'FANEESP - FACULDADE NACIONAL DE EDUCAO E ENSINO SUPERIOR DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2504, 2800, 'FACULDADE DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2505, 2801, 'INSTITUTO GUARANT DE EDUCAO SUPERIOR', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2506, 2802, 'FACULDADE DE CINCIAS AGRRIAS DE GUARANT DO NORTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2507, 2803, 'FACULDADE CETESI', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2508, 2804, 'FACULDADE CCAA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2509, 2805, 'FACULDADE MODELO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2510, 2806, 'FACULDADE EVANGLICA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2511, 2807, 'FACULDADE CENTRO CAPE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2512, 2808, 'FACULDADES ITECNE DE CASCAVEL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2513, 2809, 'INSTITUTO DE ENSINO SUPERIOR DE UBERLNDIA - IESU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2514, 2810, 'INSTITUTO SUPERIOR DE EDUCAO ANSIO TEIXEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2515, 2811, 'FACULDADE PAULUS DE TECNOLOGIA E COMUNICAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2516, 2812, 'FACULDADE DO SUDESTE BRASILEIRO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2517, 2813, 'INSTITUTO SUPERIOR DE EDUCAO CAPIMGROSSENSE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2518, 2814, 'FACULDADE SO SEBASTIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2519, 2815, 'FACULDADE VALE DO RIBEIRA - FVR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2520, 2816, 'FACULDADE SANTO AGOSTINHO - FSA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2521, 2817, 'FACULDADE DE IUNA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2522, 2818, 'FACULDADE DE VETERINRIA DE VESPASIANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2523, 2819, 'FACULDADE ANGELO VASCONCELOS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2524, 2820, 'FACULDADE PITGORAS DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2525, 2821, 'FACULDADE IDC', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2526, 2822, 'FACULDADE DE ENGENHARIA FLORESTAL DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2527, 2823, 'FACULDADE DE ENGENHARIA AGRCOLA DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2528, 2824, 'FACULDADE DE ENGENHARIA AGRONMICA DE IBIRAU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2529, 2825, 'FACULDADE DO SISTEMA FINDES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2530, 2826, 'FACULDADE NOSSA SENHORA DE FTIMA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2531, 2827, 'FACULDADE EVANGLICA DO PIAUI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2532, 2828, 'FACULDADE ITABIRANA DE SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2533, 2829, 'INSTITUTO SUPERIOR DE EDUCAO E FILOSOFIA DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2534, 2830, 'FACULDADE ADVENTISTA DE CINCIAS DA SADE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2535, 2831, 'FACULDADE DOM BOSCO DE GOIOER', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2536, 2832, 'INSTITUTO SUPERIOR DE EDUCAO PROGRAMUS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2537, 2833, 'FACULDADE ON LINE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2538, 2834, 'INSTITUTO SUPERIOR DE PSICOLOGIA DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2539, 2835, 'FACULDADE MAURCIO DE NASSAU', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2540, 2836, 'FACULDADE SUL DA AMRICA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2541, 2837, 'INSTITUTO SUPERIOR DE EDUCAO SUL DA AMRICA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2542, 2838, 'FASES - FACULDADE SOTEROPOLITANA DE ENSINO SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2543, 2839, 'INSTITUTO METODISTA SUPERIOR DE EDUCAO DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2544, 2840, 'FACULDADE METODISTA DE TEOLOGIA E CINCIAS HUMANAS DA AMAZNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2545, 2841, 'FACULDADE PARANAPANEMA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2546, 2842, 'FACULDADE DE MEDICINA MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2547, 2843, 'FACULDADE DE CINCIAS MDICAS E DA SADE DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2548, 2844, 'FACULDADE SALESIANA DOM BOSCO DE PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2549, 2845, 'FACULDADE REINALDO RAMOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2550, 2846, 'FACULDADE DE TEOLOGIA UMBANDISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2551, 2847, 'INSTITUTO SUPERIOR DE EDUCAO DO PARANAPANEMA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2552, 2848, 'FACULDADE DE NOVO PROGRESSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2553, 2849, 'ESCOLA SUPERIOR DOM HELDER CMARA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2554, 2850, 'FACULDADE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2555, 2851, 'FACULDADE SANTA PAULINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2556, 2852, 'FACULDADE DE GESTO E NEGCIOS DO ALTO URUGUAI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2557, 2853, 'FACULDADE DE TECNOLOGIA INED - UNIDADE DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2558, 2854, 'FACULDADE CONHECER', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2559, 2855, 'FACULDADE SO FRANCISCO DE ASSIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2560, 2856, 'FACULDADE DE TECNOLOGIA QUASAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2561, 2857, 'INSTITUTO CIENTFICO DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2562, 2858, 'INSTITUTO DE SADE ALEXANDER FLEMING', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2563, 2859, 'FACULDADE DE BELM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2564, 2860, 'FACULDADE CEAQ', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2565, 2861, 'FACULDADE DE ITAPETININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2566, 2862, 'FACULDADE DE DIREITO PRESIDENTE TANCREDO NEVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2567, 2863, 'FACULDADE DE ADMINISTRAO DE PETROLINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2568, 2864, 'FACULDADE DE DIREITO DE PETROLINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2569, 2865, 'FACULDADE DE CINCIAS SOCIAIS DE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2570, 2866, 'FACULDADE DE CINCIAS JURDICAS DE RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2571, 2867, 'FACULDADE DE DIREITO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2572, 2868, 'FACULDADE DE ADMINISTRAO DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2573, 2869, 'FACULDADE DE CINCIAS SOCIAIS ADO DE ALMEIDA E SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2574, 2870, 'FACULDADE SERRA DO CARMO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2575, 2871, 'INSTITUTO SUPERIOR DE EDUCAO SERRA DO CARMO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2576, 2872, 'FACULDADE DE CINCIAS AGRRIAS RENATO AZEREDO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2577, 2873, 'FACULDADE DE SISTEMAS DE INFORMAO DE SO SEBASTIO DO PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2578, 2874, 'FACULDADE DE DIREITO DE SO SEBASTIO DO PARASO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2579, 2875, 'FACULDADE INDGENA DA AMAZNIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2580, 2876, 'FACULDADE UNISSA DE SARANDI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2581, 2877, 'FACULDADE UNISSA DE EDUCAO TECNOLGICA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2582, 2878, 'INSTITUTO SUPERIOR DE EDUCAO DE CAIEIRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2583, 2879, 'FACULDADE METROPOLITANA DE CAIEIRAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2584, 2880, 'INSTITUTO SUPERIOR DE EDUCAO DE TIJUCUSSU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2585, 2881, 'INSTITUTO SUPERIOR DE EDUCAO DO SENAC-SP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2586, 2882, 'FACULDADE SO JOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2587, 2883, 'FACULDADE EDUVALE DE PARANAPANEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2588, 2884, 'INSTITUTO SUPERIOR DE EDUCAO BOM JESUS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2589, 2885, 'FACULDADE SO CAMILO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2590, 2886, 'FACULDADE ZUMBI DOS PALMARES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2591, 2887, 'FACULDADE EDUVALE DE PIRAJU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2592, 2888, 'UNIVERSIDADE DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2593, 2889, 'UNIVERSIDADE PARA O DESENVOLVIMENTO DA AMAZNIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2594, 2890, 'UNIVERSIDADE DE INTEGRAO BRASILEIRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2595, 2891, 'FACULDADE BARO DE PIRATININGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2596, 2892, 'FACULDADE DE PALMARES - FAPAL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2597, 2893, 'INSTITUTO SUPERIOR DE EDUCAO DOS PALMARES', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2598, 2894, 'FACULDADE INTEGRAL DE SANTA HELENA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2599, 2895, 'FACULDADE DE EDUCAO E TECNOLOGIA DA REGIO MISSIONEIRA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2600, 2896, 'FACULDADE SATC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2601, 2897, 'FACULDADE JK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2602, 2899, 'FACULDADES CAIARAS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2603, 2900, 'INSTITUTO TECNOLGICO REGIONAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2604, 2901, 'INSTITUTO SUPERIOR DE EDUCAO DO MDIO NORTE MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2605, 2902, 'FACULDADE DO MDIO NORTE MATO-GROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2606, 2903, 'FACULDADE CONCRDIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2607, 2904, 'ESCOLA SUPERIOR DE ADMINISTRAO, MARKETING E COMUNICAO DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2608, 2905, 'FACULDADE BRASILEIRA DE PEDAGOGIA / UNIBRA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2609, 2906, 'FACULDADE NACIONAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2610, 2907, 'FACULDADE BRASILEIRA DE NANUQUE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2611, 2908, 'INSTITUTO NATALENSE DE ENSINO E CULTURA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2612, 2909, 'INSTITUTO DE ENSINO SUPERIOR DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2613, 2910, 'INSTITUTO SUPERIOR DE EDUCAO VERDE NORTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2614, 2911, 'INSTITUTO DE ENSINO SUPERIOR DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2615, 2912, 'FACULDADE DE CINCIA E TECNOLOGIA ALBERT EINSTEIN', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2616, 2913, 'FACULDADE DO VALE DO PARAGUAU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2617, 2914, 'INSTITUTO ABUCHAIM', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2618, 2915, 'FACULDADE CIDADE DE PATOS DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2619, 2916, 'INSTITUTO DE EDUCAO SUPERIOR DE SERGIPE - ISES', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2620, 2917, 'INSTITUTO DE ENSINO E CULTURA DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2621, 2918, 'FACULDADE DE ENSINO SUPERIOR DA AMAZNIA REUNIDA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2622, 2919, 'FACULDADE SO JOS DE RIBAMAR', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2623, 2920, 'INSTITUTO DE ENSINO SUPERIOR CATTA PRETA E DIAMANTINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2624, 2921, 'INSTITUTO SUPERIOR DE EDUCAO DA AMAZNIA REUNIDA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2625, 2922, 'INSTITUTO SUPERIOR DE EDUCAO DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2626, 2923, 'FACULDADE TABIRENSE DE ENFERMAGEM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2627, 2924, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE BUTI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2628, 2925, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2629, 2926, 'FACULDADE BRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2630, 2927, 'FACULDADE DEL REY', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2631, 2928, 'FACULDADE HOLSTICA DE CINCIAS HUMANAS - FHCH', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2632, 2929, 'FACULDADE DE MILAGRES CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2633, 2930, 'FACULDADE DE SARANDI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2634, 2931, 'FACULDADE RIO GRANDE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2635, 2932, 'FACULDADE PELOTENSE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2636, 2933, 'FACULDADE TIMONENSE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2637, 2934, 'FACULDADE DE ADMINISTRAO E ECONMIA DE JOINVILLE - FAEJ', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2638, 2935, 'FACULDADE DE TALENTOS HUMANOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2639, 2936, 'INSTITUTO DE EDUCAO SUPERIOR MARISTA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2640, 2937, 'FACULDADE METROPOLITANA DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2641, 2938, 'FACULDADE DE EDUCAO DE BARCARENA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2642, 2939, 'INSTITUTO SUPERIOR DE EDUCAO TORRICELLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2643, 2940, 'FACULDADE CENECISTA DE CACHOEIRAS DE MACACU', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2644, 2941, 'INSTITUTO SUPERIOR DE TEOLOGIA E PASTORAL DE BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2645, 2942, 'INSTITUTO SUPERIOR DE EDUCAO FRANCISCANO NOSSA SENHORA DE FTIMA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2646, 2943, 'INSTITUTO SUPERIOR DE EDUCAO PIRMIDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2647, 2944, 'FACULDADE DO SUL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2648, 2945, 'FACULDADE DA ASSOCIAO BRASILIENSE DE EDUCAO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2649, 2946, 'FACULDADE DE ARQUITETURA E URBANISMO DO DISTRITO FEDERAL (FAU-DF)', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2650, 2947, 'FACULDADE DAS AMRICAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2651, 2948, 'REAL FACULDADE DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2652, 2949, 'FACULDADE DO BAIXO PARNABA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2653, 2950, 'ESCOLA SUPERIOR DE ADMINISTRAO, DIREITO E ECONOMIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2654, 2951, 'INSTITUTO SUPERIOR DE EDUCAO DE MORRO AGUDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2655, 2952, 'FACULDADES DO SUL - FASUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2656, 2953, 'INSTITUTO SUPERIOR DE EDUCAO DA CIDADE DO NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2657, 2954, 'FACULDADE SUL CAPIXABA - UNISUL', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2658, 2955, 'FACULDADE DE CIENCIAS HUMANAS, BIOLGICAS E DA SAUDE DO LESTE MATOGROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2659, 2956, 'FACULDADE DE CINCIAS JURIDICAS, SOCIAIS E TECNOLGICA-FACITE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2660, 2957, 'FACULDADE DE CINCIAS EXATAS E AGRRIAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2661, 2958, 'FACULDADE DE CINCIAS BIOLGICAS, HUMANAS E SADE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2662, 2959, 'FACULDADE DE CIENCIAS AGRARIAS E EXATAS DO LESTE MATOGROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2663, 2960, 'FACULDADE SANTOS DUMONT', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2664, 2961, 'FACULDADE DO PANTANAL MATOGROSSENSE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2665, 2962, 'FACULDADE DE CINCIAS SOCIAIS DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2666, 2963, 'FACULDADE DE CINCIAS SOCIAIS DE PETROLINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2667, 2964, 'FACULDADE DE CINCIAS DE BRASLIA - FACIBRA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2668, 2965, 'FACULDADE MOKITI OKADA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2669, 2966, 'INSTITUTO SUPERIOR DE EDUCAO HELIO MAGDALENA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2670, 2967, 'INSTITUTO SUPERIOR DE EDUCAAO PEDRO II', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2671, 2968, 'FACULDADE NOVA ESPERANA DE NUTRIO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2672, 2969, 'INSTITUTO SUPERIOR DE EDUCAO OCIDENTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2673, 2970, 'FACULDADE INTEGRAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2674, 2971, 'FACULDADE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2675, 2972, 'FACULDADE CHAPADINHENSE DE EDUCAO, CINCIAS E TECNOLOGIA - FACHAP', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2676, 2973, 'FACULDADE DE CINCIAS HUMANAS E BIOLGICAS E DA SADE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2677, 2974, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS APLICADAS DE PRIMAVERA DO LESTE', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2678, 2975, 'FACULDADE JK GUAR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2679, 2976, 'INSTITUTO SUPERIOR DE EDUCAO DA FATEB', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2680, 2977, 'FACULDADES INTEGRADAS DE CIENCIAS E BIOTECNOLOGIA - FICEB', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2681, 2978, 'FACUDADE DE ODONTOLOGIA MARIO DE OLIVEIRA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2682, 2979, 'FACULDADE SUL ESPRITO SANTENSE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2683, 2980, 'FACULDADE SENAC-CEAR DE ADMINISTRAO E COMRCIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2684, 2981, 'FACULDADE SO VICENTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2685, 2982, 'FACULDADE VICTOR HUGO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2686, 2983, 'FACULDADE SO VICENTE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2687, 2984, 'FACULDADE ABRAHAN LINCON', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2688, 2985, 'FACULDADE MERIDIONAL DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2689, 2986, 'INSTITUTO DE FILOSOFIA E CIENCIAS HUMANAS DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2690, 2987, 'FACULDADE DE ODONTOLOGIA ALFEU GOMES DE OLIVEIRA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2691, 2988, 'INSTITUTO SUPERIOR DE EDUCAO FNIX DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2692, 2989, 'IBESS - INSTITUTO BRASILEIRO DE EDUCAO SUED E SUSEJ LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2693, 2990, 'FACULDADES DE ADMINISTRAO DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2694, 2991, 'FACULDADE DE SAPEAU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2695, 2992, 'FACULDADE DO SUDESTE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2696, 2993, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2697, 2994, 'INSTITUTO SUPERIOR UNIFELI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2698, 2995, 'INSTITUTO SUPERIOR DE EDUCAO LUTERANO DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2699, 2996, 'FACULDADE SOTEROPOLITANA DE DIREITO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2700, 2997, 'FACULDADE DE COMUNICAO E INFORMAO DO CENTRO OESTE - COMUNICO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2701, 2998, 'FACULDADES SESI AMAZONAS - FASESI', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2702, 2999, 'INSTITUTO SUPERIOR DE EDUCAO CENECISTA DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2703, 3000, 'FACULDADE CENECISTA DE SINOP', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2704, 3001, 'FACULDADE CENECISTA DE RONDONPOLIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2705, 3002, 'FACULDADE DE CINCIAS DA SADE NOSSA SENHORA DAS MERCS DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2706, 3003, 'INSTITUTO SUPERIOR DE EDUCAO JUSCELINO KUBITSCHEK', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2707, 3004, 'INSTITUTO DE ENSINO SUPERIOR SANTA CECLIA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2708, 3005, 'FACULDADE SEM FRONTEIRAS - FASEF', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2709, 3006, 'INSTITUTO SUPERIOR DE EDUCAO MILTON CAMPOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2710, 3007, 'FACULDADE DO INSTITUTO NACIONAL DE PS-GRADUAO DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2711, 3008, 'FACULDADE DO INSTITUTO NACIONAL DE PS-GRADUAO DE SO JOS DOS CAMPOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2712, 3009, 'INSTITUTO DE ENSINO SUPERIOR APIA - ISA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2713, 3010, 'FACULDADE DE CINCIAS HUMANAS DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2714, 3011, 'FACULDADE PROF. MIGUEL NGELO DA SILVA SANTOS', 3, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2715, 3012, 'FAJOPA - FACULDADE JOO PAULO II', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2716, 3013, 'INSTITUTO SUPERIOR DE EDUCAO CIDADANIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2717, 3014, 'FACULDADE DE FARMCIA DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2718, 3015, 'INSTITUTO DE EDUCAO SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2719, 3016, 'FACULDADE DE ENFERMAGEM JOS RODRIGUES DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2720, 3017, 'INSTITUTO SUPERIOR DE EDUCAO UNIPLAM', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2721, 3018, 'FACULDADE METROPOLITANA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2722, 3019, 'INSTITUTO DE EDUCAO SUPERIOR ANAMLIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2723, 3020, 'FACULDADE SANTA RITA DE CSSIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2724, 3021, 'INSTITUTO SUPERIOR DE EDUCAO SANTA RITA DE CSSIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2725, 3022, 'FACULDADE DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2726, 3023, 'FACULDADES INTEGRADAS ATLNTICA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2727, 3024, 'FACULDADES INTEGRADAS DE ENSINO SUPERIOR DO ESTADO DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2728, 3025, 'INSTITUTO PRESBITERIANO DE EDUCAO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2729, 3026, 'FACULDADE DO PLANALTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2730, 3027, 'FACULDADE DE CINCIAS EDUCACIONAIS E SISTEMAS INTEGRADOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2731, 3028, 'FACULDADE REUNIDAS DO LITORAL DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2732, 3029, 'FACULDADE DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2733, 3030, 'INSTITUTO SUPERIOR DE EDUCAO EDUVALE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2734, 3031, 'FACULDADE ALPHA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2735, 3032, 'FACULDADE SANTA MARIA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2736, 3033, 'FACULDADE DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2737, 3034, 'FACULDADE DELTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2738, 3035, 'FACULDADE BARBOSA CASTILHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2739, 3036, 'LIBERTAS - INSTITUTO SUPERIOR DE CINCIAS JURIDICAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2740, 3037, 'FACULDADE DE IBINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2741, 3038, 'INSTITUTO SUPERIOR DE EDUCAO LIONS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2742, 3039, 'FACULDADE VASCONCELLOS & SOUZA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2743, 3040, 'FACULDADE VALE DO JEQUITINHONHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2744, 3041, 'FACULDADE FILADELFIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2745, 3042, 'CHRISTUS FACULDADE DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2746, 3043, 'ABEU FACULDADE DE SO JOO DE MERITI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2747, 3044, 'ABEU FACULDADE VILAR DOS TELES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2748, 3045, 'ABEU FACULDADE DE QUEIMADOS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2749, 3046, 'INSTITUTO SUPERIOR DE EDUCAO - ISE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2750, 3047, 'FACULDADE POLIVALENTE - FACIP', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2751, 3048, 'INSTITUTO SUPERIOR DE EDUCAO DO INSTITUTO PORTO ALEGRE DA IGREJA METODISTA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2752, 3049, 'INSTITUTO ODONTOLGICO DO PARAN - ODONS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2753, 3050, 'FACULDADE DE TEOLOGIA DA ASSEMBLIA DE DEUS - FATEAD', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2754, 3051, 'FACULDADE TEOLGICA DE CINCIAS HUMANAS E SOCIAIS LOGOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2755, 3052, 'FACULDADE EDUCARE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2756, 3053, 'FACULDADE DE ODONTOLOGIA PR-PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2757, 3054, 'FACULDADE DE CINCIAS E TECNOLOGIA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2758, 3055, 'INSTITUTO SUPERIOR DE EDUCAO DE RONDNIA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2759, 3056, 'ESCOLA SUPERIOR OSWALDO CRUZ', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2760, 3057, 'INSTITUTO DE ENSINO SUPERIOR SAGRADA FAMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2761, 3058, 'INSTITUTO SUPERIOR DE EDUCAO SAGRADA FAMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2762, 3059, 'INSTITUTO DE ENSINO SUPERIOR DO PARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2763, 3060, 'INSTITUTO DE ENSINO SUPERIOR DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2764, 3061, 'INSTITUTO SUPERIOR DE EDUCAO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2765, 3062, 'FACULDADE COMERCIAL DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2766, 3063, 'FAECO - FACULDADE EDUCACIONAL COSTA OESTE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2767, 3064, 'FACULDADE DE CINCIAS EXATAS E AGRARIAS DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2768, 3065, 'INSTITUTO SUPERIOR DE EDUCAO DE ARAUCRIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2769, 3066, 'FACULDADE INTERAMERICANA DE BELM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2770, 3067, 'FACULDADE ROTHSCHILD DE EDUCAO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2771, 3068, 'FACULDADE DE TEOLOGIA E CINCIAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2772, 3069, 'INSTITUTO DE EDUCAO SUPERIOR DE ALAGOAS NO LITORAL NORTE', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2773, 3070, 'FACULDADE DE BELA VISTA DE GOIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2774, 3071, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2775, 3072, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE JACOBINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2776, 3073, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE CRUZ DAS ALMAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2777, 3074, 'FACULDADE DO EXTREMO SUL DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2778, 3075, 'INSTITUTO DE EDUCAO SUPERIOR UNYAHNA DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2779, 3076, 'FACULDADE DE SADE IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2780, 3077, 'FACULDADE METROPOLITANA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2781, 3078, 'INSTITUTO SUPERIOR DE EDUCAO FRUTALENSE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2782, 3079, 'INSTITUTO DE ENSINO SUPERIOR ALTERNATIVO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2783, 3080, 'FACULDADE DE ARTE E DESIGN BERLIM - BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2784, 3081, 'FACULDADE ITALIANA DE TECNOLOGIA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2785, 3082, 'FACULDADE 2 DE JULHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2786, 3083, 'FACULDADE INTEGRADA UNIVERACRUZ DE GUANAMBI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2787, 3084, 'FACULDADE MARQUS DE POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2788, 3085, 'FACULDADE EVANGLICA LUZ E VIDA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2789, 3086, 'FACULDADE DA MODA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2790, 3087, 'CHRISTUS INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2791, 3088, 'FACULDADE UNIDAS SUL BAHIA - FUSBA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2792, 3089, 'FACULDADE CAIARAS DE TAGUATINGA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2793, 3090, 'INSTITUTO SUPERIOR NORMAL AURELINA PALMEIRA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2794, 3091, 'CENTRO DE ENSINO LEIDE TORRES', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2795, 3092, 'FACULDADE DE BEM ESTAR SOCIAL E SADE DE ITAPECERICA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2796, 3093, 'FACULDADE DE ENFERMAGEM JOO FRANCISCO DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2797, 3094, 'FACULDADE DE DIREITO DESEMBARGADOR AFFONSO TEIXEIRA LAGES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2798, 3095, 'FACULDADE DE CINCIAS AGRRIAS DOM ORIONE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2799, 3096, 'FACULDADE DE AGRONOMIA MANOEL ANTNIO DA SILVA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2800, 3097, 'FACULDADE DE DIREITO AFONSO PENA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2801, 3098, 'INSTITUTO SUPERIOR DE EDUCAO SO JUDAS TADEU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2802, 3099, 'FACULDADE POTIGUAR DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2803, 3100, 'FACULDADE INTEGRADA UNIVERACRUZ DE BOM JESUS DA LAPA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2804, 3101, 'FACULDADE INTEGRADA UNIVERACRUZ DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2805, 3102, 'FACULDADE INTEGRADA UNIVERACRUZ DE CAMPO FORMOSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2806, 3103, 'FACULDADE INTEGRADA UNIVERACRUZ DE BRUMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2807, 3104, 'FACULDADE INTEGRADA UNIVERACRUZ DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2808, 3105, 'FACULDADE INTEGRADA UNIVERACRUZ DE JACOBINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2809, 3106, 'FACULDADE INTEGRADA UNIVERACRUZ DE ITAMARAJ', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2810, 3107, 'FACULDADE BENEMRITA EDUCADORA UNIVERACRUZ DE PAULO AFONSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2811, 3108, 'FACULDADE INTEGRADA UNIVERACRUZ DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2812, 3109, 'FACULDADE ITEGRADA UNIVERACRUZ DE VALENA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2813, 3110, 'FACULDADE ITEGRADA UNIVERACRUZ DE CAMAARI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2814, 3111, 'FACULDADE INTEGRADA UNIVERACRUZ DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2815, 3112, 'FACULDADE INTEGRADA UNIVERACRUZ DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2816, 3113, 'FACULDADE INTEGRADA UNIVERACRUZ DE PILO ARCADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2817, 3114, 'FACULDADE INTEGRADA UNIVERACRUZ DE VITRIA DA CONQUISTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2818, 3115, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO DE PIRAPORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2819, 3116, 'FACULDADE SANTO AGOSTINHO DE PIRAPORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2820, 3117, 'FACULDADE DE SADE E DESENVOLVIMENTO HUMANO SANTO AGOSTINHO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2821, 3118, 'FALCUDADE INTEGRADA UNIVERACRUZ DE BARRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2822, 3119, 'FACULDADE INTEGRADA UNIVERACRUZ DE DIAS D''AVILA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2823, 3120, 'FACULDADE INTEGRADA UNIVERACRUZ DE CANDEIAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2824, 3121, 'FACULDADE INTEGRADA UNIVERACRUZ DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2825, 3122, 'FACULDADE INTEGRADA UNIVERACRUZ SIMES FILHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2826, 3123, 'FACULDADE INTEGRADA UNIVERACRUZ DE SANTA MARIA DA VITRIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2827, 3124, 'FACULDADE DO DISTRITO FEDERAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2828, 3125, 'FACULDADE INTEGRADA UNIVERACRUZ DE PORTO SEGURO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2829, 3126, 'FACULDADE INTEGRADA UNIVERACRUZ DE SENHOR DO BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2830, 3127, 'FACULDADE INTEGRADA UNIVERACRUZ DE IRECE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2831, 3128, 'FACULDADE INTEGRADA UNIVERACRUZ DE LAURO DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2832, 3129, 'FACULDADE INTEGRADA UNIVERACRUZ DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2833, 3130, 'FACULDADE INTEGRADA UNIVERACRUZ DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2834, 3131, 'FACULDADE INTEGRADA UNIVERACRUZ DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2835, 3132, 'FACULDADE INEGRADA UNIVERACRUZ DE EUCLIDES DA CUNHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2836, 3133, 'FACULDADE INTEGRADA UNIVERACRUZ DE JUAZEIRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2837, 3134, 'FACULDADE INTEGRADA UNIVERACRUZ DE ITABERABA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2838, 3135, 'FACULDADE INTEGRADA UNIVERACRUZ DE TEIXEIRA DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2839, 3136, 'FACULDADES INTEGRADA UNIVERACRUZ DE IPIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2840, 3137, 'FACULDADE INTEGRADA UNIVERACRUZ DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2841, 3138, 'FACULDADE DINMICA DE ITAIPULNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2842, 3139, 'INSTITUTO DE SUPERIOR DE EDUCAO FRANCISCO AGUIAR', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2843, 3140, 'FACULDADE ZEUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2844, 3141, 'FACVALE - FACULDADE DO VALE DO JACUPE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2845, 3142, 'INSTITUTO SUPERIOR DE EDUCAO EDEM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2846, 3143, 'FACULDADE DO VAREJO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2847, 3144, 'FACULDADE GUAS LINDAS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2848, 3145, 'FACULDADE DE DIREITO SO JUDAS TADEU DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2849, 3146, 'FACULDADE DE ODONTOLOGIA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2850, 3147, 'FACULDADE DE DIREITO DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2851, 3148, 'FACULDADE ANCHIETA DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2852, 3149, 'FACULDADES INTEGRADAS DO OESTE DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2853, 3150, 'INSTITUTO SUPERIOR DE EDUCAO DA FACULDADE DE CINCIAS E LETRAS DE ARARAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2854, 3151, 'UNIVERSIDADE COMUNITRIA REGIONAL DE CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2855, 3152, 'INSTITUTO SUPERIOR DE EDUCAO SANTA RITA DO SAPUCA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2856, 3153, 'INSTITUTO SUPERIOR DE EDUCAO CANTAREIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2857, 3154, 'FACULDADE DE TECNOLOGIA SENAI RIO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2858, 3155, 'FACULDADE DE TECNOLOGIA SENAI JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2859, 3156, 'FACULDADE DE TECNOLOGIA SENAI BRUSQUE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2860, 3157, 'INSTITUTO SUPERIOR DE EDUCAO ALMEIDA RODRIGUES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2861, 3158, 'INSTITUTO SUPERIOR DE EDUCAO ANGLO-AMERICANO DE FOZ DO IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2862, 3159, 'FACULDADE DE TECNOLOGIA SENAI FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2863, 3160, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE ALAGOAS', 1, 1, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2864, 3161, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO SERTO PERNAMBUCANO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2865, 3162, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DE SANTA CATARINA', 1, 1, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2866, 3163, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO RIO DE JANEIRO', 1, 1, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2867, 3164, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE MATO GROSSO', 1, 1, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2868, 3165, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA  DO TRINGULO MINEIRO', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2869, 3166, 'INSTITUTO SUPERIOR DE EDUCAO DE IBINA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2870, 3167, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2871, 3168, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2872, 3169, 'FACULDADE DE TECNOLOGIA IBTA CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2873, 3170, 'FACULDADES INTEGRADAS ASSOCIAO DE ENSINO DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2874, 3171, 'FACULDADE EQUIPE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2875, 3172, 'UNIVERSIDADE DO ESTADO DO AMAZONAS', 2, 1, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2876, 3173, 'FACULDADE DE TECNOLOGIA DO COMRCIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2877, 3174, 'INSTITUTO SUPERIOR DE EDUCAO DE VINHEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2878, 3175, 'INSTITUTO SUPERIOR DE EDUCAO DE TAQUARA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2879, 3176, 'INSTITUTO SUPERIOR DE EDUCAO EQUIPE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2880, 3177, 'FACULDADE DE ADMINISTRAO DA FESPSP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2881, 3178, 'INSTITUTO DE EDUCAO SUPERIOR DE BARUERI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2882, 3179, 'FACULDADE DA CIDADE DE SO GONALO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2883, 3180, 'INSTITUTO SUPERIOR DE EDUCAO UNIO DAS AMRICAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2884, 3181, 'FACULDADE DE DIREITO DE BOA VISTA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2885, 3182, 'CENTRO DE ENSINO SUPERIOR ARCANJO MIKAEL DE ARAPIRACA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2886, 3183, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE SERGIPE', 1, 1, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2887, 3184, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE RORAIMA', 1, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2888, 3185, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE SO VICENTE DO SUL', 1, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2889, 3186, 'FACULDADE EVOLUO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2890, 3187, 'INSTITUTO SUPERIOR DE EDUCAO CORAO DE JESUS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2891, 3188, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO NORTE DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2892, 3189, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2893, 3190, 'INSTITUTO SUPERIOR DE EDUCAO DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2894, 3191, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2895, 3192, 'INSTITUTO SUPERIOR DE EDUCAO DE CAJAZEIRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2896, 3193, 'FACULDADES INTEGRADAS DOS CAMPOS GERAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2897, 3194, 'FACULDADE DE MINAS BH', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2898, 3195, 'FACULDADE VILA RICA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2899, 3196, 'FACULDADE PONTES E LACERDA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2900, 3197, 'FACULDADES DO PARECIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2901, 3198, 'FACULDADE DE CINCIAS HUMANAS DE IVAIPOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2902, 3199, 'FANESF - FACULDADE NACIONAL DE ENSINO SUPERIOR DA FAZENDA RIO GRANDE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2903, 3200, 'FANPINHAIS - FACULDADE NACIONAL DE PINHAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2904, 3201, 'FACULDADE DE EDUCAO E ENSINO SUPERIOR DO ABRANCHES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2905, 3202, 'FACULDADES AUGUSTUS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2906, 3203, 'INSTITUTO SUPERIOR DE EDUCAO ALBERT EINSTEIN', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2907, 3204, 'FACULDADE DE QUATRO MARCOS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2908, 3205, 'FACULDADE DE CINCIAS BIOLGICAS E DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2909, 3206, 'INSTITUTO DO SABER', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2910, 3207, 'FACULDADES DE CAFELNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2911, 3208, 'FACULDADE AMERICA DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2912, 3209, 'FACULDADE DE ARAATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2913, 3210, 'INSTITUTO EDUCACIONAL EVANGELICO DE ARAPONGAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2914, 3211, 'FACDIPAR-FACULDADE DE DIREITO DO PARANA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2915, 3212, 'INSTITUTO SUPERIOR DE FILOSOFIA BERTHIER', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2916, 3213, 'AFIMA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2917, 3214, 'FACULDADE EUROPEU DO RIO DE JANEIRO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2918, 3215, 'FACULDADE RELIGARE TEOLGICA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2919, 3216, 'FACULDADE DE CINCIAS DA BAHIA - FACIBA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2920, 3217, 'FACULDADE DE ENSINO SUPERIOR DO BRASIL', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2921, 3218, 'FACULDADE DE CINCIAS DA SADE DE PORTO ALEGRE', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2922, 3219, 'FACULDADE EVANGLICA DE INDAIATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2923, 3220, 'INSTITUTO NACIONAL DE EDUCAO SUPERIOR DE EDUCAO E CULTURA - INESC', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2924, 3221, 'FACULDADE DE ODONTOLOGIA DE MACAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2925, 3222, 'FACULDADE DE ODONTOLOGIA DE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2926, 3223, 'ESCOLA SUPERIOR DE CINCIAS DA SADE', 2, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2927, 3224, 'FACULDADE DE FARMCIA E BIOQUMICA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2928, 3225, 'FACULDADE DE ENFERMAGEM', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2929, 3226, 'FACULDADE DE MEDICINA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2930, 3227, 'FACULDADE DE SISTEMA DE INFORMAO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2931, 3228, 'FACULDADE DE ADMINISTRAO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2932, 3229, 'FACULDADE DE TURISMO DE DUQUE DE CAXIAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2933, 3230, 'FACULDADE LUIZ EDUARDO MAGALHES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2934, 3231, 'INSTITUTO SUPERIOR DE EDUCAO PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2935, 3232, 'FACULDADE IGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2936, 3233, 'FACULDADE AMRICA DO SUL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2937, 3234, 'URN. FACULDADE DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2938, 3235, 'INSTITUTO SUPERIOR DE EDUCAO JOO PAULO PRIMEIRO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2939, 3236, 'INSITUTO DE TEOLOGIA DA DIOCESE DE SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2940, 3237, 'FACULDADE SENAC DE ADMINISTRAO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2941, 3238, 'FACULDADE DE ODONTOLOGIA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2942, 3239, 'INSTITUTO DE DESENVOLVIMENTO EDUCACIONAL SUL CATARINENSE S/C LTDA.', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2943, 3240, 'INSTITUTO SUPERIOR DE EDUCAO DE JUIZ DE FORA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2944, 3241, 'FACULDADE NACIONAL DE EDUCAO E ENSINO SUPERIOR DO BRASIL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2945, 3242, 'FACULDADE ALFA BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2946, 3243, 'FACULDADE NACIONAL CAMPO LARGO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2947, 3244, 'FACULDADE DE GUARAPARI', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2948, 3245, 'FACULDADE DE SENADOR CANEDO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2949, 3246, 'FACULDADE DE LINHARES', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2950, 3247, 'FACULDADE VITRIA DO ESPRITO SANTO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2951, 3248, 'FACULDADE DE DOMINGOS MARTINS', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2952, 3249, 'FACULDADE PADRAO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2953, 3250, 'FACULDADE DE MORRINHOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2954, 3251, 'FACULDADE DE VILA VELHA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2955, 3252, 'FACULDADE QUIRINPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2956, 3253, 'FACULDADE COSTA ESMERALDA ITAPEMA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2957, 3254, 'FACULDADE DE EDUCAO E TEOLOGIA VIVA - FATEV', 1, 1, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2958, 3255, 'FACULDADE INPG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2959, 3256, 'INSTITUTO SUPERIOR DE ECOLOGIA HUMANA E DESENVOLVIMENTO SUSTENTVEL- ISEDS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2960, 3257, 'FAESSF - FACULDADE DE ENSINO SUPERIOR SANTA FELICIDADE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2961, 3258, 'FACULDADE DE DIREITO DE RESENDE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2962, 3259, 'FACULDADES DO ICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2963, 3260, 'FACULDADE PRINCESA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2964, 3261, 'FACULDADE DE EDUCAO E ENSINO SUPERIOR INTEGRAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2965, 3262, 'FACULDADE DOM BOSCO DE GUARANIAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2966, 3263, 'FACULDADE YVERDUN BRASILIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2967, 3265, 'FACULDADE BATISTA IDA NELSON', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2968, 3266, 'UNIDADE VOCACIONAL CIDADES - UVC', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2969, 3267, 'FACULDADE TADEU ARGOLO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2970, 3268, 'FACULDADE MADRE THAIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2971, 3269, 'FACULDADE DE JUAZEIRO DO NORTE', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2972, 3270, 'FACULDADE SO BENTO DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2973, 3271, 'FACULDADE QUASAR', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2974, 3272, 'FACULDADE DE DIREITO DE PETROLINA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2975, 3273, 'FACULDADE DO RECIFE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2976, 3274, 'FACULDADE PSICOLOGIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2977, 3275, 'FACULDADE JURIDICA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2978, 3276, 'FACULDADE FORTALEZA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2979, 3277, 'FACULDADE DE TECNOLOGIA PREVE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2980, 3278, 'FACULDADE DE TECNOLOGIA MARTINUS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2981, 3279, 'INSTITUTO FEDERAL DE EDUCAO, CINCIA E TECNOLOGIA DO SUDESTE DE MINAS GERAIS', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2982, 3280, 'FACULDADE SO JOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2983, 3281, 'FACULDADE DO DESENVOLVIMENTO DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2984, 3282, 'FACULDADE PONTAL DO PARANAPANEMA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2985, 3283, 'INSTITUTO BRASILEIRO DE ZOOTECNOLOGIA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2986, 3284, 'ESCOLA SUPERIOR DE ADMINISTRAO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2987, 3285, 'FACULDADE SANTO ANTONIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2988, 3286, 'FACULDADE DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2989, 3287, 'FACULDADE DA ASSEDIPA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2990, 3288, 'FACULDADE GENESIS - FAGEN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2991, 3289, 'FACULDADE DE CINCIAS ADMINISTRATIVAS E CONTBEIS COSTA BRAGA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2992, 3290, 'INSTITUTO SUPERIOR DE EDUCAO DOS INCONFIDENTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2993, 3291, 'FACULDADE DUARTE COELHO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2994, 3292, 'INSTITUTO SUPERIOR DE EDUCAO DE CAET', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2995, 3293, 'FACULDADE DE TECNOLOGIA DIAMANTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2996, 3294, 'FACULDADE DE TECNOLOGIA ENIAC-FAPI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2997, 3295, 'FACULDADE DE TECNOLOGIA SENAC FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2998, 3296, 'FACULDADE DE TECNOLOGIA SENAC RIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (2999, 3297, 'CENTRO DE EDUCAO TECNOLGICA CHRISTUS', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3000, 3298, 'FACULDADE DE TECNOLOGIA CAMES', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3001, 3299, 'FACULDADE DE TECNOLOGIA INFORMTICA', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3002, 3300, 'FACULDADE DE TECNOLOGIA MICHEL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3003, 3301, 'FACULDADE DE TECNOLOGIA MAGISTER', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3004, 3302, 'INSTITUTO SUPERIOR DE EDUCAO DE JUNQUEIRPOLIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3005, 3303, 'FACULDADES INTEGRADAS MATO-GROSSENSES DE CINCIAS SOCIAIS E HUMANAS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3006, 3304, 'FACULDADES INTEGRADAS DE PATOS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3007, 3305, 'FACULDADE PITGORAS DE PSICOLOGIA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3008, 3306, 'FACULDADE DE TECNOLOGIA IPUC', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3009, 3307, 'FACULDADE DE TECNOLOGIA DE RIO CLARO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3010, 3308, 'FACULDADE DE TECNOLOGIA TERMOMECNICA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3011, 3309, 'FACULDADE DE TECNOLOGIA INTERNACIONAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3012, 3310, 'FACULDADE DE TECNOLOGIA DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3013, 3311, 'FACULDADE DE TECNOLOGIA SO FRANCISCO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3014, 3312, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE RIO VERDE', 1, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3015, 3313, 'CENTRO FEDERAL DE EDUCAO TECNOLGICA DE BAMBU', 1, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3016, 3314, 'FACULDADE DE CINCIAS GERENCIAIS DA FUNCEC', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3017, 3315, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3018, 3316, 'FACULDADE SUDOESTE PAULISTANO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3019, 3317, 'FACULDADE MASTER', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3020, 3318, 'FACULDADE MASTER', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3021, 3319, 'FACULDADE DE ENSINO SUPERIOR DE CATALO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3022, 3320, 'INSTITUTO DE TELEMARKETING E SERVIO AO CLIENTE LTDA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3023, 3321, 'FACIVALE -FACULDADE INTERNACIONAL DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3024, 3322, 'FACULDADE POLITCNICA DE ATIBAIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3025, 3323, 'INSTITUTO DE EDUCAO E ENSINO SUPERIOR DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3026, 3324, 'FACULDADE TALENTI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3027, 3325, 'FACULDADE COMUNITRIA DE CONTAGEM', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3028, 3326, 'CENTRO SUPERIOR DE ESTUDOS JURDICOS CARLOS DRUMMOND DE ANDRADE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3029, 3327, 'UNIPONTE - FACULDADE DA MEIA PONTE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3030, 3328, 'CENTRO DE ESTUDOS SUPERIORES EM CINCIAS DA SADE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3031, 3329, 'FACULDADE DE DIREITO DE PAR DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3032, 3330, 'INSTITUTO DE LNGUA PORTUGUESA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3033, 3331, 'FAMOL - FACULDADE MONTEIRO LOBATO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3034, 3332, 'FACULDADE DE TECNOLOGIA SENAC RIO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3035, 3333, 'FACULDADE DE TECNOLOGIA TECBRASIL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3036, 3334, 'FACULDADE DE TECNOLOGIA SO GONALO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3037, 3335, 'FACULDADE DE CINCIAS E LETRAS DO NOROESTE DO PARAN FACIP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3038, 3336, 'UNIVERSIDADE ESTADUAL DO RIO GRANDE DO SUL', 2, 1, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3039, 3337, 'FACULDADE DE TECNOLOGIA DE TERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3040, 3338, 'INSTITUTO SUPERIOR DE EDUCAO GETLIO VARGAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3041, 3339, 'FACULDADE DE GETLIO VARGAS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3042, 3340, 'FACULDADE DE PAULISTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3043, 3341, 'FACULDADES DE ALTO ARAGUAIA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3044, 3342, 'FACULDADE EVANGLICA DE CINCIA FILOSOFICA E TEOLGICA DO MARANHO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3045, 3343, 'FACULDADES DO PARECIS - FACCIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3046, 3344, 'FACULDADE REGIONAL DE IREC', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3047, 3345, 'FACULDADE YVERDON DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3048, 3346, 'FACULDADE YVERDON', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3049, 3347, 'FACULDADE REGIONAL DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3050, 3348, 'FACULDADE REGIONAL DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3051, 3349, 'FACULDADE REGIONAL METROPOLITANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3052, 3350, 'FACULDADE REGIONAL DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3053, 3351, 'INSTITUTO SUPERIOR DO NOROESTE PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3054, 3352, 'FACULDADE REGIONAL DE SANTO AMARO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3055, 3353, 'FACULDADE RECON.BAHIA EMPRESARIAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3056, 3354, 'FACULDADE REGIONAL DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3057, 3355, 'FACULDADE REGIONAL DE SO FLIX', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3058, 3356, 'INSTITUTO TEOLGICO DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3059, 3357, 'FACULDADE DO SERTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3060, 3358, 'FACULDADE CIENTFICA DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3061, 3359, 'FESC - FACULDADE DO EXTREMO SUL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3062, 3360, 'INSTITUTO DE EDUCAO SUPERIOR PRESIDENTE KENNEDY - CENTRO DE FORMAO DE PROFISSIONAIS DE EDUCAO', 2, 1, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3063, 3361, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3064, 3362, 'INSTITUTO DE CINCIAS HUMANAS E SOCIAIS APLICADAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3065, 3363, 'FACULDADE GUARA', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3066, 3364, 'FACULDADE DE ENFERMAGEM DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3067, 3365, 'FACULDADE SO FRANCISCO DE JUAZEIRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3068, 3366, 'FACULDADE DE CINCIAS GERENCIAIS DE OLIVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3069, 3367, 'INSTITUTO SUPERIOR DE EDUCAO DE OLIVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3070, 3368, 'CENTRO UNIVERSITRIO DO SUL DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3071, 3369, 'FACULDADE DE CINCIAS HUMANAS E SOCIAIS GEREMRIO DANTAS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3072, 3370, 'ESCOLA DOMINICANA DE TEOLOGIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3073, 3371, 'CENTRO UNIVERSITRIO DE PATOS DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3074, 3372, 'CENTRO UNIVERSITRIO DE LAVRAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3075, 3373, 'INSTITUTO SUPERIOR DE EDUCAO DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3076, 3374, 'FACULDADE PAUL SABATIER DE EDUCAO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3077, 3375, 'INSTITUTO DE ENSINO SUPERIOR MLTIPLO', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3078, 3376, 'FACULDADE DE TEOLOGIA INTEGRADA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3079, 3377, 'FACULDADE MONTESSORIANO DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3080, 3378, 'FACULDADE CENECISTA DE RECIFE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3081, 3379, 'INSTITUTO DE EDUCAO SUPERIOR SERRANO - IESSER', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3082, 3380, 'FACULDADE MISSIONEIRA DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3083, 3381, 'UNITEC FACULDADE TECNOLGICA E CIENTFICA DE UNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3084, 3382, 'ESCOLA SUPERIOR DE ENFERMAGEM E PEDAGOGIA MARIA PASTOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3085, 3383, 'INSTITUTO SUPERIOR DE EDUCAO SAGRA - ISAGRA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3086, 3384, 'FACULDADE SAGRA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3087, 3385, 'FACULDADE DE DIREITO PROFESSOR PEDRO ALEIXO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3088, 3386, 'FACULDADE DE ADMINISTRAO DE EMPRESAS - UNITECH', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3089, 3387, 'FACULDADE NACIONAL DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3090, 3388, 'FACULDADE PARASO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3091, 3389, 'FACULDADE RAZES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3092, 3390, 'FACULDADE DE DIREITO DO ICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3093, 3391, 'INSTITUTO SUPERIOR DE EDUCAO NOVA VIDA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3094, 3392, 'FACULDADE DA ACADEMIA BRASILEIRA DE EDUCAO E CULTURA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3095, 3393, 'FACULDADE DE ENSINO SUPERIOR DOM BOSCO', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3096, 3394, 'FACULDADE VALE DO IPIRANGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3097, 3395, 'FACULDADE EDUCIONAL SUL PARANAENSE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3098, 3396, 'FACULDADE LS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3099, 3397, 'FACULDADE BOAS NOVAS DE CINCIAS TEOLGICAS, SOCIAIS E BIOTECNOLGICAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3100, 3398, 'FACULDADE DE CINCIAS DO ESTADO DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3101, 3399, 'FACULDADE DE TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3102, 3400, 'FACULDADE DE SADE DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3103, 3401, 'FACULDADE DE ITAPECERICA DA SERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3104, 3402, 'FACULDADE ANGLICANA DE NEGCIOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3105, 3403, 'INSTITUTO SUPERIOR DE EDUCAO RUI BARBOSA - ISURB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3106, 3404, 'FACULDADE DE FILOSOFIA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3107, 3405, 'FACULDADE RUI BARBOSA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3108, 3406, 'FACULDADE CNDIDO RONDON', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3109, 3407, 'IESEMA - INSTITUTO SUPERIOR DE EDUCAO DA MATA ALAGOANA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3110, 3408, 'FACULDADE AMAZNIA DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3111, 3409, 'FACULDADE DE CINCIAS DA SADE CRISTO REI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3112, 3410, 'INSTITUTO DE EDUCAO SUPERIOR FATEV', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3113, 3411, 'FACULDADE EA DE QUEIROS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3114, 3412, 'FACULDADE DO INTERIOR PAULISTA DE TANABI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3115, 3413, 'ISEMP - INSTITUTO SUPERIOR DE EDUCAO DA MATA PERNAMBUCANA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3116, 3414, 'FACULDADE DO ENTORNO DE BRASLIA - FAEB', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3117, 3415, 'FACULDADE DE TECNOLOGIA DE CAXIAS DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3118, 3416, 'FACULDADE JK DO GAMA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3119, 3417, 'FACULDADE DO CENTRO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3120, 3418, 'FACULDADE VALE DO CARIRI', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3121, 3419, 'FACULDADE CHROMOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3122, 3420, 'INSTITUTO SUPERIOR DE EDUCAO DE CAMPOS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3123, 3421, 'FACULDADE DE MANDAGUAU', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3124, 3422, 'FACULDADE TEOLGICA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3125, 3423, 'FACULDADE DE ADMINISTRAO DE NOVO PROGRESSO', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3126, 3424, 'FACULDADE DE LAGES', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3127, 3425, 'FACETE - FACULDADE DE ARTES, CINCIAS E TECNOLOGIAS DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3128, 3426, 'ESCOLA SUPERIOR DE CINCIAS TRADICIONAIS E AMBIENTAIS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3129, 3427, 'FACULDADE JOS AUGUSTO VIEIRA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3130, 3428, 'FACULDADE ALFA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3131, 3429, 'FACULDADE RIO DAS CONTAS - FAC-RIO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3132, 3430, 'FACULDADE DE MARKETING E NEGCIOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3133, 3431, 'FACULDADE DO SERID', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3134, 3432, 'FACULDADES INTEGRADAS DE CINCIAS HUMANAS, SADE E EDUCAO DE GUARULHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3135, 3433, 'INSTITUTO SUPERIOR DE EDUCAO INTERLAGOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3136, 3434, 'FACULDADE DE SADE IBITURUNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3137, 3435, 'INSTITUTO SUPERIOR DE EDUCAO NORTE MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3138, 3436, 'FACULDADE SAVONITTI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3139, 3437, 'FACULDADE DO LITORAL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3140, 3438, 'FACULDADE MASTER DE PALMAS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3141, 3439, 'FACULDADE MASTER DE PARAUAPEBAS', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3142, 3440, 'FACULDADE MASTER DE SANTARM', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3143, 3441, 'FACULDADE MASTER DE MARAB', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3144, 3442, 'INSTITUTO DE ENSINO ALVARES DE AZEVEDO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3145, 3443, 'FACULDADE INEDI', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3146, 3444, 'FACULDADE DE CINCIAS BIOLGICAS E SOCIAIS APLICADAS JEFFERSON JORGE SALOMO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3147, 3445, 'FACULDADE JOO DO VALE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3148, 3446, 'INSTITUTO SUPERIOR DE EDUCAO JOO DO VALE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3149, 3447, 'FACULDADES SANTAMARIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3150, 3448, 'INSTITUTO SUPERIOR DE EDUCAO IBITURUNA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3151, 3449, 'TRECSON FACULDADE DE CINCIAS SOCIAIS APLICADAS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3152, 3450, 'FACULDADES MASTER', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3153, 3451, 'INSTITUTO SUPERIOR DE EDUCAO DO LITORAL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3154, 3453, 'FACULDADE JUSCELINO KUBTSCHEK GUAR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3155, 3454, 'FACULDADES LEONEL AGUIAR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3156, 3455, 'FACULDADE DE EDUCAO EXPOVEST', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3157, 3456, 'FACULDADE POLITCNICA DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3158, 3457, 'FESC- FACULDADE DO EXTREMO SUL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3159, 3458, 'ACADEMIA TEOLGICA DA GRAA DE DEUS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3160, 3459, 'INSTITUTO DE ENSINO SUPERIOR E PESQUISA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3161, 3460, 'INSTITUTO SUPERIOR DE ENSINO E PESQUISA DE ITUIUTABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3162, 3461, 'FACULDADE DE FILOSOFIA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3163, 3462, 'FACULDADE DE ENFERMAGEM DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3164, 3463, 'FACULDADE DE DIREITO DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3165, 3464, 'FACULDADE DE ENGENHARIA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3166, 3465, 'FACULDADE DE INFORMTICA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3167, 3466, 'FACULDADE DE SERVIO SOCIAL DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3168, 3467, 'FACULDADE DE NUTRIO DA FUNDAO DE ENSINO SUPERIOR DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3169, 3468, 'FACULDADE DE ENGENHARIA DO TRINGULO MINEIRO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3170, 3469, 'FACULDADE DE ADMINISTRAO DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3171, 3470, 'FACULDADE EDUCAO FSICA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3172, 3471, 'FACULDADE DE MODA DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3173, 3472, 'INSTITUTO SUPERIOR DE EDUCAO DE PASSOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3174, 3473, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DE CARANGOLA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3175, 3474, 'FACULDADE DE CINCIAS EXATAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3176, 3475, 'INSTITUTO SUPERIOR DE EDUCAO DE CARANGOLA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3177, 3476, 'FACULDADE DE FILOSOFIA E LETRAS DE DIAMANTINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3178, 3477, 'FACULDADE DE FILOSOFIA CINCIAS E LETRAS NOSSA SENHORA DE SION', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3179, 3478, 'FACULDADE DE CINCIAS EXATAS E HUMANAS DA CAMPANHA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3180, 3479, 'INSTITUTO SUPERIOR DE EDUCAO NOSSA SENHORA DE SION', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3181, 3480, 'FACULDADE DE CINCIAS JURDICAS DE DIAMANTINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3182, 3481, 'INSTITUTO SUPERIOR DE EDUCAO DE DIAMANTINA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3183, 3482, 'INSTITUTO SUPERIOR DE EDUCAO DE DIVINPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3184, 3483, 'INSTITUTO SUPERIOR DE EDUCAO DE CLUDIO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3185, 3484, 'FACULDADE DE CINCIAS GERENCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3186, 3485, 'INSTITUTO SUPERIOR DE EDUCAO DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3187, 3486, 'INSTITUTO SUPERIOR DE EDUCAO DE ITUIUTABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3188, 3487, 'FACULDADE SENAC/RS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3189, 3488, 'FACULDADE DE CINCIAS ECONMICAS DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3190, 3489, 'FACULDADE DE CINCIAS SOCIAIS APLICADAS DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3191, 3490, 'FACULDADE DE ENGENHARIA ELTRICA DE CONSELHEIRO LAFAIETE', 3, 1, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3192, 3491, 'FACULDADE EVANGLICA DO BRASIL (FAEB)', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3193, 3492, 'FACULDADE DE DIREITO DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3194, 3493, 'FACULDADE PROJETO DIDTICO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3195, 3494, 'FACULDADE GUAJARAENSE DE EDUCAO E CULTURA', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3196, 3495, 'FACULDADE PINHALZINHO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3197, 3496, 'INSTITUTO NACIONAL DE DESENVOLVIMENTO HUMANO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3198, 3497, 'FACULDADE BRASILIENSE DE DIREITO - FADIR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3199, 3498, 'FACULDADE DE ARTES, TECNOLOGIA E NEGCIOS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3200, 3499, 'INSTITUTO BOLSA DE VALORES', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3201, 3500, 'FACULDADE DO SERTO BAIANO - FASB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3202, 3501, 'FACULDADE DE ADMINISTRAO DE SANTO ANTNIO DO MONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3203, 3502, 'FACULDADE DA FRONTEIRA - FAF', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3204, 3503, 'FACUDADE DA CINCIA DA SAUDE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3205, 3504, 'ESCOLA DE ENSINO SUPERIOR DE BRASILNDIA DE MINAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3206, 3505, 'INSTITUTO SUPERIOR DE EDUCAO DE JACUTINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3207, 3506, 'FACULDADE DE CINCIAS EDUCACIONAIS DE SERGIPE', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3208, 3507, 'FACULDADE DE ADMINISTRAO DE EMPRESAS IBRAFEM', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3209, 3508, 'FACULDADE SANTO ANTONIO DE QUEIMADAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3210, 3509, 'FACULDADE VICENTINA - FAVI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3211, 3510, 'UNASP.FACULDADE DO SERVIDOR PBLICO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3212, 3511, 'FACULDADES COMUNITRIA UNIDAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3213, 3512, 'ILES - INSTITUTO LOGOS DE EDUCAO E ENSINO SUPERIOR', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3214, 3513, 'FACULDADE DE PRESIDENTE VENCESLAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3215, 3514, 'FACULDADE DE CINCIAS GERENCIAIS ALVES FORTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3216, 3515, 'FACULDADES INTEGRADAS DA VITRIA DE SANTO ANTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3217, 3516, 'FACULDADE DE CINCIAS DA SADE ARCHIMEDES THEODORO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3218, 3517, 'FACULDADE IEGS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3219, 3518, 'FACULDADE JANGADA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3220, 3519, 'FACULDADE DE CINCAS GERENCIAIS DO ALTO PARAOPEBA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3221, 3520, 'INSTITUTO DE EDUCAO SUPERIOR SANTA MARIA (IESSAM)', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3222, 3521, 'FACULDADE EXPOENTE DE EDUCAO E PESQUISA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3223, 3522, 'FACULDADE CATLICA DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3224, 3523, 'ESCOLA SUPERIOR DO MINISTRIO PBLICO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3225, 3524, 'UNIBUSINESS - FACULDADE INTERNACIONAL DE EDUCAO E GERNCIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3226, 3525, 'FACULDADE EVANGLICA DE TECNOLOGIA, CINCIAS E BIOTECNOLOGIA DA CGADB', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3227, 3526, 'INSTITUTO DE ENSINO SUPERIOR MIGUEL DE CERVANTES', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3228, 3527, 'FACULDADE CATLICA DOM AQUINO DE CUIAB', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3229, 3528, 'FACULDADES CATLICAS DE FRANCA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3230, 3529, 'CENTRO UNIVERSITRIO EURPEDES DE MARLIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3231, 3530, 'FACULDADE DE NANUQUE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3232, 3531, 'FACULDADE CACHOEIRO DE ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3233, 3532, 'FACULDADE DO OESTE CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3234, 3533, 'FACULDADE CERES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3235, 3534, 'FACULDADE BRASILEIRA DE ENSINO SUPERIOR E TECNOLOGIA - FABEST', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3236, 3535, 'FACULDADE PAULISTA DE CINCIAS FARMACUTICAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3237, 3536, 'FACULDADE DE TEOLOGIA EVANGLICA EM CURITIBA - FATEV', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3238, 3537, 'INSTITUTO BRASILEIRO DE MODA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3239, 3538, 'FACULDADES INTEGRADAS SVIGN', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3240, 3539, 'FACULDADE SANTA LCIA - MOGI GUAU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3241, 3540, 'UNIO DE FACULDADES DE ADMINISTRAO PBLICA - UNIFAP', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3242, 3541, 'FACULDADE NOTRE DAME', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3243, 3542, 'INSTITUTO DE ENSINO SUPERIOR DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3244, 3543, 'FACULDADE NOVO HAMBURGO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3245, 3544, 'FACULDADE DE FISIOTERAPIA MACHADO DE ASSIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3246, 3546, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BARRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3247, 3547, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ITABUNA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3248, 3548, 'FACULDADE SUA DE HOTELARIA DE JOINVILLE S.A.', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3249, 3549, 'FACULDADE NACIONAL SNIOR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3250, 3550, 'FACULDADE SAO FRANCISCO DE CAJAZEIRAS', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3251, 3551, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BARREIRAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3252, 3552, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE TEIXEIRA DE FREITAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3253, 3553, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE VALENA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3254, 3554, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE JACOBINA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3255, 3555, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3256, 3556, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3257, 3557, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE IRECE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3258, 3558, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE IPIR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3259, 3559, 'FACULDADE DE PORANGATU', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3260, 3560, 'FACULDADE DE CINCIAS DA SADE DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3261, 3561, 'FACULDADE SANTA RITA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3262, 3562, 'FACULDADE DE ODONTOLOGIA RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3263, 3563, 'FACULDADE DE ODONTOLOGIA RIO BRANCO', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3264, 3564, 'FACULDADE MORENENSE DE EDUCAO-FAM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3265, 3565, 'FACULDADE MORENENSE DE EDUCAO-FAM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3266, 3566, 'FACULDADE PAULO FREIRE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3267, 3567, 'FMV - FACULDADE METROPOLITANA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3268, 3568, 'FACULDADE DE DESENVOLVIMENTO E INTEGRAO REGIONAL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3269, 3569, 'INSTITUTO SUPERIOR DE EDUCAO DE MANHUAU', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3270, 3570, 'FACULDADE DE CINCIAS E EDUCAO DE SO SIMO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3271, 3571, 'FACULDADE DOS INCONFIDENTES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3272, 3572, 'FACULDADE DE DIREITO DA ACADEMIA BRASILEIRA DE CINCIAS JURDICAS E SOCIAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3273, 3573, 'FACULDADE TEOLGICA BATISTA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3274, 3574, 'UNIO DE FACULDADES DE PARASO - UNIFAP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3275, 3575, 'FACULDADE ATIVA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3276, 3576, 'FACULDADE DE ENSINO SUPERIOR DO LITORAL SUL - FASUL', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3277, 3577, 'FACULDADE DE ALTOS ESTUDOS DA BAHIA - FAE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3278, 3578, 'FACULDADE DE CIENCIAS FARMACEUTICAS DO PANTANAL', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3279, 3579, 'INSTITUTO LUTERANO DE EDUCAO SUPERIOR DO PARECIS', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3280, 3580, 'FACULDADE DE EDUCAO, CINCIAS SOCIAIS E DA SADE - SESI/TO', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3281, 3581, 'FACULDADE DE ENSINO TECNOLGICO FILADLFIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3282, 3582, 'FACULDADE PORTO CALVO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3283, 3583, 'ESCOLAS SUPERIORES DE ADMINISTRAO, GEOGRAFIA E CURSO NORMAL SUPERIOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3284, 3584, 'INSTITUTO SUPERIOR DE EDUCAO SANTA CRUZ', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3285, 3585, 'FACULDADE SANTA CRUZ', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3286, 3586, 'FACULDADE OXFORD DO BRASIL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3287, 3587, 'FACULDADE DIOCESANA SO JOS', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3288, 3588, 'FACULDADE DOM PEDRO II', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3289, 3589, 'FACULDADE TEOREMA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3290, 3590, 'FACULDADE DE ENFERMAGEM SO VICENTE DE PAULA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3291, 3591, 'INSTITUTO SUPERIOR DE EDUCAO DE MACAPARANA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3292, 3593, 'FACULDADE DE CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3293, 3594, 'FACULDADE DE CINCIA, TECNOLOGIA E EDUCAO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3294, 3595, 'INSTITUTO SUPERIOR DE EDUCAO DE SANTA MARIA DA VITRIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3295, 3596, 'FACULDADE MONTSERRAT', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3296, 3597, 'FACULDADE DE ENSINO SUPERIOR DE SANTA CRUZ DO CAPIBARIBE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3297, 3598, 'FACULDADE DE IRATI', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3298, 3599, 'FACULDADE DE ITAPEMA - FAI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3299, 3600, 'FACULDADE DO LITORAL PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3300, 3601, 'FACULDADE DE TAPEJARA - FATAP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3301, 3602, 'FACULDADES INTEGRADAS DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3302, 3603, 'FACULDADES INTEGRADAS TORRICELLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3303, 3604, 'INSTITUTO SUPERIOR DE EDUCAO DE CARIACICA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3304, 3605, 'FACULDADE DE CINCIAS, COMUNICAES E TECNOLOGIAS DE PESQUEIRA - FACCIP', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3305, 3606, 'INSTITUTO SUPERIOR DE EDUCAO PRESBITERIANO VALE DO TOCANTINS', 4, 2, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3306, 3607, 'ESCOLA SUPERIOR ASSOCIADA DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3307, 3608, 'INSTITUTO SUPERIOR DE EDUCAO DE LONDRINA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3308, 3609, 'FACULDADES INTEGRADAS IPITANGA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3309, 3610, 'FACULDADES INTEGRADAS UNICESP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3310, 3611, 'FACULDADES INTEGRADAS DA UNIO DE ENSINO SUPERIOR CERTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3311, 3612, 'FACULDADE ANHANGUERA DE VALINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3312, 3613, 'FACULDADES INTEGRADAS IESGO', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3313, 3614, 'ESCOLA SUPERIOR DE CINCIAS SOCIAIS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3314, 3615, 'FACULDADE BOA VIAGEM - INSTITUTO MATERNO INFANTIL DE PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3315, 3616, 'FACULDADES PHD', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3316, 3617, 'FACULDADE DE CINCIAS HUMANAS E EXATAS DO SERTO DO SO FRANCISCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3317, 3618, 'FACULDADE MARIO SCHENBERG', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3318, 3619, 'UNESC - UNIO DAS ESCOLAS SUPERIORES DE CACOAL', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3319, 3620, 'ESCOLA INTERNACIONAL DE ADMINISTRAO E NEGCIOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3320, 3621, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3321, 3622, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3322, 3623, 'FACULDADE DE CINCIAS DA BAHIA - FACIBA (NOME ALTERADO POR SOLICITAO DO MEC)', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3323, 3624, 'PUC MINAS ARCOS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3324, 3625, 'FACULDADE CATLICA NOSSA SENHORA DAS VITRIAS', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3325, 3626, 'FACULDADE BRASILEIRA DE EDUCAO E NEGCIOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3326, 3627, 'FACULDADE DE TECNOLOGIA BARO DO RIO BRANCO', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3327, 3628, 'FACULDADADE TEOLGICA REFORMADA - FTR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3328, 3629, 'FACULDADADE TEOLGICA REFORMADA - FTR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3329, 3630, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE PAULO AFONSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3330, 3631, 'FACULDADE DAMAS DA INSTRUO CRIST', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3331, 3632, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ITABERABA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3332, 3633, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE CAMPO FORMOSO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3333, 3634, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BOM JESUS DA LAPA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3334, 3635, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SANTA MARIA DA VITRIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3335, 3636, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SENHOR DO BONFIM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3336, 3637, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3337, 3638, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ILHUS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3338, 3639, 'FACULDADE DE DIREITO DO INSTITUTO DE ENSINO SUPERIOR DO CIRCUITO DO OURO - FDINESO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3339, 3640, 'FACULDADE DE CINCIAS ECONMICAS DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3340, 3641, 'CENTRO UNIVERSITRIO DA FUNDAO EDUCACIONAL DE BARRETOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3341, 3642, 'FACULDADE INTEGRADA DE PERNAMBUCO - SURUBIM (FACIPE - SURUBIM)', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3342, 3643, 'FACULDADE CATLICA NOSSA SENHORA DAS NEVES', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3343, 3644, 'FACULDADE CATLICA SANTA TERESINHA', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3344, 3645, 'FACULDADE CATLICA SANTA TERESINHA (CADASTRADA INDEVIDAMENTE)', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3345, 3646, 'FACULDADE DE TECNOLOGIA DE OURO FINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3346, 3647, 'FACULDADE DE TECNOLOGIA MARISTA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3347, 3648, 'FACULDADE CENTRO AMRICA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3348, 3649, 'FACULDADE CIDADE VERDE', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3349, 3650, 'INSTITUTO SUPERIOR DE EDUCAAO GREGORIANO - ISEG', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3350, 3651, 'FACULDADE DAS GUAS QUENTES - FAQ', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3351, 3652, 'FACULDADE PRESBITERIANA SAMUEL GRAHAM', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3352, 3653, 'FACULDADE PRESBITERIANA SAMUEL GRAHAM', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3353, 3654, 'FACULDADE DE CINCIAS COMUNICAES E TECNOLOGIAS DE FLORESTA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3354, 3655, 'FACULDADE DE JANABA - FAJAN', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3355, 3656, 'FACULDADE NOVA TRINDADE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3356, 3657, 'FACULDADE DE COMPUTAO DE MONTES CLAROS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3357, 3658, 'FACULDADE UIRAPURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3358, 3659, 'FACULDADE DE CINCIAS COMUNICAO E TECNOLOGIA DE SALGUEIRO-FACTS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3359, 3660, 'INSTITUTO SUPERIOR DE EDUCAO DE SALGUEIRO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3360, 3662, 'FACULDADE EVANGLICA LOGOS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3361, 3663, 'FACULDADE EVANGLICA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3362, 3664, 'INSTITUTO SUPERIOR DE EDUCAO DE VARGEM GRANDE DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3363, 3665, 'FACULDADE DE JOAABA - FJ', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3364, 3666, 'FACULDADE DE ADMINISTRAO DA AERONUTCA', 1, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3365, 3667, 'FACULDADE FILADLFIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3366, 3668, 'FACULDADE DE ENFERMAGEM E ADMINISTRAO DE JATA - FEAJ', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3367, 3669, 'FACULDADE REGIONAL DE RIBEIRA DO POMBAL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3368, 3670, 'FACULDADE DE CRICIUMA - FACRI', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3369, 3671, 'FACULDADE INTERDISCIPLINAR DE BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3370, 3672, 'FACULDADE DE CAMPOS NOVOS - FACAN', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3371, 3673, 'FACULDADE PREMIER', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3372, 3674, 'INSTITUTO NORMAL SUPERIOR - FBV', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3373, 3675, 'SINAL - FACULDADE DE TEOLOGIA E FILOSOFIA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3374, 3676, 'FACULDADE DE TECNOLOGIA DO VALE DO RIBEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3375, 3677, 'FACULDADE DE TECNOLOGIA DE ALTA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3376, 3678, 'FACULDADE DE TECNOLOGIA DO VALE DO ITAJA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3377, 3679, 'INSTITUTO DE ENSINO SUPERIOR DE GARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3378, 3680, 'FACULDADE DE TECNOLOGIA DARCY RIBEIRO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3379, 3681, 'FACULDADES DE GARANHUNS', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3380, 3682, 'INSTITUTO SUPERIOR DE EDUCAO DO MUNICPIO DE ITAPERUNA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3381, 3683, 'FACULDADE UNILAGOS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3382, 3684, 'FUNDAO DE ENSINO SUPERIOR DE CLEVELNDIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3383, 3685, 'FACULDADE DA POLI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3384, 3686, 'FADITU - FACULDADE DE DIREITO DE IT', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3385, 3687, 'FACULDADES INTEGRADAS DE JACARE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3386, 3688, 'FACULDADES INTEGRADAS DO VALE DO IVA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3387, 3689, 'FACULDADE PEDRO JULIO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3388, 3690, 'FACULDADE PEDRO II', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3389, 3691, 'FACULDADE DE TECNOLOGIA TUPY DE SO BENTO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3390, 3692, 'FACULDADE DE TECNOLOGIA IPEP DE CAMPINAS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3391, 3693, 'FACULDADE DE TECNOLOGIA IPEP DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3392, 3694, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE SANTA CATARINA', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3393, 3695, 'FACULDADE DE TECNOLOGIA ESTCIO DE S DE OURINHOS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3394, 3696, 'FACULDADE DE TECNOLOGIA DE JOINVILLE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3395, 3697, 'FACULDADE DE TECNOLOGIA SAINT PASTOUS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3396, 3698, 'PORTAL FACULDADES', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3397, 3699, 'FACULDADE PORTAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3398, 3700, 'FACULDADE DE CINCIAS JURDICAS DE PORTO VELHO', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3399, 3701, 'FACULDADE DE CINCIAS GERENCIAIS DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3400, 3702, 'FACULDADES ELO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3401, 3703, 'INSTITUTO SUPERIOR DE ADMINISTRAO E NEGOCIOS DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3402, 3704, 'FACULDADE DO ALTO PARNABA - FAP', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3403, 3705, 'FACULDADE KHALIL LTDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3404, 3706, 'FACULDADE REGIONAL DE POJUCA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3405, 3707, 'FACULDADE INTEGRADAS DO MORENO - FIAM', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3406, 3708, 'FACULDADE INTEGRAL DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3407, 3709, 'INSTUTO DE ENSINO SUPERIOR SO LUCAS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3408, 3710, 'ESCOLA SUPERIOR NACIONAL DE SEGUROS', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3409, 3711, 'FACULDADE CENTRAL DE CRISTALINA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3410, 3712, 'FACULDADE VITRIA', 4, 2, 'AC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3411, 3713, 'INSTITUTO DE TEOLOGIA E PASTORAL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3412, 3714, 'INSTITUTO TATUIANO DE ENSINO SUPERIOR - ITES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3413, 3715, 'FACULDADE METROPOLITANA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3414, 3716, 'FACULDADE CINCIAS DA VIDA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3415, 3717, 'FACULDADE CULTURAL ANJAGUN', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3416, 3718, 'FACULDADE DE CINCIAS HUMANAS JLIO GOMES', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3417, 3719, 'FACULDADE DE CORAO DE JESUS-FADECOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3418, 3720, 'FACULDADE PORTO REAL', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3419, 3721, 'FACULDADE OLIVEIRA TELLES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3420, 3722, 'FACULDADE DE CINCIAS MDICAS INTEGRADAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3421, 3723, 'FACULDADE NACIONAL POLICURSOS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3422, 3724, 'FACULDADE SO JOS', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3423, 3725, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE ITAMARAJU', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3424, 3726, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE JEQUI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3425, 3727, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE EUCLIDES DA CUNHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3426, 3728, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE FEIRA DE SANTANA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3427, 3729, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE GUANAMBI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3428, 3730, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE CAMAARI', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3429, 3731, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE BRUMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3430, 3732, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE VITRIA DA CONQUISTA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3431, 3733, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE JUAZEIRO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3432, 3734, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE SERRINHA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3433, 3735, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE EUNPOLIS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3434, 3736, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE PILO ARCADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3435, 3737, 'FACULDADE INTEGRADA DE ADMINISTRAO PBLICA DE PORTO SEGURO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3436, 3738, 'FACULDADE DE EDUCAO, CINCIAS E LETRAS DO NOROESTE DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3437, 3739, 'FACULDADE ASSOCIAO HOSPITALAR DE ILHA SOLTEIRA - FACISA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3438, 3740, 'FACULDADE DE MEDICINA DE BOTUCATU', 2, 1, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3439, 3741, 'FACULDADE DE EDUCAO DE BACABAL - FEBAC', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3440, 3742, 'FACULDADES DE CINCIAS E TECNOLOGIA DA AMAZNIA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3441, 3743, 'FACULDADE DE TECNOLOGIA SO FRANCISCO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3442, 3744, 'FACULDADE CETEP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3443, 3745, 'INSTITUTO SUPERIOR SEJA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3444, 3746, 'FACULDADE PAULISTA DE PESQUISA E ENSINO SUPERIOR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3445, 3747, 'FACULDADE METROPOLITANA DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3446, 3748, 'FACULDADE DE TECNOLOGIA THEREZA PORTO MARQUES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3447, 3749, 'FACULDADE DE TECNOLOGIA BRASLIA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3448, 3750, 'FACULDADE DE TECNOLOGIA DO PAR', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3449, 3751, 'FACULDADE DE TECNOLOGIA DO CEAR', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3450, 3752, 'FACULDADE DE TECNOLOGIA CONTEC', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3451, 3753, 'FACULDADES INTEGRADAS DOM PEDRO II', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3452, 3754, 'FACULDADES INTEGRADAS ADVENTISTAS DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3453, 3755, 'FACULDADE EM AUTOCONHECIMENTO', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3454, 3756, 'FACULDADE DE ALMENARA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3455, 3757, 'FACULDADE SERRA DA MESA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3456, 3758, 'INSTITUTO SUPERIOR TUPY DE FLORIANPOLIS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3457, 3759, 'INSTITUTO SUPERIOR TUPY DE SO BENTO DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3458, 3760, 'FACULDADE OMNI', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3459, 3761, 'FACULDADE MONSENHOR JOS SINFRNIO', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3460, 3762, 'FACULDADE DE TECNOLOGIA MILNIO', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3461, 3763, 'FACULDADE DO INTERIOR PAULISTA DE TANABI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3462, 3764, 'CENTRO DE EDUCAO SUPERIOR DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3463, 3765, 'FACULDADE SANTO AGOSTINHO DE SANTA VITRIA - FASAV', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3464, 3766, 'INSTITUTO SUPERIOR DE EDUCAO SANTO AGOSTINHO DE SANTA VITRIA - ISAV', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3465, 3767, 'FACULDADE DE EDUCAAO CIENCIAS E TECNOLOGIA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3466, 3768, 'FACULDADE IBGEN - INSTITUTO BRASILEIRO DE GESTO DE NEGCIOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3467, 3769, 'FACULDADE MADRE TEREZA', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3468, 3770, 'FACULDADE TEOLGICA BATISTA DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3469, 3771, 'FACULDADE DE TURISMO E ADMINISTRAO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3470, 3772, 'FACULDADE DE TECNOLOGIA PASTOR DOHMS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3471, 3773, 'FACULDADE PAULIPOLITANA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3472, 3774, 'FACULDADE SO TOMAZ DE AQUINO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3473, 3775, 'INSTITUTO UVB.BR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3474, 3776, 'INSTITUTO DE ENSINO SUPERIOR DE MATO GROSSO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3475, 3777, 'INSTITUTO DE ENSINO SUPERIOR DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3476, 3778, 'INSTITUTO ARACAJU DE ENSINO E CULTURA', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3477, 3779, 'FACULDADE DE TECNOLOGIA RADIAL SANTO ANDR', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3478, 3780, 'FACULDADE DE TECNOLOGIA IMPACTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3479, 3781, 'FACULDADE DE TECNOLOGIA DE JARAGU DO SUL', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3480, 3782, 'FACULDADE DE TECNOLOGIA CACHOEIRO DE ITAPEMIRIM', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3481, 3783, 'INSTITUTO PARAENSE DE ENSINO E CULTURA', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3482, 3784, 'INSTITUTO DE ENSINO SUPERIOR DO RIO GRANDE DO NORTE', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3483, 3785, 'INSTITUTO MARANHENSE DE ENSINO E CULTURA', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3484, 3786, 'INSTITUTO MINAS GERAIS DE ENSINO E CULTURA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3485, 3787, 'INSTITUTO MACAP DE ENSINO SUPERIOR', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3486, 3788, 'INSTITUTO JUIZ DE FORA DE ENSINO SUPERIOR', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3487, 3789, 'FACULDADE BETEL DE GOIANSIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3488, 3790, 'FACULDADE DE TECNOLOGIA ENSITEC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3489, 3791, 'FACULDADE DE MEDICINA DO VALE DO AO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3490, 3792, 'FACULDADE DE TECNOLOGIA DO ITAJA-MIRIM', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3491, 3793, 'FACULDADE FRUTAL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3492, 3794, 'FACULDADE DE TECNOLOGIA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3493, 3795, 'CENTRO DE EDUCAO SUPERIOR TECNOLGICA DA TERRA PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3494, 3796, 'CENTRO DE ENSINO SUPERIOR DO ESTADO DO PIAU', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3495, 3797, 'FACULDADE GUAIRAC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3496, 3798, 'FACULDADE DE TEOLOGIA DE MINAS GERAIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3497, 3799, 'INSTITUTO SUPERIOR DE EDUCAO E CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3498, 3800, 'INSTITUTO DE EDUCAO E CULTURA VALE DO IPANEMA', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3499, 3801, 'CENTRO UNIVERSIT[ARIO ZEN', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3500, 3802, 'CENTRO DE EDUCAO TECNOLGICA DO INTERIOR PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3501, 3803, 'FACULDADE JAUENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3502, 3804, 'FACULDADE DE TECNOLOGIA SENAC DO RIO GRANDE DO SUL', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3503, 3805, 'FACULDADE DE TECNOLOGIA DA PARABA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3504, 3806, 'FACULDADE DE TECNOLOGIA DE RORAIMA', 4, 2, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3505, 3807, 'FACULDADE DE TECNOLOGIA IAPEC', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3506, 3808, 'FACULDADE DE ENSINO FACTUAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3507, 3809, 'INSTITUTO SUPERIOR DE EDUCAO TEOLOGICA DO AMAZONAS', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3508, 3810, 'NCLEO DE CINCIAS FIORAVANTI DI PIERO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3509, 3811, 'CENTRO DE ESTUDOS EM NEGCIOS INTERNACIONAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3510, 3812, 'FACULDADES PARA O DESENVOLVIMENTO SUSTENTVEL DO SUL DA BAHIA - FADESB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3511, 3813, 'FATECE - FACULDADES DE TECNOLOGIA CINCIAS E EDUCAO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3512, 3814, 'FACULDADE PLANALTO DO BRASIL - FPB', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3513, 3815, 'FACULDADE DE DIREITO DE ALTA FLORESTA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3514, 3816, 'FACULDADE SANTA MARIA GORETTI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3515, 3817, 'FACULDADE METROPOLITANA DA PARAIBA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3516, 3818, 'FACULDADES EQUIPE LTDA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3517, 3819, 'FACULDADE DE ADMINISTRAO DE EMPRESAS E GESTO PBLICA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3518, 3820, 'FACULDADE PETRNIO PORTELA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3519, 3821, 'FACULDADE SO BOAVENTURA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3520, 3822, 'INSTITUTO DE EDUCAO SUPERIOR DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3521, 3823, 'INSTITUTO DE EDUCAO SUPERIOR DE POUSO ALEGRE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3522, 3824, 'FACULDADE JOS CNDIDO DE MELO CARVALHO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3523, 3825, 'FACULDADE CATLICA RIO-PRETENSE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3524, 3826, 'FACULDADE VASCO DA GAMA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3525, 3827, 'ESCOLA SUPERIOR DE CIENCIAS COMERCIAIS', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3526, 3828, 'INSTITUTO SUPERIOR DE EDUCAO DE TUP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3527, 3829, 'CENTRO DE EDUCAO SUPERIOR TECNOLGICA DA TERRA PAULISTA - CETERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3528, 3830, 'INSTITUTO CENTRO DE ENSINO TECNOLGICO - SOBRAL', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3529, 3831, 'FACULDADE DE CINCIAS CONTBEIS', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3530, 3832, 'FACULDADE DE ZOOTECNIA', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3531, 3833, 'FACULDADE DE ENGENHARIA FLORESTAL', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3532, 3834, 'FACULDADE SANTA LCIA - PIRACICABA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3533, 3835, 'UNIVERSIDADE VIRTUAL DO ESTADO DO MARANHO', 2, 1, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3534, 3836, 'UNIVERSIDADE PAULISTA-UNIP', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3535, 3837, 'FACULDADE DE TECNOLOGIA MDULO PAULISTA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3536, 3838, 'FACULDADE DE TECNOLOGIA DO UNIUOL', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3537, 3839, 'FACULDADE DE TECNOLOGIA NOVO RUMO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3538, 3840, 'FACULDADE DE TECNOLOGIA E PROFISSIONAL CATARINENSE', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3539, 3841, 'FACULDADE PITGORAS DE ADMINISTRAO SUPERIOR DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3540, 3842, 'FACULDADE METROPOLITANA DE VITRIA', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3541, 3843, 'FACULDADE CANDIDO MENDES DE ARARUAMA', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3542, 3844, 'ESCOLA SUPERIOR DE CASTANHAL', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3543, 3845, 'FACULDADE TAQUARITUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3544, 3846, 'FACULDADE DE CINCIAS E CULTURA DA LIBERDADE', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3545, 3847, 'FACULDADE BAIANA DE DIREITO E GESTO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3546, 3848, 'FACULDADE GABRIELA GONALVES', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3547, 3849, 'FUNDAO UNIVERSIDADE FEDERAL DO TOCANTINS', 1, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3548, 3850, 'FACULDADE CONTEMPORNEA - UNC-SALVADOR', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3549, 3851, 'FACULDADE DO RECNCAVO - UNR-CRUZ DAS ALMAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3550, 3852, 'FACULDADE DO RECNCAVO - UNR-CONCEIO DO ALMEIDA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3551, 3853, 'FACULDADE MAURCIO DE NASSAU DE NATAL', 4, 2, 'RN', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3552, 3854, 'FACULDADE DAS GUAS EMENDADAS - FAE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3553, 3855, 'FACULDADES INTERNACIONAIS SAN MARTIN DO BRASIL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3554, 3856, 'FACULDADE DE SANTO ANASTCIO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3555, 3857, 'FACULDADE GAUDIUM', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3556, 3858, 'FACULDADE TOBIAS BARRETO DE MENEZES-FATOB', 4, 2, 'SE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3557, 3859, 'INSTITUTO SUPERIOR DE EDUCAO TECNOLGICA DO NORTE FLUMINENSE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3558, 3860, 'FACULDADE TRIUNFO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3559, 3861, 'FACULDADE DE TECNOLOGIA E NEGCIOS CONTEMPORNEO - FATEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3560, 3862, 'FACULDADE LUCIANO FEIJO', 4, 2, 'CE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3561, 3863, 'FACULDADE COOPERATIVA DE GOINIA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3562, 3864, 'FACULDADE REGIONAL DE ALAGOINHAS', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3563, 3865, 'FACULDADES INTEGRADAS PADRE HUMBERTO', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3564, 3866, 'FACULDADE BRASILEIRA DE EDUCAO E CULTURA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3565, 3867, 'FACULDADE MAU DE BRASLIA', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3566, 3868, 'INSTITUTO DE EDUCAO SUPERIOR DO ALTO PARANABA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3567, 3869, 'INSTITUTO FLORENCE DE ENSINO SUPERIOR', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3568, 3870, 'INSTITUTO DE ESTUDOS DE NEGCIOS INTERNACIONAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3569, 3871, 'ESCOLA DE ADMINISTRAO FAZENDRIA', 1, 1, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3570, 3872, 'FACULDADE DE TECNOLOGIA SO CARLOS', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3571, 3873, 'FACULDADE DE TECNOLOGIA DE BRUMADO', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3572, 3874, 'ESCOLA SUPERIOR PROFESSOR PAULO MARTINS', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3573, 3875, 'CENTRO UNIVERSITRIO DA FUNDAO EDUCACIONAL GUAXUP', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3574, 3876, 'INSTITUTO A VEZ DO MESTRE', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3575, 3877, 'FACULDADE BRASIL CENTRAL', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3576, 3878, 'FACULDADE DECISION DE NEGCIOS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3577, 3879, 'FACULDADE MAURCIO DE NASSAU DE CAMPINA GRANDE', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3578, 3880, 'INSTITUTO SOCIAL DE EDUCAO', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3579, 3881, 'FACULDADE DE INTEGRAO DO SERTO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3580, 3882, 'INSTITUTO DE ENSINO SUPERIOR DE FORMAO PROFISSIONAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3581, 3883, 'FACULDADE EVANGLICA LOGOS - FAEL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3582, 3884, 'CESB - CENTRO DE EDUCAO SUPERIOR DA BAHIA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3583, 3885, 'FACULDADES INTEGRADAS DA TERRA PAULISTA - FATERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3584, 3886, 'FACULDADE GUA BOA', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3585, 3887, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3586, 3888, 'ESCOLA SUPERIOR DE ADMINISTRAO E NEGCIOS DE CURITIBA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3587, 3889, 'FACULDADE DE IGARAPAVA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3588, 3890, 'FACULDADE MARQUES GUIMARES', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3589, 3891, 'SOCIEDADE EDUCACIONAL ALBERTI TOLENTINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3590, 3892, 'FACULDADE DE CINCIAS SOCIAIS J.G. MELO', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3591, 3894, 'UNIESP UNIO DAS INSTITUIES EDUCACIONAIS DO ESTADO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3592, 3895, 'INSTITUTO DE EDUCAO SUPERIOR ALBERTI TOLENTINO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3593, 3896, 'FACULDADE MUNDIAL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3594, 3897, 'FACULDADE BUSCA VIDA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3595, 3898, 'SLCSA FACULDADE SANTA INS', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3596, 3899, 'FACULDADE DE RIBEIRAO DAS NEVES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3597, 3901, 'FACULDADES PROEDUC', 4, 2, 'RJ', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3598, 3902, 'FUNDAO ESCOLA DO MINISTRIO PBLICO DO ESTADO DO PARAN - FEMPAR', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3599, 3903, 'INFAMILIA - INSTITUTO BRASILEIRO DE SADE DA FAMLIA', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3600, 3904, 'FACULDADE DE CINCIAS GERENCIAIS DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3601, 3905, 'FACULDADE DE DIREITO DOCTUM DE BELO HORIZONTE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3602, 3906, 'FACULDADE DE CINCIAS AGRRIAS E DA TERRA DE TEFILO OTONI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3603, 3907, 'FACULDADE DE SAPIRANGA', 4, 2, 'RS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3604, 3908, 'FACOM - FACULDADE COMUNITRIA DO BRASIL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3605, 3909, 'ISTITUTO DE ENSINO SUPERIOR PARAENSE', 4, 2, 'PA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3606, 3910, 'INSTITUTO SUPERIOR DE EDUCAO DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3607, 3911, 'FACULDADE DE TECNOLOGIA OXFORD DO BRASIL', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3608, 3912, 'FACULDADE SUDOESTE PAULISTA - BOTUCATU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3609, 3913, 'FACULDADE SUDOESTE PAULISTA - TAQUARITUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3610, 3914, 'INSTITUTO SUPERIOR DE EDUCAO DO VALE DO CAPIBARIBE', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3611, 3915, 'INSTITUTO SUPERIOR DE EDUCAO CARLOS JOEL', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3612, 3916, 'FACULDADE DE CINCIAS JURDICAS E SOCIAIS DO PIAUI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3613, 3917, 'FACULDADE DE MERCADO AMPLO - FAMA', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3614, 3918, 'FACULDADE INTEGRADA EM CINCIAS HUMANAS', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3615, 3919, 'FACULDADE NOSSA SENHORA DO BOM CONSELHO', 4, 2, 'AL', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3616, 3920, 'FACULDADE DE TECNOLOGIA SENAI ROBERTO MANGE', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3617, 3921, 'FACULDADE ARNALDO HORCIO FERREIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3618, 3922, 'FACULDADE ARNALDO HORCIO FERREIRA', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3619, 3923, 'FACULDADE SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3620, 3924, 'FACULDADE DE IBIRACU', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3621, 3925, 'FACULDADE DE TEOLOGIA DO BRASIL - FATEB', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3622, 3926, 'FACULDADE DE FILOSOFIA, CINCIAS E LETRAS DO ALTO SO FRANCISCO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3623, 3927, 'FACULDADE DE CCERES', 4, 2, 'MT', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3624, 3928, 'FAESB - FACULDADE DE ENSINO SUPERIOR DO BRASIL', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3625, 3929, 'FACULDADES UNIDAS DE SETE LAGOAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3626, 3930, 'INSTITUTO DE EDUCAO SUPERIOR RAIMUNDO S', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3627, 3931, 'FACULDADE PRESBITERIANA ARMSTRONG', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3628, 3932, 'FACULDADE DE EDUCAO E TECNOLOGIA DE ITANHM', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3629, 3933, 'FACULDADE MTODO DE SO PAULO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3630, 3934, 'FACULDADE DA SADE', 4, 2, 'MA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3631, 3935, 'FACULDADE DE EDUCAO TEOLOGICA DO DISTRITO FEDERAL', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3632, 3936, 'FACULDADE ANHANGUERA DE LIMEIRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3633, 3937, 'FACULDADE ANHAGUERA DE INDAIATUBA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3634, 3938, 'FACULDADE DO NORTE DO MATO GROSSO DO SUL FANOR', 4, 2, 'MS', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3635, 3939, 'FACULDADE ALIANA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3636, 3940, 'FACULDADE DE ENSINO SUPERIOR SANTA BARBARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3637, 3941, 'FACULDADE COMUNITRIA DE SANTA BRBARA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3638, 3942, 'FACULDADE COMUNITRIA DE BAURU', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3639, 3943, 'FASC-TB FACULDADES ASSOCIADAS DE SC, DE TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3640, 3944, 'FACULDADE DE CINCIAS DA SADE', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3641, 3945, 'INSTITUTO DE EDUCAO EXECUTIVA CATHO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3642, 3946, 'FACULDADE DE TECNOLOGIA SENAC TUBARO', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3643, 3947, 'FACULDADE DE TECNOLOGIA SENAC CHAPEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3644, 3948, 'FACULDADE DE TECNOLOGIA SENAC BLUMENAU', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3645, 3949, 'CENTRO DE EDUCAO SUPERIOR TECNOLGICA DA TERRA PAULISTA - CETERRA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3646, 3950, 'CENTRO DE CINCIAS ETECNOLOGIA DETERESINA', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3647, 3951, 'FACULDADE DE TECNOLOGIA LUIZ ADELAR SCHEUER', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3648, 3952, 'FACULDADE VILAVELHENSE', 4, 2, 'ES', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3649, 3953, 'FACULDADE DE ODONTOLOGIA', 4, 2, 'AM', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3650, 3954, 'FACULDADE DE CINCIAS JURDICAS E GERENCIAIS DE OLIVEIRA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3651, 3955, 'FACULDADES INTEGRADAS DE CATAGUASES', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3652, 3956, 'ASSOCIAO EDUCACIONAL CENTRAL DE CRISTALINA', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3653, 3957, 'INSTITUTO SUPERIOR DE EDUCAO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3654, 3958, 'FACULDADE TECNOLOGICA DE MARILIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3655, 3959, 'FACULDADE TECNOLOGICA AMRICA DO SUL', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3656, 3960, 'FACULDADE TECNOLOGICA DE BIRIGUI', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3657, 3961, 'FACULDADE DE TECNOLOGIA SANTA RITA DE CSSIA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3658, 3962, 'FACULDADE DE TECNOLOGIA SENAI CIMATEC', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3659, 3963, 'INSTITUTO SUPERIOR DE EDUCAO CARLOS CHAGAS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3660, 3964, 'FACULDADE DE TECNOLOGIA PADRE ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3661, 3965, 'FACULDADE DE TECNOLOGIA ENG. MARCELO SILVA GUIMARES', 4, 2, 'BA', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3662, 3966, 'CENTRO UNIVERSITRIO DE CARATINGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3663, 3967, 'INSTITUTO SUPERIOR DE EDUCAO DE RORAIMA', 2, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3664, 3968, 'INSTITUTO SUPERIOR DE EDUCAO DE RORAINPOLIS', 2, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3665, 3969, 'INSTITUTO SUPERIOR DE SEGURANA E CIDADANIA DE RORAIMA', 2, 1, 'RR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3666, 3970, 'INSTITUTO SUPERIOR DE EDUCAO DE PARAISPOLIS', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3667, 3971, 'UNIO EDUCACIONAL DE PORTO NACIONAL - UNIPORTO', 3, 1, 'TO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3668, 3972, 'CENTRO SUPERIOR DE ENSINO E PESQUISA DE MACHADO', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3669, 3973, 'FACULDADE DE TECNOLOGIA BANDEIRANTES', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3670, 3974, 'UNIVERSIDADE DE RIO VERDE', 3, 1, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3671, 3975, 'FACULDADE SO FRANCISCO DE PIUMHI', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3672, 3976, 'INSTITUTO SUPERIOR DE CINCIAS HUMANAS E SOCIAIS APLICADAS DE ABAET', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3673, 3977, 'FACULDADE DE TECNOLOGIA DO AMAP', 4, 2, 'AP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3674, 3978, 'FACULDADE DE TECNOLOGIA PENTGONO', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3675, 3979, 'FACULDADE DE TECNOLOGIA LICEU NOROESTE', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3676, 3980, 'FACULDADE DE TECNOLOGIA CENACAP', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3677, 3981, 'FACULDADE DE TECNOLOGIA INTEGRAL', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3678, 3982, 'FACULDADE DE TECNOLOGIA FAMEG - FAMETEC', 4, 2, 'SC', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3679, 3983, 'CENTRO UNIVERSITRIO DE FORMIGA', 4, 2, 'MG', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3680, 3984, 'FUNDAO UNIVERSIDADE FEDERAL DO VALE DO SO FRANCISCO', 1, 1, 'PE', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3681, 3985, 'CENTRO UNIVERSITRIO SENAC', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3682, 3986, 'INSTITUTO SUPERIOR DE EDUCAO DO PARAN', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3683, 3987, 'FACULDADE UNIO DE GOYAZES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3684, 3988, 'FACULDADE UNIO DE GOYAZES', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3685, 3989, 'FACULDADE DE TECNOLOGIA DE JOO PESSOA', 4, 2, 'PB', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3686, 3990, 'FACULDADE DE TECNOLOGIA ANCHIETA', 4, 2, 'SP', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3687, 3991, 'FACULDADE DE TECNOLOGIA SO MATEUS', 4, 2, 'RO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3688, 3992, 'FACULDADE ILAPE', 4, 2, 'DF', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3689, 3993, 'FACULDADE DE TECNOLOGIA CETEP', 4, 2, 'PR', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3690, 3994, 'FACULDADE DE TECNOLOGIA LATINO AMERICANO DE ANPOLIS', 4, 2, 'GO', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3691, 3995, 'FACULDADE EVANGLICA CRISTO REI', 4, 2, 'PI', 1, 'NOW()', NULL);
INSERT INTO educacenso_ies VALUES (3692, 3996, 'FACULDADE SENAC PERNAMBUCO', 4, 2, 'PE', 1, 'NOW()', NULL);
INSERT INTO educace