<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'Avaliacao/_tests/Service/TestCommon.php';

/**
 * Avaliacao_Service_FaltaCommon abstract class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
abstract class Avaliacao_Service_FaltaCommon extends Avaliacao_Service_TestCommon
{
  /**
   * @return Avaliacao_Model_FaltaComponente
   */
  protected abstract function _getFaltaTestInstanciaDeFaltaERegistradaApenasUmaVezNoBoletim();

  /**
   * @return Avaliacao_Model_FaltaComponente
   */
  protected abstract function _getFaltaTestAdicionaFaltaNoBoletim();

  /**
   * Realiza asseres especficas para os validadores de uma instncia de
   * Avaliacao_Model_FaltaAbstract
   */
  protected abstract function _testAdicionaFaltaNoBoletimVerificaValidadores(Avaliacao_Model_FaltaAbstract $falta);

  /**
   * @see Avaliacao_Service_FaltaCommon#_getFaltaTestInstanciaDeFaltaERegistradaApenasUmaVezNoBoletim()
   */
  public function testInstanciaDeFaltaERegistradaApenasUmaVezNoBoletim()
  {
    $service = $this->_getServiceInstance();

    $falta = $this->_getFaltaTestInstanciaDeFaltaERegistradaApenasUmaVezNoBoletim();

    // Atribuio simples
    $service->addFalta($falta)
            ->addFalta($falta);

    $this->assertEquals(1, count($service->getFaltas()));

    // Via atribuio em lote
    $falta = clone $falta;
    $service->addFaltas(array($falta, $falta, $falta));

    $this->assertEquals(2, count($service->getFaltas()));
  }

  /**
   * @see Avaliacao_Service_FaltaCommon#_getFaltaTestAdicionaFaltaNoBoletim()
   * @see Avaliacao_Service_FaltaCommon#_testAdicionaFaltaNoBoletimVerificaValidadores()
   */
  public function testAdicionaFaltaNoBoletim()
  {
    $service = $this->_getServiceInstance();

    $falta = $this->_getFaltaTestAdicionaFaltaNoBoletim();

    $faltaOriginal = clone $falta;
    $service->addFalta($falta);

    $faltas = $service->getFaltas();
    $serviceFalta = array_shift($faltas);

    // Valores declarados explicitamente, verificao explcita
    $this->assertEquals($faltaOriginal->quantidade, $serviceFalta->quantidade);

    // Valores populados pelo service
    $this->assertNotEquals($faltaOriginal->etapa, $serviceFalta->etapa);

    // Validadores injetados no objeto
    $this->_testAdicionaFaltaNoBoletimVerificaValidadores($serviceFalta);
  }
}