<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'Avaliacao/_tests/Service/TestCommon.php';

/**
 * Avaliacao_Service_FaltaSituacaoCommon class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class Avaliacao_Service_FaltaSituacaoCommon extends Avaliacao_Service_TestCommon
{
  protected function _setUpFaltaAbstractDataMapperMock(
    Avaliacao_Model_FaltaAluno $faltaAluno, array $faltas)
  {
    // Configura mock para notas
    $mock = $this->getCleanMock('Avaliacao_Model_FaltaAbstractDataMapper');

    $mock->expects($this->any())
         ->method('findAll')
         ->with(array(), array('faltaAluno' => $faltaAluno->id), array('etapa' => 'ASC'))
         ->will($this->returnValue($faltas));

    $this->_setFaltaAbstractDataMapperMock($mock);
  }

  protected function _getExpectedSituacaoFaltas()
  {
    $faltaAluno = $this->_getConfigOption('faltaAluno', 'instance');

    // Valores retornados pelas instncias de classes legadas
    $cursoHoraFalta    = $this->_getConfigOption('curso', 'hora_falta');
    $serieCargaHoraria = $this->_getConfigOption('serie', 'carga_horaria');

    // Porcentagem configurada na regra
    $porcentagemPresenca = $this->_getRegraOption('porcentagemPresenca');

    $expected = new stdClass();
    $expected->situacao                 = 0;
    $expected->tipoFalta                = 0;
    $expected->cargaHoraria             = 0;
    $expected->cursoHoraFalta           = 0;
    $expected->totalFaltas              = 0;
    $expected->horasFaltas              = 0;
    $expected->porcentagemFalta         = 0;
    $expected->porcentagemPresenca      = 0;
    $expected->porcentagemPresencaRegra = 0;
    $expected->componentesCurriculares  = array();

    $expected->tipoFalta                = $faltaAluno->get('tipoFalta');
    $expected->cursoHoraFalta           = $cursoHoraFalta;
    $expected->porcentagemPresencaRegra = $porcentagemPresenca;
    $expected->cargaHoraria             = $serieCargaHoraria;

    return $expected;
  }
}