<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'Avaliacao/_tests/Service/TestCommon.php';

/**
 * Avaliacao_Service_PromocaoAlunoTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class Avaliacao_Service_PromocaoAlunoTest extends Avaliacao_Service_TestCommon
{
  protected function _setUpRegraAvaliacaoMock($tipoProgressao)
  {
    $mock = $this->getCleanMock('RegraAvaliacao_Model_Regra');
    $mock->expects($this->at(0))
         ->method('get')
         ->with('tipoProgressao')
         ->will($this->returnValue($tipoProgressao));

    return $mock;
  }

  /**
   * @expectedException CoreExt_Service_Exception
   */
  public function testPromoverAlunoLancaExcecaoCasoSituacaoEstejaEmAndamento()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = FALSE;
    $situacao->andamento   = TRUE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->promover();
  }

  /**
   * @expectedException CoreExt_Service_Exception
   */
  public function testPromoverAlunoLancaExcecaoCasoMatriculaDoAlunoJaEstejaAprovadaOuReprovada()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::APROVADO));

    $service->promover();
  }

  public function testPromoverAlunoAutomaticamenteProgressaoContinuada()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::CONTINUADA);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    $service->expects($this->at(5))
            ->method('_updateMatricula')
            ->with($codMatricula, $codUsuario, TRUE)
            ->will($this->returnValue(TRUE));

    $this->assertTrue($service->promover());
  }

  public function testPromoverAlunoAutomaticamenteProgressaoNaoContinuadaAutoMediaPresenca()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::NAO_CONTINUADA_AUTO_MEDIA_PRESENCA);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    $service->expects($this->at(5))
            ->method('_updateMatricula')
            ->with($codMatricula, $codUsuario, TRUE)
            ->will($this->returnValue(TRUE));

    $this->assertTrue($service->promover());
  }

  public function testReprovarAlunoAutomaticamenteProgressaoNaoContinuadaAutoMediaPresenca()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = TRUE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::NAO_CONTINUADA_AUTO_MEDIA_PRESENCA);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    $service->expects($this->at(5))
            ->method('_updateMatricula')
            ->with($codMatricula, $codUsuario, FALSE)
            ->will($this->returnValue(TRUE));

    $this->assertTrue($service->promover());
  }

  public function testPromoverAlunoAutomaticamenteProgressaoNaoContinuadaAutoMedia()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = TRUE;  // No considera reteno por falta

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::NAO_CONTINUADA_AUTO_SOMENTE_MEDIA);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    $service->expects($this->at(5))
            ->method('_updateMatricula')
            ->with($codMatricula, $codUsuario, TRUE)
            ->will($this->returnValue(TRUE));

    $this->assertTrue($service->promover());
  }

  public function testPromoverAlunoManualmenteProgressaoNaoContinuadaLancaExcecaoSeNaoConfirmada()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = FALSE; // Reprovado por nota
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::NAO_CONTINUADA_MANUAL);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    try {
      $service->promover();
      $this->fail('Invocar o mtodo "->promover()" sem uma confirmao booleana '
                  . 'explcita (TRUE ou FALSE) em uma progresso "NAO_CONTINUADA_MANUAL" '
                  . 'causa exceo.');
    }
    catch (CoreExt_Service_Exception $e)
    {
    }
  }

  public function testPromoverAlunoManualmenteProgressaoNaoContinuada()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = FALSE; // Reprovado por nota
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::NAO_CONTINUADA_MANUAL);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    $service->expects($this->at(5))
            ->method('_updateMatricula')
            ->with($codMatricula, $codUsuario, TRUE)
            ->will($this->returnValue(TRUE));

    $this->assertTrue($service->promover(TRUE));
  }

  public function testReprovarAlunoManualmenteProgressaoNaoContinuada()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = FALSE; // Reprovado por nota
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::NAO_CONTINUADA_MANUAL);

    $service = $this->setExcludedMethods(array('promover'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    $service->expects($this->at(5))
            ->method('_updateMatricula')
            ->with($codMatricula, $codUsuario, FALSE)
            ->will($this->returnValue(TRUE));

    $this->assertTrue($service->promover(FALSE));
  }

  public function testSaveBoletim()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    $service = $this->setExcludedMethods(array('save'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('saveNotas')
            ->will($this->returnValue($service));

    $service->expects($this->at(1))
            ->method('saveFaltas')
            ->will($this->returnValue($service));

    $service->expects($this->at(2))
            ->method('savePareceres')
            ->will($this->returnValue($service));

    $service->expects($this->at(3))
            ->method('promover')
            ->will($this->returnValue(TRUE));

    try {
      $service->save();
    }
    catch (Exception $e) {
      $this->fail('O mtodo "->save()" no deveria ter lanado exceo com o '
                  . 'cenrio de teste configurado.');
    }
  }

  public function testIntegracaoMatriculaPromoverAluno()
  {
    $situacao = new stdClass();
    $situacao->aprovado    = TRUE;
    $situacao->andamento   = FALSE;
    $situacao->recuperacao = FALSE;
    $situacao->retidoFalta = FALSE;

    $codMatricula = $this->_getConfigOption('matricula', 'cod_matricula');
    $codUsuario   = $this->_getConfigOption('usuario', 'cod_usuario');

    // Mock para RegraAvaliacao_Model_Regra
    $regra = $this->_setUpRegraAvaliacaoMock(RegraAvaliacao_Model_TipoProgressao::CONTINUADA);

    $service = $this->setExcludedMethods(array('promover', '_updateMatricula'))
                    ->getCleanMock('Avaliacao_Service_Boletim');

    $service->expects($this->at(0))
            ->method('getSituacaoAluno')
            ->will($this->returnValue($situacao));

    $service->expects($this->at(1))
            ->method('getOption')
            ->with('aprovado')
            ->will($this->returnValue(App_Model_MatriculaSituacao::EM_ANDAMENTO));

    $service->expects($this->at(2))
            ->method('getRegra')
            ->will($this->returnValue($regra));

    $service->expects($this->at(3))
            ->method('getOption')
            ->with('matricula')
            ->will($this->returnValue($codMatricula));

    $service->expects($this->at(4))
            ->method('getOption')
            ->with('usuario')
            ->will($this->returnValue($codUsuario));

    // Configura mock de instncia de classe legada
    $matricula = $this->getCleanMock('clsPmieducarMatricula');

    $matricula->expects($this->at(0))
              ->method('edita')
              ->will($this->returnValue(TRUE));

    CoreExt_Entity::addClassToStorage('clsPmieducarMatricula', $matricula,
      'include/pmieducar/clsPmieducarMatricula.inc.php', TRUE);

    $this->assertTrue($service->promover());
  }
}