<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'Avaliacao/_tests/Service/TestCommon.php';

/**
 * Avaliacao_Service_SituacaoTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Avaliacao
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class Avaliacao_Service_SituacaoTest extends Avaliacao_Service_TestCommon
{
  public function testSituacaoAluno()
  {
    $notaSituacoes = array(
      1 => App_Model_MatriculaSituacao::APROVADO,
      2 => App_Model_MatriculaSituacao::APROVADO_APOS_EXAME,
      3 => App_Model_MatriculaSituacao::EM_ANDAMENTO,
      4 => App_Model_MatriculaSituacao::EM_EXAME,
      5 => App_Model_MatriculaSituacao::REPROVADO
    );

    $faltaSituacoes = array(
      1 => App_Model_MatriculaSituacao::EM_ANDAMENTO,
      2 => App_Model_MatriculaSituacao::APROVADO,
      3 => App_Model_MatriculaSituacao::REPROVADO
    );

    // Possibilidades
    $expected = array(
      1 => array(
        1 => array(FALSE, TRUE, FALSE, FALSE),
        2 => array(TRUE, FALSE, FALSE, FALSE),
        3 => array(FALSE, FALSE, TRUE, FALSE)
      ),
      2 => array(
        1 => array(FALSE, TRUE, FALSE, TRUE),
        2 => array(TRUE, FALSE, FALSE, TRUE),
        3 => array(FALSE, FALSE, TRUE, TRUE)
      ),
      3 => array(
        1 => array(FALSE, TRUE, FALSE, FALSE),
        2 => array(FALSE, TRUE, FALSE, FALSE),
        3 => array(FALSE, TRUE, TRUE, FALSE)
      ),
      4 => array(
        1 => array(FALSE, TRUE, FALSE, TRUE),
        2 => array(FALSE, TRUE, FALSE, TRUE),
        3 => array(FALSE, TRUE, TRUE, TRUE)
      ),
      5 => array(
        1 => array(FALSE, TRUE, FALSE, FALSE),
        2 => array(FALSE, FALSE, FALSE, FALSE),
        3 => array(FALSE, FALSE, TRUE, FALSE)
      )
    );

    foreach ($notaSituacoes as $i => $notaSituacao) {
      $nota = new stdClass();
      $nota->situacao = $notaSituacao;

      foreach ($faltaSituacoes as $ii => $faltaSituacao) {
        $service = $this->setExcludedMethods(array('getSituacaoAluno'))
                        ->getCleanMock('Avaliacao_Service_Boletim');

        $falta = new stdClass();
        $falta->situacao = $faltaSituacao;

        $service->expects($this->once())
                ->method('getSituacaoComponentesCurriculares')
                ->will($this->returnValue($nota));

        $service->expects($this->once())
                ->method('getSituacaoFaltas')
                ->will($this->returnValue($falta));

        // Testa
        $situacao = $service->getSituacaoAluno();

        $this->assertEquals($expected[$i][$ii][0], $situacao->aprovado, "Aprovado, caso $i - $ii");
        $this->assertEquals($expected[$i][$ii][1], $situacao->andamento, "Andamento, caso $i - $ii");
        $this->assertEquals($expected[$i][$ii][2], $situacao->retidoFalta, "Retido por falta, caso $i - $ii");
        $this->assertEquals($expected[$i][$ii][3], $situacao->recuperacao, "Recuperao, caso $i - $ii");
      }
    }
  }
}