<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     ComponenteCurricular
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Entity.php';
require_once 'ComponenteCurricular/Model/TipoBase.php';

/**
 * ComponenteCurricular_Model_AnoEscolar class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     ComponenteCurricular
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class ComponenteCurricular_Model_AnoEscolar extends CoreExt_Entity
{
  protected $_data = array(
    'componenteCurricular' => NULL,
    'anoEscolar' => NULL,
    'cargaHoraria' => NULL
  );

  protected $_dataTypes = array(
    'cargaHoraria' => 'numeric'
  );

  protected $_references = array(
    'componenteCurricular' => array(
      'value' => NULL,
      'class' => 'ComponenteCurricular_Model_ComponenteDataMapper',
      'file'  => 'ComponenteCurricular/Model/ComponenteDataMapper.php'
    )
  );

  /**
   * Construtor. Remove o campo identidade j que usa uma chave composta.
   * @see CoreExt_Entity#__construct($options = array())
   */
  public function __construct($options = array()) {
    parent::__construct($options);
    unset($this->_data['id']);
  }

  /**
   * @see CoreExt_Entity#getDataMapper()
   */
  public function getDataMapper()
  {
    if (is_null($this->_dataMapper)) {
      require_once 'ComponenteCurricular/Model/AnoEscolarDataMapper.php';
      $this->setDataMapper(new ComponenteCurricular_Model_AnoEscolarDataMapper());
    }
    return parent::getDataMapper();
  }

  /**
   * @see CoreExt_Entity_Validatable#getDefaultValidatorCollection()
   */
  public function getDefaultValidatorCollection()
  {
    $validators = array();

    if (isset($this->anoEscolar)) {
      $validators['cargaHoraria'] = new CoreExt_Validate_Numeric(array('min' => 1));
    }

    return $validators;
  }
}