<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     ComponenteCurricular
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.2.0
 * @version     $Id$
 */

require_once 'CoreExt/DataMapper.php';
require_once 'ComponenteCurricular/Model/Turma.php';

/**
 * ComponenteCurricular_Model_TurmaDataMapper class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     ComponenteCurricular
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.2.0
 * @version     @@package_version@@
 */
class ComponenteCurricular_Model_TurmaDataMapper extends CoreExt_DataMapper
{
  protected $_entityClass = 'ComponenteCurricular_Model_Turma';
  protected $_tableName   = 'componente_curricular_turma';
  protected $_tableSchema = 'modules';

  /**
   * Os atributos anoEscolar e escola esto presentes apenas para
   * fins de desnormalizao.
   * @var array
   */
  protected $_attributeMap = array(
    'componenteCurricular' => 'componente_curricular_id',
    'anoEscolar'           => 'ano_escolar_id',
    'escola'               => 'escola_id',
    'turma'                => 'turma_id',
    'cargaHoraria'         => 'carga_horaria'
  );

  protected $_primaryKey = array(
    'componenteCurricular', 'turma'
  );

  /**
   * Realiza uma operao de atualizao em todas as instncias persistidas de
   * ComponenteCurricular_Model_Turma. A atualizao envolve criar, atualizar
   * e/ou apagar instncias persistidas.
   *
   * No exemplo de cdigo a seguir, se uma instncia de
   * ComponenteCurricular_Model_Turma com uma referncia a componenteCurricular
   * "1" existisse, esta teria seus atributos atualizados e persistidos
   * novamente. Se a referncia no existisse, uma nova instncia de
   * ComponenteCurricular_Model_Turma seria criada e persistida. Caso uma
   * referncia a "2" existisse, esta seria apagada por no estar referenciada
   * no array $componentes.
   *
   * <code>
   * <?php
   * $componentes = array(
   *   array('id' => 1, 'cargaHoraria' => 100)
   * );
   * $mapper->bulkUpdate(1, 1, 1, $componentes);
   * </code>
   *
   *
   *
   * @param  int   $anoEscolar  O cdigo do ano escolar/srie.
   * @param  int   $escola      O cdigo da escola.
   * @param  int   $turma       O cdigo da turma.
   * @param  array $componentes (id => integer, cargaHoraria => float|null)
   * @throws Exception
   */
  public function bulkUpdate($anoEscolar, $escola, $turma, array $componentes)
  {
    $update = $insert = $delete = array();

    $componentesTurma = $this->findAll(array(), array('turma'  => $turma));

    $objects = array();
    foreach ($componentesTurma as $componenteTurma) {
      $objects[$componenteTurma->get('componenteCurricular')] = $componenteTurma;
    }

    foreach ($componentes as $componente) {
      $id = $componente['id'];

      if (isset($objects[$id])) {
        $insert[$id] = $objects[$id];
        $insert[$id]->cargaHoraria = $componente['cargaHoraria'];
        continue;
      }

      $insert[$id] = new ComponenteCurricular_Model_Turma(array(
        'componenteCurricular' => $id,
        'anoEscolar'           => $anoEscolar,
        'escola'               => $escola,
        'turma'                => $turma,
        'cargaHoraria'         => $componente['cargaHoraria']
      ));
    }

    $delete = array_diff(array_keys($objects), array_keys($insert));

    foreach ($delete as $id) {
      $this->delete($objects[$id]);
    }

    foreach ($insert as $entry) {
      $this->save($entry);
    }
  }
}