<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     ComponenteCurricular
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'ComponenteCurricular/Model/ComponenteDataMapper.php';

/**
 * ComponenteDataMapperTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     ComponenteCurricular
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class ComponenteDataMapperTest extends UnitBaseTest
{
  protected $_mapper = NULL;

  protected function setUp()
  {
    $this->_mapper = new ComponenteCurricular_Model_ComponenteDataMapper();
  }

  public function testGetterDeAreaDataMapperInstanciaObjetoPorPadraoSeNenhumForConfigurado()
  {
    $this->assertType('AreaConhecimento_Model_AreaDataMapper', $this->_mapper->getAreaDataMapper());
  }

  public function testGetterDeAnoEscolarDataMapperInstanciaObjetoPorPadraoSeNenhumForConfigurado()
  {
    $this->assertType('ComponenteCurricular_Model_AnoEscolarDataMapper',
      $this->_mapper->getAnoEscolarDataMapper());
  }

  public function testFindAreaConhecimento()
  {
    // Valores de retorno
    $returnValue = array(new AreaConhecimento_Model_Area(array('id' => 1, 'nome' => 'Cincias exatas')));

    // Mock para rea de conhecimento
    $mock = $this->getCleanMock('AreaConhecimento_Model_AreaDataMapper');
    $mock->expects($this->once())
         ->method('findAll')
         ->will($this->returnValue($returnValue));

    // Substitui o data mapper padro pelo mock
    $this->_mapper->setAreaDataMapper($mock);
    $areas = $this->_mapper->findAreaConhecimento();

    $this->assertEquals($returnValue, $areas);
  }

  public function testFindComponenteCurricularAnoEscolar()
  {
    // Valores de retorno
    $returnValue = new ComponenteCurricular_Model_Componente(
      array('id' => 1, 'nome' => 'Cincias exatas', 'cargaHoraria' => 100)
    );

    $returnAnoEscolar = new ComponenteCurricular_Model_AnoEscolar(array(
      'componenteCurricular' => 1, 'anoEscolar' => 1, 'cargaHoraria' => 100
    ));

    // Mock para Ano Escolar
    $mock = $this->getCleanMock('ComponenteCurricular_Model_AnoEscolarDataMapper');
    $mock->expects($this->once())
         ->method('find')
         ->with(array(1, 1))
         ->will($this->returnValue($returnAnoEscolar));

    // Mock para Componente, exclui um mtodo de ser mocked
    $mapper = $this->setExcludedMethods(array('findComponenteCurricularAnoEscolar'))
                   ->getCleanMock('ComponenteCurricular_Model_ComponenteDataMapper');

    // O mtodo find do mapper ser chamado uma vez
    $mapper->expects($this->once())
           ->method('find')
           ->with(1)
           ->will($this->returnValue($returnValue));

    // Como um mock no mantm estado, fora o retorno do mapper AnoEscolarDataMapper mocked
    $mapper->expects($this->once())
           ->method('getAnoEscolarDataMapper')
           ->will($this->returnValue($mock));

    // Chama o mtodo
    $componenteCurricular = $mapper->findComponenteCurricularAnoEscolar(1, 1);

    $this->assertEquals($returnValue, $componenteCurricular);
  }
}