<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Docente
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.2.0
 * @version     $Id$
 */

require_once 'CoreExt/Entity.php';

/**
 * Docente_Model_Licenciatura class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Docente
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.2.0
 * @version     @@package_version@@
 */
class Docente_Model_Licenciatura extends CoreExt_Entity
{
  protected $_data = array(
    'servidor'     => NULL,
    'licenciatura' => NULL,
    'curso'        => NULL,
    'anoConclusao' => NULL,
    'ies'          => NULL,
    'user'         => NULL,
    'created_at'   => NULL,
    'updated_at'   => NULL
  );

  protected $_references = array(
    'licenciatura' => array(
      'value' => NULL,
      'class' => 'App_Model_SimNao',
      'file'  => 'App/Model/SimNao.php'
    ),
    'ies' => array(
      'value' => NULL,
      'class' => 'Educacenso_Model_IesDataMapper',
      'file'  => 'Educacenso/Model/IesDataMapper.php'
    ),
    'curso' => array(
      'value' => NULL,
      'class' => 'Educacenso_Model_CursoSuperiorDataMapper',
      'file'  => 'Educacenso/Model/CursoSuperiorDataMapper.php'
    )
  );

  public function getDefaultValidatorCollection()
  {
    return array();
  }
}