<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Docente
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.2.0
 * @version     $Id$
 */

require_once 'CoreExt/DataMapper.php';
require_once 'Docente/Model/Licenciatura.php';

/**
 * Docente_Model_LicenciaturaDataMapper class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     Docente
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.2.0
 * @version     @@package_version@@
 */
class Docente_Model_LicenciaturaDataMapper extends CoreExt_DataMapper
{
  protected $_entityClass = 'Docente_Model_Licenciatura';
  protected $_tableName   = 'docente_licenciatura';
  protected $_tableSchema = 'modules';

  protected $_attributeMap = array(
    'servidor'     => 'servidor_id',
    'licenciatura' => 'licenciatura',
    'curso'        => 'curso_id',
    'anoConclusao' => 'ano_conclusao',
    'ies'          => 'ies_id',
    'user'         => 'user_id',
    'created_at'   => 'created_at',
    'updated_at'   => 'updated_at'
  );
}