<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     FormulaMedia
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Validate/Abstract.php';
require_once 'FormulaMedia/Model/Formula.php';

/**
 * FormulaMedia_Validate_Formula class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     FormulaMedia
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class FormulaMedia_Validate_Formula extends CoreExt_Validate_Abstract
{
  /**
   * Referncia para instncia da classe FormulaMedia_Model_Formula do model.
   * @var FormulaMedia_Model_Formula
   */
  protected static $_model = NULL;

  /**
   * Por padro, exclui o tokens de nota de recuperao.
   *
   * @see CoreExt_Validate_Abstract#_getDefaultOptions()
   */
  protected function _getDefaultOptions()
  {
    return array('excludeToken' => array('Rc'));
  }

  /**
   * @see CoreExt_Validate_Abstract#_validate()
   * @throws Exception|FormulaMedia_Validate_Exception
   */
  protected function _validate($value)
  {
    // Instancia
    if (is_null(self::$_model)) {
      self::$_model = new FormulaMedia_Model_Formula();
    }

    // Adiciona espaos entre os parnteses
    $value = self::$_model->replaceAliasTokens($value);

    $tokensAvailable = $this->_getTokens();
    $valueTokens     = explode(' ', $value);
    $missingTokens   = array();
    $numericTokens   = array();

    // Verifica se alguma token no permitida foi utilizada
    foreach ($valueTokens as $tk) {
      if ('' == ($tk = trim($tk))) {
        continue;
      }

      if (!in_array($tk, $tokensAvailable)) {
        if (!is_numeric($tk)) {
          $missingTokens[] = $tk;
        }
      }
      elseif (self::$_model->isNumericToken($tk)) {
        // Se for uma token numrica, atribui um nmero 1 para usar na frmula
        // e avaliar se no lana um erro no PHP
        $numericTokens[$tk] = 1;
      }
    }

    if (0 < count($missingTokens)) {
      throw new Exception('As variveis ou smbolos no so permitidos: ' . implode(', ', $missingTokens));
    }

    // Verifica se a frmula  parseada corretamente pelo PHP
    $formula = self::$_model->replaceTokens($value, $numericTokens);

    /*
     * Eval, com surpresso de erro para evitar interrupo do script. Se
     * retornar algum valor diferente de NULL, assume como erro de sintaxe.
     */
    $evaled = @eval('?><?php $result = ' . $formula . '; ?>');
    if (!is_null($evaled)) {
      require_once 'FormulaMedia/Validate/Exception.php';
      throw new FormulaMedia_Validate_Exception('A frmula apresenta erros.'
                . ' Verifique algum parntese faltante ou um sinal de operao'
                . ' matemtica sem um operando.');
    }

    return TRUE;
  }

  /**
   * Retorna as tokens disponveis para o validador. Uma token pode ser
   * excluda usando a opo excludeToken.
   *
   * @return array
   */
  protected function _getTokens()
  {
    $tokens = self::$_model->getTokens();
    $tokensAvailable = array();

    if ($this->_hasOption('excludeToken') &&
        is_array($this->getOption('excludeToken')) &&
        0 < count($this->getOption('excludeToken'))
    ) {
      $excludeToken = $this->getOption('excludeToken');
      foreach ($tokens as $token) {
        if (!in_array($token, $excludeToken)) {
          $tokensAvailable[] = $token;
        }
      }
    }
    else {
      $tokensAvailable = $tokens;
    }

    return $tokensAvailable;
  }
}