<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     FormulaMedia
 * @subpackage  UnitTests
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id: /ieducar/branches/1.1.0-avaliacao/ieducar/modules/AreaConhecimento/_tests/AreaTest.php 862 2009-12-04T18:55:17.468486Z eriksen  $
 */

require_once 'FormulaMedia/Model/Formula.php';
require_once 'include/pmieducar/clsPmieducarInstituicao.inc.php';

/**
 * FormulaTest class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     FormulaMedia
 * @subpackage  UnitTests
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class FormulaTest extends UnitBaseTest
{
  protected $_entity = NULL;

  protected $_values = array(
      'E1' => 5,
      'E2' => 5,
      'E3' => 5,
      'E4' => 5,
      'Et' => 4,
      'Se' => 20,
      'Rc' => 0
    );

  protected function setUp()
  {
    $this->_entity = new FormulaMedia_Model_Formula();
  }

  public function testSubstituiCorretamenteAsTokens()
  {
    $formula = $this->_entity->replaceTokens('Se / Et', $this->_values);
    $this->assertEquals('20 / 4', $formula);
  }

  public function testFormulaDeMediaRetornaValorNumerico()
  {
    $this->_entity->formulaMedia = '(E1 + E2 + E3 + E4) / Et';
    $this->assertEquals(5, $this->_entity->execFormulaMedia($this->_values));
  }

  public function testFormulaDeRecuperacaoRetornaValorNumerico()
  {
    $this->_entity->formulaMedia = '((Se / Et * 0.6) + (Rc * 0.4))';
    $values = $this->_values;
    $values['Rc'] = 7;
    $nota = $this->_entity->execFormulaMedia($values);
    $this->assertEquals(5.8, $nota, '', 0.3);
  }

  public function testEntityValidators()
  {
    // Valores de retorno
    $returnValue = array(array('cod_instituicao' => 1, 'nm_instituicao' => 'Instituio'));

    // Mock para instituio
    $mock = $this->getCleanMock('clsPmieducarInstituicao');
    $mock->expects($this->any())
         ->method('lista')
         ->will($this->returnValue($returnValue));

    $this->_entity->addClassToStorage('clsPmieducarInstituicao', $mock);

    $validators = $this->_entity->getDefaultValidatorCollection();
    $this->assertType('CoreExt_Validate_Choice', $validators['instituicao']);
    $this->assertType('CoreExt_Validate_String', $validators['nome']);
    $this->assertType('FormulaMedia_Validate_Formula', $validators['formulaMedia']);
    $this->assertType('CoreExt_Validate_Choice', $validators['tipoFormula']);

    // Se o tipo da frmula for de mdia final, o validador ir lanar uma
    // exceo com a token Rc (Recuperao)
    try {
      $validators['formulaMedia']->isValid('Se + Rc / 4');
      $this->fail('Frmula deveria ter lanado exceo (Se + Rc / 4) pois o '
                  . 'validador est com a configurao padro');
    }
    catch (Exception $e) {
    }

    // Configura a instncia de FormulaMedia_Model_Formula para ser do tipo
    // "mdia recuperao", para verificar o validador.
    // Referncias podem ter seus valores atribudos apenas na instanciao
    // sendo assim imutveis. Por isso, um novo objeto.
    $this->_entity = new FormulaMedia_Model_Formula(array('tipoFormula' => 2));
    $validators = $this->_entity->getDefaultValidatorCollection();

    try {
      $validators['formulaMedia']->isValid('Se + Rc / 4');
    }
    catch (Exception $e) {
      $this->fail('Frmula no deveria ter lanado exceo.');
    }
  }
}