<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     RegraAvaliacao
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Enum.php';

/**
 * RegraAvaliacao_Model_TipoParecerDescritivo class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     RegraAvaliacao
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class RegraAvaliacao_Model_TipoParecerDescritivo extends CoreExt_Enum
{
  const NENHUM           = 0;
  const ETAPA_DESCRITOR  = 1;
  const ETAPA_COMPONENTE = 2;
  const ETAPA_GERAL      = 3;
  const ANUAL_DESCRITOR  = 4;
  const ANUAL_COMPONENTE = 5;
  const ANUAL_GERAL      = 6;

  protected $_data = array(
    self::NENHUM           => 'No usar parecer descritivo',
    self::ETAPA_COMPONENTE => 'Um parecer por etapa e por componente curricular',
    self::ETAPA_GERAL      => 'Um parecer por etapa, geral',
    self::ANUAL_COMPONENTE => 'Uma parecer por ano letivo e por componente curricular',
    self::ANUAL_GERAL      => 'Um parecer por ano letivo, geral',
  );

  public static function getInstance()
  {
    return self::_getInstance(__CLASS__);
  }
}