<?php

/**
 * i-Educar - Sistema de gesto escolar
 *
 * Copyright (C) 2006  Prefeitura Municipal de Itaja
 *                     <ctima@itajai.sc.gov.br>
 *
 * Este programa  software livre; voc pode redistribu-lo e/ou modific-lo
 * sob os termos da Licena Pblica Geral GNU conforme publicada pela Free
 * Software Foundation; tanto a verso 2 da Licena, como (a seu critrio)
 * qualquer verso posterior.
 *
 * Este programa  distribudo na expectativa de que seja til, porm, SEM
 * NENHUMA GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU
 * ADEQUAO A UMA FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral
 * do GNU para mais detalhes.
 *
 * Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto
 * com este programa; se no, escreva para a Free Software Foundation, Inc., no
 * endereo 59 Temple Street, Suite 330, Boston, MA 02111-1307 USA.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     RegraAvaliacao
 * @subpackage  Modules
 * @since       Arquivo disponvel desde a verso 1.1.0
 * @version     $Id$
 */

require_once 'CoreExt/Enum.php';

/**
 * RegraAvaliacao_Model_TipoProgressao class.
 *
 * @author      Eriksen Costa Paixo <eriksen.paixao_bs@cobra.com.br>
 * @category    i-Educar
 * @license     @@license@@
 * @package     RegraAvaliacao
 * @subpackage  Modules
 * @since       Classe disponvel desde a verso 1.1.0
 * @version     @@package_version@@
 */
class RegraAvaliacao_Model_TipoProgressao extends CoreExt_Enum
{
  const CONTINUADA = 1;
  const NAO_CONTINUADA_AUTO_MEDIA_PRESENCA = 2;
  const NAO_CONTINUADA_AUTO_SOMENTE_MEDIA = 3;
  const NAO_CONTINUADA_MANUAL = 4;

  protected $_data = array(
    self::CONTINUADA => 'Continuada',
    self::NAO_CONTINUADA_AUTO_MEDIA_PRESENCA => 'No-continuada automtica: mdia e presena',
    self::NAO_CONTINUADA_AUTO_SOMENTE_MEDIA => 'No-continuada automtica: somente mdia',
    self::NAO_CONTINUADA_MANUAL => 'No-continuada manual'
  );

  public static function getInstance()
  {
    return self::_getInstance(__CLASS__);
  }
}